/* Wallpaper.c generated by valac 0.56.17, the Vala compiler
 * generated from Wallpaper.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 */

#include "desktop.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_WALLPAPER_0_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_wallpaper_properties[PANTHEON_SHELL_WALLPAPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _pantheon_shell_thumbnail_generator_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantheonShellWallpaperLoadWallpapersData PantheonShellWallpaperLoadWallpapersData;
#define __vala_GdkFileList_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkFileList_free (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _PantheonShellWallpaperPrivate {
	GtkScrolledWindow* wallpaper_scrolled_window;
	GtkFlowBox* wallpaper_view;
	GtkOverlay* view_overlay;
	GtkComboBoxText* combo;
	GtkColorButton* color_button;
	PantheonShellWallpaperContainer* active_wallpaper;
	PantheonShellSolidColorContainer* solid_color;
	PantheonShellWallpaperContainer* wallpaper_for_removal;
	GCancellable* last_cancellable;
	gchar* current_wallpaper_path;
	gboolean prevent_update_mode;
	gboolean finished;
};

struct _Block4Data {
	int _ref_count_;
	PantheonShellWallpaper* self;
	GtkFileDialog* file_dialog;
};

struct _PantheonShellWallpaperLoadWallpapersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonShellWallpaper* self;
	gchar* basefolder;
	GCancellable* cancellable;
	gboolean toplevel_folder;
	GFile* directory;
	GFile* _tmp0_;
	gchar* attrs;
	gchar* _tmp1_;
	GFileEnumerator* e;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileInfo* file_info;
	GFileInfo* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	PantheonShellThumbnailGenerator* _tmp10_;
	PantheonShellThumbnailGenerator* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	GFileInfo* _tmp17_;
	GFile* subdir;
	GFile* _tmp18_;
	GFileInfo* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFileInfo* _tmp25_;
	GFile* file;
	GFile* _tmp26_;
	GFileInfo* _tmp27_;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	gchar* uri;
	GFile* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	GtkColorButton* _tmp34_;
	GdkRGBA _tmp35_;
	GdkRGBA _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GtkFlowBox* _tmp39_;
	PantheonShellSolidColorContainer* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	GtkFlowBox* _tmp45_;
	PantheonShellSolidColorContainer* _tmp46_;
	PantheonShellSolidColorContainer* _tmp47_;
	PantheonShellSolidColorContainer* _tmp48_;
	PantheonShellWallpaperContainer* _tmp49_;
	PantheonShellWallpaperContainer* _tmp50_;
	GtkAllocation alloc;
	PantheonShellWallpaperContainer* _tmp51_;
	GtkAllocation _tmp52_;
	GtkScrolledWindow* _tmp53_;
	GtkAdjustment* _tmp54_;
	GtkAllocation _tmp55_;
	GError* err;
	GError* _tmp56_;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	PantheonShellWallpaper* self;
	PantheonShellWallpaperContainer* wallpaper;
};

static gint PantheonShellWallpaper_private_offset;
static gpointer pantheon_shell_wallpaper_parent_class = NULL;
static GSettings* pantheon_shell_wallpaper_gnome_background_settings;
static GSettings* pantheon_shell_wallpaper_gnome_background_settings = NULL;

static void pantheon_shell_wallpaper_show_wallpaper_chooser (PantheonShellWallpaper* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda10_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void pantheon_shell_wallpaper_add_wallpaper_from_file (PantheonShellWallpaper* self,
                                                       GFile* file,
                                                       const gchar* uri);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pantheon_shell_wallpaper_load_settings (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_update_accountsservice (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_update_checked_wallpaper (PantheonShellWallpaper* self,
                                                        GtkFlowBox* box,
                                                        GtkFlowBoxChild* child);
static void pantheon_shell_wallpaper_set_combo_disabled_if_necessary (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_update_color (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_create_solid_color_container (PantheonShellWallpaper* self,
                                                            const gchar* color);
static void pantheon_shell_wallpaper_update_mode (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_clean_wallpapers (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_load_wallpapers (PantheonShellWallpaper* self,
                                               const gchar* basefolder,
                                               GCancellable* cancellable,
                                               gboolean toplevel_folder,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void pantheon_shell_wallpaper_load_wallpapers_finish (PantheonShellWallpaper* self,
                                                      GAsyncResult* _res_);
static void pantheon_shell_wallpaper_load_wallpapers_data_free (gpointer _data);
static gboolean pantheon_shell_wallpaper_load_wallpapers_co (PantheonShellWallpaperLoadWallpapersData* _data_);
static void pantheon_shell_wallpaper_load_wallpapers_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gboolean pantheon_shell_wallpaper_on_drag_data_received (PantheonShellWallpaper* self,
                                                         GValue* val,
                                                         gdouble x,
                                                         gdouble y);
static GdkFileList* _vala_GdkFileList_copy (GdkFileList* self);
static void _vala_GdkFileList_free (GdkFileList* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda11_ (Block5Data* _data5_);
static void pantheon_shell_wallpaper_send_undo_toast (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_mark_for_removal (PantheonShellWallpaper* self,
                                                PantheonShellWallpaperContainer* wallpaper);
static void ____lambda11__pantheon_shell_wallpaper_container_trash (PantheonShellWallpaperContainer* _sender,
                                                             gpointer self);
static gint pantheon_shell_wallpaper_wallpapers_sort_function (PantheonShellWallpaper* self,
                                                        GtkFlowBoxChild* _child1,
                                                        GtkFlowBoxChild* _child2);
VALA_EXTERN gchar** pantheon_shell_wallpaper_operation_get_system_bg_directories (gint* result_length1);
static void __lambda12_ (PantheonShellWallpaper* self);
static void pantheon_shell_wallpaper_undo_removal (PantheonShellWallpaper* self);
static void ___lambda12__granite_toast_default_action (GraniteToast* _sender,
                                                gpointer self);
static void _pantheon_shell_wallpaper_confirm_removal_granite_toast_dismissed (GraniteToast* _sender,
                                                                        GraniteToastDismissReason reason,
                                                                        gpointer self);
static GObject * pantheon_shell_wallpaper_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                      GtkFlowBoxChild* child,
                                                                                      gpointer self);
static gint _pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                                GtkFlowBoxChild* child2,
                                                                                gpointer self);
static void _pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self);
static void _pantheon_shell_wallpaper_update_color_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                        gpointer self);
static void _pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static gboolean _pantheon_shell_wallpaper_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                               GValue* value,
                                                                               gdouble x,
                                                                               gdouble y,
                                                                               gpointer self);
static void pantheon_shell_wallpaper_finalize (GObject * obj);
static GType pantheon_shell_wallpaper_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS[8] = {G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID};

static inline gpointer
pantheon_shell_wallpaper_get_instance_private (PantheonShellWallpaper* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellWallpaper_private_offset);
}

static GType
pantheon_shell_wallpaper_column_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_ICON, "PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_ICON", "icon"}, {PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_NAME, "PANTHEON_SHELL_WALLPAPER_COLUMN_TYPE_NAME", "name"}, {0, NULL, NULL}};
	GType pantheon_shell_wallpaper_column_type_type_id;
	pantheon_shell_wallpaper_column_type_type_id = g_enum_register_static ("PantheonShellWallpaperColumnType", values);
	return pantheon_shell_wallpaper_column_type_type_id;
}

GType
pantheon_shell_wallpaper_column_type_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_column_type_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_column_type_type_id__once)) {
		GType pantheon_shell_wallpaper_column_type_type_id;
		pantheon_shell_wallpaper_column_type_type_id = pantheon_shell_wallpaper_column_type_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_column_type_type_id__once, pantheon_shell_wallpaper_column_type_type_id);
	}
	return pantheon_shell_wallpaper_column_type_type_id__once;
}

PantheonShellWallpaper*
pantheon_shell_wallpaper_construct (GType object_type)
{
	PantheonShellWallpaper * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-wallpaper");
	_tmp1_ = _tmp0_;
	self = (PantheonShellWallpaper*) g_object_new (object_type, "title", _ ("Wallpaper"), "icon", _tmp1_, "show-end-title-buttons", TRUE, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PantheonShellWallpaper*
pantheon_shell_wallpaper_new (void)
{
	return pantheon_shell_wallpaper_construct (PANTHEON_SHELL_TYPE_WALLPAPER);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PantheonShellWallpaper* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->file_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda10_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	PantheonShellWallpaper* self;
	GListModel* list_model = NULL;
	GListModel* _tmp0_;
	GListModel* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = gtk_file_dialog_open_multiple_finish (_data4_->file_dialog, res, &_inner_error0_);
	list_model = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp1_ = list_model;
	if (_tmp1_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GListModel* _tmp4_;
					GFile* file = NULL;
					GListModel* _tmp5_;
					GObject* _tmp6_;
					GFile* _tmp7_;
					gchar* local_uri = NULL;
					GFile* _tmp8_;
					gchar* _tmp9_;
					GFile* dest = NULL;
					GFile* _tmp10_;
					GFile* _tmp11_;
					GFile* _tmp12_;
					GFile* _tmp15_;
					const gchar* _tmp16_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = list_model;
					if (!(((guint) i) <= g_list_model_get_n_items (_tmp4_))) {
						break;
					}
					_tmp5_ = list_model;
					_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
					file = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_file_get_type (), GFile);
					_tmp7_ = file;
					if (pantheon_shell_wallpaper_operation_get_is_file_in_bg_dir (_tmp7_)) {
						_g_object_unref0 (file);
						continue;
					}
					_tmp8_ = file;
					_tmp9_ = g_file_get_uri (_tmp8_);
					local_uri = _tmp9_;
					_tmp10_ = file;
					_tmp11_ = pantheon_shell_wallpaper_operation_copy_for_library (_tmp10_);
					dest = _tmp11_;
					_tmp12_ = dest;
					if (_tmp12_ != NULL) {
						GFile* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = dest;
						_tmp14_ = g_file_get_uri (_tmp13_);
						_g_free0 (local_uri);
						local_uri = _tmp14_;
					}
					_tmp15_ = file;
					_tmp16_ = local_uri;
					pantheon_shell_wallpaper_add_wallpaper_from_file (self, _tmp15_, _tmp16_);
					_g_object_unref0 (dest);
					_g_free0 (local_uri);
					_g_object_unref0 (file);
				}
			}
		}
	}
	_g_object_unref0 (list_model);
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self, source_object, res);
	block4_data_unref (self);
}

static void
pantheon_shell_wallpaper_show_wallpaper_chooser (PantheonShellWallpaper* self)
{
	Block4Data* _data4_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	gchar* _tmp1_;
	GtkFileFilter* _tmp2_;
	gchar* _tmp3_;
	GtkFileDialog* _tmp4_ = NULL;
	GtkRoot* _tmp5_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = gtk_file_filter_new ();
	filter = _tmp0_;
	gtk_file_filter_add_mime_type (filter, "image/*");
	_tmp1_ = g_strdup (_ ("Import"));
	_tmp2_ = _g_object_ref0 (filter);
	_tmp3_ = g_strdup (_ ("Import Photos"));
	_tmp4_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_accept_label (_tmp4_, _tmp1_);
	_g_free0 (_tmp1_);
	gtk_file_dialog_set_default_filter (_tmp4_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_file_dialog_set_modal (_tmp4_, TRUE);
	gtk_file_dialog_set_title (_tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	_data4_->file_dialog = _tmp4_;
	_tmp5_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_file_dialog_open_multiple (_data4_->file_dialog, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow), NULL, ___lambda10__gasync_ready_callback, block4_data_ref (_data4_));
	_g_object_unref0 (filter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
pantheon_shell_wallpaper_load_settings (PantheonShellWallpaper* self)
{
	gchar* picture_options = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkComboBoxText* _tmp5_;
	const gchar* _tmp6_;
	GSettings* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_wallpaper_gnome_background_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-options");
	picture_options = _tmp1_;
	_tmp2_ = picture_options;
	if (g_strcmp0 (_tmp2_, "none") == 0) {
		GtkComboBoxText* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = g_strdup ("zoom");
		_g_free0 (picture_options);
		picture_options = _tmp4_;
	}
	self->priv->prevent_update_mode = TRUE;
	_tmp5_ = self->priv->combo;
	_tmp6_ = picture_options;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp5_, _tmp6_);
	_tmp7_ = pantheon_shell_wallpaper_gnome_background_settings;
	_tmp8_ = g_settings_get_string (_tmp7_, "picture-uri");
	_g_free0 (self->priv->current_wallpaper_path);
	self->priv->current_wallpaper_path = _tmp8_;
	_g_free0 (picture_options);
}

static void
pantheon_shell_wallpaper_update_accountsservice (PantheonShellWallpaper* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* uri = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GSettings* _tmp10_;
	const gchar* _tmp11_;
	GSettings* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_wallpaper_path;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	uri = _tmp3_;
	_tmp4_ = file;
	if (!pantheon_shell_wallpaper_operation_get_is_file_in_bg_dir (_tmp4_)) {
		GFile* local_file = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = file;
		_tmp6_ = pantheon_shell_wallpaper_operation_copy_for_library (_tmp5_);
		local_file = _tmp6_;
		_tmp7_ = local_file;
		if (_tmp7_ != NULL) {
			GFile* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = local_file;
			_tmp9_ = g_file_get_uri (_tmp8_);
			_g_free0 (uri);
			uri = _tmp9_;
		}
		_g_object_unref0 (local_file);
	}
	_tmp10_ = pantheon_shell_wallpaper_gnome_background_settings;
	_tmp11_ = uri;
	g_settings_set_string (_tmp10_, "picture-uri", _tmp11_);
	_tmp12_ = pantheon_shell_wallpaper_gnome_background_settings;
	g_settings_set_string (_tmp12_, "picture-uri-dark", "");
	_g_free0 (uri);
	_g_object_unref0 (file);
}

static void
pantheon_shell_wallpaper_update_checked_wallpaper (PantheonShellWallpaper* self,
                                                   GtkFlowBox* box,
                                                   GtkFlowBoxChild* child)
{
	PantheonShellWallpaperContainer* children = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	PantheonShellWallpaperContainer* _tmp4_;
	PantheonShellWallpaperContainer* _tmp5_;
	PantheonShellWallpaperContainer* _tmp6_;
	GSettings* _tmp21_;
	PantheonShellWallpaperContainer* _tmp22_;
	gboolean _tmp23_ = FALSE;
	PantheonShellWallpaperContainer* _tmp24_;
	PantheonShellWallpaperContainer* _tmp28_;
	PantheonShellWallpaperContainer* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkFlowBoxChild*) _tmp3_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	_tmp5_ = _tmp4_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	children = _tmp5_;
	_tmp6_ = children;
	if (!PANTHEON_SHELL_IS_SOLID_COLOR_CONTAINER (_tmp6_)) {
		PantheonShellWallpaperContainer* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		PantheonShellWallpaperContainer* _tmp11_;
		PantheonShellSolidColorContainer* _tmp12_;
		_tmp7_ = children;
		_tmp8_ = pantheon_shell_wallpaper_container_get_uri (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->current_wallpaper_path);
		self->priv->current_wallpaper_path = _tmp10_;
		pantheon_shell_wallpaper_update_accountsservice (self);
		_tmp11_ = self->priv->active_wallpaper;
		_tmp12_ = self->priv->solid_color;
		if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
			GtkComboBoxText* _tmp13_;
			GSettings* _tmp14_;
			GtkComboBoxText* _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = self->priv->combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
			_tmp14_ = pantheon_shell_wallpaper_gnome_background_settings;
			_tmp15_ = self->priv->combo;
			_tmp16_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp15_);
			g_settings_set_string (_tmp14_, "picture-options", _tmp16_);
		}
	} else {
		GSettings* _tmp17_;
		PantheonShellSolidColorContainer* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		pantheon_shell_wallpaper_set_combo_disabled_if_necessary (self);
		_tmp17_ = pantheon_shell_wallpaper_gnome_background_settings;
		_tmp18_ = self->priv->solid_color;
		_tmp19_ = pantheon_shell_solid_color_container_get_color (_tmp18_);
		_tmp20_ = _tmp19_;
		g_settings_set_string (_tmp17_, "primary-color", _tmp20_);
	}
	_tmp21_ = pantheon_shell_wallpaper_gnome_background_settings;
	g_settings_reset (_tmp21_, "color-shading-type");
	_tmp22_ = children;
	pantheon_shell_wallpaper_container_set_checked (_tmp22_, TRUE);
	_tmp24_ = self->priv->active_wallpaper;
	if (_tmp24_ != NULL) {
		PantheonShellWallpaperContainer* _tmp25_;
		PantheonShellWallpaperContainer* _tmp26_;
		_tmp25_ = self->priv->active_wallpaper;
		_tmp26_ = children;
		_tmp23_ = _tmp25_ != _tmp26_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		PantheonShellWallpaperContainer* _tmp27_;
		_tmp27_ = self->priv->active_wallpaper;
		pantheon_shell_wallpaper_container_set_checked (_tmp27_, FALSE);
	}
	_tmp28_ = children;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->active_wallpaper);
	self->priv->active_wallpaper = _tmp29_;
	_g_object_unref0 (children);
}

static void
pantheon_shell_wallpaper_update_color (PantheonShellWallpaper* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->finished) {
		GtkColorButton* _tmp0_;
		GdkRGBA _tmp1_ = {0};
		GdkRGBA _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkFlowBox* _tmp5_;
		PantheonShellSolidColorContainer* _tmp6_;
		GtkFlowBox* _tmp7_;
		PantheonShellSolidColorContainer* _tmp8_;
		PantheonShellWallpaperContainer* _tmp9_;
		PantheonShellSolidColorContainer* _tmp11_;
		PantheonShellWallpaperContainer* _tmp12_;
		PantheonShellWallpaperContainer* _tmp13_;
		GSettings* _tmp14_;
		PantheonShellSolidColorContainer* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		pantheon_shell_wallpaper_set_combo_disabled_if_necessary (self);
		_tmp0_ = self->priv->color_button;
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gdk_rgba_to_string (&_tmp2_);
		_tmp4_ = _tmp3_;
		pantheon_shell_wallpaper_create_solid_color_container (self, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->wallpaper_view;
		_tmp6_ = self->priv->solid_color;
		gtk_flow_box_append (_tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->wallpaper_view;
		_tmp8_ = self->priv->solid_color;
		gtk_flow_box_select_child (_tmp7_, (GtkFlowBoxChild*) _tmp8_);
		_tmp9_ = self->priv->active_wallpaper;
		if (_tmp9_ != NULL) {
			PantheonShellWallpaperContainer* _tmp10_;
			_tmp10_ = self->priv->active_wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp10_, FALSE);
		}
		_tmp11_ = self->priv->solid_color;
		_tmp12_ = _g_object_ref0 ((PantheonShellWallpaperContainer*) _tmp11_);
		_g_object_unref0 (self->priv->active_wallpaper);
		self->priv->active_wallpaper = _tmp12_;
		_tmp13_ = self->priv->active_wallpaper;
		pantheon_shell_wallpaper_container_set_checked (_tmp13_, TRUE);
		_tmp14_ = pantheon_shell_wallpaper_gnome_background_settings;
		_tmp15_ = self->priv->solid_color;
		_tmp16_ = pantheon_shell_solid_color_container_get_color (_tmp15_);
		_tmp17_ = _tmp16_;
		g_settings_set_string (_tmp14_, "primary-color", _tmp17_);
	}
}

static void
pantheon_shell_wallpaper_update_mode (PantheonShellWallpaper* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->prevent_update_mode) {
		GSettings* _tmp0_;
		GtkComboBoxText* _tmp1_;
		const gchar* _tmp2_;
		PantheonShellWallpaperContainer* _tmp3_;
		PantheonShellSolidColorContainer* _tmp4_;
		_tmp0_ = pantheon_shell_wallpaper_gnome_background_settings;
		_tmp1_ = self->priv->combo;
		_tmp2_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp1_);
		g_settings_set_string (_tmp0_, "picture-options", _tmp2_);
		_tmp3_ = self->priv->active_wallpaper;
		_tmp4_ = self->priv->solid_color;
		if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
			PantheonShellWallpaperContainer* _tmp5_;
			GtkWidget* child = NULL;
			GtkFlowBox* _tmp6_;
			GtkWidget* _tmp7_;
			GtkWidget* _tmp8_;
			_tmp5_ = self->priv->active_wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp5_, FALSE);
			_tmp6_ = self->priv->wallpaper_view;
			_tmp7_ = gtk_widget_get_first_child ((GtkWidget*) _tmp6_);
			_tmp8_ = _g_object_ref0 (_tmp7_);
			child = _tmp8_;
			while (TRUE) {
				GtkWidget* _tmp9_;
				PantheonShellWallpaperContainer* container = NULL;
				GtkWidget* _tmp10_;
				PantheonShellWallpaperContainer* _tmp11_;
				PantheonShellWallpaperContainer* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GtkWidget* _tmp21_;
				GtkWidget* _tmp22_;
				GtkWidget* _tmp23_;
				_tmp9_ = child;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = child;
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
				container = _tmp11_;
				_tmp12_ = container;
				_tmp13_ = pantheon_shell_wallpaper_container_get_uri (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = self->priv->current_wallpaper_path;
				if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
					PantheonShellWallpaperContainer* _tmp16_;
					GtkFlowBox* _tmp17_;
					PantheonShellWallpaperContainer* _tmp18_;
					PantheonShellWallpaperContainer* _tmp19_;
					PantheonShellWallpaperContainer* _tmp20_;
					_tmp16_ = container;
					pantheon_shell_wallpaper_container_set_checked (_tmp16_, TRUE);
					_tmp17_ = self->priv->wallpaper_view;
					_tmp18_ = container;
					gtk_flow_box_select_child (_tmp17_, (GtkFlowBoxChild*) _tmp18_);
					_tmp19_ = container;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (self->priv->active_wallpaper);
					self->priv->active_wallpaper = _tmp20_;
					_g_object_unref0 (container);
					break;
				}
				_tmp21_ = child;
				_tmp22_ = gtk_widget_get_next_sibling (_tmp21_);
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (child);
				child = _tmp23_;
				_g_object_unref0 (container);
			}
			_g_object_unref0 (child);
		}
	} else {
		self->priv->prevent_update_mode = FALSE;
	}
}

static void
pantheon_shell_wallpaper_set_combo_disabled_if_necessary (PantheonShellWallpaper* self)
{
	PantheonShellWallpaperContainer* _tmp0_;
	PantheonShellSolidColorContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_wallpaper;
	_tmp1_ = self->priv->solid_color;
	if (_tmp0_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer)) {
		GtkComboBoxText* _tmp2_;
		GSettings* _tmp3_;
		_tmp2_ = self->priv->combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = pantheon_shell_wallpaper_gnome_background_settings;
		g_settings_set_string (_tmp3_, "picture-options", "none");
	}
}

void
pantheon_shell_wallpaper_update_wallpaper_folder (PantheonShellWallpaper* self)
{
	GCancellable* _tmp0_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->last_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->last_cancellable);
	self->priv->last_cancellable = _tmp4_;
	pantheon_shell_wallpaper_clean_wallpapers (self);
	_tmp6_ = pantheon_shell_wallpaper_operation_get_bg_directories (&_tmp5_);
	{
		gchar** directory_collection = NULL;
		gint directory_collection_length1 = 0;
		gint _directory_collection_size_ = 0;
		gint directory_it = 0;
		directory_collection = _tmp6_;
		directory_collection_length1 = _tmp5_;
		for (directory_it = 0; directory_it < directory_collection_length1; directory_it = directory_it + 1) {
			const gchar* directory = NULL;
			directory = directory_collection[directory_it];
			{
				const gchar* _tmp7_;
				GCancellable* _tmp8_;
				_tmp7_ = directory;
				_tmp8_ = cancellable;
				pantheon_shell_wallpaper_load_wallpapers (self, _tmp7_, _tmp8_, TRUE, NULL, NULL);
			}
		}
		directory_collection = (_vala_array_free (directory_collection, directory_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (cancellable);
}

static void
pantheon_shell_wallpaper_load_wallpapers_data_free (gpointer _data)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = _data;
	_g_free0 (_data_->basefolder);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonShellWallpaperLoadWallpapersData, _data_);
}

static void
pantheon_shell_wallpaper_load_wallpapers (PantheonShellWallpaper* self,
                                          const gchar* basefolder,
                                          GCancellable* cancellable,
                                          gboolean toplevel_folder,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	PantheonShellWallpaper* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (basefolder != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (PantheonShellWallpaperLoadWallpapersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_shell_wallpaper_load_wallpapers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (basefolder);
	_g_free0 (_data_->basefolder);
	_data_->basefolder = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_data_->toplevel_folder = toplevel_folder;
	pantheon_shell_wallpaper_load_wallpapers_co (_data_);
}

static void
pantheon_shell_wallpaper_load_wallpapers_finish (PantheonShellWallpaper* self,
                                                 GAsyncResult* _res_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
pantheon_shell_wallpaper_load_wallpapers_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	PantheonShellWallpaperLoadWallpapersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pantheon_shell_wallpaper_load_wallpapers_co (_data_);
}

static gboolean
pantheon_shell_wallpaper_load_wallpapers_co (PantheonShellWallpaperLoadWallpapersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = g_file_new_for_path (_data_->basefolder);
	_data_->directory = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _vala_g_strjoinv (",", PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS, (gint) G_N_ELEMENTS (PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS));
		_data_->attrs = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->directory;
		_data_->_tmp3_ = _data_->attrs;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp2_, _data_->_tmp3_, 0, G_PRIORITY_DEFAULT, NULL, pantheon_shell_wallpaper_load_wallpapers_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->e = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->attrs);
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = g_file_enumerator_next_file (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->file_info);
				_g_object_unref0 (_data_->e);
				_g_free0 (_data_->attrs);
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_object_unref0 (_data_->file_info);
			_data_->file_info = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->file_info;
			if (!(_data_->_tmp9_ != NULL)) {
				_g_object_unref0 (_data_->_tmp5_);
				break;
			}
			if (g_cancellable_is_cancelled (_data_->cancellable)) {
				_data_->_tmp10_ = pantheon_shell_thumbnail_generator_get_default ();
				_data_->_tmp11_ = _data_->_tmp10_;
				pantheon_shell_thumbnail_generator_dequeue_all (_data_->_tmp11_);
				_pantheon_shell_thumbnail_generator_unref0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->_tmp5_);
				_g_object_unref0 (_data_->file_info);
				_g_object_unref0 (_data_->e);
				_g_free0 (_data_->attrs);
				_g_object_unref0 (_data_->directory);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp14_ = _data_->file_info;
			if (g_file_info_get_is_hidden (_data_->_tmp14_)) {
				_data_->_tmp13_ = TRUE;
			} else {
				_data_->_tmp15_ = _data_->file_info;
				_data_->_tmp13_ = g_file_info_get_is_backup (_data_->_tmp15_);
			}
			if (_data_->_tmp13_) {
				_data_->_tmp12_ = TRUE;
			} else {
				_data_->_tmp16_ = _data_->file_info;
				_data_->_tmp12_ = g_file_info_get_is_symlink (_data_->_tmp16_);
			}
			if (_data_->_tmp12_) {
				_g_object_unref0 (_data_->_tmp5_);
				continue;
			}
			_data_->_tmp17_ = _data_->file_info;
			if (g_file_info_get_file_type (_data_->_tmp17_) == G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp18_ = _data_->directory;
				_data_->_tmp19_ = _data_->file_info;
				_data_->_tmp20_ = g_file_info_get_name (_data_->_tmp19_);
				_data_->_tmp21_ = g_file_resolve_relative_path (_data_->_tmp18_, _data_->_tmp20_);
				_data_->subdir = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->subdir;
				_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_state_ = 2;
				pantheon_shell_wallpaper_load_wallpapers (_data_->self, _data_->_tmp24_, _data_->cancellable, FALSE, pantheon_shell_wallpaper_load_wallpapers_ready, _data_);
				return FALSE;
				_state_2:
				pantheon_shell_wallpaper_load_wallpapers_finish (_data_->self, _data_->_res_);
				_g_free0 (_data_->_tmp24_);
				_g_object_unref0 (_data_->subdir);
				_g_object_unref0 (_data_->_tmp5_);
				continue;
			} else {
				_data_->_tmp25_ = _data_->file_info;
				if (!pantheon_shell_io_helper_is_valid_file_type (_data_->_tmp25_)) {
					_g_object_unref0 (_data_->_tmp5_);
					continue;
				}
			}
			_data_->_tmp26_ = _data_->directory;
			_data_->_tmp27_ = _data_->file_info;
			_data_->_tmp28_ = g_file_info_get_name (_data_->_tmp27_);
			_data_->_tmp29_ = g_file_resolve_relative_path (_data_->_tmp26_, _data_->_tmp28_);
			_data_->file = _data_->_tmp29_;
			_data_->_tmp30_ = _data_->file;
			_data_->_tmp31_ = g_file_get_uri (_data_->_tmp30_);
			_data_->uri = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->file;
			_data_->_tmp33_ = _data_->uri;
			pantheon_shell_wallpaper_add_wallpaper_from_file (_data_->self, _data_->_tmp32_, _data_->_tmp33_);
			_g_free0 (_data_->uri);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->_tmp5_);
		}
		if (_data_->toplevel_folder) {
			_data_->_tmp34_ = _data_->self->priv->color_button;
			memset (&_data_->_tmp35_, 0, sizeof (GdkRGBA));
			gtk_color_chooser_get_rgba ((GtkColorChooser*) _data_->_tmp34_, &_data_->_tmp35_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = gdk_rgba_to_string (&_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			pantheon_shell_wallpaper_create_solid_color_container (_data_->self, _data_->_tmp38_);
			_g_free0 (_data_->_tmp38_);
			_data_->_tmp39_ = _data_->self->priv->wallpaper_view;
			_data_->_tmp40_ = _data_->self->priv->solid_color;
			gtk_flow_box_append (_data_->_tmp39_, (GtkWidget*) _data_->_tmp40_);
			_data_->self->priv->finished = TRUE;
			_data_->_tmp41_ = pantheon_shell_wallpaper_gnome_background_settings;
			_data_->_tmp42_ = g_settings_get_string (_data_->_tmp41_, "picture-options");
			_data_->_tmp43_ = _data_->_tmp42_;
			_data_->_tmp44_ = g_strcmp0 (_data_->_tmp43_, "none") == 0;
			_g_free0 (_data_->_tmp43_);
			if (_data_->_tmp44_) {
				_data_->_tmp45_ = _data_->self->priv->wallpaper_view;
				_data_->_tmp46_ = _data_->self->priv->solid_color;
				gtk_flow_box_select_child (_data_->_tmp45_, (GtkFlowBoxChild*) _data_->_tmp46_);
				_data_->_tmp47_ = _data_->self->priv->solid_color;
				pantheon_shell_wallpaper_container_set_checked ((PantheonShellWallpaperContainer*) _data_->_tmp47_, TRUE);
				_data_->_tmp48_ = _data_->self->priv->solid_color;
				_data_->_tmp49_ = _g_object_ref0 ((PantheonShellWallpaperContainer*) _data_->_tmp48_);
				_g_object_unref0 (_data_->self->priv->active_wallpaper);
				_data_->self->priv->active_wallpaper = _data_->_tmp49_;
			}
			_data_->_tmp50_ = _data_->self->priv->active_wallpaper;
			if (_data_->_tmp50_ != NULL) {
				_data_->_tmp51_ = _data_->self->priv->active_wallpaper;
				memset (&_data_->_tmp52_, 0, sizeof (GtkAllocation));
				gtk_widget_get_allocation ((GtkWidget*) _data_->_tmp51_, &_data_->_tmp52_);
				_data_->alloc = _data_->_tmp52_;
				_data_->_tmp53_ = _data_->self->priv->wallpaper_scrolled_window;
				_data_->_tmp54_ = gtk_scrolled_window_get_vadjustment (_data_->_tmp53_);
				_data_->_tmp55_ = _data_->alloc;
				gtk_adjustment_set_value (_data_->_tmp54_, (gdouble) _data_->_tmp55_.y);
			}
		}
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->e);
		_g_free0 (_data_->attrs);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp56_ = _data_->err;
		if (!g_error_matches (_data_->_tmp56_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp57_ = _data_->err;
			_data_->_tmp58_ = _data_->_tmp57_->message;
			g_warning ("Wallpaper.vala:344: %s", _data_->_tmp58_);
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pantheon_shell_wallpaper_create_solid_color_container (PantheonShellWallpaper* self,
                                                       const gchar* color)
{
	PantheonShellSolidColorContainer* _tmp0_;
	PantheonShellSolidColorContainer* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = self->priv->solid_color;
	if (_tmp0_ != NULL) {
		GtkFlowBox* _tmp1_;
		PantheonShellSolidColorContainer* _tmp2_;
		GtkFlowBox* _tmp3_;
		PantheonShellSolidColorContainer* _tmp4_;
		PantheonShellSolidColorContainer* _tmp5_;
		_tmp1_ = self->priv->wallpaper_view;
		_tmp2_ = self->priv->solid_color;
		gtk_flow_box_unselect_child (_tmp1_, (GtkFlowBoxChild*) _tmp2_);
		_tmp3_ = self->priv->wallpaper_view;
		_tmp4_ = self->priv->solid_color;
		gtk_flow_box_remove (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->solid_color;
		g_signal_emit_by_name ((GtkWidget*) _tmp5_, "destroy");
	}
	_tmp6_ = pantheon_shell_solid_color_container_new (color);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->solid_color);
	self->priv->solid_color = _tmp6_;
}

static void
pantheon_shell_wallpaper_clean_wallpapers (PantheonShellWallpaper* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GtkFlowBox* _tmp0_;
		GtkWidget* _tmp1_;
		GtkFlowBox* _tmp2_;
		GtkFlowBox* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp0_ = self->priv->wallpaper_view;
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = self->priv->wallpaper_view;
		_tmp3_ = self->priv->wallpaper_view;
		_tmp4_ = gtk_widget_get_first_child ((GtkWidget*) _tmp3_);
		gtk_flow_box_remove (_tmp2_, _tmp4_);
	}
	_g_object_unref0 (self->priv->solid_color);
	self->priv->solid_color = NULL;
}

static GdkFileList*
_vala_GdkFileList_copy (GdkFileList* self)
{
	return g_boxed_copy (gdk_file_list_get_type (), self);
}

static gpointer
__vala_GdkFileList_copy0 (gpointer self)
{
	return self ? _vala_GdkFileList_copy (self) : NULL;
}

static void
_vala_GdkFileList_free (GdkFileList* self)
{
	g_boxed_free (gdk_file_list_get_type (), self);
}

static gboolean
pantheon_shell_wallpaper_on_drag_data_received (PantheonShellWallpaper* self,
                                                GValue* val,
                                                gdouble x,
                                                gdouble y)
{
	GdkFileList* file_list = NULL;
	GValue _tmp0_;
	GdkFileList* _tmp1_;
	GdkFileList* _tmp2_;
	GSList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = __vala_GdkFileList_copy0 (g_value_get_boxed (&_tmp0_));
	file_list = _tmp1_;
	_tmp2_ = file_list;
	_tmp3_ = gdk_file_list_get_files (_tmp2_);
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
		file_collection = _tmp3_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* file = NULL;
			file = (GFile*) file_it->data;
			{
				gchar* local_uri = NULL;
				GFile* _tmp4_;
				gchar* _tmp5_;
				GFile* dest = NULL;
				GFile* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp11_;
				const gchar* _tmp12_;
				_tmp4_ = file;
				_tmp5_ = g_file_get_uri (_tmp4_);
				local_uri = _tmp5_;
				_tmp6_ = file;
				_tmp7_ = pantheon_shell_wallpaper_operation_copy_for_library (_tmp6_);
				dest = _tmp7_;
				_tmp8_ = dest;
				if (_tmp8_ != NULL) {
					GFile* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = dest;
					_tmp10_ = g_file_get_uri (_tmp9_);
					_g_free0 (local_uri);
					local_uri = _tmp10_;
				}
				_tmp11_ = file;
				_tmp12_ = local_uri;
				pantheon_shell_wallpaper_add_wallpaper_from_file (self, _tmp11_, _tmp12_);
				_g_object_unref0 (dest);
				_g_free0 (local_uri);
			}
		}
		(file_collection == NULL) ? NULL : (file_collection = (g_slist_free (file_collection), NULL));
	}
	result = TRUE;
	__vala_GdkFileList_free0 (file_list);
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PantheonShellWallpaper* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->wallpaper);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda11_ (Block5Data* _data5_)
{
	PantheonShellWallpaper* self;
	PantheonShellWallpaperContainer* _tmp0_;
	self = _data5_->self;
	pantheon_shell_wallpaper_send_undo_toast (self);
	_tmp0_ = _data5_->wallpaper;
	pantheon_shell_wallpaper_mark_for_removal (self, _tmp0_);
}

static void
____lambda11__pantheon_shell_wallpaper_container_trash (PantheonShellWallpaperContainer* _sender,
                                                        gpointer self)
{
	___lambda11_ (self);
}

static void
pantheon_shell_wallpaper_add_wallpaper_from_file (PantheonShellWallpaper* self,
                                                  GFile* file,
                                                  const gchar* uri)
{
	gboolean _tmp0_ = FALSE;
	PantheonShellWallpaperContainer* _tmp1_;
	GtkFlowBox* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (uri != NULL);
	_tmp1_ = self->priv->wallpaper_for_removal;
	if (_tmp1_ != NULL) {
		PantheonShellWallpaperContainer* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->wallpaper_for_removal;
		_tmp3_ = pantheon_shell_wallpaper_container_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, uri) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		Block5Data* _data5_;
		GFileInfo* info = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		gchar* thumb_path = NULL;
		GFileInfo* _tmp9_;
		gchar* _tmp10_;
		gboolean thumb_valid = FALSE;
		GFileInfo* _tmp11_;
		const gchar* _tmp12_;
		PantheonShellWallpaperContainer* _tmp13_;
		GtkFlowBox* _tmp14_;
		PantheonShellWallpaperContainer* _tmp15_;
		PantheonShellWallpaperContainer* _tmp16_;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->self = g_object_ref (self);
		_tmp5_ = _vala_g_strjoinv (",", PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS, (gint) G_N_ELEMENTS (PANTHEON_SHELL_WALLPAPER_REQUIRED_FILE_ATTRS));
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_query_info (file, _tmp6_, 0, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		info = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block5_data_unref (_data5_);
			_data5_ = NULL;
			goto __catch0_g_error;
		}
		_tmp9_ = info;
		_tmp10_ = g_file_info_get_attribute_as_string (_tmp9_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		thumb_path = _tmp10_;
		_tmp11_ = info;
		thumb_valid = g_file_info_get_attribute_boolean (_tmp11_, G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID);
		_tmp12_ = thumb_path;
		_tmp13_ = pantheon_shell_wallpaper_container_new (uri, _tmp12_, thumb_valid);
		g_object_ref_sink (_tmp13_);
		_data5_->wallpaper = _tmp13_;
		_tmp14_ = self->priv->wallpaper_view;
		_tmp15_ = _data5_->wallpaper;
		gtk_flow_box_append (_tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = _data5_->wallpaper;
		g_signal_connect_data (_tmp16_, "trash", (GCallback) ____lambda11__pantheon_shell_wallpaper_container_trash, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_tmp18_ = self->priv->current_wallpaper_path;
		if (g_str_has_suffix (_tmp18_, uri)) {
			GSettings* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = pantheon_shell_wallpaper_gnome_background_settings;
			_tmp20_ = g_settings_get_string (_tmp19_, "picture-options");
			_tmp21_ = _tmp20_;
			_tmp17_ = g_strcmp0 (_tmp21_, "none") != 0;
			_g_free0 (_tmp21_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			GtkFlowBox* _tmp22_;
			PantheonShellWallpaperContainer* _tmp23_;
			PantheonShellWallpaperContainer* _tmp24_;
			PantheonShellWallpaperContainer* _tmp25_;
			PantheonShellWallpaperContainer* _tmp26_;
			_tmp22_ = self->priv->wallpaper_view;
			_tmp23_ = _data5_->wallpaper;
			gtk_flow_box_select_child (_tmp22_, (GtkFlowBoxChild*) _tmp23_);
			_tmp24_ = _data5_->wallpaper;
			pantheon_shell_wallpaper_container_set_checked (_tmp24_, TRUE);
			_tmp25_ = _data5_->wallpaper;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (self->priv->active_wallpaper);
			self->priv->active_wallpaper = _tmp26_;
		}
		_g_free0 (thumb_path);
		_g_object_unref0 (info);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_critical ("Wallpaper.vala:409: Unable to add wallpaper: %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp29_ = self->priv->wallpaper_view;
	gtk_flow_box_invalidate_sort (_tmp29_);
}

void
pantheon_shell_wallpaper_cancel_thumbnail_generation (PantheonShellWallpaper* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->last_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->last_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static gint
pantheon_shell_wallpaper_wallpapers_sort_function (PantheonShellWallpaper* self,
                                                   GtkFlowBoxChild* _child1,
                                                   GtkFlowBoxChild* _child2)
{
	PantheonShellWallpaperContainer* child1 = NULL;
	PantheonShellWallpaperContainer* _tmp0_;
	PantheonShellWallpaperContainer* child2 = NULL;
	PantheonShellWallpaperContainer* _tmp1_;
	gchar* uri1 = NULL;
	PantheonShellWallpaperContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* uri2 = NULL;
	PantheonShellWallpaperContainer* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean uri1_is_system = FALSE;
	gboolean uri2_is_system = FALSE;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gboolean _tmp24_ = FALSE;
	guint64 child1_date = 0ULL;
	PantheonShellWallpaperContainer* _tmp26_;
	guint64 child2_date = 0ULL;
	PantheonShellWallpaperContainer* _tmp27_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (_child1 != NULL, 0);
	g_return_val_if_fail (_child2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_child1, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	child1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_child2, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer));
	child2 = _tmp1_;
	_tmp2_ = child1;
	_tmp3_ = pantheon_shell_wallpaper_container_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	uri1 = _tmp5_;
	_tmp6_ = child2;
	_tmp7_ = pantheon_shell_wallpaper_container_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	uri2 = _tmp9_;
	_tmp11_ = uri1;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = uri2;
		_tmp10_ = _tmp12_ == NULL;
	}
	if (_tmp10_) {
		result = 0;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	uri1_is_system = FALSE;
	uri2_is_system = FALSE;
	_tmp14_ = pantheon_shell_wallpaper_operation_get_system_bg_directories (&_tmp13_);
	{
		gchar** bg_dir_collection = NULL;
		gint bg_dir_collection_length1 = 0;
		gint _bg_dir_collection_size_ = 0;
		gint bg_dir_it = 0;
		bg_dir_collection = _tmp14_;
		bg_dir_collection_length1 = _tmp13_;
		for (bg_dir_it = 0; bg_dir_it < bg_dir_collection_length1; bg_dir_it = bg_dir_it + 1) {
			gchar* _tmp15_;
			gchar* bg_dir = NULL;
			_tmp15_ = g_strdup (bg_dir_collection[bg_dir_it]);
			bg_dir = _tmp15_;
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp16_ = bg_dir;
				_tmp17_ = g_strconcat ("file://", _tmp16_, NULL);
				_g_free0 (bg_dir);
				bg_dir = _tmp17_;
				_tmp19_ = uri1;
				_tmp20_ = bg_dir;
				if (g_str_has_prefix (_tmp19_, _tmp20_)) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = uri1_is_system;
				}
				uri1_is_system = _tmp18_;
				_tmp22_ = uri2;
				_tmp23_ = bg_dir;
				if (g_str_has_prefix (_tmp22_, _tmp23_)) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = uri2_is_system;
				}
				uri2_is_system = _tmp21_;
				_g_free0 (bg_dir);
			}
		}
		bg_dir_collection = (_vala_array_free (bg_dir_collection, bg_dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (uri1_is_system) {
		_tmp24_ = !uri2_is_system;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = 1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	} else {
		gboolean _tmp25_ = FALSE;
		if (!uri1_is_system) {
			_tmp25_ = uri2_is_system;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			result = -1;
			_g_free0 (uri2);
			_g_free0 (uri1);
			_g_object_unref0 (child2);
			_g_object_unref0 (child1);
			return result;
		}
	}
	_tmp26_ = child1;
	child1_date = _tmp26_->creation_date;
	_tmp27_ = child2;
	child2_date = _tmp27_->creation_date;
	if (child1_date == child2_date) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = uri1;
		_tmp29_ = uri2;
		result = g_utf8_collate (_tmp28_, _tmp29_);
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	if (child1_date >= child2_date) {
		result = -1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	} else {
		result = 1;
		_g_free0 (uri2);
		_g_free0 (uri1);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
}

static void
__lambda12_ (PantheonShellWallpaper* self)
{
	pantheon_shell_wallpaper_undo_removal (self);
}

static void
___lambda12__granite_toast_default_action (GraniteToast* _sender,
                                           gpointer self)
{
	__lambda12_ ((PantheonShellWallpaper*) self);
}

static void
_pantheon_shell_wallpaper_confirm_removal_granite_toast_dismissed (GraniteToast* _sender,
                                                                   GraniteToastDismissReason reason,
                                                                   gpointer self)
{
	pantheon_shell_wallpaper_confirm_removal ((PantheonShellWallpaper*) self);
}

static void
pantheon_shell_wallpaper_send_undo_toast (PantheonShellWallpaper* self)
{
	GtkWidget* child = NULL;
	GtkOverlay* _tmp0_;
	GtkWidget* _tmp1_;
	PantheonShellWallpaperContainer* _tmp7_;
	GraniteToast* toast = NULL;
	GraniteToast* _tmp8_;
	GtkOverlay* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_overlay;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	child = _tmp1_;
	while (TRUE) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp2_ = child;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = child;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GRANITE_TYPE_TOAST)) {
			GtkWidget* _tmp4_;
			_tmp4_ = child;
			granite_toast_withdraw (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GRANITE_TYPE_TOAST, GraniteToast));
		}
		_tmp5_ = child;
		_tmp6_ = gtk_widget_get_next_sibling (_tmp5_);
		child = _tmp6_;
	}
	_tmp7_ = self->priv->wallpaper_for_removal;
	if (_tmp7_ != NULL) {
		pantheon_shell_wallpaper_confirm_removal (self);
	}
	_tmp8_ = granite_toast_new (_ ("Wallpaper Deleted"));
	g_object_ref_sink (_tmp8_);
	toast = _tmp8_;
	granite_toast_set_default_action (toast, _ ("Undo"));
	g_signal_connect_object (toast, "default-action", (GCallback) ___lambda12__granite_toast_default_action, self, 0);
	g_signal_connect_object (toast, "dismissed", (GCallback) _pantheon_shell_wallpaper_confirm_removal_granite_toast_dismissed, self, 0);
	_tmp9_ = self->priv->view_overlay;
	gtk_overlay_add_overlay (_tmp9_, (GtkWidget*) toast);
	granite_toast_send_notification (toast);
	_g_object_unref0 (toast);
}

static void
pantheon_shell_wallpaper_mark_for_removal (PantheonShellWallpaper* self,
                                           PantheonShellWallpaperContainer* wallpaper)
{
	GtkFlowBox* _tmp0_;
	PantheonShellWallpaperContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wallpaper != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	gtk_flow_box_remove (_tmp0_, (GtkWidget*) wallpaper);
	_tmp1_ = _g_object_ref0 (wallpaper);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = _tmp1_;
}

void
pantheon_shell_wallpaper_confirm_removal (PantheonShellWallpaper* self)
{
	PantheonShellWallpaperContainer* _tmp0_;
	GFile* wallpaper_file = NULL;
	PantheonShellWallpaperContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	PantheonShellWallpaperContainer* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wallpaper_for_removal;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->wallpaper_for_removal;
	_tmp2_ = pantheon_shell_wallpaper_container_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_uri (_tmp3_);
	wallpaper_file = _tmp4_;
	_tmp5_ = wallpaper_file;
	g_file_trash_async (_tmp5_, G_PRIORITY_DEFAULT, NULL, NULL, NULL);
	_tmp6_ = self->priv->wallpaper_for_removal;
	g_signal_emit_by_name ((GtkWidget*) _tmp6_, "destroy");
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = NULL;
	_g_object_unref0 (wallpaper_file);
}

static void
pantheon_shell_wallpaper_undo_removal (PantheonShellWallpaper* self)
{
	GtkFlowBox* _tmp0_;
	PantheonShellWallpaperContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wallpaper_view;
	_tmp1_ = self->priv->wallpaper_for_removal;
	gtk_flow_box_append (_tmp0_, (GtkWidget*) _tmp1_);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	self->priv->wallpaper_for_removal = NULL;
}

static void
_pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                 GtkFlowBoxChild* child,
                                                                                 gpointer self)
{
	pantheon_shell_wallpaper_update_checked_wallpaper ((PantheonShellWallpaper*) self, _sender, child);
}

static gint
_pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                           GtkFlowBoxChild* child2,
                                                                           gpointer self)
{
	gint result;
	result = pantheon_shell_wallpaper_wallpapers_sort_function ((PantheonShellWallpaper*) self, child1, child2);
	return result;
}

static void
_pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self)
{
	pantheon_shell_wallpaper_update_mode ((PantheonShellWallpaper*) self);
}

static void
_pantheon_shell_wallpaper_update_color_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                   gpointer self)
{
	pantheon_shell_wallpaper_update_color ((PantheonShellWallpaper*) self);
}

static void
_pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	pantheon_shell_wallpaper_show_wallpaper_chooser ((PantheonShellWallpaper*) self);
}

static gboolean
_pantheon_shell_wallpaper_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                      GValue* value,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self)
{
	gboolean result;
	result = pantheon_shell_wallpaper_on_drag_data_received ((PantheonShellWallpaper*) self, value, x, y);
	return result;
}

static GObject *
pantheon_shell_wallpaper_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellWallpaper * self;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp0_;
	GtkFlowBox* _tmp1_ = NULL;
	GtkFlowBox* _tmp2_;
	GtkFlowBox* _tmp3_;
	GtkFlowBox* _tmp4_;
	GtkFlowBox* _tmp5_;
	GtkDropTarget* _tmp6_;
	GtkEventController* _tmp7_;
	gchar* color = NULL;
	GSettings* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GtkFlowBox* _tmp11_;
	GtkWidget* _tmp12_;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkScrolledWindow* _tmp14_;
	GtkWidget* _tmp15_;
	GtkOverlay* _tmp16_ = NULL;
	GtkButton* add_wallpaper_button = NULL;
	GtkButton* _tmp17_;
	GtkComboBoxText* _tmp18_ = NULL;
	GtkComboBoxText* _tmp19_;
	GtkComboBoxText* _tmp20_;
	GtkComboBoxText* _tmp21_;
	GtkComboBoxText* _tmp22_;
	GdkRGBA rgba_color = {0};
	GdkRGBA _tmp23_ = {0};
	const gchar* _tmp24_;
	GdkRGBA _tmp26_;
	GtkColorButton* _tmp27_ = NULL;
	GtkColorButton* _tmp28_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp29_;
	GtkActionBar* _tmp30_;
	GtkActionBar* _tmp31_;
	GtkButton* _tmp32_;
	GtkActionBar* _tmp33_;
	GtkColorButton* _tmp34_;
	GtkActionBar* _tmp35_;
	GtkComboBoxText* _tmp36_;
	GtkBox* box = NULL;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkOverlay* _tmp39_;
	GtkBox* _tmp40_;
	GtkActionBar* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkButton* _tmp44_;
	GtkDropTarget* _tmp45_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_wallpaper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	_tmp0_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp0_;
	_tmp1_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_activate_on_single_click (_tmp1_, TRUE);
	gtk_flow_box_set_homogeneous (_tmp1_, TRUE);
	gtk_flow_box_set_selection_mode (_tmp1_, GTK_SELECTION_SINGLE);
	gtk_flow_box_set_min_children_per_line (_tmp1_, (guint) 3);
	gtk_flow_box_set_max_children_per_line (_tmp1_, (guint) 5);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->wallpaper_view);
	self->priv->wallpaper_view = _tmp1_;
	_tmp2_ = self->priv->wallpaper_view;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_VIEW);
	_tmp3_ = self->priv->wallpaper_view;
	g_signal_connect_object (_tmp3_, "child-activated", (GCallback) _pantheon_shell_wallpaper_update_checked_wallpaper_gtk_flow_box_child_activated, self, 0);
	_tmp4_ = self->priv->wallpaper_view;
	gtk_flow_box_set_sort_func (_tmp4_, _pantheon_shell_wallpaper_wallpapers_sort_function_gtk_flow_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->wallpaper_view;
	_tmp6_ = drop_target;
	_tmp7_ = _g_object_ref0 ((GtkEventController*) _tmp6_);
	gtk_widget_add_controller ((GtkWidget*) _tmp5_, _tmp7_);
	_tmp8_ = pantheon_shell_wallpaper_gnome_background_settings;
	_tmp9_ = g_settings_get_string (_tmp8_, "primary-color");
	color = _tmp9_;
	_tmp10_ = color;
	pantheon_shell_wallpaper_create_solid_color_container (self, _tmp10_);
	_tmp11_ = self->priv->wallpaper_view;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_set (_tmp13_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->wallpaper_scrolled_window);
	self->priv->wallpaper_scrolled_window = _tmp13_;
	_tmp14_ = self->priv->wallpaper_scrolled_window;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	_tmp16_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp16_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->view_overlay);
	self->priv->view_overlay = _tmp16_;
	_tmp17_ = (GtkButton*) gtk_button_new_with_label (_ ("Import Photo…"));
	g_object_ref_sink (_tmp17_);
	add_wallpaper_button = _tmp17_;
	_tmp18_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->combo);
	self->priv->combo = _tmp18_;
	_tmp19_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp19_, "centered", _ ("Centered"));
	_tmp20_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp20_, "zoom", _ ("Zoom"));
	_tmp21_ = self->priv->combo;
	gtk_combo_box_text_append (_tmp21_, "spanned", _ ("Spanned"));
	_tmp22_ = self->priv->combo;
	g_signal_connect_object ((GtkComboBox*) _tmp22_, "changed", (GCallback) _pantheon_shell_wallpaper_update_mode_gtk_combo_box_changed, self, 0);
	rgba_color = _tmp23_;
	_tmp24_ = color;
	if (!gdk_rgba_parse (&rgba_color, _tmp24_)) {
		GdkRGBA _tmp25_ = {0};
		_tmp25_.red = (gfloat) 1;
		_tmp25_.green = (gfloat) 1;
		_tmp25_.blue = (gfloat) 1;
		_tmp25_.alpha = (gfloat) 1;
		rgba_color = _tmp25_;
	}
	_tmp26_ = rgba_color;
	_tmp27_ = (GtkColorButton*) gtk_color_button_new ();
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp27_, &_tmp26_);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->color_button);
	self->priv->color_button = _tmp27_;
	_tmp28_ = self->priv->color_button;
	g_signal_connect_object (_tmp28_, "color-set", (GCallback) _pantheon_shell_wallpaper_update_color_gtk_color_button_color_set, self, 0);
	pantheon_shell_wallpaper_load_settings (self);
	_tmp29_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp29_);
	actionbar = _tmp29_;
	_tmp30_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, GRANITE_STYLE_CLASS_FLAT);
	_tmp31_ = actionbar;
	_tmp32_ = add_wallpaper_button;
	gtk_action_bar_pack_start (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = actionbar;
	_tmp34_ = self->priv->color_button;
	gtk_action_bar_pack_end (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = actionbar;
	_tmp36_ = self->priv->combo;
	gtk_action_bar_pack_end (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp37_);
	box = _tmp37_;
	_tmp38_ = box;
	_tmp39_ = self->priv->view_overlay;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = box;
	_tmp41_ = actionbar;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp42_, GRANITE_STYLE_CLASS_FRAME);
	_tmp43_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp43_);
	gtk_widget_add_css_class ((GtkWidget*) self, "wallpaper");
	_tmp44_ = add_wallpaper_button;
	g_signal_connect_object (_tmp44_, "clicked", (GCallback) _pantheon_shell_wallpaper_show_wallpaper_chooser_gtk_button_clicked, self, 0);
	_tmp45_ = drop_target;
	g_signal_connect_object (_tmp45_, "drop", (GCallback) _pantheon_shell_wallpaper_on_drag_data_received_gtk_drop_target_drop, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_wallpaper_button);
	_g_free0 (color);
	_g_object_unref0 (drop_target);
	return obj;
}

static void
pantheon_shell_wallpaper_class_init (PantheonShellWallpaperClass * klass,
                                     gpointer klass_data)
{
	GSettings* _tmp0_;
	pantheon_shell_wallpaper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellWallpaper_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_wallpaper_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_wallpaper_finalize;
	_tmp0_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (pantheon_shell_wallpaper_gnome_background_settings);
	pantheon_shell_wallpaper_gnome_background_settings = _tmp0_;
}

static void
pantheon_shell_wallpaper_instance_init (PantheonShellWallpaper * self,
                                        gpointer klass)
{
	self->priv = pantheon_shell_wallpaper_get_instance_private (self);
	self->priv->active_wallpaper = NULL;
	self->priv->solid_color = NULL;
	self->priv->wallpaper_for_removal = NULL;
	self->priv->prevent_update_mode = FALSE;
}

static void
pantheon_shell_wallpaper_finalize (GObject * obj)
{
	PantheonShellWallpaper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER, PantheonShellWallpaper);
	_g_object_unref0 (self->priv->wallpaper_scrolled_window);
	_g_object_unref0 (self->priv->wallpaper_view);
	_g_object_unref0 (self->priv->view_overlay);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->color_button);
	_g_object_unref0 (self->priv->active_wallpaper);
	_g_object_unref0 (self->priv->solid_color);
	_g_object_unref0 (self->priv->wallpaper_for_removal);
	_g_object_unref0 (self->priv->last_cancellable);
	_g_free0 (self->priv->current_wallpaper_path);
	G_OBJECT_CLASS (pantheon_shell_wallpaper_parent_class)->finalize (obj);
}

static GType
pantheon_shell_wallpaper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellWallpaperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_wallpaper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellWallpaper), 0, (GInstanceInitFunc) pantheon_shell_wallpaper_instance_init, NULL };
	GType pantheon_shell_wallpaper_type_id;
	pantheon_shell_wallpaper_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PantheonShellWallpaper", &g_define_type_info, 0);
	PantheonShellWallpaper_private_offset = g_type_add_instance_private (pantheon_shell_wallpaper_type_id, sizeof (PantheonShellWallpaperPrivate));
	return pantheon_shell_wallpaper_type_id;
}

GType
pantheon_shell_wallpaper_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_type_id__once)) {
		GType pantheon_shell_wallpaper_type_id;
		pantheon_shell_wallpaper_type_id = pantheon_shell_wallpaper_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_type_id__once, pantheon_shell_wallpaper_type_id);
	}
	return pantheon_shell_wallpaper_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

