/* SourceSettings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceSettings.vala, do not modify */

/*
* Copyright 2017-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "keyboard.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_TYPE_SOURCE_SETTINGS (keyboard_source_settings_get_type ())
#define KEYBOARD_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings))
#define KEYBOARD_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))
#define KEYBOARD_IS_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_IS_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_SOURCE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))

typedef struct _KeyboardSourceSettings KeyboardSourceSettings;
typedef struct _KeyboardSourceSettingsClass KeyboardSourceSettingsClass;
typedef struct _KeyboardSourceSettingsPrivate KeyboardSourceSettingsPrivate;

#define KEYBOARD_TYPE_XKB_MODIFIER (keyboard_xkb_modifier_get_type ())
#define KEYBOARD_XKB_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifier))
#define KEYBOARD_XKB_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifierClass))
#define KEYBOARD_IS_XKB_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_XKB_MODIFIER))
#define KEYBOARD_IS_XKB_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_XKB_MODIFIER))
#define KEYBOARD_XKB_MODIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifierClass))

typedef struct _KeyboardXkbModifier KeyboardXkbModifier;
typedef struct _KeyboardXkbModifierClass KeyboardXkbModifierClass;
enum  {
	KEYBOARD_SOURCE_SETTINGS_0_PROPERTY,
	KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY,
	KEYBOARD_SOURCE_SETTINGS_ACTIVE_INPUT_SOURCE_PROPERTY,
	KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY,
	KEYBOARD_SOURCE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
enum  {
	KEYBOARD_SOURCE_SETTINGS_EXTERNAL_LAYOUT_CHANGE_SIGNAL,
	KEYBOARD_SOURCE_SETTINGS_NUM_SIGNALS
};
static guint keyboard_source_settings_signals[KEYBOARD_SOURCE_SETTINGS_NUM_SIGNALS] = {0};

struct _KeyboardSourceSettings {
	GObject parent_instance;
	KeyboardSourceSettingsPrivate * priv;
};

struct _KeyboardSourceSettingsClass {
	GObjectClass parent_class;
};

struct _KeyboardSourceSettingsPrivate {
	guint _active_index;
	gchar** _active_engines;
	gint _active_engines_length1;
	gint __active_engines_size_;
	GList* input_sources;
	KeyboardXkbModifier** xkb_options_modifiers;
	gint xkb_options_modifiers_length1;
	gint _xkb_options_modifiers_size_;
	GSettings* settings;
	gboolean currently_writing;
};

struct _Block9Data {
	int _ref_count_;
	KeyboardSourceSettings* self;
	gboolean have_xkb;
};

struct _Block10Data {
	int _ref_count_;
	KeyboardSourceSettings* self;
	GList* remove_layouts;
	KeyboardLayoutType* layout_type;
};

struct _Block11Data {
	int _ref_count_;
	KeyboardSourceSettings* self;
	guint index;
	gchar* engine_name;
};

struct _Block12Data {
	int _ref_count_;
	KeyboardSourceSettings* self;
	GVariant** elements;
	gint elements_length1;
	gint _elements_size_;
	GList* xkb_sources;
	GList* ibus_sources;
};

static gint KeyboardSourceSettings_private_offset;
static gpointer keyboard_source_settings_parent_class = NULL;
static GOnce keyboard_source_settings_instance;
static GOnce keyboard_source_settings_instance = G_ONCE_INIT;

VALA_EXTERN GType keyboard_source_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType keyboard_xkb_modifier_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN KeyboardSourceSettings* keyboard_source_settings_get_instance (void);
static KeyboardSourceSettings* __lambda22_ (void);
static KeyboardSourceSettings* keyboard_source_settings_new (void);
static KeyboardSourceSettings* keyboard_source_settings_construct (GType object_type);
static gpointer ___lambda22__gthread_func (gpointer self);
static void __lambda23_ (KeyboardSourceSettings* self);
static void keyboard_source_settings_update_list_from_gsettings (KeyboardSourceSettings* self);
static void ___lambda23__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN void keyboard_source_settings_reset (KeyboardSourceSettings* self,
                                     KeyboardLayoutType* layout_type,
                                     gboolean signal_changed);
VALA_EXTERN gboolean keyboard_source_settings_add_layout_internal (KeyboardSourceSettings* self,
                                                       KeyboardInputSource* new_layout);
static void keyboard_source_settings_add_default_keyboard_if_required (KeyboardSourceSettings* self);
VALA_EXTERN void keyboard_source_settings_add_xkb_modifier (KeyboardSourceSettings* self,
                                                KeyboardXkbModifier* modifier);
VALA_EXTERN void keyboard_xkb_modifier_update_from_gsettings (KeyboardXkbModifier* self);
static void _vala_array_add6 (KeyboardXkbModifier** * array,
                       gint* length,
                       gint* size,
                       KeyboardXkbModifier* value);
VALA_EXTERN KeyboardXkbModifier* keyboard_source_settings_get_xkb_modifier_by_name (KeyboardSourceSettings* self,
                                                                        const gchar* name);
VALA_EXTERN const gchar* keyboard_xkb_modifier_get_name (KeyboardXkbModifier* self);
VALA_EXTERN void keyboard_source_settings_switch_items (KeyboardSourceSettings* self,
                                            guint pos1,
                                            gboolean move_up);
VALA_EXTERN guint keyboard_source_settings_get_active_index (KeyboardSourceSettings* self);
VALA_EXTERN void keyboard_source_settings_set_active_index (KeyboardSourceSettings* self,
                                                guint value);
static void keyboard_source_settings_write_to_gsettings (KeyboardSourceSettings* self);
VALA_EXTERN void keyboard_source_settings_foreach_layout (KeyboardSourceSettings* self,
                                              GFunc func,
                                              gpointer func_target);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda26_ (Block9Data* _data9_,
                  KeyboardInputSource* source);
static void ___lambda26__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN gboolean keyboard_source_settings_add_layout (KeyboardSourceSettings* self,
                                              KeyboardInputSource* new_layout);
VALA_EXTERN void keyboard_source_settings_remove_layout (KeyboardSourceSettings* self,
                                             guint index);
static KeyboardLayoutType* _keyboard_layout_type_dup (KeyboardLayoutType* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda24_ (Block10Data* _data10_,
                  KeyboardInputSource* source);
static gboolean _keyboard_layout_type_equal (const KeyboardLayoutType * s1,
                                      const KeyboardLayoutType * s2);
static void ___lambda24__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda25_ (KeyboardSourceSettings* self,
                  KeyboardInputSource* layout);
static void ___lambda25__gfunc (gconstpointer data,
                         gpointer self);
static void keyboard_source_settings_update_input_sources_ibus (KeyboardSourceSettings* self);
VALA_EXTERN gchar** keyboard_source_settings_get_active_engines (KeyboardSourceSettings* self,
                                                     gint* result_length1);
VALA_EXTERN gboolean keyboard_source_settings_add_active_engine (KeyboardSourceSettings* self,
                                                     const gchar* engine_name);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void keyboard_source_settings_set_active_engines (KeyboardSourceSettings* self,
                                                  gchar** value,
                                                  gint value_length1);
VALA_EXTERN void keyboard_source_settings_set_active_engine_name (KeyboardSourceSettings* self,
                                                      const gchar* engine_name);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda78_ (Block11Data* _data11_,
                  KeyboardInputSource* input_source);
static void ___lambda78__gfunc (gconstpointer data,
                         gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void ___lambda27_ (Block12Data* _data12_,
                   KeyboardInputSource* input_source);
static void ____lambda27__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda28_ (Block12Data* _data12_,
                   KeyboardInputSource* input_source);
static void _vala_array_add8 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void ____lambda28__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda29_ (Block12Data* _data12_,
                   KeyboardInputSource* input_source);
static void _vala_array_add9 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void ____lambda29__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN KeyboardInputSource* keyboard_source_settings_get_active_input_source (KeyboardSourceSettings* self);
static GObject * keyboard_source_settings_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void keyboard_source_settings_finalize (GObject * obj);
static GType keyboard_source_settings_get_type_once (void);
static void _vala_keyboard_source_settings_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_keyboard_source_settings_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
keyboard_source_settings_get_instance_private (KeyboardSourceSettings* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardSourceSettings_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static KeyboardSourceSettings*
__lambda22_ (void)
{
	KeyboardSourceSettings* _tmp0_;
	KeyboardSourceSettings* result;
	_tmp0_ = keyboard_source_settings_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda22__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda22_ ();
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

KeyboardSourceSettings*
keyboard_source_settings_get_instance (void)
{
	gconstpointer _tmp0_;
	KeyboardSourceSettings* _tmp1_;
	KeyboardSourceSettings* result;
	_tmp0_ = g_once (&keyboard_source_settings_instance, ___lambda22__gthread_func, NULL);
	_tmp1_ = _g_object_ref0 ((KeyboardSourceSettings*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
__lambda23_ (KeyboardSourceSettings* self)
{
	keyboard_source_settings_update_list_from_gsettings (self);
	g_signal_emit (self, keyboard_source_settings_signals[KEYBOARD_SOURCE_SETTINGS_EXTERNAL_LAYOUT_CHANGE_SIGNAL], 0);
}

static void
___lambda23__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda23_ ((KeyboardSourceSettings*) self);
}

static KeyboardSourceSettings*
keyboard_source_settings_construct (GType object_type)
{
	KeyboardSourceSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	self = (KeyboardSourceSettings*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed::sources", (GCallback) ___lambda23__g_settings_changed, self, 0);
	_tmp2_ = self->priv->settings;
	g_settings_bind (_tmp2_, "current", (GObject*) self, "active-index", G_SETTINGS_BIND_DEFAULT);
	keyboard_source_settings_update_list_from_gsettings (self);
	return self;
}

static KeyboardSourceSettings*
keyboard_source_settings_new (void)
{
	return keyboard_source_settings_construct (KEYBOARD_TYPE_SOURCE_SETTINGS);
}

static void
keyboard_source_settings_update_list_from_gsettings (KeyboardSourceSettings* self)
{
	GVariant* sources = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	const GVariantType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->currently_writing) {
		return;
	}
	keyboard_source_settings_reset (self, NULL, TRUE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "sources");
	sources = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = g_variant_get_type (_tmp2_);
	_tmp4_ = g_variant_type_dup_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "a(ss)") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		{
			gsize i = 0UL;
			i = (gsize) 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					GVariant* _tmp9_;
					GVariant* child = NULL;
					GVariant* _tmp10_;
					GVariant* _tmp11_;
					GVariant* _tmp12_;
					KeyboardInputSource* _tmp13_;
					KeyboardInputSource* _tmp14_;
					if (!_tmp7_) {
						gsize _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = sources;
					if (!(i < g_variant_n_children (_tmp9_))) {
						break;
					}
					_tmp10_ = sources;
					_tmp11_ = g_variant_get_child_value (_tmp10_, i);
					child = _tmp11_;
					_tmp12_ = child;
					_tmp13_ = keyboard_input_source_new_from_variant (_tmp12_);
					_tmp14_ = _tmp13_;
					keyboard_source_settings_add_layout_internal (self, _tmp14_);
					_g_object_unref0 (_tmp14_);
					_g_variant_unref0 (child);
				}
			}
		}
		g_signal_emit (self, keyboard_source_settings_signals[KEYBOARD_SOURCE_SETTINGS_EXTERNAL_LAYOUT_CHANGE_SIGNAL], 0);
	} else {
		g_warning ("SourceSettings.vala:103: GSettings sources of unexpected type");
	}
	keyboard_source_settings_add_default_keyboard_if_required (self);
	_g_variant_unref0 (sources);
}

static void
_vala_array_add6 (KeyboardXkbModifier** * array,
                  gint* length,
                  gint* size,
                  KeyboardXkbModifier* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (KeyboardXkbModifier*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
keyboard_source_settings_add_xkb_modifier (KeyboardSourceSettings* self,
                                           KeyboardXkbModifier* modifier)
{
	KeyboardXkbModifier* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modifier != NULL);
	keyboard_xkb_modifier_update_from_gsettings (modifier);
	_tmp0_ = _g_object_ref0 (modifier);
	_vala_array_add6 (&self->priv->xkb_options_modifiers, &self->priv->xkb_options_modifiers_length1, &self->priv->_xkb_options_modifiers_size_, _tmp0_);
}

KeyboardXkbModifier*
keyboard_source_settings_get_xkb_modifier_by_name (KeyboardSourceSettings* self,
                                                   const gchar* name)
{
	KeyboardXkbModifier** _tmp0_;
	gint _tmp0__length1;
	KeyboardXkbModifier* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->xkb_options_modifiers;
	_tmp0__length1 = self->priv->xkb_options_modifiers_length1;
	{
		KeyboardXkbModifier** modifier_collection = NULL;
		gint modifier_collection_length1 = 0;
		gint _modifier_collection_size_ = 0;
		gint modifier_it = 0;
		modifier_collection = _tmp0_;
		modifier_collection_length1 = _tmp0__length1;
		for (modifier_it = 0; modifier_it < modifier_collection_length1; modifier_it = modifier_it + 1) {
			KeyboardXkbModifier* _tmp1_;
			KeyboardXkbModifier* modifier = NULL;
			_tmp1_ = _g_object_ref0 (modifier_collection[modifier_it]);
			modifier = _tmp1_;
			{
				KeyboardXkbModifier* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = modifier;
				_tmp3_ = keyboard_xkb_modifier_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					result = modifier;
					return result;
				}
				_g_object_unref0 (modifier);
			}
		}
	}
	result = NULL;
	return result;
}

void
keyboard_source_settings_switch_items (KeyboardSourceSettings* self,
                                       guint pos1,
                                       gboolean move_up)
{
	guint max_pos = 0U;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	guint pos2 = 0U;
	gboolean _tmp2_ = FALSE;
	GList* container1 = NULL;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* container2 = NULL;
	GList* _tmp5_;
	GList* _tmp6_;
	KeyboardInputSource* tmp = NULL;
	GList* _tmp19_;
	gconstpointer _tmp20_;
	KeyboardInputSource* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	gconstpointer _tmp24_;
	KeyboardInputSource* _tmp25_;
	GList* _tmp26_;
	KeyboardInputSource* _tmp27_;
	KeyboardInputSource* _tmp28_;
	guint _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_sources;
	max_pos = g_list_length (_tmp0_) - 1;
	if (move_up) {
		_tmp1_ = pos1 - 1;
	} else {
		_tmp1_ = pos1 + 1;
	}
	pos2 = _tmp1_;
	if (pos2 < ((guint) 0)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = pos2 > max_pos;
	}
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->input_sources;
	_tmp4_ = g_list_nth (_tmp3_, pos1);
	container1 = _tmp4_;
	_tmp5_ = self->priv->input_sources;
	_tmp6_ = g_list_nth (_tmp5_, pos2);
	container2 = _tmp6_;
	while (TRUE) {
		GList* _tmp7_;
		gconstpointer _tmp8_;
		KeyboardLayoutType _tmp9_;
		KeyboardLayoutType _tmp10_;
		GList* _tmp11_;
		gconstpointer _tmp12_;
		KeyboardLayoutType _tmp13_;
		KeyboardLayoutType _tmp14_;
		guint _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		GList* _tmp17_;
		GList* _tmp18_;
		_tmp7_ = container1;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = keyboard_input_source_get_layout_type ((KeyboardInputSource*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = container2;
		_tmp12_ = _tmp11_->data;
		_tmp13_ = keyboard_input_source_get_layout_type ((KeyboardInputSource*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (!(_tmp10_ != _tmp14_)) {
			break;
		}
		if (move_up) {
			_tmp15_ = pos2 - 1;
		} else {
			_tmp15_ = pos2 + 1;
		}
		pos2 = _tmp15_;
		if (pos2 < ((guint) 0)) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = pos2 > max_pos;
		}
		if (_tmp16_) {
			return;
		}
		_tmp17_ = self->priv->input_sources;
		_tmp18_ = g_list_nth (_tmp17_, pos2);
		container2 = _tmp18_;
	}
	_tmp19_ = container1;
	_tmp20_ = _tmp19_->data;
	_tmp21_ = _g_object_ref0 ((KeyboardInputSource*) _tmp20_);
	tmp = _tmp21_;
	_tmp22_ = container1;
	_tmp23_ = container2;
	_tmp24_ = _tmp23_->data;
	_tmp25_ = _g_object_ref0 ((KeyboardInputSource*) _tmp24_);
	_g_object_unref0 (_tmp22_->data);
	_tmp22_->data = _tmp25_;
	_tmp26_ = container2;
	_tmp27_ = tmp;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (_tmp26_->data);
	_tmp26_->data = _tmp28_;
	_tmp29_ = self->priv->_active_index;
	if (_tmp29_ == pos1) {
		keyboard_source_settings_set_active_index (self, pos2);
	} else {
		guint _tmp30_;
		_tmp30_ = self->priv->_active_index;
		if (_tmp30_ == pos2) {
			keyboard_source_settings_set_active_index (self, pos1);
		}
	}
	keyboard_source_settings_write_to_gsettings (self);
	_g_object_unref0 (tmp);
}

void
keyboard_source_settings_foreach_layout (KeyboardSourceSettings* self,
                                         GFunc func,
                                         gpointer func_target)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_sources;
	g_list_foreach (_tmp0_, func, func_target);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		KeyboardSourceSettings* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda26_ (Block9Data* _data9_,
             KeyboardInputSource* source)
{
	KeyboardSourceSettings* self;
	KeyboardLayoutType _tmp0_;
	KeyboardLayoutType _tmp1_;
	self = _data9_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = keyboard_input_source_get_layout_type (source);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == KEYBOARD_LAYOUT_TYPE_XKB) {
		_data9_->have_xkb = TRUE;
	}
}

static void
___lambda26__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda26_ (self, (KeyboardInputSource*) data);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
keyboard_source_settings_add_default_keyboard_if_required (KeyboardSourceSettings* self)
{
	Block9Data* _data9_;
	GList* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->have_xkb = FALSE;
	_tmp0_ = self->priv->input_sources;
	g_list_foreach (_tmp0_, ___lambda26__gfunc, _data9_);
	if (!_data9_->have_xkb) {
		GFile* file = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* xkb_layout = NULL;
		gchar* _tmp6_;
		gchar* xkb_variant = NULL;
		gchar* _tmp7_;
		gchar** variants = NULL;
		const gchar* _tmp34_;
		gchar** _tmp35_;
		gchar** _tmp36_;
		gint variants_length1;
		gint _variants_size_;
		gchar** xkb_layouts = NULL;
		const gchar* _tmp37_;
		gchar** _tmp38_;
		gchar** _tmp39_;
		gint xkb_layouts_length1;
		gint _xkb_layouts_size_;
		_tmp1_ = g_file_new_for_path ("/etc/default/keyboard");
		file = _tmp1_;
		_tmp2_ = file;
		if (!g_file_query_exists (_tmp2_, NULL)) {
			GFile* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = file;
			_tmp4_ = g_file_get_path (_tmp3_);
			_tmp5_ = _tmp4_;
			g_warning ("SourceSettings.vala:174: File '%s' doesn't exist.\n", _tmp5_);
			_g_free0 (_tmp5_);
			_g_object_unref0 (file);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return;
		}
		_tmp6_ = g_strdup ("");
		xkb_layout = _tmp6_;
		_tmp7_ = g_strdup ("");
		xkb_variant = _tmp7_;
		{
			GFileInputStream* _tmp8_ = NULL;
			GFile* _tmp9_;
			GFileInputStream* _tmp10_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp11_;
			gchar* line = NULL;
			_tmp9_ = file;
			_tmp10_ = g_file_read (_tmp9_, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp11_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
			dis = _tmp11_;
			while (TRUE) {
				gchar* _tmp12_ = NULL;
				GDataInputStream* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp13_ = dis;
				_tmp14_ = g_data_input_stream_read_line (_tmp13_, NULL, NULL, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp8_);
					goto __catch0_g_error;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_free0 (line);
				line = _tmp15_;
				_tmp16_ = line;
				if (!(_tmp16_ != NULL)) {
					_g_free0 (_tmp12_);
					break;
				}
				_tmp17_ = line;
				if (string_contains (_tmp17_, "XKBLAYOUT=")) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp18_ = line;
					_tmp19_ = string_replace (_tmp18_, "XKBLAYOUT=", "");
					_tmp20_ = _tmp19_;
					_tmp21_ = string_replace (_tmp20_, "\"", "");
					_g_free0 (xkb_layout);
					xkb_layout = _tmp21_;
					_g_free0 (_tmp20_);
					while (TRUE) {
						gchar* _tmp22_ = NULL;
						GDataInputStream* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						_tmp23_ = dis;
						_tmp24_ = g_data_input_stream_read_line (_tmp23_, NULL, NULL, &_inner_error0_);
						_tmp22_ = _tmp24_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (_tmp12_);
							_g_free0 (line);
							_g_object_unref0 (dis);
							_g_object_unref0 (_tmp8_);
							goto __catch0_g_error;
						}
						_tmp25_ = _tmp22_;
						_tmp22_ = NULL;
						_g_free0 (line);
						line = _tmp25_;
						_tmp26_ = line;
						if (!(_tmp26_ != NULL)) {
							_g_free0 (_tmp22_);
							break;
						}
						_tmp27_ = line;
						if (string_contains (_tmp27_, "XKBVARIANT=")) {
							const gchar* _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp28_ = line;
							_tmp29_ = string_replace (_tmp28_, "XKBVARIANT=", "");
							_tmp30_ = _tmp29_;
							_tmp31_ = string_replace (_tmp30_, "\"", "");
							_g_free0 (xkb_variant);
							xkb_variant = _tmp31_;
							_g_free0 (_tmp30_);
						}
						_g_free0 (_tmp22_);
					}
					_g_free0 (_tmp12_);
					break;
				}
				_g_free0 (_tmp12_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp8_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			g_warning ("SourceSettings.vala:201: %s", _tmp33_);
			_g_error_free0 (e);
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_object_unref0 (file);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_object_unref0 (file);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp34_ = xkb_variant;
		_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, ",", 0);
		variants = _tmp36_;
		variants_length1 = _vala_array_length (_tmp35_);
		_variants_size_ = variants_length1;
		_tmp37_ = xkb_layout;
		_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, ",", 0);
		xkb_layouts = _tmp39_;
		xkb_layouts_length1 = _vala_array_length (_tmp38_);
		_xkb_layouts_size_ = xkb_layouts_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					gchar** _tmp42_;
					gint _tmp42__length1;
					gboolean _tmp43_ = FALSE;
					gchar** _tmp44_;
					gint _tmp44__length1;
					const gchar* _tmp45_;
					if (!_tmp40_) {
						gint _tmp41_;
						_tmp41_ = i;
						i = _tmp41_ + 1;
					}
					_tmp40_ = FALSE;
					_tmp42_ = xkb_layouts;
					_tmp42__length1 = xkb_layouts_length1;
					if (!(i < _tmp42__length1)) {
						break;
					}
					_tmp44_ = variants;
					_tmp44__length1 = variants_length1;
					_tmp45_ = _tmp44_[i];
					if (_tmp45_ != NULL) {
						gchar** _tmp46_;
						gint _tmp46__length1;
						const gchar* _tmp47_;
						_tmp46_ = variants;
						_tmp46__length1 = variants_length1;
						_tmp47_ = _tmp46_[i];
						_tmp43_ = g_strcmp0 (_tmp47_, "") != 0;
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						gchar** _tmp48_;
						gint _tmp48__length1;
						const gchar* _tmp49_;
						gchar** _tmp50_;
						gint _tmp50__length1;
						const gchar* _tmp51_;
						KeyboardInputSource* _tmp52_;
						KeyboardInputSource* _tmp53_;
						_tmp48_ = xkb_layouts;
						_tmp48__length1 = xkb_layouts_length1;
						_tmp49_ = _tmp48_[i];
						_tmp50_ = variants;
						_tmp50__length1 = variants_length1;
						_tmp51_ = _tmp50_[i];
						_tmp52_ = keyboard_input_source_new_xkb (_tmp49_, _tmp51_);
						_tmp53_ = _tmp52_;
						keyboard_source_settings_add_layout_internal (self, _tmp53_);
						_g_object_unref0 (_tmp53_);
					} else {
						gchar** _tmp54_;
						gint _tmp54__length1;
						const gchar* _tmp55_;
						KeyboardInputSource* _tmp56_;
						KeyboardInputSource* _tmp57_;
						_tmp54_ = xkb_layouts;
						_tmp54__length1 = xkb_layouts_length1;
						_tmp55_ = _tmp54_[i];
						_tmp56_ = keyboard_input_source_new_xkb (_tmp55_, NULL);
						_tmp57_ = _tmp56_;
						keyboard_source_settings_add_layout_internal (self, _tmp57_);
						_g_object_unref0 (_tmp57_);
					}
				}
			}
		}
		keyboard_source_settings_write_to_gsettings (self);
		xkb_layouts = (_vala_array_free (xkb_layouts, xkb_layouts_length1, (GDestroyNotify) g_free), NULL);
		variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (xkb_variant);
		_g_free0 (xkb_layout);
		_g_object_unref0 (file);
	}
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

gboolean
keyboard_source_settings_add_layout (KeyboardSourceSettings* self,
                                     KeyboardInputSource* new_layout)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (keyboard_source_settings_add_layout_internal (self, new_layout)) {
		keyboard_source_settings_write_to_gsettings (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
keyboard_source_settings_add_layout_internal (KeyboardSourceSettings* self,
                                              KeyboardInputSource* new_layout)
{
	gint i = 0;
	GList* _tmp0_;
	KeyboardInputSource* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (new_layout == NULL) {
		result = FALSE;
		return result;
	}
	i = 0;
	_tmp0_ = self->priv->input_sources;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			KeyboardInputSource* _tmp1_;
			KeyboardInputSource* l = NULL;
			_tmp1_ = _g_object_ref0 ((KeyboardInputSource*) l_it->data);
			l = _tmp1_;
			{
				KeyboardInputSource* _tmp2_;
				gint _tmp3_;
				_tmp2_ = l;
				if (keyboard_input_source_equal (_tmp2_, new_layout)) {
					result = FALSE;
					_g_object_unref0 (l);
					return result;
				}
				_tmp3_ = i;
				i = _tmp3_ + 1;
				_g_object_unref0 (l);
			}
		}
	}
	_tmp4_ = _g_object_ref0 (new_layout);
	self->priv->input_sources = g_list_append (self->priv->input_sources, _tmp4_);
	result = TRUE;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
keyboard_source_settings_remove_layout (KeyboardSourceSettings* self,
                                        guint index)
{
	GList* _tmp0_;
	KeyboardInputSource* source = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	KeyboardInputSource* _tmp3_;
	KeyboardInputSource* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_sources;
	if (index >= g_list_length (_tmp0_)) {
		index = (guint) 0;
	}
	_tmp1_ = self->priv->input_sources;
	_tmp2_ = g_list_nth_data (_tmp1_, index);
	_tmp3_ = _g_object_ref0 ((KeyboardInputSource*) _tmp2_);
	source = _tmp3_;
	_tmp4_ = source;
	self->priv->input_sources = vala_g_list_remove_full (self->priv->input_sources, _tmp4_, _g_object_unref0_);
	if (index >= ((guint) 1)) {
		GList* _tmp5_;
		_tmp5_ = self->priv->input_sources;
		keyboard_source_settings_set_active_index (self, g_list_length (_tmp5_) - 1);
	}
	keyboard_source_settings_add_default_keyboard_if_required (self);
	keyboard_source_settings_write_to_gsettings (self);
	_g_object_unref0 (source);
}

static KeyboardLayoutType*
_keyboard_layout_type_dup (KeyboardLayoutType* self)
{
	KeyboardLayoutType* dup;
	dup = g_new0 (KeyboardLayoutType, 1);
	memcpy (dup, self, sizeof (KeyboardLayoutType));
	return dup;
}

static gpointer
__keyboard_layout_type_dup0 (gpointer self)
{
	return self ? _keyboard_layout_type_dup (self) : NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		KeyboardSourceSettings* self;
		self = _data10_->self;
		(_data10_->remove_layouts == NULL) ? NULL : (_data10_->remove_layouts = (_g_list_free__g_object_unref0_ (_data10_->remove_layouts), NULL));
		_g_free0 (_data10_->layout_type);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
_keyboard_layout_type_equal (const KeyboardLayoutType * s1,
                             const KeyboardLayoutType * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
__lambda24_ (Block10Data* _data10_,
             KeyboardInputSource* source)
{
	KeyboardSourceSettings* self;
	gboolean _tmp0_ = FALSE;
	self = _data10_->self;
	g_return_if_fail (source != NULL);
	if (_data10_->layout_type == NULL) {
		_tmp0_ = TRUE;
	} else {
		KeyboardLayoutType _tmp1_;
		KeyboardLayoutType _tmp2_;
		_tmp1_ = keyboard_input_source_get_layout_type (source);
		_tmp2_ = _tmp1_;
		_tmp0_ = _keyboard_layout_type_equal (_data10_->layout_type, &_tmp2_) == TRUE;
	}
	if (_tmp0_) {
		KeyboardInputSource* _tmp3_;
		_tmp3_ = _g_object_ref0 (source);
		_data10_->remove_layouts = g_list_append (_data10_->remove_layouts, _tmp3_);
	}
}

static void
___lambda24__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda24_ (self, (KeyboardInputSource*) data);
}

static void
__lambda25_ (KeyboardSourceSettings* self,
             KeyboardInputSource* layout)
{
	g_return_if_fail (layout != NULL);
	self->priv->input_sources = vala_g_list_remove_full (self->priv->input_sources, layout, _g_object_unref0_);
}

static void
___lambda25__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda25_ ((KeyboardSourceSettings*) self, (KeyboardInputSource*) data);
}

void
keyboard_source_settings_reset (KeyboardSourceSettings* self,
                                KeyboardLayoutType* layout_type,
                                gboolean signal_changed)
{
	Block10Data* _data10_;
	KeyboardLayoutType* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = __keyboard_layout_type_dup0 (layout_type);
	_g_free0 (_data10_->layout_type);
	_data10_->layout_type = _tmp0_;
	_data10_->remove_layouts = NULL;
	_tmp1_ = self->priv->input_sources;
	g_list_foreach (_tmp1_, ___lambda24__gfunc, _data10_);
	g_list_foreach (_data10_->remove_layouts, ___lambda25__gfunc, self);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
keyboard_source_settings_update_input_sources_ibus (KeyboardSourceSettings* self)
{
	KeyboardLayoutType _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = KEYBOARD_LAYOUT_TYPE_IBUS;
	keyboard_source_settings_reset (self, &_tmp0_, FALSE);
	_tmp1_ = keyboard_source_settings_get_active_engines (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** engine_name_collection = NULL;
		gint engine_name_collection_length1 = 0;
		gint _engine_name_collection_size_ = 0;
		gint engine_name_it = 0;
		engine_name_collection = _tmp3_;
		engine_name_collection_length1 = _tmp3__length1;
		for (engine_name_it = 0; engine_name_it < engine_name_collection_length1; engine_name_it = engine_name_it + 1) {
			gchar* _tmp4_;
			gchar* engine_name = NULL;
			_tmp4_ = g_strdup (engine_name_collection[engine_name_it]);
			engine_name = _tmp4_;
			{
				const gchar* _tmp5_;
				KeyboardInputSource* _tmp6_;
				KeyboardInputSource* _tmp7_;
				_tmp5_ = engine_name;
				_tmp6_ = keyboard_input_source_new_ibus (_tmp5_);
				_tmp7_ = _tmp6_;
				keyboard_source_settings_add_layout (self, _tmp7_);
				_g_object_unref0 (_tmp7_);
				_g_free0 (engine_name);
			}
		}
	}
	keyboard_source_settings_write_to_gsettings (self);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gboolean
keyboard_source_settings_add_active_engine (KeyboardSourceSettings* self,
                                            const gchar* engine_name)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** new_engine_list = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint new_engine_list_length1;
	gint _new_engine_list_size_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (engine_name != NULL, FALSE);
	_tmp0_ = keyboard_source_settings_get_active_engines (self, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	{
		gchar** active_engine_collection = NULL;
		gint active_engine_collection_length1 = 0;
		gint _active_engine_collection_size_ = 0;
		gint active_engine_it = 0;
		active_engine_collection = _tmp2_;
		active_engine_collection_length1 = _tmp2__length1;
		for (active_engine_it = 0; active_engine_it < active_engine_collection_length1; active_engine_it = active_engine_it + 1) {
			gchar* _tmp3_;
			gchar* active_engine = NULL;
			_tmp3_ = g_strdup (active_engine_collection[active_engine_it]);
			active_engine = _tmp3_;
			{
				const gchar* _tmp4_;
				_tmp4_ = active_engine;
				if (g_strcmp0 (engine_name, _tmp4_) == 0) {
					result = FALSE;
					_g_free0 (active_engine);
					return result;
				}
				_g_free0 (active_engine);
			}
		}
	}
	_tmp5_ = keyboard_source_settings_get_active_engines (self, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup2 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	new_engine_list = _tmp8_;
	new_engine_list_length1 = _tmp8__length1;
	_new_engine_list_size_ = new_engine_list_length1;
	_tmp9_ = g_strdup (engine_name);
	_vala_array_add7 (&new_engine_list, &new_engine_list_length1, &_new_engine_list_size_, _tmp9_);
	_tmp10_ = new_engine_list;
	_tmp10__length1 = new_engine_list_length1;
	keyboard_source_settings_set_active_engines (self, _tmp10_, _tmp10__length1);
	result = TRUE;
	new_engine_list = (_vala_array_free (new_engine_list, new_engine_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		KeyboardSourceSettings* self;
		self = _data11_->self;
		_g_free0 (_data11_->engine_name);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda78_ (Block11Data* _data11_,
             KeyboardInputSource* input_source)
{
	KeyboardSourceSettings* self;
	gboolean _tmp0_ = FALSE;
	KeyboardLayoutType _tmp1_;
	KeyboardLayoutType _tmp2_;
	guint _tmp5_;
	self = _data11_->self;
	g_return_if_fail (input_source != NULL);
	_tmp1_ = keyboard_input_source_get_layout_type (input_source);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == KEYBOARD_LAYOUT_TYPE_IBUS) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = keyboard_input_source_get_name (input_source);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, _data11_->engine_name) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		keyboard_source_settings_set_active_index (self, _data11_->index);
		return;
	}
	_tmp5_ = _data11_->index;
	_data11_->index = _tmp5_ + 1;
}

static void
___lambda78__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda78_ (self, (KeyboardInputSource*) data);
}

void
keyboard_source_settings_set_active_engine_name (KeyboardSourceSettings* self,
                                                 const gchar* engine_name)
{
	Block11Data* _data11_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine_name != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = g_strdup (engine_name);
	_g_free0 (_data11_->engine_name);
	_data11_->engine_name = _tmp0_;
	keyboard_source_settings_update_input_sources_ibus (self);
	_data11_->index = (guint) 0;
	keyboard_source_settings_foreach_layout (self, ___lambda78__gfunc, _data11_);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		KeyboardSourceSettings* self;
		self = _data12_->self;
		(_data12_->ibus_sources == NULL) ? NULL : (_data12_->ibus_sources = (_g_list_free__g_object_unref0_ (_data12_->ibus_sources), NULL));
		(_data12_->xkb_sources == NULL) ? NULL : (_data12_->xkb_sources = (_g_list_free__g_object_unref0_ (_data12_->xkb_sources), NULL));
		_data12_->elements = (_vala_array_free (_data12_->elements, _data12_->elements_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
___lambda27_ (Block12Data* _data12_,
              KeyboardInputSource* input_source)
{
	KeyboardSourceSettings* self;
	KeyboardLayoutType _tmp0_;
	KeyboardLayoutType _tmp1_;
	self = _data12_->self;
	g_return_if_fail (input_source != NULL);
	_tmp0_ = keyboard_input_source_get_layout_type (input_source);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == KEYBOARD_LAYOUT_TYPE_XKB) {
		KeyboardInputSource* _tmp2_;
		_tmp2_ = _g_object_ref0 (input_source);
		_data12_->xkb_sources = g_list_append (_data12_->xkb_sources, _tmp2_);
	} else {
		KeyboardInputSource* _tmp3_;
		_tmp3_ = _g_object_ref0 (input_source);
		_data12_->ibus_sources = g_list_append (_data12_->ibus_sources, _tmp3_);
	}
}

static void
____lambda27__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda27_ (self, (KeyboardInputSource*) data);
}

static void
_vala_array_add8 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
___lambda28_ (Block12Data* _data12_,
              KeyboardInputSource* input_source)
{
	KeyboardSourceSettings* self;
	GVariant* _tmp0_;
	self = _data12_->self;
	g_return_if_fail (input_source != NULL);
	_tmp0_ = keyboard_input_source_to_variant (input_source);
	_vala_array_add8 (&_data12_->elements, &_data12_->elements_length1, &_data12_->_elements_size_, _tmp0_);
}

static void
____lambda28__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda28_ (self, (KeyboardInputSource*) data);
}

static void
_vala_array_add9 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
___lambda29_ (Block12Data* _data12_,
              KeyboardInputSource* input_source)
{
	KeyboardSourceSettings* self;
	GVariant* _tmp0_;
	self = _data12_->self;
	g_return_if_fail (input_source != NULL);
	_tmp0_ = keyboard_input_source_to_variant (input_source);
	_vala_array_add9 (&_data12_->elements, &_data12_->elements_length1, &_data12_->_elements_size_, _tmp0_);
}

static void
____lambda29__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda29_ (self, (KeyboardInputSource*) data);
}

static void
keyboard_source_settings_write_to_gsettings (KeyboardSourceSettings* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->currently_writing = TRUE;
	{
		Block12Data* _data12_;
		GVariant** _tmp0_;
		GList* _tmp1_;
		GVariant* list = NULL;
		GVariantType* _tmp2_;
		GVariantType* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GSettings* _tmp6_;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->self = g_object_ref (self);
		_tmp0_ = g_new0 (GVariant*, 0 + 1);
		_data12_->elements = _tmp0_;
		_data12_->elements_length1 = 0;
		_data12_->_elements_size_ = _data12_->elements_length1;
		_data12_->xkb_sources = NULL;
		_data12_->ibus_sources = NULL;
		_tmp1_ = self->priv->input_sources;
		g_list_foreach (_tmp1_, ____lambda27__gfunc, _data12_);
		g_list_foreach (_data12_->xkb_sources, ____lambda28__gfunc, _data12_);
		g_list_foreach (_data12_->ibus_sources, ____lambda29__gfunc, _data12_);
		_tmp2_ = g_variant_type_new ("(ss)");
		_tmp3_ = _tmp2_;
		_tmp4_ = g_variant_new_array (_tmp3_, _data12_->elements, _data12_->elements_length1);
		g_variant_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		_g_variant_type_free0 (_tmp3_);
		list = _tmp5_;
		_tmp6_ = self->priv->settings;
		g_settings_set_value (_tmp6_, "sources", list);
		_g_variant_unref0 (list);
		block12_data_unref (_data12_);
		_data12_ = NULL;
	}
	__finally0:
	{
		self->priv->currently_writing = FALSE;
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

guint
keyboard_source_settings_get_active_index (KeyboardSourceSettings* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_active_index;
	return result;
}

void
keyboard_source_settings_set_active_index (KeyboardSourceSettings* self,
                                           guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_source_settings_get_active_index (self);
	if (old_value != value) {
		self->priv->_active_index = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY]);
	}
}

KeyboardInputSource*
keyboard_source_settings_get_active_input_source (KeyboardSourceSettings* self)
{
	KeyboardInputSource* result;
	guint _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	gconstpointer _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_index;
	_tmp1_ = self->priv->input_sources;
	if (_tmp0_ >= g_list_length (_tmp1_)) {
		keyboard_source_settings_set_active_index (self, (guint) 0);
	}
	_tmp2_ = self->priv->input_sources;
	_tmp3_ = self->priv->_active_index;
	_tmp4_ = g_list_nth_data (_tmp2_, _tmp3_);
	result = (KeyboardInputSource*) _tmp4_;
	return result;
}

gchar**
keyboard_source_settings_get_active_engines (KeyboardSourceSettings* self,
                                             gint* result_length1)
{
	gchar** result;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = keyboard_plug_ibus_general_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "preload-engines");
	self->priv->_active_engines = (_vala_array_free (self->priv->_active_engines, self->priv->_active_engines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_active_engines = _tmp2_;
	self->priv->_active_engines_length1 = _vala_array_length (_tmp1_);
	self->priv->__active_engines_size_ = self->priv->_active_engines_length1;
	_tmp3_ = self->priv->_active_engines;
	_tmp3__length1 = self->priv->_active_engines_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

void
keyboard_source_settings_set_active_engines (KeyboardSourceSettings* self,
                                             gchar** value,
                                             gint value_length1)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = keyboard_plug_ibus_general_settings;
	g_settings_set_strv (_tmp0_, "preload-engines", value);
	_tmp1_ = keyboard_plug_ibus_general_settings;
	g_settings_set_strv (_tmp1_, "engines-order", value);
	keyboard_source_settings_update_input_sources_ibus (self);
	g_object_notify_by_pspec ((GObject *) self, keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY]);
}

static GObject *
keyboard_source_settings_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardSourceSettings * self;
	parent_class = G_OBJECT_CLASS (keyboard_source_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings);
	(self->priv->input_sources == NULL) ? NULL : (self->priv->input_sources = (_g_list_free__g_object_unref0_ (self->priv->input_sources), NULL));
	self->priv->input_sources = NULL;
	return obj;
}

static void
keyboard_source_settings_class_init (KeyboardSourceSettingsClass * klass,
                                     gpointer klass_data)
{
	keyboard_source_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardSourceSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_source_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_source_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_source_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_source_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY, keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY] = g_param_spec_uint ("active-index", "active-index", "active-index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SOURCE_SETTINGS_ACTIVE_INPUT_SOURCE_PROPERTY, keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_ACTIVE_INPUT_SOURCE_PROPERTY] = g_param_spec_object ("active-input-source", "active-input-source", "active-input-source", KEYBOARD_TYPE_INPUT_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY, keyboard_source_settings_properties[KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY] = g_param_spec_boxed ("active-engines", "active-engines", "active-engines", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	keyboard_source_settings_signals[KEYBOARD_SOURCE_SETTINGS_EXTERNAL_LAYOUT_CHANGE_SIGNAL] = g_signal_new ("external-layout-change", KEYBOARD_TYPE_SOURCE_SETTINGS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
keyboard_source_settings_instance_init (KeyboardSourceSettings * self,
                                        gpointer klass)
{
	self->priv = keyboard_source_settings_get_instance_private (self);
}

static void
keyboard_source_settings_finalize (GObject * obj)
{
	KeyboardSourceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings);
	self->priv->_active_engines = (_vala_array_free (self->priv->_active_engines, self->priv->_active_engines_length1, (GDestroyNotify) g_free), NULL);
	(self->priv->input_sources == NULL) ? NULL : (self->priv->input_sources = (_g_list_free__g_object_unref0_ (self->priv->input_sources), NULL));
	self->priv->xkb_options_modifiers = (_vala_array_free (self->priv->xkb_options_modifiers, self->priv->xkb_options_modifiers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (keyboard_source_settings_parent_class)->finalize (obj);
}

static GType
keyboard_source_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardSourceSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_source_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardSourceSettings), 0, (GInstanceInitFunc) keyboard_source_settings_instance_init, NULL };
	GType keyboard_source_settings_type_id;
	keyboard_source_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyboardSourceSettings", &g_define_type_info, 0);
	KeyboardSourceSettings_private_offset = g_type_add_instance_private (keyboard_source_settings_type_id, sizeof (KeyboardSourceSettingsPrivate));
	return keyboard_source_settings_type_id;
}

GType
keyboard_source_settings_get_type (void)
{
	static volatile gsize keyboard_source_settings_type_id__once = 0;
	if (g_once_init_enter (&keyboard_source_settings_type_id__once)) {
		GType keyboard_source_settings_type_id;
		keyboard_source_settings_type_id = keyboard_source_settings_get_type_once ();
		g_once_init_leave (&keyboard_source_settings_type_id__once, keyboard_source_settings_type_id);
	}
	return keyboard_source_settings_type_id__once;
}

static void
_vala_keyboard_source_settings_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	KeyboardSourceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings);
	switch (property_id) {
		case KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY:
		g_value_set_uint (value, keyboard_source_settings_get_active_index (self));
		break;
		case KEYBOARD_SOURCE_SETTINGS_ACTIVE_INPUT_SOURCE_PROPERTY:
		g_value_set_object (value, keyboard_source_settings_get_active_input_source (self));
		break;
		case KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, keyboard_source_settings_get_active_engines (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_source_settings_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	KeyboardSourceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings);
	switch (property_id) {
		case KEYBOARD_SOURCE_SETTINGS_ACTIVE_INDEX_PROPERTY:
		keyboard_source_settings_set_active_index (self, g_value_get_uint (value));
		break;
		case KEYBOARD_SOURCE_SETTINGS_ACTIVE_ENGINES_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			keyboard_source_settings_set_active_engines (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

