/* InfoBox.c generated by valac 0.56.17, the Vala compiler
 * generated from InfoBox.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * SPDX-FileCopyrightText: 2015-2024 elementary, Inc. (https://elementary.io)
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <float.h>
#include <math.h>

#define NETWORK_UNKNOWN_STR _ ("Unknown")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_INFO_BOX_0_PROPERTY,
	NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY,
	NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY,
	NETWORK_WIDGETS_INFO_BOX_NUM_PROPERTIES
};
static GParamSpec* network_widgets_info_box_properties[NETWORK_WIDGETS_INFO_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	NETWORK_WIDGETS_INFO_BOX_UPDATE_SIDEBAR_SIGNAL,
	NETWORK_WIDGETS_INFO_BOX_INFO_CHANGED_SIGNAL,
	NETWORK_WIDGETS_INFO_BOX_NUM_SIGNALS
};
static guint network_widgets_info_box_signals[NETWORK_WIDGETS_INFO_BOX_NUM_SIGNALS] = {0};

struct _NetworkWidgetsInfoBoxPrivate {
	NMDevice* _device;
	NetworkWidgetsDeviceItem* _owner;
	GtkBox* ip6address_box;
	GtkLabel* ip4address;
	GtkLabel* mask;
	GtkLabel* router;
	GtkLabel* dns;
	GtkLabel* sent;
	GtkLabel* received;
	GtkSwitch* auto_connect_switch;
	GtkSwitch* reduce_data_switch;
	GraniteHeaderLabel* ip6address_head;
	NMRemoteConnection* connection;
};

static gint NetworkWidgetsInfoBox_private_offset;
static gpointer network_widgets_info_box_parent_class = NULL;

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void network_widgets_info_box_commit_changes (NetworkWidgetsInfoBox* self);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void network_widgets_info_box_update_settings (NetworkWidgetsInfoBox* self);
static GObject * network_widgets_info_box_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _network_widgets_info_box_update_settings_nm_connection_changed (NMConnection* _sender,
                                                                      gpointer self);
static void _network_widgets_info_box___lambda6_ (NetworkWidgetsInfoBox* self);
static void __network_widgets_info_box___lambda6__nm_device_state_changed (NMDevice* _sender,
                                                                    guint new_state,
                                                                    guint old_state,
                                                                    guint reason,
                                                                    gpointer self);
static void _network_widgets_info_box___lambda7_ (NetworkWidgetsInfoBox* self);
static void __network_widgets_info_box___lambda7__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _network_widgets_info_box___lambda8_ (NetworkWidgetsInfoBox* self);
static void __network_widgets_info_box___lambda8__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void network_widgets_info_box_finalize (GObject * obj);
static GType network_widgets_info_box_get_type_once (void);
static void _vala_network_widgets_info_box_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_network_widgets_info_box_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
network_widgets_info_box_get_instance_private (NetworkWidgetsInfoBox* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsInfoBox_private_offset);
}

NetworkWidgetsInfoBox*
network_widgets_info_box_construct_from_device (GType object_type,
                                                NMDevice* device)
{
	NetworkWidgetsInfoBox * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (NetworkWidgetsInfoBox*) g_object_new (object_type, "device", device, NULL);
	return self;
}

NetworkWidgetsInfoBox*
network_widgets_info_box_new_from_device (NMDevice* device)
{
	return network_widgets_info_box_construct_from_device (NETWORK_WIDGETS_TYPE_INFO_BOX, device);
}

void
network_widgets_info_box_update_activity (NetworkWidgetsInfoBox* self,
                                          const gchar* sent_bytes,
                                          const gchar* received_bytes)
{
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sent_bytes != NULL);
	g_return_if_fail (received_bytes != NULL);
	_tmp0_ = sent_bytes;
	if (_tmp0_ == NULL) {
		_tmp0_ = NETWORK_UNKNOWN_STR;
	}
	_tmp1_ = self->priv->sent;
	gtk_label_set_label (_tmp1_, _tmp0_);
	_tmp2_ = received_bytes;
	if (_tmp2_ == NULL) {
		_tmp2_ = NETWORK_UNKNOWN_STR;
	}
	_tmp3_ = self->priv->received;
	gtk_label_set_label (_tmp3_, _tmp2_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
network_widgets_info_box_update_status (NetworkWidgetsInfoBox* self)
{
	NMIPConfig* ipv4 = NULL;
	NMDevice* _tmp0_;
	NMIPConfig* _tmp1_;
	NMIPConfig* _tmp2_;
	NMIPConfig* _tmp3_;
	NMIPConfig* ip6 = NULL;
	NMDevice* _tmp51_;
	NMIPConfig* _tmp52_;
	NMIPConfig* _tmp53_;
	GtkBox* _tmp54_;
	GraniteHeaderLabel* _tmp55_;
	NMIPConfig* _tmp56_;
	NMIPConfig* _tmp57_;
	NetworkWidgetsDeviceItem* _tmp78_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = nm_device_get_ip4_config (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ipv4 = _tmp2_;
	_tmp3_ = ipv4;
	if (_tmp3_ != NULL) {
		NMIPConfig* _tmp4_;
		GPtrArray* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		const gchar* _tmp19_ = NULL;
		NMIPConfig* _tmp20_;
		const gchar* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		NMIPConfig* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		_tmp4_ = ipv4;
		_tmp5_ = nm_ip_config_get_addresses (_tmp4_);
		_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ > 0) {
			NMIPAddress* address = NULL;
			NMIPConfig* _tmp8_;
			GPtrArray* _tmp9_;
			gconstpointer _tmp10_;
			GtkLabel* _tmp11_;
			NMIPAddress* _tmp12_;
			const gchar* _tmp13_;
			guint32 mask_addr = 0U;
			NMIPAddress* _tmp14_;
			struct in_addr source_addr = {0};
			struct in_addr _tmp15_ = {0};
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_;
			GtkLabel* _tmp18_;
			_tmp8_ = ipv4;
			_tmp9_ = nm_ip_config_get_addresses (_tmp8_);
			_tmp10_ = g_ptr_array_index (_tmp9_, (guint) 0);
			address = (NMIPAddress*) _tmp10_;
			_tmp11_ = self->priv->ip4address;
			_tmp12_ = address;
			_tmp13_ = nm_ip_address_get_address (_tmp12_);
			gtk_label_set_label (_tmp11_, _tmp13_);
			_tmp14_ = address;
			mask_addr = htonl (((guint32) 0xffffffffLL) << (32 - nm_ip_address_get_prefix (_tmp14_)));
			memset (&_tmp15_, 0, sizeof (struct in_addr));
			_tmp15_.s_addr = mask_addr;
			source_addr = _tmp15_;
			_tmp17_ = inet_ntoa (source_addr);
			_tmp16_ = _tmp17_;
			if (_tmp16_ == NULL) {
				_tmp16_ = NETWORK_UNKNOWN_STR;
			}
			_tmp18_ = self->priv->mask;
			gtk_label_set_label (_tmp18_, _tmp16_);
			 (source_addr);
		}
		_tmp20_ = ipv4;
		_tmp21_ = nm_ip_config_get_gateway (_tmp20_);
		_tmp19_ = _tmp21_;
		if (_tmp19_ == NULL) {
			_tmp19_ = NETWORK_UNKNOWN_STR;
		}
		_tmp22_ = self->priv->router;
		gtk_label_set_label (_tmp22_, _tmp19_);
		_tmp23_ = self->priv->dns;
		gtk_label_set_label (_tmp23_, "");
		_tmp24_ = ipv4;
		_tmp26_ = _tmp25_ = nm_ip_config_get_nameservers (_tmp24_);
		if (_vala_array_length (_tmp25_) > 0) {
			gchar** dns_addr = NULL;
			NMIPConfig* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			gint dns_addr_length1;
			gint _dns_addr_size_;
			GtkLabel* _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			const gchar* _tmp33_;
			_tmp27_ = ipv4;
			_tmp29_ = _tmp28_ = nm_ip_config_get_nameservers (_tmp27_);
			_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup1 (_tmp29_, _vala_array_length (_tmp28_)) : _tmp29_;
			_tmp30__length1 = _vala_array_length (_tmp28_);
			dns_addr = _tmp30_;
			dns_addr_length1 = _tmp30__length1;
			_dns_addr_size_ = dns_addr_length1;
			_tmp31_ = self->priv->dns;
			_tmp32_ = dns_addr;
			_tmp32__length1 = dns_addr_length1;
			_tmp33_ = _tmp32_[0];
			gtk_label_set_label (_tmp31_, _tmp33_);
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp34_ = FALSE;
					_tmp34_ = TRUE;
					while (TRUE) {
						gchar** _tmp36_;
						gint _tmp36__length1;
						GtkLabel* _tmp37_;
						GtkLabel* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar** _tmp43_;
						gint _tmp43__length1;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						if (!_tmp34_) {
							gint _tmp35_;
							_tmp35_ = i;
							i = _tmp35_ + 1;
						}
						_tmp34_ = FALSE;
						_tmp36_ = dns_addr;
						_tmp36__length1 = dns_addr_length1;
						if (!(i < _tmp36__length1)) {
							break;
						}
						_tmp37_ = self->priv->dns;
						_tmp38_ = self->priv->dns;
						_tmp39_ = gtk_label_get_label (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strconcat (_tmp40_, ", ", NULL);
						_tmp42_ = _tmp41_;
						_tmp43_ = dns_addr;
						_tmp43__length1 = dns_addr_length1;
						_tmp44_ = _tmp43_[i];
						_tmp45_ = g_strconcat (_tmp42_, _tmp44_, NULL);
						_tmp46_ = _tmp45_;
						gtk_label_set_label (_tmp37_, _tmp46_);
						_g_free0 (_tmp46_);
						_g_free0 (_tmp42_);
					}
				}
			}
			dns_addr = (_vala_array_free (dns_addr, dns_addr_length1, (GDestroyNotify) g_free), NULL);
		}
	} else {
		GtkLabel* _tmp47_;
		GtkLabel* _tmp48_;
		GtkLabel* _tmp49_;
		GtkLabel* _tmp50_;
		_tmp47_ = self->priv->ip4address;
		gtk_label_set_label (_tmp47_, NETWORK_UNKNOWN_STR);
		_tmp48_ = self->priv->mask;
		gtk_label_set_label (_tmp48_, NETWORK_UNKNOWN_STR);
		_tmp49_ = self->priv->router;
		gtk_label_set_label (_tmp49_, NETWORK_UNKNOWN_STR);
		_tmp50_ = self->priv->dns;
		gtk_label_set_label (_tmp50_, NETWORK_UNKNOWN_STR);
	}
	_tmp51_ = self->priv->_device;
	_tmp52_ = nm_device_get_ip6_config (_tmp51_);
	_tmp53_ = _g_object_ref0 (_tmp52_);
	ip6 = _tmp53_;
	_tmp54_ = self->priv->ip6address_box;
	_tmp55_ = self->priv->ip6address_head;
	_tmp56_ = ip6;
	gtk_widget_set_visible ((GtkWidget*) _tmp55_, _tmp56_ != NULL);
	gtk_widget_set_visible ((GtkWidget*) _tmp54_, _tmp56_ != NULL);
	_tmp57_ = ip6;
	if (_tmp57_ != NULL) {
		NMIPConfig* _tmp63_;
		GPtrArray* _tmp64_;
		while (TRUE) {
			GtkBox* _tmp58_;
			GtkWidget* _tmp59_;
			GtkBox* _tmp60_;
			GtkBox* _tmp61_;
			GtkWidget* _tmp62_;
			_tmp58_ = self->priv->ip6address_box;
			_tmp59_ = gtk_widget_get_first_child ((GtkWidget*) _tmp58_);
			if (!(_tmp59_ != NULL)) {
				break;
			}
			_tmp60_ = self->priv->ip6address_box;
			_tmp61_ = self->priv->ip6address_box;
			_tmp62_ = gtk_widget_get_first_child ((GtkWidget*) _tmp61_);
			gtk_box_remove (_tmp60_, _tmp62_);
		}
		_tmp63_ = ip6;
		_tmp64_ = nm_ip_config_get_addresses (_tmp63_);
		{
			GPtrArray* address_collection = NULL;
			guint address_index = 0U;
			address_collection = _tmp64_;
			for (address_index = 0; address_index < address_collection->len; address_index = address_index + 1) {
				NMIPAddress* address = NULL;
				address = (NMIPAddress*) g_ptr_array_index (address_collection, address_index);
				{
					gchar* inet_str = NULL;
					NMIPAddress* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					NMIPAddress* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					GtkLabel* address_label = NULL;
					const gchar* _tmp74_;
					GtkLabel* _tmp75_ = NULL;
					GtkBox* _tmp76_;
					GtkLabel* _tmp77_;
					_tmp65_ = address;
					_tmp66_ = nm_ip_address_get_address (_tmp65_);
					_tmp67_ = g_strconcat (_tmp66_, "/", NULL);
					_tmp68_ = _tmp67_;
					_tmp69_ = address;
					_tmp70_ = g_strdup_printf ("%u", nm_ip_address_get_prefix (_tmp69_));
					_tmp71_ = _tmp70_;
					_tmp72_ = g_strconcat (_tmp68_, _tmp71_, NULL);
					_tmp73_ = _tmp72_;
					_g_free0 (_tmp71_);
					_g_free0 (_tmp68_);
					inet_str = _tmp73_;
					_tmp74_ = inet_str;
					_tmp75_ = (GtkLabel*) gtk_label_new (_tmp74_);
					gtk_label_set_selectable (_tmp75_, TRUE);
					gtk_label_set_xalign (_tmp75_, (gfloat) 0);
					g_object_ref_sink (_tmp75_);
					address_label = _tmp75_;
					_tmp76_ = self->priv->ip6address_box;
					_tmp77_ = address_label;
					gtk_box_append (_tmp76_, (GtkWidget*) _tmp77_);
					_g_object_unref0 (address_label);
					_g_free0 (inet_str);
				}
			}
		}
	}
	_tmp78_ = self->priv->_owner;
	if (_tmp78_ != NULL) {
		NetworkWidgetsDeviceItem* _tmp79_;
		_tmp79_ = self->priv->_owner;
		g_signal_emit (self, network_widgets_info_box_signals[NETWORK_WIDGETS_INFO_BOX_UPDATE_SIDEBAR_SIGNAL], 0, _tmp79_);
	}
	_g_object_unref0 (ip6);
	_g_object_unref0 (ipv4);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
network_widgets_info_box_commit_changes (NetworkWidgetsInfoBox* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		NMRemoteConnection* _tmp0_;
		_tmp0_ = self->priv->connection;
		nm_remote_connection_commit_changes_async (_tmp0_, TRUE, NULL, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GtkRoot* _tmp1_;
		GtkWindow* _tmp2_;
		GraniteMessageDialog* _tmp3_ = NULL;
		GraniteMessageDialog* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
		_tmp3_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Failed To Configure Settings"), _ ("Unable to save changes to the disk"), "network-error", GTK_BUTTONS_CLOSE);
		gtk_window_set_modal ((GtkWindow*) _tmp3_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
		_g_object_unref0 (_tmp2_);
		g_object_ref_sink (_tmp3_);
		message_dialog = _tmp3_;
		_tmp4_ = message_dialog;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		granite_message_dialog_show_error_details (_tmp4_, _tmp6_);
		_tmp7_ = message_dialog;
		_tmp8_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp7_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp8_, 0);
		_tmp9_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp9_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
network_widgets_info_box_update_settings (NetworkWidgetsInfoBox* self)
{
	NMSettingConnection* setting_connection = NULL;
	NMRemoteConnection* _tmp0_;
	NMSettingConnection* _tmp1_;
	NMSettingConnection* _tmp2_;
	GtkSwitch* _tmp3_;
	NMSettingConnection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_ = FALSE;
	NMSettingConnection* _tmp8_;
	NMMetered _tmp9_;
	NMMetered _tmp10_;
	GtkSwitch* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connection;
	_tmp1_ = nm_connection_get_setting_connection ((NMConnection*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	setting_connection = _tmp2_;
	_tmp3_ = self->priv->auto_connect_switch;
	_tmp4_ = setting_connection;
	g_object_get (_tmp4_, "autoconnect", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	gtk_switch_set_active (_tmp3_, _tmp6_);
	_tmp8_ = setting_connection;
	g_object_get (_tmp8_, "metered", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == NM_METERED_YES) {
		_tmp7_ = TRUE;
	} else {
		NMSettingConnection* _tmp11_;
		NMMetered _tmp12_;
		NMMetered _tmp13_;
		_tmp11_ = setting_connection;
		g_object_get (_tmp11_, "metered", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp7_ = _tmp13_ == NM_METERED_GUESS_YES;
	}
	_tmp14_ = self->priv->reduce_data_switch;
	gtk_switch_set_active (_tmp14_, _tmp7_);
	_g_object_unref0 (setting_connection);
}

NetworkWidgetsInfoBox*
network_widgets_info_box_construct (GType object_type)
{
	NetworkWidgetsInfoBox * self = NULL;
	self = (NetworkWidgetsInfoBox*) g_object_new (object_type, NULL);
	return self;
}

NetworkWidgetsInfoBox*
network_widgets_info_box_new (void)
{
	return network_widgets_info_box_construct (NETWORK_WIDGETS_TYPE_INFO_BOX);
}

NMDevice*
network_widgets_info_box_get_device (NetworkWidgetsInfoBox* self)
{
	NMDevice* result;
	NMDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
network_widgets_info_box_set_device (NetworkWidgetsInfoBox* self,
                                     NMDevice* value)
{
	NMDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_info_box_get_device (self);
	if (old_value != value) {
		NMDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_info_box_properties[NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY]);
	}
}

NetworkWidgetsDeviceItem*
network_widgets_info_box_get_owner (NetworkWidgetsInfoBox* self)
{
	NetworkWidgetsDeviceItem* result;
	NetworkWidgetsDeviceItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}

static void
network_widgets_info_box_set_owner (NetworkWidgetsInfoBox* self,
                                    NetworkWidgetsDeviceItem* value)
{
	NetworkWidgetsDeviceItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_info_box_get_owner (self);
	if (old_value != value) {
		NetworkWidgetsDeviceItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_owner);
		self->priv->_owner = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_info_box_properties[NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY]);
	}
}

static void
_network_widgets_info_box_update_settings_nm_connection_changed (NMConnection* _sender,
                                                                 gpointer self)
{
	network_widgets_info_box_update_settings ((NetworkWidgetsInfoBox*) self);
}

static void
_network_widgets_info_box___lambda6_ (NetworkWidgetsInfoBox* self)
{
	network_widgets_info_box_update_status (self);
	g_signal_emit (self, network_widgets_info_box_signals[NETWORK_WIDGETS_INFO_BOX_INFO_CHANGED_SIGNAL], 0);
}

static void
__network_widgets_info_box___lambda6__nm_device_state_changed (NMDevice* _sender,
                                                               guint new_state,
                                                               guint old_state,
                                                               guint reason,
                                                               gpointer self)
{
	_network_widgets_info_box___lambda6_ ((NetworkWidgetsInfoBox*) self);
}

static void
_network_widgets_info_box___lambda7_ (NetworkWidgetsInfoBox* self)
{
	NMSettingConnection* setting_connection = NULL;
	NMRemoteConnection* _tmp0_;
	NMSettingConnection* _tmp1_;
	NMSettingConnection* _tmp2_;
	NMSettingConnection* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkSwitch* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	NMSettingConnection* _tmp9_;
	GtkSwitch* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GValue _tmp13_ = {0};
	_tmp0_ = self->priv->connection;
	_tmp1_ = nm_connection_get_setting_connection ((NMConnection*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	setting_connection = _tmp2_;
	_tmp3_ = setting_connection;
	g_object_get (_tmp3_, "autoconnect", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->auto_connect_switch;
	_tmp7_ = gtk_switch_get_active (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ == _tmp8_) {
		_g_object_unref0 (setting_connection);
		return;
	}
	_tmp9_ = setting_connection;
	_tmp10_ = self->priv->auto_connect_switch;
	_tmp11_ = gtk_switch_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	g_value_init (&_tmp13_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp13_, _tmp12_);
	g_object_set_property ((GObject*) _tmp9_, NM_SETTING_CONNECTION_AUTOCONNECT, &_tmp13_);
	G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
	network_widgets_info_box_commit_changes (self);
	_g_object_unref0 (setting_connection);
}

static void
__network_widgets_info_box___lambda7__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_network_widgets_info_box___lambda7_ ((NetworkWidgetsInfoBox*) self);
}

static void
_network_widgets_info_box___lambda8_ (NetworkWidgetsInfoBox* self)
{
	NMSettingConnection* setting_connection = NULL;
	NMRemoteConnection* _tmp0_;
	NMSettingConnection* _tmp1_;
	NMSettingConnection* _tmp2_;
	NMMetered metered = 0;
	NMSettingConnection* _tmp3_;
	NMMetered _tmp4_;
	NMMetered _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkSwitch* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	NMSettingConnection* _tmp16_;
	GValue _tmp17_ = {0};
	_tmp0_ = self->priv->connection;
	_tmp1_ = nm_connection_get_setting_connection ((NMConnection*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	setting_connection = _tmp2_;
	_tmp3_ = setting_connection;
	g_object_get (_tmp3_, "metered", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	metered = _tmp5_;
	_tmp8_ = self->priv->reduce_data_switch;
	_tmp9_ = gtk_switch_get_active (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		_tmp7_ = metered != NM_METERED_YES;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = metered != NM_METERED_GUESS_YES;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		metered = NM_METERED_YES;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		GtkSwitch* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = self->priv->reduce_data_switch;
		_tmp14_ = gtk_switch_get_active (_tmp13_);
		_tmp15_ = _tmp14_;
		if (!_tmp15_) {
			_tmp12_ = metered != NM_METERED_NO;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = metered != NM_METERED_GUESS_NO;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			metered = NM_METERED_NO;
		}
	}
	_tmp16_ = setting_connection;
	g_value_init (&_tmp17_, nm_metered_get_type ());
	g_value_set_enum (&_tmp17_, metered);
	g_object_set_property ((GObject*) _tmp16_, NM_SETTING_CONNECTION_METERED, &_tmp17_);
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	network_widgets_info_box_commit_changes (self);
	_g_object_unref0 (setting_connection);
}

static void
__network_widgets_info_box___lambda8__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_network_widgets_info_box___lambda8_ ((NetworkWidgetsInfoBox*) self);
}

static GObject *
network_widgets_info_box_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsInfoBox * self;
	GtkImage* sent_image = NULL;
	gchar* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkImage* received_image = NULL;
	gchar* _tmp3_;
	GtkImage* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkBox* send_receive_box = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkImage* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GraniteHeaderLabel* ip4address_head = NULL;
	GraniteHeaderLabel* _tmp15_;
	GtkLabel* _tmp16_ = NULL;
	GraniteHeaderLabel* _tmp17_;
	GtkBox* _tmp18_;
	GraniteHeaderLabel* mask_head = NULL;
	GraniteHeaderLabel* _tmp19_;
	GtkLabel* _tmp20_ = NULL;
	GraniteHeaderLabel* router_head = NULL;
	GraniteHeaderLabel* _tmp21_;
	GtkLabel* _tmp22_ = NULL;
	GraniteHeaderLabel* dns_head = NULL;
	GraniteHeaderLabel* _tmp23_;
	GtkLabel* _tmp24_ = NULL;
	GtkSwitch* _tmp25_ = NULL;
	GraniteHeaderLabel* reduce_data_header = NULL;
	GtkSwitch* _tmp26_;
	GtkWidget* _tmp27_;
	gchar* _tmp28_;
	GraniteHeaderLabel* _tmp29_ = NULL;
	GtkBox* reduce_data_box = NULL;
	GtkBox* _tmp30_ = NULL;
	GtkBox* _tmp31_;
	GraniteHeaderLabel* _tmp32_;
	GtkBox* _tmp33_;
	GtkSwitch* _tmp34_;
	GtkSwitch* _tmp35_ = NULL;
	GraniteHeaderLabel* auto_connect_header = NULL;
	GtkSwitch* _tmp36_;
	GtkWidget* _tmp37_;
	GraniteHeaderLabel* _tmp38_ = NULL;
	GtkBox* auto_connect_box = NULL;
	GtkBox* _tmp39_ = NULL;
	GtkBox* _tmp40_;
	GraniteHeaderLabel* _tmp41_;
	GtkBox* _tmp42_;
	GtkSwitch* _tmp43_;
	GraniteHeaderLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GraniteHeaderLabel* _tmp46_;
	GtkBox* _tmp47_;
	GraniteHeaderLabel* _tmp48_;
	GtkLabel* _tmp49_;
	GraniteHeaderLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GraniteHeaderLabel* _tmp52_;
	GtkLabel* _tmp53_;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	NMDevice* _tmp57_;
	NMActiveConnection* _tmp58_;
	NMRemoteConnection* _tmp59_;
	NMRemoteConnection* _tmp60_;
	NMRemoteConnection* _tmp61_;
	NMRemoteConnection* _tmp62_;
	NMDevice* _tmp63_;
	GtkSwitch* _tmp64_;
	GtkSwitch* _tmp65_;
	parent_class = G_OBJECT_CLASS (network_widgets_info_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_INFO_BOX, NetworkWidgetsInfoBox);
	_tmp0_ = g_strdup (_ ("Sent"));
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("go-up-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	sent_image = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->sent);
	self->priv->sent = _tmp2_;
	_tmp3_ = g_strdup (_ ("Received"));
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("go-down-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	received_image = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->received);
	self->priv->received = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 12);
	g_object_ref_sink (_tmp6_);
	send_receive_box = _tmp6_;
	_tmp7_ = send_receive_box;
	_tmp8_ = sent_image;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = send_receive_box;
	_tmp10_ = self->priv->sent;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = send_receive_box;
	_tmp12_ = received_image;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = send_receive_box;
	_tmp14_ = self->priv->received;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = granite_header_label_new (_ ("IP Address"));
	g_object_ref_sink (_tmp15_);
	ip4address_head = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_selectable (_tmp16_, TRUE);
	gtk_label_set_xalign (_tmp16_, (gfloat) 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->ip4address);
	self->priv->ip4address = _tmp16_;
	_tmp17_ = granite_header_label_new (_ ("IPv6 Addresses"));
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->ip6address_head);
	self->priv->ip6address_head = _tmp17_;
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->ip6address_box);
	self->priv->ip6address_box = _tmp18_;
	_tmp19_ = granite_header_label_new (_ ("Subnet Mask"));
	g_object_ref_sink (_tmp19_);
	mask_head = _tmp19_;
	_tmp20_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_selectable (_tmp20_, TRUE);
	gtk_label_set_xalign (_tmp20_, (gfloat) 0);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->mask);
	self->priv->mask = _tmp20_;
	_tmp21_ = granite_header_label_new (_ ("Router"));
	g_object_ref_sink (_tmp21_);
	router_head = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_selectable (_tmp22_, TRUE);
	gtk_label_set_xalign (_tmp22_, (gfloat) 0);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->router);
	self->priv->router = _tmp22_;
	_tmp23_ = granite_header_label_new (_ ("DNS"));
	g_object_ref_sink (_tmp23_);
	dns_head = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_selectable (_tmp24_, TRUE);
	gtk_label_set_xalign (_tmp24_, (gfloat) 0);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->dns);
	self->priv->dns = _tmp24_;
	_tmp25_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp25_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->reduce_data_switch);
	self->priv->reduce_data_switch = _tmp25_;
	_tmp26_ = self->priv->reduce_data_switch;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = g_strdup (_ ("While connected to this network, background tasks like automatic updat" \
"es will be paused."));
	_tmp29_ = granite_header_label_new (_ ("Reduce background data usage"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp29_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp29_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	granite_header_label_set_secondary_text (_tmp29_, _tmp28_);
	_g_free0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	reduce_data_header = _tmp29_;
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp30_, 24);
	g_object_ref_sink (_tmp30_);
	reduce_data_box = _tmp30_;
	_tmp31_ = reduce_data_box;
	_tmp32_ = reduce_data_header;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = reduce_data_box;
	_tmp34_ = self->priv->reduce_data_switch;
	gtk_box_append (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp35_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->auto_connect_switch);
	self->priv->auto_connect_switch = _tmp35_;
	_tmp36_ = self->priv->auto_connect_switch;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = granite_header_label_new (_ ("Automatically connect"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp38_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	gtk_widget_set_valign ((GtkWidget*) _tmp38_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp38_);
	auto_connect_header = _tmp38_;
	_tmp39_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp39_, 12);
	g_object_ref_sink (_tmp39_);
	auto_connect_box = _tmp39_;
	_tmp40_ = auto_connect_box;
	_tmp41_ = auto_connect_header;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = auto_connect_box;
	_tmp43_ = self->priv->auto_connect_switch;
	gtk_box_append (_tmp42_, (GtkWidget*) _tmp43_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp44_ = ip4address_head;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->ip4address;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->ip6address_head;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->ip6address_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp47_);
	_tmp48_ = mask_head;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->mask;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp49_);
	_tmp50_ = router_head;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->router;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp51_);
	_tmp52_ = dns_head;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp52_);
	_tmp53_ = self->priv->dns;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp53_);
	_tmp54_ = send_receive_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp54_);
	_tmp55_ = reduce_data_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp55_);
	_tmp56_ = auto_connect_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp56_);
	_tmp57_ = self->priv->_device;
	_tmp58_ = nm_device_get_active_connection (_tmp57_);
	_tmp59_ = nm_active_connection_get_connection (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = _g_object_ref0 (_tmp60_);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp61_;
	_tmp62_ = self->priv->connection;
	g_signal_connect_object ((NMConnection*) _tmp62_, "changed", (GCallback) _network_widgets_info_box_update_settings_nm_connection_changed, self, 0);
	_tmp63_ = self->priv->_device;
	g_signal_connect_object (_tmp63_, "state-changed", (GCallback) __network_widgets_info_box___lambda6__nm_device_state_changed, self, 0);
	network_widgets_info_box_update_settings (self);
	network_widgets_info_box_update_status (self);
	_tmp64_ = self->priv->auto_connect_switch;
	g_signal_connect_object ((GObject*) _tmp64_, "notify::active", (GCallback) __network_widgets_info_box___lambda7__g_object_notify, self, 0);
	_tmp65_ = self->priv->reduce_data_switch;
	g_signal_connect_object ((GObject*) _tmp65_, "notify::active", (GCallback) __network_widgets_info_box___lambda8__g_object_notify, self, 0);
	_g_object_unref0 (auto_connect_box);
	_g_object_unref0 (auto_connect_header);
	_g_object_unref0 (reduce_data_box);
	_g_object_unref0 (reduce_data_header);
	_g_object_unref0 (dns_head);
	_g_object_unref0 (router_head);
	_g_object_unref0 (mask_head);
	_g_object_unref0 (ip4address_head);
	_g_object_unref0 (send_receive_box);
	_g_object_unref0 (received_image);
	_g_object_unref0 (sent_image);
	return obj;
}

static void
network_widgets_info_box_class_init (NetworkWidgetsInfoBoxClass * klass,
                                     gpointer klass_data)
{
	network_widgets_info_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsInfoBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_info_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_info_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_info_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_info_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY, network_widgets_info_box_properties[NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", nm_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY, network_widgets_info_box_properties[NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY] = g_param_spec_object ("owner", "owner", "owner", NETWORK_WIDGETS_TYPE_DEVICE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	network_widgets_info_box_signals[NETWORK_WIDGETS_INFO_BOX_UPDATE_SIDEBAR_SIGNAL] = g_signal_new ("update-sidebar", NETWORK_WIDGETS_TYPE_INFO_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETWORK_WIDGETS_TYPE_DEVICE_ITEM);
	network_widgets_info_box_signals[NETWORK_WIDGETS_INFO_BOX_INFO_CHANGED_SIGNAL] = g_signal_new ("info-changed", NETWORK_WIDGETS_TYPE_INFO_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
network_widgets_info_box_instance_init (NetworkWidgetsInfoBox * self,
                                        gpointer klass)
{
	self->priv = network_widgets_info_box_get_instance_private (self);
}

static void
network_widgets_info_box_finalize (GObject * obj)
{
	NetworkWidgetsInfoBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_INFO_BOX, NetworkWidgetsInfoBox);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->_owner);
	_g_object_unref0 (self->priv->ip6address_box);
	_g_object_unref0 (self->priv->ip4address);
	_g_object_unref0 (self->priv->mask);
	_g_object_unref0 (self->priv->router);
	_g_object_unref0 (self->priv->dns);
	_g_object_unref0 (self->priv->sent);
	_g_object_unref0 (self->priv->received);
	_g_object_unref0 (self->priv->auto_connect_switch);
	_g_object_unref0 (self->priv->reduce_data_switch);
	_g_object_unref0 (self->priv->ip6address_head);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (network_widgets_info_box_parent_class)->finalize (obj);
}

static GType
network_widgets_info_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsInfoBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_info_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsInfoBox), 0, (GInstanceInitFunc) network_widgets_info_box_instance_init, NULL };
	GType network_widgets_info_box_type_id;
	network_widgets_info_box_type_id = g_type_register_static (gtk_box_get_type (), "NetworkWidgetsInfoBox", &g_define_type_info, 0);
	NetworkWidgetsInfoBox_private_offset = g_type_add_instance_private (network_widgets_info_box_type_id, sizeof (NetworkWidgetsInfoBoxPrivate));
	return network_widgets_info_box_type_id;
}

GType
network_widgets_info_box_get_type (void)
{
	static volatile gsize network_widgets_info_box_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_info_box_type_id__once)) {
		GType network_widgets_info_box_type_id;
		network_widgets_info_box_type_id = network_widgets_info_box_get_type_once ();
		g_once_init_leave (&network_widgets_info_box_type_id__once, network_widgets_info_box_type_id);
	}
	return network_widgets_info_box_type_id__once;
}

static void
_vala_network_widgets_info_box_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	NetworkWidgetsInfoBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_INFO_BOX, NetworkWidgetsInfoBox);
	switch (property_id) {
		case NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY:
		g_value_set_object (value, network_widgets_info_box_get_device (self));
		break;
		case NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY:
		g_value_set_object (value, network_widgets_info_box_get_owner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_info_box_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	NetworkWidgetsInfoBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_INFO_BOX, NetworkWidgetsInfoBox);
	switch (property_id) {
		case NETWORK_WIDGETS_INFO_BOX_DEVICE_PROPERTY:
		network_widgets_info_box_set_device (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_INFO_BOX_OWNER_PROPERTY:
		network_widgets_info_box_set_owner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

