/* MainView.c generated by valac 0.56.17, the Vala compiler
 * generated from MainView.vala, do not modify */

/*
 * Copyright (c) 2015-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <NetworkManager.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_MAIN_VIEW_0_PROPERTY,
	NETWORK_MAIN_VIEW_STATE_PROPERTY,
	NETWORK_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* network_main_view_properties[NETWORK_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define NETWORK_MAIN_VIEW_TYPE_SIDEBAR (network_main_view_sidebar_get_type ())
#define NETWORK_MAIN_VIEW_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETWORK_MAIN_VIEW_TYPE_SIDEBAR, NetworkMainViewSidebar))
#define NETWORK_MAIN_VIEW_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETWORK_MAIN_VIEW_TYPE_SIDEBAR, NetworkMainViewSidebarClass))
#define NETWORK_MAIN_VIEW_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETWORK_MAIN_VIEW_TYPE_SIDEBAR))
#define NETWORK_MAIN_VIEW_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETWORK_MAIN_VIEW_TYPE_SIDEBAR))
#define NETWORK_MAIN_VIEW_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETWORK_MAIN_VIEW_TYPE_SIDEBAR, NetworkMainViewSidebarClass))

typedef struct _NetworkMainViewSidebar NetworkMainViewSidebar;
typedef struct _NetworkMainViewSidebarClass NetworkMainViewSidebarClass;
typedef struct _NetworkMainViewSidebarPrivate NetworkMainViewSidebarPrivate;
enum  {
	NETWORK_MAIN_VIEW_SIDEBAR_0_PROPERTY,
	NETWORK_MAIN_VIEW_SIDEBAR_NUM_PROPERTIES
};
static GParamSpec* network_main_view_sidebar_properties[NETWORK_MAIN_VIEW_SIDEBAR_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _NetworkMainViewPrivate {
	NMDeviceState _state;
	GraniteHeaderLabel* devices_header;
	GraniteHeaderLabel* virtual_header;
	GtkListBox* device_list;
	GtkStack* content;
	NMDevice* current_device;
	NetworkVPNPage* vpn_page;
};

struct _NetworkMainViewSidebar {
	GtkBox parent_instance;
	NetworkMainViewSidebarPrivate * priv;
};

struct _NetworkMainViewSidebarClass {
	GtkBoxClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	NetworkMainView* self;
	GtkSwitch* airplane_switch;
	NMClient* nm_client;
};

static gint NetworkMainView_private_offset;
static gpointer network_main_view_parent_class = NULL;
static gpointer network_main_view_sidebar_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void network_main_view_device_removed_cb (NetworkMainView* self,
                                          NMDevice* device);
static void network_main_view_remove_interface (NetworkMainView* self,
                                         NetworkWidgetsPage* widget_interface);
static void network_main_view_update_interfaces_names (NetworkMainView* self);
static gint* _int_dup (gint* self);
static void network_main_view_connection_added_cb (NetworkMainView* self,
                                            NMRemoteConnection* connection);
static void network_main_view_connection_removed_cb (NetworkMainView* self,
                                              NMRemoteConnection* connection);
static void network_main_view_device_added_cb (NetworkMainView* self,
                                        NMDevice* device);
static void network_main_view_add_interface (NetworkMainView* self,
                                      NetworkWidgetsPage* page);
static void network_main_view_update_state (NetworkMainView* self);
static void _network_main_view_update_state_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void network_main_view_set_state (NetworkMainView* self,
                                  NMDeviceState value);
static void network_main_view_update_networking_state (NetworkMainView* self);
static void network_main_view_remove_iface_from_list (NetworkMainView* self,
                                               NetworkWidgetsPage* iface);
static gint network_main_view_sort_func (NetworkMainView* self,
                                  GtkListBoxRow* row1,
                                  GtkListBoxRow* row2);
static void network_main_view_update_headers (NetworkMainView* self,
                                       GtkListBoxRow* row,
                                       GtkListBoxRow* before);
static GType network_main_view_sidebar_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NetworkMainViewSidebar* network_main_view_sidebar_new (void);
static NetworkMainViewSidebar* network_main_view_sidebar_construct (GType object_type);
static GObject * network_main_view_sidebar_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static GType network_main_view_sidebar_get_type_once (void);
static GObject * network_main_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint _network_main_view_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self);
static void _network_main_view_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                        GtkListBoxRow* before,
                                                                        gpointer self);
static void _network_main_view___lambda46_ (NetworkMainView* self,
                                     GtkListBoxRow* row);
static void __network_main_view___lambda46__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                GtkListBoxRow* row,
                                                                gpointer self);
static void _network_main_view___lambda47_ (NetworkMainView* self,
                                     GtkListBoxRow* row);
static void __network_main_view___lambda47__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self);
static void _network_main_view_connection_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                        NMRemoteConnection* connection,
                                                                        gpointer self);
static void _network_main_view_connection_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                            NMRemoteConnection* connection,
                                                                            gpointer self);
static void _network_main_view_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                                NMDevice* device,
                                                                gpointer self);
static void _network_main_view_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                                    NMDevice* device,
                                                                    gpointer self);
static void _network_main_view___lambda48_ (NetworkMainView* self,
                                     NMDevice* device);
static void __network_main_view___lambda48__gfunc (gconstpointer data,
                                            gpointer self);
static void _network_main_view___lambda49_ (NetworkMainView* self,
                                     NMRemoteConnection* connection);
static void __network_main_view___lambda49__gfunc (gconstpointer data,
                                            gpointer self);
static void _network_main_view_update_networking_state_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _network_main_view___lambda50_ (Block2Data* _data2_);
static GVariant* _variant_new1 (gboolean value);
static void __lambda51_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda51__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __network_main_view___lambda50__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void network_main_view_finalize (GObject * obj);
static GType network_main_view_get_type_once (void);
static void _vala_network_main_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_network_main_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
network_main_view_get_instance_private (NetworkMainView* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkMainView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
network_main_view_device_removed_cb (NetworkMainView* self,
                                     NMDevice* device)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->network_interface;
	{
		GList* widget_interface_collection = NULL;
		GList* widget_interface_it = NULL;
		widget_interface_collection = _tmp0_;
		for (widget_interface_it = widget_interface_collection; widget_interface_it != NULL; widget_interface_it = widget_interface_it->next) {
			NetworkWidgetsPage* _tmp1_;
			NetworkWidgetsPage* widget_interface = NULL;
			_tmp1_ = _g_object_ref0 ((NetworkWidgetsPage*) widget_interface_it->data);
			widget_interface = _tmp1_;
			{
				NetworkWidgetsPage* _tmp2_;
				NMDevice* _tmp3_;
				NMDevice* _tmp4_;
				_tmp2_ = widget_interface;
				_tmp3_ = network_widgets_page_get_device (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == device) {
					NetworkWidgetsPage* _tmp5_;
					NetworkWidgetsPage* _tmp6_;
					_tmp5_ = widget_interface;
					self->network_interface = vala_g_list_remove_full (self->network_interface, _tmp5_, _g_object_unref0_);
					_tmp6_ = widget_interface;
					network_main_view_remove_interface (self, _tmp6_);
					_g_object_unref0 (widget_interface);
					break;
				}
				_g_object_unref0 (widget_interface);
			}
		}
	}
	network_main_view_update_interfaces_names (self);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static void
network_main_view_update_interfaces_names (NetworkMainView* self)
{
	GeeHashMap* count_type = NULL;
	GeeHashMap* _tmp0_;
	GList* _tmp1_;
	GList* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, (GBoxedCopyFunc) _int_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	count_type = _tmp0_;
	_tmp1_ = self->network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp1_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetsPage* _tmp2_;
			NetworkWidgetsPage* iface = NULL;
			_tmp2_ = _g_object_ref0 ((NetworkWidgetsPage*) iface_it->data);
			iface = _tmp2_;
			{
				gchar* type = NULL;
				NetworkWidgetsPage* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				GeeHashMap* _tmp6_;
				const gchar* _tmp7_;
				_tmp3_ = iface;
				_tmp4_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp3_));
				_tmp5_ = g_strdup (_tmp4_);
				type = _tmp5_;
				_tmp6_ = count_type;
				_tmp7_ = type;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_)) {
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					GeeHashMap* _tmp10_;
					const gchar* _tmp11_;
					gpointer _tmp12_;
					gint* _tmp13_;
					gint _tmp14_;
					_tmp8_ = count_type;
					_tmp9_ = type;
					_tmp10_ = count_type;
					_tmp11_ = type;
					_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
					_tmp13_ = (gint*) _tmp12_;
					_tmp14_ = (*_tmp13_) + 1;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, &_tmp14_);
					_g_free0 (_tmp13_);
				} else {
					GeeHashMap* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					_tmp15_ = count_type;
					_tmp16_ = type;
					_tmp17_ = 1;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, &_tmp17_);
				}
				_g_free0 (type);
				_g_object_unref0 (iface);
			}
		}
	}
	_tmp18_ = self->network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp18_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetsPage* _tmp19_;
			NetworkWidgetsPage* iface = NULL;
			_tmp19_ = _g_object_ref0 ((NetworkWidgetsPage*) iface_it->data);
			iface = _tmp19_;
			{
				gchar* type = NULL;
				NetworkWidgetsPage* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				NetworkWidgetsPage* _tmp23_;
				GeeHashMap* _tmp24_;
				const gchar* _tmp25_;
				gpointer _tmp26_;
				gint* _tmp27_;
				_tmp20_ = iface;
				_tmp21_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp20_));
				_tmp22_ = g_strdup (_tmp21_);
				type = _tmp22_;
				_tmp23_ = iface;
				_tmp24_ = count_type;
				_tmp25_ = type;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				_tmp27_ = (gint*) _tmp26_;
				network_widgets_page_update_name (_tmp23_, *_tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (type);
				_g_object_unref0 (iface);
			}
		}
	}
	_g_object_unref0 (count_type);
}

static void
network_main_view_connection_added_cb (NetworkMainView* self,
                                       NMRemoteConnection* connection)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = nm_connection_get_connection_type ((NMConnection*) connection);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string (NM_SETTING_WIREGUARD_SETTING_NAME)))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string (NM_SETTING_VPN_SETTING_NAME))))) {
		switch (0) {
			default:
			{
				NetworkVPNPage* _tmp4_;
				_tmp4_ = self->priv->vpn_page;
				network_vpn_page_add_connection (_tmp4_, connection);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
network_main_view_connection_removed_cb (NetworkMainView* self,
                                         NMRemoteConnection* connection)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = nm_connection_get_connection_type ((NMConnection*) connection);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string (NM_SETTING_WIREGUARD_SETTING_NAME)))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string (NM_SETTING_VPN_SETTING_NAME))))) {
		switch (0) {
			default:
			{
				NetworkVPNPage* _tmp4_;
				_tmp4_ = self->priv->vpn_page;
				network_vpn_page_remove_connection (_tmp4_, connection);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
_network_main_view_update_state_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	network_main_view_update_state ((NetworkMainView*) self);
}

static void
network_main_view_device_added_cb (NetworkMainView* self,
                                   NMDevice* device)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	NetworkWidgetsPage* widget_interface = NULL;
	NetworkWidgetsPage* hotspot_interface = NULL;
	NetworkWidgetsPage* _tmp11_;
	NetworkWidgetsPage* _tmp16_;
	GList* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp2_ = nm_device_get_iface (device);
	if (g_str_has_prefix (_tmp2_, "vmnet")) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = nm_device_get_iface (device);
		_tmp1_ = g_str_has_prefix (_tmp3_, "lo");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = nm_device_get_iface (device);
		_tmp0_ = g_str_has_prefix (_tmp4_, "veth");
	}
	if (_tmp0_) {
		return;
	}
	widget_interface = NULL;
	hotspot_interface = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_wifi_get_type ())) {
		NetworkWifiInterface* _tmp5_;
		NetworkWidgetsPage* _tmp6_;
		NetworkWidgetsHotspotInterface* _tmp7_;
		_tmp5_ = network_wifi_interface_new (device);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (widget_interface);
		widget_interface = (NetworkWidgetsPage*) _tmp5_;
		_tmp6_ = widget_interface;
		_tmp7_ = network_widgets_hotspot_interface_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (hotspot_interface);
		hotspot_interface = (NetworkWidgetsPage*) _tmp7_;
		g_debug ("MainView.vala:231: Wifi interface added");
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_ethernet_get_type ())) {
			NetworkWidgetsEtherInterface* _tmp8_;
			_tmp8_ = network_widgets_ether_interface_new (device);
			g_object_ref_sink (_tmp8_);
			_g_object_unref0 (widget_interface);
			widget_interface = (NetworkWidgetsPage*) _tmp8_;
			g_debug ("MainView.vala:234: Ethernet interface added");
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_modem_get_type ())) {
				NetworkWidgetsModemInterface* _tmp9_;
				_tmp9_ = network_widgets_modem_interface_new (device);
				g_object_ref_sink (_tmp9_);
				_g_object_unref0 (widget_interface);
				widget_interface = (NetworkWidgetsPage*) _tmp9_;
				g_debug ("MainView.vala:237: Modem interface added");
			} else {
				GEnumValue* _tmp10_;
				_tmp10_ = g_enum_get_value (g_type_class_ref (nm_device_type_get_type ()), nm_device_get_device_type (device));
				g_debug ("MainView.vala:239: Unknown device: %s\n", (_tmp10_ != NULL) ? _tmp10_->value_name : NULL);
			}
		}
	}
	_tmp11_ = widget_interface;
	if (_tmp11_ != NULL) {
		NetworkWidgetsPage* _tmp12_;
		NetworkWidgetsPage* _tmp13_;
		NetworkWidgetsPage* _tmp14_;
		NetworkWidgetsPage* _tmp15_;
		_tmp12_ = widget_interface;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		self->network_interface = g_list_append (self->network_interface, _tmp13_);
		_tmp14_ = widget_interface;
		network_main_view_add_interface (self, _tmp14_);
		_tmp15_ = widget_interface;
		g_signal_connect_object ((GObject*) _tmp15_, "notify::state", (GCallback) _network_main_view_update_state_g_object_notify, self, 0);
	}
	_tmp16_ = hotspot_interface;
	if (_tmp16_ != NULL) {
		NetworkWidgetsPage* _tmp17_;
		NetworkWidgetsPage* _tmp18_;
		NetworkWidgetsPage* _tmp19_;
		NetworkWidgetsPage* _tmp20_;
		_tmp17_ = hotspot_interface;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		self->network_interface = g_list_append (self->network_interface, _tmp18_);
		_tmp19_ = hotspot_interface;
		network_main_view_add_interface (self, _tmp19_);
		_tmp20_ = hotspot_interface;
		g_signal_connect_object ((GObject*) _tmp20_, "notify::state", (GCallback) _network_main_view_update_state_g_object_notify, self, 0);
	}
	network_main_view_update_interfaces_names (self);
	_tmp21_ = self->network_interface;
	{
		GList* inter_collection = NULL;
		GList* inter_it = NULL;
		inter_collection = _tmp21_;
		for (inter_it = inter_collection; inter_it != NULL; inter_it = inter_it->next) {
			NetworkWidgetsPage* _tmp22_;
			NetworkWidgetsPage* inter = NULL;
			_tmp22_ = _g_object_ref0 ((NetworkWidgetsPage*) inter_it->data);
			inter = _tmp22_;
			{
				NetworkWidgetsPage* _tmp23_;
				_tmp23_ = inter;
				network_widgets_page_update (_tmp23_);
				_g_object_unref0 (inter);
			}
		}
	}
	_g_object_unref0 (hotspot_interface);
	_g_object_unref0 (widget_interface);
}

static void
network_main_view_update_state (NetworkMainView* self)
{
	NMDeviceState next_state = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	next_state = NM_DEVICE_STATE_DISCONNECTED;
	_tmp0_ = self->network_interface;
	{
		GList* inter_collection = NULL;
		GList* inter_it = NULL;
		inter_collection = _tmp0_;
		for (inter_it = inter_collection; inter_it != NULL; inter_it = inter_it->next) {
			NetworkWidgetsPage* _tmp1_;
			NetworkWidgetsPage* inter = NULL;
			_tmp1_ = _g_object_ref0 ((NetworkWidgetsPage*) inter_it->data);
			inter = _tmp1_;
			{
				NetworkWidgetsPage* _tmp2_;
				NMDeviceState _tmp3_;
				NMDeviceState _tmp4_;
				_tmp2_ = inter;
				_tmp3_ = network_widgets_page_get_state (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ != NM_DEVICE_STATE_DISCONNECTED) {
					NetworkWidgetsPage* _tmp5_;
					NMDeviceState _tmp6_;
					NMDeviceState _tmp7_;
					_tmp5_ = inter;
					_tmp6_ = network_widgets_page_get_state (_tmp5_);
					_tmp7_ = _tmp6_;
					next_state = _tmp7_;
				}
				_g_object_unref0 (inter);
			}
		}
	}
	network_main_view_set_state (self, next_state);
}

static void
network_main_view_add_interface (NetworkMainView* self,
                                 NetworkWidgetsPage* page)
{
	NetworkWidgetsDeviceItem* item = NULL;
	GtkStack* _tmp6_;
	GtkStackPage* _tmp7_;
	GtkListBox* _tmp9_;
	NetworkWidgetsDeviceItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	if (NETWORK_WIDGETS_IS_HOTSPOT_INTERFACE (page)) {
		NetworkWidgetsDeviceItem* _tmp0_ = NULL;
		_tmp0_ = network_widgets_device_item_new_from_page (page, "network-wired");
		network_widgets_device_item_set_item_type (_tmp0_, NETWORK_UTILS_ITEM_TYPE_VIRTUAL);
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (item);
		item = _tmp0_;
	} else {
		NMDevice* _tmp1_;
		NMDevice* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = network_widgets_page_get_device (page);
		_tmp2_ = _tmp1_;
		_tmp3_ = nm_device_get_iface (_tmp2_);
		if (g_str_has_prefix (_tmp3_, "usb")) {
			NetworkWidgetsDeviceItem* _tmp4_;
			_tmp4_ = network_widgets_device_item_new_from_page (page, "drive-removable-media");
			g_object_ref_sink (_tmp4_);
			_g_object_unref0 (item);
			item = _tmp4_;
		} else {
			NetworkWidgetsDeviceItem* _tmp5_;
			_tmp5_ = network_widgets_device_item_new_from_page (page, "network-wired");
			g_object_ref_sink (_tmp5_);
			_g_object_unref0 (item);
			item = _tmp5_;
		}
	}
	_tmp6_ = self->priv->content;
	_tmp7_ = gtk_stack_get_page (_tmp6_, (GtkWidget*) page);
	if (_tmp7_ == NULL) {
		GtkStack* _tmp8_;
		_tmp8_ = self->priv->content;
		gtk_stack_add_child (_tmp8_, (GtkWidget*) page);
	}
	_tmp9_ = self->priv->device_list;
	_tmp10_ = item;
	gtk_list_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	network_main_view_update_networking_state (self);
	_g_object_unref0 (item);
}

static void
network_main_view_remove_interface (NetworkMainView* self,
                                    NetworkWidgetsPage* widget_interface)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget_interface != NULL);
	_tmp0_ = self->priv->content;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (widget_interface, gtk_widget_get_type (), GtkWidget)) {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		gint index = 0;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GtkListBoxRow* _tmp8_;
		_tmp2_ = self->priv->device_list;
		_tmp3_ = gtk_list_box_get_selected_row (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		row = _tmp4_;
		_tmp5_ = self->priv->device_list;
		_tmp6_ = gtk_list_box_get_selected_row (_tmp5_);
		index = gtk_list_box_row_get_index (_tmp6_);
		network_main_view_remove_iface_from_list (self, widget_interface);
		_tmp8_ = row;
		if (_tmp8_ != NULL) {
			GtkListBoxRow* _tmp9_;
			_tmp9_ = row;
			_tmp7_ = gtk_list_box_row_get_index (_tmp9_) >= 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkListBox* _tmp10_;
			GtkListBoxRow* _tmp11_;
			_tmp10_ = self->priv->device_list;
			_tmp11_ = gtk_list_box_get_row_at_index (_tmp10_, index);
			g_signal_emit_by_name (_tmp11_, "activate");
		} else {
			GtkListBox* _tmp12_;
			GtkListBoxRow* _tmp13_;
			_tmp12_ = self->priv->device_list;
			_tmp13_ = gtk_list_box_get_row_at_index (_tmp12_, 0);
			g_signal_emit_by_name (_tmp13_, "activate");
		}
		_g_object_unref0 (row);
	} else {
		network_main_view_remove_iface_from_list (self, widget_interface);
	}
	g_signal_emit_by_name ((GtkWidget*) widget_interface, "destroy");
}

static void
network_main_view_remove_iface_from_list (NetworkMainView* self,
                                          NetworkWidgetsPage* iface)
{
	GtkWidget* child = NULL;
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->device_list;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	child = _tmp1_;
	while (TRUE) {
		GtkWidget* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		_tmp2_ = child;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp4_ = child;
		if (NETWORK_WIDGETS_IS_DEVICE_ITEM (_tmp4_)) {
			GtkWidget* _tmp5_;
			NetworkWidgetsPage* _tmp6_;
			NetworkWidgetsPage* _tmp7_;
			_tmp5_ = child;
			_tmp6_ = network_widgets_device_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem));
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ == iface;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkListBox* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = self->priv->device_list;
			_tmp9_ = child;
			gtk_list_box_remove (_tmp8_, _tmp9_);
			break;
		}
		_tmp10_ = child;
		_tmp11_ = gtk_widget_get_next_sibling (_tmp10_);
		child = _tmp11_;
	}
}

static void
network_main_view_update_networking_state (NetworkMainView* self)
{
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp0_;
	NetworkNetworkManager* _tmp1_;
	NMClient* _tmp2_;
	NMClient* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_network_manager_get_default ();
	network_manager = _tmp0_;
	_tmp1_ = network_manager;
	_tmp2_ = network_network_manager_get_client (_tmp1_);
	_tmp3_ = _tmp2_;
	if (nm_client_networking_get_enabled (_tmp3_)) {
		GtkListBox* _tmp4_;
		GtkWidget* child = NULL;
		GtkListBox* _tmp5_;
		GtkWidget* _tmp6_;
		GtkListBox* _tmp18_;
		GtkListBoxRow* _tmp19_;
		_tmp4_ = self->priv->device_list;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->priv->device_list;
		_tmp6_ = gtk_widget_get_first_child ((GtkWidget*) _tmp5_);
		child = _tmp6_;
		while (TRUE) {
			GtkWidget* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp16_;
			GtkWidget* _tmp17_;
			_tmp7_ = child;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp9_ = child;
			if (NETWORK_WIDGETS_IS_DEVICE_ITEM (_tmp9_)) {
				GtkWidget* _tmp10_;
				NetworkWidgetsPage* _tmp11_;
				NetworkWidgetsPage* _tmp12_;
				NMDeviceState _tmp13_;
				NMDeviceState _tmp14_;
				_tmp10_ = child;
				_tmp11_ = network_widgets_device_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem));
				_tmp12_ = _tmp11_;
				_tmp13_ = network_widgets_page_get_state (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ == NM_DEVICE_STATE_ACTIVATED;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GtkWidget* _tmp15_;
				_tmp15_ = child;
				gtk_widget_activate (_tmp15_);
				return;
			}
			_tmp16_ = child;
			_tmp17_ = gtk_widget_get_next_sibling (_tmp16_);
			child = _tmp17_;
		}
		_tmp18_ = self->priv->device_list;
		_tmp19_ = gtk_list_box_get_row_at_index (_tmp18_, 0);
		g_signal_emit_by_name (_tmp19_, "activate");
	} else {
		GtkListBox* _tmp20_;
		GtkListBox* _tmp21_;
		GtkStack* _tmp22_;
		_tmp20_ = self->priv->device_list;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, FALSE);
		_g_object_unref0 (self->priv->current_device);
		self->priv->current_device = NULL;
		_tmp21_ = self->priv->device_list;
		gtk_list_box_select_row (_tmp21_, NULL);
		_tmp22_ = self->priv->content;
		gtk_stack_set_visible_child_name (_tmp22_, "airplane-mode-info");
	}
}

static gint
network_main_view_sort_func (NetworkMainView* self,
                             GtkListBoxRow* row1,
                             GtkListBoxRow* row2)
{
	NetworkUtilsItemType _tmp0_;
	NetworkUtilsItemType _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = network_widgets_device_item_get_item_type (G_TYPE_CHECK_INSTANCE_CAST (row1, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NETWORK_UTILS_ITEM_TYPE_DEVICE) {
		result = -1;
		return result;
	} else {
		NetworkUtilsItemType _tmp2_;
		NetworkUtilsItemType _tmp3_;
		_tmp2_ = network_widgets_device_item_get_item_type (G_TYPE_CHECK_INSTANCE_CAST (row1, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem));
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NETWORK_UTILS_ITEM_TYPE_VIRTUAL) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

static void
network_main_view_update_headers (NetworkMainView* self,
                                  GtkListBoxRow* row,
                                  GtkListBoxRow* before)
{
	NetworkWidgetsDeviceItem* row_item = NULL;
	NetworkWidgetsDeviceItem* before_item = NULL;
	NetworkWidgetsDeviceItem* _tmp0_;
	NetworkUtilsItemType _tmp1_;
	NetworkUtilsItemType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	row_item = G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	before_item = G_TYPE_CHECK_INSTANCE_CAST (before, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem);
	_tmp0_ = row_item;
	_tmp1_ = network_widgets_device_item_get_item_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NETWORK_UTILS_ITEM_TYPE_VIRTUAL) {
		gboolean _tmp3_ = FALSE;
		NetworkWidgetsDeviceItem* _tmp4_;
		GraniteHeaderLabel* _tmp8_;
		GtkWidget* _tmp9_;
		GraniteHeaderLabel* _tmp11_;
		_tmp4_ = before_item;
		if (_tmp4_ != NULL) {
			NetworkWidgetsDeviceItem* _tmp5_;
			NetworkUtilsItemType _tmp6_;
			NetworkUtilsItemType _tmp7_;
			_tmp5_ = before_item;
			_tmp6_ = network_widgets_device_item_get_item_type (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ == NETWORK_UTILS_ITEM_TYPE_VIRTUAL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gtk_list_box_row_set_header (row, NULL);
			return;
		}
		_tmp8_ = self->priv->virtual_header;
		_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
		if (_tmp9_ != NULL) {
			GraniteHeaderLabel* _tmp10_;
			_tmp10_ = self->priv->virtual_header;
			gtk_widget_unparent ((GtkWidget*) _tmp10_);
		}
		_tmp11_ = self->priv->virtual_header;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp11_);
	} else {
		NetworkWidgetsDeviceItem* _tmp12_;
		NetworkUtilsItemType _tmp13_;
		NetworkUtilsItemType _tmp14_;
		_tmp12_ = row_item;
		_tmp13_ = network_widgets_device_item_get_item_type (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NETWORK_UTILS_ITEM_TYPE_DEVICE) {
			gboolean _tmp15_ = FALSE;
			NetworkWidgetsDeviceItem* _tmp16_;
			GraniteHeaderLabel* _tmp20_;
			GtkWidget* _tmp21_;
			GraniteHeaderLabel* _tmp23_;
			_tmp16_ = before_item;
			if (_tmp16_ != NULL) {
				NetworkWidgetsDeviceItem* _tmp17_;
				NetworkUtilsItemType _tmp18_;
				NetworkUtilsItemType _tmp19_;
				_tmp17_ = before_item;
				_tmp18_ = network_widgets_device_item_get_item_type (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp15_ = _tmp19_ == NETWORK_UTILS_ITEM_TYPE_DEVICE;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gtk_list_box_row_set_header (row, NULL);
				return;
			}
			_tmp20_ = self->priv->devices_header;
			_tmp21_ = gtk_widget_get_parent ((GtkWidget*) _tmp20_);
			if (_tmp21_ != NULL) {
				GraniteHeaderLabel* _tmp22_;
				_tmp22_ = self->priv->devices_header;
				gtk_widget_unparent ((GtkWidget*) _tmp22_);
			}
			_tmp23_ = self->priv->devices_header;
			gtk_list_box_row_set_header (row, (GtkWidget*) _tmp23_);
		} else {
			gtk_list_box_row_set_header (row, NULL);
		}
	}
}

NetworkMainView*
network_main_view_construct (GType object_type)
{
	NetworkMainView * self = NULL;
	self = (NetworkMainView*) g_object_new (object_type, NULL);
	return self;
}

NetworkMainView*
network_main_view_new (void)
{
	return network_main_view_construct (NETWORK_TYPE_MAIN_VIEW);
}

NMDeviceState
network_main_view_get_state (NetworkMainView* self)
{
	NMDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
network_main_view_set_state (NetworkMainView* self,
                             NMDeviceState value)
{
	NMDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_main_view_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_main_view_properties[NETWORK_MAIN_VIEW_STATE_PROPERTY]);
	}
}

static NetworkMainViewSidebar*
network_main_view_sidebar_construct (GType object_type)
{
	NetworkMainViewSidebar * self = NULL;
	self = (NetworkMainViewSidebar*) g_object_new (object_type, NULL);
	return self;
}

static NetworkMainViewSidebar*
network_main_view_sidebar_new (void)
{
	return network_main_view_sidebar_construct (NETWORK_MAIN_VIEW_TYPE_SIDEBAR);
}

static GObject *
network_main_view_sidebar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkMainViewSidebar * self;
	parent_class = G_OBJECT_CLASS (network_main_view_sidebar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_MAIN_VIEW_TYPE_SIDEBAR, NetworkMainViewSidebar);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_SIDEBAR);
	return obj;
}

static void
network_main_view_sidebar_base_init (NetworkMainViewSidebarClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingssidebar");
}

static void
network_main_view_sidebar_class_init (NetworkMainViewSidebarClass * klass,
                                      gpointer klass_data)
{
	network_main_view_sidebar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = network_main_view_sidebar_constructor;
}

static void
network_main_view_sidebar_instance_init (NetworkMainViewSidebar * self,
                                         gpointer klass)
{
}

static GType
network_main_view_sidebar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkMainViewSidebarClass), (GBaseInitFunc) network_main_view_sidebar_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_main_view_sidebar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkMainViewSidebar), 0, (GInstanceInitFunc) network_main_view_sidebar_instance_init, NULL };
	GType network_main_view_sidebar_type_id;
	network_main_view_sidebar_type_id = g_type_register_static (gtk_box_get_type (), "NetworkMainViewSidebar", &g_define_type_info, 0);
	return network_main_view_sidebar_type_id;
}

static GType
network_main_view_sidebar_get_type (void)
{
	static volatile gsize network_main_view_sidebar_type_id__once = 0;
	if (g_once_init_enter (&network_main_view_sidebar_type_id__once)) {
		GType network_main_view_sidebar_type_id;
		network_main_view_sidebar_type_id = network_main_view_sidebar_get_type_once ();
		g_once_init_leave (&network_main_view_sidebar_type_id__once, network_main_view_sidebar_type_id);
	}
	return network_main_view_sidebar_type_id__once;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NetworkMainView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->airplane_switch);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gint
_network_main_view_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                     GtkListBoxRow* row2,
                                                     gpointer self)
{
	gint result;
	result = network_main_view_sort_func ((NetworkMainView*) self, row1, row2);
	return result;
}

static void
_network_main_view_update_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                   GtkListBoxRow* before,
                                                                   gpointer self)
{
	network_main_view_update_headers ((NetworkMainView*) self, row, before);
}

static void
_network_main_view___lambda46_ (NetworkMainView* self,
                                GtkListBoxRow* row)
{
	g_signal_emit_by_name (row, "activate");
}

static void
__network_main_view___lambda46__gtk_list_box_row_selected (GtkListBox* _sender,
                                                           GtkListBoxRow* row,
                                                           gpointer self)
{
	_network_main_view___lambda46_ ((NetworkMainView*) self, row);
}

static void
_network_main_view___lambda47_ (NetworkMainView* self,
                                GtkListBoxRow* row)
{
	NetworkWidgetsPage* page = NULL;
	NetworkWidgetsPage* _tmp0_;
	NetworkWidgetsPage* _tmp1_;
	NetworkWidgetsPage* _tmp2_;
	GtkStack* _tmp3_;
	NetworkWidgetsPage* _tmp4_;
	g_return_if_fail (row != NULL);
	_tmp0_ = network_widgets_device_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_WIDGETS_TYPE_DEVICE_ITEM, NetworkWidgetsDeviceItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	page = _tmp2_;
	_tmp3_ = self->priv->content;
	_tmp4_ = page;
	gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (page);
}

static void
__network_main_view___lambda47__gtk_list_box_row_activated (GtkListBox* _sender,
                                                            GtkListBoxRow* row,
                                                            gpointer self)
{
	_network_main_view___lambda47_ ((NetworkMainView*) self, row);
}

static void
_network_main_view_connection_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                   NMRemoteConnection* connection,
                                                                   gpointer self)
{
	network_main_view_connection_added_cb ((NetworkMainView*) self, connection);
}

static void
_network_main_view_connection_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                       NMRemoteConnection* connection,
                                                                       gpointer self)
{
	network_main_view_connection_removed_cb ((NetworkMainView*) self, connection);
}

static void
_network_main_view_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                           NMDevice* device,
                                                           gpointer self)
{
	network_main_view_device_added_cb ((NetworkMainView*) self, device);
}

static void
_network_main_view_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                               NMDevice* device,
                                                               gpointer self)
{
	network_main_view_device_removed_cb ((NetworkMainView*) self, device);
}

static void
_network_main_view___lambda48_ (NetworkMainView* self,
                                NMDevice* device)
{
	g_return_if_fail (device != NULL);
	network_main_view_device_added_cb (self, device);
}

static void
__network_main_view___lambda48__gfunc (gconstpointer data,
                                       gpointer self)
{
	_network_main_view___lambda48_ ((NetworkMainView*) self, (NMDevice*) data);
}

static void
_network_main_view___lambda49_ (NetworkMainView* self,
                                NMRemoteConnection* connection)
{
	g_return_if_fail (connection != NULL);
	network_main_view_connection_added_cb (self, connection);
}

static void
__network_main_view___lambda49__gfunc (gconstpointer data,
                                       gpointer self)
{
	_network_main_view___lambda49_ ((NetworkMainView*) self, (NMRemoteConnection*) data);
}

static void
_network_main_view_update_networking_state_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	network_main_view_update_networking_state ((NetworkMainView*) self);
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
__lambda51_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	NetworkMainView* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		NMClient* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = _data2_->nm_client;
		_tmp1_ = nm_client_dbus_call_finish (_tmp0_, res, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_variant_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("MainView.vala:153: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda51__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda51_ (self, source_object, res);
	block2_data_unref (self);
}

static void
_network_main_view___lambda50_ (Block2Data* _data2_)
{
	NetworkMainView* self;
	NMClient* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant** _tmp5_;
	GVariant** _tmp6_;
	gint _tmp6__length1;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	self = _data2_->self;
	_tmp0_ = _data2_->nm_client;
	_tmp1_ = _data2_->airplane_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new1 (!_tmp3_);
	_tmp5_ = g_new0 (GVariant*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = g_variant_new_tuple (_tmp6_, 1);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	nm_client_dbus_call (_tmp0_, NM_DBUS_PATH, NM_DBUS_INTERFACE, "Enable", _tmp8_, NULL, -1, NULL, ___lambda51__gasync_ready_callback, block2_data_ref (_data2_));
	_g_variant_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_variant_unref), NULL);
}

static void
__network_main_view___lambda50__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_network_main_view___lambda50_ (self);
}

static GObject *
network_main_view_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkMainView * self;
	Block2Data* _data2_;
	GraniteHeaderLabel* _tmp0_;
	GraniteHeaderLabel* _tmp1_;
	NetworkWidgetsProxyPage* proxy_page = NULL;
	NetworkWidgetsProxyPage* _tmp2_;
	NetworkWidgetsDeviceItem* proxy = NULL;
	NetworkWidgetsProxyPage* _tmp3_;
	NetworkWidgetsDeviceItem* _tmp4_ = NULL;
	NetworkVPNPage* _tmp5_;
	NetworkWidgetsDeviceItem* vpn = NULL;
	NetworkVPNPage* _tmp6_;
	NetworkWidgetsDeviceItem* _tmp7_ = NULL;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp8_ = NULL;
	GtkListBox* _tmp9_ = NULL;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	NetworkWidgetsDeviceItem* _tmp13_;
	GtkListBox* _tmp14_;
	NetworkWidgetsDeviceItem* _tmp15_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp16_;
	GtkSwitch* _tmp17_ = NULL;
	GtkActionBar* footer = NULL;
	GtkActionBar* _tmp18_;
	GtkActionBar* _tmp19_;
	GtkLabel* _tmp20_;
	GtkActionBar* _tmp21_;
	GtkSwitch* _tmp22_;
	GranitePlaceholder* airplane_mode = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GThemedIcon* _tmp26_;
	GranitePlaceholder* _tmp27_ = NULL;
	GranitePlaceholder* _tmp28_;
	GtkStack* _tmp29_ = NULL;
	GtkStack* _tmp30_;
	GranitePlaceholder* _tmp31_;
	GtkStack* _tmp32_;
	NetworkVPNPage* _tmp33_;
	GtkStack* _tmp34_;
	NetworkWidgetsDeviceItem* _tmp35_;
	NetworkWidgetsPage* _tmp36_;
	NetworkWidgetsPage* _tmp37_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkScrolledWindow* _tmp40_ = NULL;
	AdwToolbarView* toolbarview = NULL;
	GtkScrolledWindow* _tmp41_;
	GtkWidget* _tmp42_;
	AdwToolbarView* _tmp43_ = NULL;
	AdwToolbarView* _tmp44_;
	AdwHeaderBar* _tmp45_;
	AdwToolbarView* _tmp46_;
	GtkActionBar* _tmp47_;
	NetworkMainViewSidebar* sidebar = NULL;
	NetworkMainViewSidebar* _tmp48_;
	NetworkMainViewSidebar* _tmp49_;
	AdwToolbarView* _tmp50_;
	GtkPaned* paned = NULL;
	NetworkMainViewSidebar* _tmp51_;
	GtkWidget* _tmp52_;
	GtkStack* _tmp53_;
	GtkWidget* _tmp54_;
	GtkPaned* _tmp55_ = NULL;
	GSettingsSchema* sss = NULL;
	GSettingsSchemaSource* _tmp56_;
	GSettingsSchema* _tmp57_;
	gboolean _tmp58_ = FALSE;
	GSettingsSchema* _tmp59_;
	GtkPaned* _tmp64_;
	GtkListBox* _tmp65_;
	GtkListBox* _tmp66_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp67_;
	NetworkNetworkManager* _tmp68_;
	NMClient* _tmp69_;
	NMClient* _tmp70_;
	NMClient* _tmp71_;
	NMClient* _tmp72_;
	NMClient* _tmp73_;
	NMClient* _tmp74_;
	NMClient* _tmp75_;
	GPtrArray* _tmp76_;
	NMClient* _tmp77_;
	GPtrArray* _tmp78_;
	NMClient* _tmp79_;
	GtkSwitch* _tmp80_;
	gboolean _tmp81_ = FALSE;
	GtkSwitch* _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	parent_class = G_OBJECT_CLASS (network_main_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_MAIN_VIEW, NetworkMainView);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	(self->network_interface == NULL) ? NULL : (self->network_interface = (_g_list_free__g_object_unref0_ (self->network_interface), NULL));
	self->network_interface = NULL;
	_tmp0_ = granite_header_label_new (_ ("Virtual"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->virtual_header);
	self->priv->virtual_header = _tmp0_;
	_tmp1_ = granite_header_label_new (_ ("Devices"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->devices_header);
	self->priv->devices_header = _tmp1_;
	_tmp2_ = network_widgets_proxy_page_new ();
	g_object_ref_sink (_tmp2_);
	proxy_page = _tmp2_;
	_tmp3_ = proxy_page;
	_tmp4_ = network_widgets_device_item_new_from_page ((NetworkWidgetsPage*) _tmp3_, "network-wired");
	network_widgets_device_item_set_item_type (_tmp4_, NETWORK_UTILS_ITEM_TYPE_VIRTUAL);
	g_object_ref_sink (_tmp4_);
	proxy = _tmp4_;
	_tmp5_ = network_vpn_page_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->vpn_page);
	self->priv->vpn_page = _tmp5_;
	_tmp6_ = self->priv->vpn_page;
	_tmp7_ = network_widgets_device_item_new_from_page ((NetworkWidgetsPage*) _tmp6_, "network-wired");
	network_widgets_device_item_set_item_type (_tmp7_, NETWORK_UTILS_ITEM_TYPE_VIRTUAL);
	g_object_ref_sink (_tmp7_);
	vpn = _tmp7_;
	_tmp8_ = (AdwHeaderBar*) adw_header_bar_new ();
	adw_header_bar_set_show_end_title_buttons (_tmp8_, FALSE);
	adw_header_bar_set_show_title (_tmp8_, FALSE);
	g_object_ref_sink (_tmp8_);
	headerbar = _tmp8_;
	_tmp9_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp9_, TRUE);
	gtk_list_box_set_selection_mode (_tmp9_, GTK_SELECTION_SINGLE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->device_list);
	self->priv->device_list = _tmp9_;
	_tmp10_ = self->priv->device_list;
	gtk_list_box_set_sort_func (_tmp10_, _network_main_view_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp11_ = self->priv->device_list;
	gtk_list_box_set_header_func (_tmp11_, _network_main_view_update_headers_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->device_list;
	_tmp13_ = proxy;
	gtk_list_box_append (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->device_list;
	_tmp15_ = vpn;
	gtk_list_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Airplane Mode"));
	g_object_ref_sink (_tmp16_);
	label = _tmp16_;
	_tmp17_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp17_);
	_data2_->airplane_switch = _tmp17_;
	_tmp18_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp18_);
	footer = _tmp18_;
	_tmp19_ = footer;
	_tmp20_ = label;
	gtk_action_bar_pack_start (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = footer;
	_tmp22_ = _data2_->airplane_switch;
	gtk_action_bar_pack_end (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = g_strconcat (_ ("While in Airplane Mode your device's Internet access and any wireless " \
"and ethernet connections, will be suspended.\n" \
"\n"), _ ("You will be unable to browse the web or use applications that require " \
"a network connection or Internet access.\n"), NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, _ ("Applications and other functions that do not require the Internet will" \
" be unaffected."), NULL);
	_tmp26_ = (GThemedIcon*) g_themed_icon_new ("airplane-mode");
	_tmp27_ = granite_placeholder_new (_ ("Airplane Mode Is Enabled"));
	granite_placeholder_set_description (_tmp27_, _tmp25_);
	_g_free0 (_tmp25_);
	granite_placeholder_set_icon (_tmp27_, (GIcon*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp24_);
	airplane_mode = _tmp28_;
	_tmp29_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp29_, TRUE);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp29_;
	_tmp30_ = self->priv->content;
	_tmp31_ = airplane_mode;
	gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, "airplane-mode-info");
	_tmp32_ = self->priv->content;
	_tmp33_ = self->priv->vpn_page;
	gtk_stack_add_child (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->content;
	_tmp35_ = proxy;
	_tmp36_ = network_widgets_device_item_get_page (_tmp35_);
	_tmp37_ = _tmp36_;
	gtk_stack_add_child (_tmp34_, (GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->device_list;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	g_object_set (_tmp40_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp40_);
	scrolled_window = _tmp40_;
	_tmp41_ = scrolled_window;
	_tmp42_ = _g_object_ref0 ((GtkWidget*) _tmp41_);
	_tmp43_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp43_, _tmp42_);
	_g_object_unref0 (_tmp42_);
	adw_toolbar_view_set_top_bar_style (_tmp43_, ADW_TOOLBAR_FLAT);
	adw_toolbar_view_set_bottom_bar_style (_tmp43_, ADW_TOOLBAR_RAISED);
	g_object_ref_sink (_tmp43_);
	toolbarview = _tmp43_;
	_tmp44_ = toolbarview;
	_tmp45_ = headerbar;
	adw_toolbar_view_add_top_bar (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = toolbarview;
	_tmp47_ = footer;
	adw_toolbar_view_add_bottom_bar (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = network_main_view_sidebar_new ();
	g_object_ref_sink (_tmp48_);
	sidebar = _tmp48_;
	_tmp49_ = sidebar;
	_tmp50_ = toolbarview;
	gtk_box_append ((GtkBox*) _tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = sidebar;
	_tmp52_ = _g_object_ref0 ((GtkWidget*) _tmp51_);
	_tmp53_ = self->priv->content;
	_tmp54_ = _g_object_ref0 ((GtkWidget*) _tmp53_);
	_tmp55_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_start_child (_tmp55_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	gtk_paned_set_end_child (_tmp55_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	gtk_paned_set_resize_start_child (_tmp55_, FALSE);
	gtk_paned_set_shrink_start_child (_tmp55_, FALSE);
	gtk_paned_set_shrink_end_child (_tmp55_, FALSE);
	g_object_ref_sink (_tmp55_);
	paned = _tmp55_;
	_tmp56_ = g_settings_schema_source_get_default ();
	_tmp57_ = g_settings_schema_source_lookup (_tmp56_, "io.elementary.settings", TRUE);
	sss = _tmp57_;
	_tmp59_ = sss;
	if (_tmp59_ != NULL) {
		GSettingsSchema* _tmp60_;
		_tmp60_ = sss;
		_tmp58_ = g_settings_schema_has_key (_tmp60_, "sidebar-position");
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		GSettings* settings = NULL;
		GSettings* _tmp61_;
		GSettings* _tmp62_;
		GtkPaned* _tmp63_;
		_tmp61_ = g_settings_new ("io.elementary.settings");
		settings = _tmp61_;
		_tmp62_ = settings;
		_tmp63_ = paned;
		g_settings_bind (_tmp62_, "sidebar-position", (GObject*) _tmp63_, "position", G_SETTINGS_BIND_DEFAULT);
		_g_object_unref0 (settings);
	}
	_tmp64_ = paned;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp64_);
	_tmp65_ = self->priv->device_list;
	g_signal_connect_object (_tmp65_, "row-selected", (GCallback) __network_main_view___lambda46__gtk_list_box_row_selected, self, 0);
	_tmp66_ = self->priv->device_list;
	g_signal_connect_object (_tmp66_, "row-activated", (GCallback) __network_main_view___lambda47__gtk_list_box_row_activated, self, 0);
	_tmp67_ = network_network_manager_get_default ();
	network_manager = _tmp67_;
	_tmp68_ = network_manager;
	_tmp69_ = network_network_manager_get_client (_tmp68_);
	_tmp70_ = _tmp69_;
	_data2_->nm_client = _tmp70_;
	_tmp71_ = _data2_->nm_client;
	g_signal_connect_object (_tmp71_, "connection-added", (GCallback) _network_main_view_connection_added_cb_nm_client_connection_added, self, 0);
	_tmp72_ = _data2_->nm_client;
	g_signal_connect_object (_tmp72_, "connection-removed", (GCallback) _network_main_view_connection_removed_cb_nm_client_connection_removed, self, 0);
	_tmp73_ = _data2_->nm_client;
	g_signal_connect_object (_tmp73_, "device-added", (GCallback) _network_main_view_device_added_cb_nm_client_device_added, self, 0);
	_tmp74_ = _data2_->nm_client;
	g_signal_connect_object (_tmp74_, "device-removed", (GCallback) _network_main_view_device_removed_cb_nm_client_device_removed, self, 0);
	_tmp75_ = _data2_->nm_client;
	_tmp76_ = nm_client_get_devices (_tmp75_);
	g_ptr_array_foreach (_tmp76_, __network_main_view___lambda48__gfunc, self);
	_tmp77_ = _data2_->nm_client;
	_tmp78_ = nm_client_get_connections (_tmp77_);
	g_ptr_array_foreach (_tmp78_, __network_main_view___lambda49__gfunc, self);
	network_main_view_update_networking_state (self);
	_tmp79_ = _data2_->nm_client;
	g_signal_connect_object ((GObject*) _tmp79_, "notify::networking-enabled", (GCallback) _network_main_view_update_networking_state_g_object_notify, self, 0);
	_tmp80_ = _data2_->airplane_switch;
	g_signal_connect_data ((GObject*) _tmp80_, "notify::active", (GCallback) __network_main_view___lambda50__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp82_ = _data2_->airplane_switch;
	_tmp83_ = gtk_switch_get_active (_tmp82_);
	_tmp84_ = _tmp83_;
	if (!_tmp84_) {
		NMClient* _tmp85_;
		gboolean _tmp86_;
		gboolean _tmp87_;
		_tmp85_ = _data2_->nm_client;
		g_object_get (_tmp85_, "networking-enabled", &_tmp86_, NULL);
		_tmp87_ = _tmp86_;
		_tmp81_ = !_tmp87_;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		GtkSwitch* _tmp88_;
		_tmp88_ = _data2_->airplane_switch;
		g_signal_emit_by_name (_tmp88_, "activate");
	}
	_g_settings_schema_unref0 (sss);
	_g_object_unref0 (paned);
	_g_object_unref0 (sidebar);
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (airplane_mode);
	_g_object_unref0 (footer);
	_g_object_unref0 (label);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (vpn);
	_g_object_unref0 (proxy);
	_g_object_unref0 (proxy_page);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
network_main_view_class_init (NetworkMainViewClass * klass,
                              gpointer klass_data)
{
	network_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkMainView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_main_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_main_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_main_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_main_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_MAIN_VIEW_STATE_PROPERTY, network_main_view_properties[NETWORK_MAIN_VIEW_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", nm_device_state_get_type (), NM_DEVICE_STATE_PREPARE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_main_view_instance_init (NetworkMainView * self,
                                 gpointer klass)
{
	self->priv = network_main_view_get_instance_private (self);
	self->priv->_state = NM_DEVICE_STATE_PREPARE;
	self->priv->current_device = NULL;
}

static void
network_main_view_finalize (GObject * obj)
{
	NetworkMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_MAIN_VIEW, NetworkMainView);
	(self->network_interface == NULL) ? NULL : (self->network_interface = (_g_list_free__g_object_unref0_ (self->network_interface), NULL));
	_g_object_unref0 (self->priv->devices_header);
	_g_object_unref0 (self->priv->virtual_header);
	_g_object_unref0 (self->priv->device_list);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->current_device);
	_g_object_unref0 (self->priv->vpn_page);
	G_OBJECT_CLASS (network_main_view_parent_class)->finalize (obj);
}

static GType
network_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkMainView), 0, (GInstanceInitFunc) network_main_view_instance_init, NULL };
	GType network_main_view_type_id;
	network_main_view_type_id = g_type_register_static (gtk_box_get_type (), "NetworkMainView", &g_define_type_info, 0);
	NetworkMainView_private_offset = g_type_add_instance_private (network_main_view_type_id, sizeof (NetworkMainViewPrivate));
	return network_main_view_type_id;
}

GType
network_main_view_get_type (void)
{
	static volatile gsize network_main_view_type_id__once = 0;
	if (g_once_init_enter (&network_main_view_type_id__once)) {
		GType network_main_view_type_id;
		network_main_view_type_id = network_main_view_get_type_once ();
		g_once_init_leave (&network_main_view_type_id__once, network_main_view_type_id);
	}
	return network_main_view_type_id__once;
}

static void
_vala_network_main_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	NetworkMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MAIN_VIEW, NetworkMainView);
	switch (property_id) {
		case NETWORK_MAIN_VIEW_STATE_PROPERTY:
		g_value_set_enum (value, network_main_view_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_main_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	NetworkMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MAIN_VIEW, NetworkMainView);
	switch (property_id) {
		case NETWORK_MAIN_VIEW_STATE_PROPERTY:
		network_main_view_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

