/* HotspotPage.c generated by valac 0.56.17, the Vala compiler
 * generated from HotspotPage.vala, do not modify */

/*-
 * Copyright (c) 2015-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <granite-7.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <NetworkManager.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_HOTSPOT_INTERFACE_0_PROPERTY,
	NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY,
	NETWORK_WIDGETS_HOTSPOT_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_widgets_hotspot_interface_properties[NETWORK_WIDGETS_HOTSPOT_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NetworkWidgetsHotspotInterfaceConnectToHotspotData NetworkWidgetsHotspotInterfaceConnectToHotspotData;
typedef struct _Block4Data Block4Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkWidgetsHotspotInterfacePrivate {
	NetworkWifiInterface* _root_iface;
	GtkButton* settings_button;
	gboolean switch_updating;
	GtkEntry* ssid_entry;
	GraniteValidatedEntry* key_entry;
	GtkLabel* conn_label;
	GtkLabel* ssid_label;
	GtkLabel* key_label;
	GtkComboBox* conn_combo;
	GtkCheckButton* check_btn;
};

struct _NetworkWidgetsHotspotInterfaceConnectToHotspotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkWidgetsHotspotInterface* self;
	NetworkNetworkManager* network_manager;
	NetworkNetworkManager* _tmp0_;
	NMDevice* _tmp1_;
	NMDevice* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GraniteValidatedEntry* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	NMConnection* _tmp9_;
};

struct _Block4Data {
	int _ref_count_;
	NetworkWidgetsHotspotInterface* self;
	GtkListStore* list_store;
	GtkTreeIter iter;
	gint i;
};

static gint NetworkWidgetsHotspotInterface_private_offset;
static gpointer network_widgets_hotspot_interface_parent_class = NULL;

static void network_widgets_hotspot_interface_real_update_name (NetworkWidgetsPage* base,
                                                         gint count);
static void network_widgets_hotspot_interface_validate_entries (NetworkWidgetsHotspotInterface* self);
static NMConnection* network_widgets_hotspot_interface_get_selected_connection (NetworkWidgetsHotspotInterface* self);
static void network_widgets_hotspot_interface_change_selected_connection (NetworkWidgetsHotspotInterface* self);
static void _network_widgets_hotspot_interface_change_selected_connection_network_utils_update_secret_callback (gpointer self);
static void network_widgets_hotspot_interface_real_update (NetworkWidgetsPage* base);
static void network_widgets_hotspot_interface_real_update_switch (NetworkWidgetsPage* base);
static void network_widgets_hotspot_interface_real_control_switch_activated (NetworkWidgetsPage* base);
static void network_widgets_hotspot_interface_connect_to_hotspot (NetworkWidgetsHotspotInterface* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void network_widgets_hotspot_interface_connect_to_hotspot_finish (NetworkWidgetsHotspotInterface* self,
                                                                  GAsyncResult* _res_);
static void network_widgets_hotspot_interface_connect_to_hotspot_data_free (gpointer _data);
static gboolean network_widgets_hotspot_interface_connect_to_hotspot_co (NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_);
static void network_widgets_hotspot_interface_connect_to_hotspot_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static GObject * network_widgets_hotspot_interface_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _network_widgets_hotspot_interface___lambda30_ (Block4Data* _data4_,
                                                     NMRemoteConnection* connection);
static void __network_widgets_hotspot_interface___lambda30__gfunc (gconstpointer data,
                                                            gpointer self);
static void _network_widgets_hotspot_interface_change_selected_connection_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                          gpointer self);
static void _network_widgets_page_open_advanced_settings_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _network_widgets_hotspot_interface___lambda31_ (NetworkWidgetsHotspotInterface* self);
static void __network_widgets_hotspot_interface___lambda31__g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void _network_widgets_page_update_nm_device_state_changed (NMDevice* _sender,
                                                           guint new_state,
                                                           guint old_state,
                                                           guint reason,
                                                           gpointer self);
static void _network_widgets_hotspot_interface_validate_entries_gtk_editable_changed (GtkEditable* _sender,
                                                                               gpointer self);
static void _network_widgets_hotspot_interface___lambda32_ (NetworkWidgetsHotspotInterface* self);
static void __network_widgets_hotspot_interface___lambda32__gtk_editable_changed (GtkEditable* _sender,
                                                                           gpointer self);
static void network_widgets_hotspot_interface_finalize (GObject * obj);
static GType network_widgets_hotspot_interface_get_type_once (void);
static void _vala_network_widgets_hotspot_interface_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_network_widgets_hotspot_interface_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);

static inline gpointer
network_widgets_hotspot_interface_get_instance_private (NetworkWidgetsHotspotInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsHotspotInterface_private_offset);
}

NetworkWidgetsHotspotInterface*
network_widgets_hotspot_interface_construct (GType object_type,
                                             NetworkWifiInterface* root_iface)
{
	NetworkWidgetsHotspotInterface * self = NULL;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	g_return_val_if_fail (root_iface != NULL, NULL);
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) root_iface);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("network-wireless-hotspot");
	_tmp3_ = _tmp2_;
	self = (NetworkWidgetsHotspotInterface*) g_object_new (object_type, "activatable", TRUE, "root-iface", root_iface, "description", _ ("Enabling Hotspot will disconnect from any connected wireless networks." \
" You will not be able to connect to a wireless network while Hotspot i" \
"s active."), "device", _tmp1_, "icon", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	return self;
}

NetworkWidgetsHotspotInterface*
network_widgets_hotspot_interface_new (NetworkWifiInterface* root_iface)
{
	return network_widgets_hotspot_interface_construct (NETWORK_WIDGETS_TYPE_HOTSPOT_INTERFACE, root_iface);
}

static void
network_widgets_hotspot_interface_real_update_name (NetworkWidgetsPage* base,
                                                    gint count)
{
	NetworkWidgetsHotspotInterface * self;
	self = (NetworkWidgetsHotspotInterface*) base;
	if (count <= 1) {
		switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _ ("Hotspot"));
	} else {
		NMDevice* _tmp0_;
		NMDevice* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nm_device_get_description (_tmp1_);
		_tmp3_ = g_strdup_printf (_ ("Hotspot %s"), _tmp2_);
		_tmp4_ = _tmp3_;
		switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp4_);
		_g_free0 (_tmp4_);
	}
}

static void
network_widgets_hotspot_interface_validate_entries (NetworkWidgetsHotspotInterface* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	GraniteValidatedEntry* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->key_entry;
	_tmp2_ = granite_validated_entry_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = gtk_widget_get_sensitive ((GtkWidget*) self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	}
	_tmp6_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp7_ = _tmp6_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp0_);
	_tmp8_ = self->priv->key_entry;
	_tmp9_ = granite_validated_entry_get_is_valid (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		GraniteValidatedEntry* _tmp11_;
		_tmp11_ = self->priv->key_entry;
		g_object_set ((GtkEntry*) _tmp11_, "secondary-icon-tooltip-text", _ ("Password needs to be at least 8 characters long"), NULL);
	} else {
		GraniteValidatedEntry* _tmp12_;
		_tmp12_ = self->priv->key_entry;
		g_object_set ((GtkEntry*) _tmp12_, "secondary-icon-tooltip-text", _ ("Password is at least 8 characters long"), NULL);
	}
}

static NMConnection*
network_widgets_hotspot_interface_get_selected_connection (NetworkWidgetsHotspotInterface* self)
{
	NMConnection* connection = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	NMConnection* _tmp6_ = NULL;
	NMConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->conn_combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->conn_combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &_tmp6_, -1);
	connection = _tmp6_;
	result = connection;
	return result;
}

static void
_network_widgets_hotspot_interface_change_selected_connection_network_utils_update_secret_callback (gpointer self)
{
	network_widgets_hotspot_interface_change_selected_connection ((NetworkWidgetsHotspotInterface*) self);
}

static void
network_widgets_hotspot_interface_change_selected_connection (NetworkWidgetsHotspotInterface* self)
{
	gboolean sensitive = FALSE;
	GtkComboBox* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkEntry* _tmp5_;
	GraniteValidatedEntry* _tmp6_;
	gchar* secret = NULL;
	NMConnection* selected_connection = NULL;
	NMConnection* _tmp7_;
	NMConnection* _tmp8_;
	GtkComboBox* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conn_combo;
	_tmp1_ = gtk_combo_box_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ == 0;
	_tmp3_ = self->priv->ssid_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, sensitive);
	_tmp4_ = self->priv->key_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, sensitive);
	_tmp5_ = self->priv->ssid_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, sensitive);
	_tmp6_ = self->priv->key_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, sensitive);
	secret = NULL;
	_tmp7_ = network_widgets_hotspot_interface_get_selected_connection (self);
	selected_connection = _tmp7_;
	_tmp8_ = selected_connection;
	if (_tmp8_ != NULL) {
		NMSettingWirelessSecurity* setting_wireless_security = NULL;
		NMConnection* _tmp9_;
		NMSettingWirelessSecurity* _tmp10_;
		gchar* key_mgmt = NULL;
		NMSettingWirelessSecurity* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp24_;
		_tmp9_ = selected_connection;
		_tmp10_ = nm_connection_get_setting_wireless_security (_tmp9_);
		setting_wireless_security = _tmp10_;
		_tmp11_ = setting_wireless_security;
		_tmp12_ = nm_setting_wireless_security_get_key_mgmt (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		key_mgmt = _tmp13_;
		_tmp14_ = key_mgmt;
		if (g_strcmp0 (_tmp14_, "none") == 0) {
			NMSettingWirelessSecurity* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = setting_wireless_security;
			g_object_get (_tmp15_, "wep-key0", &_tmp16_, NULL);
			_tmp17_ = _tmp16_;
			_g_free0 (secret);
			secret = _tmp17_;
		} else {
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			_tmp19_ = key_mgmt;
			if (g_strcmp0 (_tmp19_, "wpa-psk") == 0) {
				_tmp18_ = TRUE;
			} else {
				const gchar* _tmp20_;
				_tmp20_ = key_mgmt;
				_tmp18_ = g_strcmp0 (_tmp20_, "wpa-none") == 0;
			}
			if (_tmp18_) {
				NMSettingWirelessSecurity* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = setting_wireless_security;
				g_object_get (_tmp21_, "psk", &_tmp22_, NULL);
				_tmp23_ = _tmp22_;
				_g_free0 (secret);
				secret = _tmp23_;
			}
		}
		_tmp24_ = secret;
		if (_tmp24_ == NULL) {
			NMConnection* _tmp25_;
			_tmp25_ = selected_connection;
			network_utils_update_secrets (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, nm_remote_connection_get_type (), NMRemoteConnection), _network_widgets_hotspot_interface_change_selected_connection_network_utils_update_secret_callback, self);
		}
		_g_free0 (key_mgmt);
	}
	_tmp26_ = self->priv->conn_combo;
	_tmp27_ = gtk_combo_box_get_active (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != 0) {
		GtkEntry* _tmp29_;
		NMConnection* _tmp30_;
		NMSettingWireless* _tmp31_;
		GBytes* _tmp32_;
		gsize _tmp33_ = 0;
		guint8* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		GraniteValidatedEntry* _tmp39_;
		const gchar* _tmp40_;
		_tmp29_ = self->priv->ssid_entry;
		_tmp30_ = selected_connection;
		_tmp31_ = nm_connection_get_setting_wireless (_tmp30_);
		_tmp32_ = nm_setting_wireless_get_ssid (_tmp31_);
		_tmp34_ = g_bytes_get_data (_tmp32_, &_tmp33_);
		_tmp35_ = nm_utils_ssid_to_utf8 (_tmp34_, (gsize) _tmp33_);
		_tmp36_ = _tmp35_;
		gtk_editable_set_text ((GtkEditable*) _tmp29_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = secret;
		if (_tmp37_ == NULL) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("");
			_g_free0 (secret);
			secret = _tmp38_;
		}
		_tmp39_ = self->priv->key_entry;
		_tmp40_ = secret;
		gtk_editable_set_text ((GtkEditable*) _tmp39_, _tmp40_);
	}
	_g_free0 (secret);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
network_widgets_hotspot_interface_real_update (NetworkWidgetsPage* base)
{
	NetworkWidgetsHotspotInterface * self;
	NMDeviceWifi* wifi_device = NULL;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceWifi* _tmp2_;
	gboolean hotspot_mode = FALSE;
	NMDeviceWifi* _tmp3_;
	GtkButton* _tmp4_;
	gboolean sensitive = FALSE;
	GtkComboBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkEntry* _tmp9_;
	GraniteValidatedEntry* _tmp10_;
	gboolean root_iface_is_hotspot = FALSE;
	NetworkWifiInterface* _tmp11_;
	NMDeviceWifi* _tmp12_;
	NMDeviceState _tmp13_;
	NMDeviceState _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	self = (NetworkWidgetsHotspotInterface*) base;
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, nm_device_wifi_get_type (), NMDeviceWifi));
	wifi_device = _tmp2_;
	_tmp3_ = wifi_device;
	hotspot_mode = network_utils_get_device_is_hotspot (_tmp3_);
	_tmp4_ = self->priv->settings_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, hotspot_mode);
	sensitive = !hotspot_mode;
	_tmp5_ = self->priv->conn_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, sensitive);
	_tmp6_ = self->priv->conn_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, sensitive);
	_tmp7_ = self->priv->ssid_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, sensitive);
	_tmp8_ = self->priv->key_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, sensitive);
	_tmp9_ = self->priv->ssid_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, sensitive);
	_tmp10_ = self->priv->key_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, sensitive);
	network_widgets_page_update_switch ((NetworkWidgetsPage*) self);
	_tmp11_ = self->priv->_root_iface;
	_tmp12_ = _tmp11_->wifi_device;
	root_iface_is_hotspot = network_utils_get_device_is_hotspot (_tmp12_);
	if (root_iface_is_hotspot) {
		network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_ACTIVATED);
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
	} else {
		network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_DISCONNECTED);
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
	}
	_tmp13_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = network_utils_state_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp16_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (wifi_device);
}

static void
network_widgets_hotspot_interface_real_update_switch (NetworkWidgetsPage* base)
{
	NetworkWidgetsHotspotInterface * self;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	NMDeviceState _tmp2_;
	NMDeviceState _tmp3_;
	self = (NetworkWidgetsHotspotInterface*) base;
	self->priv->switch_updating = TRUE;
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp3_ = _tmp2_;
	gtk_switch_set_active (_tmp1_, _tmp3_ == NM_DEVICE_STATE_ACTIVATED);
	self->priv->switch_updating = FALSE;
}

static void
network_widgets_hotspot_interface_real_control_switch_activated (NetworkWidgetsPage* base)
{
	NetworkWidgetsHotspotInterface * self;
	NMDeviceWifi* wifi_device = NULL;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceWifi* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = (NetworkWidgetsHotspotInterface*) base;
	if (self->priv->switch_updating) {
		self->priv->switch_updating = FALSE;
		return;
	}
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, nm_device_wifi_get_type (), NMDeviceWifi));
	wifi_device = _tmp2_;
	_tmp4_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_switch_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		NMDeviceWifi* _tmp8_;
		_tmp8_ = wifi_device;
		_tmp3_ = network_utils_get_device_is_hotspot (_tmp8_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		NetworkNetworkManager* network_manager = NULL;
		NetworkNetworkManager* _tmp9_;
		NetworkNetworkManager* _tmp10_;
		NMDeviceWifi* _tmp11_;
		_tmp9_ = network_network_manager_get_default ();
		network_manager = _tmp9_;
		_tmp10_ = network_manager;
		_tmp11_ = wifi_device;
		network_network_manager_deactivate_hotspot (_tmp10_, _tmp11_, NULL, NULL);
	} else {
		network_widgets_hotspot_interface_connect_to_hotspot (self, NULL, NULL);
	}
	_g_object_unref0 (wifi_device);
}

static void
network_widgets_hotspot_interface_connect_to_hotspot_data_free (gpointer _data)
{
	NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkWidgetsHotspotInterfaceConnectToHotspotData, _data_);
}

static void
network_widgets_hotspot_interface_connect_to_hotspot (NetworkWidgetsHotspotInterface* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_;
	NetworkWidgetsHotspotInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NetworkWidgetsHotspotInterfaceConnectToHotspotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_widgets_hotspot_interface_connect_to_hotspot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	network_widgets_hotspot_interface_connect_to_hotspot_co (_data_);
}

static void
network_widgets_hotspot_interface_connect_to_hotspot_finish (NetworkWidgetsHotspotInterface* self,
                                                             GAsyncResult* _res_)
{
	NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
network_widgets_hotspot_interface_connect_to_hotspot_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_widgets_hotspot_interface_connect_to_hotspot_co (_data_);
}

static gboolean
network_widgets_hotspot_interface_connect_to_hotspot_co (NetworkWidgetsHotspotInterfaceConnectToHotspotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = network_network_manager_get_default ();
	_data_->network_manager = _data_->_tmp0_;
	_data_->_tmp1_ = network_widgets_page_get_device ((NetworkWidgetsPage*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->ssid_entry;
	_data_->_tmp4_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->key_entry;
	_data_->_tmp7_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = network_widgets_hotspot_interface_get_selected_connection (_data_->self);
	_data_->_state_ = 1;
	network_network_manager_activate_hotspot (_data_->network_manager, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, nm_device_wifi_get_type (), NMDeviceWifi), _data_->_tmp5_, _data_->_tmp8_, _data_->_tmp9_, network_widgets_hotspot_interface_connect_to_hotspot_ready, _data_);
	return FALSE;
	_state_1:
	network_network_manager_activate_hotspot_finish (_data_->network_manager, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

NetworkWifiInterface*
network_widgets_hotspot_interface_get_root_iface (NetworkWidgetsHotspotInterface* self)
{
	NetworkWifiInterface* result;
	NetworkWifiInterface* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root_iface;
	result = _tmp0_;
	return result;
}

static void
network_widgets_hotspot_interface_set_root_iface (NetworkWidgetsHotspotInterface* self,
                                                  NetworkWifiInterface* value)
{
	NetworkWifiInterface* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_hotspot_interface_get_root_iface (self);
	if (old_value != value) {
		NetworkWifiInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_root_iface);
		self->priv->_root_iface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_hotspot_interface_properties[NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NetworkWidgetsHotspotInterface* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->list_store);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
_network_widgets_hotspot_interface___lambda30_ (Block4Data* _data4_,
                                                NMRemoteConnection* connection)
{
	NetworkWidgetsHotspotInterface* self;
	self = _data4_->self;
	g_return_if_fail (connection != NULL);
	if (network_utils_get_connection_is_hotspot ((NMConnection*) connection)) {
		NMSettingWireless* setting_wireless = NULL;
		NMSettingWireless* _tmp0_;
		NMSettingWireless* _tmp1_;
		gchar* ssid_name = NULL;
		NMSettingWireless* _tmp2_;
		GBytes* _tmp3_;
		gsize _tmp4_ = 0;
		guint8* _tmp5_;
		gchar* _tmp6_;
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		GtkListStore* _tmp9_;
		GtkTreeIter _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		_tmp0_ = nm_connection_get_setting_wireless ((NMConnection*) connection);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		setting_wireless = _tmp1_;
		_tmp2_ = setting_wireless;
		_tmp3_ = nm_setting_wireless_get_ssid (_tmp2_);
		_tmp5_ = g_bytes_get_data (_tmp3_, &_tmp4_);
		_tmp6_ = nm_utils_ssid_to_utf8 (_tmp5_, (gsize) _tmp4_);
		ssid_name = _tmp6_;
		_tmp7_ = _data4_->list_store;
		gtk_list_store_append (_tmp7_, &_tmp8_);
		_data4_->iter = _tmp8_;
		_tmp9_ = _data4_->list_store;
		_tmp10_ = _data4_->iter;
		_tmp11_ = ssid_name;
		gtk_list_store_set (_tmp9_, &_tmp10_, 0, _tmp11_, 1, connection, -1);
		_tmp12_ = _data4_->i;
		_data4_->i = _tmp12_ + 1;
		_g_free0 (ssid_name);
		_g_object_unref0 (setting_wireless);
	}
}

static void
__network_widgets_hotspot_interface___lambda30__gfunc (gconstpointer data,
                                                       gpointer self)
{
	_network_widgets_hotspot_interface___lambda30_ (self, (NMRemoteConnection*) data);
}

static void
_network_widgets_hotspot_interface_change_selected_connection_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                     gpointer self)
{
	network_widgets_hotspot_interface_change_selected_connection ((NetworkWidgetsHotspotInterface*) self);
}

static void
_network_widgets_page_open_advanced_settings_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	network_widgets_page_open_advanced_settings ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_hotspot_interface___lambda31_ (NetworkWidgetsHotspotInterface* self)
{
	GtkButton* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = self->priv->settings_button;
	_tmp1_ = ((NetworkWidgetsPage*) self)->uuid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, g_strcmp0 (_tmp1_, "") != 0);
}

static void
__network_widgets_hotspot_interface___lambda31__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	_network_widgets_hotspot_interface___lambda31_ ((NetworkWidgetsHotspotInterface*) self);
}

static void
_network_widgets_page_update_nm_device_state_changed (NMDevice* _sender,
                                                      guint new_state,
                                                      guint old_state,
                                                      guint reason,
                                                      gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_hotspot_interface_validate_entries_gtk_editable_changed (GtkEditable* _sender,
                                                                          gpointer self)
{
	network_widgets_hotspot_interface_validate_entries ((NetworkWidgetsHotspotInterface*) self);
}

static void
_network_widgets_hotspot_interface___lambda32_ (NetworkWidgetsHotspotInterface* self)
{
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->key_entry;
	_tmp1_ = self->priv->key_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	granite_validated_entry_set_is_valid (_tmp0_, g_utf8_strlen (_tmp3_, (gssize) -1) >= 8);
	network_widgets_hotspot_interface_validate_entries (self);
}

static void
__network_widgets_hotspot_interface___lambda32__gtk_editable_changed (GtkEditable* _sender,
                                                                      gpointer self)
{
	_network_widgets_hotspot_interface___lambda32_ ((NetworkWidgetsHotspotInterface*) self);
}

static GObject *
network_widgets_hotspot_interface_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsHotspotInterface * self;
	Block4Data* _data4_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkEntry* _tmp2_ = NULL;
	GraniteValidatedEntry* _tmp3_ = NULL;
	GtkCheckButton* _tmp4_;
	GtkCheckButton* _tmp5_;
	GraniteValidatedEntry* _tmp6_;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkListStore* _tmp9_;
	GtkListStore* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkComboBox* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkListStore* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	GtkListStore* _tmp19_;
	GtkTreeIter _tmp20_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp21_;
	GPtrArray* connections = NULL;
	NetworkNetworkManager* _tmp22_;
	NMClient* _tmp23_;
	NMClient* _tmp24_;
	GPtrArray* _tmp25_;
	GPtrArray* _tmp26_;
	GPtrArray* _tmp27_;
	GtkComboBox* _tmp28_;
	GtkComboBox* _tmp29_;
	GtkLabel* _tmp30_ = NULL;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp31_ = NULL;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkComboBox* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkEntry* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GraniteValidatedEntry* _tmp43_;
	GtkGrid* _tmp44_;
	GtkCheckButton* _tmp45_;
	GtkGrid* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	const gchar* _tmp50_;
	NMDevice* _tmp51_;
	NMDevice* _tmp52_;
	GtkEntry* _tmp53_;
	GraniteValidatedEntry* _tmp54_;
	parent_class = G_OBJECT_CLASS (network_widgets_hotspot_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_HOTSPOT_INTERFACE, NetworkWidgetsHotspotInterface);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_get_host_name ();
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_editable_set_text ((GtkEditable*) _tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->ssid_entry);
	self->priv->ssid_entry = _tmp2_;
	_tmp3_ = granite_validated_entry_new ();
	gtk_entry_set_visibility ((GtkEntry*) _tmp3_, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->key_entry);
	self->priv->key_entry = _tmp3_;
	_tmp4_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Show Password"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->check_btn);
	self->priv->check_btn = _tmp4_;
	_tmp5_ = self->priv->check_btn;
	_tmp6_ = self->priv->key_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "active", (GObject*) _tmp6_, "visibility", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Network Name:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->ssid_label);
	self->priv->ssid_label = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->key_label);
	self->priv->key_label = _tmp8_;
	_tmp9_ = gtk_list_store_new (2, G_TYPE_STRING, nm_connection_get_type (), -1);
	_data4_->list_store = _tmp9_;
	_tmp10_ = _data4_->list_store;
	_tmp11_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->conn_combo);
	self->priv->conn_combo = _tmp11_;
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	renderer = _tmp12_;
	_tmp13_ = self->priv->conn_combo;
	_tmp14_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) _tmp14_, TRUE);
	_tmp15_ = self->priv->conn_combo;
	_tmp16_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, "text", 0);
	_tmp17_ = _data4_->list_store;
	gtk_list_store_append (_tmp17_, &_tmp18_);
	_data4_->iter = _tmp18_;
	_tmp19_ = _data4_->list_store;
	_tmp20_ = _data4_->iter;
	gtk_list_store_set (_tmp19_, &_tmp20_, 0, _ ("New…"), -1, -1);
	_data4_->i = 1;
	_tmp21_ = network_network_manager_get_default ();
	network_manager = _tmp21_;
	_tmp22_ = network_manager;
	_tmp23_ = network_network_manager_get_client (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = nm_client_get_connections (_tmp24_);
	_tmp26_ = _g_ptr_array_ref0 (_tmp25_);
	connections = _tmp26_;
	_tmp27_ = connections;
	g_ptr_array_foreach (_tmp27_, __network_widgets_hotspot_interface___lambda30__gfunc, _data4_);
	_tmp28_ = self->priv->conn_combo;
	gtk_combo_box_set_active (_tmp28_, 0);
	_tmp29_ = self->priv->conn_combo;
	g_signal_connect_object (_tmp29_, "changed", (GCallback) _network_widgets_hotspot_interface_change_selected_connection_gtk_combo_box_changed, self, 0);
	_tmp30_ = (GtkLabel*) gtk_label_new (_ ("Connection:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->conn_label);
	self->priv->conn_label = _tmp30_;
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp31_, 12);
	gtk_grid_set_row_spacing (_tmp31_, 6);
	g_object_ref_sink (_tmp31_);
	main_grid = _tmp31_;
	_tmp32_ = main_grid;
	_tmp33_ = self->priv->conn_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 1, 2, 1, 1);
	_tmp34_ = main_grid;
	_tmp35_ = self->priv->conn_combo;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 2, 2, 1, 1);
	_tmp36_ = main_grid;
	_tmp37_ = self->priv->ssid_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 3, 1, 1);
	_tmp38_ = main_grid;
	_tmp39_ = self->priv->ssid_entry;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 2, 3, 1, 1);
	_tmp40_ = main_grid;
	_tmp41_ = self->priv->key_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 1, 4, 1, 1);
	_tmp42_ = main_grid;
	_tmp43_ = self->priv->key_entry;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 2, 4, 1, 1);
	_tmp44_ = main_grid;
	_tmp45_ = self->priv->check_btn;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 2, 5, 1, 1);
	_tmp46_ = main_grid;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp46_);
	_tmp47_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Hotspot Settings…"));
	_g_object_unref0 (self->priv->settings_button);
	self->priv->settings_button = _tmp47_;
	_tmp48_ = self->priv->settings_button;
	g_signal_connect_object (_tmp48_, "clicked", (GCallback) _network_widgets_page_open_advanced_settings_gtk_button_clicked, (NetworkWidgetsPage*) self, 0);
	_tmp49_ = self->priv->settings_button;
	_tmp50_ = ((NetworkWidgetsPage*) self)->uuid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp49_, g_strcmp0 (_tmp50_, "") != 0);
	g_signal_connect_object ((GObject*) self, "notify::uuid", (GCallback) __network_widgets_hotspot_interface___lambda31__g_object_notify, self, 0);
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	network_widgets_hotspot_interface_validate_entries (self);
	_tmp51_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp52_ = _tmp51_;
	g_signal_connect_object (_tmp52_, "state-changed", (GCallback) _network_widgets_page_update_nm_device_state_changed, (NetworkWidgetsPage*) self, 0);
	_tmp53_ = self->priv->ssid_entry;
	g_signal_connect_object ((GtkEditable*) _tmp53_, "changed", (GCallback) _network_widgets_hotspot_interface_validate_entries_gtk_editable_changed, self, 0);
	_tmp54_ = self->priv->key_entry;
	g_signal_connect_object ((GtkEditable*) _tmp54_, "changed", (GCallback) __network_widgets_hotspot_interface___lambda32__gtk_editable_changed, self, 0);
	_g_object_unref0 (main_grid);
	_g_ptr_array_unref0 (connections);
	_g_object_unref0 (renderer);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
network_widgets_hotspot_interface_class_init (NetworkWidgetsHotspotInterfaceClass * klass,
                                              gpointer klass_data)
{
	network_widgets_hotspot_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsHotspotInterface_private_offset);
	((NetworkWidgetsPageClass *) klass)->update_name = (void (*) (NetworkWidgetsPage*, gint)) network_widgets_hotspot_interface_real_update_name;
	((NetworkWidgetsPageClass *) klass)->update = (void (*) (NetworkWidgetsPage*)) network_widgets_hotspot_interface_real_update;
	((NetworkWidgetsPageClass *) klass)->update_switch = (void (*) (NetworkWidgetsPage*)) network_widgets_hotspot_interface_real_update_switch;
	((NetworkWidgetsPageClass *) klass)->control_switch_activated = (void (*) (NetworkWidgetsPage*)) network_widgets_hotspot_interface_real_control_switch_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_hotspot_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_hotspot_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_hotspot_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_hotspot_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY, network_widgets_hotspot_interface_properties[NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY] = g_param_spec_object ("root-iface", "root-iface", "root-iface", NETWORK_TYPE_WIFI_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
network_widgets_hotspot_interface_instance_init (NetworkWidgetsHotspotInterface * self,
                                                 gpointer klass)
{
	self->priv = network_widgets_hotspot_interface_get_instance_private (self);
	self->priv->switch_updating = FALSE;
}

static void
network_widgets_hotspot_interface_finalize (GObject * obj)
{
	NetworkWidgetsHotspotInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_HOTSPOT_INTERFACE, NetworkWidgetsHotspotInterface);
	_g_object_unref0 (self->priv->_root_iface);
	_g_object_unref0 (self->priv->settings_button);
	_g_object_unref0 (self->priv->ssid_entry);
	_g_object_unref0 (self->priv->key_entry);
	_g_object_unref0 (self->priv->conn_label);
	_g_object_unref0 (self->priv->ssid_label);
	_g_object_unref0 (self->priv->key_label);
	_g_object_unref0 (self->priv->conn_combo);
	_g_object_unref0 (self->priv->check_btn);
	G_OBJECT_CLASS (network_widgets_hotspot_interface_parent_class)->finalize (obj);
}

static GType
network_widgets_hotspot_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsHotspotInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_hotspot_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsHotspotInterface), 0, (GInstanceInitFunc) network_widgets_hotspot_interface_instance_init, NULL };
	GType network_widgets_hotspot_interface_type_id;
	network_widgets_hotspot_interface_type_id = g_type_register_static (NETWORK_WIDGETS_TYPE_PAGE, "NetworkWidgetsHotspotInterface", &g_define_type_info, 0);
	NetworkWidgetsHotspotInterface_private_offset = g_type_add_instance_private (network_widgets_hotspot_interface_type_id, sizeof (NetworkWidgetsHotspotInterfacePrivate));
	return network_widgets_hotspot_interface_type_id;
}

GType
network_widgets_hotspot_interface_get_type (void)
{
	static volatile gsize network_widgets_hotspot_interface_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_hotspot_interface_type_id__once)) {
		GType network_widgets_hotspot_interface_type_id;
		network_widgets_hotspot_interface_type_id = network_widgets_hotspot_interface_get_type_once ();
		g_once_init_leave (&network_widgets_hotspot_interface_type_id__once, network_widgets_hotspot_interface_type_id);
	}
	return network_widgets_hotspot_interface_type_id__once;
}

static void
_vala_network_widgets_hotspot_interface_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	NetworkWidgetsHotspotInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_HOTSPOT_INTERFACE, NetworkWidgetsHotspotInterface);
	switch (property_id) {
		case NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY:
		g_value_set_object (value, network_widgets_hotspot_interface_get_root_iface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_hotspot_interface_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	NetworkWidgetsHotspotInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_HOTSPOT_INTERFACE, NetworkWidgetsHotspotInterface);
	switch (property_id) {
		case NETWORK_WIDGETS_HOTSPOT_INTERFACE_ROOT_IFACE_PROPERTY:
		network_widgets_hotspot_interface_set_root_iface (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

