/* rfkill.c generated by valac 0.56.17, the Vala compiler
 * generated from rfkill.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "network.h"
#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>
#include <fcntl.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_RF_KILL_EVENT (rf_kill_event_get_type ())
typedef struct _RFKillEvent RFKillEvent;
typedef enum  {
	RF_KILL_OPERATION_ADD = 0,
	RF_KILL_OPERATION_DELETE,
	RF_KILL_OPERATION_CHANGE,
	RF_KILL_OPERATION_CHANGE_ALL
} RFKillOperation;

#define TYPE_RF_KILL_OPERATION (rf_kill_operation_get_type ())
typedef struct _ParamSpecRFKillDevice ParamSpecRFKillDevice;
enum  {
	RF_KILL_DEVICE_CHANGED_SIGNAL,
	RF_KILL_DEVICE_NUM_SIGNALS
};
static guint rf_kill_device_signals[RF_KILL_DEVICE_NUM_SIGNALS] = {0};
enum  {
	RF_KILL_MANAGER_0_PROPERTY,
	RF_KILL_MANAGER_NUM_PROPERTIES
};
static GParamSpec* rf_kill_manager_properties[RF_KILL_MANAGER_NUM_PROPERTIES];
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _rf_kill_device_unref0(var) ((var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL)))
enum  {
	RF_KILL_MANAGER_DEVICE_ADDED_SIGNAL,
	RF_KILL_MANAGER_DEVICE_CHANGED_SIGNAL,
	RF_KILL_MANAGER_DEVICE_DELETED_SIGNAL,
	RF_KILL_MANAGER_NUM_SIGNALS
};
static guint rf_kill_manager_signals[RF_KILL_MANAGER_NUM_SIGNALS] = {0};

struct _RFKillEvent {
	guint32 idx;
	guint8 type;
	guint8 op;
	guint8 soft;
	guint8 hard;
};

struct _ParamSpecRFKillDevice {
	GParamSpec parent_instance;
};

struct _RFKillManagerPrivate {
	GList* _devices;
};

static gpointer rf_kill_device_parent_class = NULL;
static gint RFKillManager_private_offset;
static gpointer rf_kill_manager_parent_class = NULL;

VALA_EXTERN RFKillDevice* rf_kill_device_new (RFKillManager* manager,
                                  guint32 idx,
                                  RFKillDeviceType device_type,
                                  gboolean software_lock,
                                  gboolean hardware_lock);
VALA_EXTERN RFKillDevice* rf_kill_device_construct (GType object_type,
                                        RFKillManager* manager,
                                        guint32 idx,
                                        RFKillDeviceType device_type,
                                        gboolean software_lock,
                                        gboolean hardware_lock);
VALA_EXTERN GType rf_kill_event_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RFKillEvent* rf_kill_event_dup (const RFKillEvent* self);
VALA_EXTERN void rf_kill_event_free (RFKillEvent* self);
VALA_EXTERN GType rf_kill_operation_get_type (void) G_GNUC_CONST ;
static void rf_kill_device_finalize (RFKillDevice * obj);
static GType rf_kill_device_get_type_once (void);
static void _rf_kill_device_unref0_ (gpointer var);
static inline void _g_list_free__rf_kill_device_unref0_ (GList* self);
static gboolean rf_kill_manager_read_event (RFKillManager* self);
static gboolean __lambda5_ (RFKillManager* self);
static gboolean ___lambda5__gio_func (GIOChannel* source,
                               GIOCondition condition,
                               gpointer self);
static RFKillDevice* rf_kill_manager_get_device (RFKillManager* self,
                                          guint32 idx);
static void g_cclosure_user_marshal_VOID__RF_KILL_DEVICE (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void rf_kill_manager_finalize (GObject * obj);
static GType rf_kill_manager_get_type_once (void);

static GType
rf_kill_device_type_get_type_once (void)
{
	static const GEnumValue values[] = {{RF_KILL_DEVICE_TYPE_ALL, "RF_KILL_DEVICE_TYPE_ALL", "all"}, {RF_KILL_DEVICE_TYPE_WLAN, "RF_KILL_DEVICE_TYPE_WLAN", "wlan"}, {RF_KILL_DEVICE_TYPE_BLUETOOTH, "RF_KILL_DEVICE_TYPE_BLUETOOTH", "bluetooth"}, {RF_KILL_DEVICE_TYPE_UWB, "RF_KILL_DEVICE_TYPE_UWB", "uwb"}, {RF_KILL_DEVICE_TYPE_WIMAX, "RF_KILL_DEVICE_TYPE_WIMAX", "wimax"}, {RF_KILL_DEVICE_TYPE_WMAN, "RF_KILL_DEVICE_TYPE_WMAN", "wman"}, {0, NULL, NULL}};
	GType rf_kill_device_type_type_id;
	rf_kill_device_type_type_id = g_enum_register_static ("RFKillDeviceType", values);
	return rf_kill_device_type_type_id;
}

GType
rf_kill_device_type_get_type (void)
{
	static volatile gsize rf_kill_device_type_type_id__once = 0;
	if (g_once_init_enter (&rf_kill_device_type_type_id__once)) {
		GType rf_kill_device_type_type_id;
		rf_kill_device_type_type_id = rf_kill_device_type_get_type_once ();
		g_once_init_leave (&rf_kill_device_type_type_id__once, rf_kill_device_type_type_id);
	}
	return rf_kill_device_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RFKillDevice*
rf_kill_device_construct (GType object_type,
                          RFKillManager* manager,
                          guint32 idx,
                          RFKillDeviceType device_type,
                          gboolean software_lock,
                          gboolean hardware_lock)
{
	RFKillDevice* self = NULL;
	RFKillManager* _tmp0_;
	g_return_val_if_fail (manager != NULL, NULL);
	self = (RFKillDevice*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->manager);
	self->manager = _tmp0_;
	self->idx = idx;
	self->_device_type = device_type;
	self->_software_lock = software_lock;
	self->_hardware_lock = hardware_lock;
	return self;
}

RFKillDevice*
rf_kill_device_new (RFKillManager* manager,
                    guint32 idx,
                    RFKillDeviceType device_type,
                    gboolean software_lock,
                    gboolean hardware_lock)
{
	return rf_kill_device_construct (TYPE_RF_KILL_DEVICE, manager, idx, device_type, software_lock, hardware_lock);
}

gboolean
rf_kill_device_get_software_lock (RFKillDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_software_lock;
	return result;
}

void
rf_kill_device_set_software_lock (RFKillDevice* self,
                                  gboolean value)
{
	RFKillEvent event = {0};
	gint _tmp0_ = 0;
	RFKillManager* _tmp1_;
	g_return_if_fail (self != NULL);
	memset (&event, 0, sizeof (RFKillEvent));
	event.idx = self->idx;
	event.op = (guint8) RF_KILL_OPERATION_CHANGE;
	if (value) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	event.soft = (guint8) _tmp0_;
	_tmp1_ = self->manager;
	if (write (_tmp1_->fd, &event, (gsize) 8) != ((gssize) 8)) {
		return;
	}
}

gboolean
rf_kill_device_get_hardware_lock (RFKillDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_hardware_lock;
	return result;
}

RFKillDeviceType
rf_kill_device_get_device_type (RFKillDevice* self)
{
	RFKillDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->_device_type;
	return result;
}

static void
value_rf_kill_device_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_rf_kill_device_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rf_kill_device_unref (value->data[0].v_pointer);
	}
}

static void
value_rf_kill_device_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rf_kill_device_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_rf_kill_device_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_rf_kill_device_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RFKillDevice * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rf_kill_device_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_rf_kill_device_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	RFKillDevice ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rf_kill_device_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_rf_kill_device (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecRFKillDevice* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_RF_KILL_DEVICE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_rf_kill_device (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RF_KILL_DEVICE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_rf_kill_device (GValue* value,
                          gpointer v_object)
{
	RFKillDevice * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RF_KILL_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RF_KILL_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rf_kill_device_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rf_kill_device_unref (old);
	}
}

void
value_take_rf_kill_device (GValue* value,
                           gpointer v_object)
{
	RFKillDevice * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RF_KILL_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RF_KILL_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rf_kill_device_unref (old);
	}
}

static void
rf_kill_device_class_init (RFKillDeviceClass * klass,
                           gpointer klass_data)
{
	rf_kill_device_parent_class = g_type_class_peek_parent (klass);
	((RFKillDeviceClass *) klass)->finalize = rf_kill_device_finalize;
	rf_kill_device_signals[RF_KILL_DEVICE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_RF_KILL_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
rf_kill_device_instance_init (RFKillDevice * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
rf_kill_device_finalize (RFKillDevice * obj)
{
	RFKillDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RF_KILL_DEVICE, RFKillDevice);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->manager);
}

static GType
rf_kill_device_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_rf_kill_device_init, value_rf_kill_device_free_value, value_rf_kill_device_copy_value, value_rf_kill_device_peek_pointer, "p", value_rf_kill_device_collect_value, "p", value_rf_kill_device_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RFKillDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rf_kill_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RFKillDevice), 0, (GInstanceInitFunc) rf_kill_device_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rf_kill_device_type_id;
	rf_kill_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RFKillDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return rf_kill_device_type_id;
}

GType
rf_kill_device_get_type (void)
{
	static volatile gsize rf_kill_device_type_id__once = 0;
	if (g_once_init_enter (&rf_kill_device_type_id__once)) {
		GType rf_kill_device_type_id;
		rf_kill_device_type_id = rf_kill_device_get_type_once ();
		g_once_init_leave (&rf_kill_device_type_id__once, rf_kill_device_type_id);
	}
	return rf_kill_device_type_id__once;
}

gpointer
rf_kill_device_ref (gpointer instance)
{
	RFKillDevice * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rf_kill_device_unref (gpointer instance)
{
	RFKillDevice * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RF_KILL_DEVICE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
rf_kill_manager_get_instance_private (RFKillManager* self)
{
	return G_STRUCT_MEMBER_P (self, RFKillManager_private_offset);
}

static void
_rf_kill_device_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL));
}

static inline void
_g_list_free__rf_kill_device_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rf_kill_device_unref0_);
}

RFKillManager*
rf_kill_manager_construct (GType object_type)
{
	RFKillManager * self = NULL;
	self = (RFKillManager*) g_object_new (object_type, NULL);
	(self->priv->_devices == NULL) ? NULL : (self->priv->_devices = (_g_list_free__rf_kill_device_unref0_ (self->priv->_devices), NULL));
	self->priv->_devices = NULL;
	return self;
}

RFKillManager*
rf_kill_manager_new (void)
{
	return rf_kill_manager_construct (TYPE_RF_KILL_MANAGER);
}

static gboolean
__lambda5_ (RFKillManager* self)
{
	gboolean result;
	result = rf_kill_manager_read_event (self);
	return result;
}

static gboolean
___lambda5__gio_func (GIOChannel* source,
                      GIOCondition condition,
                      gpointer self)
{
	gboolean result;
	result = __lambda5_ ((RFKillManager*) self);
	return result;
}

void
rf_kill_manager_open (RFKillManager* self)
{
	GIOChannel* channel = NULL;
	GIOChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->fd = open ("/dev/rfkill", O_RDWR, (mode_t) 0);
	fcntl (self->fd, F_SETFL, O_NONBLOCK, NULL);
	while (TRUE) {
		if (!rf_kill_manager_read_event (self)) {
			break;
		}
	}
	_tmp0_ = g_io_channel_unix_new (self->fd);
	channel = _tmp0_;
	g_io_add_watch (channel, (G_IO_IN | G_IO_HUP) | G_IO_ERR, ___lambda5__gio_func, self);
	_g_io_channel_unref0 (channel);
}

static gpointer
_rf_kill_device_ref0 (gpointer self)
{
	return self ? rf_kill_device_ref (self) : NULL;
}

GList*
rf_kill_manager_get_devices (RFKillManager* self)
{
	GList* devices = NULL;
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	devices = NULL;
	_tmp0_ = self->priv->_devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp0_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			RFKillDevice* _tmp1_;
			RFKillDevice* device = NULL;
			_tmp1_ = _rf_kill_device_ref0 ((RFKillDevice*) device_it->data);
			device = _tmp1_;
			{
				RFKillDevice* _tmp2_;
				RFKillDevice* _tmp3_;
				_tmp2_ = device;
				_tmp3_ = _rf_kill_device_ref0 (_tmp2_);
				devices = g_list_append (devices, _tmp3_);
				_rf_kill_device_unref0 (device);
			}
		}
	}
	result = devices;
	return result;
}

void
rf_kill_manager_set_software_lock (RFKillManager* self,
                                   RFKillDeviceType type,
                                   gboolean lock_enabled)
{
	RFKillEvent event = {0};
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	memset (&event, 0, sizeof (RFKillEvent));
	event.type = (guint8) type;
	event.op = (guint8) RF_KILL_OPERATION_CHANGE_ALL;
	if (lock_enabled) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	event.soft = (guint8) _tmp0_;
	if (write (self->fd, &event, (gsize) 8) != ((gssize) 8)) {
		return;
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static gboolean
rf_kill_manager_read_event (RFKillManager* self)
{
	RFKillEvent event = {0};
	RFKillEvent _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&event, 0, sizeof (RFKillEvent));
	if (read (self->fd, &event, (gsize) 8) != ((gssize) 8)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = event;
	switch (_tmp0_.op) {
		case RF_KILL_OPERATION_ADD:
		{
			RFKillDevice* device = NULL;
			RFKillEvent _tmp1_;
			RFKillEvent _tmp2_;
			RFKillEvent _tmp3_;
			RFKillEvent _tmp4_;
			RFKillDevice* _tmp5_;
			RFKillDevice* _tmp6_;
			RFKillDevice* _tmp7_;
			RFKillDevice* _tmp8_;
			_tmp1_ = event;
			_tmp2_ = event;
			_tmp3_ = event;
			_tmp4_ = event;
			_tmp5_ = rf_kill_device_new (self, _tmp1_.idx, (RFKillDeviceType) _tmp2_.type, ((gint) _tmp3_.soft) != 0, ((gint) _tmp4_.hard) != 0);
			device = _tmp5_;
			_tmp6_ = device;
			_tmp7_ = _rf_kill_device_ref0 (_tmp6_);
			self->priv->_devices = g_list_append (self->priv->_devices, _tmp7_);
			_tmp8_ = device;
			g_signal_emit (self, rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_ADDED_SIGNAL], 0, _tmp8_);
			_rf_kill_device_unref0 (device);
			break;
		}
		case RF_KILL_OPERATION_DELETE:
		{
			RFKillDevice* device = NULL;
			RFKillEvent _tmp9_;
			RFKillDevice* _tmp10_;
			RFKillDevice* _tmp11_;
			_tmp9_ = event;
			_tmp10_ = rf_kill_manager_get_device (self, _tmp9_.idx);
			device = _tmp10_;
			_tmp11_ = device;
			if (_tmp11_ != NULL) {
				RFKillDevice* _tmp12_;
				RFKillDevice* _tmp13_;
				_tmp12_ = device;
				self->priv->_devices = vala_g_list_remove_full (self->priv->_devices, _tmp12_, _rf_kill_device_unref0_);
				_tmp13_ = device;
				g_signal_emit (self, rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_DELETED_SIGNAL], 0, _tmp13_);
			}
			_rf_kill_device_unref0 (device);
			break;
		}
		case RF_KILL_OPERATION_CHANGE:
		{
			RFKillDevice* device = NULL;
			RFKillEvent _tmp14_;
			RFKillDevice* _tmp15_;
			RFKillDevice* _tmp16_;
			_tmp14_ = event;
			_tmp15_ = rf_kill_manager_get_device (self, _tmp14_.idx);
			device = _tmp15_;
			_tmp16_ = device;
			if (_tmp16_ != NULL) {
				RFKillDevice* _tmp17_;
				RFKillEvent _tmp18_;
				RFKillDevice* _tmp19_;
				RFKillEvent _tmp20_;
				RFKillDevice* _tmp21_;
				RFKillDevice* _tmp22_;
				_tmp17_ = device;
				_tmp18_ = event;
				_tmp17_->_software_lock = ((gint) _tmp18_.soft) != 0;
				_tmp19_ = device;
				_tmp20_ = event;
				_tmp19_->_hardware_lock = ((gint) _tmp20_.hard) != 0;
				_tmp21_ = device;
				g_signal_emit (_tmp21_, rf_kill_device_signals[RF_KILL_DEVICE_CHANGED_SIGNAL], 0);
				_tmp22_ = device;
				g_signal_emit (self, rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_CHANGED_SIGNAL], 0, _tmp22_);
			}
			_rf_kill_device_unref0 (device);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

static RFKillDevice*
rf_kill_manager_get_device (RFKillManager* self,
                            guint32 idx)
{
	GList* _tmp0_;
	RFKillDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp0_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			RFKillDevice* _tmp1_;
			RFKillDevice* device = NULL;
			_tmp1_ = _rf_kill_device_ref0 ((RFKillDevice*) device_it->data);
			device = _tmp1_;
			{
				RFKillDevice* _tmp2_;
				_tmp2_ = device;
				if (_tmp2_->idx == idx) {
					result = device;
					return result;
				}
				_rf_kill_device_unref0 (device);
			}
		}
	}
	result = NULL;
	return result;
}

static void
g_cclosure_user_marshal_VOID__RF_KILL_DEVICE (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__RF_KILL_DEVICE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__RF_KILL_DEVICE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__RF_KILL_DEVICE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_rf_kill_device (param_values + 1), data2);
}

static void
rf_kill_manager_class_init (RFKillManagerClass * klass,
                            gpointer klass_data)
{
	rf_kill_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RFKillManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rf_kill_manager_finalize;
	rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", TYPE_RF_KILL_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__RF_KILL_DEVICE, G_TYPE_NONE, 1, TYPE_RF_KILL_DEVICE);
	rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_CHANGED_SIGNAL] = g_signal_new ("device-changed", TYPE_RF_KILL_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__RF_KILL_DEVICE, G_TYPE_NONE, 1, TYPE_RF_KILL_DEVICE);
	rf_kill_manager_signals[RF_KILL_MANAGER_DEVICE_DELETED_SIGNAL] = g_signal_new ("device-deleted", TYPE_RF_KILL_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__RF_KILL_DEVICE, G_TYPE_NONE, 1, TYPE_RF_KILL_DEVICE);
}

static void
rf_kill_manager_instance_init (RFKillManager * self,
                               gpointer klass)
{
	self->priv = rf_kill_manager_get_instance_private (self);
	self->fd = -1;
}

static void
rf_kill_manager_finalize (GObject * obj)
{
	RFKillManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RF_KILL_MANAGER, RFKillManager);
	(self->priv->_devices == NULL) ? NULL : (self->priv->_devices = (_g_list_free__rf_kill_device_unref0_ (self->priv->_devices), NULL));
	G_OBJECT_CLASS (rf_kill_manager_parent_class)->finalize (obj);
}

static GType
rf_kill_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RFKillManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rf_kill_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RFKillManager), 0, (GInstanceInitFunc) rf_kill_manager_instance_init, NULL };
	GType rf_kill_manager_type_id;
	rf_kill_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RFKillManager", &g_define_type_info, 0);
	RFKillManager_private_offset = g_type_add_instance_private (rf_kill_manager_type_id, sizeof (RFKillManagerPrivate));
	return rf_kill_manager_type_id;
}

GType
rf_kill_manager_get_type (void)
{
	static volatile gsize rf_kill_manager_type_id__once = 0;
	if (g_once_init_enter (&rf_kill_manager_type_id__once)) {
		GType rf_kill_manager_type_id;
		rf_kill_manager_type_id = rf_kill_manager_get_type_once ();
		g_once_init_leave (&rf_kill_manager_type_id__once, rf_kill_manager_type_id);
	}
	return rf_kill_manager_type_id__once;
}

RFKillEvent*
rf_kill_event_dup (const RFKillEvent* self)
{
	RFKillEvent* dup;
	dup = g_new0 (RFKillEvent, 1);
	memcpy (dup, self, sizeof (RFKillEvent));
	return dup;
}

void
rf_kill_event_free (RFKillEvent* self)
{
	g_free (self);
}

static GType
rf_kill_event_get_type_once (void)
{
	GType rf_kill_event_type_id;
	rf_kill_event_type_id = g_boxed_type_register_static ("RFKillEvent", (GBoxedCopyFunc) rf_kill_event_dup, (GBoxedFreeFunc) rf_kill_event_free);
	return rf_kill_event_type_id;
}

GType
rf_kill_event_get_type (void)
{
	static volatile gsize rf_kill_event_type_id__once = 0;
	if (g_once_init_enter (&rf_kill_event_type_id__once)) {
		GType rf_kill_event_type_id;
		rf_kill_event_type_id = rf_kill_event_get_type_once ();
		g_once_init_leave (&rf_kill_event_type_id__once, rf_kill_event_type_id);
	}
	return rf_kill_event_type_id__once;
}

static GType
rf_kill_operation_get_type_once (void)
{
	static const GEnumValue values[] = {{RF_KILL_OPERATION_ADD, "RF_KILL_OPERATION_ADD", "add"}, {RF_KILL_OPERATION_DELETE, "RF_KILL_OPERATION_DELETE", "delete"}, {RF_KILL_OPERATION_CHANGE, "RF_KILL_OPERATION_CHANGE", "change"}, {RF_KILL_OPERATION_CHANGE_ALL, "RF_KILL_OPERATION_CHANGE_ALL", "change-all"}, {0, NULL, NULL}};
	GType rf_kill_operation_type_id;
	rf_kill_operation_type_id = g_enum_register_static ("RFKillOperation", values);
	return rf_kill_operation_type_id;
}

GType
rf_kill_operation_get_type (void)
{
	static volatile gsize rf_kill_operation_type_id__once = 0;
	if (g_once_init_enter (&rf_kill_operation_type_id__once)) {
		GType rf_kill_operation_type_id;
		rf_kill_operation_type_id = rf_kill_operation_get_type_once ();
		g_once_init_leave (&rf_kill_operation_type_id__once, rf_kill_operation_type_id);
	}
	return rf_kill_operation_type_id__once;
}

