/* SettingsOption.c generated by valac 0.56.17, the Vala compiler
 * generated from SettingsOption.vala, do not modify */

/*
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "notifications.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WIDGETS_SETTINGS_OPTION_0_PROPERTY,
	WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY,
	WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY,
	WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY,
	WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY,
	WIDGETS_SETTINGS_OPTION_NUM_PROPERTIES
};
static GParamSpec* widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WidgetsSettingsOptionPrivate {
	gboolean _active;
	gchar* _image_path;
	gchar* _title;
	gchar* _description;
	GtkGrid* card;
	GtkSettings* gtk_settings;
};

static gint WidgetsSettingsOption_private_offset;
static gpointer widgets_settings_option_parent_class = NULL;

static void widgets_settings_option_update_image_resource (WidgetsSettingsOption* self);
static GObject * widgets_settings_option_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _widgets_settings_option___lambda8_ (WidgetsSettingsOption* self);
static void __widgets_settings_option___lambda8__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void widgets_settings_option_finalize (GObject * obj);
static GType widgets_settings_option_get_type_once (void);
static void _vala_widgets_settings_option_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_widgets_settings_option_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
widgets_settings_option_get_instance_private (WidgetsSettingsOption* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsSettingsOption_private_offset);
}

WidgetsSettingsOption*
widgets_settings_option_construct (GType object_type,
                                   const gchar* image_path,
                                   const gchar* title,
                                   const gchar* description)
{
	WidgetsSettingsOption * self = NULL;
	g_return_val_if_fail (image_path != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (WidgetsSettingsOption*) g_object_new (object_type, "image-path", image_path, "title", title, "description", description, NULL);
	return self;
}

WidgetsSettingsOption*
widgets_settings_option_new (const gchar* image_path,
                             const gchar* title,
                             const gchar* description)
{
	return widgets_settings_option_construct (WIDGETS_TYPE_SETTINGS_OPTION, image_path, title, description);
}

static void
widgets_settings_option_update_image_resource (WidgetsSettingsOption* self)
{
	GtkSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gtk_settings;
	g_object_get (_tmp0_, "gtk-application-prefer-dark-theme", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkGrid* _tmp3_;
		_tmp3_ = self->priv->card;
		gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "dark");
	} else {
		GtkGrid* _tmp4_;
		_tmp4_ = self->priv->card;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp4_, "dark");
	}
}

gboolean
widgets_settings_option_get_active (WidgetsSettingsOption* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
widgets_settings_option_set_active (WidgetsSettingsOption* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = widgets_settings_option_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY]);
	}
}

const gchar*
widgets_settings_option_get_image_path (WidgetsSettingsOption* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_path;
	result = _tmp0_;
	return result;
}

static void
widgets_settings_option_set_image_path (WidgetsSettingsOption* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = widgets_settings_option_get_image_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_image_path);
		self->priv->_image_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY]);
	}
}

const gchar*
widgets_settings_option_get_title (WidgetsSettingsOption* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
widgets_settings_option_set_title (WidgetsSettingsOption* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = widgets_settings_option_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY]);
	}
}

const gchar*
widgets_settings_option_get_description (WidgetsSettingsOption* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
widgets_settings_option_set_description (WidgetsSettingsOption* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = widgets_settings_option_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_widgets_settings_option___lambda8_ (WidgetsSettingsOption* self)
{
	widgets_settings_option_update_image_resource (self);
}

static void
__widgets_settings_option___lambda8__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_widgets_settings_option___lambda8_ ((WidgetsSettingsOption*) self);
}

static GObject *
widgets_settings_option_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WidgetsSettingsOption * self;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* _tmp1_;
	const gchar* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkSwitch* widget = NULL;
	GtkSwitch* _tmp5_ = NULL;
	GraniteHeaderLabel* header_label = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkWidget* _tmp10_;
	GraniteHeaderLabel* _tmp11_ = NULL;
	GraniteHeaderLabel* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkGrid* _tmp14_;
	GtkSettings* _tmp15_;
	GtkSettings* _tmp16_;
	GtkSettings* _tmp17_;
	GtkSwitch* _tmp18_;
	parent_class = G_OBJECT_CLASS (widgets_settings_option_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SETTINGS_OPTION, WidgetsSettingsOption);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->card);
	self->priv->card = _tmp0_;
	_tmp1_ = self->priv->card;
	_tmp2_ = self->priv->_image_path;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->card;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_CARD);
	_tmp4_ = self->priv->card;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp5_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp5_);
	widget = _tmp5_;
	_tmp6_ = self->priv->_title;
	_tmp7_ = self->priv->_description;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = widget;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = granite_header_label_new (_tmp6_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_FILL);
	granite_header_label_set_secondary_text (_tmp11_, _tmp8_);
	_g_free0 (_tmp8_);
	granite_header_label_set_mnemonic_widget (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	header_label = _tmp11_;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp12_ = header_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp12_, 0, 0, 1, 1);
	_tmp13_ = widget;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp13_, 1, 0, 1, 1);
	_tmp14_ = self->priv->card;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 0, 1, 2, 1);
	_tmp15_ = gtk_settings_get_default ();
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->gtk_settings);
	self->priv->gtk_settings = _tmp16_;
	_tmp17_ = self->priv->gtk_settings;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::gtk-application-prefer-dark-theme", (GCallback) __widgets_settings_option___lambda8__g_object_notify, self, 0);
	widgets_settings_option_update_image_resource (self);
	_tmp18_ = widget;
	g_object_bind_property_with_closures ((GObject*) self, "active", (GObject*) _tmp18_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (header_label);
	_g_object_unref0 (widget);
	return obj;
}

static void
widgets_settings_option_class_init (WidgetsSettingsOptionClass * klass,
                                    gpointer klass_data)
{
	widgets_settings_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsSettingsOption_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_widgets_settings_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_widgets_settings_option_set_property;
	G_OBJECT_CLASS (klass)->constructor = widgets_settings_option_constructor;
	G_OBJECT_CLASS (klass)->finalize = widgets_settings_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY] = g_param_spec_string ("image-path", "image-path", "image-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY, widgets_settings_option_properties[WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
widgets_settings_option_instance_init (WidgetsSettingsOption * self,
                                       gpointer klass)
{
	self->priv = widgets_settings_option_get_instance_private (self);
}

static void
widgets_settings_option_finalize (GObject * obj)
{
	WidgetsSettingsOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SETTINGS_OPTION, WidgetsSettingsOption);
	_g_free0 (self->priv->_image_path);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->card);
	_g_object_unref0 (self->priv->gtk_settings);
	G_OBJECT_CLASS (widgets_settings_option_parent_class)->finalize (obj);
}

static GType
widgets_settings_option_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsSettingsOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_settings_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsSettingsOption), 0, (GInstanceInitFunc) widgets_settings_option_instance_init, NULL };
	GType widgets_settings_option_type_id;
	widgets_settings_option_type_id = g_type_register_static (gtk_grid_get_type (), "WidgetsSettingsOption", &g_define_type_info, 0);
	WidgetsSettingsOption_private_offset = g_type_add_instance_private (widgets_settings_option_type_id, sizeof (WidgetsSettingsOptionPrivate));
	return widgets_settings_option_type_id;
}

GType
widgets_settings_option_get_type (void)
{
	static volatile gsize widgets_settings_option_type_id__once = 0;
	if (g_once_init_enter (&widgets_settings_option_type_id__once)) {
		GType widgets_settings_option_type_id;
		widgets_settings_option_type_id = widgets_settings_option_get_type_once ();
		g_once_init_leave (&widgets_settings_option_type_id__once, widgets_settings_option_type_id);
	}
	return widgets_settings_option_type_id__once;
}

static void
_vala_widgets_settings_option_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	WidgetsSettingsOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WIDGETS_TYPE_SETTINGS_OPTION, WidgetsSettingsOption);
	switch (property_id) {
		case WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY:
		g_value_set_boolean (value, widgets_settings_option_get_active (self));
		break;
		case WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY:
		g_value_set_string (value, widgets_settings_option_get_image_path (self));
		break;
		case WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY:
		g_value_set_string (value, widgets_settings_option_get_title (self));
		break;
		case WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, widgets_settings_option_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_widgets_settings_option_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	WidgetsSettingsOption * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WIDGETS_TYPE_SETTINGS_OPTION, WidgetsSettingsOption);
	switch (property_id) {
		case WIDGETS_SETTINGS_OPTION_ACTIVE_PROPERTY:
		widgets_settings_option_set_active (self, g_value_get_boolean (value));
		break;
		case WIDGETS_SETTINGS_OPTION_IMAGE_PATH_PROPERTY:
		widgets_settings_option_set_image_path (self, g_value_get_string (value));
		break;
		case WIDGETS_SETTINGS_OPTION_TITLE_PROPERTY:
		widgets_settings_option_set_title (self, g_value_get_string (value));
		break;
		case WIDGETS_SETTINGS_OPTION_DESCRIPTION_PROPERTY:
		widgets_settings_option_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

