/* WebRestriction.c generated by valac 0.56.17, the Vala compiler
 * generated from WebRestriction.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define PC_DAEMON_WEB_RESTRICTION_IPTABLES_EXEC "iptables"
#define PC_DAEMON_WEB_RESTRICTION_BYTES 65535
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_RESTRICTION (pc_daemon_restriction_get_type ())
#define PC_DAEMON_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestriction))
#define PC_DAEMON_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestrictionClass))
#define PC_DAEMON_IS_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_RESTRICTION))
#define PC_DAEMON_IS_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_RESTRICTION))
#define PC_DAEMON_RESTRICTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_RESTRICTION, PCDaemonRestrictionClass))

typedef struct _PCDaemonRestriction PCDaemonRestriction;
typedef struct _PCDaemonRestrictionClass PCDaemonRestrictionClass;
typedef struct _PCDaemonRestrictionPrivate PCDaemonRestrictionPrivate;

#define PC_DAEMON_TYPE_USER_CONFIG (pc_daemon_user_config_get_type ())
#define PC_DAEMON_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig))
#define PC_DAEMON_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))
#define PC_DAEMON_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))

typedef struct _PCDaemonUserConfig PCDaemonUserConfig;
typedef struct _PCDaemonUserConfigClass PCDaemonUserConfigClass;

#define PC_DAEMON_TYPE_WEB_RESTRICTION (pc_daemon_web_restriction_get_type ())
#define PC_DAEMON_WEB_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_WEB_RESTRICTION, PCDaemonWebRestriction))
#define PC_DAEMON_WEB_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_WEB_RESTRICTION, PCDaemonWebRestrictionClass))
#define PC_DAEMON_IS_WEB_RESTRICTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_WEB_RESTRICTION))
#define PC_DAEMON_IS_WEB_RESTRICTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_WEB_RESTRICTION))
#define PC_DAEMON_WEB_RESTRICTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_WEB_RESTRICTION, PCDaemonWebRestrictionClass))

typedef struct _PCDaemonWebRestriction PCDaemonWebRestriction;
typedef struct _PCDaemonWebRestrictionClass PCDaemonWebRestrictionClass;
typedef struct _PCDaemonWebRestrictionPrivate PCDaemonWebRestrictionPrivate;
enum  {
	PC_DAEMON_WEB_RESTRICTION_0_PROPERTY,
	PC_DAEMON_WEB_RESTRICTION_NUM_PROPERTIES
};
static GParamSpec* pc_daemon_web_restriction_properties[PC_DAEMON_WEB_RESTRICTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PCDaemonRestriction {
	GObject parent_instance;
	PCDaemonRestrictionPrivate * priv;
	PCDaemonUserConfig* config;
};

struct _PCDaemonRestrictionClass {
	GObjectClass parent_class;
	void (*start) (PCDaemonRestriction* self);
	void (*stop) (PCDaemonRestriction* self);
};

struct _PCDaemonWebRestriction {
	PCDaemonRestriction parent_instance;
	PCDaemonWebRestrictionPrivate * priv;
};

struct _PCDaemonWebRestrictionClass {
	PCDaemonRestrictionClass parent_class;
};

static gpointer pc_daemon_web_restriction_parent_class = NULL;

VALA_EXTERN GType pc_daemon_restriction_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonRestriction, g_object_unref)
VALA_EXTERN GType pc_daemon_user_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonUserConfig, g_object_unref)
VALA_EXTERN GType pc_daemon_web_restriction_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonWebRestriction, g_object_unref)
VALA_EXTERN void pc_daemon_restriction_start (PCDaemonRestriction* self);
VALA_EXTERN void pc_daemon_restriction_stop (PCDaemonRestriction* self);
VALA_EXTERN gboolean pc_daemon_web_restriction_get_supported (void);
VALA_EXTERN PCDaemonWebRestriction* pc_daemon_web_restriction_new (PCDaemonUserConfig* config);
VALA_EXTERN PCDaemonWebRestriction* pc_daemon_web_restriction_construct (GType object_type,
                                                             PCDaemonUserConfig* config);
VALA_EXTERN PCDaemonRestriction* pc_daemon_restriction_construct (GType object_type,
                                                      PCDaemonUserConfig* config);
static void pc_daemon_web_restriction_real_start (PCDaemonRestriction* base);
VALA_EXTERN gchar** pc_daemon_user_config_get_block_urls (PCDaemonUserConfig* self,
                                              gint* result_length1);
static gboolean pc_daemon_web_restriction_check_address_from_name (PCDaemonWebRestriction* self,
                                                            const gchar* name);
static void pc_daemon_web_restriction_process_address (PCDaemonWebRestriction* self,
                                                const gchar* url,
                                                const gchar* option,
                                                const gchar* filter);
static void pc_daemon_web_restriction_real_stop (PCDaemonRestriction* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GType pc_daemon_web_restriction_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gboolean
pc_daemon_web_restriction_get_supported (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = g_find_program_in_path (PC_DAEMON_WEB_RESTRICTION_IPTABLES_EXEC);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

PCDaemonWebRestriction*
pc_daemon_web_restriction_construct (GType object_type,
                                     PCDaemonUserConfig* config)
{
	PCDaemonWebRestriction * self = NULL;
	g_return_val_if_fail (config != NULL, NULL);
	self = (PCDaemonWebRestriction*) pc_daemon_restriction_construct (object_type, config);
	return self;
}

PCDaemonWebRestriction*
pc_daemon_web_restriction_new (PCDaemonUserConfig* config)
{
	return pc_daemon_web_restriction_construct (PC_DAEMON_TYPE_WEB_RESTRICTION, config);
}

static void
pc_daemon_web_restriction_real_start (PCDaemonRestriction* base)
{
	PCDaemonWebRestriction * self;
	PCDaemonUserConfig* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (PCDaemonWebRestriction*) base;
	_tmp0_ = ((PCDaemonRestriction*) self)->config;
	_tmp1_ = pc_daemon_user_config_get_block_urls (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** url_collection = NULL;
		gint url_collection_length1 = 0;
		gint _url_collection_size_ = 0;
		gint url_it = 0;
		url_collection = _tmp3_;
		url_collection_length1 = _tmp3__length1;
		for (url_it = 0; url_it < url_collection_length1; url_it = url_it + 1) {
			gchar* _tmp4_;
			gchar* url = NULL;
			_tmp4_ = g_strdup (url_collection[url_it]);
			url = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = url;
				if (pc_daemon_web_restriction_check_address_from_name (self, _tmp5_)) {
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp6_ = url;
					pc_daemon_web_restriction_process_address (self, _tmp6_, "-A", "INPUT");
					_tmp7_ = url;
					pc_daemon_web_restriction_process_address (self, _tmp7_, "-A", "OUTPUT");
				}
				_g_free0 (url);
			}
		}
		url_collection = (_vala_array_free (url_collection, url_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
pc_daemon_web_restriction_real_stop (PCDaemonRestriction* base)
{
	PCDaemonWebRestriction * self;
	PCDaemonUserConfig* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (PCDaemonWebRestriction*) base;
	_tmp0_ = ((PCDaemonRestriction*) self)->config;
	_tmp1_ = pc_daemon_user_config_get_block_urls (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** url_collection = NULL;
		gint url_collection_length1 = 0;
		gint _url_collection_size_ = 0;
		gint url_it = 0;
		url_collection = _tmp3_;
		url_collection_length1 = _tmp3__length1;
		for (url_it = 0; url_it < url_collection_length1; url_it = url_it + 1) {
			gchar* _tmp4_;
			gchar* url = NULL;
			_tmp4_ = g_strdup (url_collection[url_it]);
			url = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = url;
				if (pc_daemon_web_restriction_check_address_from_name (self, _tmp5_)) {
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp6_ = url;
					pc_daemon_web_restriction_process_address (self, _tmp6_, "-D", "INPUT");
					_tmp7_ = url;
					pc_daemon_web_restriction_process_address (self, _tmp7_, "-D", "OUTPUT");
				}
				_g_free0 (url);
			}
		}
		url_collection = (_vala_array_free (url_collection, url_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
pc_daemon_web_restriction_check_address_from_name (PCDaemonWebRestriction* self,
                                                   const gchar* name)
{
	GResolver* resolver = NULL;
	GResolver* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_resolver_get_default ();
	resolver = _tmp0_;
	{
		GList* addresses = NULL;
		GResolver* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp1_ = resolver;
		_tmp2_ = g_resolver_lookup_by_name (_tmp1_, name, NULL, &_inner_error0_);
		addresses = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = addresses;
		{
			GList* address_collection = NULL;
			GList* address_it = NULL;
			address_collection = _tmp3_;
			for (address_it = address_collection; address_it != NULL; address_it = address_it->next) {
				GInetAddress* _tmp4_;
				GInetAddress* address = NULL;
				_tmp4_ = _g_object_ref0 ((GInetAddress*) address_it->data);
				address = _tmp4_;
				{
					GInetAddress* _tmp5_;
					_tmp5_ = address;
					if (g_inet_address_get_family (_tmp5_) == G_SOCKET_FAMILY_IPV4) {
						result = TRUE;
						_g_object_unref0 (address);
						(addresses == NULL) ? NULL : (addresses = (_g_list_free__g_object_unref0_ (addresses), NULL));
						_g_object_unref0 (resolver);
						return result;
					}
					_g_object_unref0 (address);
				}
			}
		}
		(addresses == NULL) ? NULL : (addresses = (_g_list_free__g_object_unref0_ (addresses), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("WebRestriction.vala:65: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_object_unref0 (resolver);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	result = FALSE;
	_g_object_unref0 (resolver);
	return result;
}

static void
pc_daemon_web_restriction_process_address (PCDaemonWebRestriction* self,
                                           const gchar* url,
                                           const gchar* option,
                                           const gchar* filter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (filter != NULL);
	{
		gchar** argv = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp0_ = g_strdup (PC_DAEMON_WEB_RESTRICTION_IPTABLES_EXEC);
		_tmp1_ = g_strdup (option);
		_tmp2_ = g_strdup (filter);
		_tmp3_ = g_strdup ("-m");
		_tmp4_ = g_strdup ("string");
		_tmp5_ = g_strdup ("--string");
		_tmp6_ = g_strdup (url);
		_tmp7_ = g_strdup ("--algo");
		_tmp8_ = g_strdup ("kmp");
		_tmp9_ = g_strdup ("--to");
		_tmp10_ = g_strdup_printf ("%i", PC_DAEMON_WEB_RESTRICTION_BYTES);
		_tmp11_ = g_strdup ("-j");
		_tmp12_ = g_strdup ("DROP");
		_tmp13_ = g_new0 (gchar*, 13 + 1);
		_tmp13_[0] = _tmp0_;
		_tmp13_[1] = _tmp1_;
		_tmp13_[2] = _tmp2_;
		_tmp13_[3] = _tmp3_;
		_tmp13_[4] = _tmp4_;
		_tmp13_[5] = _tmp5_;
		_tmp13_[6] = _tmp6_;
		_tmp13_[7] = _tmp7_;
		_tmp13_[8] = _tmp8_;
		_tmp13_[9] = _tmp9_;
		_tmp13_[10] = _tmp10_;
		_tmp13_[11] = _tmp11_;
		_tmp13_[12] = _tmp12_;
		argv = _tmp13_;
		argv_length1 = 13;
		_argv_size_ = argv_length1;
		_tmp15_ = _tmp14_ = g_get_environ ();
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _vala_array_length (_tmp14_);
		g_spawn_sync ("/", argv, _tmp16_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("WebRestriction.vala:84: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pc_daemon_web_restriction_class_init (PCDaemonWebRestrictionClass * klass,
                                      gpointer klass_data)
{
	pc_daemon_web_restriction_parent_class = g_type_class_peek_parent (klass);
	((PCDaemonRestrictionClass *) klass)->start = (void (*) (PCDaemonRestriction*)) pc_daemon_web_restriction_real_start;
	((PCDaemonRestrictionClass *) klass)->stop = (void (*) (PCDaemonRestriction*)) pc_daemon_web_restriction_real_stop;
}

static void
pc_daemon_web_restriction_instance_init (PCDaemonWebRestriction * self,
                                         gpointer klass)
{
}

static GType
pc_daemon_web_restriction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonWebRestrictionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_web_restriction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCDaemonWebRestriction), 0, (GInstanceInitFunc) pc_daemon_web_restriction_instance_init, NULL };
	GType pc_daemon_web_restriction_type_id;
	pc_daemon_web_restriction_type_id = g_type_register_static (PC_DAEMON_TYPE_RESTRICTION, "PCDaemonWebRestriction", &g_define_type_info, 0);
	return pc_daemon_web_restriction_type_id;
}

GType
pc_daemon_web_restriction_get_type (void)
{
	static volatile gsize pc_daemon_web_restriction_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_web_restriction_type_id__once)) {
		GType pc_daemon_web_restriction_type_id;
		pc_daemon_web_restriction_type_id = pc_daemon_web_restriction_get_type_once ();
		g_once_init_leave (&pc_daemon_web_restriction_type_id__once, pc_daemon_web_restriction_type_id);
	}
	return pc_daemon_web_restriction_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

