/* JobsView.c generated by valac 0.56.17, the Vala compiler
 * generated from JobsView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include "cups/cups.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_JOBS_VIEW_0_PROPERTY,
	PRINTERS_JOBS_VIEW_PRINTER_PROPERTY,
	PRINTERS_JOBS_VIEW_NUM_PROPERTIES
};
static GParamSpec* printers_jobs_view_properties[PRINTERS_JOBS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PrintersJobsViewPrivate {
	PrintersPrinter* _printer;
	GtkListBox* list_box;
	GtkButton* clear_button;
};

struct _Block8Data {
	int _ref_count_;
	PrintersJobsView* self;
	PrintersClearQueueDialog* dialog;
};

static gint PrintersJobsView_private_offset;
static gpointer printers_jobs_view_parent_class = NULL;

static gint printers_jobs_view_compare (PrintersJobRow* a,
                                 PrintersJobRow* b);
static void printers_jobs_view_update_header (PrintersJobRow* row1,
                                       PrintersJobRow* row2,
                                       PrintersJobsView* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda8_ (Block8Data* _data8_,
                 gint response_id);
static void printers_jobs_view_refresh_job_list (PrintersJobsView* self);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static GObject * printers_jobs_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _printers_jobs_view___lambda9_ (PrintersJobsView* self,
                                     const gchar* text,
                                     const gchar* printer_uri,
                                     const gchar* name,
                                     guint32 state,
                                     const gchar* state_reasons,
                                     gboolean is_accepting_jobs,
                                     guint32 job_id,
                                     guint32 job_state,
                                     const gchar* job_state_reason,
                                     const gchar* job_name,
                                     guint32 job_impressions_completed);
static void __printers_jobs_view___lambda9__cups_notifier_job_created (CupsNotifier* _sender,
                                                                const gchar* text,
                                                                const gchar* printer_uri,
                                                                const gchar* name,
                                                                guint32 state,
                                                                const gchar* state_reasons,
                                                                gboolean is_accepting_jobs,
                                                                guint32 job_id,
                                                                guint32 job_state,
                                                                const gchar* job_state_reason,
                                                                const gchar* job_name,
                                                                guint32 job_impressions_completed,
                                                                gpointer self);
static void _printers_jobs_view___lambda10_ (PrintersJobsView* self);
static void __printers_jobs_view___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void printers_jobs_view_finalize (GObject * obj);
static GType printers_jobs_view_get_type_once (void);
static void _vala_printers_jobs_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_printers_jobs_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
printers_jobs_view_get_instance_private (PrintersJobsView* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersJobsView_private_offset);
}

PrintersJobsView*
printers_jobs_view_construct (GType object_type,
                              PrintersPrinter* printer)
{
	PrintersJobsView * self = NULL;
	g_return_val_if_fail (printer != NULL, NULL);
	self = (PrintersJobsView*) g_object_new (object_type, "printer", printer, NULL);
	return self;
}

PrintersJobsView*
printers_jobs_view_new (PrintersPrinter* printer)
{
	return printers_jobs_view_construct (PRINTERS_TYPE_JOBS_VIEW, printer);
}

static gint
printers_jobs_view_compare (PrintersJobRow* a,
                            PrintersJobRow* b)
{
	gboolean _tmp0_ = FALSE;
	PrintersJob* _tmp1_;
	PrintersJob* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = printers_job_row_get_job (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = printers_job_get_is_ongoing (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		PrintersJob* _tmp5_;
		PrintersJob* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = printers_job_row_get_job (b);
		_tmp6_ = _tmp5_;
		_tmp7_ = printers_job_get_is_ongoing (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		PrintersJob* _tmp10_;
		PrintersJob* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = printers_job_row_get_job (a);
		_tmp11_ = _tmp10_;
		_tmp12_ = printers_job_get_is_ongoing (_tmp11_);
		_tmp13_ = _tmp12_;
		if (!_tmp13_) {
			PrintersJob* _tmp14_;
			PrintersJob* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp14_ = printers_job_row_get_job (b);
			_tmp15_ = _tmp14_;
			_tmp16_ = printers_job_get_is_ongoing (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp17_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = 1;
			return result;
		} else {
			GDateTime* timea = NULL;
			PrintersJob* _tmp18_;
			PrintersJob* _tmp19_;
			GDateTime* _tmp20_;
			GDateTime* timeb = NULL;
			PrintersJob* _tmp21_;
			PrintersJob* _tmp22_;
			GDateTime* _tmp23_;
			GDateTime* _tmp24_;
			_tmp18_ = printers_job_row_get_job (G_TYPE_CHECK_INSTANCE_CAST (a, PRINTERS_TYPE_JOB_ROW, PrintersJobRow));
			_tmp19_ = _tmp18_;
			_tmp20_ = printers_job_get_display_time (_tmp19_);
			timea = _tmp20_;
			_tmp21_ = printers_job_row_get_job (G_TYPE_CHECK_INSTANCE_CAST (b, PRINTERS_TYPE_JOB_ROW, PrintersJobRow));
			_tmp22_ = _tmp21_;
			_tmp23_ = printers_job_get_display_time (_tmp22_);
			timeb = _tmp23_;
			_tmp24_ = timea;
			if (_tmp24_ == NULL) {
				GDateTime* _tmp25_;
				_tmp25_ = timeb;
				if (_tmp25_ == NULL) {
					result = 0;
					_g_date_time_unref0 (timeb);
					_g_date_time_unref0 (timea);
					return result;
				} else {
					result = 1;
					_g_date_time_unref0 (timeb);
					_g_date_time_unref0 (timea);
					return result;
				}
			} else {
				GDateTime* _tmp26_;
				_tmp26_ = timeb;
				if (_tmp26_ == NULL) {
					result = -1;
					_g_date_time_unref0 (timeb);
					_g_date_time_unref0 (timea);
					return result;
				} else {
					GDateTime* _tmp27_;
					GDateTime* _tmp28_;
					_tmp27_ = timeb;
					_tmp28_ = timea;
					result = g_date_time_compare (_tmp27_, _tmp28_);
					_g_date_time_unref0 (timeb);
					_g_date_time_unref0 (timea);
					return result;
				}
			}
			_g_date_time_unref0 (timeb);
			_g_date_time_unref0 (timea);
		}
	}
}

static void
printers_jobs_view_update_header (PrintersJobRow* row1,
                                  PrintersJobRow* row2,
                                  PrintersJobsView* self)
{
	gboolean _tmp0_ = FALSE;
	PrintersJob* _tmp1_;
	PrintersJob* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row1 != NULL);
	_tmp1_ = printers_job_row_get_job (row1);
	_tmp2_ = _tmp1_;
	_tmp3_ = printers_job_get_is_ongoing (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		if (row2 == NULL) {
			_tmp5_ = TRUE;
		} else {
			PrintersJob* _tmp6_;
			PrintersJob* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp6_ = printers_job_row_get_job (row2);
			_tmp7_ = _tmp6_;
			_tmp8_ = printers_job_get_is_ongoing (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_;
		}
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteHeaderLabel* label = NULL;
		GraniteHeaderLabel* _tmp10_;
		GraniteHeaderLabel* _tmp11_;
		_tmp10_ = granite_header_label_new (_ ("Completed Jobs"));
		g_object_ref_sink (_tmp10_);
		label = _tmp10_;
		_tmp11_ = label;
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp11_);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, NULL);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		PrintersJobsView* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda8_ (Block8Data* _data8_,
            gint response_id)
{
	PrintersJobsView* self;
	self = _data8_->self;
	gtk_window_destroy ((GtkWindow*) _data8_->dialog);
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		while (TRUE) {
			GtkListBox* _tmp0_;
			GtkListBoxRow* _tmp1_;
			PrintersJob* job = NULL;
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			PrintersJob* _tmp4_;
			PrintersJob* _tmp5_;
			PrintersJob* _tmp6_;
			PrintersJob* _tmp7_;
			PrintersJob* _tmp8_;
			GtkListBox* _tmp9_;
			GtkListBox* _tmp10_;
			GtkListBoxRow* _tmp11_;
			_tmp0_ = self->priv->list_box;
			_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
			if (!(_tmp1_ != NULL)) {
				break;
			}
			_tmp2_ = self->priv->list_box;
			_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, 0);
			_tmp4_ = printers_job_row_get_job (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PRINTERS_TYPE_JOB_ROW, PrintersJobRow));
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			job = _tmp6_;
			_tmp7_ = job;
			printers_job_pause (_tmp7_);
			_tmp8_ = job;
			printers_job_purge (_tmp8_);
			_tmp9_ = self->priv->list_box;
			_tmp10_ = self->priv->list_box;
			_tmp11_ = gtk_list_box_get_row_at_index (_tmp10_, 0);
			gtk_list_box_remove (_tmp9_, (GtkWidget*) _tmp11_);
			_g_object_unref0 (job);
		}
		printers_jobs_view_refresh_job_list (self);
	}
}

static void
___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda8_ (self, response_id);
}

void
printers_jobs_view_clear_queue (PrintersJobsView* self)
{
	Block8Data* _data8_;
	PrintersPrinter* _tmp0_;
	GtkRoot* _tmp1_;
	GtkWindow* _tmp2_;
	PrintersClearQueueDialog* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = self->priv->_printer;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = printers_clear_queue_dialog_new (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_data8_->dialog = _tmp3_;
	g_signal_connect_data ((GtkDialog*) _data8_->dialog, "response", (GCallback) ___lambda8__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data8_->dialog);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
printers_jobs_view_refresh_job_list (PrintersJobsView* self)
{
	GeeTreeSet* jobs = NULL;
	PrintersPrinter* _tmp5_;
	GeeTreeSet* _tmp6_;
	GtkButton* _tmp17_;
	GtkListBox* _tmp18_;
	GtkWidget* _tmp19_;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GtkListBox* _tmp0_;
		GtkListBoxRow* _tmp1_;
		GtkListBox* _tmp2_;
		GtkListBox* _tmp3_;
		GtkListBoxRow* _tmp4_;
		_tmp0_ = self->priv->list_box;
		_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = self->priv->list_box;
		_tmp3_ = self->priv->list_box;
		_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, 0);
		gtk_list_box_remove (_tmp2_, (GtkWidget*) _tmp4_);
	}
	_tmp5_ = self->priv->_printer;
	_tmp6_ = printers_printer_get_jobs (_tmp5_, TRUE, CUPS_WHICHJOBS_ALL);
	jobs = _tmp6_;
	{
		GeeIterator* _job_it = NULL;
		GeeTreeSet* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp7_ = jobs;
		_tmp8_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp7_);
		_job_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			PrintersJob* job = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GtkListBox* _tmp12_;
			PrintersPrinter* _tmp13_;
			PrintersJob* _tmp14_;
			PrintersJobRow* _tmp15_;
			PrintersJobRow* _tmp16_;
			_tmp9_ = _job_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _job_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			job = (PrintersJob*) _tmp11_;
			_tmp12_ = self->priv->list_box;
			_tmp13_ = self->priv->_printer;
			_tmp14_ = job;
			_tmp15_ = printers_job_row_new (_tmp13_, _tmp14_);
			g_object_ref_sink (_tmp15_);
			_tmp16_ = _tmp15_;
			gtk_list_box_append (_tmp12_, (GtkWidget*) _tmp16_);
			_g_object_unref0 (_tmp16_);
			_g_object_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	_tmp17_ = self->priv->clear_button;
	_tmp18_ = self->priv->list_box;
	_tmp19_ = gtk_widget_get_first_child ((GtkWidget*) _tmp18_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, PRINTERS_IS_JOB_ROW (_tmp19_));
	_g_object_unref0 (jobs);
}

PrintersPrinter*
printers_jobs_view_get_printer (PrintersJobsView* self)
{
	PrintersPrinter* result;
	PrintersPrinter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_printer;
	result = _tmp0_;
	return result;
}

static void
printers_jobs_view_set_printer (PrintersJobsView* self,
                                PrintersPrinter* value)
{
	PrintersPrinter* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_jobs_view_get_printer (self);
	if (old_value != value) {
		PrintersPrinter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_printer);
		self->priv->_printer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_jobs_view_properties[PRINTERS_JOBS_VIEW_PRINTER_PROPERTY]);
	}
}

static void
_printers_jobs_view___lambda9_ (PrintersJobsView* self,
                                const gchar* text,
                                const gchar* printer_uri,
                                const gchar* name,
                                guint32 state,
                                const gchar* state_reasons,
                                gboolean is_accepting_jobs,
                                guint32 job_id,
                                guint32 job_state,
                                const gchar* job_state_reason,
                                const gchar* job_name,
                                guint32 job_impressions_completed)
{
	PrintersPrinter* _tmp0_;
	cups_dest_t _tmp1_;
	const gchar* _tmp2_;
	GeeTreeSet* jobs_ = NULL;
	PrintersPrinter* _tmp3_;
	GeeTreeSet* _tmp4_;
	GtkButton* _tmp18_;
	GtkListBox* _tmp19_;
	GtkWidget* _tmp20_;
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	g_return_if_fail (job_state_reason != NULL);
	g_return_if_fail (job_name != NULL);
	_tmp0_ = self->priv->_printer;
	_tmp1_ = _tmp0_->dest;
	_tmp2_ = _tmp1_.name;
	if (g_strcmp0 (_tmp2_, name) != 0) {
		return;
	}
	_tmp3_ = self->priv->_printer;
	_tmp4_ = printers_printer_get_jobs (_tmp3_, TRUE, CUPS_WHICHJOBS_ALL);
	jobs_ = _tmp4_;
	{
		GeeIterator* _job_it = NULL;
		GeeTreeSet* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp5_ = jobs_;
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp5_);
		_job_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			PrintersJob* job = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			PrintersJob* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp7_ = _job_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _job_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			job = (PrintersJob*) _tmp9_;
			_tmp10_ = job;
			_tmp11_ = printers_job_get_uid (_tmp10_);
			_tmp12_ = _tmp11_;
			if (((guint32) _tmp12_) == job_id) {
				GtkListBox* _tmp13_;
				PrintersPrinter* _tmp14_;
				PrintersJob* _tmp15_;
				PrintersJobRow* _tmp16_;
				PrintersJobRow* _tmp17_;
				_tmp13_ = self->priv->list_box;
				_tmp14_ = self->priv->_printer;
				_tmp15_ = job;
				_tmp16_ = printers_job_row_new (_tmp14_, _tmp15_);
				g_object_ref_sink (_tmp16_);
				_tmp17_ = _tmp16_;
				gtk_list_box_append (_tmp13_, (GtkWidget*) _tmp17_);
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (job);
				break;
			}
			_g_object_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	_tmp18_ = self->priv->clear_button;
	_tmp19_ = self->priv->list_box;
	_tmp20_ = gtk_widget_get_first_child ((GtkWidget*) _tmp19_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, PRINTERS_IS_JOB_ROW (_tmp20_));
	_g_object_unref0 (jobs_);
}

static void
__printers_jobs_view___lambda9__cups_notifier_job_created (CupsNotifier* _sender,
                                                           const gchar* text,
                                                           const gchar* printer_uri,
                                                           const gchar* name,
                                                           guint32 state,
                                                           const gchar* state_reasons,
                                                           gboolean is_accepting_jobs,
                                                           guint32 job_id,
                                                           guint32 job_state,
                                                           const gchar* job_state_reason,
                                                           const gchar* job_name,
                                                           guint32 job_impressions_completed,
                                                           gpointer self)
{
	_printers_jobs_view___lambda9_ ((PrintersJobsView*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs, job_id, job_state, job_state_reason, job_name, job_impressions_completed);
}

static void
_printers_jobs_view___lambda10_ (PrintersJobsView* self)
{
	printers_jobs_view_clear_queue (self);
}

static void
__printers_jobs_view___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_printers_jobs_view___lambda10_ ((PrintersJobsView*) self);
}

static GObject *
printers_jobs_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersJobsView * self;
	GranitePlaceholder* alert = NULL;
	gchar* _tmp0_;
	GranitePlaceholder* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GranitePlaceholder* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp8_;
	GtkWidget* _tmp9_;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkLabel* clear_button_label = NULL;
	GtkLabel* _tmp11_;
	GtkBox* clear_button_box = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkWidget* _tmp19_;
	GtkButton* _tmp20_ = NULL;
	GtkLabel* _tmp21_;
	GtkButton* _tmp22_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp23_;
	GtkActionBar* _tmp24_;
	GtkActionBar* _tmp25_;
	GtkButton* _tmp26_;
	GtkBox* box = NULL;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkBox* _tmp30_;
	GtkActionBar* _tmp31_;
	GtkBox* _tmp32_;
	CupsNotifier* notifier = NULL;
	CupsNotifier* _tmp33_;
	CupsNotifier* _tmp34_;
	GtkButton* _tmp35_;
	parent_class = G_OBJECT_CLASS (printers_jobs_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_JOBS_VIEW, PrintersJobsView);
	_tmp0_ = g_strdup (_ ("There are no pending jobs in the queue."));
	_tmp1_ = granite_placeholder_new (_ ("Print Queue Is Empty"));
	granite_placeholder_set_description (_tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	alert = _tmp1_;
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp2_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp2_;
	_tmp3_ = self->priv->list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp4_ = self->priv->list_box;
	_tmp5_ = alert;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->list_box;
	gtk_list_box_set_header_func (_tmp6_, (GtkListBoxUpdateHeaderFunc) printers_jobs_view_update_header, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->list_box;
	gtk_list_box_set_sort_func (_tmp7_, (GtkListBoxSortFunc) printers_jobs_view_compare, NULL, NULL);
	_tmp8_ = self->priv->list_box;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp10_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	scrolled = _tmp10_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Clear All"));
	g_object_ref_sink (_tmp11_);
	clear_button_label = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp12_);
	clear_button_box = _tmp12_;
	_tmp13_ = clear_button_box;
	_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-clear-all-symbolic");
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = clear_button_box;
	_tmp17_ = clear_button_label;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = clear_button_box;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	_tmp20_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp20_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	gtk_button_set_has_frame (_tmp20_, FALSE);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->clear_button = _tmp20_;
	_tmp21_ = clear_button_label;
	_tmp22_ = self->priv->clear_button;
	gtk_label_set_mnemonic_widget (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp23_);
	actionbar = _tmp23_;
	_tmp24_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp24_, GRANITE_STYLE_CLASS_FLAT);
	_tmp25_ = actionbar;
	_tmp26_ = self->priv->clear_button;
	gtk_action_bar_pack_start (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp27_);
	box = _tmp27_;
	_tmp28_ = box;
	_tmp29_ = scrolled;
	gtk_box_append (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = box;
	_tmp31_ = actionbar;
	gtk_box_append (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = box;
	gtk_frame_set_child ((GtkFrame*) self, (GtkWidget*) _tmp32_);
	printers_jobs_view_refresh_job_list (self);
	_tmp33_ = cups_notifier_get_default ();
	notifier = _tmp33_;
	_tmp34_ = notifier;
	g_signal_connect_object (_tmp34_, "job-created", (GCallback) __printers_jobs_view___lambda9__cups_notifier_job_created, self, 0);
	_tmp35_ = self->priv->clear_button;
	g_signal_connect_object (_tmp35_, "clicked", (GCallback) __printers_jobs_view___lambda10__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (clear_button_box);
	_g_object_unref0 (clear_button_label);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (alert);
	return obj;
}

static void
printers_jobs_view_class_init (PrintersJobsViewClass * klass,
                               gpointer klass_data)
{
	printers_jobs_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersJobsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_jobs_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_jobs_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_jobs_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_jobs_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_JOBS_VIEW_PRINTER_PROPERTY, printers_jobs_view_properties[PRINTERS_JOBS_VIEW_PRINTER_PROPERTY] = g_param_spec_object ("printer", "printer", "printer", PRINTERS_TYPE_PRINTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
printers_jobs_view_instance_init (PrintersJobsView * self,
                                  gpointer klass)
{
	self->priv = printers_jobs_view_get_instance_private (self);
}

static void
printers_jobs_view_finalize (GObject * obj)
{
	PrintersJobsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_JOBS_VIEW, PrintersJobsView);
	_g_object_unref0 (self->priv->_printer);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->clear_button);
	G_OBJECT_CLASS (printers_jobs_view_parent_class)->finalize (obj);
}

static GType
printers_jobs_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersJobsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_jobs_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersJobsView), 0, (GInstanceInitFunc) printers_jobs_view_instance_init, NULL };
	GType printers_jobs_view_type_id;
	printers_jobs_view_type_id = g_type_register_static (gtk_frame_get_type (), "PrintersJobsView", &g_define_type_info, 0);
	PrintersJobsView_private_offset = g_type_add_instance_private (printers_jobs_view_type_id, sizeof (PrintersJobsViewPrivate));
	return printers_jobs_view_type_id;
}

GType
printers_jobs_view_get_type (void)
{
	static volatile gsize printers_jobs_view_type_id__once = 0;
	if (g_once_init_enter (&printers_jobs_view_type_id__once)) {
		GType printers_jobs_view_type_id;
		printers_jobs_view_type_id = printers_jobs_view_get_type_once ();
		g_once_init_leave (&printers_jobs_view_type_id__once, printers_jobs_view_type_id);
	}
	return printers_jobs_view_type_id__once;
}

static void
_vala_printers_jobs_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PrintersJobsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOBS_VIEW, PrintersJobsView);
	switch (property_id) {
		case PRINTERS_JOBS_VIEW_PRINTER_PROPERTY:
		g_value_set_object (value, printers_jobs_view_get_printer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_jobs_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PrintersJobsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_JOBS_VIEW, PrintersJobsView);
	switch (property_id) {
		case PRINTERS_JOBS_VIEW_PRINTER_PROPERTY:
		printers_jobs_view_set_printer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

