/* TrackPanel.c generated by valac 0.56.17, the Vala compiler
 * generated from TrackPanel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2014-2018 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "security-privacy.h"
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <gtk/gtk.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECURITY_PRIVACY_TRACK_PANEL_0_PROPERTY,
	SECURITY_PRIVACY_TRACK_PANEL_NUM_PROPERTIES
};
static GParamSpec* security_privacy_track_panel_properties[SECURITY_PRIVACY_TRACK_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _security_privacy_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (security_privacy_blacklist_unref (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _Block5Data {
	int _ref_count_;
	SecurityPrivacyTrackPanel* self;
	GranitePlaceholder* alert;
	IncludeTreeView* include_treeview;
	ExcludeTreeView* exclude_treeview;
	GtkBox* content_box;
	GtkStack* stack;
};

static gpointer security_privacy_track_panel_parent_class = NULL;
static SecurityPrivacyBlacklist* security_privacy_track_panel__blacklist;
static SecurityPrivacyBlacklist* security_privacy_track_panel__blacklist = NULL;

static gchar* security_privacy_track_panel_get_operating_system_name (void);
static void security_privacy_track_panel_update_status_switch (SecurityPrivacyTrackPanel* self);
static void security_privacy_track_panel_set_blacklist (SecurityPrivacyBlacklist* value);
static GObject * security_privacy_track_panel_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _security_privacy_track_panel___lambda13_ (Block5Data* _data5_);
static void __security_privacy_track_panel___lambda13__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _security_privacy_track_panel___lambda14_ (SecurityPrivacyTrackPanel* self);
static void __security_privacy_track_panel___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void security_privacy_track_panel_finalize (GObject * obj);
static GType security_privacy_track_panel_get_type_once (void);
static void _vala_security_privacy_track_panel_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_security_privacy_track_panel_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

SecurityPrivacyTrackPanel*
security_privacy_track_panel_construct (GType object_type)
{
	SecurityPrivacyTrackPanel * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GThemedIcon* _tmp4_;
	GThemedIcon* _tmp5_;
	_tmp0_ = security_privacy_track_panel_get_operating_system_name ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("%s can store local usage data to provide extra functionality like offe" \
"ring recently-used files and more relevant local search. Regardless of" \
" this setting, usage data is never transmitted off of this device or t" \
"o third parties."), _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("document-open-recent");
	_tmp5_ = _tmp4_;
	self = (SecurityPrivacyTrackPanel*) g_object_new (object_type, "activatable", TRUE, "description", _tmp3_, "icon", _tmp5_, "title", _ ("History"), NULL);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

SecurityPrivacyTrackPanel*
security_privacy_track_panel_new (void)
{
	return security_privacy_track_panel_construct (SECURITY_PRIVACY_TYPE_TRACK_PANEL);
}

static gchar*
security_privacy_track_panel_get_operating_system_name (void)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	_tmp1_ = g_get_os_info (G_OS_INFO_KEY_NAME);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("Your system"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static void
security_privacy_track_panel_update_status_switch (SecurityPrivacyTrackPanel* self)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Enabled"));
	} else {
		g_warning ("TrackPanel.vala:112: Trying to set offline");
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Disabled"));
	}
}

SecurityPrivacyBlacklist*
security_privacy_track_panel_get_blacklist (void)
{
	SecurityPrivacyBlacklist* result;
	SecurityPrivacyBlacklist* _tmp0_;
	_tmp0_ = security_privacy_track_panel__blacklist;
	result = _tmp0_;
	return result;
}

static gpointer
_security_privacy_blacklist_ref0 (gpointer self)
{
	return self ? security_privacy_blacklist_ref (self) : NULL;
}

static void
security_privacy_track_panel_set_blacklist (SecurityPrivacyBlacklist* value)
{
	SecurityPrivacyBlacklist* _tmp0_;
	_tmp0_ = _security_privacy_blacklist_ref0 (value);
	_security_privacy_blacklist_unref0 (security_privacy_track_panel__blacklist);
	security_privacy_track_panel__blacklist = _tmp0_;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SecurityPrivacyTrackPanel* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->stack);
		_g_object_unref0 (_data5_->content_box);
		_g_object_unref0 (_data5_->exclude_treeview);
		_g_object_unref0 (_data5_->include_treeview);
		_g_object_unref0 (_data5_->alert);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_security_privacy_track_panel___lambda13_ (Block5Data* _data5_)
{
	SecurityPrivacyTrackPanel* self;
	gboolean privacy_mode = FALSE;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	IncludeTreeView* _tmp4_;
	ExcludeTreeView* _tmp5_;
	SecurityPrivacyBlacklist* _tmp10_;
	SecurityPrivacyBlacklist* _tmp11_;
	self = _data5_->self;
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	privacy_mode = !_tmp3_;
	_tmp4_ = _data5_->include_treeview;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, !privacy_mode);
	_tmp5_ = _data5_->exclude_treeview;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, !privacy_mode);
	if (privacy_mode) {
		GtkStack* _tmp6_;
		GranitePlaceholder* _tmp7_;
		_tmp6_ = _data5_->stack;
		_tmp7_ = _data5_->alert;
		gtk_stack_set_visible_child (_tmp6_, (GtkWidget*) _tmp7_);
	} else {
		GtkStack* _tmp8_;
		GtkBox* _tmp9_;
		_tmp8_ = _data5_->stack;
		_tmp9_ = _data5_->content_box;
		gtk_stack_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
	}
	_tmp10_ = security_privacy_track_panel_get_blacklist ();
	_tmp11_ = _tmp10_;
	if (privacy_mode != security_privacy_blacklist_get_incognito (_tmp11_)) {
		SecurityPrivacyBlacklist* _tmp12_;
		SecurityPrivacyBlacklist* _tmp13_;
		GSettings* privacy_settings = NULL;
		GSettings* _tmp14_;
		GSettings* _tmp15_;
		GSettings* _tmp16_;
		_tmp12_ = security_privacy_track_panel_get_blacklist ();
		_tmp13_ = _tmp12_;
		security_privacy_blacklist_set_incognito (_tmp13_, privacy_mode);
		_tmp14_ = g_settings_new ("org.gnome.desktop.privacy");
		privacy_settings = _tmp14_;
		_tmp15_ = privacy_settings;
		g_settings_set_boolean (_tmp15_, "remember-recent-files", !privacy_mode);
		_tmp16_ = privacy_settings;
		g_settings_set_boolean (_tmp16_, "remember-app-usage", !privacy_mode);
		_g_object_unref0 (privacy_settings);
	}
	security_privacy_track_panel_update_status_switch (self);
}

static void
__security_privacy_track_panel___lambda13__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_security_privacy_track_panel___lambda13_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_security_privacy_track_panel___lambda14_ (SecurityPrivacyTrackPanel* self)
{
	SecurityPrivacyWidgetsClearUsageDialog* clear_dialog = NULL;
	GtkRoot* _tmp0_;
	GtkWindow* _tmp1_;
	SecurityPrivacyWidgetsClearUsageDialog* _tmp2_ = NULL;
	SecurityPrivacyWidgetsClearUsageDialog* _tmp3_;
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = security_privacy_widgets_clear_usage_dialog_new ();
	gtk_window_set_modal ((GtkWindow*) _tmp2_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp2_, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	clear_dialog = _tmp2_;
	_tmp3_ = clear_dialog;
	gtk_window_present ((GtkWindow*) _tmp3_);
	_g_object_unref0 (clear_dialog);
}

static void
__security_privacy_track_panel___lambda14__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	_security_privacy_track_panel___lambda14_ ((SecurityPrivacyTrackPanel*) self);
}

static GObject *
security_privacy_track_panel_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SecurityPrivacyTrackPanel * self;
	Block5Data* _data5_;
	gchar* description = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GranitePlaceholder* _tmp8_ = NULL;
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	IncludeTreeView* _tmp11_;
	ExcludeTreeView* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	IncludeTreeView* _tmp15_;
	GtkBox* _tmp16_;
	ExcludeTreeView* _tmp17_;
	GtkStack* _tmp18_;
	GtkStack* _tmp19_;
	GtkBox* _tmp20_;
	GtkStack* _tmp21_;
	GranitePlaceholder* _tmp22_;
	GtkStack* _tmp23_;
	GtkButton* clear_button = NULL;
	GtkButton* _tmp24_;
	GtkSwitch* _tmp25_;
	GtkSwitch* _tmp26_;
	GtkSwitch* _tmp27_;
	GtkSwitch* _tmp28_;
	SecurityPrivacyBlacklist* _tmp29_;
	SecurityPrivacyBlacklist* _tmp30_;
	GtkButton* _tmp31_;
	parent_class = G_OBJECT_CLASS (security_privacy_track_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_TRACK_PANEL, SecurityPrivacyTrackPanel);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = security_privacy_track_panel_get_operating_system_name ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("%s won't retain any further usage data."), _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s %s\n\n%s", _tmp3_, _ ("The additional functionality that this data provides will be affected."), _ ("This may not prevent apps from recording their own usage data, such as" \
" browser history."));
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	description = _tmp5_;
	_tmp6_ = description;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = granite_placeholder_new (_ ("History Is Disabled"));
	granite_placeholder_set_description (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_data5_->alert = _tmp8_;
	_tmp9_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp10_ = _tmp9_;
	gtk_switch_set_active (_tmp10_, TRUE);
	_tmp11_ = include_tree_view_new ();
	g_object_ref_sink (_tmp11_);
	_data5_->include_treeview = _tmp11_;
	_tmp12_ = exclude_tree_view_new ();
	g_object_ref_sink (_tmp12_);
	_data5_->exclude_treeview = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp13_);
	_data5_->content_box = _tmp13_;
	_tmp14_ = _data5_->content_box;
	_tmp15_ = _data5_->include_treeview;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = _data5_->content_box;
	_tmp17_ = _data5_->exclude_treeview;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp18_);
	_data5_->stack = _tmp18_;
	_tmp19_ = _data5_->stack;
	_tmp20_ = _data5_->content_box;
	gtk_stack_add_child (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = _data5_->stack;
	_tmp22_ = _data5_->alert;
	gtk_stack_add_child (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = _data5_->stack;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp23_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp24_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Clear History…"));
	clear_button = _tmp24_;
	_tmp25_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp26_ = _tmp25_;
	g_signal_connect_data ((GObject*) _tmp26_, "notify::active", (GCallback) __security_privacy_track_panel___lambda13__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp27_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = security_privacy_track_panel_get_blacklist ();
	_tmp30_ = _tmp29_;
	gtk_switch_set_active (_tmp28_, !security_privacy_blacklist_get_incognito (_tmp30_));
	security_privacy_track_panel_update_status_switch (self);
	_tmp31_ = clear_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) __security_privacy_track_panel___lambda14__gtk_button_clicked, self, 0);
	_g_object_unref0 (clear_button);
	_g_free0 (description);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
security_privacy_track_panel_class_init (SecurityPrivacyTrackPanelClass * klass,
                                         gpointer klass_data)
{
	SecurityPrivacyBlacklist* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	security_privacy_track_panel_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_security_privacy_track_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_security_privacy_track_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = security_privacy_track_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_track_panel_finalize;
	_tmp0_ = security_privacy_blacklist_new ();
	_tmp1_ = _tmp0_;
	security_privacy_track_panel_set_blacklist (_tmp1_);
	_security_privacy_blacklist_unref0 (_tmp1_);
}

static void
security_privacy_track_panel_instance_init (SecurityPrivacyTrackPanel * self,
                                            gpointer klass)
{
}

static void
security_privacy_track_panel_finalize (GObject * obj)
{
	SecurityPrivacyTrackPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_TRACK_PANEL, SecurityPrivacyTrackPanel);
	G_OBJECT_CLASS (security_privacy_track_panel_parent_class)->finalize (obj);
}

static GType
security_privacy_track_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyTrackPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_track_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyTrackPanel), 0, (GInstanceInitFunc) security_privacy_track_panel_instance_init, NULL };
	GType security_privacy_track_panel_type_id;
	security_privacy_track_panel_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "SecurityPrivacyTrackPanel", &g_define_type_info, 0);
	return security_privacy_track_panel_type_id;
}

GType
security_privacy_track_panel_get_type (void)
{
	static volatile gsize security_privacy_track_panel_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_track_panel_type_id__once)) {
		GType security_privacy_track_panel_type_id;
		security_privacy_track_panel_type_id = security_privacy_track_panel_get_type_once ();
		g_once_init_leave (&security_privacy_track_panel_type_id__once, security_privacy_track_panel_type_id);
	}
	return security_privacy_track_panel_type_id__once;
}

static void
_vala_security_privacy_track_panel_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SecurityPrivacyTrackPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_TYPE_TRACK_PANEL, SecurityPrivacyTrackPanel);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_security_privacy_track_panel_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SecurityPrivacyTrackPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_TYPE_TRACK_PANEL, SecurityPrivacyTrackPanel);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

