/* TestPopover.c generated by valac 0.56.17, the Vala compiler
 * generated from TestPopover.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016-2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.sound.h"
#include <gtk/gtk.h>
#include <pulse/pulseaudio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <canberra.h>
#include <granite-7.h>
#include <adwaita.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_TEST_POPOVER_0_PROPERTY,
	SOUND_TEST_POPOVER_NUM_PROPERTIES
};
static GParamSpec* sound_test_popover_properties[SOUND_TEST_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SOUND_TEST_POPOVER_POSITION_BUTTON_0_PROPERTY,
	SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY,
	SOUND_TEST_POPOVER_POSITION_BUTTON_NUM_PROPERTIES
};
static GParamSpec* sound_test_popover_position_button_properties[SOUND_TEST_POPOVER_POSITION_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))

struct _SoundTestPopoverPrivate {
	GtkGrid* main_grid;
	SoundDevice* default_device;
};

struct _SoundTestPopoverPositionButtonPrivate {
	pa_channel_position_t _pa_position;
	gboolean playing;
	GtkImage* image;
};

static gint SoundTestPopover_private_offset;
static gpointer sound_test_popover_parent_class = NULL;
static gint SoundTestPopoverPositionButton_private_offset;
static gpointer sound_test_popover_position_button_parent_class = NULL;

static void sound_test_popover_create_position_button (SoundTestPopover* self,
                                                pa_channel_position_t pa_position);
static void sound_test_popover_default_changed (SoundTestPopover* self);
static void sound_test_popover_update_buttons (SoundTestPopover* self);
static void _sound_test_popover_update_buttons_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void sound_test_popover_clear_buttons (SoundTestPopover* self);
static void sound_test_popover_add_buttons (SoundTestPopover* self);
static gchar* sound_test_popover_position_button_get_icon (SoundTestPopoverPositionButton* self);
static gchar* sound_test_popover_position_button_get_sound_name (SoundTestPopoverPositionButton* self);
static gchar* sound_test_popover_position_button_get_pretty_position (SoundTestPopoverPositionButton* self);
static void sound_test_popover_position_button_real_clicked (GtkButton* base);
static void sound_test_popover_position_button_play_full_callback (SoundTestPopoverPositionButton* self,
                                                            ca_context* c,
                                                            guint32 id,
                                                            gint code);
static void _sound_test_popover_position_button_play_full_callback_ca_finishcallback (ca_context* c,
                                                                               guint32 id,
                                                                               gint code,
                                                                               gpointer self);
static GObject * sound_test_popover_position_button_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void sound_test_popover_position_button_finalize (GObject * obj);
static GType sound_test_popover_position_button_get_type_once (void);
static void _vala_sound_test_popover_position_button_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_sound_test_popover_position_button_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static GObject * sound_test_popover_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _sound_test_popover___lambda23_ (SoundTestPopover* self);
static void __sound_test_popover___lambda23__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void sound_test_popover_finalize (GObject * obj);
static GType sound_test_popover_get_type_once (void);

static inline gpointer
sound_test_popover_get_instance_private (SoundTestPopover* self)
{
	return G_STRUCT_MEMBER_P (self, SoundTestPopover_private_offset);
}

static void
sound_test_popover_create_position_button (SoundTestPopover* self,
                                           pa_channel_position_t pa_position)
{
	SoundTestPopoverPositionButton* button = NULL;
	SoundTestPopoverPositionButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sound_test_popover_position_button_new (pa_position);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	switch (pa_position) {
		case PA_CHANNEL_POSITION_FRONT_LEFT:
		{
			GtkGrid* _tmp1_;
			SoundTestPopoverPositionButton* _tmp2_;
			_tmp1_ = self->priv->main_grid;
			_tmp2_ = button;
			gtk_grid_attach (_tmp1_, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT:
		{
			GtkGrid* _tmp3_;
			SoundTestPopoverPositionButton* _tmp4_;
			_tmp3_ = self->priv->main_grid;
			_tmp4_ = button;
			gtk_grid_attach (_tmp3_, (GtkWidget*) _tmp4_, 4, 0, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_FRONT_CENTER:
		{
			GtkGrid* _tmp5_;
			SoundTestPopoverPositionButton* _tmp6_;
			_tmp5_ = self->priv->main_grid;
			_tmp6_ = button;
			gtk_grid_attach (_tmp5_, (GtkWidget*) _tmp6_, 2, 0, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_REAR_LEFT:
		{
			GtkGrid* _tmp7_;
			SoundTestPopoverPositionButton* _tmp8_;
			_tmp7_ = self->priv->main_grid;
			_tmp8_ = button;
			gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 0, 2, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_REAR_RIGHT:
		{
			GtkGrid* _tmp9_;
			SoundTestPopoverPositionButton* _tmp10_;
			_tmp9_ = self->priv->main_grid;
			_tmp10_ = button;
			gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 4, 2, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_REAR_CENTER:
		{
			GtkGrid* _tmp11_;
			SoundTestPopoverPositionButton* _tmp12_;
			_tmp11_ = self->priv->main_grid;
			_tmp12_ = button;
			gtk_grid_attach (_tmp11_, (GtkWidget*) _tmp12_, 2, 2, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_LFE:
		{
			GtkGrid* _tmp13_;
			SoundTestPopoverPositionButton* _tmp14_;
			_tmp13_ = self->priv->main_grid;
			_tmp14_ = button;
			gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 3, 2, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_SIDE_LEFT:
		{
			GtkGrid* _tmp15_;
			SoundTestPopoverPositionButton* _tmp16_;
			_tmp15_ = self->priv->main_grid;
			_tmp16_ = button;
			gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp16_, 0, 1, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_SIDE_RIGHT:
		{
			GtkGrid* _tmp17_;
			SoundTestPopoverPositionButton* _tmp18_;
			_tmp17_ = self->priv->main_grid;
			_tmp18_ = button;
			gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 4, 1, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER:
		{
			GtkGrid* _tmp19_;
			SoundTestPopoverPositionButton* _tmp20_;
			_tmp19_ = self->priv->main_grid;
			_tmp20_ = button;
			gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 1, 0, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER:
		{
			GtkGrid* _tmp21_;
			SoundTestPopoverPositionButton* _tmp22_;
			_tmp21_ = self->priv->main_grid;
			_tmp22_ = button;
			gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 3, 0, 1, 1);
			break;
		}
		case PA_CHANNEL_POSITION_MONO:
		{
			GtkGrid* _tmp23_;
			SoundTestPopoverPositionButton* _tmp24_;
			_tmp23_ = self->priv->main_grid;
			_tmp24_ = button;
			gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 2, 0, 1, 1);
			break;
		}
		default:
		break;
	}
	_g_object_unref0 (button);
}

static void
_sound_test_popover_update_buttons_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	sound_test_popover_update_buttons ((SoundTestPopover*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sound_test_popover_default_changed (SoundTestPopover* self)
{
	SoundDevice* _tmp0_;
	SoundPulseAudioManager* pam = NULL;
	SoundPulseAudioManager* _tmp3_;
	SoundDevice* _tmp4_;
	SoundDevice* _tmp5_;
	SoundDevice* _tmp6_;
	SoundDevice* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_device;
	if (_tmp0_ != NULL) {
		SoundDevice* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->default_device;
		g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _sound_test_popover_update_buttons_g_object_notify, self);
		sound_test_popover_clear_buttons (self);
	}
	_tmp3_ = sound_pulse_audio_manager_get_default ();
	pam = _tmp3_;
	_tmp4_ = sound_pulse_audio_manager_get_default_output (pam);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->default_device);
	self->priv->default_device = _tmp6_;
	_tmp7_ = self->priv->default_device;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::channel-map", (GCallback) _sound_test_popover_update_buttons_g_object_notify, self, 0);
	sound_test_popover_add_buttons (self);
}

static void
sound_test_popover_update_buttons (SoundTestPopover* self)
{
	g_return_if_fail (self != NULL);
	sound_test_popover_clear_buttons (self);
	sound_test_popover_add_buttons (self);
}

static void
sound_test_popover_clear_buttons (SoundTestPopover* self)
{
	GtkWidget* child = NULL;
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_grid;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	child = _tmp1_;
	while (TRUE) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp2_ = child;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = child;
		if (SOUND_TEST_POPOVER_IS_POSITION_BUTTON (_tmp3_)) {
			GtkGrid* _tmp4_;
			GtkWidget* _tmp5_;
			_tmp4_ = self->priv->main_grid;
			_tmp5_ = child;
			gtk_grid_remove (_tmp4_, _tmp5_);
		}
		_tmp6_ = child;
		_tmp7_ = gtk_widget_get_next_sibling (_tmp6_);
		child = _tmp7_;
	}
}

static void
sound_test_popover_add_buttons (SoundTestPopover* self)
{
	SoundDevice* _tmp0_;
	pa_channel_map _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_device;
	_tmp1_ = _tmp0_->channel_map;
	{
		pa_channel_position_t* position_collection = NULL;
		gint position_collection_length1 = 0;
		gint _position_collection_size_ = 0;
		gint position_it = 0;
		position_collection = _tmp1_.map;
		position_collection_length1 = 32;
		for (position_it = 0; position_it < position_collection_length1; position_it = position_it + 1) {
			pa_channel_position_t position = 0;
			position = position_collection[position_it];
			{
				gboolean _tmp2_ = FALSE;
				if (position > 0) {
					_tmp2_ = position < PA_CHANNEL_POSITION_MAX;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					sound_test_popover_create_position_button (self, position);
				}
			}
		}
	}
}

SoundTestPopover*
sound_test_popover_construct (GType object_type)
{
	SoundTestPopover * self = NULL;
	self = (SoundTestPopover*) g_object_new (object_type, NULL);
	return self;
}

SoundTestPopover*
sound_test_popover_new (void)
{
	return sound_test_popover_construct (SOUND_TYPE_TEST_POPOVER);
}

static inline gpointer
sound_test_popover_position_button_get_instance_private (SoundTestPopoverPositionButton* self)
{
	return G_STRUCT_MEMBER_P (self, SoundTestPopoverPositionButton_private_offset);
}

SoundTestPopoverPositionButton*
sound_test_popover_position_button_construct (GType object_type,
                                              pa_channel_position_t pa_position)
{
	SoundTestPopoverPositionButton * self = NULL;
	self = (SoundTestPopoverPositionButton*) g_object_new (object_type, "pa-position", pa_position, NULL);
	return self;
}

SoundTestPopoverPositionButton*
sound_test_popover_position_button_new (pa_channel_position_t pa_position)
{
	return sound_test_popover_position_button_construct (SOUND_TEST_POPOVER_TYPE_POSITION_BUTTON, pa_position);
}

static gchar*
sound_test_popover_position_button_get_icon (SoundTestPopoverPositionButton* self)
{
	pa_channel_position_t _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pa_position;
	switch (_tmp0_) {
		case PA_CHANNEL_POSITION_FRONT_LEFT:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			if (self->priv->playing) {
				_tmp1_ = "audio-speaker-left-testing";
			} else {
				_tmp1_ = "audio-speaker-left";
			}
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			if (self->priv->playing) {
				_tmp3_ = "audio-speaker-right-testing";
			} else {
				_tmp3_ = "audio-speaker-right";
			}
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_CENTER:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			if (self->priv->playing) {
				_tmp5_ = "audio-speaker-center-testing";
			} else {
				_tmp5_ = "audio-speaker-center";
			}
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_LEFT:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			if (self->priv->playing) {
				_tmp7_ = "audio-speaker-left-back-testing";
			} else {
				_tmp7_ = "audio-speaker-left-back";
			}
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_RIGHT:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			if (self->priv->playing) {
				_tmp9_ = "audio-speaker-right-back-testing";
			} else {
				_tmp9_ = "audio-speaker-right-back";
			}
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_CENTER:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			if (self->priv->playing) {
				_tmp11_ = "audio-speaker-center-back-testing";
			} else {
				_tmp11_ = "audio-speaker-center-back";
			}
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		case PA_CHANNEL_POSITION_LFE:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			if (self->priv->playing) {
				_tmp13_ = "audio-subwoofer-testing";
			} else {
				_tmp13_ = "audio-subwoofer";
			}
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			return result;
		}
		case PA_CHANNEL_POSITION_SIDE_LEFT:
		{
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			if (self->priv->playing) {
				_tmp15_ = "audio-speaker-left-side-testing";
			} else {
				_tmp15_ = "audio-speaker-left-side";
			}
			_tmp16_ = g_strdup (_tmp15_);
			result = _tmp16_;
			return result;
		}
		case PA_CHANNEL_POSITION_SIDE_RIGHT:
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			if (self->priv->playing) {
				_tmp17_ = "audio-speaker-right-side-testing";
			} else {
				_tmp17_ = "audio-speaker-right-side";
			}
			_tmp18_ = g_strdup (_tmp17_);
			result = _tmp18_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER:
		{
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			if (self->priv->playing) {
				_tmp19_ = "audio-speaker-front-left-of-center-testing";
			} else {
				_tmp19_ = "audio-speaker-front-left-of-center";
			}
			_tmp20_ = g_strdup (_tmp19_);
			result = _tmp20_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER:
		{
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			if (self->priv->playing) {
				_tmp21_ = "audio-speaker-front-right-of-center-testing";
			} else {
				_tmp21_ = "audio-speaker-front-right-of-center";
			}
			_tmp22_ = g_strdup (_tmp21_);
			result = _tmp22_;
			return result;
		}
		case PA_CHANNEL_POSITION_MONO:
		{
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			if (self->priv->playing) {
				_tmp23_ = "audio-speaker-mono-testing";
			} else {
				_tmp23_ = "audio-speaker-mono";
			}
			_tmp24_ = g_strdup (_tmp23_);
			result = _tmp24_;
			return result;
		}
		default:
		{
			gchar* _tmp25_;
			_tmp25_ = g_strdup ("audio-speaker-mono");
			result = _tmp25_;
			return result;
		}
	}
}

static gchar*
sound_test_popover_position_button_get_sound_name (SoundTestPopoverPositionButton* self)
{
	pa_channel_position_t _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pa_position;
	switch (_tmp0_) {
		case PA_CHANNEL_POSITION_FRONT_LEFT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("audio-channel-front-left");
			result = _tmp1_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("audio-channel-front-right");
			result = _tmp2_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_CENTER:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("audio-channel-front-center");
			result = _tmp3_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_LEFT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("audio-channel-rear-left");
			result = _tmp4_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_RIGHT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("audio-channel-rear-right");
			result = _tmp5_;
			return result;
		}
		case PA_CHANNEL_POSITION_REAR_CENTER:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("audio-channel-rear-center");
			result = _tmp6_;
			return result;
		}
		case PA_CHANNEL_POSITION_LFE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("audio-channel-lfe");
			result = _tmp7_;
			return result;
		}
		case PA_CHANNEL_POSITION_SIDE_LEFT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("audio-channel-side-left");
			result = _tmp8_;
			return result;
		}
		case PA_CHANNEL_POSITION_SIDE_RIGHT:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("audio-channel-side-right");
			result = _tmp9_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("audio-channel-front-left-of-center");
			result = _tmp10_;
			return result;
		}
		case PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("audio-channel-front-right-of-center");
			result = _tmp11_;
			return result;
		}
		case PA_CHANNEL_POSITION_MONO:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("audio-channel-mono");
			result = _tmp12_;
			return result;
		}
		default:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("audio-test-signal");
			result = _tmp13_;
			return result;
		}
	}
}

static gchar*
sound_test_popover_position_button_get_pretty_position (SoundTestPopoverPositionButton* self)
{
	pa_channel_position_t _tmp0_;
	pa_channel_position_t _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pa_position;
	if (_tmp0_ == PA_CHANNEL_POSITION_LFE) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("Subwoofer");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_pa_position;
	_tmp3_ = pa_channel_position_to_pretty_string (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
_sound_test_popover_position_button_play_full_callback_ca_finishcallback (ca_context* c,
                                                                          guint32 id,
                                                                          gint code,
                                                                          gpointer self)
{
	sound_test_popover_position_button_play_full_callback ((SoundTestPopoverPositionButton*) self, c, id, code);
}

static void
sound_test_popover_position_button_real_clicked (GtkButton* base)
{
	SoundTestPopoverPositionButton * self;
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ca_proplist* proplist = NULL;
	ca_proplist* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	pa_channel_position_t _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ca_context* canberra = NULL;
	ca_context* _tmp10_;
	self = (SoundTestPopoverPositionButton*) base;
	self->priv->playing = TRUE;
	_tmp0_ = self->priv->image;
	_tmp1_ = sound_test_popover_position_button_get_icon (self);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "icon-name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	ca_proplist_create (&_tmp3_);
	_ca_proplist_destroy0 (proplist);
	proplist = _tmp3_;
	ca_proplist_sets (proplist, CA_PROP_MEDIA_ROLE, "test");
	_tmp4_ = sound_test_popover_position_button_get_pretty_position (self);
	_tmp5_ = _tmp4_;
	ca_proplist_sets (proplist, CA_PROP_MEDIA_NAME, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_pa_position;
	_tmp7_ = pa_channel_position_to_string (_tmp6_);
	ca_proplist_sets (proplist, CA_PROP_CANBERRA_FORCE_CHANNEL, _tmp7_);
	ca_proplist_sets (proplist, CA_PROP_CANBERRA_ENABLE, "1");
	_tmp8_ = sound_test_popover_position_button_get_sound_name (self);
	_tmp9_ = _tmp8_;
	ca_proplist_sets (proplist, CA_PROP_EVENT_ID, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = canberra_gtk4_context_get ();
	canberra = _tmp10_;
	ca_context_play_full (canberra, (guint32) 1, proplist, _sound_test_popover_position_button_play_full_callback_ca_finishcallback, self);
	_ca_proplist_destroy0 (proplist);
}

static void
sound_test_popover_position_button_play_full_callback (SoundTestPopoverPositionButton* self,
                                                       ca_context* c,
                                                       guint32 id,
                                                       gint code)
{
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	self->priv->playing = FALSE;
	_tmp0_ = self->priv->image;
	_tmp1_ = sound_test_popover_position_button_get_icon (self);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "icon-name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
}

pa_channel_position_t
sound_test_popover_position_button_get_pa_position (SoundTestPopoverPositionButton* self)
{
	pa_channel_position_t result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_pa_position;
	return result;
}

static void
sound_test_popover_position_button_set_pa_position (SoundTestPopoverPositionButton* self,
                                                    pa_channel_position_t value)
{
	pa_channel_position_t old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_test_popover_position_button_get_pa_position (self);
	if (old_value != value) {
		self->priv->_pa_position = value;
		g_object_notify_by_pspec ((GObject *) self, sound_test_popover_position_button_properties[SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY]);
	}
}

static GObject *
sound_test_popover_position_button_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundTestPopoverPositionButton * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkImage* _tmp2_ = NULL;
	GtkImage* _tmp3_;
	parent_class = G_OBJECT_CLASS (sound_test_popover_position_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TEST_POPOVER_TYPE_POSITION_BUTTON, SoundTestPopoverPositionButton);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_FLAT);
	_tmp0_ = sound_test_popover_position_button_get_icon (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp1_);
	gtk_image_set_pixel_size (_tmp2_, 48);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = self->priv->image;
	gtk_button_set_child ((GtkButton*) self, (GtkWidget*) _tmp3_);
	return obj;
}

static void
sound_test_popover_position_button_class_init (SoundTestPopoverPositionButtonClass * klass,
                                               gpointer klass_data)
{
	sound_test_popover_position_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundTestPopoverPositionButton_private_offset);
	((GtkButtonClass *) klass)->clicked = (void (*) (GtkButton*)) sound_test_popover_position_button_real_clicked;
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_test_popover_position_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_test_popover_position_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_test_popover_position_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_test_popover_position_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY, sound_test_popover_position_button_properties[SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY] = g_param_spec_int ("pa-position", "pa-position", "pa-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
sound_test_popover_position_button_instance_init (SoundTestPopoverPositionButton * self,
                                                  gpointer klass)
{
	self->priv = sound_test_popover_position_button_get_instance_private (self);
	self->priv->playing = FALSE;
}

static void
sound_test_popover_position_button_finalize (GObject * obj)
{
	SoundTestPopoverPositionButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TEST_POPOVER_TYPE_POSITION_BUTTON, SoundTestPopoverPositionButton);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (sound_test_popover_position_button_parent_class)->finalize (obj);
}

static GType
sound_test_popover_position_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundTestPopoverPositionButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_test_popover_position_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundTestPopoverPositionButton), 0, (GInstanceInitFunc) sound_test_popover_position_button_instance_init, NULL };
	GType sound_test_popover_position_button_type_id;
	sound_test_popover_position_button_type_id = g_type_register_static (gtk_button_get_type (), "SoundTestPopoverPositionButton", &g_define_type_info, 0);
	SoundTestPopoverPositionButton_private_offset = g_type_add_instance_private (sound_test_popover_position_button_type_id, sizeof (SoundTestPopoverPositionButtonPrivate));
	return sound_test_popover_position_button_type_id;
}

GType
sound_test_popover_position_button_get_type (void)
{
	static volatile gsize sound_test_popover_position_button_type_id__once = 0;
	if (g_once_init_enter (&sound_test_popover_position_button_type_id__once)) {
		GType sound_test_popover_position_button_type_id;
		sound_test_popover_position_button_type_id = sound_test_popover_position_button_get_type_once ();
		g_once_init_leave (&sound_test_popover_position_button_type_id__once, sound_test_popover_position_button_type_id);
	}
	return sound_test_popover_position_button_type_id__once;
}

static void
_vala_sound_test_popover_position_button_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	SoundTestPopoverPositionButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TEST_POPOVER_TYPE_POSITION_BUTTON, SoundTestPopoverPositionButton);
	switch (property_id) {
		case SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY:
		g_value_set_int (value, sound_test_popover_position_button_get_pa_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_test_popover_position_button_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	SoundTestPopoverPositionButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TEST_POPOVER_TYPE_POSITION_BUTTON, SoundTestPopoverPositionButton);
	switch (property_id) {
		case SOUND_TEST_POPOVER_POSITION_BUTTON_PA_POSITION_PROPERTY:
		sound_test_popover_position_button_set_pa_position (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_sound_test_popover___lambda23_ (SoundTestPopover* self)
{
	sound_test_popover_default_changed (self);
}

static void
__sound_test_popover___lambda23__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_sound_test_popover___lambda23_ ((SoundTestPopover*) self);
}

static GObject *
sound_test_popover_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundTestPopover * self;
	GtkGrid* _tmp0_ = NULL;
	AdwAvatar* me = NULL;
	gchar* _tmp1_;
	AdwAvatar* _tmp2_ = NULL;
	GtkGrid* _tmp3_;
	AdwAvatar* _tmp4_;
	GtkGrid* _tmp5_;
	SoundPulseAudioManager* pam = NULL;
	SoundPulseAudioManager* _tmp6_;
	SoundPulseAudioManager* _tmp7_;
	GtkIconTheme* icon_theme = NULL;
	GdkDisplay* _tmp8_;
	GtkIconTheme* _tmp9_;
	GtkIconTheme* _tmp10_;
	GtkIconTheme* _tmp11_;
	parent_class = G_OBJECT_CLASS (sound_test_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_TEST_POPOVER, SoundTestPopover);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	gtk_grid_set_column_spacing (_tmp0_, 6);
	gtk_grid_set_row_spacing (_tmp0_, 6);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_grid);
	self->priv->main_grid = _tmp0_;
	_tmp1_ = g_strdup ("avatar-default-symbolic");
	_tmp2_ = (AdwAvatar*) adw_avatar_new (48, NULL, TRUE);
	adw_avatar_set_icon_name (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	me = _tmp2_;
	_tmp3_ = self->priv->main_grid;
	_tmp4_ = me;
	gtk_grid_attach (_tmp3_, (GtkWidget*) _tmp4_, 2, 1, 1, 1);
	_tmp5_ = self->priv->main_grid;
	gtk_popover_set_child ((GtkPopover*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = sound_pulse_audio_manager_get_default ();
	pam = _tmp6_;
	_tmp7_ = pam;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::default-output", (GCallback) __sound_test_popover___lambda23__g_object_notify, self, 0);
	_tmp8_ = gdk_display_get_default ();
	_tmp9_ = gtk_icon_theme_get_for_display (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	icon_theme = _tmp10_;
	_tmp11_ = icon_theme;
	gtk_icon_theme_add_resource_path (_tmp11_, "/io/elementary/settings/sound/icons/");
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (me);
	return obj;
}

static void
sound_test_popover_class_init (SoundTestPopoverClass * klass,
                               gpointer klass_data)
{
	sound_test_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundTestPopover_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sound_test_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_test_popover_finalize;
}

static void
sound_test_popover_instance_init (SoundTestPopover * self,
                                  gpointer klass)
{
	self->priv = sound_test_popover_get_instance_private (self);
}

static void
sound_test_popover_finalize (GObject * obj)
{
	SoundTestPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_TEST_POPOVER, SoundTestPopover);
	_g_object_unref0 (self->priv->main_grid);
	_g_object_unref0 (self->priv->default_device);
	G_OBJECT_CLASS (sound_test_popover_parent_class)->finalize (obj);
}

static GType
sound_test_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundTestPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_test_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundTestPopover), 0, (GInstanceInitFunc) sound_test_popover_instance_init, NULL };
	GType sound_test_popover_type_id;
	sound_test_popover_type_id = g_type_register_static (gtk_popover_get_type (), "SoundTestPopover", &g_define_type_info, 0);
	SoundTestPopover_private_offset = g_type_add_instance_private (sound_test_popover_type_id, sizeof (SoundTestPopoverPrivate));
	return sound_test_popover_type_id;
}

GType
sound_test_popover_get_type (void)
{
	static volatile gsize sound_test_popover_type_id__once = 0;
	if (g_once_init_enter (&sound_test_popover_type_id__once)) {
		GType sound_test_popover_type_id;
		sound_test_popover_type_id = sound_test_popover_get_type_once ();
		g_once_init_leave (&sound_test_popover_type_id__once, sound_test_popover_type_id);
	}
	return sound_test_popover_type_id__once;
}

