/* InputPanel.c generated by valac 0.56.17, the Vala compiler
 * generated from InputPanel.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-FileCopyrightText: 2016-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.sound.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_INPUT_PANEL_0_PROPERTY,
	SOUND_INPUT_PANEL_NUM_PROPERTIES
};
static GParamSpec* sound_input_panel_properties[SOUND_INPUT_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SoundInputPanelPrivate {
	SoundDevice* default_device;
	GRecMutex __lock_default_device;
	GtkLevelBar* level_bar;
	GtkListBox* devices_listbox;
	GtkScale* volume_scale;
	GtkSwitch* volume_switch;
	SoundInputDeviceMonitor* device_monitor;
	SoundPulseAudioManager* pam;
};

struct _Block17Data {
	int _ref_count_;
	SoundInputPanel* self;
	SoundDeviceRow* device_row;
	SoundDevice* device;
};

static gint SoundInputPanel_private_offset;
static gpointer sound_input_panel_parent_class = NULL;

static void sound_input_panel_disconnect_signals (SoundInputPanel* self);
static void sound_input_panel_volume_switch_changed (SoundInputPanel* self);
static void _sound_input_panel_volume_switch_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void sound_input_panel_volume_scale_value_changed (SoundInputPanel* self);
static void _sound_input_panel_volume_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                            gpointer self);
static void sound_input_panel_connect_signals (SoundInputPanel* self);
static void sound_input_panel_default_changed (SoundInputPanel* self);
static void sound_input_panel_device_notify (SoundInputPanel* self,
                                      GParamSpec* pspec);
static void _sound_input_panel_device_notify_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void sound_input_panel_add_device (SoundInputPanel* self,
                                   SoundDevice* device);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda27_ (Block17Data* _data17_);
static void ___lambda27__sound_device_row_set_as_default (SoundDeviceRow* _sender,
                                                   gpointer self);
static void __lambda28_ (Block17Data* _data17_);
static void ___lambda28__sound_device_removed (SoundDevice* _sender,
                                        gpointer self);
static GObject * sound_input_panel_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _sound_input_panel___lambda29_ (SoundInputPanel* self,
                                     GtkListBoxRow* row);
static void __sound_input_panel___lambda29__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self);
static void _sound_input_panel___lambda30_ (SoundInputPanel* self,
                                     gfloat fraction);
static void __sound_input_panel___lambda30__sound_input_device_monitor_update_fraction (SoundInputDeviceMonitor* _sender,
                                                                                 gfloat fraction,
                                                                                 gpointer self);
static void _sound_input_panel_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                         SoundDevice* dev,
                                                                         gpointer self);
static void _sound_input_panel___lambda31_ (SoundInputPanel* self);
static void __sound_input_panel___lambda31__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void sound_input_panel_finalize (GObject * obj);
static GType sound_input_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_input_panel_get_instance_private (SoundInputPanel* self)
{
	return G_STRUCT_MEMBER_P (self, SoundInputPanel_private_offset);
}

void
sound_input_panel_set_visibility (SoundInputPanel* self,
                                  gboolean is_visible)
{
	g_return_if_fail (self != NULL);
	if (is_visible) {
		SoundInputDeviceMonitor* _tmp0_;
		_tmp0_ = self->priv->device_monitor;
		sound_input_device_monitor_start_record (_tmp0_);
	} else {
		SoundInputDeviceMonitor* _tmp1_;
		_tmp1_ = self->priv->device_monitor;
		sound_input_device_monitor_stop_record (_tmp1_);
	}
}

static void
_sound_input_panel_volume_switch_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	sound_input_panel_volume_switch_changed ((SoundInputPanel*) self);
}

static void
_sound_input_panel_volume_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                       gpointer self)
{
	sound_input_panel_volume_scale_value_changed ((SoundInputPanel*) self);
}

static void
sound_input_panel_disconnect_signals (SoundInputPanel* self)
{
	GtkSwitch* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GtkScale* _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_switch;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _sound_input_panel_volume_switch_changed_g_object_notify, self);
	_tmp3_ = self->priv->volume_scale;
	g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkRange*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _sound_input_panel_volume_scale_value_changed_gtk_range_value_changed, self);
}

static void
sound_input_panel_connect_signals (SoundInputPanel* self)
{
	GtkSwitch* _tmp0_;
	GtkScale* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_switch;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::active", (GCallback) _sound_input_panel_volume_switch_changed_g_object_notify, self, 0);
	_tmp1_ = self->priv->volume_scale;
	g_signal_connect_object ((GtkRange*) _tmp1_, "value-changed", (GCallback) _sound_input_panel_volume_scale_value_changed_gtk_range_value_changed, self, 0);
}

static void
sound_input_panel_volume_scale_value_changed (SoundInputPanel* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	sound_input_panel_disconnect_signals (self);
	_tmp0_ = self->priv->pam;
	_tmp1_ = self->priv->default_device;
	_tmp2_ = self->priv->volume_scale;
	sound_pulse_audio_manager_change_device_volume (_tmp0_, _tmp1_, gtk_range_get_value ((GtkRange*) _tmp2_));
	sound_input_panel_connect_signals (self);
}

static void
sound_input_panel_volume_switch_changed (SoundInputPanel* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	sound_input_panel_disconnect_signals (self);
	_tmp0_ = self->priv->pam;
	_tmp1_ = self->priv->default_device;
	_tmp2_ = self->priv->volume_switch;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	sound_pulse_audio_manager_change_device_mute (_tmp0_, _tmp1_, !_tmp4_);
	sound_input_panel_connect_signals (self);
}

static void
_sound_input_panel_device_notify_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	sound_input_panel_device_notify ((SoundInputPanel*) self, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sound_input_panel_default_changed (SoundInputPanel* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	sound_input_panel_disconnect_signals (self);
	{
		SoundDevice* _tmp0_;
		_tmp0_ = self->priv->default_device;
		g_rec_mutex_lock (&self->priv->__lock_default_device);
		{
			SoundDevice* _tmp1_;
			SoundPulseAudioManager* _tmp4_;
			SoundDevice* _tmp5_;
			SoundDevice* _tmp6_;
			SoundDevice* _tmp7_;
			SoundDevice* _tmp8_;
			_tmp1_ = self->priv->default_device;
			if (_tmp1_ != NULL) {
				SoundDevice* _tmp2_;
				guint _tmp3_;
				_tmp2_ = self->priv->default_device;
				g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _sound_input_panel_device_notify_g_object_notify, self);
			}
			_tmp4_ = self->priv->pam;
			_tmp5_ = sound_pulse_audio_manager_get_default_input (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (self->priv->default_device);
			self->priv->default_device = _tmp7_;
			_tmp8_ = self->priv->default_device;
			if (_tmp8_ != NULL) {
				SoundInputDeviceMonitor* _tmp9_;
				SoundDevice* _tmp10_;
				GtkSwitch* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				SoundDevice* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				GtkScale* _tmp18_;
				SoundDevice* _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_;
				SoundDevice* _tmp22_;
				_tmp9_ = self->priv->device_monitor;
				_tmp10_ = self->priv->default_device;
				sound_input_device_monitor_set_device (_tmp9_, _tmp10_);
				_tmp11_ = self->priv->volume_switch;
				_tmp12_ = gtk_switch_get_active (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = self->priv->default_device;
				_tmp15_ = sound_device_get_is_muted (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp13_ == _tmp16_) {
					GtkSwitch* _tmp17_;
					_tmp17_ = self->priv->volume_switch;
					g_signal_emit_by_name (_tmp17_, "activate");
				}
				_tmp18_ = self->priv->volume_scale;
				_tmp19_ = self->priv->default_device;
				_tmp20_ = sound_device_get_volume (_tmp19_);
				_tmp21_ = _tmp20_;
				gtk_range_set_value ((GtkRange*) _tmp18_, _tmp21_);
				_tmp22_ = self->priv->default_device;
				g_signal_connect_object ((GObject*) _tmp22_, "notify", (GCallback) _sound_input_panel_device_notify_g_object_notify, self, 0);
			}
		}
		__finally0:
		{
			SoundDevice* _tmp23_;
			_tmp23_ = self->priv->default_device;
			g_rec_mutex_unlock (&self->priv->__lock_default_device);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	sound_input_panel_connect_signals (self);
}

static void
sound_input_panel_device_notify (SoundInputPanel* self,
                                 GParamSpec* pspec)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	sound_input_panel_disconnect_signals (self);
	_tmp0_ = g_param_spec_get_name (pspec);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("is-muted")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				SoundDevice* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				GtkScale* _tmp11_;
				SoundDevice* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp4_ = self->priv->volume_switch;
				_tmp5_ = gtk_switch_get_active (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->priv->default_device;
				_tmp8_ = sound_device_get_is_muted (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp6_ == _tmp9_) {
					GtkSwitch* _tmp10_;
					_tmp10_ = self->priv->volume_switch;
					g_signal_emit_by_name (_tmp10_, "activate");
				}
				_tmp11_ = self->priv->volume_scale;
				_tmp12_ = self->priv->default_device;
				_tmp13_ = sound_device_get_is_muted (_tmp12_);
				_tmp14_ = _tmp13_;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp14_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("volume")))) {
		switch (0) {
			default:
			{
				GtkScale* _tmp15_;
				SoundDevice* _tmp16_;
				gdouble _tmp17_;
				gdouble _tmp18_;
				_tmp15_ = self->priv->volume_scale;
				_tmp16_ = self->priv->default_device;
				_tmp17_ = sound_device_get_volume (_tmp16_);
				_tmp18_ = _tmp17_;
				gtk_range_set_value ((GtkRange*) _tmp15_, _tmp18_);
				break;
			}
		}
	}
	sound_input_panel_connect_signals (self);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		SoundInputPanel* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->device_row);
		_g_object_unref0 (_data17_->device);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda27_ (Block17Data* _data17_)
{
	SoundInputPanel* self;
	SoundPulseAudioManager* _tmp0_;
	self = _data17_->self;
	_tmp0_ = self->priv->pam;
	sound_pulse_audio_manager_set_default_device (_tmp0_, _data17_->device, NULL, NULL);
}

static void
___lambda27__sound_device_row_set_as_default (SoundDeviceRow* _sender,
                                              gpointer self)
{
	__lambda27_ (self);
}

static void
__lambda28_ (Block17Data* _data17_)
{
	SoundInputPanel* self;
	GtkListBox* _tmp0_;
	SoundDeviceRow* _tmp1_;
	self = _data17_->self;
	_tmp0_ = self->priv->devices_listbox;
	_tmp1_ = _data17_->device_row;
	gtk_list_box_remove (_tmp0_, (GtkWidget*) _tmp1_);
}

static void
___lambda28__sound_device_removed (SoundDevice* _sender,
                                   gpointer self)
{
	__lambda28_ (self);
}

static void
sound_input_panel_add_device (SoundInputPanel* self,
                              SoundDevice* device)
{
	Block17Data* _data17_;
	SoundDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SoundDeviceRow* _tmp3_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GtkListBox* _tmp10_;
	SoundDeviceRow* _tmp11_;
	SoundDeviceRow* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data17_->device);
	_data17_->device = _tmp0_;
	_tmp1_ = sound_device_get_input (_data17_->device);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return;
	}
	_tmp3_ = sound_device_row_new (_data17_->device);
	g_object_ref_sink (_tmp3_);
	_data17_->device_row = _tmp3_;
	_tmp4_ = self->priv->devices_listbox;
	_tmp5_ = gtk_list_box_get_row_at_index (_tmp4_, 0);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	row = _tmp6_;
	_tmp7_ = row;
	if (_tmp7_ != NULL) {
		SoundDeviceRow* _tmp8_;
		GtkListBoxRow* _tmp9_;
		_tmp8_ = _data17_->device_row;
		_tmp9_ = row;
		sound_device_row_link_to_row (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SOUND_TYPE_DEVICE_ROW, SoundDeviceRow));
	}
	_tmp10_ = self->priv->devices_listbox;
	_tmp11_ = _data17_->device_row;
	gtk_list_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = _data17_->device_row;
	g_signal_connect_data (_tmp12_, "set-as-default", (GCallback) ___lambda27__sound_device_row_set_as_default, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	g_signal_connect_data (_data17_->device, "removed", (GCallback) ___lambda28__sound_device_removed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_g_object_unref0 (row);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

SoundInputPanel*
sound_input_panel_construct (GType object_type)
{
	SoundInputPanel * self = NULL;
	self = (SoundInputPanel*) g_object_new (object_type, NULL);
	return self;
}

SoundInputPanel*
sound_input_panel_new (void)
{
	return sound_input_panel_construct (SOUND_TYPE_INPUT_PANEL);
}

static void
_sound_input_panel___lambda29_ (SoundInputPanel* self,
                                GtkListBoxRow* row)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	SoundDevice* _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->pam;
	_tmp1_ = sound_device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (row, SOUND_TYPE_DEVICE_ROW, SoundDeviceRow));
	_tmp2_ = _tmp1_;
	sound_pulse_audio_manager_set_default_device (_tmp0_, _tmp2_, NULL, NULL);
}

static void
__sound_input_panel___lambda29__gtk_list_box_row_activated (GtkListBox* _sender,
                                                            GtkListBoxRow* row,
                                                            gpointer self)
{
	_sound_input_panel___lambda29_ ((SoundInputPanel*) self, row);
}

static void
_sound_input_panel___lambda30_ (SoundInputPanel* self,
                                gfloat fraction)
{
	GtkLevelBar* _tmp0_;
	_tmp0_ = self->priv->level_bar;
	gtk_level_bar_set_value (_tmp0_, (gdouble) fraction);
}

static void
__sound_input_panel___lambda30__sound_input_device_monitor_update_fraction (SoundInputDeviceMonitor* _sender,
                                                                            gfloat fraction,
                                                                            gpointer self)
{
	_sound_input_panel___lambda30_ ((SoundInputPanel*) self, fraction);
}

static void
_sound_input_panel_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                    SoundDevice* dev,
                                                                    gpointer self)
{
	sound_input_panel_add_device ((SoundInputPanel*) self, dev);
}

static void
_sound_input_panel___lambda31_ (SoundInputPanel* self)
{
	sound_input_panel_default_changed (self);
}

static void
__sound_input_panel___lambda31__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_sound_input_panel___lambda31_ ((SoundInputPanel*) self);
}

static GObject *
sound_input_panel_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundInputPanel * self;
	GranitePlaceholder* no_device_grid = NULL;
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GranitePlaceholder* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp8_;
	GtkWidget* _tmp9_;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkFrame* devices_frame = NULL;
	GtkScrolledWindow* _tmp11_;
	GtkWidget* _tmp12_;
	GtkFrame* _tmp13_ = NULL;
	GraniteHeaderLabel* volume_label = NULL;
	GraniteHeaderLabel* _tmp14_;
	GtkScale* _tmp15_ = NULL;
	GtkScale* _tmp16_;
	GtkScale* _tmp17_;
	GtkSwitch* _tmp18_ = NULL;
	GtkLevelBar* _tmp19_;
	GtkLevelBar* _tmp20_;
	GtkLevelBar* _tmp21_;
	GtkLevelBar* _tmp22_;
	GtkLevelBar* _tmp23_;
	GtkGrid* volume_grid = NULL;
	GtkGrid* _tmp24_ = NULL;
	GtkGrid* _tmp25_;
	GraniteHeaderLabel* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLevelBar* _tmp28_;
	GtkGrid* _tmp29_;
	GtkScale* _tmp30_;
	GtkGrid* _tmp31_;
	GtkSwitch* _tmp32_;
	GtkFrame* _tmp33_;
	GtkGrid* _tmp34_;
	SoundInputDeviceMonitor* _tmp35_;
	SoundInputDeviceMonitor* _tmp36_;
	SoundPulseAudioManager* _tmp37_;
	SoundPulseAudioManager* _tmp38_;
	SoundPulseAudioManager* _tmp39_;
	parent_class = G_OBJECT_CLASS (sound_input_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_INPUT_PANEL, SoundInputPanel);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	_tmp0_ = g_strdup (_ ("Check that all cables are securely attached and audio input devices ar" \
"e powered on."));
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("audio-input-microphone-symbolic");
	_tmp2_ = granite_placeholder_new (_ ("No Connected Audio Devices Detected"));
	granite_placeholder_set_description (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	granite_placeholder_set_icon (_tmp2_, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	no_device_grid = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp3_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->devices_listbox);
	self->priv->devices_listbox = _tmp3_;
	_tmp4_ = self->priv->devices_listbox;
	_tmp5_ = no_device_grid;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->devices_listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp7_ = self->priv->devices_listbox;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) __sound_input_panel___lambda29__gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->devices_listbox;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp10_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	scrolled = _tmp10_;
	_tmp11_ = scrolled;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	devices_frame = _tmp13_;
	_tmp14_ = granite_header_label_new (_ ("Input Volume"));
	g_object_ref_sink (_tmp14_);
	volume_label = _tmp14_;
	_tmp15_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 5);
	gtk_scale_set_draw_value (_tmp15_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 3);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->volume_scale);
	self->priv->volume_scale = _tmp15_;
	_tmp16_ = self->priv->volume_scale;
	gtk_scale_add_mark (_tmp16_, (gdouble) 10, GTK_POS_BOTTOM, _ ("Unamplified"));
	_tmp17_ = self->priv->volume_scale;
	gtk_scale_add_mark (_tmp17_, (gdouble) 80, GTK_POS_BOTTOM, _ ("100%"));
	_tmp18_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->volume_switch);
	self->priv->volume_switch = _tmp18_;
	_tmp19_ = (GtkLevelBar*) gtk_level_bar_new_for_interval (0.0, 1.0);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->level_bar);
	self->priv->level_bar = _tmp19_;
	_tmp20_ = self->priv->level_bar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp20_, "inverted");
	_tmp21_ = self->priv->level_bar;
	gtk_level_bar_add_offset_value (_tmp21_, "low", 0.8);
	_tmp22_ = self->priv->level_bar;
	gtk_level_bar_add_offset_value (_tmp22_, "high", 0.95);
	_tmp23_ = self->priv->level_bar;
	gtk_level_bar_add_offset_value (_tmp23_, "full", 1.0);
	_tmp24_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp24_, 12);
	gtk_grid_set_row_spacing (_tmp24_, 3);
	g_object_ref_sink (_tmp24_);
	volume_grid = _tmp24_;
	_tmp25_ = volume_grid;
	_tmp26_ = volume_label;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, 0, 1, 1);
	_tmp27_ = volume_grid;
	_tmp28_ = self->priv->level_bar;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 1, 1, 1);
	_tmp29_ = volume_grid;
	_tmp30_ = self->priv->volume_scale;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 0, 2, 1, 1);
	_tmp31_ = volume_grid;
	_tmp32_ = self->priv->volume_switch;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 1, 1, 1, 2);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 18);
	_tmp33_ = devices_frame;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp33_);
	_tmp34_ = volume_grid;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp34_);
	_tmp35_ = sound_input_device_monitor_new ();
	_g_object_unref0 (self->priv->device_monitor);
	self->priv->device_monitor = _tmp35_;
	_tmp36_ = self->priv->device_monitor;
	g_signal_connect_object (_tmp36_, "update-fraction", (GCallback) __sound_input_panel___lambda30__sound_input_device_monitor_update_fraction, self, 0);
	_tmp37_ = sound_pulse_audio_manager_get_default ();
	self->priv->pam = _tmp37_;
	_tmp38_ = self->priv->pam;
	g_signal_connect_object (_tmp38_, "new-device", (GCallback) _sound_input_panel_add_device_sound_pulse_audio_manager_new_device, self, 0);
	_tmp39_ = self->priv->pam;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::default-input", (GCallback) __sound_input_panel___lambda31__g_object_notify, self, 0);
	sound_input_panel_connect_signals (self);
	_g_object_unref0 (volume_grid);
	_g_object_unref0 (volume_label);
	_g_object_unref0 (devices_frame);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (no_device_grid);
	return obj;
}

static void
sound_input_panel_class_init (SoundInputPanelClass * klass,
                              gpointer klass_data)
{
	sound_input_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundInputPanel_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sound_input_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_input_panel_finalize;
}

static void
sound_input_panel_instance_init (SoundInputPanel * self,
                                 gpointer klass)
{
	self->priv = sound_input_panel_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_default_device);
	self->priv->default_device = NULL;
}

static void
sound_input_panel_finalize (GObject * obj)
{
	SoundInputPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_INPUT_PANEL, SoundInputPanel);
	g_rec_mutex_clear (&self->priv->__lock_default_device);
	_g_object_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->level_bar);
	_g_object_unref0 (self->priv->devices_listbox);
	_g_object_unref0 (self->priv->volume_scale);
	_g_object_unref0 (self->priv->volume_switch);
	_g_object_unref0 (self->priv->device_monitor);
	G_OBJECT_CLASS (sound_input_panel_parent_class)->finalize (obj);
}

static GType
sound_input_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundInputPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_input_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundInputPanel), 0, (GInstanceInitFunc) sound_input_panel_instance_init, NULL };
	GType sound_input_panel_type_id;
	sound_input_panel_type_id = g_type_register_static (gtk_box_get_type (), "SoundInputPanel", &g_define_type_info, 0);
	SoundInputPanel_private_offset = g_type_add_instance_private (sound_input_panel_type_id, sizeof (SoundInputPanelPrivate));
	return sound_input_panel_type_id;
}

GType
sound_input_panel_get_type (void)
{
	static volatile gsize sound_input_panel_type_id__once = 0;
	if (g_once_init_enter (&sound_input_panel_type_id__once)) {
		GType sound_input_panel_type_id;
		sound_input_panel_type_id = sound_input_panel_get_type_once ();
		g_once_init_leave (&sound_input_panel_type_id__once, sound_input_panel_type_id);
	}
	return sound_input_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

