/* OutputPanel.c generated by valac 0.56.17, the Vala compiler
 * generated from OutputPanel.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-FileCopyrightText: 2016-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.sound.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <canberra.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_OUTPUT_PANEL_0_PROPERTY,
	SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY,
	SOUND_OUTPUT_PANEL_NUM_PROPERTIES
};
static GParamSpec* sound_output_panel_properties[SOUND_OUTPUT_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))
typedef struct _Block16Data Block16Data;

struct _SoundOutputPanelPrivate {
	gboolean _screen_reader_active;
	SoundDevice* default_device;
	GRecMutex __lock_default_device;
	GtkListBox* devices_listbox;
	GtkScale* balance_scale;
	GtkScale* volume_scale;
	GtkSwitch* volume_switch;
	guint notify_timeout_id;
	ca_context* ca_context;
	SoundPulseAudioManager* pam;
	GSettings* media_keys_settings;
	gchar* _screenreader_shortcut_label;
};

struct _Block15Data {
	int _ref_count_;
	SoundOutputPanel* self;
	SoundDeviceRow* device_row;
	SoundDevice* device;
};

struct _Block16Data {
	int _ref_count_;
	SoundOutputPanel* self;
	GraniteHeaderLabel* screen_reader_label;
	GtkSwitch* screen_reader_switch;
};

static gint SoundOutputPanel_private_offset;
static gpointer sound_output_panel_parent_class = NULL;

static void sound_output_panel_default_changed (SoundOutputPanel* self);
static void sound_output_panel_disconnect_signals (SoundOutputPanel* self);
static void sound_output_panel_device_notify (SoundOutputPanel* self,
                                       GParamSpec* pspec);
static void _sound_output_panel_device_notify_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void sound_output_panel_connect_signals (SoundOutputPanel* self);
static void sound_output_panel_volume_switch_changed (SoundOutputPanel* self);
static void _sound_output_panel_volume_switch_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void sound_output_panel_volume_scale_value_changed (SoundOutputPanel* self);
static void _sound_output_panel_volume_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                             gpointer self);
static void sound_output_panel_balance_scale_value_changed (SoundOutputPanel* self);
static void _sound_output_panel_balance_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                              gpointer self);
static void sound_output_panel_add_device (SoundOutputPanel* self,
                                    SoundDevice* device);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void __lambda32_ (Block15Data* _data15_);
static void ___lambda32__sound_device_row_set_as_default (SoundDeviceRow* _sender,
                                                   gpointer self);
static void __lambda33_ (Block15Data* _data15_);
static void ___lambda33__sound_device_removed (SoundDevice* _sender,
                                        gpointer self);
static void sound_output_panel_notify_change (SoundOutputPanel* self);
static gboolean __lambda34_ (SoundOutputPanel* self);
static gboolean ___lambda34__gsource_func (gpointer self);
static const gchar* sound_output_panel_get_screenreader_shortcut_label (SoundOutputPanel* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GObject * sound_output_panel_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean _sound_output_panel___lambda35_ (Block16Data* _data16_);
static gboolean __sound_output_panel___lambda35__gbinding_transform_func (GBinding* binding,
                                                                   GValue* from_value,
                                                                   GValue* to_value,
                                                                   gpointer self);
static void _sound_output_panel_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                          SoundDevice* dev,
                                                                          gpointer self);
static void _sound_output_panel_default_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _sound_output_panel___lambda36_ (SoundOutputPanel* self,
                                      GtkListBoxRow* row);
static void __sound_output_panel___lambda36__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self);
static void _sound_output_panel___lambda37_ (Block16Data* _data16_);
static void __sound_output_panel___lambda37__g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self);
static gboolean _sound_output_panel___lambda38_ (SoundOutputPanel* self,
                                          GdkEvent* e);
static gboolean __sound_output_panel___lambda38__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                             GdkEvent* event,
                                                                             gpointer self);
static void sound_output_panel_finalize (GObject * obj);
static GType sound_output_panel_get_type_once (void);
static void _vala_sound_output_panel_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_sound_output_panel_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_output_panel_get_instance_private (SoundOutputPanel* self)
{
	return G_STRUCT_MEMBER_P (self, SoundOutputPanel_private_offset);
}

static void
_sound_output_panel_device_notify_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	sound_output_panel_device_notify ((SoundOutputPanel*) self, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sound_output_panel_default_changed (SoundOutputPanel* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	sound_output_panel_disconnect_signals (self);
	{
		SoundDevice* _tmp0_;
		_tmp0_ = self->priv->default_device;
		g_rec_mutex_lock (&self->priv->__lock_default_device);
		{
			SoundDevice* _tmp1_;
			SoundPulseAudioManager* _tmp4_;
			SoundDevice* _tmp5_;
			SoundDevice* _tmp6_;
			SoundDevice* _tmp7_;
			SoundDevice* _tmp8_;
			_tmp1_ = self->priv->default_device;
			if (_tmp1_ != NULL) {
				SoundDevice* _tmp2_;
				guint _tmp3_;
				_tmp2_ = self->priv->default_device;
				g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _sound_output_panel_device_notify_g_object_notify, self);
			}
			_tmp4_ = self->priv->pam;
			_tmp5_ = sound_pulse_audio_manager_get_default_output (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (self->priv->default_device);
			self->priv->default_device = _tmp7_;
			_tmp8_ = self->priv->default_device;
			if (_tmp8_ != NULL) {
				GtkSwitch* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				SoundDevice* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				GtkScale* _tmp16_;
				SoundDevice* _tmp17_;
				gdouble _tmp18_;
				gdouble _tmp19_;
				GtkScale* _tmp20_;
				SoundDevice* _tmp21_;
				gfloat _tmp22_;
				gfloat _tmp23_;
				SoundDevice* _tmp24_;
				_tmp9_ = self->priv->volume_switch;
				_tmp10_ = gtk_switch_get_active (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = self->priv->default_device;
				_tmp13_ = sound_device_get_is_muted (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp11_ == _tmp14_) {
					GtkSwitch* _tmp15_;
					_tmp15_ = self->priv->volume_switch;
					g_signal_emit_by_name (_tmp15_, "activate");
				}
				_tmp16_ = self->priv->volume_scale;
				_tmp17_ = self->priv->default_device;
				_tmp18_ = sound_device_get_volume (_tmp17_);
				_tmp19_ = _tmp18_;
				gtk_range_set_value ((GtkRange*) _tmp16_, _tmp19_);
				_tmp20_ = self->priv->balance_scale;
				_tmp21_ = self->priv->default_device;
				_tmp22_ = sound_device_get_balance (_tmp21_);
				_tmp23_ = _tmp22_;
				gtk_range_set_value ((GtkRange*) _tmp20_, (gdouble) _tmp23_);
				_tmp24_ = self->priv->default_device;
				g_signal_connect_object ((GObject*) _tmp24_, "notify", (GCallback) _sound_output_panel_device_notify_g_object_notify, self, 0);
			}
		}
		__finally0:
		{
			SoundDevice* _tmp25_;
			_tmp25_ = self->priv->default_device;
			g_rec_mutex_unlock (&self->priv->__lock_default_device);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	sound_output_panel_connect_signals (self);
}

static void
_sound_output_panel_volume_switch_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	sound_output_panel_volume_switch_changed ((SoundOutputPanel*) self);
}

static void
_sound_output_panel_volume_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                        gpointer self)
{
	sound_output_panel_volume_scale_value_changed ((SoundOutputPanel*) self);
}

static void
_sound_output_panel_balance_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                         gpointer self)
{
	sound_output_panel_balance_scale_value_changed ((SoundOutputPanel*) self);
}

static void
sound_output_panel_disconnect_signals (SoundOutputPanel* self)
{
	GtkSwitch* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GtkScale* _tmp3_;
	guint _tmp4_;
	GtkScale* _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_switch;
	g_signal_parse_name ("notify::active", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _sound_output_panel_volume_switch_changed_g_object_notify, self);
	_tmp3_ = self->priv->volume_scale;
	g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkRange*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _sound_output_panel_volume_scale_value_changed_gtk_range_value_changed, self);
	_tmp5_ = self->priv->balance_scale;
	g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkRange*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _sound_output_panel_balance_scale_value_changed_gtk_range_value_changed, self);
}

static void
sound_output_panel_connect_signals (SoundOutputPanel* self)
{
	GtkSwitch* _tmp0_;
	GtkScale* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_switch;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::active", (GCallback) _sound_output_panel_volume_switch_changed_g_object_notify, self, 0);
	_tmp1_ = self->priv->volume_scale;
	g_signal_connect_object ((GtkRange*) _tmp1_, "value-changed", (GCallback) _sound_output_panel_volume_scale_value_changed_gtk_range_value_changed, self, 0);
	_tmp2_ = self->priv->balance_scale;
	g_signal_connect_object ((GtkRange*) _tmp2_, "value-changed", (GCallback) _sound_output_panel_balance_scale_value_changed_gtk_range_value_changed, self, 0);
}

static void
sound_output_panel_volume_scale_value_changed (SoundOutputPanel* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	sound_output_panel_disconnect_signals (self);
	_tmp0_ = self->priv->pam;
	_tmp1_ = self->priv->default_device;
	_tmp2_ = self->priv->volume_scale;
	sound_pulse_audio_manager_change_device_volume (_tmp0_, _tmp1_, (gdouble) ((gfloat) gtk_range_get_value ((GtkRange*) _tmp2_)));
	sound_output_panel_connect_signals (self);
}

static void
sound_output_panel_balance_scale_value_changed (SoundOutputPanel* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	sound_output_panel_disconnect_signals (self);
	_tmp0_ = self->priv->pam;
	_tmp1_ = self->priv->default_device;
	_tmp2_ = self->priv->balance_scale;
	sound_pulse_audio_manager_change_device_balance (_tmp0_, _tmp1_, (gfloat) gtk_range_get_value ((GtkRange*) _tmp2_));
	sound_output_panel_connect_signals (self);
}

static void
sound_output_panel_volume_switch_changed (SoundOutputPanel* self)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	sound_output_panel_disconnect_signals (self);
	_tmp0_ = self->priv->pam;
	_tmp1_ = self->priv->default_device;
	_tmp2_ = self->priv->volume_switch;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	sound_pulse_audio_manager_change_device_mute (_tmp0_, _tmp1_, !_tmp4_);
	sound_output_panel_connect_signals (self);
}

static void
sound_output_panel_device_notify (SoundOutputPanel* self,
                                  GParamSpec* pspec)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	sound_output_panel_disconnect_signals (self);
	_tmp0_ = g_param_spec_get_name (pspec);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("is-muted")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				SoundDevice* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				GtkScale* _tmp11_;
				SoundDevice* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				GtkScale* _tmp15_;
				SoundDevice* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp4_ = self->priv->volume_switch;
				_tmp5_ = gtk_switch_get_active (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->priv->default_device;
				_tmp8_ = sound_device_get_is_muted (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp6_ == _tmp9_) {
					GtkSwitch* _tmp10_;
					_tmp10_ = self->priv->volume_switch;
					g_signal_emit_by_name (_tmp10_, "activate");
				}
				_tmp11_ = self->priv->balance_scale;
				_tmp12_ = self->priv->default_device;
				_tmp13_ = sound_device_get_is_muted (_tmp12_);
				_tmp14_ = _tmp13_;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp14_);
				_tmp15_ = self->priv->volume_scale;
				_tmp16_ = self->priv->default_device;
				_tmp17_ = sound_device_get_is_muted (_tmp16_);
				_tmp18_ = _tmp17_;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, !_tmp18_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("volume")))) {
		switch (0) {
			default:
			{
				GtkScale* _tmp19_;
				SoundDevice* _tmp20_;
				gdouble _tmp21_;
				gdouble _tmp22_;
				_tmp19_ = self->priv->volume_scale;
				_tmp20_ = self->priv->default_device;
				_tmp21_ = sound_device_get_volume (_tmp20_);
				_tmp22_ = _tmp21_;
				gtk_range_set_value ((GtkRange*) _tmp19_, _tmp22_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("balance")))) {
		switch (0) {
			default:
			{
				GtkScale* _tmp23_;
				SoundDevice* _tmp24_;
				gfloat _tmp25_;
				gfloat _tmp26_;
				_tmp23_ = self->priv->balance_scale;
				_tmp24_ = self->priv->default_device;
				_tmp25_ = sound_device_get_balance (_tmp24_);
				_tmp26_ = _tmp25_;
				gtk_range_set_value ((GtkRange*) _tmp23_, (gdouble) _tmp26_);
				break;
			}
		}
	}
	sound_output_panel_connect_signals (self);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		SoundOutputPanel* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->device_row);
		_g_object_unref0 (_data15_->device);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda32_ (Block15Data* _data15_)
{
	SoundOutputPanel* self;
	SoundPulseAudioManager* _tmp0_;
	self = _data15_->self;
	_tmp0_ = self->priv->pam;
	sound_pulse_audio_manager_set_default_device (_tmp0_, _data15_->device, NULL, NULL);
}

static void
___lambda32__sound_device_row_set_as_default (SoundDeviceRow* _sender,
                                              gpointer self)
{
	__lambda32_ (self);
}

static void
__lambda33_ (Block15Data* _data15_)
{
	SoundOutputPanel* self;
	GtkListBox* _tmp0_;
	SoundDeviceRow* _tmp1_;
	self = _data15_->self;
	_tmp0_ = self->priv->devices_listbox;
	_tmp1_ = _data15_->device_row;
	gtk_list_box_remove (_tmp0_, (GtkWidget*) _tmp1_);
}

static void
___lambda33__sound_device_removed (SoundDevice* _sender,
                                   gpointer self)
{
	__lambda33_ (self);
}

static void
sound_output_panel_add_device (SoundOutputPanel* self,
                               SoundDevice* device)
{
	Block15Data* _data15_;
	SoundDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SoundDeviceRow* _tmp3_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GtkListBox* _tmp10_;
	SoundDeviceRow* _tmp11_;
	SoundDeviceRow* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data15_->device);
	_data15_->device = _tmp0_;
	_tmp1_ = sound_device_get_input (_data15_->device);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return;
	}
	_tmp3_ = sound_device_row_new (_data15_->device);
	g_object_ref_sink (_tmp3_);
	_data15_->device_row = _tmp3_;
	_tmp4_ = self->priv->devices_listbox;
	_tmp5_ = gtk_list_box_get_row_at_index (_tmp4_, 0);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	row = _tmp6_;
	_tmp7_ = row;
	if (_tmp7_ != NULL) {
		SoundDeviceRow* _tmp8_;
		GtkListBoxRow* _tmp9_;
		_tmp8_ = _data15_->device_row;
		_tmp9_ = row;
		sound_device_row_link_to_row (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SOUND_TYPE_DEVICE_ROW, SoundDeviceRow));
	}
	_tmp10_ = self->priv->devices_listbox;
	_tmp11_ = _data15_->device_row;
	gtk_list_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = _data15_->device_row;
	g_signal_connect_data (_tmp12_, "set-as-default", (GCallback) ___lambda32__sound_device_row_set_as_default, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	g_signal_connect_data (_data15_->device, "removed", (GCallback) ___lambda33__sound_device_removed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_g_object_unref0 (row);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static gboolean
__lambda34_ (SoundOutputPanel* self)
{
	ca_proplist* props = NULL;
	ca_proplist* _tmp0_ = NULL;
	ca_context* _tmp1_;
	gboolean result;
	ca_proplist_create (&_tmp0_);
	_ca_proplist_destroy0 (props);
	props = _tmp0_;
	ca_proplist_sets (props, CA_PROP_CANBERRA_CACHE_CONTROL, "volatile");
	ca_proplist_sets (props, CA_PROP_EVENT_ID, "audio-volume-change");
	_tmp1_ = self->priv->ca_context;
	ca_context_play_full (_tmp1_, (guint32) 0, props, NULL, NULL);
	self->priv->notify_timeout_id = (guint) 0;
	result = FALSE;
	_ca_proplist_destroy0 (props);
	return result;
}

static gboolean
___lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda34_ ((SoundOutputPanel*) self);
	return result;
}

static void
sound_output_panel_notify_change (SoundOutputPanel* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->notify_timeout_id > ((guint) 0)) {
		return;
	}
	self->priv->notify_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, ___lambda34__gsource_func, g_object_ref (self), g_object_unref);
}

SoundOutputPanel*
sound_output_panel_construct (GType object_type)
{
	SoundOutputPanel * self = NULL;
	self = (SoundOutputPanel*) g_object_new (object_type, NULL);
	return self;
}

SoundOutputPanel*
sound_output_panel_new (void)
{
	return sound_output_panel_construct (SOUND_TYPE_OUTPUT_PANEL);
}

gboolean
sound_output_panel_get_screen_reader_active (SoundOutputPanel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_screen_reader_active;
	return result;
}

void
sound_output_panel_set_screen_reader_active (SoundOutputPanel* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_output_panel_get_screen_reader_active (self);
	if (old_value != value) {
		self->priv->_screen_reader_active = value;
		g_object_notify_by_pspec ((GObject *) self, sound_output_panel_properties[SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY]);
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static const gchar*
sound_output_panel_get_screenreader_shortcut_label (SoundOutputPanel* self)
{
	const gchar* result;
	gchar** granite_accel_strings = NULL;
	gint granite_accel_strings_length1;
	gint _granite_accel_strings_size_;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	granite_accel_strings = NULL;
	granite_accel_strings_length1 = 0;
	_granite_accel_strings_size_ = granite_accel_strings_length1;
	_tmp0_ = self->priv->media_keys_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "screenreader");
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp2_;
		key_collection_length1 = _vala_array_length (_tmp1_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			const gchar* key = NULL;
			key = key_collection[key_it];
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = key;
				_tmp4_ = granite_accel_to_string (_tmp3_);
				_vala_array_add2 (&granite_accel_strings, &granite_accel_strings_length1, &_granite_accel_strings_size_, _tmp4_);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = granite_accel_strings;
	_tmp5__length1 = granite_accel_strings_length1;
	_tmp6_ = _vala_g_strjoinv (_ (", "), _tmp5_, (gint) _tmp5__length1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Provide audio descriptions for items on the screen. %s"), _tmp7_);
	_g_free0 (self->priv->_screenreader_shortcut_label);
	self->priv->_screenreader_shortcut_label = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->_screenreader_shortcut_label;
	result = _tmp9_;
	granite_accel_strings = (_vala_array_free (granite_accel_strings, granite_accel_strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		SoundOutputPanel* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->screen_reader_switch);
		_g_object_unref0 (_data16_->screen_reader_label);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
_sound_output_panel___lambda35_ (Block16Data* _data16_)
{
	SoundOutputPanel* self;
	gboolean _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data16_->self;
	_tmp0_ = self->priv->_screen_reader_active;
	_tmp1_ = _data16_->screen_reader_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0_ != _tmp3_) {
		GtkSwitch* _tmp4_;
		_tmp4_ = _data16_->screen_reader_switch;
		g_signal_emit_by_name (_tmp4_, "activate");
	}
}

static gboolean
__sound_output_panel___lambda35__gbinding_transform_func (GBinding* binding,
                                                          GValue* from_value,
                                                          GValue* to_value,
                                                          gpointer self)
{
	gboolean result;
	result = _sound_output_panel___lambda35_ (self);
	return result;
}

static void
_sound_output_panel_add_device_sound_pulse_audio_manager_new_device (SoundPulseAudioManager* _sender,
                                                                     SoundDevice* dev,
                                                                     gpointer self)
{
	sound_output_panel_add_device ((SoundOutputPanel*) self, dev);
}

static void
_sound_output_panel_default_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	sound_output_panel_default_changed ((SoundOutputPanel*) self);
}

static void
_sound_output_panel___lambda36_ (SoundOutputPanel* self,
                                 GtkListBoxRow* row)
{
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	SoundDevice* _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->pam;
	_tmp1_ = sound_device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (row, SOUND_TYPE_DEVICE_ROW, SoundDeviceRow));
	_tmp2_ = _tmp1_;
	sound_pulse_audio_manager_set_default_device (_tmp0_, _tmp2_, NULL, NULL);
}

static void
__sound_output_panel___lambda36__gtk_list_box_row_activated (GtkListBox* _sender,
                                                             GtkListBoxRow* row,
                                                             gpointer self)
{
	_sound_output_panel___lambda36_ ((SoundOutputPanel*) self, row);
}

static void
_sound_output_panel___lambda37_ (Block16Data* _data16_)
{
	SoundOutputPanel* self;
	GraniteHeaderLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data16_->self;
	_tmp0_ = _data16_->screen_reader_label;
	_tmp1_ = sound_output_panel_get_screenreader_shortcut_label (self);
	_tmp2_ = _tmp1_;
	granite_header_label_set_secondary_text (_tmp0_, _tmp2_);
}

static void
__sound_output_panel___lambda37__g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self)
{
	_sound_output_panel___lambda37_ (self);
}

static gboolean
_sound_output_panel___lambda38_ (SoundOutputPanel* self,
                                 GdkEvent* e)
{
	GdkEventType event_type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	event_type = gdk_event_get_event_type (e);
	if (event_type == GDK_SCROLL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event_type == GDK_BUTTON_RELEASE;
	}
	if (_tmp0_) {
		sound_output_panel_notify_change (self);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__sound_output_panel___lambda38__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                    GdkEvent* event,
                                                                    gpointer self)
{
	gboolean result;
	result = _sound_output_panel___lambda38_ ((SoundOutputPanel*) self, event);
	return result;
}

static GObject *
sound_output_panel_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundOutputPanel * self;
	Block16Data* _data16_;
	GranitePlaceholder* no_device_grid = NULL;
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GranitePlaceholder* _tmp5_;
	GtkListBox* _tmp6_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp7_;
	GtkWidget* _tmp8_;
	GtkScrolledWindow* _tmp9_ = NULL;
	GtkFrame* devices_frame = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkWidget* _tmp11_;
	GtkFrame* _tmp12_ = NULL;
	GraniteHeaderLabel* volume_label = NULL;
	GraniteHeaderLabel* _tmp13_;
	GtkEventControllerLegacy* legacy_controller = NULL;
	GtkEventControllerLegacy* _tmp14_;
	GtkScale* _tmp15_ = NULL;
	GtkScale* _tmp16_;
	GtkAdjustment* _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkScale* _tmp19_;
	GtkEventControllerLegacy* _tmp20_;
	GtkEventController* _tmp21_;
	GtkSwitch* _tmp22_ = NULL;
	GtkScale* _tmp23_ = NULL;
	GtkScale* _tmp24_;
	GtkAdjustment* _tmp25_;
	GtkAdjustment* _tmp26_;
	GtkScale* _tmp27_;
	GtkScale* _tmp28_;
	GtkScale* _tmp29_;
	GraniteHeaderLabel* alerts_label = NULL;
	gchar* _tmp30_;
	GraniteHeaderLabel* _tmp31_ = NULL;
	GtkCheckButton* audio_alert_check = NULL;
	GtkCheckButton* _tmp32_ = NULL;
	GtkCheckButton* visual_alert_check = NULL;
	GtkCheckButton* _tmp33_ = NULL;
	SoundTestPopover* test_popover = NULL;
	SoundTestPopover* _tmp34_;
	GtkMenuButton* test_button = NULL;
	gchar* _tmp35_;
	SoundTestPopover* _tmp36_;
	GtkPopover* _tmp37_;
	GtkMenuButton* _tmp38_ = NULL;
	GSettings* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	GraniteHeaderLabel* _tmp43_ = NULL;
	GtkSwitch* _tmp44_ = NULL;
	GtkGrid* output_grid = NULL;
	GtkGrid* _tmp45_ = NULL;
	GtkGrid* _tmp46_;
	GraniteHeaderLabel* _tmp47_;
	GtkGrid* _tmp48_;
	GtkScale* _tmp49_;
	GtkGrid* _tmp50_;
	GtkSwitch* _tmp51_;
	GtkGrid* _tmp52_;
	GtkScale* _tmp53_;
	GtkBox* alerts_box = NULL;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GraniteHeaderLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkCheckButton* _tmp58_;
	GtkBox* _tmp59_;
	GtkCheckButton* _tmp60_;
	GtkBox* screen_reader_box = NULL;
	GtkBox* _tmp61_;
	GtkBox* _tmp62_;
	GraniteHeaderLabel* _tmp63_;
	GtkBox* _tmp64_;
	GtkSwitch* _tmp65_;
	GtkFrame* _tmp66_;
	GtkGrid* _tmp67_;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	GtkMenuButton* _tmp70_;
	GSettings* applications_settings = NULL;
	GSettings* _tmp71_;
	GtkSwitch* _tmp72_;
	GSettings* _tmp73_;
	SoundPulseAudioManager* _tmp74_;
	SoundPulseAudioManager* _tmp75_;
	SoundPulseAudioManager* _tmp76_;
	GSettings* sound_settings = NULL;
	GSettings* _tmp77_;
	GSettings* _tmp78_;
	GtkCheckButton* _tmp79_;
	GSettings* wm_settings = NULL;
	GSettings* _tmp80_;
	GSettings* _tmp81_;
	GtkCheckButton* _tmp82_;
	ca_context* _tmp83_;
	gchar* locale = NULL;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	ca_context* _tmp86_;
	const gchar* _tmp87_;
	ca_context* _tmp88_;
	GtkListBox* _tmp89_;
	GSettings* _tmp90_;
	GtkEventControllerLegacy* _tmp91_;
	parent_class = G_OBJECT_CLASS (sound_output_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_OUTPUT_PANEL, SoundOutputPanel);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Check that all cables are securely attached and audio output devices a" \
"re powered on."));
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("audio-volume-muted-symbolic");
	_tmp2_ = granite_placeholder_new (_ ("No Connected Output Devices Detected"));
	granite_placeholder_set_description (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	granite_placeholder_set_icon (_tmp2_, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	no_device_grid = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp3_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->devices_listbox);
	self->priv->devices_listbox = _tmp3_;
	_tmp4_ = self->priv->devices_listbox;
	_tmp5_ = no_device_grid;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->devices_listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp7_ = self->priv->devices_listbox;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	scrolled = _tmp9_;
	_tmp10_ = scrolled;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	devices_frame = _tmp12_;
	_tmp13_ = granite_header_label_new (_ ("Volume"));
	g_object_ref_sink (_tmp13_);
	volume_label = _tmp13_;
	_tmp14_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
	legacy_controller = _tmp14_;
	_tmp15_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 5);
	gtk_scale_set_draw_value (_tmp15_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->volume_scale);
	self->priv->volume_scale = _tmp15_;
	_tmp16_ = self->priv->volume_scale;
	_tmp17_ = gtk_range_get_adjustment ((GtkRange*) _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_adjustment_set_page_increment (_tmp18_, (gdouble) 5);
	_tmp19_ = self->priv->volume_scale;
	_tmp20_ = legacy_controller;
	_tmp21_ = _g_object_ref0 ((GtkEventController*) _tmp20_);
	gtk_widget_add_controller ((GtkWidget*) _tmp19_, _tmp21_);
	_tmp22_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	gtk_switch_set_active (_tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->volume_switch);
	self->priv->volume_switch = _tmp22_;
	_tmp23_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) -1, (gdouble) 1, 0.1);
	gtk_scale_set_draw_value (_tmp23_, FALSE);
	gtk_scale_set_has_origin (_tmp23_, FALSE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->balance_scale);
	self->priv->balance_scale = _tmp23_;
	_tmp24_ = self->priv->balance_scale;
	_tmp25_ = gtk_range_get_adjustment ((GtkRange*) _tmp24_);
	_tmp26_ = _tmp25_;
	gtk_adjustment_set_page_increment (_tmp26_, 0.1);
	_tmp27_ = self->priv->balance_scale;
	gtk_scale_add_mark (_tmp27_, (gdouble) -1, GTK_POS_BOTTOM, C_ ("balance", "Left"));
	_tmp28_ = self->priv->balance_scale;
	gtk_scale_add_mark (_tmp28_, (gdouble) 0, GTK_POS_BOTTOM, C_ ("balance", "Center"));
	_tmp29_ = self->priv->balance_scale;
	gtk_scale_add_mark (_tmp29_, (gdouble) 1, GTK_POS_BOTTOM, C_ ("balance", "Right"));
	_tmp30_ = g_strdup (_ ("Notify when the system can't do something in response to input, like a" \
"ttempting to backspace in an empty input or switch windows when only o" \
"ne is open."));
	_tmp31_ = granite_header_label_new (_ ("Event Alerts"));
	granite_header_label_set_secondary_text (_tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	alerts_label = _tmp31_;
	_tmp32_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Play sound"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 6);
	g_object_ref_sink (_tmp32_);
	audio_alert_check = _tmp32_;
	_tmp33_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Flash screen"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp33_, 6);
	g_object_ref_sink (_tmp33_);
	visual_alert_check = _tmp33_;
	_tmp34_ = sound_test_popover_new ();
	g_object_ref_sink (_tmp34_);
	test_popover = _tmp34_;
	_tmp35_ = g_strdup (_ ("Test Speakers…"));
	_tmp36_ = test_popover;
	_tmp37_ = _g_object_ref0 ((GtkPopover*) _tmp36_);
	_tmp38_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_direction (_tmp38_, GTK_ARROW_UP);
	gtk_widget_set_halign ((GtkWidget*) _tmp38_, GTK_ALIGN_END);
	gtk_menu_button_set_label (_tmp38_, _tmp35_);
	_g_free0 (_tmp35_);
	gtk_menu_button_set_popover (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	test_button = _tmp38_;
	_tmp39_ = g_settings_new ("org.gnome.settings-daemon.plugins.media-keys");
	_g_object_unref0 (self->priv->media_keys_settings);
	self->priv->media_keys_settings = _tmp39_;
	_tmp40_ = sound_output_panel_get_screenreader_shortcut_label (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup (_tmp41_);
	_tmp43_ = granite_header_label_new (_ ("Screen Reader"));
	granite_header_label_set_secondary_text (_tmp43_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_ref_sink (_tmp43_);
	_data16_->screen_reader_label = _tmp43_;
	_tmp44_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp44_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp44_, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp44_, TRUE);
	g_object_ref_sink (_tmp44_);
	_data16_->screen_reader_switch = _tmp44_;
	_tmp45_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp45_, 12);
	g_object_ref_sink (_tmp45_);
	output_grid = _tmp45_;
	_tmp46_ = output_grid;
	_tmp47_ = volume_label;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 0, 0, 2, 1);
	_tmp48_ = output_grid;
	_tmp49_ = self->priv->volume_scale;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 0, 1, 1, 1);
	_tmp50_ = output_grid;
	_tmp51_ = self->priv->volume_switch;
	gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 1, 1, 1, 1);
	_tmp52_ = output_grid;
	_tmp53_ = self->priv->balance_scale;
	gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 0, 2, 1, 1);
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp54_);
	alerts_box = _tmp54_;
	_tmp55_ = alerts_box;
	_tmp56_ = alerts_label;
	gtk_box_append (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = alerts_box;
	_tmp58_ = audio_alert_check;
	gtk_box_append (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = alerts_box;
	_tmp60_ = visual_alert_check;
	gtk_box_append (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp61_);
	screen_reader_box = _tmp61_;
	_tmp62_ = screen_reader_box;
	_tmp63_ = _data16_->screen_reader_label;
	gtk_box_append (_tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = screen_reader_box;
	_tmp65_ = _data16_->screen_reader_switch;
	gtk_box_append (_tmp64_, (GtkWidget*) _tmp65_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 18);
	_tmp66_ = devices_frame;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp66_);
	_tmp67_ = output_grid;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp67_);
	_tmp68_ = alerts_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp68_);
	_tmp69_ = screen_reader_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp69_);
	_tmp70_ = test_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp70_);
	_tmp71_ = g_settings_new ("org.gnome.desktop.a11y.applications");
	applications_settings = _tmp71_;
	_tmp72_ = _data16_->screen_reader_switch;
	g_object_bind_property_with_closures ((GObject*) self, "screen-reader-active", (GObject*) _tmp72_, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((__sound_output_panel___lambda35__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __sound_output_panel___lambda35__gbinding_transform_func, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp73_ = applications_settings;
	g_settings_bind (_tmp73_, "screen-reader-enabled", (GObject*) self, "screen_reader_active", G_SETTINGS_BIND_DEFAULT);
	_tmp74_ = sound_pulse_audio_manager_get_default ();
	self->priv->pam = _tmp74_;
	_tmp75_ = self->priv->pam;
	g_signal_connect_object (_tmp75_, "new-device", (GCallback) _sound_output_panel_add_device_sound_pulse_audio_manager_new_device, self, 0);
	_tmp76_ = self->priv->pam;
	g_signal_connect_object ((GObject*) _tmp76_, "notify::default-output", (GCallback) _sound_output_panel_default_changed_g_object_notify, self, 0);
	_tmp77_ = g_settings_new ("org.gnome.desktop.sound");
	sound_settings = _tmp77_;
	_tmp78_ = sound_settings;
	_tmp79_ = audio_alert_check;
	g_settings_bind (_tmp78_, "event-sounds", (GObject*) _tmp79_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp80_ = g_settings_new ("org.gnome.desktop.wm.preferences");
	wm_settings = _tmp80_;
	_tmp81_ = wm_settings;
	_tmp82_ = visual_alert_check;
	g_settings_bind (_tmp81_, "visual-bell", (GObject*) _tmp82_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp83_ = canberra_gtk4_context_get ();
	self->priv->ca_context = _tmp83_;
	_tmp84_ = setlocale (LC_MESSAGES, NULL);
	_tmp85_ = g_strdup (_tmp84_);
	locale = _tmp85_;
	_tmp86_ = self->priv->ca_context;
	_tmp87_ = locale;
	ca_context_change_props (_tmp86_, CA_PROP_APPLICATION_NAME, "Sound Settings", CA_PROP_APPLICATION_ID, "io.elementary.settings.sound", CA_PROP_APPLICATION_LANGUAGE, _tmp87_, NULL, NULL);
	_tmp88_ = self->priv->ca_context;
	ca_context_open (_tmp88_);
	sound_output_panel_connect_signals (self);
	_tmp89_ = self->priv->devices_listbox;
	g_signal_connect_object (_tmp89_, "row-activated", (GCallback) __sound_output_panel___lambda36__gtk_list_box_row_activated, self, 0);
	_tmp90_ = self->priv->media_keys_settings;
	g_signal_connect_data (_tmp90_, "changed::screenreader", (GCallback) __sound_output_panel___lambda37__g_settings_changed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp91_ = legacy_controller;
	g_signal_connect_object (_tmp91_, "event", (GCallback) __sound_output_panel___lambda38__gtk_event_controller_legacy_event, self, 0);
	_g_free0 (locale);
	_g_object_unref0 (wm_settings);
	_g_object_unref0 (sound_settings);
	_g_object_unref0 (applications_settings);
	_g_object_unref0 (screen_reader_box);
	_g_object_unref0 (alerts_box);
	_g_object_unref0 (output_grid);
	_g_object_unref0 (test_button);
	_g_object_unref0 (test_popover);
	_g_object_unref0 (visual_alert_check);
	_g_object_unref0 (audio_alert_check);
	_g_object_unref0 (alerts_label);
	_g_object_unref0 (legacy_controller);
	_g_object_unref0 (volume_label);
	_g_object_unref0 (devices_frame);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (no_device_grid);
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return obj;
}

static void
sound_output_panel_class_init (SoundOutputPanelClass * klass,
                               gpointer klass_data)
{
	sound_output_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundOutputPanel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_output_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_output_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_output_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_output_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY, sound_output_panel_properties[SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY] = g_param_spec_boolean ("screen-reader-active", "screen-reader-active", "screen-reader-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sound_output_panel_instance_init (SoundOutputPanel * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = sound_output_panel_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_default_device);
	self->priv->default_device = NULL;
	self->priv->notify_timeout_id = (guint) 0;
	self->priv->ca_context = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_screenreader_shortcut_label = _tmp0_;
}

static void
sound_output_panel_finalize (GObject * obj)
{
	SoundOutputPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_OUTPUT_PANEL, SoundOutputPanel);
	g_rec_mutex_clear (&self->priv->__lock_default_device);
	_g_object_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->devices_listbox);
	_g_object_unref0 (self->priv->balance_scale);
	_g_object_unref0 (self->priv->volume_scale);
	_g_object_unref0 (self->priv->volume_switch);
	_g_object_unref0 (self->priv->media_keys_settings);
	_g_free0 (self->priv->_screenreader_shortcut_label);
	G_OBJECT_CLASS (sound_output_panel_parent_class)->finalize (obj);
}

static GType
sound_output_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundOutputPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_output_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundOutputPanel), 0, (GInstanceInitFunc) sound_output_panel_instance_init, NULL };
	GType sound_output_panel_type_id;
	sound_output_panel_type_id = g_type_register_static (gtk_box_get_type (), "SoundOutputPanel", &g_define_type_info, 0);
	SoundOutputPanel_private_offset = g_type_add_instance_private (sound_output_panel_type_id, sizeof (SoundOutputPanelPrivate));
	return sound_output_panel_type_id;
}

GType
sound_output_panel_get_type (void)
{
	static volatile gsize sound_output_panel_type_id__once = 0;
	if (g_once_init_enter (&sound_output_panel_type_id__once)) {
		GType sound_output_panel_type_id;
		sound_output_panel_type_id = sound_output_panel_get_type_once ();
		g_once_init_leave (&sound_output_panel_type_id__once, sound_output_panel_type_id);
	}
	return sound_output_panel_type_id__once;
}

static void
_vala_sound_output_panel_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SoundOutputPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_OUTPUT_PANEL, SoundOutputPanel);
	switch (property_id) {
		case SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY:
		g_value_set_boolean (value, sound_output_panel_get_screen_reader_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_output_panel_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SoundOutputPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_OUTPUT_PANEL, SoundOutputPanel);
	switch (property_id) {
		case SOUND_OUTPUT_PANEL_SCREEN_READER_ACTIVE_PROPERTY:
		sound_output_panel_set_screen_reader_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

