/* zeitgeist-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from zeitgeist-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <zeitgeist-datamodel.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME "org.gnome.zeitgeist.Engine"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH (synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatchClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatchClass))

typedef struct _SynapseZeitgeistPluginZeitgeistUriMatch SynapseZeitgeistPluginZeitgeistUriMatch;
typedef struct _SynapseZeitgeistPluginZeitgeistUriMatchClass SynapseZeitgeistPluginZeitgeistUriMatchClass;
typedef struct _SynapseZeitgeistPluginProcessResultsData SynapseZeitgeistPluginProcessResultsData;
typedef struct _SynapseZeitgeistPluginProcessRecentResultsData SynapseZeitgeistPluginProcessRecentResultsData;
typedef struct _Block7Data Block7Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseZeitgeistPluginSearchData SynapseZeitgeistPluginSearchData;

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH (synapse_zeitgeist_plugin_zeitgeist_application_match_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatchClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatchClass))

typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatch SynapseZeitgeistPluginZeitgeistApplicationMatch;
typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatchClass SynapseZeitgeistPluginZeitgeistApplicationMatchClass;
typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate;
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_zeitgeist_application_match_properties[SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_NUM_PROPERTIES];
typedef struct _SynapseZeitgeistPluginZeitgeistUriMatchPrivate SynapseZeitgeistPluginZeitgeistUriMatchPrivate;
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_zeitgeist_uri_match_properties[SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_NUM_PROPERTIES];

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY (synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactory))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactoryClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_MATCH_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_MATCH_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactoryClass))

typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactory SynapseZeitgeistPluginZeitgeistMatchFactory;
typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactoryClass SynapseZeitgeistPluginZeitgeistMatchFactoryClass;
typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate;
typedef struct _SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory;

struct _SynapseZeitgeistPluginPrivate {
	gboolean _enabled;
	SynapseDataSink* _data_sink;
	ZeitgeistIndex* zg_index;
	ZeitgeistLog* zg_log;
	gboolean search_in_progress;
};

struct _SynapseZeitgeistPluginProcessResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* query;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* real_results;
	gboolean local_only;
	gboolean places_search;
	GeeSet* uris;
	GeeHashSet* _tmp0_;
	GeeList* matchers;
	GeeList* _tmp1_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp2_;
	glong minimum;
	glong maximum;
	ZeitgeistResultSet* _event_it;
	ZeitgeistResultSet* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistResultSet* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistSubject* subject;
	ZeitgeistEvent* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	gconstpointer _tmp11_;
	ZeitgeistSubject* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistSubject* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ZeitgeistSubject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* uri;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GeeSet* _tmp23_;
	const gchar* _tmp24_;
	gboolean is_application;
	const gchar* _tmp25_;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GeeSet* _tmp26_;
	const gchar* _tmp27_;
	GFile* f;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	GFile* _tmp34_;
	GFileInfo* fi;
	GFile* _tmp35_;
	const gchar* _tmp36_;
	GFileInfo* _tmp37_;
	GFileInfo* _tmp38_;
	GIcon* _tmp39_;
	gchar* _tmp40_;
	GFileInfo* _tmp41_;
	GFileInfo* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	GFileInfo* _tmp45_;
	const gchar* _tmp46_;
	gchar* note_filename;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* note_path;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	GFile* note_f;
	const gchar* _tmp55_;
	GFile* _tmp56_;
	gboolean exists;
	GFile* _tmp57_;
	GIcon* _tmp58_;
	GIcon* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp62_;
	SynapseDesktopFileService* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	SynapseDesktopFileInfo* _tmp67_;
	SynapseDesktopFileInfo* _tmp68_;
	gboolean _tmp69_;
	const gchar* mimetype;
	ZeitgeistSubject* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	gboolean _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	GIcon* _tmp77_;
	GIcon* _tmp78_;
	gchar* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	SynapseQueryFlags _tmp82_;
	SynapseQueryFlags _tmp83_;
	SynapseQueryFlags query_type;
	SynapseMatch* match_obj;
	ZeitgeistEvent* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	SynapseMatch* _tmp87_;
	gboolean match_found;
	GeeList* _matcher_list;
	GeeList* _tmp88_;
	gint _matcher_size;
	GeeList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	gint _matcher_index;
	gint _tmp92_;
	gint _tmp93_;
	GeeMapEntry* matcher;
	GeeList* _tmp94_;
	gpointer _tmp95_;
	gchar* adjusted_title;
	const gchar* _tmp96_;
	SynapseMatch* _tmp97_;
	const gchar* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	const gchar* _tmp102_;
	const gchar* _tmp103_;
	SynapseMatch* _tmp104_;
	const gchar* _tmp105_;
	const gchar* _tmp106_;
	GeeMapEntry* _tmp107_;
	gconstpointer _tmp108_;
	gconstpointer _tmp109_;
	gint relevancy;
	const gchar* _tmp110_;
	GeeMapEntry* _tmp111_;
	gconstpointer _tmp112_;
	gconstpointer _tmp113_;
	SynapseResultSet* _tmp114_;
	SynapseMatch* _tmp115_;
	SynapseResultSet* _tmp116_;
	SynapseMatch* _tmp117_;
	GeeIterator* _entry_it;
	SynapseResultSet* _tmp118_;
	GeeSet* _tmp119_;
	GeeSet* _tmp120_;
	GeeSet* _tmp121_;
	GeeIterator* _tmp122_;
	GeeIterator* _tmp123_;
	GeeIterator* _tmp124_;
	GeeMapEntry* entry;
	GeeIterator* _tmp125_;
	gpointer _tmp126_;
	SynapseZeitgeistPluginZeitgeistUriMatch* mo;
	GeeMapEntry* _tmp127_;
	gconstpointer _tmp128_;
	gconstpointer _tmp129_;
	SynapseMatch* _tmp130_;
	gboolean _tmp131_;
	gboolean _tmp132_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp133_;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp136_;
	const gchar* _tmp137_;
	const gchar* _tmp138_;
	glong len;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp139_;
	const gchar* _tmp140_;
	const gchar* _tmp141_;
	gint _tmp142_;
	gint _tmp143_;
	gfloat mult;
	gint adjusted_relevancy;
	GeeMapEntry* _tmp144_;
	gconstpointer _tmp145_;
	gconstpointer _tmp146_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp147_;
	const gchar* _tmp148_;
	const gchar* _tmp149_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp150_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp151_;
	GeeMapEntry* _tmp152_;
	gconstpointer _tmp153_;
	gconstpointer _tmp154_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistPluginProcessRecentResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistPlugin* self;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* results;
	gboolean local_only;
	gboolean places_search;
	GeeSet* uris;
	GeeHashSet* _tmp0_;
	guint events_size;
	guint event_index;
	ZeitgeistResultSet* _event_it;
	ZeitgeistResultSet* _tmp1_;
	ZeitgeistEvent* event;
	ZeitgeistResultSet* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	guint _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistSubject* subject;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	const gchar* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* uri;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeSet* _tmp19_;
	const gchar* _tmp20_;
	gboolean is_application;
	const gchar* _tmp21_;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GeeSet* _tmp22_;
	const gchar* _tmp23_;
	GFile* f;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	GFile* _tmp30_;
	GFileInfo* fi;
	GFile* _tmp31_;
	const gchar* _tmp32_;
	GFileInfo* _tmp33_;
	GFileInfo* _tmp34_;
	GIcon* _tmp35_;
	gchar* _tmp36_;
	GFileInfo* _tmp37_;
	GFileInfo* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GFileInfo* _tmp41_;
	gboolean _tmp42_;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp43_;
	SynapseDesktopFileService* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	SynapseDesktopFileInfo* _tmp48_;
	SynapseDesktopFileInfo* _tmp49_;
	gboolean _tmp50_;
	const gchar* mimetype;
	ZeitgeistSubject* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GIcon* _tmp58_;
	GIcon* _tmp59_;
	gchar* _tmp60_;
	SynapseQueryFlags _tmp61_;
	SynapseQueryFlags _tmp62_;
	SynapseQueryFlags query_type;
	SynapseMatch* match_obj;
	ZeitgeistEvent* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	SynapseMatch* _tmp66_;
	SynapseMatch* _tmp67_;
	ZeitgeistEvent* _tmp68_;
	gint relevancy;
	SynapseMatch* _tmp69_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	SynapseZeitgeistPlugin* self;
	gpointer _async_data_;
};

struct _SynapseZeitgeistPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block7Data* _data7_;
	gchar* search_query;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean empty_query;
	const gchar* _tmp3_;
	SynapseQuery _tmp4_;
	GTimer* timer;
	GTimer* _tmp5_;
	GPtrArray* templates;
	GPtrArray* _tmp6_;
	GPtrArray* event_templates;
	SynapseQuery _tmp7_;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint i;
	gboolean _tmp12_;
	gint _tmp13_;
	GPtrArray* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GPtrArray* _tmp17_;
	GPtrArray* _tmp18_;
	gconstpointer _tmp19_;
	ZeitgeistEvent* _tmp20_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp21_;
	gulong sig_id;
	gulong _tmp22_;
	ZeitgeistResultSet* rs;
	gboolean only_local;
	SynapseQuery _tmp23_;
	gboolean places_search;
	SynapseQuery _tmp24_;
	ZeitgeistResultType _tmp25_;
	ZeitgeistResultType rt;
	gint64 start_ts;
	GDateTime* _tmp26_;
	GDateTime* _tmp27_;
	gint64 _tmp28_;
	ZeitgeistResultSet* _tmp29_;
	ZeitgeistLog* _tmp30_;
	ZeitgeistTimeRange* _tmp31_;
	ZeitgeistTimeRange* _tmp32_;
	GPtrArray* _tmp33_;
	SynapseQuery _tmp34_;
	ZeitgeistResultSet* _tmp35_;
	ZeitgeistResultSet* _tmp36_;
	ZeitgeistResultSet* _tmp37_;
	ZeitgeistResultSet* _tmp38_;
	SynapseQuery _tmp39_;
	GCancellable* _tmp40_;
	SynapseResultSet* _tmp41_;
	gchar** words;
	const gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	ZeitgeistResultSet* _tmp49_;
	ZeitgeistIndex* _tmp50_;
	const gchar* _tmp51_;
	ZeitgeistTimeRange* _tmp52_;
	ZeitgeistTimeRange* _tmp53_;
	GPtrArray* _tmp54_;
	SynapseQuery _tmp55_;
	ZeitgeistResultSet* _tmp56_;
	ZeitgeistResultSet* _tmp57_;
	ZeitgeistResultSet* _tmp58_;
	SynapseQuery _tmp59_;
	const gchar* _tmp60_;
	ZeitgeistResultSet* _tmp61_;
	SynapseQuery _tmp62_;
	GCancellable* _tmp63_;
	SynapseResultSet* _tmp64_;
	GError* err;
	GError* _tmp65_;
	const gchar* _tmp66_;
	GTimer* _tmp67_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatch {
	SynapseApplicationMatch parent_instance;
	SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatchClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate {
	gchar* _extended_info;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatch {
	SynapseUriMatch parent_instance;
	SynapseZeitgeistPluginZeitgeistUriMatchPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatchClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatchPrivate {
	gchar* _extended_info;
};

struct _SynapseZeitgeistPluginZeitgeistMatchFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistMatchFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseZeitgeistPluginZeitgeistMatchFactory *self);
};

struct _SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory {
	GParamSpec parent_instance;
};

static gint SynapseZeitgeistPlugin_private_offset;
static gpointer synapse_zeitgeist_plugin_parent_class = NULL;
static gchar* synapse_zeitgeist_plugin_interesting_attributes;
static gchar* synapse_zeitgeist_plugin_interesting_attributes = NULL;
static gint SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset;
static gpointer synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class = NULL;
static SynapseExtendedInfoIface * synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_parent_iface = NULL;
static gint SynapseZeitgeistPluginZeitgeistUriMatch_private_offset;
static gpointer synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class = NULL;
static SynapseExtendedInfoIface * synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_parent_iface = NULL;
static gpointer synapse_zeitgeist_plugin_zeitgeist_match_factory_parent_class = NULL;
static SynapseActivatableIface * synapse_zeitgeist_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_register_plugin (void);
static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void);
static gint synapse_zeitgeist_plugin_compute_relevancy (const gchar* uri,
                                                 gint base_relevancy);
static void synapse_zeitgeist_plugin_update_min_max (const gchar* uri,
                                              glong* minimum,
                                              glong* maximum);
static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data);
static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* _data_);
static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static SynapseMatch* synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (ZeitgeistEvent* event,
                                                                                    const gchar* thumbnail_path,
                                                                                    const gchar* icon,
                                                                                    SynapseQueryFlags obj_type);
static GType synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self,
                                                      ZeitgeistResultSet* events,
                                                      GCancellable* cancellable,
                                                      SynapseResultSet* results,
                                                      gboolean local_only,
                                                      gboolean places_search,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self,
                                                             GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* _data_);
static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (SynapseExtendedInfo* match,
                                                                                     ZeitgeistEvent* event);
static void _g_object_unref0_ (gpointer var);
static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base);
static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* q,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda28_ (Block7Data* _data7_);
static void ____lambda28__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void synapse_zeitgeist_plugin_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static GType synapse_zeitgeist_plugin_zeitgeist_application_match_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseZeitgeistPluginZeitgeistApplicationMatch* synapse_zeitgeist_plugin_zeitgeist_application_match_new (ZeitgeistEvent* event,
                                                                                                           const gchar* thumbnail_path,
                                                                                                           const gchar* icon);
static SynapseZeitgeistPluginZeitgeistApplicationMatch* synapse_zeitgeist_plugin_zeitgeist_application_match_construct (GType object_type,
                                                                                                                 ZeitgeistEvent* event,
                                                                                                                 const gchar* thumbnail_path,
                                                                                                                 const gchar* icon);
static void synapse_zeitgeist_plugin_zeitgeist_application_match_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property (GObject * object,
                                                                              guint property_id,
                                                                              GValue * value,
                                                                              GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property (GObject * object,
                                                                              guint property_id,
                                                                              const GValue * value,
                                                                              GParamSpec * pspec);
static SynapseZeitgeistPluginZeitgeistUriMatch* synapse_zeitgeist_plugin_zeitgeist_uri_match_new (ZeitgeistEvent* event,
                                                                                           const gchar* thumbnail_path,
                                                                                           const gchar* icon,
                                                                                           gboolean use_origin);
static SynapseZeitgeistPluginZeitgeistUriMatch* synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (GType object_type,
                                                                                                 ZeitgeistEvent* event,
                                                                                                 const gchar* thumbnail_path,
                                                                                                 const gchar* icon,
                                                                                                 gboolean use_origin);
static void synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (SynapseZeitgeistPluginZeitgeistUriMatch* self,
                                                                   ZeitgeistEvent* event,
                                                                   gboolean use_origin);
static void synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static gpointer synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (gpointer instance);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (gpointer instance);
static GParamSpec* synapse_zeitgeist_plugin_param_spec_zeitgeist_match_factory (const gchar* name,
                                                                         const gchar* nick,
                                                                         const gchar* blurb,
                                                                         GType object_type,
                                                                         GParamFlags flags) G_GNUC_UNUSED ;
static void synapse_zeitgeist_plugin_value_set_zeitgeist_match_factory (GValue* value,
                                                                 gpointer v_object) G_GNUC_UNUSED ;
static void synapse_zeitgeist_plugin_value_take_zeitgeist_match_factory (GValue* value,
                                                                  gpointer v_object) G_GNUC_UNUSED ;
static gpointer synapse_zeitgeist_plugin_value_get_zeitgeist_match_factory (const GValue* value) G_GNUC_UNUSED ;
static GType synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseZeitgeistPluginZeitgeistMatchFactory* synapse_zeitgeist_plugin_zeitgeist_match_factory_new (void);
static SynapseZeitgeistPluginZeitgeistMatchFactory* synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (GType object_type);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize (SynapseZeitgeistPluginZeitgeistMatchFactory * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once (void);
static GObject * synapse_zeitgeist_plugin_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void synapse_zeitgeist_plugin_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_zeitgeist_plugin_get_instance_private (SynapseZeitgeistPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPlugin_private_offset);
}

static void
synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base)
{
	SynapseZeitgeistPlugin * self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistIndex* _tmp1_;
#line 28 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 30 "zeitgeist-plugin.vala"
	_tmp0_ = zeitgeist_log_new ();
#line 30 "zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 30 "zeitgeist-plugin.vala"
	self->priv->zg_log = _tmp0_;
#line 31 "zeitgeist-plugin.vala"
	_tmp1_ = zeitgeist_index_new ();
#line 31 "zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_index);
#line 31 "zeitgeist-plugin.vala"
	self->priv->zg_index = _tmp1_;
#line 744 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseZeitgeistPlugin * self;
#line 34 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 753 "zeitgeist-plugin.c"
}

static void
_synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 193 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_register_plugin ();
#line 761 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp3_;
#line 193 "zeitgeist-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 193 "zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 193 "zeitgeist-plugin.vala"
	_tmp2_ = synapse_dbus_service_get_default ();
#line 193 "zeitgeist-plugin.vala"
	_tmp3_ = _tmp2_;
#line 193 "zeitgeist-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, "Zeitgeist", _ ("Search various items logged by Zeitgeist."), "zeitgeist", _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func, synapse_dbus_service_name_is_activatable (_tmp3_, SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME), _ ("Zeitgeist is not installed"));
#line 193 "zeitgeist-plugin.vala"
	_g_object_unref0 (_tmp3_);
#line 193 "zeitgeist-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 785 "zeitgeist-plugin.c"
}

static gint
synapse_zeitgeist_plugin_compute_relevancy (const gchar* uri,
                                            gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat pop = 0.0F;
	gint result;
#line 216 "zeitgeist-plugin.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 218 "zeitgeist-plugin.vala"
	_tmp0_ = synapse_relevancy_service_get_default ();
#line 218 "zeitgeist-plugin.vala"
	rs = _tmp0_;
#line 219 "zeitgeist-plugin.vala"
	pop = synapse_relevancy_service_get_uri_popularity (rs, uri);
#line 221 "zeitgeist-plugin.vala"
	result = synapse_relevancy_service_compute_relevancy (base_relevancy, pop);
#line 221 "zeitgeist-plugin.vala"
	_g_object_unref0 (rs);
#line 221 "zeitgeist-plugin.vala"
	return result;
#line 810 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_update_min_max (const gchar* uri,
                                         glong* minimum,
                                         glong* maximum)
{
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
#line 224 "zeitgeist-plugin.vala"
	g_return_if_fail (uri != NULL);
#line 227 "zeitgeist-plugin.vala"
	_tmp0_ = strlen (uri);
#line 227 "zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 227 "zeitgeist-plugin.vala"
	len = (glong) _tmp1_;
#line 229 "zeitgeist-plugin.vala"
	if (len > (*maximum)) {
#line 229 "zeitgeist-plugin.vala"
		*maximum = len;
#line 833 "zeitgeist-plugin.c"
	}
#line 230 "zeitgeist-plugin.vala"
	if (len < (*minimum)) {
#line 230 "zeitgeist-plugin.vala"
		*minimum = len;
#line 839 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_results_data_free (gpointer _data)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = _data;
#line 24 "zeitgeist-plugin.vala"
	_g_free0 (_data_->query);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->real_results);
#line 24 "zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginProcessResultsData, _data_);
#line 858 "zeitgeist-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "zeitgeist-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 866 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_process_results (const gchar* query,
                                          ZeitgeistResultSet* events,
                                          GCancellable* cancellable,
                                          SynapseResultSet* real_results,
                                          gboolean local_only,
                                          gboolean places_search,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
	gchar* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	GCancellable* _tmp2_;
	SynapseResultSet* _tmp3_;
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (query != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (events != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (cancellable != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (real_results != NULL);
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessResultsData);
#line 24 "zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 24 "zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_results_data_free);
#line 24 "zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (query);
#line 24 "zeitgeist-plugin.vala"
	_g_free0 (_data_->query);
#line 24 "zeitgeist-plugin.vala"
	_data_->query = _tmp0_;
#line 24 "zeitgeist-plugin.vala"
	_tmp1_ = _g_object_ref0 (events);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "zeitgeist-plugin.vala"
	_data_->events = _tmp1_;
#line 24 "zeitgeist-plugin.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "zeitgeist-plugin.vala"
	_data_->cancellable = _tmp2_;
#line 24 "zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 (real_results);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->real_results);
#line 24 "zeitgeist-plugin.vala"
	_data_->real_results = _tmp3_;
#line 24 "zeitgeist-plugin.vala"
	_data_->local_only = local_only;
#line 24 "zeitgeist-plugin.vala"
	_data_->places_search = places_search;
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_results_co (_data_);
#line 928 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_process_results_finish (GAsyncResult* _res_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "zeitgeist-plugin.vala"
		return;
#line 941 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_results_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
#line 279 "zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 279 "zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 279 "zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 279 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_results_co (_data_);
#line 959 "zeitgeist-plugin.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 982 "zeitgeist-plugin.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 991 "zeitgeist-plugin.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1010 "zeitgeist-plugin.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1014 "zeitgeist-plugin.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1020 "zeitgeist-plugin.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1030 "zeitgeist-plugin.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1038 "zeitgeist-plugin.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1042 "zeitgeist-plugin.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1048 "zeitgeist-plugin.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1058 "zeitgeist-plugin.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1082 "zeitgeist-plugin.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1090 "zeitgeist-plugin.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1096 "zeitgeist-plugin.c"
	}
}

static gboolean
synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* _data_)
{
#line 240 "zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 240 "zeitgeist-plugin.vala"
		case 0:
#line 1107 "zeitgeist-plugin.c"
		goto _state_0;
#line 240 "zeitgeist-plugin.vala"
		case 1:
#line 1111 "zeitgeist-plugin.c"
		goto _state_1;
#line 240 "zeitgeist-plugin.vala"
		case 2:
#line 1115 "zeitgeist-plugin.c"
		goto _state_2;
		default:
#line 240 "zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 1120 "zeitgeist-plugin.c"
	}
	_state_0:
#line 244 "zeitgeist-plugin.vala"
	_data_->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 244 "zeitgeist-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp0_;
#line 246 "zeitgeist-plugin.vala"
	_data_->_tmp1_ = synapse_query_get_matchers_for_query (_data_->query, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 246 "zeitgeist-plugin.vala"
	_data_->matchers = _data_->_tmp1_;
#line 252 "zeitgeist-plugin.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 252 "zeitgeist-plugin.vala"
	_data_->results = _data_->_tmp2_;
#line 253 "zeitgeist-plugin.vala"
	_data_->minimum = G_MAXLONG;
#line 254 "zeitgeist-plugin.vala"
	_data_->maximum = (glong) 0;
#line 1139 "zeitgeist-plugin.c"
	{
#line 256 "zeitgeist-plugin.vala"
		_data_->_tmp3_ = zeitgeist_result_set_iterator (_data_->events);
#line 256 "zeitgeist-plugin.vala"
		_data_->_event_it = _data_->_tmp3_;
#line 256 "zeitgeist-plugin.vala"
		while (TRUE) {
#line 256 "zeitgeist-plugin.vala"
			_data_->_tmp4_ = _data_->_event_it;
#line 256 "zeitgeist-plugin.vala"
			_data_->_tmp5_ = zeitgeist_result_set_next_value (_data_->_tmp4_);
#line 256 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->event);
#line 256 "zeitgeist-plugin.vala"
			_data_->event = _data_->_tmp5_;
#line 256 "zeitgeist-plugin.vala"
			_data_->_tmp6_ = _data_->event;
#line 256 "zeitgeist-plugin.vala"
			if (!(_data_->_tmp6_ != NULL)) {
#line 256 "zeitgeist-plugin.vala"
				break;
#line 1161 "zeitgeist-plugin.c"
			}
#line 258 "zeitgeist-plugin.vala"
			_data_->_tmp7_ = _data_->event;
#line 258 "zeitgeist-plugin.vala"
			if (zeitgeist_event_num_subjects (_data_->_tmp7_) <= 0) {
#line 258 "zeitgeist-plugin.vala"
				continue;
#line 1169 "zeitgeist-plugin.c"
			}
#line 259 "zeitgeist-plugin.vala"
			_data_->_tmp8_ = _data_->event;
#line 259 "zeitgeist-plugin.vala"
			_data_->_tmp9_ = zeitgeist_event_get_subjects (_data_->_tmp8_);
#line 259 "zeitgeist-plugin.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 259 "zeitgeist-plugin.vala"
			_data_->_tmp11_ = g_ptr_array_index (_data_->_tmp10_, (guint) 0);
#line 259 "zeitgeist-plugin.vala"
			_data_->_tmp12_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp11_);
#line 259 "zeitgeist-plugin.vala"
			_data_->subject = _data_->_tmp12_;
#line 260 "zeitgeist-plugin.vala"
			if (_data_->places_search) {
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp14_ = _data_->subject;
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp15_ = zeitgeist_subject_get_origin (_data_->_tmp14_);
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp16_ = _data_->_tmp15_;
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->_tmp16_;
#line 1193 "zeitgeist-plugin.c"
			} else {
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp17_ = _data_->subject;
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp18_ = zeitgeist_subject_get_current_uri (_data_->_tmp17_);
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp19_ = _data_->_tmp18_;
#line 261 "zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->_tmp19_;
#line 1203 "zeitgeist-plugin.c"
			}
#line 260 "zeitgeist-plugin.vala"
			_data_->uri = _data_->_tmp13_;
#line 262 "zeitgeist-plugin.vala"
			_data_->_tmp21_ = _data_->uri;
#line 262 "zeitgeist-plugin.vala"
			if (_data_->_tmp21_ == NULL) {
#line 262 "zeitgeist-plugin.vala"
				_data_->_tmp20_ = TRUE;
#line 1213 "zeitgeist-plugin.c"
			} else {
#line 262 "zeitgeist-plugin.vala"
				_data_->_tmp22_ = _data_->uri;
#line 262 "zeitgeist-plugin.vala"
				_data_->_tmp20_ = g_strcmp0 (_data_->_tmp22_, "") == 0;
#line 1219 "zeitgeist-plugin.c"
			}
#line 262 "zeitgeist-plugin.vala"
			if (_data_->_tmp20_) {
#line 262 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->subject);
#line 262 "zeitgeist-plugin.vala"
				continue;
#line 1227 "zeitgeist-plugin.c"
			}
#line 264 "zeitgeist-plugin.vala"
			_data_->_tmp23_ = _data_->uris;
#line 264 "zeitgeist-plugin.vala"
			_data_->_tmp24_ = _data_->uri;
#line 264 "zeitgeist-plugin.vala"
			if (!gee_collection_contains ((GeeCollection*) _data_->_tmp23_, _data_->_tmp24_)) {
#line 266 "zeitgeist-plugin.vala"
				_data_->_tmp25_ = _data_->uri;
#line 266 "zeitgeist-plugin.vala"
				_data_->is_application = g_str_has_prefix (_data_->_tmp25_, "application://");
#line 267 "zeitgeist-plugin.vala"
				_data_->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 268 "zeitgeist-plugin.vala"
				_data_->thumbnail_path = NULL;
#line 269 "zeitgeist-plugin.vala"
				_data_->icon = NULL;
#line 270 "zeitgeist-plugin.vala"
				_data_->_tmp26_ = _data_->uris;
#line 270 "zeitgeist-plugin.vala"
				_data_->_tmp27_ = _data_->uri;
#line 270 "zeitgeist-plugin.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp26_, _data_->_tmp27_);
#line 271 "zeitgeist-plugin.vala"
				_data_->_tmp28_ = _data_->uri;
#line 271 "zeitgeist-plugin.vala"
				_data_->_tmp29_ = g_file_new_for_uri (_data_->_tmp28_);
#line 271 "zeitgeist-plugin.vala"
				_data_->f = _data_->_tmp29_;
#line 273 "zeitgeist-plugin.vala"
				_data_->_tmp30_ = _data_->f;
#line 273 "zeitgeist-plugin.vala"
				_data_->_tmp31_ = g_file_get_uri_scheme (_data_->_tmp30_);
#line 273 "zeitgeist-plugin.vala"
				_data_->_tmp32_ = _data_->_tmp31_;
#line 273 "zeitgeist-plugin.vala"
				_data_->_tmp33_ = g_strcmp0 (_data_->_tmp32_, "data") == 0;
#line 273 "zeitgeist-plugin.vala"
				_g_free0 (_data_->_tmp32_);
#line 273 "zeitgeist-plugin.vala"
				if (_data_->_tmp33_) {
#line 273 "zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->f);
#line 273 "zeitgeist-plugin.vala"
					_g_free0 (_data_->icon);
#line 273 "zeitgeist-plugin.vala"
					_g_free0 (_data_->thumbnail_path);
#line 273 "zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->subject);
#line 273 "zeitgeist-plugin.vala"
					continue;
#line 1279 "zeitgeist-plugin.c"
				}
#line 274 "zeitgeist-plugin.vala"
				_data_->_tmp34_ = _data_->f;
#line 274 "zeitgeist-plugin.vala"
				if (g_file_is_native (_data_->_tmp34_)) {
#line 1285 "zeitgeist-plugin.c"
					{
#line 279 "zeitgeist-plugin.vala"
						_data_->_tmp35_ = _data_->f;
#line 279 "zeitgeist-plugin.vala"
						_data_->_tmp36_ = synapse_zeitgeist_plugin_interesting_attributes;
#line 279 "zeitgeist-plugin.vala"
						_data_->_state_ = 1;
#line 279 "zeitgeist-plugin.vala"
						g_file_query_info_async (_data_->_tmp35_, _data_->_tmp36_, 0, 0, _data_->cancellable, synapse_zeitgeist_plugin_process_results_ready, _data_);
#line 279 "zeitgeist-plugin.vala"
						return FALSE;
#line 1297 "zeitgeist-plugin.c"
						_state_1:
#line 279 "zeitgeist-plugin.vala"
						_data_->_tmp37_ = g_file_query_info_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
#line 279 "zeitgeist-plugin.vala"
						_data_->fi = _data_->_tmp37_;
#line 279 "zeitgeist-plugin.vala"
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1305 "zeitgeist-plugin.c"
							goto __catch0_g_error;
						}
#line 283 "zeitgeist-plugin.vala"
						_data_->_tmp38_ = _data_->fi;
#line 283 "zeitgeist-plugin.vala"
						_data_->_tmp39_ = g_file_info_get_icon (_data_->_tmp38_);
#line 283 "zeitgeist-plugin.vala"
						_data_->_tmp40_ = g_icon_to_string (_data_->_tmp39_);
#line 283 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 283 "zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp40_;
#line 284 "zeitgeist-plugin.vala"
						_data_->_tmp41_ = _data_->fi;
#line 284 "zeitgeist-plugin.vala"
						if (g_file_info_has_attribute (_data_->_tmp41_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
#line 286 "zeitgeist-plugin.vala"
							_data_->_tmp42_ = _data_->fi;
#line 286 "zeitgeist-plugin.vala"
							_data_->_tmp43_ = g_file_info_get_attribute_byte_string (_data_->_tmp42_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 286 "zeitgeist-plugin.vala"
							_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
#line 286 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 286 "zeitgeist-plugin.vala"
							_data_->thumbnail_path = _data_->_tmp44_;
#line 1332 "zeitgeist-plugin.c"
						}
#line 290 "zeitgeist-plugin.vala"
						_data_->_tmp45_ = _data_->fi;
#line 290 "zeitgeist-plugin.vala"
						if (g_file_info_get_is_hidden (_data_->_tmp45_)) {
#line 292 "zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM;
#line 1340 "zeitgeist-plugin.c"
						}
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->fi);
#line 1344 "zeitgeist-plugin.c"
					}
					goto __finally0;
					__catch0_g_error:
					{
#line 276 "zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 297 "zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 297 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 297 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->results);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matchers);
#line 297 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 297 "zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 297 "zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 297 "zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 297 "zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1379 "zeitgeist-plugin.c"
								}
							}
#line 297 "zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 297 "zeitgeist-plugin.vala"
							return FALSE;
#line 1386 "zeitgeist-plugin.c"
						} else {
#line 298 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 298 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 298 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 298 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 298 "zeitgeist-plugin.vala"
							continue;
#line 1398 "zeitgeist-plugin.c"
						}
					}
					__finally0:
#line 276 "zeitgeist-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 276 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 276 "zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->event);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_event_it);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->results);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->matchers);
#line 276 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->uris);
#line 276 "zeitgeist-plugin.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 276 "zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 276 "zeitgeist-plugin.vala"
						g_object_unref (_data_->_async_result);
#line 276 "zeitgeist-plugin.vala"
						return FALSE;
#line 1430 "zeitgeist-plugin.c"
					}
				} else {
#line 301 "zeitgeist-plugin.vala"
					_data_->_tmp46_ = _data_->uri;
#line 301 "zeitgeist-plugin.vala"
					if (g_str_has_prefix (_data_->_tmp46_, "note://tomboy/")) {
#line 304 "zeitgeist-plugin.vala"
						_data_->_tmp47_ = _data_->uri;
#line 304 "zeitgeist-plugin.vala"
						_data_->_tmp48_ = string_substring (_data_->_tmp47_, (glong) 14, (glong) -1);
#line 304 "zeitgeist-plugin.vala"
						_data_->_tmp49_ = _data_->_tmp48_;
#line 304 "zeitgeist-plugin.vala"
						_data_->_tmp50_ = g_strconcat (_data_->_tmp49_, ".note", NULL);
#line 304 "zeitgeist-plugin.vala"
						_data_->_tmp51_ = _data_->_tmp50_;
#line 304 "zeitgeist-plugin.vala"
						_g_free0 (_data_->_tmp49_);
#line 304 "zeitgeist-plugin.vala"
						_data_->note_filename = _data_->_tmp51_;
#line 305 "zeitgeist-plugin.vala"
						_data_->_tmp52_ = g_get_user_data_dir ();
#line 305 "zeitgeist-plugin.vala"
						_data_->_tmp53_ = _data_->note_filename;
#line 305 "zeitgeist-plugin.vala"
						_data_->_tmp54_ = g_build_filename (_data_->_tmp52_, "tomboy", _data_->_tmp53_, NULL);
#line 305 "zeitgeist-plugin.vala"
						_data_->note_path = _data_->_tmp54_;
#line 307 "zeitgeist-plugin.vala"
						_data_->_tmp55_ = _data_->note_path;
#line 307 "zeitgeist-plugin.vala"
						_data_->_tmp56_ = g_file_new_for_path (_data_->_tmp55_);
#line 307 "zeitgeist-plugin.vala"
						_data_->note_f = _data_->_tmp56_;
#line 308 "zeitgeist-plugin.vala"
						_data_->_tmp57_ = _data_->note_f;
#line 308 "zeitgeist-plugin.vala"
						_data_->_state_ = 2;
#line 308 "zeitgeist-plugin.vala"
						synapse_utils_query_exists_async (_data_->_tmp57_, synapse_zeitgeist_plugin_process_results_ready, _data_);
#line 308 "zeitgeist-plugin.vala"
						return FALSE;
#line 1473 "zeitgeist-plugin.c"
						_state_2:
#line 308 "zeitgeist-plugin.vala"
						_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 310 "zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->note_f);
#line 310 "zeitgeist-plugin.vala"
							_g_free0 (_data_->note_path);
#line 310 "zeitgeist-plugin.vala"
							_g_free0 (_data_->note_filename);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 310 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 310 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->results);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matchers);
#line 310 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 310 "zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 310 "zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 310 "zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 310 "zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1511 "zeitgeist-plugin.c"
								}
							}
#line 310 "zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 310 "zeitgeist-plugin.vala"
							return FALSE;
#line 1518 "zeitgeist-plugin.c"
						} else {
#line 311 "zeitgeist-plugin.vala"
							if (!_data_->exists) {
#line 311 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->note_f);
#line 311 "zeitgeist-plugin.vala"
								_g_free0 (_data_->note_path);
#line 311 "zeitgeist-plugin.vala"
								_g_free0 (_data_->note_filename);
#line 311 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->f);
#line 311 "zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 311 "zeitgeist-plugin.vala"
								_g_free0 (_data_->thumbnail_path);
#line 311 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->subject);
#line 311 "zeitgeist-plugin.vala"
								continue;
#line 1538 "zeitgeist-plugin.c"
							}
						}
#line 313 "zeitgeist-plugin.vala"
						_data_->_tmp58_ = g_content_type_get_icon ("application/x-note");
#line 313 "zeitgeist-plugin.vala"
						_data_->_tmp59_ = _data_->_tmp58_;
#line 313 "zeitgeist-plugin.vala"
						_data_->_tmp60_ = g_icon_to_string (_data_->_tmp59_);
#line 313 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 313 "zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp60_;
#line 313 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_tmp59_);
#line 301 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->note_f);
#line 301 "zeitgeist-plugin.vala"
						_g_free0 (_data_->note_path);
#line 301 "zeitgeist-plugin.vala"
						_g_free0 (_data_->note_filename);
#line 1559 "zeitgeist-plugin.c"
					} else {
#line 315 "zeitgeist-plugin.vala"
						if (_data_->local_only) {
#line 315 "zeitgeist-plugin.vala"
							_data_->_tmp61_ = !_data_->is_application;
#line 1565 "zeitgeist-plugin.c"
						} else {
#line 315 "zeitgeist-plugin.vala"
							_data_->_tmp61_ = FALSE;
#line 1569 "zeitgeist-plugin.c"
						}
#line 315 "zeitgeist-plugin.vala"
						if (_data_->_tmp61_) {
#line 317 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 317 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 317 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 317 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 317 "zeitgeist-plugin.vala"
							continue;
#line 1583 "zeitgeist-plugin.c"
						} else {
#line 319 "zeitgeist-plugin.vala"
							if (_data_->is_application) {
#line 321 "zeitgeist-plugin.vala"
								_data_->_tmp62_ = synapse_desktop_file_service_get_default ();
#line 321 "zeitgeist-plugin.vala"
								_data_->dfs = _data_->_tmp62_;
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp63_ = _data_->dfs;
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp64_ = _data_->uri;
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp65_ = string_substring (_data_->_tmp64_, (glong) 14, (glong) -1);
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp66_ = _data_->_tmp65_;
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp67_ = synapse_desktop_file_service_get_desktop_file_for_id (_data_->_tmp63_, _data_->_tmp66_);
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp68_ = _data_->_tmp67_;
#line 322 "zeitgeist-plugin.vala"
								_data_->_tmp69_ = _data_->_tmp68_ == NULL;
#line 322 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->_tmp68_);
#line 322 "zeitgeist-plugin.vala"
								_g_free0 (_data_->_tmp66_);
#line 322 "zeitgeist-plugin.vala"
								if (_data_->_tmp69_) {
#line 322 "zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->dfs);
#line 322 "zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->f);
#line 322 "zeitgeist-plugin.vala"
									_g_free0 (_data_->icon);
#line 322 "zeitgeist-plugin.vala"
									_g_free0 (_data_->thumbnail_path);
#line 322 "zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->subject);
#line 322 "zeitgeist-plugin.vala"
									continue;
#line 1623 "zeitgeist-plugin.c"
								}
#line 319 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->dfs);
#line 1627 "zeitgeist-plugin.c"
							} else {
#line 326 "zeitgeist-plugin.vala"
								_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 327 "zeitgeist-plugin.vala"
								_data_->_tmp70_ = _data_->subject;
#line 327 "zeitgeist-plugin.vala"
								_data_->_tmp71_ = zeitgeist_subject_get_mimetype (_data_->_tmp70_);
#line 327 "zeitgeist-plugin.vala"
								_data_->_tmp72_ = _data_->_tmp71_;
#line 327 "zeitgeist-plugin.vala"
								_data_->mimetype = _data_->_tmp72_;
#line 328 "zeitgeist-plugin.vala"
								_data_->_tmp74_ = _data_->mimetype;
#line 328 "zeitgeist-plugin.vala"
								if (_data_->_tmp74_ != NULL) {
#line 328 "zeitgeist-plugin.vala"
									_data_->_tmp75_ = _data_->mimetype;
#line 328 "zeitgeist-plugin.vala"
									_data_->_tmp73_ = g_strcmp0 (_data_->_tmp75_, "") != 0;
#line 1647 "zeitgeist-plugin.c"
								} else {
#line 328 "zeitgeist-plugin.vala"
									_data_->_tmp73_ = FALSE;
#line 1651 "zeitgeist-plugin.c"
								}
#line 328 "zeitgeist-plugin.vala"
								if (_data_->_tmp73_) {
#line 330 "zeitgeist-plugin.vala"
									_data_->_tmp76_ = _data_->mimetype;
#line 330 "zeitgeist-plugin.vala"
									_data_->_tmp77_ = g_content_type_get_icon (_data_->_tmp76_);
#line 330 "zeitgeist-plugin.vala"
									_data_->_tmp78_ = _data_->_tmp77_;
#line 330 "zeitgeist-plugin.vala"
									_data_->_tmp79_ = g_icon_to_string (_data_->_tmp78_);
#line 330 "zeitgeist-plugin.vala"
									_g_free0 (_data_->icon);
#line 330 "zeitgeist-plugin.vala"
									_data_->icon = _data_->_tmp79_;
#line 330 "zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->_tmp78_);
#line 1669 "zeitgeist-plugin.c"
								}
#line 333 "zeitgeist-plugin.vala"
								_data_->_tmp80_ = _data_->uri;
#line 333 "zeitgeist-plugin.vala"
								if (g_str_has_prefix (_data_->_tmp80_, "http")) {
#line 335 "zeitgeist-plugin.vala"
									_data_->_tmp81_ = _data_->uri;
#line 335 "zeitgeist-plugin.vala"
									synapse_zeitgeist_plugin_update_min_max (_data_->_tmp81_, &_data_->minimum, &_data_->maximum);
#line 1679 "zeitgeist-plugin.c"
								}
							}
						}
					}
				}
#line 339 "zeitgeist-plugin.vala"
				if (_data_->is_application) {
#line 340 "zeitgeist-plugin.vala"
					_data_->_tmp82_ = SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 1689 "zeitgeist-plugin.c"
				} else {
#line 340 "zeitgeist-plugin.vala"
					if (_data_->places_search) {
#line 341 "zeitgeist-plugin.vala"
						_data_->_tmp83_ = SYNAPSE_QUERY_FLAGS_PLACES;
#line 1695 "zeitgeist-plugin.c"
					} else {
#line 341 "zeitgeist-plugin.vala"
						_data_->_tmp83_ = SYNAPSE_QUERY_FLAGS_FILES;
#line 1699 "zeitgeist-plugin.c"
					}
#line 340 "zeitgeist-plugin.vala"
					_data_->_tmp82_ = _data_->_tmp83_;
#line 1703 "zeitgeist-plugin.c"
				}
#line 339 "zeitgeist-plugin.vala"
				_data_->query_type = _data_->_tmp82_;
#line 343 "zeitgeist-plugin.vala"
				_data_->_tmp84_ = _data_->event;
#line 343 "zeitgeist-plugin.vala"
				_data_->_tmp85_ = _data_->thumbnail_path;
#line 343 "zeitgeist-plugin.vala"
				_data_->_tmp86_ = _data_->icon;
#line 343 "zeitgeist-plugin.vala"
				_data_->_tmp87_ = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (_data_->_tmp84_, _data_->_tmp85_, _data_->_tmp86_, _data_->query_type);
#line 343 "zeitgeist-plugin.vala"
				_data_->match_obj = _data_->_tmp87_;
#line 347 "zeitgeist-plugin.vala"
				_data_->match_found = FALSE;
#line 1719 "zeitgeist-plugin.c"
				{
#line 348 "zeitgeist-plugin.vala"
					_data_->_tmp88_ = _data_->matchers;
#line 348 "zeitgeist-plugin.vala"
					_data_->_matcher_list = _data_->_tmp88_;
#line 348 "zeitgeist-plugin.vala"
					_data_->_tmp89_ = _data_->_matcher_list;
#line 348 "zeitgeist-plugin.vala"
					_data_->_tmp90_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp89_);
#line 348 "zeitgeist-plugin.vala"
					_data_->_tmp91_ = _data_->_tmp90_;
#line 348 "zeitgeist-plugin.vala"
					_data_->_matcher_size = _data_->_tmp91_;
#line 348 "zeitgeist-plugin.vala"
					_data_->_matcher_index = -1;
#line 348 "zeitgeist-plugin.vala"
					while (TRUE) {
#line 348 "zeitgeist-plugin.vala"
						_data_->_matcher_index = _data_->_matcher_index + 1;
#line 348 "zeitgeist-plugin.vala"
						_data_->_tmp92_ = _data_->_matcher_index;
#line 348 "zeitgeist-plugin.vala"
						_data_->_tmp93_ = _data_->_matcher_size;
#line 348 "zeitgeist-plugin.vala"
						if (!(_data_->_tmp92_ < _data_->_tmp93_)) {
#line 348 "zeitgeist-plugin.vala"
							break;
#line 1747 "zeitgeist-plugin.c"
						}
#line 348 "zeitgeist-plugin.vala"
						_data_->_tmp94_ = _data_->_matcher_list;
#line 348 "zeitgeist-plugin.vala"
						_data_->_tmp95_ = gee_list_get (_data_->_tmp94_, _data_->_matcher_index);
#line 348 "zeitgeist-plugin.vala"
						_data_->matcher = (GeeMapEntry*) _data_->_tmp95_;
#line 350 "zeitgeist-plugin.vala"
						_data_->adjusted_title = NULL;
#line 351 "zeitgeist-plugin.vala"
						_data_->_tmp96_ = _data_->uri;
#line 351 "zeitgeist-plugin.vala"
						if (g_str_has_prefix (_data_->_tmp96_, "http")) {
#line 354 "zeitgeist-plugin.vala"
							_data_->_tmp97_ = _data_->match_obj;
#line 354 "zeitgeist-plugin.vala"
							_data_->_tmp98_ = synapse_match_get_title (_data_->_tmp97_);
#line 354 "zeitgeist-plugin.vala"
							_data_->_tmp99_ = _data_->_tmp98_;
#line 354 "zeitgeist-plugin.vala"
							_data_->_tmp100_ = _data_->uri;
#line 354 "zeitgeist-plugin.vala"
							_data_->_tmp101_ = g_strdup_printf ("%s (%s)", _data_->_tmp99_, _data_->_tmp100_);
#line 354 "zeitgeist-plugin.vala"
							_g_free0 (_data_->adjusted_title);
#line 354 "zeitgeist-plugin.vala"
							_data_->adjusted_title = _data_->_tmp101_;
#line 1775 "zeitgeist-plugin.c"
						}
#line 357 "zeitgeist-plugin.vala"
						_data_->_tmp103_ = _data_->adjusted_title;
#line 357 "zeitgeist-plugin.vala"
						_data_->_tmp102_ = _data_->_tmp103_;
#line 357 "zeitgeist-plugin.vala"
						if (_data_->_tmp102_ == NULL) {
#line 357 "zeitgeist-plugin.vala"
							_data_->_tmp104_ = _data_->match_obj;
#line 357 "zeitgeist-plugin.vala"
							_data_->_tmp105_ = synapse_match_get_title (_data_->_tmp104_);
#line 357 "zeitgeist-plugin.vala"
							_data_->_tmp106_ = _data_->_tmp105_;
#line 357 "zeitgeist-plugin.vala"
							_data_->_tmp102_ = _data_->_tmp106_;
#line 1791 "zeitgeist-plugin.c"
						}
#line 357 "zeitgeist-plugin.vala"
						_data_->_tmp107_ = _data_->matcher;
#line 357 "zeitgeist-plugin.vala"
						_data_->_tmp108_ = gee_map_entry_get_key (_data_->_tmp107_);
#line 357 "zeitgeist-plugin.vala"
						_data_->_tmp109_ = _data_->_tmp108_;
#line 357 "zeitgeist-plugin.vala"
						if (g_regex_match ((GRegex*) _data_->_tmp109_, _data_->_tmp102_, 0, NULL)) {
#line 359 "zeitgeist-plugin.vala"
							_data_->_tmp110_ = _data_->uri;
#line 359 "zeitgeist-plugin.vala"
							_data_->_tmp111_ = _data_->matcher;
#line 359 "zeitgeist-plugin.vala"
							_data_->_tmp112_ = gee_map_entry_get_value (_data_->_tmp111_);
#line 359 "zeitgeist-plugin.vala"
							_data_->_tmp113_ = _data_->_tmp112_;
#line 359 "zeitgeist-plugin.vala"
							_data_->relevancy = synapse_zeitgeist_plugin_compute_relevancy (_data_->_tmp110_, ((gint) ((gintptr) _data_->_tmp113_)) - _data_->relevancy_penalty);
#line 360 "zeitgeist-plugin.vala"
							_data_->_tmp114_ = _data_->results;
#line 360 "zeitgeist-plugin.vala"
							_data_->_tmp115_ = _data_->match_obj;
#line 360 "zeitgeist-plugin.vala"
							synapse_result_set_add (_data_->_tmp114_, _data_->_tmp115_, _data_->relevancy);
#line 361 "zeitgeist-plugin.vala"
							_data_->match_found = TRUE;
#line 362 "zeitgeist-plugin.vala"
							_g_free0 (_data_->adjusted_title);
#line 362 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matcher);
#line 362 "zeitgeist-plugin.vala"
							break;
#line 1825 "zeitgeist-plugin.c"
						}
#line 348 "zeitgeist-plugin.vala"
						_g_free0 (_data_->adjusted_title);
#line 348 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->matcher);
#line 1831 "zeitgeist-plugin.c"
					}
				}
#line 365 "zeitgeist-plugin.vala"
				if (!_data_->match_found) {
#line 365 "zeitgeist-plugin.vala"
					_data_->_tmp116_ = _data_->results;
#line 365 "zeitgeist-plugin.vala"
					_data_->_tmp117_ = _data_->match_obj;
#line 365 "zeitgeist-plugin.vala"
					synapse_result_set_add (_data_->_tmp116_, _data_->_tmp117_, (gint) (SYNAPSE_MATCH_SCORE_POOR + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
#line 1842 "zeitgeist-plugin.c"
				}
#line 264 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->match_obj);
#line 264 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 264 "zeitgeist-plugin.vala"
				_g_free0 (_data_->icon);
#line 264 "zeitgeist-plugin.vala"
				_g_free0 (_data_->thumbnail_path);
#line 1852 "zeitgeist-plugin.c"
			}
#line 256 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->subject);
#line 1856 "zeitgeist-plugin.c"
		}
#line 256 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->event);
#line 256 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_event_it);
#line 1862 "zeitgeist-plugin.c"
	}
	{
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp118_ = _data_->results;
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp119_ = synapse_result_set_get_entries (_data_->_tmp118_);
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp120_ = _data_->_tmp119_;
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp121_ = _data_->_tmp120_;
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp122_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp121_);
#line 369 "zeitgeist-plugin.vala"
		_data_->_tmp123_ = _data_->_tmp122_;
#line 369 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_tmp121_);
#line 369 "zeitgeist-plugin.vala"
		_data_->_entry_it = _data_->_tmp123_;
#line 369 "zeitgeist-plugin.vala"
		while (TRUE) {
#line 369 "zeitgeist-plugin.vala"
			_data_->_tmp124_ = _data_->_entry_it;
#line 369 "zeitgeist-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp124_)) {
#line 369 "zeitgeist-plugin.vala"
				break;
#line 1889 "zeitgeist-plugin.c"
			}
#line 369 "zeitgeist-plugin.vala"
			_data_->_tmp125_ = _data_->_entry_it;
#line 369 "zeitgeist-plugin.vala"
			_data_->_tmp126_ = gee_iterator_get (_data_->_tmp125_);
#line 369 "zeitgeist-plugin.vala"
			_data_->entry = (GeeMapEntry*) _data_->_tmp126_;
#line 371 "zeitgeist-plugin.vala"
			_data_->_tmp127_ = _data_->entry;
#line 371 "zeitgeist-plugin.vala"
			_data_->_tmp128_ = gee_map_entry_get_key (_data_->_tmp127_);
#line 371 "zeitgeist-plugin.vala"
			_data_->_tmp129_ = _data_->_tmp128_;
#line 371 "zeitgeist-plugin.vala"
			_data_->_tmp130_ = (SynapseMatch*) _data_->_tmp129_;
#line 371 "zeitgeist-plugin.vala"
			_data_->mo = SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH (_data_->_tmp130_) ? ((SynapseZeitgeistPluginZeitgeistUriMatch*) _data_->_tmp130_) : NULL;
#line 372 "zeitgeist-plugin.vala"
			_data_->_tmp133_ = _data_->mo;
#line 372 "zeitgeist-plugin.vala"
			_data_->_tmp134_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp133_);
#line 372 "zeitgeist-plugin.vala"
			_data_->_tmp135_ = _data_->_tmp134_;
#line 372 "zeitgeist-plugin.vala"
			if (_data_->_tmp135_ != NULL) {
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp136_ = _data_->mo;
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp137_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp136_);
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp138_ = _data_->_tmp137_;
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp132_ = g_str_has_prefix (_data_->_tmp138_, "http");
#line 1923 "zeitgeist-plugin.c"
			} else {
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp132_ = FALSE;
#line 1927 "zeitgeist-plugin.c"
			}
#line 372 "zeitgeist-plugin.vala"
			if (_data_->_tmp132_) {
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp131_ = _data_->minimum != _data_->maximum;
#line 1933 "zeitgeist-plugin.c"
			} else {
#line 372 "zeitgeist-plugin.vala"
				_data_->_tmp131_ = FALSE;
#line 1937 "zeitgeist-plugin.c"
			}
#line 372 "zeitgeist-plugin.vala"
			if (_data_->_tmp131_) {
#line 374 "zeitgeist-plugin.vala"
				_data_->_tmp139_ = _data_->mo;
#line 374 "zeitgeist-plugin.vala"
				_data_->_tmp140_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp139_);
#line 374 "zeitgeist-plugin.vala"
				_data_->_tmp141_ = _data_->_tmp140_;
#line 374 "zeitgeist-plugin.vala"
				_data_->_tmp142_ = strlen (_data_->_tmp141_);
#line 374 "zeitgeist-plugin.vala"
				_data_->_tmp143_ = _data_->_tmp142_;
#line 374 "zeitgeist-plugin.vala"
				_data_->len = (glong) _data_->_tmp143_;
#line 376 "zeitgeist-plugin.vala"
				_data_->mult = (_data_->len - _data_->minimum) / ((gfloat) (_data_->maximum - _data_->minimum));
#line 377 "zeitgeist-plugin.vala"
				_data_->_tmp144_ = _data_->entry;
#line 377 "zeitgeist-plugin.vala"
				_data_->_tmp145_ = gee_map_entry_get_value (_data_->_tmp144_);
#line 377 "zeitgeist-plugin.vala"
				_data_->_tmp146_ = _data_->_tmp145_;
#line 377 "zeitgeist-plugin.vala"
				_data_->adjusted_relevancy = ((gint) ((gintptr) _data_->_tmp146_)) - ((gint) (_data_->mult * SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
#line 378 "zeitgeist-plugin.vala"
				_data_->_tmp147_ = _data_->mo;
#line 378 "zeitgeist-plugin.vala"
				_data_->_tmp148_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp147_);
#line 378 "zeitgeist-plugin.vala"
				_data_->_tmp149_ = _data_->_tmp148_;
#line 378 "zeitgeist-plugin.vala"
				if (string_index_of (_data_->_tmp149_, "?", 0) != -1) {
#line 378 "zeitgeist-plugin.vala"
					_data_->adjusted_relevancy -= (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 1973 "zeitgeist-plugin.c"
				}
#line 379 "zeitgeist-plugin.vala"
				_data_->_tmp150_ = _data_->mo;
#line 379 "zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->real_results, (SynapseMatch*) _data_->_tmp150_, _data_->adjusted_relevancy);
#line 1979 "zeitgeist-plugin.c"
			} else {
#line 383 "zeitgeist-plugin.vala"
				_data_->_tmp151_ = _data_->mo;
#line 383 "zeitgeist-plugin.vala"
				_data_->_tmp152_ = _data_->entry;
#line 383 "zeitgeist-plugin.vala"
				_data_->_tmp153_ = gee_map_entry_get_value (_data_->_tmp152_);
#line 383 "zeitgeist-plugin.vala"
				_data_->_tmp154_ = _data_->_tmp153_;
#line 383 "zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->real_results, (SynapseMatch*) _data_->_tmp151_, (gint) ((gintptr) _data_->_tmp154_));
#line 1991 "zeitgeist-plugin.c"
			}
#line 369 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->entry);
#line 1995 "zeitgeist-plugin.c"
		}
#line 369 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_entry_it);
#line 1999 "zeitgeist-plugin.c"
	}
#line 240 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 240 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 240 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 240 "zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 240 "zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 240 "zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 240 "zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2015 "zeitgeist-plugin.c"
		}
	}
#line 240 "zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 240 "zeitgeist-plugin.vala"
	return FALSE;
#line 2022 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = _data;
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginProcessRecentResultsData, _data_);
#line 2040 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self,
                                                 ZeitgeistResultSet* events,
                                                 GCancellable* cancellable,
                                                 SynapseResultSet* results,
                                                 gboolean local_only,
                                                 gboolean places_search,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	SynapseZeitgeistPlugin* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	GCancellable* _tmp2_;
	SynapseResultSet* _tmp3_;
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (self != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (events != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (cancellable != NULL);
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (results != NULL);
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessRecentResultsData);
#line 24 "zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 24 "zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_recent_results_data_free);
#line 24 "zeitgeist-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "zeitgeist-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "zeitgeist-plugin.vala"
	_tmp1_ = _g_object_ref0 (events);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "zeitgeist-plugin.vala"
	_data_->events = _tmp1_;
#line 24 "zeitgeist-plugin.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "zeitgeist-plugin.vala"
	_data_->cancellable = _tmp2_;
#line 24 "zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 (results);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 24 "zeitgeist-plugin.vala"
	_data_->results = _tmp3_;
#line 24 "zeitgeist-plugin.vala"
	_data_->local_only = local_only;
#line 24 "zeitgeist-plugin.vala"
	_data_->places_search = places_search;
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
#line 2100 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self,
                                                        GAsyncResult* _res_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "zeitgeist-plugin.vala"
		return;
#line 2114 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
#line 423 "zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 423 "zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 423 "zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 423 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
#line 2132 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* _data_)
{
#line 388 "zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 388 "zeitgeist-plugin.vala"
		case 0:
#line 2142 "zeitgeist-plugin.c"
		goto _state_0;
#line 388 "zeitgeist-plugin.vala"
		case 1:
#line 2146 "zeitgeist-plugin.c"
		goto _state_1;
		default:
#line 388 "zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 2151 "zeitgeist-plugin.c"
	}
	_state_0:
#line 394 "zeitgeist-plugin.vala"
	_data_->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 394 "zeitgeist-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp0_;
#line 396 "zeitgeist-plugin.vala"
	_data_->events_size = zeitgeist_result_set_size (_data_->events);
#line 397 "zeitgeist-plugin.vala"
	_data_->event_index = (guint) 0;
#line 2162 "zeitgeist-plugin.c"
	{
#line 399 "zeitgeist-plugin.vala"
		_data_->_tmp1_ = zeitgeist_result_set_iterator (_data_->events);
#line 399 "zeitgeist-plugin.vala"
		_data_->_event_it = _data_->_tmp1_;
#line 399 "zeitgeist-plugin.vala"
		while (TRUE) {
#line 399 "zeitgeist-plugin.vala"
			_data_->_tmp2_ = _data_->_event_it;
#line 399 "zeitgeist-plugin.vala"
			_data_->_tmp3_ = zeitgeist_result_set_next_value (_data_->_tmp2_);
#line 399 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->event);
#line 399 "zeitgeist-plugin.vala"
			_data_->event = _data_->_tmp3_;
#line 399 "zeitgeist-plugin.vala"
			_data_->_tmp4_ = _data_->event;
#line 399 "zeitgeist-plugin.vala"
			if (!(_data_->_tmp4_ != NULL)) {
#line 399 "zeitgeist-plugin.vala"
				break;
#line 2184 "zeitgeist-plugin.c"
			}
#line 401 "zeitgeist-plugin.vala"
			_data_->_tmp5_ = _data_->event_index;
#line 401 "zeitgeist-plugin.vala"
			_data_->event_index = _data_->_tmp5_ + 1;
#line 402 "zeitgeist-plugin.vala"
			_data_->_tmp6_ = _data_->event;
#line 402 "zeitgeist-plugin.vala"
			if (zeitgeist_event_num_subjects (_data_->_tmp6_) <= 0) {
#line 402 "zeitgeist-plugin.vala"
				continue;
#line 2196 "zeitgeist-plugin.c"
			}
#line 403 "zeitgeist-plugin.vala"
			_data_->_tmp7_ = _data_->event;
#line 403 "zeitgeist-plugin.vala"
			_data_->_tmp8_ = zeitgeist_event_get_subject (_data_->_tmp7_, 0);
#line 403 "zeitgeist-plugin.vala"
			_data_->subject = _data_->_tmp8_;
#line 404 "zeitgeist-plugin.vala"
			if (_data_->places_search) {
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp10_ = _data_->subject;
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp11_ = zeitgeist_subject_get_origin (_data_->_tmp10_);
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp12_ = _data_->_tmp11_;
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp9_ = _data_->_tmp12_;
#line 2214 "zeitgeist-plugin.c"
			} else {
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->subject;
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp14_ = zeitgeist_subject_get_current_uri (_data_->_tmp13_);
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 405 "zeitgeist-plugin.vala"
				_data_->_tmp9_ = _data_->_tmp15_;
#line 2224 "zeitgeist-plugin.c"
			}
#line 404 "zeitgeist-plugin.vala"
			_data_->uri = _data_->_tmp9_;
#line 406 "zeitgeist-plugin.vala"
			_data_->_tmp17_ = _data_->uri;
#line 406 "zeitgeist-plugin.vala"
			if (_data_->_tmp17_ == NULL) {
#line 406 "zeitgeist-plugin.vala"
				_data_->_tmp16_ = TRUE;
#line 2234 "zeitgeist-plugin.c"
			} else {
#line 406 "zeitgeist-plugin.vala"
				_data_->_tmp18_ = _data_->uri;
#line 406 "zeitgeist-plugin.vala"
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp18_, "") == 0;
#line 2240 "zeitgeist-plugin.c"
			}
#line 406 "zeitgeist-plugin.vala"
			if (_data_->_tmp16_) {
#line 406 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->subject);
#line 406 "zeitgeist-plugin.vala"
				continue;
#line 2248 "zeitgeist-plugin.c"
			}
#line 408 "zeitgeist-plugin.vala"
			_data_->_tmp19_ = _data_->uris;
#line 408 "zeitgeist-plugin.vala"
			_data_->_tmp20_ = _data_->uri;
#line 408 "zeitgeist-plugin.vala"
			if (!gee_collection_contains ((GeeCollection*) _data_->_tmp19_, _data_->_tmp20_)) {
#line 410 "zeitgeist-plugin.vala"
				_data_->_tmp21_ = _data_->uri;
#line 410 "zeitgeist-plugin.vala"
				_data_->is_application = g_str_has_prefix (_data_->_tmp21_, "application://");
#line 411 "zeitgeist-plugin.vala"
				_data_->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 412 "zeitgeist-plugin.vala"
				_data_->thumbnail_path = NULL;
#line 413 "zeitgeist-plugin.vala"
				_data_->icon = NULL;
#line 414 "zeitgeist-plugin.vala"
				_data_->_tmp22_ = _data_->uris;
#line 414 "zeitgeist-plugin.vala"
				_data_->_tmp23_ = _data_->uri;
#line 414 "zeitgeist-plugin.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp22_, _data_->_tmp23_);
#line 415 "zeitgeist-plugin.vala"
				_data_->_tmp24_ = _data_->uri;
#line 415 "zeitgeist-plugin.vala"
				_data_->_tmp25_ = g_file_new_for_uri (_data_->_tmp24_);
#line 415 "zeitgeist-plugin.vala"
				_data_->f = _data_->_tmp25_;
#line 417 "zeitgeist-plugin.vala"
				_data_->_tmp26_ = _data_->f;
#line 417 "zeitgeist-plugin.vala"
				_data_->_tmp27_ = g_file_get_uri_scheme (_data_->_tmp26_);
#line 417 "zeitgeist-plugin.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 417 "zeitgeist-plugin.vala"
				_data_->_tmp29_ = g_strcmp0 (_data_->_tmp28_, "data") == 0;
#line 417 "zeitgeist-plugin.vala"
				_g_free0 (_data_->_tmp28_);
#line 417 "zeitgeist-plugin.vala"
				if (_data_->_tmp29_) {
#line 417 "zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->f);
#line 417 "zeitgeist-plugin.vala"
					_g_free0 (_data_->icon);
#line 417 "zeitgeist-plugin.vala"
					_g_free0 (_data_->thumbnail_path);
#line 417 "zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->subject);
#line 417 "zeitgeist-plugin.vala"
					continue;
#line 2300 "zeitgeist-plugin.c"
				}
#line 418 "zeitgeist-plugin.vala"
				_data_->_tmp30_ = _data_->f;
#line 418 "zeitgeist-plugin.vala"
				if (g_file_is_native (_data_->_tmp30_)) {
#line 2306 "zeitgeist-plugin.c"
					{
#line 423 "zeitgeist-plugin.vala"
						_data_->_tmp31_ = _data_->f;
#line 423 "zeitgeist-plugin.vala"
						_data_->_tmp32_ = synapse_zeitgeist_plugin_interesting_attributes;
#line 423 "zeitgeist-plugin.vala"
						_data_->_state_ = 1;
#line 423 "zeitgeist-plugin.vala"
						g_file_query_info_async (_data_->_tmp31_, _data_->_tmp32_, 0, 0, _data_->cancellable, synapse_zeitgeist_plugin_process_recent_results_ready, _data_);
#line 423 "zeitgeist-plugin.vala"
						return FALSE;
#line 2318 "zeitgeist-plugin.c"
						_state_1:
#line 423 "zeitgeist-plugin.vala"
						_data_->_tmp33_ = g_file_query_info_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error0_);
#line 423 "zeitgeist-plugin.vala"
						_data_->fi = _data_->_tmp33_;
#line 423 "zeitgeist-plugin.vala"
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2326 "zeitgeist-plugin.c"
							goto __catch0_g_error;
						}
#line 427 "zeitgeist-plugin.vala"
						_data_->_tmp34_ = _data_->fi;
#line 427 "zeitgeist-plugin.vala"
						_data_->_tmp35_ = g_file_info_get_icon (_data_->_tmp34_);
#line 427 "zeitgeist-plugin.vala"
						_data_->_tmp36_ = g_icon_to_string (_data_->_tmp35_);
#line 427 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 427 "zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp36_;
#line 428 "zeitgeist-plugin.vala"
						_data_->_tmp37_ = _data_->fi;
#line 428 "zeitgeist-plugin.vala"
						if (g_file_info_has_attribute (_data_->_tmp37_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
#line 430 "zeitgeist-plugin.vala"
							_data_->_tmp38_ = _data_->fi;
#line 430 "zeitgeist-plugin.vala"
							_data_->_tmp39_ = g_file_info_get_attribute_byte_string (_data_->_tmp38_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 430 "zeitgeist-plugin.vala"
							_data_->_tmp40_ = g_strdup (_data_->_tmp39_);
#line 430 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 430 "zeitgeist-plugin.vala"
							_data_->thumbnail_path = _data_->_tmp40_;
#line 2353 "zeitgeist-plugin.c"
						}
#line 434 "zeitgeist-plugin.vala"
						_data_->_tmp41_ = _data_->fi;
#line 434 "zeitgeist-plugin.vala"
						if (g_file_info_get_is_hidden (_data_->_tmp41_)) {
#line 436 "zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM;
#line 2361 "zeitgeist-plugin.c"
						}
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->fi);
#line 2365 "zeitgeist-plugin.c"
					}
					goto __finally0;
					__catch0_g_error:
					{
#line 420 "zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 441 "zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 441 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 441 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 441 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 441 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 441 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 441 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 441 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 441 "zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 441 "zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 441 "zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 441 "zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2396 "zeitgeist-plugin.c"
								}
							}
#line 441 "zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 441 "zeitgeist-plugin.vala"
							return FALSE;
#line 2403 "zeitgeist-plugin.c"
						} else {
#line 442 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 442 "zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 442 "zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 442 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 442 "zeitgeist-plugin.vala"
							continue;
#line 2415 "zeitgeist-plugin.c"
						}
					}
					__finally0:
#line 420 "zeitgeist-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 420 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 420 "zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->event);
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_event_it);
#line 420 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->uris);
#line 420 "zeitgeist-plugin.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 420 "zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 420 "zeitgeist-plugin.vala"
						g_object_unref (_data_->_async_result);
#line 420 "zeitgeist-plugin.vala"
						return FALSE;
#line 2443 "zeitgeist-plugin.c"
					}
				} else {
#line 445 "zeitgeist-plugin.vala"
					if (_data_->local_only) {
#line 445 "zeitgeist-plugin.vala"
						_data_->_tmp42_ = !_data_->is_application;
#line 2450 "zeitgeist-plugin.c"
					} else {
#line 445 "zeitgeist-plugin.vala"
						_data_->_tmp42_ = FALSE;
#line 2454 "zeitgeist-plugin.c"
					}
#line 445 "zeitgeist-plugin.vala"
					if (_data_->_tmp42_) {
#line 447 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 447 "zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 447 "zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 447 "zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 447 "zeitgeist-plugin.vala"
						continue;
#line 2468 "zeitgeist-plugin.c"
					} else {
#line 449 "zeitgeist-plugin.vala"
						if (_data_->is_application) {
#line 451 "zeitgeist-plugin.vala"
							_data_->_tmp43_ = synapse_desktop_file_service_get_default ();
#line 451 "zeitgeist-plugin.vala"
							_data_->dfs = _data_->_tmp43_;
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp44_ = _data_->dfs;
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp45_ = _data_->uri;
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp46_ = string_substring (_data_->_tmp45_, (glong) 14, (glong) -1);
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp47_ = _data_->_tmp46_;
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp48_ = synapse_desktop_file_service_get_desktop_file_for_id (_data_->_tmp44_, _data_->_tmp47_);
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp49_ = _data_->_tmp48_;
#line 452 "zeitgeist-plugin.vala"
							_data_->_tmp50_ = _data_->_tmp49_ == NULL;
#line 452 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_tmp49_);
#line 452 "zeitgeist-plugin.vala"
							_g_free0 (_data_->_tmp47_);
#line 452 "zeitgeist-plugin.vala"
							if (_data_->_tmp50_) {
#line 452 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->dfs);
#line 452 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->f);
#line 452 "zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 452 "zeitgeist-plugin.vala"
								_g_free0 (_data_->thumbnail_path);
#line 452 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->subject);
#line 452 "zeitgeist-plugin.vala"
								continue;
#line 2508 "zeitgeist-plugin.c"
							}
#line 449 "zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->dfs);
#line 2512 "zeitgeist-plugin.c"
						} else {
#line 456 "zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 457 "zeitgeist-plugin.vala"
							_data_->_tmp51_ = _data_->subject;
#line 457 "zeitgeist-plugin.vala"
							_data_->_tmp52_ = zeitgeist_subject_get_mimetype (_data_->_tmp51_);
#line 457 "zeitgeist-plugin.vala"
							_data_->_tmp53_ = _data_->_tmp52_;
#line 457 "zeitgeist-plugin.vala"
							_data_->mimetype = _data_->_tmp53_;
#line 458 "zeitgeist-plugin.vala"
							_data_->_tmp55_ = _data_->mimetype;
#line 458 "zeitgeist-plugin.vala"
							if (_data_->_tmp55_ != NULL) {
#line 458 "zeitgeist-plugin.vala"
								_data_->_tmp56_ = _data_->mimetype;
#line 458 "zeitgeist-plugin.vala"
								_data_->_tmp54_ = g_strcmp0 (_data_->_tmp56_, "") != 0;
#line 2532 "zeitgeist-plugin.c"
							} else {
#line 458 "zeitgeist-plugin.vala"
								_data_->_tmp54_ = FALSE;
#line 2536 "zeitgeist-plugin.c"
							}
#line 458 "zeitgeist-plugin.vala"
							if (_data_->_tmp54_) {
#line 460 "zeitgeist-plugin.vala"
								_data_->_tmp57_ = _data_->mimetype;
#line 460 "zeitgeist-plugin.vala"
								_data_->_tmp58_ = g_content_type_get_icon (_data_->_tmp57_);
#line 460 "zeitgeist-plugin.vala"
								_data_->_tmp59_ = _data_->_tmp58_;
#line 460 "zeitgeist-plugin.vala"
								_data_->_tmp60_ = g_icon_to_string (_data_->_tmp59_);
#line 460 "zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 460 "zeitgeist-plugin.vala"
								_data_->icon = _data_->_tmp60_;
#line 460 "zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->_tmp59_);
#line 2554 "zeitgeist-plugin.c"
							}
						}
					}
				}
#line 464 "zeitgeist-plugin.vala"
				if (_data_->is_application) {
#line 465 "zeitgeist-plugin.vala"
					_data_->_tmp61_ = SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 2563 "zeitgeist-plugin.c"
				} else {
#line 465 "zeitgeist-plugin.vala"
					if (_data_->places_search) {
#line 466 "zeitgeist-plugin.vala"
						_data_->_tmp62_ = SYNAPSE_QUERY_FLAGS_PLACES;
#line 2569 "zeitgeist-plugin.c"
					} else {
#line 466 "zeitgeist-plugin.vala"
						_data_->_tmp62_ = SYNAPSE_QUERY_FLAGS_FILES;
#line 2573 "zeitgeist-plugin.c"
					}
#line 465 "zeitgeist-plugin.vala"
					_data_->_tmp61_ = _data_->_tmp62_;
#line 2577 "zeitgeist-plugin.c"
				}
#line 464 "zeitgeist-plugin.vala"
				_data_->query_type = _data_->_tmp61_;
#line 467 "zeitgeist-plugin.vala"
				_data_->_tmp63_ = _data_->event;
#line 467 "zeitgeist-plugin.vala"
				_data_->_tmp64_ = _data_->thumbnail_path;
#line 467 "zeitgeist-plugin.vala"
				_data_->_tmp65_ = _data_->icon;
#line 467 "zeitgeist-plugin.vala"
				_data_->_tmp66_ = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (_data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_, _data_->query_type);
#line 467 "zeitgeist-plugin.vala"
				_data_->match_obj = _data_->_tmp66_;
#line 471 "zeitgeist-plugin.vala"
				_data_->_tmp67_ = _data_->match_obj;
#line 471 "zeitgeist-plugin.vala"
				_data_->_tmp68_ = _data_->event;
#line 471 "zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp67_, SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo), _data_->_tmp68_);
#line 473 "zeitgeist-plugin.vala"
				_data_->relevancy = (gint) (((_data_->events_size - _data_->event_index) / ((gfloat) _data_->events_size)) * SYNAPSE_MATCH_SCORE_HIGHEST);
#line 475 "zeitgeist-plugin.vala"
				_data_->_tmp69_ = _data_->match_obj;
#line 475 "zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->results, _data_->_tmp69_, _data_->relevancy);
#line 408 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->match_obj);
#line 408 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 408 "zeitgeist-plugin.vala"
				_g_free0 (_data_->icon);
#line 408 "zeitgeist-plugin.vala"
				_g_free0 (_data_->thumbnail_path);
#line 2611 "zeitgeist-plugin.c"
			}
#line 399 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->subject);
#line 2615 "zeitgeist-plugin.c"
		}
#line 399 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->event);
#line 399 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_event_it);
#line 2621 "zeitgeist-plugin.c"
	}
#line 388 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 388 "zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 388 "zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 388 "zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 388 "zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2633 "zeitgeist-plugin.c"
		}
	}
#line 388 "zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 388 "zeitgeist-plugin.vala"
	return FALSE;
#line 2640 "zeitgeist-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 483 "zeitgeist-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2648 "zeitgeist-plugin.c"
}

GPtrArray*
synapse_zeitgeist_plugin_create_templates (SynapseQueryFlags flags)
{
	GPtrArray* templates = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* manifestation = NULL;
	gchar* _tmp2_;
	ZeitgeistEvent* event = NULL;
	ZeitgeistSubject* subject = NULL;
	SynapseQueryFlags flags_intersect = 0U;
	SynapseQueryFlags _tmp3_ = 0U;
	SynapseQueryFlags almost_all = 0U;
	GPtrArray* result;
#line 483 "zeitgeist-plugin.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 483 "zeitgeist-plugin.vala"
	templates = _tmp0_;
#line 484 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) {
#line 485 "zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 2673 "zeitgeist-plugin.c"
	} else {
#line 485 "zeitgeist-plugin.vala"
		_tmp1_ = "!" ZEITGEIST_NFO_REMOTE_DATA_OBJECT;
#line 2677 "zeitgeist-plugin.c"
	}
#line 484 "zeitgeist-plugin.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 484 "zeitgeist-plugin.vala"
	manifestation = _tmp2_;
#line 490 "zeitgeist-plugin.vala"
	flags_intersect = flags & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
#line 493 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 494 "zeitgeist-plugin.vala"
		_tmp3_ = SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
#line 2689 "zeitgeist-plugin.c"
	} else {
#line 495 "zeitgeist-plugin.vala"
		_tmp3_ = SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT ^ SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 2693 "zeitgeist-plugin.c"
	}
#line 493 "zeitgeist-plugin.vala"
	almost_all = _tmp3_;
#line 496 "zeitgeist-plugin.vala"
	if (flags_intersect == almost_all) {
#line 2699 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp4_;
		ZeitgeistSubject* _tmp5_;
		const gchar* _tmp6_;
		ZeitgeistEvent* _tmp7_;
		ZeitgeistEvent* _tmp8_;
		ZeitgeistSubject* _tmp9_;
		ZeitgeistSubject* _tmp10_;
		ZeitgeistSubject* _tmp11_;
		ZeitgeistEvent* _tmp12_;
		ZeitgeistSubject* _tmp13_;
		ZeitgeistSubject* _tmp14_;
		ZeitgeistSubject* _tmp15_;
		ZeitgeistEvent* _tmp16_;
		ZeitgeistSubject* _tmp17_;
		GPtrArray* _tmp18_;
		ZeitgeistEvent* _tmp19_;
		ZeitgeistEvent* _tmp20_;
#line 498 "zeitgeist-plugin.vala"
		_tmp4_ = zeitgeist_subject_new ();
#line 498 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 498 "zeitgeist-plugin.vala"
		subject = _tmp4_;
#line 499 "zeitgeist-plugin.vala"
		_tmp5_ = subject;
#line 499 "zeitgeist-plugin.vala"
		_tmp6_ = manifestation;
#line 499 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp5_, _tmp6_);
#line 500 "zeitgeist-plugin.vala"
		_tmp7_ = zeitgeist_event_new ();
#line 500 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 500 "zeitgeist-plugin.vala"
		event = _tmp7_;
#line 501 "zeitgeist-plugin.vala"
		_tmp8_ = event;
#line 501 "zeitgeist-plugin.vala"
		_tmp9_ = subject;
#line 501 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp8_, _tmp9_);
#line 505 "zeitgeist-plugin.vala"
		_tmp10_ = zeitgeist_subject_new ();
#line 505 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 505 "zeitgeist-plugin.vala"
		subject = _tmp10_;
#line 506 "zeitgeist-plugin.vala"
		_tmp11_ = subject;
#line 506 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp11_, "!" ZEITGEIST_NFO_FOLDER);
#line 507 "zeitgeist-plugin.vala"
		_tmp12_ = event;
#line 507 "zeitgeist-plugin.vala"
		_tmp13_ = subject;
#line 507 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp12_, _tmp13_);
#line 509 "zeitgeist-plugin.vala"
		_tmp14_ = zeitgeist_subject_new ();
#line 509 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 509 "zeitgeist-plugin.vala"
		subject = _tmp14_;
#line 510 "zeitgeist-plugin.vala"
		_tmp15_ = subject;
#line 510 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp15_, "!" ZEITGEIST_NFO_SOFTWARE);
#line 511 "zeitgeist-plugin.vala"
		_tmp16_ = event;
#line 511 "zeitgeist-plugin.vala"
		_tmp17_ = subject;
#line 511 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp16_, _tmp17_);
#line 513 "zeitgeist-plugin.vala"
		_tmp18_ = templates;
#line 513 "zeitgeist-plugin.vala"
		_tmp19_ = event;
#line 513 "zeitgeist-plugin.vala"
		_tmp20_ = _g_object_ref0 (_tmp19_);
#line 513 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp18_, _tmp20_);
#line 515 "zeitgeist-plugin.vala"
		result = templates;
#line 515 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 515 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 515 "zeitgeist-plugin.vala"
		_g_free0 (manifestation);
#line 515 "zeitgeist-plugin.vala"
		return result;
#line 2791 "zeitgeist-plugin.c"
	}
#line 518 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 2795 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp21_;
		ZeitgeistSubject* _tmp22_;
		ZeitgeistEvent* _tmp23_;
		ZeitgeistEvent* _tmp24_;
		ZeitgeistSubject* _tmp25_;
		GPtrArray* _tmp26_;
		ZeitgeistEvent* _tmp27_;
		ZeitgeistEvent* _tmp28_;
#line 520 "zeitgeist-plugin.vala"
		_tmp21_ = zeitgeist_subject_new ();
#line 520 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 520 "zeitgeist-plugin.vala"
		subject = _tmp21_;
#line 521 "zeitgeist-plugin.vala"
		_tmp22_ = subject;
#line 521 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp22_, ZEITGEIST_NFO_SOFTWARE);
#line 522 "zeitgeist-plugin.vala"
		_tmp23_ = zeitgeist_event_new ();
#line 522 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 522 "zeitgeist-plugin.vala"
		event = _tmp23_;
#line 523 "zeitgeist-plugin.vala"
		_tmp24_ = event;
#line 523 "zeitgeist-plugin.vala"
		_tmp25_ = subject;
#line 523 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp24_, _tmp25_);
#line 525 "zeitgeist-plugin.vala"
		_tmp26_ = templates;
#line 525 "zeitgeist-plugin.vala"
		_tmp27_ = event;
#line 525 "zeitgeist-plugin.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 525 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp26_, _tmp28_);
#line 2834 "zeitgeist-plugin.c"
	}
#line 528 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_AUDIO) == SYNAPSE_QUERY_FLAGS_AUDIO) {
#line 2838 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp29_;
		ZeitgeistSubject* _tmp30_;
		ZeitgeistSubject* _tmp31_;
		const gchar* _tmp32_;
		ZeitgeistEvent* _tmp33_;
		ZeitgeistEvent* _tmp34_;
		ZeitgeistSubject* _tmp35_;
		GPtrArray* _tmp36_;
		ZeitgeistEvent* _tmp37_;
		ZeitgeistEvent* _tmp38_;
#line 530 "zeitgeist-plugin.vala"
		_tmp29_ = zeitgeist_subject_new ();
#line 530 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 530 "zeitgeist-plugin.vala"
		subject = _tmp29_;
#line 531 "zeitgeist-plugin.vala"
		_tmp30_ = subject;
#line 531 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp30_, ZEITGEIST_NFO_AUDIO);
#line 532 "zeitgeist-plugin.vala"
		_tmp31_ = subject;
#line 532 "zeitgeist-plugin.vala"
		_tmp32_ = manifestation;
#line 532 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp31_, _tmp32_);
#line 533 "zeitgeist-plugin.vala"
		_tmp33_ = zeitgeist_event_new ();
#line 533 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 533 "zeitgeist-plugin.vala"
		event = _tmp33_;
#line 534 "zeitgeist-plugin.vala"
		_tmp34_ = event;
#line 534 "zeitgeist-plugin.vala"
		_tmp35_ = subject;
#line 534 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp34_, _tmp35_);
#line 536 "zeitgeist-plugin.vala"
		_tmp36_ = templates;
#line 536 "zeitgeist-plugin.vala"
		_tmp37_ = event;
#line 536 "zeitgeist-plugin.vala"
		_tmp38_ = _g_object_ref0 (_tmp37_);
#line 536 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp36_, _tmp38_);
#line 2885 "zeitgeist-plugin.c"
	}
#line 539 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_VIDEO) == SYNAPSE_QUERY_FLAGS_VIDEO) {
#line 2889 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp39_;
		ZeitgeistSubject* _tmp40_;
		ZeitgeistSubject* _tmp41_;
		const gchar* _tmp42_;
		ZeitgeistEvent* _tmp43_;
		ZeitgeistEvent* _tmp44_;
		ZeitgeistSubject* _tmp45_;
		GPtrArray* _tmp46_;
		ZeitgeistEvent* _tmp47_;
		ZeitgeistEvent* _tmp48_;
#line 541 "zeitgeist-plugin.vala"
		_tmp39_ = zeitgeist_subject_new ();
#line 541 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 541 "zeitgeist-plugin.vala"
		subject = _tmp39_;
#line 542 "zeitgeist-plugin.vala"
		_tmp40_ = subject;
#line 542 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp40_, ZEITGEIST_NFO_VIDEO);
#line 543 "zeitgeist-plugin.vala"
		_tmp41_ = subject;
#line 543 "zeitgeist-plugin.vala"
		_tmp42_ = manifestation;
#line 543 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp41_, _tmp42_);
#line 544 "zeitgeist-plugin.vala"
		_tmp43_ = zeitgeist_event_new ();
#line 544 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 544 "zeitgeist-plugin.vala"
		event = _tmp43_;
#line 545 "zeitgeist-plugin.vala"
		_tmp44_ = event;
#line 545 "zeitgeist-plugin.vala"
		_tmp45_ = subject;
#line 545 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp44_, _tmp45_);
#line 547 "zeitgeist-plugin.vala"
		_tmp46_ = templates;
#line 547 "zeitgeist-plugin.vala"
		_tmp47_ = event;
#line 547 "zeitgeist-plugin.vala"
		_tmp48_ = _g_object_ref0 (_tmp47_);
#line 547 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp46_, _tmp48_);
#line 2936 "zeitgeist-plugin.c"
	}
#line 550 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_IMAGES) == SYNAPSE_QUERY_FLAGS_IMAGES) {
#line 2940 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp49_;
		ZeitgeistSubject* _tmp50_;
		ZeitgeistSubject* _tmp51_;
		const gchar* _tmp52_;
		ZeitgeistEvent* _tmp53_;
		ZeitgeistEvent* _tmp54_;
		ZeitgeistSubject* _tmp55_;
		GPtrArray* _tmp56_;
		ZeitgeistEvent* _tmp57_;
		ZeitgeistEvent* _tmp58_;
#line 552 "zeitgeist-plugin.vala"
		_tmp49_ = zeitgeist_subject_new ();
#line 552 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 552 "zeitgeist-plugin.vala"
		subject = _tmp49_;
#line 553 "zeitgeist-plugin.vala"
		_tmp50_ = subject;
#line 553 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp50_, ZEITGEIST_NFO_IMAGE);
#line 554 "zeitgeist-plugin.vala"
		_tmp51_ = subject;
#line 554 "zeitgeist-plugin.vala"
		_tmp52_ = manifestation;
#line 554 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp51_, _tmp52_);
#line 555 "zeitgeist-plugin.vala"
		_tmp53_ = zeitgeist_event_new ();
#line 555 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 555 "zeitgeist-plugin.vala"
		event = _tmp53_;
#line 556 "zeitgeist-plugin.vala"
		_tmp54_ = event;
#line 556 "zeitgeist-plugin.vala"
		_tmp55_ = subject;
#line 556 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp54_, _tmp55_);
#line 558 "zeitgeist-plugin.vala"
		_tmp56_ = templates;
#line 558 "zeitgeist-plugin.vala"
		_tmp57_ = event;
#line 558 "zeitgeist-plugin.vala"
		_tmp58_ = _g_object_ref0 (_tmp57_);
#line 558 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp56_, _tmp58_);
#line 2987 "zeitgeist-plugin.c"
	}
#line 561 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_DOCUMENTS) == SYNAPSE_QUERY_FLAGS_DOCUMENTS) {
#line 2991 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp59_;
		ZeitgeistSubject* _tmp60_;
		ZeitgeistSubject* _tmp61_;
		const gchar* _tmp62_;
		ZeitgeistEvent* _tmp63_;
		ZeitgeistEvent* _tmp64_;
		ZeitgeistSubject* _tmp65_;
		GPtrArray* _tmp66_;
		ZeitgeistEvent* _tmp67_;
		ZeitgeistEvent* _tmp68_;
#line 563 "zeitgeist-plugin.vala"
		_tmp59_ = zeitgeist_subject_new ();
#line 563 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 563 "zeitgeist-plugin.vala"
		subject = _tmp59_;
#line 564 "zeitgeist-plugin.vala"
		_tmp60_ = subject;
#line 564 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp60_, ZEITGEIST_NFO_DOCUMENT);
#line 565 "zeitgeist-plugin.vala"
		_tmp61_ = subject;
#line 565 "zeitgeist-plugin.vala"
		_tmp62_ = manifestation;
#line 565 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp61_, _tmp62_);
#line 566 "zeitgeist-plugin.vala"
		_tmp63_ = zeitgeist_event_new ();
#line 566 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 566 "zeitgeist-plugin.vala"
		event = _tmp63_;
#line 567 "zeitgeist-plugin.vala"
		_tmp64_ = event;
#line 567 "zeitgeist-plugin.vala"
		_tmp65_ = subject;
#line 567 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp64_, _tmp65_);
#line 569 "zeitgeist-plugin.vala"
		_tmp66_ = templates;
#line 569 "zeitgeist-plugin.vala"
		_tmp67_ = event;
#line 569 "zeitgeist-plugin.vala"
		_tmp68_ = _g_object_ref0 (_tmp67_);
#line 569 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp66_, _tmp68_);
#line 3038 "zeitgeist-plugin.c"
	}
#line 572 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
#line 3042 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp69_;
		ZeitgeistSubject* _tmp70_;
		ZeitgeistSubject* _tmp71_;
		const gchar* _tmp72_;
		ZeitgeistEvent* _tmp73_;
		ZeitgeistEvent* _tmp74_;
		ZeitgeistSubject* _tmp75_;
		GPtrArray* _tmp76_;
		ZeitgeistEvent* _tmp77_;
		ZeitgeistEvent* _tmp78_;
#line 574 "zeitgeist-plugin.vala"
		_tmp69_ = zeitgeist_subject_new ();
#line 574 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 574 "zeitgeist-plugin.vala"
		subject = _tmp69_;
#line 575 "zeitgeist-plugin.vala"
		_tmp70_ = subject;
#line 575 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp70_, ZEITGEIST_NFO_WEBSITE);
#line 576 "zeitgeist-plugin.vala"
		_tmp71_ = subject;
#line 576 "zeitgeist-plugin.vala"
		_tmp72_ = manifestation;
#line 576 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp71_, _tmp72_);
#line 577 "zeitgeist-plugin.vala"
		_tmp73_ = zeitgeist_event_new ();
#line 577 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 577 "zeitgeist-plugin.vala"
		event = _tmp73_;
#line 578 "zeitgeist-plugin.vala"
		_tmp74_ = event;
#line 578 "zeitgeist-plugin.vala"
		_tmp75_ = subject;
#line 578 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp74_, _tmp75_);
#line 580 "zeitgeist-plugin.vala"
		_tmp76_ = templates;
#line 580 "zeitgeist-plugin.vala"
		_tmp77_ = event;
#line 580 "zeitgeist-plugin.vala"
		_tmp78_ = _g_object_ref0 (_tmp77_);
#line 580 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp76_, _tmp78_);
#line 3089 "zeitgeist-plugin.c"
	}
#line 583 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) == SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) {
#line 3093 "zeitgeist-plugin.c"
		ZeitgeistEvent* _tmp79_;
		ZeitgeistSubject* _tmp80_;
		ZeitgeistSubject* _tmp81_;
		ZeitgeistEvent* _tmp82_;
		ZeitgeistSubject* _tmp83_;
		ZeitgeistSubject* _tmp84_;
		ZeitgeistSubject* _tmp85_;
		ZeitgeistEvent* _tmp86_;
		ZeitgeistSubject* _tmp87_;
		ZeitgeistSubject* _tmp88_;
		ZeitgeistSubject* _tmp89_;
		ZeitgeistEvent* _tmp90_;
		ZeitgeistSubject* _tmp91_;
		ZeitgeistSubject* _tmp92_;
		ZeitgeistSubject* _tmp93_;
		ZeitgeistEvent* _tmp94_;
		ZeitgeistSubject* _tmp95_;
		ZeitgeistSubject* _tmp96_;
		ZeitgeistSubject* _tmp97_;
		ZeitgeistEvent* _tmp98_;
		ZeitgeistSubject* _tmp99_;
		ZeitgeistSubject* _tmp100_;
		ZeitgeistSubject* _tmp101_;
		ZeitgeistEvent* _tmp102_;
		ZeitgeistSubject* _tmp103_;
		GPtrArray* _tmp109_;
		ZeitgeistEvent* _tmp110_;
		ZeitgeistEvent* _tmp111_;
#line 585 "zeitgeist-plugin.vala"
		_tmp79_ = zeitgeist_event_new ();
#line 585 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 585 "zeitgeist-plugin.vala"
		event = _tmp79_;
#line 586 "zeitgeist-plugin.vala"
		_tmp80_ = zeitgeist_subject_new ();
#line 586 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 586 "zeitgeist-plugin.vala"
		subject = _tmp80_;
#line 587 "zeitgeist-plugin.vala"
		_tmp81_ = subject;
#line 587 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp81_, "!" ZEITGEIST_NFO_SOFTWARE);
#line 588 "zeitgeist-plugin.vala"
		_tmp82_ = event;
#line 588 "zeitgeist-plugin.vala"
		_tmp83_ = subject;
#line 588 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp82_, _tmp83_);
#line 589 "zeitgeist-plugin.vala"
		_tmp84_ = zeitgeist_subject_new ();
#line 589 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 589 "zeitgeist-plugin.vala"
		subject = _tmp84_;
#line 590 "zeitgeist-plugin.vala"
		_tmp85_ = subject;
#line 590 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp85_, "!" ZEITGEIST_NFO_AUDIO);
#line 591 "zeitgeist-plugin.vala"
		_tmp86_ = event;
#line 591 "zeitgeist-plugin.vala"
		_tmp87_ = subject;
#line 591 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp86_, _tmp87_);
#line 592 "zeitgeist-plugin.vala"
		_tmp88_ = zeitgeist_subject_new ();
#line 592 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 592 "zeitgeist-plugin.vala"
		subject = _tmp88_;
#line 593 "zeitgeist-plugin.vala"
		_tmp89_ = subject;
#line 593 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp89_, "!" ZEITGEIST_NFO_VIDEO);
#line 594 "zeitgeist-plugin.vala"
		_tmp90_ = event;
#line 594 "zeitgeist-plugin.vala"
		_tmp91_ = subject;
#line 594 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp90_, _tmp91_);
#line 595 "zeitgeist-plugin.vala"
		_tmp92_ = zeitgeist_subject_new ();
#line 595 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 595 "zeitgeist-plugin.vala"
		subject = _tmp92_;
#line 596 "zeitgeist-plugin.vala"
		_tmp93_ = subject;
#line 596 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp93_, "!" ZEITGEIST_NFO_IMAGE);
#line 597 "zeitgeist-plugin.vala"
		_tmp94_ = event;
#line 597 "zeitgeist-plugin.vala"
		_tmp95_ = subject;
#line 597 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp94_, _tmp95_);
#line 598 "zeitgeist-plugin.vala"
		_tmp96_ = zeitgeist_subject_new ();
#line 598 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 598 "zeitgeist-plugin.vala"
		subject = _tmp96_;
#line 599 "zeitgeist-plugin.vala"
		_tmp97_ = subject;
#line 599 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp97_, "!" ZEITGEIST_NFO_DOCUMENT);
#line 600 "zeitgeist-plugin.vala"
		_tmp98_ = event;
#line 600 "zeitgeist-plugin.vala"
		_tmp99_ = subject;
#line 600 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp98_, _tmp99_);
#line 601 "zeitgeist-plugin.vala"
		_tmp100_ = zeitgeist_subject_new ();
#line 601 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 601 "zeitgeist-plugin.vala"
		subject = _tmp100_;
#line 602 "zeitgeist-plugin.vala"
		_tmp101_ = subject;
#line 602 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp101_, "!" ZEITGEIST_NFO_WEBSITE);
#line 603 "zeitgeist-plugin.vala"
		_tmp102_ = event;
#line 603 "zeitgeist-plugin.vala"
		_tmp103_ = subject;
#line 603 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp102_, _tmp103_);
#line 606 "zeitgeist-plugin.vala"
		if (!((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE)) {
#line 3226 "zeitgeist-plugin.c"
			ZeitgeistSubject* _tmp104_;
			ZeitgeistSubject* _tmp105_;
			const gchar* _tmp106_;
			ZeitgeistEvent* _tmp107_;
			ZeitgeistSubject* _tmp108_;
#line 608 "zeitgeist-plugin.vala"
			_tmp104_ = zeitgeist_subject_new ();
#line 608 "zeitgeist-plugin.vala"
			_g_object_unref0 (subject);
#line 608 "zeitgeist-plugin.vala"
			subject = _tmp104_;
#line 609 "zeitgeist-plugin.vala"
			_tmp105_ = subject;
#line 609 "zeitgeist-plugin.vala"
			_tmp106_ = manifestation;
#line 609 "zeitgeist-plugin.vala"
			zeitgeist_subject_set_manifestation (_tmp105_, _tmp106_);
#line 610 "zeitgeist-plugin.vala"
			_tmp107_ = event;
#line 610 "zeitgeist-plugin.vala"
			_tmp108_ = subject;
#line 610 "zeitgeist-plugin.vala"
			zeitgeist_event_add_subject (_tmp107_, _tmp108_);
#line 3250 "zeitgeist-plugin.c"
		}
#line 613 "zeitgeist-plugin.vala"
		_tmp109_ = templates;
#line 613 "zeitgeist-plugin.vala"
		_tmp110_ = event;
#line 613 "zeitgeist-plugin.vala"
		_tmp111_ = _g_object_ref0 (_tmp110_);
#line 613 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp109_, _tmp111_);
#line 3260 "zeitgeist-plugin.c"
	}
#line 616 "zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_PLACES) == SYNAPSE_QUERY_FLAGS_PLACES) {
#line 3264 "zeitgeist-plugin.c"
		ZeitgeistEvent* _tmp112_;
		ZeitgeistSubject* _tmp113_;
		ZeitgeistSubject* _tmp114_;
		ZeitgeistEvent* _tmp115_;
		ZeitgeistSubject* _tmp116_;
		GPtrArray* _tmp117_;
		ZeitgeistEvent* _tmp118_;
		ZeitgeistEvent* _tmp119_;
#line 618 "zeitgeist-plugin.vala"
		_tmp112_ = zeitgeist_event_new ();
#line 618 "zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 618 "zeitgeist-plugin.vala"
		event = _tmp112_;
#line 619 "zeitgeist-plugin.vala"
		_tmp113_ = zeitgeist_subject_new ();
#line 619 "zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 619 "zeitgeist-plugin.vala"
		subject = _tmp113_;
#line 620 "zeitgeist-plugin.vala"
		_tmp114_ = subject;
#line 620 "zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp114_, "!" ZEITGEIST_NFO_WEBSITE);
#line 621 "zeitgeist-plugin.vala"
		_tmp115_ = event;
#line 621 "zeitgeist-plugin.vala"
		_tmp116_ = subject;
#line 621 "zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp115_, _tmp116_);
#line 623 "zeitgeist-plugin.vala"
		_tmp117_ = templates;
#line 623 "zeitgeist-plugin.vala"
		_tmp118_ = event;
#line 623 "zeitgeist-plugin.vala"
		_tmp119_ = _g_object_ref0 (_tmp118_);
#line 623 "zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp117_, _tmp119_);
#line 3303 "zeitgeist-plugin.c"
	}
#line 626 "zeitgeist-plugin.vala"
	result = templates;
#line 626 "zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 626 "zeitgeist-plugin.vala"
	_g_object_unref0 (event);
#line 626 "zeitgeist-plugin.vala"
	_g_free0 (manifestation);
#line 626 "zeitgeist-plugin.vala"
	return result;
#line 3315 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base)
{
	SynapseZeitgeistPlugin * self;
	gboolean result;
#line 629 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 631 "zeitgeist-plugin.vala"
	result = TRUE;
#line 631 "zeitgeist-plugin.vala"
	return result;
#line 3329 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_search_data_free (gpointer _data)
{
	SynapseZeitgeistPluginSearchData* _data_;
	_data_ = _data;
#line 24 "zeitgeist-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginSearchData, _data_);
#line 3345 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* q,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseZeitgeistPlugin * self;
	SynapseZeitgeistPluginSearchData* _data_;
	SynapseZeitgeistPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "zeitgeist-plugin.vala"
	g_return_if_fail (q != NULL);
#line 24 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginSearchData);
#line 24 "zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_real_search_data_free);
#line 24 "zeitgeist-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "zeitgeist-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "zeitgeist-plugin.vala"
	_tmp1_ = *q;
#line 24 "zeitgeist-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "zeitgeist-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "zeitgeist-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "zeitgeist-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data_);
#line 3386 "zeitgeist-plugin.c"
}

static SynapseResultSet*
synapse_zeitgeist_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseZeitgeistPluginSearchData* _data_;
#line 24 "zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "zeitgeist-plugin.vala"
		return NULL;
#line 3402 "zeitgeist-plugin.c"
	}
#line 24 "zeitgeist-plugin.vala"
	result = _data_->result;
#line 24 "zeitgeist-plugin.vala"
	_data_->result = NULL;
#line 24 "zeitgeist-plugin.vala"
	return result;
#line 3410 "zeitgeist-plugin.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 636 "zeitgeist-plugin.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 636 "zeitgeist-plugin.vala"
	return _data7_;
#line 3420 "zeitgeist-plugin.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 636 "zeitgeist-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 3430 "zeitgeist-plugin.c"
		SynapseZeitgeistPlugin* self;
#line 636 "zeitgeist-plugin.vala"
		self = _data7_->self;
#line 636 "zeitgeist-plugin.vala"
		_g_object_unref0 (self);
#line 636 "zeitgeist-plugin.vala"
		g_slice_free (Block7Data, _data7_);
#line 3438 "zeitgeist-plugin.c"
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 3460 "zeitgeist-plugin.c"
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
#line 5950 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5951 "glib-2.0.vapi"
	result = (gint) self->len;
#line 5951 "glib-2.0.vapi"
	return result;
#line 3473 "zeitgeist-plugin.c"
}

static void
___lambda28_ (Block7Data* _data7_)
{
	SynapseZeitgeistPlugin* self;
#line 660 "zeitgeist-plugin.vala"
	self = _data7_->self;
#line 661 "zeitgeist-plugin.vala"
	if (self->priv->search_in_progress) {
#line 661 "zeitgeist-plugin.vala"
		return;
#line 3486 "zeitgeist-plugin.c"
	}
#line 662 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data7_->_async_data_);
#line 3490 "zeitgeist-plugin.c"
}

static void
____lambda28__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
#line 660 "zeitgeist-plugin.vala"
	___lambda28_ (self);
#line 3500 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SynapseZeitgeistPluginSearchData* _data_;
#line 703 "zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 703 "zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 703 "zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 703 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data_);
#line 3517 "zeitgeist-plugin.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 3531 "zeitgeist-plugin.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 3535 "zeitgeist-plugin.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 3541 "zeitgeist-plugin.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 3546 "zeitgeist-plugin.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 3552 "zeitgeist-plugin.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 3556 "zeitgeist-plugin.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 3560 "zeitgeist-plugin.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 3564 "zeitgeist-plugin.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3568 "zeitgeist-plugin.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 3572 "zeitgeist-plugin.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 3587 "zeitgeist-plugin.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 3596 "zeitgeist-plugin.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 3603 "zeitgeist-plugin.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 3609 "zeitgeist-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 3617 "zeitgeist-plugin.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 3621 "zeitgeist-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 3627 "zeitgeist-plugin.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 3632 "zeitgeist-plugin.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 3638 "zeitgeist-plugin.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 3642 "zeitgeist-plugin.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 3646 "zeitgeist-plugin.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 3652 "zeitgeist-plugin.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 3658 "zeitgeist-plugin.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 3670 "zeitgeist-plugin.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 3674 "zeitgeist-plugin.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 3678 "zeitgeist-plugin.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 3683 "zeitgeist-plugin.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 3691 "zeitgeist-plugin.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 3709 "zeitgeist-plugin.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 3715 "zeitgeist-plugin.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 3719 "zeitgeist-plugin.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 3727 "zeitgeist-plugin.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 3736 "zeitgeist-plugin.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 3745 "zeitgeist-plugin.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 3751 "zeitgeist-plugin.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 3759 "zeitgeist-plugin.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 3771 "zeitgeist-plugin.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 3777 "zeitgeist-plugin.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 3781 "zeitgeist-plugin.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 3789 "zeitgeist-plugin.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 3800 "zeitgeist-plugin.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 3809 "zeitgeist-plugin.c"
	}
}

static gboolean
synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* _data_)
{
#line 636 "zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 636 "zeitgeist-plugin.vala"
		case 0:
#line 3820 "zeitgeist-plugin.c"
		goto _state_0;
#line 636 "zeitgeist-plugin.vala"
		case 1:
#line 3824 "zeitgeist-plugin.c"
		goto _state_1;
#line 636 "zeitgeist-plugin.vala"
		case 2:
#line 3828 "zeitgeist-plugin.c"
		goto _state_2;
#line 636 "zeitgeist-plugin.vala"
		case 3:
#line 3832 "zeitgeist-plugin.c"
		goto _state_3;
#line 636 "zeitgeist-plugin.vala"
		case 4:
#line 3836 "zeitgeist-plugin.c"
		goto _state_4;
#line 636 "zeitgeist-plugin.vala"
		case 5:
#line 3840 "zeitgeist-plugin.c"
		goto _state_5;
		default:
#line 636 "zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 3845 "zeitgeist-plugin.c"
	}
	_state_0:
#line 636 "zeitgeist-plugin.vala"
	_data_->_data7_ = g_slice_new0 (Block7Data);
#line 636 "zeitgeist-plugin.vala"
	_data_->_data7_->_ref_count_ = 1;
#line 636 "zeitgeist-plugin.vala"
	_data_->_data7_->self = g_object_ref (_data_->self);
#line 636 "zeitgeist-plugin.vala"
	_data_->_data7_->_async_data_ = _data_;
#line 638 "zeitgeist-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 638 "zeitgeist-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 638 "zeitgeist-plugin.vala"
	_data_->_tmp2_ = string_strip (_data_->_tmp1_);
#line 638 "zeitgeist-plugin.vala"
	_data_->search_query = _data_->_tmp2_;
#line 639 "zeitgeist-plugin.vala"
	_data_->_tmp3_ = _data_->search_query;
#line 639 "zeitgeist-plugin.vala"
	_data_->empty_query = g_strcmp0 (_data_->_tmp3_, "") == 0;
#line 641 "zeitgeist-plugin.vala"
	if (!_data_->empty_query) {
#line 641 "zeitgeist-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 641 "zeitgeist-plugin.vala"
		_data_->q.query_type = _data_->_tmp4_.query_type & (~SYNAPSE_QUERY_FLAGS_APPLICATIONS);
#line 3874 "zeitgeist-plugin.c"
	}
#line 643 "zeitgeist-plugin.vala"
	_data_->_tmp5_ = g_timer_new ();
#line 643 "zeitgeist-plugin.vala"
	_data_->timer = _data_->_tmp5_;
#line 645 "zeitgeist-plugin.vala"
	_data_->_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 645 "zeitgeist-plugin.vala"
	_data_->templates = _data_->_tmp6_;
#line 646 "zeitgeist-plugin.vala"
	_data_->_tmp7_ = _data_->q;
#line 646 "zeitgeist-plugin.vala"
	_data_->_tmp8_ = synapse_zeitgeist_plugin_create_templates (_data_->_tmp7_.query_type);
#line 646 "zeitgeist-plugin.vala"
	_data_->event_templates = _data_->_tmp8_;
#line 647 "zeitgeist-plugin.vala"
	_data_->_tmp9_ = _data_->event_templates;
#line 647 "zeitgeist-plugin.vala"
	_data_->_tmp10_ = vala_g_ptr_array_get_length (_data_->_tmp9_);
#line 647 "zeitgeist-plugin.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 647 "zeitgeist-plugin.vala"
	if (_data_->_tmp11_ == 0) {
#line 647 "zeitgeist-plugin.vala"
		_data_->result = NULL;
#line 647 "zeitgeist-plugin.vala"
		_g_ptr_array_unref0 (_data_->event_templates);
#line 647 "zeitgeist-plugin.vala"
		_g_ptr_array_unref0 (_data_->templates);
#line 647 "zeitgeist-plugin.vala"
		_g_timer_destroy0 (_data_->timer);
#line 647 "zeitgeist-plugin.vala"
		_g_free0 (_data_->search_query);
#line 647 "zeitgeist-plugin.vala"
		block7_data_unref (_data_->_data7_);
#line 647 "zeitgeist-plugin.vala"
		_data_->_data7_ = NULL;
#line 647 "zeitgeist-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 647 "zeitgeist-plugin.vala"
		if (_data_->_state_ != 0) {
#line 647 "zeitgeist-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 647 "zeitgeist-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3920 "zeitgeist-plugin.c"
			}
		}
#line 647 "zeitgeist-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 647 "zeitgeist-plugin.vala"
		return FALSE;
#line 3927 "zeitgeist-plugin.c"
	}
	{
#line 648 "zeitgeist-plugin.vala"
		_data_->i = 0;
#line 3932 "zeitgeist-plugin.c"
		{
#line 648 "zeitgeist-plugin.vala"
			_data_->_tmp12_ = TRUE;
#line 648 "zeitgeist-plugin.vala"
			while (TRUE) {
#line 648 "zeitgeist-plugin.vala"
				if (!_data_->_tmp12_) {
#line 648 "zeitgeist-plugin.vala"
					_data_->_tmp13_ = _data_->i;
#line 648 "zeitgeist-plugin.vala"
					_data_->i = _data_->_tmp13_ + 1;
#line 3944 "zeitgeist-plugin.c"
				}
#line 648 "zeitgeist-plugin.vala"
				_data_->_tmp12_ = FALSE;
#line 648 "zeitgeist-plugin.vala"
				_data_->_tmp14_ = _data_->event_templates;
#line 648 "zeitgeist-plugin.vala"
				_data_->_tmp15_ = vala_g_ptr_array_get_length (_data_->_tmp14_);
#line 648 "zeitgeist-plugin.vala"
				_data_->_tmp16_ = _data_->_tmp15_;
#line 648 "zeitgeist-plugin.vala"
				if (!(_data_->i < _data_->_tmp16_)) {
#line 648 "zeitgeist-plugin.vala"
					break;
#line 3958 "zeitgeist-plugin.c"
				}
#line 650 "zeitgeist-plugin.vala"
				_data_->_tmp17_ = _data_->templates;
#line 650 "zeitgeist-plugin.vala"
				_data_->_tmp18_ = _data_->event_templates;
#line 650 "zeitgeist-plugin.vala"
				_data_->_tmp19_ = g_ptr_array_index (_data_->_tmp18_, (guint) _data_->i);
#line 650 "zeitgeist-plugin.vala"
				_data_->_tmp20_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp19_);
#line 650 "zeitgeist-plugin.vala"
				g_ptr_array_add (_data_->_tmp17_, _data_->_tmp20_);
#line 3970 "zeitgeist-plugin.c"
			}
		}
	}
#line 653 "zeitgeist-plugin.vala"
	_data_->_tmp21_ = synapse_result_set_new ();
#line 653 "zeitgeist-plugin.vala"
	_data_->_result_ = _data_->_tmp21_;
#line 656 "zeitgeist-plugin.vala"
	while (TRUE) {
#line 656 "zeitgeist-plugin.vala"
		if (!_data_->self->priv->search_in_progress) {
#line 656 "zeitgeist-plugin.vala"
			break;
#line 3984 "zeitgeist-plugin.c"
		}
#line 660 "zeitgeist-plugin.vala"
		_data_->_tmp22_ = g_signal_connect_data ((GObject*) _data_->self, "notify::search-in-progress", (GCallback) ____lambda28__g_object_notify, block7_data_ref (_data_->_data7_), (GClosureNotify) block7_data_unref, 0);
#line 660 "zeitgeist-plugin.vala"
		_data_->sig_id = _data_->_tmp22_;
#line 664 "zeitgeist-plugin.vala"
		_data_->_state_ = 1;
#line 664 "zeitgeist-plugin.vala"
		return FALSE;
#line 3994 "zeitgeist-plugin.c"
		_state_1:
		;
#line 666 "zeitgeist-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->sig_id);
#line 667 "zeitgeist-plugin.vala"
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 667 "zeitgeist-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 667 "zeitgeist-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 667 "zeitgeist-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 667 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 667 "zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->event_templates);
#line 667 "zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->templates);
#line 667 "zeitgeist-plugin.vala"
				_g_timer_destroy0 (_data_->timer);
#line 667 "zeitgeist-plugin.vala"
				_g_free0 (_data_->search_query);
#line 667 "zeitgeist-plugin.vala"
				block7_data_unref (_data_->_data7_);
#line 667 "zeitgeist-plugin.vala"
				_data_->_data7_ = NULL;
#line 667 "zeitgeist-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 667 "zeitgeist-plugin.vala"
				return FALSE;
#line 4025 "zeitgeist-plugin.c"
			} else {
#line 667 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 667 "zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->event_templates);
#line 667 "zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->templates);
#line 667 "zeitgeist-plugin.vala"
				_g_timer_destroy0 (_data_->timer);
#line 667 "zeitgeist-plugin.vala"
				_g_free0 (_data_->search_query);
#line 667 "zeitgeist-plugin.vala"
				block7_data_unref (_data_->_data7_);
#line 667 "zeitgeist-plugin.vala"
				_data_->_data7_ = NULL;
#line 667 "zeitgeist-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 667 "zeitgeist-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 667 "zeitgeist-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 667 "zeitgeist-plugin.vala"
				return FALSE;
#line 4049 "zeitgeist-plugin.c"
			}
		}
	}
	{
#line 673 "zeitgeist-plugin.vala"
		_data_->_tmp23_ = _data_->q;
#line 673 "zeitgeist-plugin.vala"
		_data_->only_local = !((_data_->_tmp23_.query_type & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE);
#line 674 "zeitgeist-plugin.vala"
		_data_->_tmp24_ = _data_->q;
#line 674 "zeitgeist-plugin.vala"
		_data_->places_search = (_data_->_tmp24_.query_type & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT) == SYNAPSE_QUERY_FLAGS_PLACES;
#line 676 "zeitgeist-plugin.vala"
		if (_data_->places_search) {
#line 677 "zeitgeist-plugin.vala"
			_data_->_tmp25_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN;
#line 4066 "zeitgeist-plugin.c"
		} else {
#line 678 "zeitgeist-plugin.vala"
			_data_->_tmp25_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS;
#line 4070 "zeitgeist-plugin.c"
		}
#line 676 "zeitgeist-plugin.vala"
		_data_->rt = _data_->_tmp25_;
#line 680 "zeitgeist-plugin.vala"
		_data_->self->priv->search_in_progress = TRUE;
#line 700 "zeitgeist-plugin.vala"
		if (_data_->empty_query) {
#line 702 "zeitgeist-plugin.vala"
			_data_->_tmp26_ = g_date_time_new_now_local ();
#line 702 "zeitgeist-plugin.vala"
			_data_->_tmp27_ = _data_->_tmp26_;
#line 702 "zeitgeist-plugin.vala"
			_data_->_tmp28_ = (g_date_time_to_unix (_data_->_tmp27_) * 1000) - (ZEITGEIST_TIMESTAMP_WEEK * 24);
#line 702 "zeitgeist-plugin.vala"
			_g_date_time_unref0 (_data_->_tmp27_);
#line 702 "zeitgeist-plugin.vala"
			_data_->start_ts = _data_->_tmp28_;
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp30_ = _data_->self->priv->zg_log;
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp31_ = zeitgeist_time_range_new (_data_->start_ts, G_MAXINT64);
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp32_ = _data_->_tmp31_;
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp33_ = _data_->templates;
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp34_ = _data_->q;
#line 703 "zeitgeist-plugin.vala"
			_data_->_state_ = 2;
#line 703 "zeitgeist-plugin.vala"
			zeitgeist_log_find_events (_data_->_tmp30_, _data_->_tmp32_, _data_->_tmp33_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) _data_->_tmp34_.max_results, _data_->rt, NULL, synapse_zeitgeist_plugin_search_ready, _data_);
#line 703 "zeitgeist-plugin.vala"
			return FALSE;
#line 4104 "zeitgeist-plugin.c"
			_state_2:
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp35_ = zeitgeist_log_find_events_finish (_data_->_tmp30_, _data_->_res_, &_data_->_inner_error0_);
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp36_ = _data_->_tmp35_;
#line 703 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp32_);
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp29_ = _data_->_tmp36_;
#line 703 "zeitgeist-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 703 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->rs);
#line 4118 "zeitgeist-plugin.c"
				goto __catch0_g_error;
			}
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp37_ = _data_->_tmp29_;
#line 703 "zeitgeist-plugin.vala"
			_data_->_tmp29_ = NULL;
#line 703 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->rs);
#line 703 "zeitgeist-plugin.vala"
			_data_->rs = _data_->_tmp37_;
#line 710 "zeitgeist-plugin.vala"
			if (!synapse_query_is_cancelled (&_data_->q)) {
#line 712 "zeitgeist-plugin.vala"
				_data_->_tmp38_ = _data_->rs;
#line 712 "zeitgeist-plugin.vala"
				_data_->_tmp39_ = _data_->q;
#line 712 "zeitgeist-plugin.vala"
				_data_->_tmp40_ = _data_->_tmp39_.cancellable;
#line 712 "zeitgeist-plugin.vala"
				_data_->_tmp41_ = _data_->_result_;
#line 712 "zeitgeist-plugin.vala"
				_data_->_state_ = 3;
#line 712 "zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_recent_results (_data_->self, _data_->_tmp38_, _data_->_tmp40_, _data_->_tmp41_, _data_->only_local, _data_->places_search, synapse_zeitgeist_plugin_search_ready, _data_);
#line 712 "zeitgeist-plugin.vala"
				return FALSE;
#line 4145 "zeitgeist-plugin.c"
				_state_3:
#line 712 "zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_recent_results_finish (_data_->self, _data_->_res_);
#line 4149 "zeitgeist-plugin.c"
			}
#line 700 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp29_);
#line 4153 "zeitgeist-plugin.c"
		} else {
#line 718 "zeitgeist-plugin.vala"
			_data_->_tmp42_ = _data_->search_query;
#line 718 "zeitgeist-plugin.vala"
			_data_->_tmp44_ = _data_->_tmp43_ = g_regex_split_simple ("\\s+|\\.+(?!\\d)", _data_->_tmp42_, 0, 0);
#line 718 "zeitgeist-plugin.vala"
			_data_->words = _data_->_tmp44_;
#line 718 "zeitgeist-plugin.vala"
			_data_->words_length1 = _vala_array_length (_data_->_tmp43_);
#line 718 "zeitgeist-plugin.vala"
			_data_->_words_size_ = _data_->words_length1;
#line 719 "zeitgeist-plugin.vala"
			_data_->_tmp45_ = _data_->words;
#line 719 "zeitgeist-plugin.vala"
			_data_->_tmp45__length1 = _data_->words_length1;
#line 719 "zeitgeist-plugin.vala"
			_data_->_tmp46_ = _vala_g_strjoinv ("* ", _data_->_tmp45_, (gint) _data_->_tmp45__length1);
#line 719 "zeitgeist-plugin.vala"
			_data_->_tmp47_ = _data_->_tmp46_;
#line 719 "zeitgeist-plugin.vala"
			_data_->_tmp48_ = g_strdup_printf ("(%s*)", _data_->_tmp47_);
#line 719 "zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 719 "zeitgeist-plugin.vala"
			_data_->search_query = _data_->_tmp48_;
#line 719 "zeitgeist-plugin.vala"
			_g_free0 (_data_->_tmp47_);
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp50_ = _data_->self->priv->zg_index;
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp51_ = _data_->search_query;
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp52_ = zeitgeist_time_range_new (G_MININT64, G_MAXINT64);
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp53_ = _data_->_tmp52_;
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp54_ = _data_->templates;
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp55_ = _data_->q;
#line 720 "zeitgeist-plugin.vala"
			_data_->_state_ = 4;
#line 720 "zeitgeist-plugin.vala"
			zeitgeist_index_search (_data_->_tmp50_, _data_->_tmp51_, _data_->_tmp53_, _data_->_tmp54_, (guint32) 0, (guint32) _data_->_tmp55_.max_results, _data_->rt, NULL, synapse_zeitgeist_plugin_search_ready, _data_);
#line 720 "zeitgeist-plugin.vala"
			return FALSE;
#line 4199 "zeitgeist-plugin.c"
			_state_4:
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp56_ = zeitgeist_index_search_finish (_data_->_tmp50_, _data_->_res_, &_data_->_inner_error0_);
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp57_ = _data_->_tmp56_;
#line 720 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp53_);
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp49_ = _data_->_tmp57_;
#line 720 "zeitgeist-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 720 "zeitgeist-plugin.vala"
				_data_->words = (_vala_array_free (_data_->words, _data_->words_length1, (GDestroyNotify) g_free), NULL);
#line 720 "zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->rs);
#line 4215 "zeitgeist-plugin.c"
				goto __catch0_g_error;
			}
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp58_ = _data_->_tmp49_;
#line 720 "zeitgeist-plugin.vala"
			_data_->_tmp49_ = NULL;
#line 720 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->rs);
#line 720 "zeitgeist-plugin.vala"
			_data_->rs = _data_->_tmp58_;
#line 728 "zeitgeist-plugin.vala"
			if (!synapse_query_is_cancelled (&_data_->q)) {
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp59_ = _data_->q;
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp60_ = _data_->_tmp59_.query_string;
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp61_ = _data_->rs;
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp62_ = _data_->q;
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp63_ = _data_->_tmp62_.cancellable;
#line 730 "zeitgeist-plugin.vala"
				_data_->_tmp64_ = _data_->_result_;
#line 730 "zeitgeist-plugin.vala"
				_data_->_state_ = 5;
#line 730 "zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_results (_data_->_tmp60_, _data_->_tmp61_, _data_->_tmp63_, _data_->_tmp64_, _data_->only_local, _data_->places_search, synapse_zeitgeist_plugin_search_ready, _data_);
#line 730 "zeitgeist-plugin.vala"
				return FALSE;
#line 4246 "zeitgeist-plugin.c"
				_state_5:
#line 730 "zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_results_finish (_data_->_res_);
#line 4250 "zeitgeist-plugin.c"
			}
#line 700 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp49_);
#line 700 "zeitgeist-plugin.vala"
			_data_->words = (_vala_array_free (_data_->words, _data_->words_length1, (GDestroyNotify) g_free), NULL);
#line 4256 "zeitgeist-plugin.c"
		}
#line 670 "zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->rs);
#line 4260 "zeitgeist-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 670 "zeitgeist-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 670 "zeitgeist-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 737 "zeitgeist-plugin.vala"
		if (!synapse_query_is_cancelled (&_data_->q)) {
#line 740 "zeitgeist-plugin.vala"
			_data_->_tmp65_ = _data_->err;
#line 740 "zeitgeist-plugin.vala"
			_data_->_tmp66_ = _data_->_tmp65_->message;
#line 740 "zeitgeist-plugin.vala"
			g_warning ("zeitgeist-plugin.vala:740: Zeitgeist search failed: %s", _data_->_tmp66_);
#line 4277 "zeitgeist-plugin.c"
		}
#line 670 "zeitgeist-plugin.vala"
		_g_error_free0 (_data_->err);
#line 4281 "zeitgeist-plugin.c"
	}
	__finally0:
#line 670 "zeitgeist-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 670 "zeitgeist-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 670 "zeitgeist-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 670 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 670 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 670 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 670 "zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 670 "zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 670 "zeitgeist-plugin.vala"
			block7_data_unref (_data_->_data7_);
#line 670 "zeitgeist-plugin.vala"
			_data_->_data7_ = NULL;
#line 670 "zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 670 "zeitgeist-plugin.vala"
			return FALSE;
#line 4308 "zeitgeist-plugin.c"
		} else {
#line 670 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 670 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 670 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 670 "zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 670 "zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 670 "zeitgeist-plugin.vala"
			block7_data_unref (_data_->_data7_);
#line 670 "zeitgeist-plugin.vala"
			_data_->_data7_ = NULL;
#line 670 "zeitgeist-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 670 "zeitgeist-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 670 "zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 670 "zeitgeist-plugin.vala"
			return FALSE;
#line 4332 "zeitgeist-plugin.c"
		}
	}
#line 744 "zeitgeist-plugin.vala"
	_data_->self->priv->search_in_progress = FALSE;
#line 746 "zeitgeist-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 746 "zeitgeist-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 746 "zeitgeist-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 746 "zeitgeist-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 746 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 746 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 746 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 746 "zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 746 "zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 746 "zeitgeist-plugin.vala"
			block7_data_unref (_data_->_data7_);
#line 746 "zeitgeist-plugin.vala"
			_data_->_data7_ = NULL;
#line 746 "zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 746 "zeitgeist-plugin.vala"
			return FALSE;
#line 4363 "zeitgeist-plugin.c"
		} else {
#line 746 "zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 746 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 746 "zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 746 "zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 746 "zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 746 "zeitgeist-plugin.vala"
			block7_data_unref (_data_->_data7_);
#line 746 "zeitgeist-plugin.vala"
			_data_->_data7_ = NULL;
#line 746 "zeitgeist-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 746 "zeitgeist-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 746 "zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 746 "zeitgeist-plugin.vala"
			return FALSE;
#line 4387 "zeitgeist-plugin.c"
		}
	}
#line 748 "zeitgeist-plugin.vala"
	_data_->_tmp67_ = _data_->timer;
#line 748 "zeitgeist-plugin.vala"
	g_debug ("zeitgeist-plugin.vala:748: search took %d ms", (gint) (g_timer_elapsed (_data_->_tmp67_, NULL) * 1000));
#line 750 "zeitgeist-plugin.vala"
	_data_->result = _data_->_result_;
#line 750 "zeitgeist-plugin.vala"
	_g_ptr_array_unref0 (_data_->event_templates);
#line 750 "zeitgeist-plugin.vala"
	_g_ptr_array_unref0 (_data_->templates);
#line 750 "zeitgeist-plugin.vala"
	_g_timer_destroy0 (_data_->timer);
#line 750 "zeitgeist-plugin.vala"
	_g_free0 (_data_->search_query);
#line 750 "zeitgeist-plugin.vala"
	block7_data_unref (_data_->_data7_);
#line 750 "zeitgeist-plugin.vala"
	_data_->_data7_ = NULL;
#line 750 "zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 750 "zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 750 "zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 750 "zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4416 "zeitgeist-plugin.c"
		}
	}
#line 750 "zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 750 "zeitgeist-plugin.vala"
	return FALSE;
#line 4423 "zeitgeist-plugin.c"
}

SynapseZeitgeistPlugin*
synapse_zeitgeist_plugin_construct (GType object_type)
{
	SynapseZeitgeistPlugin * self = NULL;
#line 24 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) g_object_new (object_type, NULL);
#line 24 "zeitgeist-plugin.vala"
	return self;
#line 4434 "zeitgeist-plugin.c"
}

SynapseZeitgeistPlugin*
synapse_zeitgeist_plugin_new (void)
{
#line 24 "zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_construct (SYNAPSE_TYPE_ZEITGEIST_PLUGIN);
#line 4442 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseZeitgeistPlugin* self;
#line 26 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 26 "zeitgeist-plugin.vala"
	result = self->priv->_enabled;
#line 26 "zeitgeist-plugin.vala"
	return result;
#line 4456 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseZeitgeistPlugin* self;
	gboolean old_value;
#line 26 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 26 "zeitgeist-plugin.vala"
	old_value = synapse_zeitgeist_plugin_real_get_enabled (base);
#line 26 "zeitgeist-plugin.vala"
	if (old_value != value) {
#line 26 "zeitgeist-plugin.vala"
		self->priv->_enabled = value;
#line 26 "zeitgeist-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY]);
#line 4475 "zeitgeist-plugin.c"
	}
}

SynapseDataSink*
synapse_zeitgeist_plugin_get_data_sink (SynapseZeitgeistPlugin* self)
{
	SynapseDataSink* result;
	SynapseDataSink* _tmp0_;
#line 39 "zeitgeist-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 39 "zeitgeist-plugin.vala"
	result = _tmp0_;
#line 39 "zeitgeist-plugin.vala"
	return result;
#line 4492 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_set_data_sink (SynapseZeitgeistPlugin* self,
                                        SynapseDataSink* value)
{
	SynapseDataSink* old_value;
#line 39 "zeitgeist-plugin.vala"
	g_return_if_fail (self != NULL);
#line 39 "zeitgeist-plugin.vala"
	old_value = synapse_zeitgeist_plugin_get_data_sink (self);
#line 39 "zeitgeist-plugin.vala"
	if (old_value != value) {
#line 39 "zeitgeist-plugin.vala"
		self->priv->_data_sink = value;
#line 39 "zeitgeist-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY]);
#line 4510 "zeitgeist-plugin.c"
	}
}

static inline gpointer
synapse_zeitgeist_plugin_zeitgeist_application_match_get_instance_private (SynapseZeitgeistPluginZeitgeistApplicationMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset);
}

static SynapseZeitgeistPluginZeitgeistApplicationMatch*
synapse_zeitgeist_plugin_zeitgeist_application_match_construct (GType object_type,
                                                                ZeitgeistEvent* event,
                                                                const gchar* thumbnail_path,
                                                                const gchar* icon)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ZeitgeistSubject* subject = NULL;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	ZeitgeistSubject* _tmp5_;
	gchar* uri = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp9_;
	SynapseDesktopFileInfo* dfi = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SynapseDesktopFileInfo* _tmp12_;
	SynapseDesktopFileInfo* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
#line 48 "zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 53 "zeitgeist-plugin.vala"
	_tmp0_ = icon;
#line 53 "zeitgeist-plugin.vala"
	if (_tmp0_ == NULL) {
#line 53 "zeitgeist-plugin.vala"
		_tmp0_ = "";
#line 4563 "zeitgeist-plugin.c"
	}
#line 54 "zeitgeist-plugin.vala"
	_tmp1_ = thumbnail_path;
#line 54 "zeitgeist-plugin.vala"
	if (_tmp1_ == NULL) {
#line 54 "zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 4571 "zeitgeist-plugin.c"
	}
#line 52 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) g_object_new (object_type, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp1_, NULL);
#line 56 "zeitgeist-plugin.vala"
	_tmp2_ = zeitgeist_event_get_subjects (event);
#line 56 "zeitgeist-plugin.vala"
	_tmp3_ = _tmp2_;
#line 56 "zeitgeist-plugin.vala"
	_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
#line 56 "zeitgeist-plugin.vala"
	_tmp5_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp4_);
#line 56 "zeitgeist-plugin.vala"
	subject = _tmp5_;
#line 57 "zeitgeist-plugin.vala"
	_tmp6_ = zeitgeist_subject_get_uri (subject);
#line 57 "zeitgeist-plugin.vala"
	_tmp7_ = _tmp6_;
#line 57 "zeitgeist-plugin.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 57 "zeitgeist-plugin.vala"
	uri = _tmp8_;
#line 59 "zeitgeist-plugin.vala"
	_tmp9_ = synapse_desktop_file_service_get_default ();
#line 59 "zeitgeist-plugin.vala"
	dfs = _tmp9_;
#line 60 "zeitgeist-plugin.vala"
	_tmp10_ = string_substring (uri, (glong) 14, (glong) -1);
#line 60 "zeitgeist-plugin.vala"
	_tmp11_ = _tmp10_;
#line 60 "zeitgeist-plugin.vala"
	_tmp12_ = synapse_desktop_file_service_get_desktop_file_for_id (dfs, _tmp11_);
#line 60 "zeitgeist-plugin.vala"
	_tmp13_ = _tmp12_;
#line 60 "zeitgeist-plugin.vala"
	_g_free0 (_tmp11_);
#line 60 "zeitgeist-plugin.vala"
	dfi = _tmp13_;
#line 62 "zeitgeist-plugin.vala"
	_tmp14_ = synapse_desktop_file_info_get_name (dfi);
#line 62 "zeitgeist-plugin.vala"
	_tmp15_ = _tmp14_;
#line 62 "zeitgeist-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp15_);
#line 63 "zeitgeist-plugin.vala"
	_tmp16_ = synapse_desktop_file_info_get_icon_name (dfi);
#line 63 "zeitgeist-plugin.vala"
	_tmp17_ = _tmp16_;
#line 63 "zeitgeist-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp17_);
#line 64 "zeitgeist-plugin.vala"
	_tmp18_ = synapse_desktop_file_info_get_comment (dfi);
#line 64 "zeitgeist-plugin.vala"
	_tmp19_ = _tmp18_;
#line 64 "zeitgeist-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp19_);
#line 65 "zeitgeist-plugin.vala"
	_tmp20_ = synapse_desktop_file_info_get_needs_terminal (dfi);
#line 65 "zeitgeist-plugin.vala"
	_tmp21_ = _tmp20_;
#line 65 "zeitgeist-plugin.vala"
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp21_);
#line 66 "zeitgeist-plugin.vala"
	_tmp22_ = synapse_desktop_file_info_get_filename (dfi);
#line 66 "zeitgeist-plugin.vala"
	_tmp23_ = _tmp22_;
#line 66 "zeitgeist-plugin.vala"
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, _tmp23_);
#line 48 "zeitgeist-plugin.vala"
	_g_object_unref0 (dfi);
#line 48 "zeitgeist-plugin.vala"
	_g_object_unref0 (dfs);
#line 48 "zeitgeist-plugin.vala"
	_g_free0 (uri);
#line 48 "zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 48 "zeitgeist-plugin.vala"
	return self;
#line 4649 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistApplicationMatch*
synapse_zeitgeist_plugin_zeitgeist_application_match_new (ZeitgeistEvent* event,
                                                          const gchar* thumbnail_path,
                                                          const gchar* icon)
{
#line 48 "zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_application_match_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, event, thumbnail_path, icon);
#line 4659 "zeitgeist-plugin.c"
}

static const gchar*
synapse_zeitgeist_plugin_zeitgeist_application_match_real_get_extended_info (SynapseExtendedInfo* base)
{
	const gchar* result;
	SynapseZeitgeistPluginZeitgeistApplicationMatch* self;
	const gchar* _tmp0_;
#line 46 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) base;
#line 46 "zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_extended_info;
#line 46 "zeitgeist-plugin.vala"
	result = _tmp0_;
#line 46 "zeitgeist-plugin.vala"
	return result;
#line 4676 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_real_set_extended_info (SynapseExtendedInfo* base,
                                                                             const gchar* value)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch* self;
	gchar* _tmp0_;
#line 46 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) base;
#line 46 "zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (value);
#line 46 "zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 46 "zeitgeist-plugin.vala"
	self->priv->_extended_info = _tmp0_;
#line 4693 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_class_init (SynapseZeitgeistPluginZeitgeistApplicationMatchClass * klass,
                                                                 gpointer klass_data)
{
#line 43 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class = g_type_class_peek_parent (klass);
#line 43 "zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset);
#line 43 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property;
#line 43 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property;
#line 43 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_application_match_finalize;
#line 4710 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface,
                                                                                           gpointer iface_data)
{
#line 43 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
#line 43 "zeitgeist-plugin.vala"
	iface->get_extended_info = synapse_zeitgeist_plugin_zeitgeist_application_match_real_get_extended_info;
#line 43 "zeitgeist-plugin.vala"
	iface->set_extended_info = synapse_zeitgeist_plugin_zeitgeist_application_match_real_set_extended_info;
#line 4723 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_instance_init (SynapseZeitgeistPluginZeitgeistApplicationMatch * self,
                                                                    gpointer klass)
{
#line 43 "zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_zeitgeist_application_match_get_instance_private (self);
#line 46 "zeitgeist-plugin.vala"
	self->priv->_extended_info = NULL;
#line 4734 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_finalize (GObject * obj)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
#line 43 "zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 46 "zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 43 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class)->finalize (obj);
#line 4747 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatch), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_instance_init, NULL };
	static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
	synapse_zeitgeist_plugin_zeitgeist_application_match_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseZeitgeistPluginZeitgeistApplicationMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_zeitgeist_application_match_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
	SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_zeitgeist_application_match_type_id, sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate));
	return synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_application_match_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__once)) {
		GType synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
		synapse_zeitgeist_plugin_zeitgeist_application_match_type_id = synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__once, synapse_zeitgeist_plugin_zeitgeist_application_match_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__once;
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property (GObject * object,
                                                                         guint property_id,
                                                                         GValue * value,
                                                                         GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 43 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 4784 "zeitgeist-plugin.c"
		default:
#line 43 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "zeitgeist-plugin.vala"
		break;
#line 4790 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property (GObject * object,
                                                                         guint property_id,
                                                                         const GValue * value,
                                                                         GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 43 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 4804 "zeitgeist-plugin.c"
		default:
#line 43 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "zeitgeist-plugin.vala"
		break;
#line 4810 "zeitgeist-plugin.c"
	}
}

static inline gpointer
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_instance_private (SynapseZeitgeistPluginZeitgeistUriMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPluginZeitgeistUriMatch_private_offset);
}

static SynapseZeitgeistPluginZeitgeistUriMatch*
synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (GType object_type,
                                                        ZeitgeistEvent* event,
                                                        const gchar* thumbnail_path,
                                                        const gchar* icon,
                                                        gboolean use_origin)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 75 "zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 81 "zeitgeist-plugin.vala"
	_tmp0_ = icon;
#line 81 "zeitgeist-plugin.vala"
	if (_tmp0_ == NULL) {
#line 81 "zeitgeist-plugin.vala"
		_tmp0_ = "";
#line 4838 "zeitgeist-plugin.c"
	}
#line 82 "zeitgeist-plugin.vala"
	_tmp1_ = thumbnail_path;
#line 82 "zeitgeist-plugin.vala"
	if (_tmp1_ == NULL) {
#line 82 "zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 4846 "zeitgeist-plugin.c"
	}
#line 80 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) g_object_new (object_type, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp1_, NULL);
#line 84 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (self, event, use_origin);
#line 75 "zeitgeist-plugin.vala"
	return self;
#line 4854 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistUriMatch*
synapse_zeitgeist_plugin_zeitgeist_uri_match_new (ZeitgeistEvent* event,
                                                  const gchar* thumbnail_path,
                                                  const gchar* icon,
                                                  gboolean use_origin)
{
#line 75 "zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, event, thumbnail_path, icon, use_origin);
#line 4865 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (SynapseZeitgeistPluginZeitgeistUriMatch* self,
                                                              ZeitgeistEvent* event,
                                                              gboolean use_origin)
{
	ZeitgeistSubject* subject = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gconstpointer _tmp2_;
	ZeitgeistSubject* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GFile* f = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* text = NULL;
	ZeitgeistSubject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ZeitgeistSubject* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* interpretation = NULL;
	ZeitgeistSubject* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
#line 87 "zeitgeist-plugin.vala"
	g_return_if_fail (self != NULL);
#line 87 "zeitgeist-plugin.vala"
	g_return_if_fail (event != NULL);
#line 90 "zeitgeist-plugin.vala"
	_tmp0_ = zeitgeist_event_get_subjects (event);
#line 90 "zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 90 "zeitgeist-plugin.vala"
	_tmp2_ = g_ptr_array_index (_tmp1_, (guint) 0);
#line 90 "zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp2_);
#line 90 "zeitgeist-plugin.vala"
	subject = _tmp3_;
#line 91 "zeitgeist-plugin.vala"
	if (use_origin) {
#line 4914 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 91 "zeitgeist-plugin.vala"
		_tmp5_ = subject;
#line 91 "zeitgeist-plugin.vala"
		_tmp6_ = zeitgeist_subject_get_origin (_tmp5_);
#line 91 "zeitgeist-plugin.vala"
		_tmp7_ = _tmp6_;
#line 91 "zeitgeist-plugin.vala"
		_tmp4_ = _tmp7_;
#line 4926 "zeitgeist-plugin.c"
	} else {
		ZeitgeistSubject* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 91 "zeitgeist-plugin.vala"
		_tmp8_ = subject;
#line 91 "zeitgeist-plugin.vala"
		_tmp9_ = zeitgeist_subject_get_current_uri (_tmp8_);
#line 91 "zeitgeist-plugin.vala"
		_tmp10_ = _tmp9_;
#line 91 "zeitgeist-plugin.vala"
		_tmp4_ = _tmp10_;
#line 4939 "zeitgeist-plugin.c"
	}
#line 91 "zeitgeist-plugin.vala"
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp4_);
#line 92 "zeitgeist-plugin.vala"
	_tmp11_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 92 "zeitgeist-plugin.vala"
	_tmp12_ = _tmp11_;
#line 92 "zeitgeist-plugin.vala"
	_tmp13_ = g_file_new_for_uri (_tmp12_);
#line 92 "zeitgeist-plugin.vala"
	f = _tmp13_;
#line 93 "zeitgeist-plugin.vala"
	_tmp14_ = f;
#line 93 "zeitgeist-plugin.vala"
	_tmp15_ = g_file_get_parse_name (_tmp14_);
#line 93 "zeitgeist-plugin.vala"
	_tmp16_ = _tmp15_;
#line 93 "zeitgeist-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp16_);
#line 93 "zeitgeist-plugin.vala"
	_g_free0 (_tmp16_);
#line 95 "zeitgeist-plugin.vala"
	_tmp17_ = subject;
#line 95 "zeitgeist-plugin.vala"
	_tmp18_ = zeitgeist_subject_get_text (_tmp17_);
#line 95 "zeitgeist-plugin.vala"
	_tmp19_ = _tmp18_;
#line 95 "zeitgeist-plugin.vala"
	text = _tmp19_;
#line 96 "zeitgeist-plugin.vala"
	if (use_origin) {
#line 4971 "zeitgeist-plugin.c"
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 98 "zeitgeist-plugin.vala"
		_tmp20_ = f;
#line 98 "zeitgeist-plugin.vala"
		_tmp21_ = g_file_get_parse_name (_tmp20_);
#line 98 "zeitgeist-plugin.vala"
		_tmp22_ = _tmp21_;
#line 98 "zeitgeist-plugin.vala"
		_tmp23_ = g_path_get_basename (_tmp22_);
#line 98 "zeitgeist-plugin.vala"
		_tmp24_ = _tmp23_;
#line 98 "zeitgeist-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, _tmp24_);
#line 98 "zeitgeist-plugin.vala"
		_g_free0 (_tmp24_);
#line 98 "zeitgeist-plugin.vala"
		_g_free0 (_tmp22_);
#line 4993 "zeitgeist-plugin.c"
	} else {
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
#line 100 "zeitgeist-plugin.vala"
		_tmp26_ = text;
#line 100 "zeitgeist-plugin.vala"
		if (_tmp26_ == NULL) {
#line 100 "zeitgeist-plugin.vala"
			_tmp25_ = TRUE;
#line 5003 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp27_;
#line 100 "zeitgeist-plugin.vala"
			_tmp27_ = text;
#line 100 "zeitgeist-plugin.vala"
			_tmp25_ = g_strcmp0 (_tmp27_, "") == 0;
#line 5010 "zeitgeist-plugin.c"
		}
#line 100 "zeitgeist-plugin.vala"
		if (_tmp25_) {
#line 5014 "zeitgeist-plugin.c"
			const gchar* _tmp28_;
			const gchar* _tmp29_;
#line 102 "zeitgeist-plugin.vala"
			_tmp28_ = synapse_match_get_description ((SynapseMatch*) self);
#line 102 "zeitgeist-plugin.vala"
			_tmp29_ = _tmp28_;
#line 102 "zeitgeist-plugin.vala"
			synapse_match_set_title ((SynapseMatch*) self, _tmp29_);
#line 5023 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp30_;
#line 106 "zeitgeist-plugin.vala"
			_tmp30_ = text;
#line 106 "zeitgeist-plugin.vala"
			synapse_match_set_title ((SynapseMatch*) self, _tmp30_);
#line 5030 "zeitgeist-plugin.c"
		}
	}
#line 109 "zeitgeist-plugin.vala"
	_tmp31_ = subject;
#line 109 "zeitgeist-plugin.vala"
	_tmp32_ = zeitgeist_subject_get_mimetype (_tmp31_);
#line 109 "zeitgeist-plugin.vala"
	_tmp33_ = _tmp32_;
#line 109 "zeitgeist-plugin.vala"
	synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, _tmp33_);
#line 111 "zeitgeist-plugin.vala"
	_tmp34_ = subject;
#line 111 "zeitgeist-plugin.vala"
	_tmp35_ = zeitgeist_subject_get_interpretation (_tmp34_);
#line 111 "zeitgeist-plugin.vala"
	_tmp36_ = _tmp35_;
#line 111 "zeitgeist-plugin.vala"
	interpretation = _tmp36_;
#line 112 "zeitgeist-plugin.vala"
	_tmp37_ = interpretation;
#line 112 "zeitgeist-plugin.vala"
	if (zeitgeist_symbol_is_a (_tmp37_, ZEITGEIST_NFO_AUDIO)) {
#line 114 "zeitgeist-plugin.vala"
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_AUDIO);
#line 5055 "zeitgeist-plugin.c"
	} else {
		const gchar* _tmp38_;
#line 116 "zeitgeist-plugin.vala"
		_tmp38_ = interpretation;
#line 116 "zeitgeist-plugin.vala"
		if (zeitgeist_symbol_is_a (_tmp38_, ZEITGEIST_NFO_VIDEO)) {
#line 118 "zeitgeist-plugin.vala"
			synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_VIDEO);
#line 5064 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp39_;
#line 120 "zeitgeist-plugin.vala"
			_tmp39_ = interpretation;
#line 120 "zeitgeist-plugin.vala"
			if (zeitgeist_symbol_is_a (_tmp39_, ZEITGEIST_NFO_IMAGE)) {
#line 122 "zeitgeist-plugin.vala"
				synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_IMAGES);
#line 5073 "zeitgeist-plugin.c"
			} else {
				const gchar* _tmp40_;
#line 124 "zeitgeist-plugin.vala"
				_tmp40_ = interpretation;
#line 124 "zeitgeist-plugin.vala"
				if (zeitgeist_symbol_is_a (_tmp40_, ZEITGEIST_NFO_DOCUMENT)) {
#line 126 "zeitgeist-plugin.vala"
					synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_DOCUMENTS);
#line 5082 "zeitgeist-plugin.c"
				} else {
					const gchar* _tmp41_;
#line 128 "zeitgeist-plugin.vala"
					_tmp41_ = interpretation;
#line 128 "zeitgeist-plugin.vala"
					if (zeitgeist_symbol_is_a (_tmp41_, ZEITGEIST_NFO_WEBSITE)) {
#line 130 "zeitgeist-plugin.vala"
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_INTERNET);
#line 5091 "zeitgeist-plugin.c"
					} else {
#line 134 "zeitgeist-plugin.vala"
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
#line 5095 "zeitgeist-plugin.c"
					}
				}
			}
		}
	}
#line 87 "zeitgeist-plugin.vala"
	_g_object_unref0 (f);
#line 87 "zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 5105 "zeitgeist-plugin.c"
}

static const gchar*
synapse_zeitgeist_plugin_zeitgeist_uri_match_real_get_extended_info (SynapseExtendedInfo* base)
{
	const gchar* result;
	SynapseZeitgeistPluginZeitgeistUriMatch* self;
	const gchar* _tmp0_;
#line 73 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) base;
#line 73 "zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_extended_info;
#line 73 "zeitgeist-plugin.vala"
	result = _tmp0_;
#line 73 "zeitgeist-plugin.vala"
	return result;
#line 5122 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_real_set_extended_info (SynapseExtendedInfo* base,
                                                                     const gchar* value)
{
	SynapseZeitgeistPluginZeitgeistUriMatch* self;
	gchar* _tmp0_;
#line 73 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) base;
#line 73 "zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (value);
#line 73 "zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 73 "zeitgeist-plugin.vala"
	self->priv->_extended_info = _tmp0_;
#line 5139 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_class_init (SynapseZeitgeistPluginZeitgeistUriMatchClass * klass,
                                                         gpointer klass_data)
{
#line 70 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class = g_type_class_peek_parent (klass);
#line 70 "zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPluginZeitgeistUriMatch_private_offset);
#line 70 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property;
#line 70 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property;
#line 70 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize;
#line 5156 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface,
                                                                                   gpointer iface_data)
{
#line 70 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
#line 70 "zeitgeist-plugin.vala"
	iface->get_extended_info = synapse_zeitgeist_plugin_zeitgeist_uri_match_real_get_extended_info;
#line 70 "zeitgeist-plugin.vala"
	iface->set_extended_info = synapse_zeitgeist_plugin_zeitgeist_uri_match_real_set_extended_info;
#line 5169 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_instance_init (SynapseZeitgeistPluginZeitgeistUriMatch * self,
                                                            gpointer klass)
{
#line 70 "zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_zeitgeist_uri_match_get_instance_private (self);
#line 73 "zeitgeist-plugin.vala"
	self->priv->_extended_info = NULL;
#line 5180 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize (GObject * obj)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
#line 70 "zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 73 "zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 70 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class)->finalize (obj);
#line 5193 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistUriMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistUriMatch), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_instance_init, NULL };
	static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
	synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseZeitgeistPluginZeitgeistUriMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
	SynapseZeitgeistPluginZeitgeistUriMatch_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id, sizeof (SynapseZeitgeistPluginZeitgeistUriMatchPrivate));
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__once)) {
		GType synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
		synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id = synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__once, synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__once;
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 70 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 5230 "zeitgeist-plugin.c"
		default:
#line 70 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "zeitgeist-plugin.vala"
		break;
#line 5236 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 70 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 5250 "zeitgeist-plugin.c"
		default:
#line 70 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "zeitgeist-plugin.vala"
		break;
#line 5256 "zeitgeist-plugin.c"
	}
}

static SynapseMatch*
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (ZeitgeistEvent* event,
                                                                      const gchar* thumbnail_path,
                                                                      const gchar* icon,
                                                                      SynapseQueryFlags obj_type)
{
	SynapseMatch* result;
#line 141 "zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 146 "zeitgeist-plugin.vala"
	if ((obj_type & SYNAPSE_QUERY_FLAGS_FILES) == SYNAPSE_QUERY_FLAGS_FILES) {
#line 5271 "zeitgeist-plugin.c"
		SynapseZeitgeistPluginZeitgeistUriMatch* _tmp0_;
#line 147 "zeitgeist-plugin.vala"
		_tmp0_ = synapse_zeitgeist_plugin_zeitgeist_uri_match_new (event, thumbnail_path, icon, FALSE);
#line 147 "zeitgeist-plugin.vala"
		result = (SynapseMatch*) _tmp0_;
#line 147 "zeitgeist-plugin.vala"
		return result;
#line 5279 "zeitgeist-plugin.c"
	} else {
#line 148 "zeitgeist-plugin.vala"
		if ((obj_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 5283 "zeitgeist-plugin.c"
			SynapseZeitgeistPluginZeitgeistApplicationMatch* _tmp1_;
#line 149 "zeitgeist-plugin.vala"
			_tmp1_ = synapse_zeitgeist_plugin_zeitgeist_application_match_new (event, thumbnail_path, icon);
#line 149 "zeitgeist-plugin.vala"
			result = (SynapseMatch*) _tmp1_;
#line 149 "zeitgeist-plugin.vala"
			return result;
#line 5291 "zeitgeist-plugin.c"
		} else {
#line 150 "zeitgeist-plugin.vala"
			if ((obj_type & SYNAPSE_QUERY_FLAGS_PLACES) == SYNAPSE_QUERY_FLAGS_PLACES) {
#line 5295 "zeitgeist-plugin.c"
				SynapseZeitgeistPluginZeitgeistUriMatch* _tmp2_;
#line 151 "zeitgeist-plugin.vala"
				_tmp2_ = synapse_zeitgeist_plugin_zeitgeist_uri_match_new (event, thumbnail_path, icon, TRUE);
#line 151 "zeitgeist-plugin.vala"
				result = (SynapseMatch*) _tmp2_;
#line 151 "zeitgeist-plugin.vala"
				return result;
#line 5303 "zeitgeist-plugin.c"
			}
		}
	}
#line 153 "zeitgeist-plugin.vala"
	g_assert_not_reached ();
#line 5309 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (SynapseExtendedInfo* match,
                                                                                ZeitgeistEvent* event)
{
	gint64 now = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 delta = 0LL;
	gint64 _tmp3_;
	gint64 _tmp4_;
#line 156 "zeitgeist-plugin.vala"
	g_return_if_fail (match != NULL);
#line 156 "zeitgeist-plugin.vala"
	g_return_if_fail (event != NULL);
#line 158 "zeitgeist-plugin.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 158 "zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 158 "zeitgeist-plugin.vala"
	_tmp2_ = g_date_time_to_unix (_tmp1_) * 1000;
#line 158 "zeitgeist-plugin.vala"
	_g_date_time_unref0 (_tmp1_);
#line 158 "zeitgeist-plugin.vala"
	now = _tmp2_;
#line 159 "zeitgeist-plugin.vala"
	_tmp3_ = zeitgeist_event_get_timestamp (event);
#line 159 "zeitgeist-plugin.vala"
	_tmp4_ = _tmp3_;
#line 159 "zeitgeist-plugin.vala"
	delta = now - _tmp4_;
#line 160 "zeitgeist-plugin.vala"
	if (delta < (ZEITGEIST_TIMESTAMP_MINUTE * 2)) {
#line 162 "zeitgeist-plugin.vala"
		synapse_extended_info_set_extended_info (match, _ ("few moments ago"));
#line 5347 "zeitgeist-plugin.c"
	} else {
#line 164 "zeitgeist-plugin.vala"
		if (delta < ZEITGEIST_TIMESTAMP_HOUR) {
#line 5351 "zeitgeist-plugin.c"
			gint mins = 0;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 166 "zeitgeist-plugin.vala"
			mins = (gint) (delta / ZEITGEIST_TIMESTAMP_MINUTE);
#line 167 "zeitgeist-plugin.vala"
			_tmp5_ = g_strdup_printf (ngettext ("%d minute ago", "%d minutes ago", (gulong) mins), mins);
#line 167 "zeitgeist-plugin.vala"
			_tmp6_ = _tmp5_;
#line 167 "zeitgeist-plugin.vala"
			synapse_extended_info_set_extended_info (match, _tmp6_);
#line 167 "zeitgeist-plugin.vala"
			_g_free0 (_tmp6_);
#line 5365 "zeitgeist-plugin.c"
		} else {
#line 169 "zeitgeist-plugin.vala"
			if (delta < (ZEITGEIST_TIMESTAMP_DAY * 2)) {
#line 5369 "zeitgeist-plugin.c"
				gint hours = 0;
				gchar* _tmp7_;
				gchar* _tmp8_;
#line 171 "zeitgeist-plugin.vala"
				hours = (gint) (delta / ZEITGEIST_TIMESTAMP_HOUR);
#line 172 "zeitgeist-plugin.vala"
				_tmp7_ = g_strdup_printf (ngettext ("%d hour ago", "%d hours ago", (gulong) hours), hours);
#line 172 "zeitgeist-plugin.vala"
				_tmp8_ = _tmp7_;
#line 172 "zeitgeist-plugin.vala"
				synapse_extended_info_set_extended_info (match, _tmp8_);
#line 172 "zeitgeist-plugin.vala"
				_g_free0 (_tmp8_);
#line 5383 "zeitgeist-plugin.c"
			} else {
#line 174 "zeitgeist-plugin.vala"
				if (delta < (ZEITGEIST_TIMESTAMP_WEEK * 2)) {
#line 5387 "zeitgeist-plugin.c"
					gint days = 0;
					gchar* _tmp9_;
					gchar* _tmp10_;
#line 176 "zeitgeist-plugin.vala"
					days = (gint) (delta / ZEITGEIST_TIMESTAMP_DAY);
#line 177 "zeitgeist-plugin.vala"
					_tmp9_ = g_strdup_printf (ngettext ("%d day ago", "%d days ago", (gulong) days), days);
#line 177 "zeitgeist-plugin.vala"
					_tmp10_ = _tmp9_;
#line 177 "zeitgeist-plugin.vala"
					synapse_extended_info_set_extended_info (match, _tmp10_);
#line 177 "zeitgeist-plugin.vala"
					_g_free0 (_tmp10_);
#line 5401 "zeitgeist-plugin.c"
				} else {
#line 179 "zeitgeist-plugin.vala"
					if (delta < ZEITGEIST_TIMESTAMP_YEAR) {
#line 5405 "zeitgeist-plugin.c"
						gint weeks = 0;
						gchar* _tmp11_;
						gchar* _tmp12_;
#line 181 "zeitgeist-plugin.vala"
						weeks = (gint) (delta / ZEITGEIST_TIMESTAMP_WEEK);
#line 182 "zeitgeist-plugin.vala"
						_tmp11_ = g_strdup_printf (ngettext ("%d week ago", "%d weeks ago", (gulong) weeks), weeks);
#line 182 "zeitgeist-plugin.vala"
						_tmp12_ = _tmp11_;
#line 182 "zeitgeist-plugin.vala"
						synapse_extended_info_set_extended_info (match, _tmp12_);
#line 182 "zeitgeist-plugin.vala"
						_g_free0 (_tmp12_);
#line 5419 "zeitgeist-plugin.c"
					} else {
#line 186 "zeitgeist-plugin.vala"
						synapse_extended_info_set_extended_info (match, _ ("long time ago"));
#line 5423 "zeitgeist-plugin.c"
					}
				}
			}
		}
	}
}

static SynapseZeitgeistPluginZeitgeistMatchFactory*
synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (GType object_type)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory* self = NULL;
#line 139 "zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistMatchFactory*) g_type_create_instance (object_type);
#line 139 "zeitgeist-plugin.vala"
	return self;
#line 5439 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistMatchFactory*
synapse_zeitgeist_plugin_zeitgeist_match_factory_new (void)
{
#line 139 "zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY);
#line 5447 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_init (GValue* value)
{
#line 139 "zeitgeist-plugin.vala"
	value->data[0].v_pointer = NULL;
#line 5455 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_free_value (GValue* value)
{
#line 139 "zeitgeist-plugin.vala"
	if (value->data[0].v_pointer) {
#line 139 "zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (value->data[0].v_pointer);
#line 5465 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_copy_value (const GValue* src_value,
                                                                   GValue* dest_value)
{
#line 139 "zeitgeist-plugin.vala"
	if (src_value->data[0].v_pointer) {
#line 139 "zeitgeist-plugin.vala"
		dest_value->data[0].v_pointer = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (src_value->data[0].v_pointer);
#line 5477 "zeitgeist-plugin.c"
	} else {
#line 139 "zeitgeist-plugin.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5481 "zeitgeist-plugin.c"
	}
}

static gpointer
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_peek_pointer (const GValue* value)
{
#line 139 "zeitgeist-plugin.vala"
	return value->data[0].v_pointer;
#line 5490 "zeitgeist-plugin.c"
}

static gchar*
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_collect_value (GValue* value,
                                                                      guint n_collect_values,
                                                                      GTypeCValue* collect_values,
                                                                      guint collect_flags)
{
#line 139 "zeitgeist-plugin.vala"
	if (collect_values[0].v_pointer) {
#line 5501 "zeitgeist-plugin.c"
		SynapseZeitgeistPluginZeitgeistMatchFactory * object;
		object = collect_values[0].v_pointer;
#line 139 "zeitgeist-plugin.vala"
		if (object->parent_instance.g_class == NULL) {
#line 139 "zeitgeist-plugin.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5508 "zeitgeist-plugin.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 139 "zeitgeist-plugin.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5512 "zeitgeist-plugin.c"
		}
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (object);
#line 5516 "zeitgeist-plugin.c"
	} else {
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5520 "zeitgeist-plugin.c"
	}
#line 139 "zeitgeist-plugin.vala"
	return NULL;
#line 5524 "zeitgeist-plugin.c"
}

static gchar*
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_lcopy_value (const GValue* value,
                                                                    guint n_collect_values,
                                                                    GTypeCValue* collect_values,
                                                                    guint collect_flags)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory ** object_p;
	object_p = collect_values[0].v_pointer;
#line 139 "zeitgeist-plugin.vala"
	if (!object_p) {
#line 139 "zeitgeist-plugin.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5539 "zeitgeist-plugin.c"
	}
#line 139 "zeitgeist-plugin.vala"
	if (!value->data[0].v_pointer) {
#line 139 "zeitgeist-plugin.vala"
		*object_p = NULL;
#line 5545 "zeitgeist-plugin.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 139 "zeitgeist-plugin.vala"
		*object_p = value->data[0].v_pointer;
#line 5549 "zeitgeist-plugin.c"
	} else {
#line 139 "zeitgeist-plugin.vala"
		*object_p = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (value->data[0].v_pointer);
#line 5553 "zeitgeist-plugin.c"
	}
#line 139 "zeitgeist-plugin.vala"
	return NULL;
#line 5557 "zeitgeist-plugin.c"
}

static GParamSpec*
synapse_zeitgeist_plugin_param_spec_zeitgeist_match_factory (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags)
{
	SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory* spec;
#line 139 "zeitgeist-plugin.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY), NULL);
#line 139 "zeitgeist-plugin.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 139 "zeitgeist-plugin.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 139 "zeitgeist-plugin.vala"
	return G_PARAM_SPEC (spec);
#line 5576 "zeitgeist-plugin.c"
}

static gpointer
synapse_zeitgeist_plugin_value_get_zeitgeist_match_factory (const GValue* value)
{
#line 139 "zeitgeist-plugin.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY), NULL);
#line 139 "zeitgeist-plugin.vala"
	return value->data[0].v_pointer;
#line 5586 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_set_zeitgeist_match_factory (GValue* value,
                                                            gpointer v_object)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * old;
#line 139 "zeitgeist-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "zeitgeist-plugin.vala"
	old = value->data[0].v_pointer;
#line 139 "zeitgeist-plugin.vala"
	if (v_object) {
#line 139 "zeitgeist-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "zeitgeist-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 139 "zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (value->data[0].v_pointer);
#line 5608 "zeitgeist-plugin.c"
	} else {
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5612 "zeitgeist-plugin.c"
	}
#line 139 "zeitgeist-plugin.vala"
	if (old) {
#line 139 "zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (old);
#line 5618 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_value_take_zeitgeist_match_factory (GValue* value,
                                                             gpointer v_object)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * old;
#line 139 "zeitgeist-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "zeitgeist-plugin.vala"
	old = value->data[0].v_pointer;
#line 139 "zeitgeist-plugin.vala"
	if (v_object) {
#line 139 "zeitgeist-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "zeitgeist-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 5639 "zeitgeist-plugin.c"
	} else {
#line 139 "zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5643 "zeitgeist-plugin.c"
	}
#line 139 "zeitgeist-plugin.vala"
	if (old) {
#line 139 "zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (old);
#line 5649 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_class_init (SynapseZeitgeistPluginZeitgeistMatchFactoryClass * klass,
                                                             gpointer klass_data)
{
#line 139 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_match_factory_parent_class = g_type_class_peek_parent (klass);
#line 139 "zeitgeist-plugin.vala"
	((SynapseZeitgeistPluginZeitgeistMatchFactoryClass *) klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize;
#line 5661 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_instance_init (SynapseZeitgeistPluginZeitgeistMatchFactory * self,
                                                                gpointer klass)
{
#line 139 "zeitgeist-plugin.vala"
	self->ref_count = 1;
#line 5670 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize (SynapseZeitgeistPluginZeitgeistMatchFactory * obj)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
#line 139 "zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactory);
#line 139 "zeitgeist-plugin.vala"
	g_signal_handlers_destroy (self);
#line 5681 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_zeitgeist_plugin_value_zeitgeist_match_factory_init, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_free_value, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_copy_value, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_peek_pointer, "p", synapse_zeitgeist_plugin_value_zeitgeist_match_factory_collect_value, "p", synapse_zeitgeist_plugin_value_zeitgeist_match_factory_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistMatchFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_match_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistMatchFactory), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_match_factory_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
	synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseZeitgeistPluginZeitgeistMatchFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__once)) {
		GType synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
		synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__once, synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__once;
}

static gpointer
synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (gpointer instance)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
	self = instance;
#line 139 "zeitgeist-plugin.vala"
	g_atomic_int_inc (&self->ref_count);
#line 139 "zeitgeist-plugin.vala"
	return instance;
#line 5716 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (gpointer instance)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
	self = instance;
#line 139 "zeitgeist-plugin.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 139 "zeitgeist-plugin.vala"
		SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_GET_CLASS (self)->finalize (self);
#line 139 "zeitgeist-plugin.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5730 "zeitgeist-plugin.c"
	}
}

static GObject *
synapse_zeitgeist_plugin_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistPlugin * self;
#line 212 "zeitgeist-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class);
#line 212 "zeitgeist-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 212 "zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 212 "zeitgeist-plugin.vala"
	return obj;
#line 5750 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_class_init (SynapseZeitgeistPluginClass * klass,
                                     gpointer klass_data)
{
	gchar* _tmp0_;
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPlugin_private_offset);
#line 24 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_get_property;
#line 24 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_set_property;
#line 24 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_plugin_constructor;
#line 24 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_finalize;
#line 24 "zeitgeist-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "zeitgeist-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY] = g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 233 "zeitgeist-plugin.vala"
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, NULL, NULL);
#line 233 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_interesting_attributes = _tmp0_;
#line 206 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_register_plugin ();
#line 5780 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "zeitgeist-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_plugin_real_activate;
#line 24 "zeitgeist-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_plugin_real_deactivate;
#line 24 "zeitgeist-plugin.vala"
	iface->get_enabled = synapse_zeitgeist_plugin_real_get_enabled;
#line 24 "zeitgeist-plugin.vala"
	iface->set_enabled = synapse_zeitgeist_plugin_real_set_enabled;
#line 5797 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
#line 24 "zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "zeitgeist-plugin.vala"
	iface->handles_empty_query = (gboolean (*) (SynapseItemProvider*)) synapse_zeitgeist_plugin_real_handles_empty_query;
#line 24 "zeitgeist-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_zeitgeist_plugin_real_search;
#line 24 "zeitgeist-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_zeitgeist_plugin_search_finish;
#line 5812 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_instance_init (SynapseZeitgeistPlugin * self,
                                        gpointer klass)
{
#line 24 "zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_get_instance_private (self);
#line 26 "zeitgeist-plugin.vala"
	self->priv->_enabled = TRUE;
#line 634 "zeitgeist-plugin.vala"
	self->priv->search_in_progress = FALSE;
#line 5825 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_finalize (GObject * obj)
{
	SynapseZeitgeistPlugin * self;
#line 24 "zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 209 "zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_index);
#line 210 "zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 24 "zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class)->finalize (obj);
#line 5840 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPlugin), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_type_id;
	synapse_zeitgeist_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseZeitgeistPlugin_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_type_id, sizeof (SynapseZeitgeistPluginPrivate));
	return synapse_zeitgeist_plugin_type_id;
}

GType
synapse_zeitgeist_plugin_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_type_id__once)) {
		GType synapse_zeitgeist_plugin_type_id;
		synapse_zeitgeist_plugin_type_id = synapse_zeitgeist_plugin_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_type_id__once, synapse_zeitgeist_plugin_type_id);
	}
	return synapse_zeitgeist_plugin_type_id__once;
}

static void
_vala_synapse_zeitgeist_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseZeitgeistPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 24 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 24 "zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY:
#line 24 "zeitgeist-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "zeitgeist-plugin.vala"
		break;
#line 24 "zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY:
#line 24 "zeitgeist-plugin.vala"
		g_value_set_object (value, synapse_zeitgeist_plugin_get_data_sink (self));
#line 24 "zeitgeist-plugin.vala"
		break;
#line 5891 "zeitgeist-plugin.c"
		default:
#line 24 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "zeitgeist-plugin.vala"
		break;
#line 5897 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseZeitgeistPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 24 "zeitgeist-plugin.vala"
	switch (property_id) {
#line 24 "zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY:
#line 24 "zeitgeist-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "zeitgeist-plugin.vala"
		break;
#line 24 "zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY:
#line 24 "zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_set_data_sink (self, g_value_get_object (value));
#line 24 "zeitgeist-plugin.vala"
		break;
#line 5923 "zeitgeist-plugin.c"
		default:
#line 24 "zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "zeitgeist-plugin.vala"
		break;
#line 5929 "zeitgeist-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5940 "zeitgeist-plugin.c"
		gssize i;
#line 24 "pastebin-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "pastebin-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "pastebin-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5948 "zeitgeist-plugin.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "pastebin-plugin.vala"
	g_free (array);
#line 5963 "zeitgeist-plugin.c"
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
#line 24 "pastebin-plugin.vala"
	if (array) {
#line 24 "pastebin-plugin.vala"
		while (((gpointer*) array)[length]) {
#line 24 "pastebin-plugin.vala"
			length++;
#line 5977 "zeitgeist-plugin.c"
		}
	}
#line 24 "pastebin-plugin.vala"
	return length;
#line 5982 "zeitgeist-plugin.c"
}

