const char console_lua[] =
"-- console.lua -- internal file\n"
"--\n"
"-- vim: ts=4 sw=4 et\n"
"\n"
"local ffi = require('ffi')\n"
"ffi.cdef[[\n"
"    enum output_format {\n"
"        OUTPUT_FORMAT_YAML = 0,\n"
"        OUTPUT_FORMAT_LUA_LINE,\n"
"        OUTPUT_FORMAT_LUA_BLOCK,\n"
"    };\n"
"\n"
"    enum output_format\n"
"    console_get_output_format();\n"
"\n"
"    void\n"
"    console_set_output_format(enum output_format output_format);\n"
"]]\n"
"\n"
"local internal = require('console.lib')\n"
"local session_internal = box.internal.session\n"
"local fiber = require('fiber')\n"
"local socket = require('socket')\n"
"local log = require('log')\n"
"local errno = require('errno')\n"
"local urilib = require('uri')\n"
"local yaml = require('yaml')\n"
"local net_box = require('net.box')\n"
"local help = require('help').help\n"
"\n"
"local DEFAULT_CONNECT_TIMEOUT = 10\n"
"local PUSH_TAG_HANDLE = '!push!'\n"
"\n"
"--\n"
"-- Default output handler set to YAML for backward\n"
"-- compatibility reason.\n"
"local default_output_format = { [\"fmt\"] = \"yaml\", [\"opts\"] = nil }\n"
"local output_handlers = { }\n"
"\n"
"--\n"
"-- This is an end-of-stream marker for text output of Tarantool\n"
"-- server, for different output formats - yaml and Lua.\n"
"--\n"
"-- While for yaml ... is a standard stream end marker, using ';'\n"
"-- for Lua output we're walking on a thin ice - ';' is legal inside\n"
"-- a valid Lua block as well. But since this marker is used when\n"
"-- reading data created by a Tarantool server, we can rely on it not\n"
"-- being present inside of stream, since Tarantool server never\n"
"-- puts it inside of a stream.\n"
"local output_eos = { [\"yaml\"] = '\\n...\\n', [\"lua\"] = ';' }\n"
"\n"
"local default_local_eos = ''\n"
"\n"
"output_handlers[\"yaml\"] = function(status, _opts, ...)\n"
"    local err, ok, res\n"
"     -- Using pcall, because serializer can raise an exception\n"
"    if status then\n"
"        ok, res = pcall(internal.format_yaml, ...)\n"
"    else\n"
"        err = ...\n"
"        if err == nil then\n"
"            err = box.NULL\n"
"        end\n"
"        ok, res = pcall(internal.format_yaml, { error = err })\n"
"    end\n"
"    if ok then\n"
"        return res\n"
"    else\n"
"        local m = 'console: exception while formatting the output: \"%s\"'\n"
"        err = m:format(tostring(res))\n"
"        return internal.format_yaml({ error = err })\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- Format a Lua value.\n"
"local function format_lua_value(status, internal_opts, value)\n"
"    if not status then\n"
"        if value == nil then\n"
"            value = box.NULL\n"
"        end\n"
"        value = { error = value }\n"
"    end\n"
"    local ok, res = pcall(internal.format_lua, internal_opts, value)\n"
"    if ok then\n"
"        return res\n"
"    else\n"
"        local m = 'console: exception while formatting the output: \"%s\"'\n"
"        local err = m:format(tostring(res))\n"
"        return internal.format_lua(internal_opts, { error = err })\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- Convert options from user form to the internal format.\n"
"local function gen_lua_opts(opts)\n"
"    if opts == \"block\" then\n"
"        return {block=true, indent=2}\n"
"    else\n"
"        return {block=false, indent=2}\n"
"    end\n"
"end\n"
"\n"
"output_handlers[\"lua\"] = function(status, opts, ...)\n"
"    local collect = {}\n"
"    --\n"
"    -- Convert options to internal dictionary.\n"
"    local internal_opts = gen_lua_opts(opts)\n"
"    for i = 1, select('#', ...) do\n"
"        collect[i] = format_lua_value(status, internal_opts, select(i, ...))\n"
"        if collect[i] == nil then\n"
"            --\n"
"            -- table.concat doesn't work for nil\n"
"            -- so convert it explicitly.\n"
"            collect[i] = \"nil\"\n"
"        end\n"
"    end\n"
"    return table.concat(collect, ', ') .. output_eos[\"lua\"]\n"
"end\n"
"\n"
"local function parse_output(value)\n"
"    if not value then\n"
"        return 'Specify output format: lua or yaml.'\n"
"    end\n"
"    local fmt, opts, local_eos\n"
"    for _, v in ipairs(value:split(',')) do\n"
"        if v == 'yaml' or v == 'lua' then\n"
"            fmt = v\n"
"        elseif v == 'line' or v == 'block' then\n"
"            opts = v\n"
"        elseif v:find('=') then\n"
"            local pivot = v:find('=')\n"
"            local lhs = v:sub(1, pivot - 1)\n"
"            local rhs = v:sub(pivot + 1, -1)\n"
"            if lhs == 'local_eos' then\n"
"                local_eos = rhs\n"
"            else\n"
"                return ('Unknown \"\\\\set output\" option: %q'):format(lhs)\n"
"            end\n"
"        else\n"
"            return ('Unknown \"\\\\set output\" option: %q'):format(v)\n"
"        end\n"
"    end\n"
"    if fmt == nil then\n"
"        return 'Specify output format: lua or yaml.'\n"
"    end\n"
"    if (opts or local_eos) and fmt ~= 'lua' then\n"
"        return (\"Invalid language %s, opts are available only in lua.\"):format(fmt)\n"
"    end\n"
"    return nil, fmt, opts, local_eos\n"
"end\n"
"\n"
"local function set_default_output(value)\n"
"    if value == nil then\n"
"        error(\"Nil output value passed\")\n"
"    end\n"
"    local err, fmt, opts = parse_output(value)\n"
"    if err then\n"
"        error(err)\n"
"    end\n"
"    default_output_format[\"fmt\"] = fmt\n"
"    default_output_format[\"opts\"] = opts\n"
"end\n"
"\n"
"local function get_default_output(...)\n"
"    local args = ...\n"
"    if args ~= nil then\n"
"        error(\"Arguments provided while prohibited\")\n"
"    end\n"
"    return default_output_format\n"
"end\n"
"\n"
"local function output_save(fmt, opts)\n"
"    --\n"
"    -- Output format descriptors are saved per\n"
"    -- session thus each console may specify\n"
"    -- own mode.\n"
"    if fmt == \"yaml\" then\n"
"        ffi.C.console_set_output_format(ffi.C.OUTPUT_FORMAT_YAML)\n"
"    elseif fmt == \"lua\" and opts == \"block\" then\n"
"        ffi.C.console_set_output_format(ffi.C.OUTPUT_FORMAT_LUA_BLOCK)\n"
"    else\n"
"        ffi.C.console_set_output_format(ffi.C.OUTPUT_FORMAT_LUA_LINE)\n"
"    end\n"
"end\n"
"\n"
"local function current_output()\n"
"    local fmt = ffi.C.console_get_output_format()\n"
"    if fmt == ffi.C.OUTPUT_FORMAT_YAML then\n"
"        return { [\"fmt\"] = \"yaml\", [\"opts\"] = nil }\n"
"    elseif fmt == ffi.C.OUTPUT_FORMAT_LUA_LINE then\n"
"        return { [\"fmt\"] = \"lua\", [\"opts\"] = \"line\" }\n"
"    elseif fmt == ffi.C.OUTPUT_FORMAT_LUA_BLOCK then\n"
"        return { [\"fmt\"] = \"lua\", [\"opts\"] = \"block\" }\n"
"    end\n"
"end\n"
"\n"
"-- Used by console_session_push.\n"
"box.internal.format_lua_push = function(value)\n"
"    local internal_opts = gen_lua_opts(current_output()[\"opts\"])\n"
"    value = format_lua_value(true, internal_opts, value)\n"
"    return '-- Push\\n' .. value .. ';'\n"
"end\n"
"\n"
"--\n"
"-- Return current EOS value for currently\n"
"-- active output format.\n"
"local function current_eos()\n"
"    return output_eos[current_output()[\"fmt\"]]\n"
"end\n"
"\n"
"--\n"
"-- Set/get current console EOS value from\n"
"-- currently active output format.\n"
"local function console_eos(eos_value)\n"
"    if not eos_value then\n"
"        return tostring(current_eos())\n"
"    end\n"
"    -- We can't allow to change yaml eos format\n"
"    -- because it is a part of encoding standart.\n"
"    local d = current_output()\n"
"    if d[\"fmt\"] == \"yaml\" then\n"
"        error(\"console.eos(): is immutable for output \" .. d[\"fmt\"])\n"
"    else\n"
"        output_eos[d[\"fmt\"]] = eos_value\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- Map output format descriptor into a \"\\set\" command.\n"
"local function output_to_cmd_string(desc)\n"
"    if desc[\"opts\"] then\n"
"        return string.format(\"\\\\set output %s,%s\", desc[\"fmt\"], desc[\"opts\"])\n"
"    else\n"
"        return string.format(\"\\\\set output %s\", desc[\"fmt\"])\n"
"    end\n"
"end\n"
"\n"
"local function format(status, ...)\n"
"    local d = current_output()\n"
"    return output_handlers[d[\"fmt\"]](status, d[\"opts\"], ...)\n"
"end\n"
"\n"
"--\n"
"-- Set delimiter\n"
"--\n"
"local function delimiter(delim)\n"
"    local self = fiber.self().storage.console\n"
"    if self == nil then\n"
"        error(\"console.delimiter(): need existing console\")\n"
"    end\n"
"    if delim == nil then\n"
"        return self.delimiter\n"
"    elseif type(delim) == 'string' then\n"
"        self.delimiter = delim\n"
"    else\n"
"        error('invalid delimiter')\n"
"    end\n"
"end\n"
"\n"
"local function set_delimiter(_storage, value)\n"
"    local console = fiber.self().storage.console\n"
"    if console ~= nil and console.delimiter == '$EOF$' then\n"
"        return error('Can not install delimiter for net box sessions')\n"
"    end\n"
"    value = value or ''\n"
"    return delimiter(value)\n"
"end\n"
"\n"
"local function set_language(storage, value)\n"
"    if value == nil then\n"
"        return { language = storage.language or 'lua' }\n"
"    end\n"
"    if value ~= 'lua' and value ~= 'sql' then\n"
"        local msg = 'Invalid language \"%s\", supported languages: lua and sql.'\n"
"        return error(msg:format(value))\n"
"    end\n"
"    if value == 'sql' and rawget(box, 'execute') == nil then\n"
"        return error(\"Unable to set language to 'sql' with unconfigured box\")\n"
"    end\n"
"    storage.language = value\n"
"    return true\n"
"end\n"
"\n"
"local function set_output(storage, value)\n"
"    local err, fmt, opts, local_eos = parse_output(value)\n"
"    if err then\n"
"        return error(err)\n"
"    end\n"
"    if local_eos ~= nil then\n"
"        storage.local_eos = local_eos\n"
"    end\n"
"    output_save(fmt, opts)\n"
"    return true\n"
"end\n"
"\n"
"local param_handlers = {\n"
"    language = set_language,\n"
"    lang = set_language,\n"
"    l = set_language,\n"
"    output = set_output,\n"
"    o = set_output,\n"
"    delimiter = set_delimiter,\n"
"    delim = set_delimiter,\n"
"    d = set_delimiter\n"
"}\n"
"\n"
"local function set_param(storage, _func, param, value)\n"
"    if param == nil then\n"
"        return format(false, 'Invalid set syntax, type \\\\help for help')\n"
"    end\n"
"    if param_handlers[param] == nil then\n"
"        return format(false, 'Unknown parameter: ' .. tostring(param))\n"
"    end\n"
"    return format(pcall(param_handlers[param], storage, value))\n"
"end\n"
"\n"
"local function help_wrapper(_storage)\n"
"    return format(true, help())\n"
"end\n"
"\n"
"local function quit(_storage)\n"
"    local console = fiber.self().storage.console\n"
"    if console ~= nil then\n"
"        console.running = false\n"
"    end\n"
"end\n"
"\n"
"local operators = {\n"
"    help = help_wrapper,\n"
"    h = help_wrapper,\n"
"    set = set_param,\n"
"    s = set_param,\n"
"    quit = quit,\n"
"    q = quit\n"
"}\n"
"\n"
"--\n"
"-- Generate command arguments from the line to\n"
"-- be passed into command handlers.\n"
"local function parse_operators(line)\n"
"    local items = {}\n"
"    for item in string.gmatch(line, '([^%s]+)') do\n"
"        items[#items + 1] = item\n"
"    end\n"
"    if #items == 0 then\n"
"        return 0, nil\n"
"    end\n"
"    if operators[items[1]] == nil then\n"
"        return #items, nil\n"
"    end\n"
"    return #items, items\n"
"end\n"
"\n"
"--\n"
"-- Preprocess a command via operator helpers.\n"
"local function preprocess(storage, line)\n"
"    local nr_items, items = parse_operators(line)\n"
"    if nr_items == 0 then\n"
"        return help_wrapper()\n"
"    end\n"
"    if items == nil then\n"
"        local msg = \"Invalid command \\\\%s. Type \\\\help for help.\"\n"
"        return format(false, msg:format(line))\n"
"    end\n"
"    return operators[items[1]](storage, unpack(items))\n"
"end\n"
"\n"
"--\n"
"-- Return a command without a leading slash.\n"
"local function get_command(line)\n"
"    if line:sub(1, 1) == '\\\\' then\n"
"        return line:sub(2)\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"--\n"
"-- return args as table with 'n' set to args number\n"
"--\n"
"local function table_pack(...)\n"
"    return {n = select('#', ...), ...}\n"
"end\n"
"\n"
"--\n"
"-- Evaluate command on local instance\n"
"--\n"
"local function local_eval(storage, line)\n"
"    if not line then\n"
"        return nil\n"
"    end\n"
"    internal.run_on_eval(line)\n"
"    local command = get_command(line)\n"
"    if command then\n"
"        return preprocess(storage, command)\n"
"    end\n"
"    if storage.language == 'sql' then\n"
"        return format(pcall(box.execute, line))\n"
"    end\n"
"    --\n"
"    -- Attempt to append 'return ' before the chunk: if the chunk is\n"
"    -- an expression, this pushes results of the expression onto the\n"
"    -- stack. If the chunk is a statement, it won't compile. In that\n"
"    -- case try to run the original string.\n"
"    --\n"
"    local fun, errmsg = loadstring(\"return \"..line)\n"
"    if not fun then\n"
"        fun, errmsg = loadstring(line)\n"
"    end\n"
"    if not fun then\n"
"        return format(false, errmsg)\n"
"    end\n"
"    -- box.is_in_txn() is stubbed to throw a error before call to box.cfg{}\n"
"    local in_txn_before = ffi.C.box_txn()\n"
"    local res = table_pack(pcall(fun))\n"
"    --\n"
"    -- Rollback if transaction was began in the failed expression.\n"
"    --\n"
"    -- In case of remote binary console if eval leaves an active transaction\n"
"    -- then later a error is thrown overwriting error thrown by eval thus the\n"
"    -- rollback. Also the check if we were already in transaction allows for\n"
"    -- local and remote text console to preserve interactive transactions.\n"
"    --\n"
"    if not res[1] and not in_txn_before and ffi.C.box_txn() then\n"
"        box.rollback()\n"
"    end\n"
"    -- specify length to preserve trailing nils\n"
"    return format(unpack(res, 1, res.n))\n"
"end\n"
"\n"
"local function eval(line)\n"
"    return local_eval(box.session.storage, line)\n"
"end\n"
"\n"
"local text_connection_mt = {\n"
"    __index = {\n"
"        --\n"
"        -- Close underlying socket.\n"
"        --\n"
"        close = function(self)\n"
"            self._socket:close()\n"
"        end,\n"
"        --\n"
"        -- Write a text into a socket.\n"
"        -- @param test Text to send.\n"
"        -- @retval not nil Bytes sent.\n"
"        -- @retval     nil Error.\n"
"        --\n"
"        write = function(self, text)\n"
"            return self._socket:write(text)\n"
"        end,\n"
"        --\n"
"        -- Read a text from a socket until EOS.\n"
"        -- @retval not nil Well formatted data.\n"
"        -- @retval     nil Error.\n"
"        --\n"
"        read = function(self)\n"
"            local ret = self._socket:read(self.eos)\n"
"            if ret and ret ~= '' then\n"
"                return ret\n"
"            end\n"
"        end,\n"
"        --\n"
"        -- The command might modify EOS so\n"
"        -- we have to parse and preprocess it\n"
"        -- first to not stuck in :read() forever.\n"
"        --\n"
"        -- Same time the EOS is per connection\n"
"        -- value so we keep it inside the metatable\n"
"        -- instace, and because we can't use same\n"
"        -- name as output_eos() function we call\n"
"        -- it simplier as self.eos.\n"
"        preprocess_eval = function(self, text)\n"
"            local command = get_command(text)\n"
"            if command == nil then\n"
"                return\n"
"            end\n"
"            local nr_items, items = parse_operators(command)\n"
"            if nr_items == 3 then\n"
"                --\n"
"                -- Make sure it is exactly \"\\set output\" command.\n"
"                if operators[items[1]] == set_param and\n"
"                    param_handlers[items[2]] == set_output then\n"
"                    local err, fmt, opts, local_eos = parse_output(items[3])\n"
"                    if not err then\n"
"                        self.fmt = fmt\n"
"                        self.eos = output_eos[fmt]\n"
"                        if local_eos ~= nil then\n"
"                            -- Rebuild the command without\n"
"                            -- local_eos=<...>, because it is a client\n"
"                            -- side option.\n"
"                            self.local_eos = local_eos\n"
"                            local server_cmd_opts = table.concat({fmt, opts},\n"
"                                                                 ',')\n"
"                            return ('\\\\set output %s'):format(server_cmd_opts)\n"
"                        end\n"
"                    end\n"
"                end\n"
"            end\n"
"            return text\n"
"        end,\n"
"        --\n"
"        -- Write + Read.\n"
"        --\n"
"        eval = function(self, text)\n"
"            local server_cmd = self:preprocess_eval(text)\n"
"            -- If `text` is a `\\set output` command, server_cmd may be a cropped\n"
"            -- version of it without some configuration, that server doesn't\n"
"            -- need to get.\n"
"            text = (server_cmd or text)..'$EOF$\\n'\n"
"            local fmt = self.fmt or default_output_format[\"fmt\"]\n"
"            if not self:write(text) then\n"
"                error(self:set_error())\n"
"            end\n"
"            while true do\n"
"                local rc = self:read()\n"
"                if not rc then\n"
"                    break\n"
"                end\n"
"                if fmt == \"yaml\" then\n"
"                    local handle = yaml.decode(rc, {tag_only = true})\n"
"                    if not handle then\n"
"                        -- Can not fail - tags are encoded with no\n"
"                        -- user participation and are correct always.\n"
"                        return rc\n"
"                    end\n"
"                    if handle == PUSH_TAG_HANDLE and self.print_f then\n"
"                        self.print_f(rc)\n"
"                    end\n"
"                else\n"
"                    if not string.startswith(rc, '-- Push') then\n"
"                        return rc\n"
"                    end\n"
"                    if self.print_f then\n"
"                        self.print_f(rc)\n"
"                    end\n"
"                end\n"
"            end\n"
"            return error(self:set_error())\n"
"        end,\n"
"        --\n"
"        -- Make the connection be in error state, set error\n"
"        -- message.\n"
"        -- @retval Error message.\n"
"        --\n"
"        set_error = function(self)\n"
"            self.state = 'error'\n"
"            self.error = self._socket:error()\n"
"            if not self.error then\n"
"                self.error = 'Peer closed'\n"
"            end\n"
"            return self.error\n"
"        end,\n"
"    }\n"
"}\n"
"\n"
"--\n"
"-- Wrap an existing socket with text Read-Write API inside a\n"
"-- netbox-like object.\n"
"-- @param connection Socket to wrap.\n"
"-- @param url Parsed destination URL.\n"
"-- @param print_f Function to print push messages.\n"
"--\n"
"-- @retval nil, err Error, and err contains an error message.\n"
"-- @retval  not nil Netbox-like object.\n"
"--\n"
"local function wrap_text_socket(connection, url, print_f)\n"
"    local conn = setmetatable({\n"
"        _socket = connection,\n"
"        state = 'active',\n"
"        host = url.host or 'localhost',\n"
"        port = url.service,\n"
"        print_f = print_f,\n"
"        eos = current_eos(),\n"
"        fmt = current_output()[\"fmt\"],\n"
"        local_eos = default_local_eos\n"
"    }, text_connection_mt)\n"
"    --\n"
"    -- Prepare the connection: setup EOS symbol\n"
"    -- by executing the \\set command on remote machine\n"
"    -- explicitly, and then setup a delimiter.\n"
"    local cmd_set_output = output_to_cmd_string(current_output()) .. '\\n'\n"
"    if not conn:write(cmd_set_output) or not conn:read() then\n"
"        conn:set_error()\n"
"    end\n"
"    local cmd_delimiter = 'require(\"console\").delimiter(\"$EOF$\")\\n'\n"
"    if not conn:write(cmd_delimiter) or not conn:read() then\n"
"        conn:set_error()\n"
"    end\n"
"    return conn\n"
"end\n"
"\n"
"--\n"
"-- Evaluate command on remote instance\n"
"--\n"
"local function remote_eval(self, line)\n"
"    if line and self.remote.state == 'active' then\n"
"        local ok, res = pcall(self.remote.console_eval, line)\n"
"        if self.remote.state == 'active' then\n"
"            return ok and res or format(false, res)\n"
"        end\n"
"    end\n"
"    local err = self.remote.error\n"
"    self.remote:close()\n"
"    self.remote = nil\n"
"    self.console_eval = nil\n"
"    self.eval = nil\n"
"    self.prompt = nil\n"
"    self.completion = nil\n"
"    pcall(self.on_client_disconnect, self)\n"
"    return (err and format(false, err)) or ''\n"
"end\n"
"\n"
"local function local_check_lua(buf)\n"
"    local fn, err = loadstring(buf)\n"
"    if fn ~= nil or not string.find(err, \" near '<eof>'$\") then\n"
"        -- valid Lua code or a syntax error not due to\n"
"        -- an incomplete input\n"
"        return true\n"
"    end\n"
"    if loadstring('return '..buf) ~= nil then\n"
"        -- certain obscure inputs like '(42\\n)' yield the\n"
"        -- same error as incomplete statement\n"
"        return true\n"
"    end\n"
"    return false\n"
"end\n"
"\n"
"--\n"
"-- Read command from stdin\n"
"--\n"
"local function local_read(self)\n"
"    local buf = \"\"\n"
"    local prompt = self.prompt\n"
"    while true do\n"
"        local delim = self.delimiter\n"
"        local line, discard_buffer = internal.readline({\n"
"            prompt = prompt.. \"> \",\n"
"            completion = self.ac and self.completion or nil\n"
"        })\n"
"        if not line then\n"
"            return nil\n"
"        end\n"
"        if discard_buffer then\n"
"            return ''\n"
"        end\n"
"        buf = buf..line\n"
"        if buf:sub(1, 1) == '\\\\' then\n"
"            break\n"
"        end\n"
"        if delim == \"\" then\n"
"            local lang = box.session.language\n"
"            if not lang or lang == 'lua' then\n"
"                -- stop once a complete Lua statement is entered\n"
"                if local_check_lua(buf) then\n"
"                    break\n"
"                end\n"
"            else\n"
"                break\n"
"            end\n"
"        elseif #buf >= #delim and buf:sub(#buf - #delim + 1) == delim then\n"
"            buf = buf:sub(0, #buf - #delim)\n"
"            break\n"
"        end\n"
"        buf = buf..\"\\n\"\n"
"        prompt = string.rep(' ', #self.prompt)\n"
"    end\n"
"    internal.add_history(buf)\n"
"    if self.history_file then\n"
"        internal.save_history(self.history_file)\n"
"    end\n"
"    return buf\n"
"end\n"
"\n"
"--\n"
"-- Print result to stdout\n"
"--\n"
"local function local_print(self, output)\n"
"    --\n"
"    -- Be cautious, `output` may be any printable object, e.g. tarantoolctl\n"
"    -- passes cdata errors in some cases.\n"
"    --\n"
"    if type(output) == 'string' and output:endswith(output_eos[\"lua\"]) then\n"
"        local new_local_eos\n"
"        if self.remote ~= nil then\n"
"            new_local_eos = self.remote.local_eos\n"
"        else\n"
"            new_local_eos = self.local_eos\n"
"        end\n"
"        output = output:sub(1, -#output_eos[\"lua\"] - 1) .. new_local_eos\n"
"    end\n"
"    print(output)\n"
"end\n"
"\n"
"--\n"
"-- Read command from connected client console.listen()\n"
"--\n"
"local function client_read(self)\n"
"    --\n"
"    -- Byte sequences that come over the network and come from\n"
"    -- the local client console may have a different terminal\n"
"    -- character. We support both possible options: LF and CRLF.\n"
"    --\n"
"    local delim_cr = self.delimiter .. \"\\r\"\n"
"    local delim_lf = self.delimiter .. \"\\n\"\n"
"    local buf = self.client:read({delimiter = {delim_lf, delim_cr}})\n"
"    if buf == nil then\n"
"        return nil\n"
"    elseif buf == \"\" then\n"
"        return nil -- EOF\n"
"    elseif buf == \"~.\\n\" then\n"
"        -- Escape sequence to close current connection (like SSH)\n"
"        return nil\n"
"    end\n"
"    -- remove trailing delimiter\n"
"    return buf:sub(1, -#self.delimiter-2)\n"
"end\n"
"\n"
"--\n"
"-- Print result to connected client from console.listen()\n"
"--\n"
"local function client_print(self, output)\n"
"    self.client:write(output)\n"
"end\n"
"\n"
"--\n"
"-- REPL state\n"
"--\n"
"local repl_mt = {\n"
"    __index = {\n"
"        running = false;\n"
"        delimiter = \"\";\n"
"        prompt = \"tarantool\";\n"
"        read = local_read;\n"
"        eval = local_eval;\n"
"        print = local_print;\n"
"        completion = internal.completion_handler;\n"
"        ac = true;\n"
"        local_eos = default_local_eos;\n"
"    };\n"
"}\n"
"\n"
"--\n"
"-- REPL = read-eval-print-loop\n"
"--\n"
"local function repl(self)\n"
"    fiber.self().storage.console = self\n"
"    if type(self.on_start) == 'function' then\n"
"        self:on_start()\n"
"    end\n"
"\n"
"    while self.running do\n"
"        local command = self:read()\n"
"        local output = self:eval(command)\n"
"        if output == nil then break end\n"
"        self:print(output)\n"
"    end\n"
"    self.running = false\n"
"    fiber.self().storage.console = nil\n"
"end\n"
"\n"
"local function on_start(foo)\n"
"    if foo == nil or type(foo) == 'function' then\n"
"        repl_mt.__index.on_start = foo\n"
"        return\n"
"    end\n"
"    error('Wrong type of on_start hook: ' .. type(foo))\n"
"end\n"
"\n"
"local function on_client_disconnect(foo)\n"
"    if foo == nil or type(foo) == 'function' then\n"
"        repl_mt.__index.on_client_disconnect = foo\n"
"        return\n"
"    end\n"
"    error('Wrong type of on_client_disconnect hook: ' .. type(foo))\n"
"end\n"
"\n"
"--\n"
"--\n"
"--\n"
"local function ac(yes_no)\n"
"    local self = fiber.self().storage.console\n"
"    if self == nil then\n"
"        error(\"console.ac(): need existing console\")\n"
"    end\n"
"    self.ac = not not yes_no\n"
"end\n"
"\n"
"--\n"
"-- Start REPL on stdin\n"
"--\n"
"local started = false\n"
"local function start()\n"
"    if started then\n"
"        error(\"console is already started\")\n"
"    end\n"
"    started = true\n"
"    local self = setmetatable({ running = true }, repl_mt)\n"
"    local home_dir = os.getenv('HOME')\n"
"    if home_dir then\n"
"        self.history_file = home_dir .. '/.tarantool_history'\n"
"        internal.load_history(self.history_file)\n"
"    end\n"
"    session_internal.create(1, \"repl\") -- stdin fileno\n"
"    repl(self)\n"
"    started = false\n"
"end\n"
"\n"
"--\n"
"-- Connect to Lua console\n"
"--\n"
"local function connect_lua_console(url, timeout, print_f)\n"
"    local deadline = fiber.clock() + (timeout or DEFAULT_CONNECT_TIMEOUT)\n"
"    local s, err = socket.tcp_connect(url.host, url.service,\n"
"                                      deadline - fiber.clock())\n"
"    if not s then\n"
"        return nil, err\n"
"    end\n"
"    local greeting = s:read(128, deadline - fiber.clock())\n"
"    if not greeting then\n"
"        local err = s:error()\n"
"        s:close()\n"
"        return nil, err\n"
"    end\n"
"    if greeting:len() ~= 128 or\n"
"       greeting:sub(64, 64) ~= '\\n' or greeting:sub(128, 128) ~= '\\n' or\n"
"       not greeting:match(\"Tarantool%s+%d+%.%d+%.%d+%s+%(Lua console%)\") then\n"
"        s:close()\n"
"        return nil, 'Invalid greeting'\n"
"   end\n"
"   return wrap_text_socket(s, url, print_f)\n"
"end\n"
"\n"
"--\n"
"-- Connect to remote instance\n"
"--\n"
"local function connect(uri, opts)\n"
"    opts = opts or {}\n"
"\n"
"    local self = fiber.self().storage.console\n"
"    if self == nil then\n"
"        error(\"console.connect() need existing console\")\n"
"    end\n"
"\n"
"    local u\n"
"    if uri then\n"
"        u = urilib.parse(tostring(uri))\n"
"    end\n"
"    if u == nil or u.service == nil then\n"
"        error('Usage: console.connect(\"[login:password@][host:]port\")')\n"
"    end\n"
"\n"
"    -- We don't know if the remote end is binary or Lua console so we first try\n"
"    -- to connect to it as binary using net.box and fall back on Lua console if\n"
"    -- it fails.\n"
"    local remote = net_box.connect(u.host, u.service, {\n"
"            connect_timeout = opts.timeout,\n"
"            user = u.login,\n"
"            password = u.password,\n"
"    })\n"
"    if remote.state == 'error' then\n"
"        local err = remote.error\n"
"        remote = nil\n"
"        if err == 'Unsupported protocol: Lua console' then\n"
"            remote, err = connect_lua_console(u, opts.timeout,\n"
"                                              function(msg) self:print(msg) end)\n"
"        end\n"
"        if not remote then\n"
"            log.verbose(err)\n"
"            box.error(box.error.NO_CONNECTION)\n"
"        end\n"
"        remote.console_eval = function(line)\n"
"            return remote:eval(line)\n"
"        end\n"
"    else\n"
"        if not remote.host then\n"
"            remote.host = 'localhost'\n"
"        end\n"
"        local eval_obj\n"
"        if remote.peer_protocol_features.streams then\n"
"            eval_obj = remote:new_stream()\n"
"        else\n"
"            eval_obj = remote\n"
"        end\n"
"        remote.console_eval = function(line)\n"
"            return eval_obj:eval('return require(\"console\").eval(...)', {line})\n"
"        end\n"
"    end\n"
"\n"
"    -- check connection && permissions\n"
"    local ok, res = pcall(remote.console_eval, 'return true')\n"
"    if not ok then\n"
"        remote:close()\n"
"        pcall(self.on_client_disconnect, self)\n"
"        error(res)\n"
"    end\n"
"\n"
"    -- override methods\n"
"    self.remote = remote\n"
"    self.eval = remote_eval\n"
"    self.prompt = string.format(\"%s:%s\", self.remote.host, self.remote.port)\n"
"    self.completion = function (str, pos1, pos2)\n"
"        local c = string.format(\n"
"            'return require(\"console\").completion_handler(%q, %d, %d)',\n"
"            str, pos1, pos2)\n"
"        return yaml.decode(remote.console_eval(c))[1]\n"
"    end\n"
"    log.info(\"connected to %s:%s\", self.remote.host, self.remote.port)\n"
"    return true\n"
"end\n"
"\n"
"local function client_handler(client, _peer)\n"
"    session_internal.create(client:fd(), \"console\")\n"
"    session_internal.run_on_connect()\n"
"    session_internal.run_on_auth(box.session.user(), true)\n"
"    local state = setmetatable({\n"
"        running = true;\n"
"        read = client_read;\n"
"        print = client_print;\n"
"        client = client;\n"
"    }, repl_mt)\n"
"    local version = _TARANTOOL:match(\"([^-]+)-\")\n"
"    state:print(string.format(\"%-63s\\n%-63s\\n\",\n"
"        \"Tarantool \".. version..\" (Lua console)\",\n"
"        \"type 'help' for interactive help\"))\n"
"    repl(state)\n"
"    session_internal.run_on_disconnect()\n"
"end\n"
"\n"
"--\n"
"-- Start admin console\n"
"--\n"
"local function listen(uri)\n"
"    local host, port\n"
"    if uri == nil then\n"
"        host = 'unix/'\n"
"        port = '/tmp/tarantool-console.sock'\n"
"    else\n"
"        local u = urilib.parse(tostring(uri))\n"
"        if u == nil or u.service == nil then\n"
"            error('Usage: console.listen(\"[host:]port\")')\n"
"        end\n"
"        host = u.host\n"
"        port = u.service or 3313\n"
"    end\n"
"    local s = socket.tcp_server(host, port, { handler = client_handler,\n"
"        name = 'console'})\n"
"    if not s then\n"
"        error(string.format('failed to create server %s:%s: %s',\n"
"            host, port, errno.strerror()))\n"
"    end\n"
"    return s\n"
"end\n"
"\n"
"return {\n"
"    start = start;\n"
"    eval = eval;\n"
"    delimiter = delimiter;\n"
"    set_default_output = set_default_output;\n"
"    get_default_output = get_default_output;\n"
"    eos = console_eos;\n"
"    ac = ac;\n"
"    connect = connect;\n"
"    listen = listen;\n"
"    on_start = on_start;\n"
"    on_client_disconnect = on_client_disconnect;\n"
"    completion_handler = internal.completion_handler;\n"
"}\n"
""
;
