const char upgrade_lua[] =
"local log = require('log')\n"
"local bit = require('bit')\n"
"local json = require('json')\n"
"local fio = require('fio')\n"
"local xlog = require('xlog')\n"
"local ffi = require('ffi')\n"
"local fun = require('fun')\n"
"\n"
"ffi.cdef('uint32_t box_dd_version_id(void);')\n"
"\n"
"-- Guest user id - the default user\n"
"local GUEST = 0\n"
"-- Super User ID\n"
"local ADMIN = 1\n"
"-- role 'PUBLIC' is special, it's automatically granted to every user\n"
"local PUBLIC = 2\n"
"-- role 'REPLICATION'\n"
"local REPLICATION = 3\n"
"-- role 'SUPER'\n"
"-- choose a fancy id to not clash with any existing role or\n"
"-- user during upgrade\n"
"local SUPER = 31\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Utils\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- Used to give a hint that the table should be serialized in MsgPack as map\n"
"-- and not as a array. Typical use is to give hint for empty table when it is\n"
"-- not possible to infer type from table content.\n"
"local function setmap(tab)\n"
"    return setmetatable(tab, { __serialize = 'map' })\n"
"end\n"
"\n"
"local mkversion = {}\n"
"mkversion.__index = mkversion\n"
"setmetatable(mkversion, {__call = function(c, ...) return c.new(...) end})\n"
"\n"
"function mkversion.new(major, minor, patch)\n"
"    local self = setmetatable({}, mkversion)\n"
"    self.major = major\n"
"    self.minor = minor\n"
"    self.patch = patch\n"
"    self.id = bit.bor(bit.lshift(bit.bor(bit.lshift(major, 8), minor), 8), patch)\n"
"    return self\n"
"end\n"
"\n"
"-- Parse string with version in format 'A.B.C' to version object.\n"
"function mkversion.parse(version)\n"
"    local major, minor, patch = version:match('^(%d+)%.(%d+)%.(%d+)$')\n"
"    if major == nil then\n"
"        error('version should be in format A.B.C')\n"
"    end\n"
"    return mkversion.new(tonumber(major), tonumber(minor), tonumber(patch))\n"
"end\n"
"\n"
"function mkversion.__tostring(self)\n"
"    return string.format('%s.%s.%s', self.major, self.minor, self.patch)\n"
"end\n"
"\n"
"function mkversion.__eq(lhs, rhs)\n"
"    return lhs.id == rhs.id\n"
"end\n"
"\n"
"function mkversion.__lt(lhs, rhs)\n"
"    return lhs.id < rhs.id\n"
"end\n"
"\n"
"-- space:truncate() doesn't work with disabled triggers on __index\n"
"local function truncate(space)\n"
"    local pk = space.index[0]\n"
"    while pk:len() > 0 do\n"
"        for _, t in pk:pairs() do\n"
"            local key = {}\n"
"            for _, parts in ipairs(pk.parts) do\n"
"                table.insert(key, t[parts.fieldno])\n"
"            end\n"
"            space:delete(key)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function foreach_system_space(cb)\n"
"    local max = box.schema.SYSTEM_ID_MAX\n"
"    for id, space in pairs(box.space) do\n"
"        -- Check for number, because box.space contains each space\n"
"        -- twice - by ID and by name. Here IDs are selected.\n"
"        -- Engine is checked to be a 'native' space, because other\n"
"        -- engines does not support DML, and does not have\n"
"        -- triggers to turn off/on. These are 'service',\n"
"        -- 'blackhole', and more may be added.\n"
"        -- When id > max system id is met, break is not done,\n"
"        -- because box.space is not an array, and it is not safe\n"
"        -- to assume all its numeric indexes are returned in\n"
"        -- ascending order.\n"
"        if type(id) == 'number' and id <= max and\n"
"           (space.engine == 'memtx' or space.engine == 'vinyl') then\n"
"            cb(space)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function set_system_triggers(val)\n"
"    foreach_system_space(function(s) s:run_triggers(val) end)\n"
"end\n"
"\n"
"local function with_disabled_system_triggers(func)\n"
"    set_system_triggers(false)\n"
"    local status, err = pcall(func)\n"
"    set_system_triggers(true)\n"
"    if not status then\n"
"        error(err)\n"
"    end\n"
"end\n"
"\n"
"-- Clears formats of all system spaces. It is used to disable system space\n"
"-- format checking before creation of a bootstrap snapshot.\n"
"local function clear_system_formats()\n"
"    foreach_system_space(function(s)\n"
"        box.space._space:update({s.id}, {{'=', 7, {}}})\n"
"    end)\n"
"end\n"
"\n"
"-- Applies no-op update to all system space records to run system triggers.\n"
"-- It is used to re-enable system space format checking after creation of\n"
"-- a bootstrap snapshot.\n"
"local function reset_system_formats()\n"
"    foreach_system_space(function(s)\n"
"        box.space._space:update({s.id}, {})\n"
"    end)\n"
"end\n"
"\n"
"local function version_from_tuple(tuple)\n"
"    local major, minor, patch = tuple:unpack(2, 4)\n"
"    patch = patch or 0\n"
"    if major and minor and type(major) == 'number' and\n"
"       type(minor) == 'number' and type(patch) == 'number' then\n"
"        return mkversion(major, minor, patch)\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"-- Get schema version, stored in _schema system space, by reading the latest\n"
"-- snapshot file from the snap_dir. Useful to define schema_version before\n"
"-- recovering the snapshot, because some schema versions are too old and cannot\n"
"-- be recovered normally.\n"
"local function get_snapshot_version(snap_dir)\n"
"    local snap_pattern = fio.pathjoin(snap_dir,\n"
"                                      string.rep('[0-9]', 20)..'.snap')\n"
"    local snap_list = fio.glob(snap_pattern)\n"
"    table.sort(snap_list)\n"
"    local snap = snap_list[#snap_list]\n"
"    if not snap then\n"
"        return nil\n"
"    end\n"
"    local version = nil\n"
"    for _, row in xlog.pairs(snap) do\n"
"        local sid = row.BODY and row.BODY.space_id\n"
"        if sid == box.schema.SCHEMA_ID then\n"
"            local tuple = row.BODY.tuple\n"
"            if tuple and tuple[1] == 'version' then\n"
"                version = version_from_tuple(tuple)\n"
"                if not version then\n"
"                    log.error(\"Corrupted version tuple in space '_schema' \"..\n"
"                              \"in snapshot '%s': %s \", snap, tuple)\n"
"                end\n"
"                break\n"
"            end\n"
"        elseif sid and sid > box.schema.SCHEMA_ID then\n"
"            -- Exit early if version wasn't found in _schema space.\n"
"            -- Snapshot rows are ordered by space id.\n"
"            break\n"
"        end\n"
"    end\n"
"    return version\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Bootstrap\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function erase()\n"
"    foreach_system_space(function(s) truncate(s) end)\n"
"end\n"
"\n"
"local function create_sysview(source_id, target_id)\n"
"    --\n"
"    -- Create definitions for the system view, and grant\n"
"    -- privileges on system views to 'PUBLIC' role\n"
"    --\n"
"    local def = box.space._space:get(source_id):totable()\n"
"    def[1] = target_id\n"
"    def[3] = \"_v\"..def[3]:sub(2)\n"
"    def[4] = 'sysview'\n"
"    local space_def = box.space._space:get(target_id)\n"
"    if space_def == nil then\n"
"        log.info(\"create view %s...\", def[3])\n"
"        box.space._space:replace(def)\n"
"    elseif json.encode(space_def[7]) ~= json.encode(def[7]) then\n"
"        -- sync box.space._vXXX format with box.space._XXX format\n"
"        log.info(\"alter space %s set format\", def[3])\n"
"        box.space._space:update(def[1], {{ '=', 7, def[7] }})\n"
"    end\n"
"    local idefs = {}\n"
"    for _, idef in box.space._index:pairs(source_id, { iterator = 'EQ'}) do\n"
"        idef = idef:totable()\n"
"        idef[1] = target_id\n"
"        table.insert(idefs, idef)\n"
"    end\n"
"    for _, idef in ipairs(idefs) do\n"
"        if box.space._index:get({idef[1], idef[2]}) == nil then\n"
"            log.info(\"create index %s on %s\", idef[3], def[3])\n"
"            box.space._index:replace(idef)\n"
"        end\n"
"    end\n"
"    -- public can read system views\n"
"    if box.space._priv.index.primary:count({PUBLIC, 'space', target_id}) == 0 then\n"
"        log.info(\"grant read access to 'public' role for %s view\", def[3])\n"
"        box.space._priv:insert({1, PUBLIC, 'space', target_id, box.priv.R})\n"
"    end\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 1.7.1\n"
"--------------------------------------------------------------------------------\n"
"local function user_trig_1_7_1(_, tuple)\n"
"    if tuple and tuple[3] == 'guest' and not tuple[5] then\n"
"        local auth_method_list = {}\n"
"        auth_method_list[\"chap-sha1\"] = box.schema.user.password(\"\")\n"
"        tuple = tuple:update{{'=', 5, auth_method_list}}\n"
"        log.info(\"Set empty password to user 'guest'\")\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 1.7.2\n"
"--------------------------------------------------------------------------------\n"
"local function index_trig_1_7_2(_, tuple)\n"
"    local field_types_v16 = {\n"
"        num = 'unsigned',\n"
"        int = 'integer',\n"
"        str = 'string',\n"
"    }\n"
"    if not tuple then\n"
"        return tuple\n"
"    end\n"
"    local parts = tuple[6]\n"
"    local changed = false\n"
"    for _, part in pairs(parts) do\n"
"        local field_type = part[2]:lower()\n"
"        if field_types_v16[field_type] ~= nil then\n"
"            part[2] = field_types_v16[field_type]\n"
"            changed = true\n"
"        end\n"
"    end\n"
"    if changed then\n"
"        log.info(\"Update index '%s' on space '%s': set parts to %s\", tuple[3],\n"
"                 box.space[tuple[1]].name, json.encode(parts))\n"
"        tuple = tuple:update{{'=', 6, parts}}\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 1.7.5\n"
"--------------------------------------------------------------------------------\n"
"local function create_truncate_space()\n"
"    local _truncate = box.space[box.schema.TRUNCATE_ID]\n"
"\n"
"    log.info(\"create space _truncate\")\n"
"    box.space._space:insert{\n"
"        _truncate.id, ADMIN, '_truncate', 'memtx', 0, setmap({}),\n"
"        {{name = 'id', type = 'unsigned'}, {name = 'count', type = 'unsigned'}}\n"
"    }\n"
"\n"
"    log.info(\"create index primary on _truncate\")\n"
"    box.space._index:insert{\n"
"        _truncate.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}\n"
"    }\n"
"\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    _priv:insert{ADMIN, PUBLIC, 'space', _truncate.id, box.priv.W}\n"
"end\n"
"\n"
"local function upgrade_to_1_7_5()\n"
"    create_truncate_space()\n"
"end\n"
"\n"
"local function user_trig_1_7_5(_, tuple)\n"
"    if tuple and not tuple[5] then\n"
"        tuple = tuple:update{{'=', 5, setmap({})}}\n"
"        log.info(\"Set empty password to %s '%s'\", tuple[4], tuple[3])\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"local space_formats_1_7_5 = {\n"
"    _schema = {\n"
"        {name = 'key', type = 'string'},\n"
"    },\n"
"    _space = {\n"
"        {name = 'id', type = 'unsigned'},\n"
"        {name = 'owner', type = 'unsigned'},\n"
"        {name = 'name', type = 'string'},\n"
"        {name = 'engine', type = 'string'},\n"
"        {name = 'field_count', type = 'unsigned'},\n"
"        {name = 'flags', type = 'map'},\n"
"        {name = 'format', type = 'array'},\n"
"    },\n"
"    _index = {\n"
"        {name = 'id', type = 'unsigned'},\n"
"        {name = 'iid', type = 'unsigned'},\n"
"        {name = 'name', type = 'string'},\n"
"        {name = 'type', type = 'string'},\n"
"        {name = 'opts', type = 'map'},\n"
"        {name = 'parts', type = 'array'},\n"
"    },\n"
"    _func = {\n"
"        {name = 'id', type = 'unsigned'},\n"
"        {name = 'owner', type = 'unsigned'},\n"
"        {name = 'name', type = 'string'},\n"
"        {name = 'setuid', type = 'unsigned'},\n"
"    },\n"
"    _user = {\n"
"        {name = 'id', type = 'unsigned'},\n"
"        {name = 'owner', type = 'unsigned'},\n"
"        {name = 'name', type = 'string'},\n"
"        {name = 'type', type = 'string'},\n"
"        {name = 'auth', type = 'map'},\n"
"    },\n"
"    _priv = {\n"
"        {name = 'grantor', type = 'unsigned'},\n"
"        {name = 'grantee', type = 'unsigned'},\n"
"        {name = 'object_type', type = 'string'},\n"
"        {name = 'object_id', type = 'unsigned'},\n"
"        {name = 'privilege', type = 'unsigned'},\n"
"    },\n"
"    _cluster = {\n"
"        {name = 'id', type = 'unsigned'},\n"
"        {name = 'uuid', type = 'string'},\n"
"    },\n"
"}\n"
"\n"
"space_formats_1_7_5._vspace = space_formats_1_7_5._space\n"
"space_formats_1_7_5._vindex = space_formats_1_7_5._index\n"
"space_formats_1_7_5._vfunc = space_formats_1_7_5._func\n"
"space_formats_1_7_5._vuser = space_formats_1_7_5._user\n"
"space_formats_1_7_5._vpriv = space_formats_1_7_5._priv\n"
"\n"
"local function space_trig_1_7_5(_, tuple)\n"
"    if tuple and space_formats_1_7_5[tuple[3]] and\n"
"       not table.equals(space_formats_1_7_5[tuple[3]], tuple[7]) then\n"
"        tuple = tuple:update{{'=', 7, space_formats_1_7_5[tuple[3]]}}\n"
"        log.info(\"Update space '%s' format: new format %s\", tuple[3],\n"
"                 json.encode(tuple[7]))\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"local function initial_1_7_5()\n"
"    -- stick to the following convention:\n"
"    -- prefer user id (owner id) in field #1\n"
"    -- prefer object name in field #2\n"
"    -- index on owner id is index #1\n"
"    -- index on object name is index #2\n"
"    --\n"
"\n"
"    local _schema = box.space[box.schema.SCHEMA_ID]\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local _cluster = box.space[box.schema.CLUSTER_ID]\n"
"    local _truncate = box.space[box.schema.TRUNCATE_ID]\n"
"    local MAP = setmap({})\n"
"\n"
"    --\n"
"    -- _schema\n"
"    --\n"
"    log.info(\"create space _schema\")\n"
"    local format = {}\n"
"    format[1] = {type='string', name='key'}\n"
"    _space:insert{_schema.id, ADMIN, '_schema', 'memtx', 0, MAP, format}\n"
"    log.info(\"create index primary on _schema\")\n"
"    _index:insert{_schema.id, 0, 'primary', 'tree', { unique = true }, {{0, 'string'}}}\n"
"\n"
"    --\n"
"    -- _space\n"
"    --\n"
"    log.info(\"create space _space\")\n"
"    format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='owner', type='unsigned'}\n"
"    format[3] = {name='name', type='string'}\n"
"    format[4] = {name='engine', type='string'}\n"
"    format[5] = {name='field_count', type='unsigned'}\n"
"    format[6] = {name='flags', type='map'}\n"
"    format[7] = {name='format', type='array'}\n"
"    _space:insert{_space.id, ADMIN, '_space', 'memtx', 0, MAP, format}\n"
"    -- space name is unique\n"
"    log.info(\"create index primary on _space\")\n"
"    _index:insert{_space.id, 0, 'primary', 'tree', { unique = true }, {{0, 'unsigned'}}}\n"
"    log.info(\"create index owner on _space\")\n"
"    _index:insert{_space.id, 1, 'owner', 'tree', {unique = false }, {{1, 'unsigned'}}}\n"
"    log.info(\"create index index name on _space\")\n"
"    _index:insert{_space.id, 2, 'name', 'tree', { unique = true }, {{2, 'string'}}}\n"
"    create_sysview(box.schema.SPACE_ID, box.schema.VSPACE_ID)\n"
"\n"
"    --\n"
"    -- _index\n"
"    --\n"
"    log.info(\"create space _index\")\n"
"    format = {}\n"
"    format[1] = {name = 'id', type = 'unsigned'}\n"
"    format[2] = {name = 'iid', type = 'unsigned'}\n"
"    format[3] = {name = 'name', type = 'string'}\n"
"    format[4] = {name = 'type', type = 'string'}\n"
"    format[5] = {name = 'opts', type = 'map'}\n"
"    format[6] = {name = 'parts', type = 'array'}\n"
"    _space:insert{_index.id, ADMIN, '_index', 'memtx', 0, MAP, format}\n"
"    -- index name is unique within a space\n"
"    log.info(\"create index primary on _index\")\n"
"    _index:insert{_index.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}, {1, 'unsigned'}}}\n"
"    log.info(\"create index name on _index\")\n"
"    _index:insert{_index.id, 2, 'name', 'tree', {unique = true}, {{0, 'unsigned'}, {2, 'string'}}}\n"
"    create_sysview(box.schema.INDEX_ID, box.schema.VINDEX_ID)\n"
"\n"
"    --\n"
"    -- _func\n"
"    --\n"
"    log.info(\"create space _func\")\n"
"    format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='owner', type='unsigned'}\n"
"    format[3] = {name='name', type='string'}\n"
"    format[4] = {name='setuid', type='unsigned'}\n"
"    _space:insert{_func.id, ADMIN, '_func', 'memtx', 0, MAP, format}\n"
"    -- function name and id are unique\n"
"    log.info(\"create index _func:primary\")\n"
"    _index:insert{_func.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"    log.info(\"create index _func:owner\")\n"
"    _index:insert{_func.id, 1, 'owner', 'tree', {unique = false}, {{1, 'unsigned'}}}\n"
"    log.info(\"create index _func:name\")\n"
"    _index:insert{_func.id, 2, 'name', 'tree', {unique = true}, {{2, 'string'}}}\n"
"    create_sysview(box.schema.FUNC_ID, box.schema.VFUNC_ID)\n"
"\n"
"    --\n"
"    -- _user\n"
"    --\n"
"    log.info(\"create space _user\")\n"
"    format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='owner', type='unsigned'}\n"
"    format[3] = {name='name', type='string'}\n"
"    format[4] = {name='type', type='string'}\n"
"    format[5] = {name='auth', type='map'}\n"
"    _space:insert{_user.id, ADMIN, '_user', 'memtx', 0, MAP, format}\n"
"    -- user name and id are unique\n"
"    log.info(\"create index _func:primary\")\n"
"    _index:insert{_user.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"    log.info(\"create index _func:owner\")\n"
"    _index:insert{_user.id, 1, 'owner', 'tree', {unique = false}, {{1, 'unsigned'}}}\n"
"    log.info(\"create index _func:name\")\n"
"    _index:insert{_user.id, 2, 'name', 'tree', {unique = true}, {{2, 'string'}}}\n"
"    create_sysview(box.schema.USER_ID, box.schema.VUSER_ID)\n"
"\n"
"    --\n"
"    -- _priv\n"
"    --\n"
"    log.info(\"create space _priv\")\n"
"    format = {}\n"
"    format[1] = {name='grantor', type='unsigned'}\n"
"    format[2] = {name='grantee', type='unsigned'}\n"
"    format[3] = {name='object_type', type='string'}\n"
"    format[4] = {name='object_id', type='unsigned'}\n"
"    format[5] = {name='privilege', type='unsigned'}\n"
"    _space:insert{_priv.id, ADMIN, '_priv', 'memtx', 0, MAP, format}\n"
"    -- user id, object type and object id are unique\n"
"    log.info(\"create index primary on _priv\")\n"
"    _index:insert{_priv.id, 0, 'primary', 'tree', {unique = true}, {{1, 'unsigned'}, {2, 'string'}, {3, 'unsigned'}}}\n"
"    -- owner index  - to quickly find all privileges granted by a user\n"
"    log.info(\"create index owner on _priv\")\n"
"    _index:insert{_priv.id, 1, 'owner', 'tree', {unique = false}, {{0, 'unsigned'}}}\n"
"    -- object index - to quickly find all grants on a given object\n"
"    log.info(\"create index object on _priv\")\n"
"    _index:insert{_priv.id, 2, 'object', 'tree', {unique = false}, {{2, 'string'}, {3, 'unsigned'}}}\n"
"    create_sysview(box.schema.PRIV_ID, box.schema.VPRIV_ID)\n"
"\n"
"    --\n"
"    -- _cluster\n"
"    --\n"
"    log.info(\"create space _cluster\")\n"
"    format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='uuid', type='string'}\n"
"    _space:insert{_cluster.id, ADMIN, '_cluster', 'memtx', 0, MAP, format}\n"
"    -- primary key: node id\n"
"    log.info(\"create index primary on _cluster\")\n"
"    _index:insert{_cluster.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"    -- node uuid key: node uuid\n"
"    log.info(\"create index uuid on _cluster\")\n"
"    _index:insert{_cluster.id, 1, 'uuid', 'tree', {unique = true}, {{1, 'string'}}}\n"
"\n"
"    --\n"
"    -- _truncate\n"
"    --\n"
"    log.info(\"create space _truncate\")\n"
"    format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='count', type='unsigned'}\n"
"    _space:insert{_truncate.id, ADMIN, '_truncate', 'memtx', 0, MAP, format}\n"
"    -- primary key: space id\n"
"    log.info(\"create index primary on _truncate\")\n"
"    _index:insert{_truncate.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"\n"
"    --\n"
"    -- Create users\n"
"    --\n"
"    log.info(\"create user guest\")\n"
"    _user:insert{GUEST, ADMIN, 'guest', 'user',\n"
"                 {['chap-sha1'] = 'vhvewKp0tNyweZQ+cFKAlsyphfg='}}\n"
"    log.info(\"create user admin\")\n"
"    _user:insert{ADMIN, ADMIN, 'admin', 'user', MAP}\n"
"    log.info(\"create role public\")\n"
"    _user:insert{PUBLIC, ADMIN, 'public', 'role', MAP}\n"
"    log.info(\"create role replication\")\n"
"    _user:insert{REPLICATION, ADMIN, 'replication', 'role', MAP}\n"
"\n"
"    --\n"
"    -- Create grants\n"
"    --\n"
"    log.info(\"grant read,write,execute on universe to admin\")\n"
"    _priv:insert{ADMIN, ADMIN, 'universe', 0, box.priv.R + box.priv.W + box.priv.X}\n"
"\n"
"    -- grant role 'public' to 'guest'\n"
"    log.info(\"grant role public to guest\")\n"
"    _priv:insert{ADMIN, GUEST, 'role', PUBLIC, box.priv.X}\n"
"\n"
"    -- replication can read the entire universe\n"
"    log.info(\"grant read on universe to replication\")\n"
"    _priv:replace{ADMIN, REPLICATION, 'universe', 0, box.priv.R}\n"
"    -- replication can append to '_cluster' system space\n"
"    log.info(\"grant write on space _cluster to replication\")\n"
"    _priv:replace{ADMIN, REPLICATION, 'space', _cluster.id, box.priv.W}\n"
"\n"
"    _priv:insert{ADMIN, PUBLIC, 'space', _truncate.id, box.priv.W}\n"
"\n"
"    -- create \"box.schema.user.info\" function\n"
"    log.info('create function \"box.schema.user.info\" with setuid')\n"
"    _func:replace{1, ADMIN, 'box.schema.user.info', 1, 'LUA'}\n"
"\n"
"    -- grant 'public' role access to 'box.schema.user.info' function\n"
"    log.info('grant execute on function \"box.schema.user.info\" to public')\n"
"    _priv:replace{ADMIN, PUBLIC, 'function', 1, box.priv.X}\n"
"\n"
"    log.info(\"set max_id to box.schema.SYSTEM_ID_MAX\")\n"
"    _schema:insert{'max_id', box.schema.SYSTEM_ID_MAX}\n"
"\n"
"    log.info(\"set schema version to 1.7.5\")\n"
"    _schema:insert({'version', 1, 7, 5})\n"
"end\n"
"\n"
"local sequence_format = {{name = 'id', type = 'unsigned'},\n"
"                         {name = 'owner', type = 'unsigned'},\n"
"                         {name = 'name', type = 'string'},\n"
"                         {name = 'step', type = 'integer'},\n"
"                         {name = 'min', type = 'integer'},\n"
"                         {name = 'max', type = 'integer'},\n"
"                         {name = 'start', type = 'integer'},\n"
"                         {name = 'cache', type = 'integer'},\n"
"                         {name = 'cycle', type = 'boolean'}}\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 1.7.6\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function create_sequence_space()\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _sequence = box.space[box.schema.SEQUENCE_ID]\n"
"    local _sequence_data = box.space[box.schema.SEQUENCE_DATA_ID]\n"
"    local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"    local MAP = setmap({})\n"
"\n"
"    log.info(\"create space _sequence\")\n"
"    _space:insert{_sequence.id, ADMIN, '_sequence', 'memtx', 0, MAP, sequence_format}\n"
"    log.info(\"create index _sequence:primary\")\n"
"    _index:insert{_sequence.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"    log.info(\"create index _sequence:owner\")\n"
"    _index:insert{_sequence.id, 1, 'owner', 'tree', {unique = false}, {{1, 'unsigned'}}}\n"
"    log.info(\"create index _sequence:name\")\n"
"    _index:insert{_sequence.id, 2, 'name', 'tree', {unique = true}, {{2, 'string'}}}\n"
"\n"
"    log.info(\"create space _sequence_data\")\n"
"    _space:insert{_sequence_data.id, ADMIN, '_sequence_data', 'memtx', 0, MAP,\n"
"                  {{name = 'id', type = 'unsigned'}, {name = 'value', type = 'integer'}}}\n"
"    log.info(\"create index primary on _sequence_data\")\n"
"    _index:insert{_sequence_data.id, 0, 'primary', 'hash', {unique = true}, {{0, 'unsigned'}}}\n"
"\n"
"    log.info(\"create space _space_sequence\")\n"
"    _space:insert{_space_sequence.id, ADMIN, '_space_sequence', 'memtx', 0, MAP,\n"
"                  {{name = 'id', type = 'unsigned'},\n"
"                   {name = 'sequence_id', type = 'unsigned'},\n"
"                   {name = 'is_generated', type = 'boolean'}}}\n"
"    log.info(\"create index _space_sequence:primary\")\n"
"    _index:insert{_space_sequence.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"    log.info(\"create index _space_sequence:sequence\")\n"
"    _index:insert{_space_sequence.id, 1, 'sequence', 'tree', {unique = false}, {{1, 'unsigned'}}}\n"
"end\n"
"\n"
"local function create_collation_space()\n"
"    local _collation = box.space[box.schema.COLLATION_ID]\n"
"\n"
"    log.info(\"create space _collation\")\n"
"    box.space._space:insert{_collation.id, ADMIN, '_collation', 'memtx', 0, setmap({}),\n"
"        { { name = 'id', type = 'unsigned' }, { name = 'name', type = 'string' },\n"
"          { name = 'owner', type = 'unsigned' }, { name = 'type', type = 'string' },\n"
"          { name = 'locale', type = 'string' }, { name = 'opts', type = 'map' } } }\n"
"\n"
"    log.info(\"create index primary on _collation\")\n"
"    box.space._index:insert{_collation.id, 0, 'primary', 'tree', {unique = true}, {{0, 'unsigned'}}}\n"
"\n"
"    log.info(\"create index name on _collation\")\n"
"    box.space._index:insert{_collation.id, 1, 'name', 'tree', {unique = true}, {{1, 'string'}}}\n"
"\n"
"    log.info(\"create predefined collations\")\n"
"    box.space._collation:replace{1, \"unicode\", ADMIN, \"ICU\", \"\", setmap{}}\n"
"    box.space._collation:replace{2, \"unicode_ci\", ADMIN, \"ICU\", \"\", {strength='primary'}}\n"
"\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    _priv:insert{ADMIN, PUBLIC, 'space', _collation.id, box.priv.W}\n"
"end\n"
"\n"
"local function upgrade_to_1_7_6()\n"
"    create_sequence_space()\n"
"    create_collation_space()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"--- Tarantool 1.7.7\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function upgrade_to_1_7_7()\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    --\n"
"    -- grant 'session' and 'usage' to all existing users\n"
"    --\n"
"    for _, v in _user:pairs() do\n"
"        if v[4] ~= \"role\" then\n"
"            _priv:upsert({ADMIN, v[1], \"universe\", 0, box.priv.S + box.priv.U},\n"
"                                                {{\"|\", 5, box.priv.S + box.priv.U}})\n"
"        end\n"
"    end\n"
"    --\n"
"    -- grant 'create' to all users with 'read' and 'write'\n"
"    -- on the universe, since going forward we will require\n"
"    -- 'create' rather than 'read,write' to be able to create\n"
"    -- objects\n"
"    --\n"
"    for _, v in _priv.index.object:pairs{'universe'} do\n"
"        if bit.band(v[5], 1) ~= 0 and bit.band(v[5], 2) ~= 0 then\n"
"            _priv:update({v[2], v[3], v[4]}, {{ \"|\", 5, box.priv.C}})\n"
"        end\n"
"    end\n"
"    -- grant admin all new privileges (session, usage, grant option,\n"
"    -- create, alter, drop and anything that might come up in the future\n"
"    --\n"
"    _priv:upsert({ADMIN, ADMIN, 'universe', 0, box.priv.ALL},\n"
"                 {{ \"|\", 5, box.priv.ALL}})\n"
"    --\n"
"    -- create role 'super' and grant it all privileges on universe\n"
"    --\n"
"    _user:replace{SUPER, ADMIN, 'super', 'role', setmap({})}\n"
"    _priv:replace({ADMIN, SUPER, 'universe', 0, 4294967295})\n"
"end\n"
"\n"
"local function priv_trig_1_7_7(_, tuple)\n"
"    if tuple and tuple[2] == ADMIN and tuple[3] == 'universe' and\n"
"       tuple[5] ~= box.priv.ALL then\n"
"        tuple = tuple:update{{'=', 5, box.priv.ALL}}\n"
"        log.info(\"Grant all privileges to user 'admin'\")\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"--- Tarantool 1.10.0\n"
"--------------------------------------------------------------------------------\n"
"local function create_vsequence_space()\n"
"    create_sysview(box.schema.SEQUENCE_ID, box.schema.VSEQUENCE_ID)\n"
"    box.space._space:update({box.schema.VSEQUENCE_ID},\n"
"                            {{'=', 7, sequence_format}})\n"
"end\n"
"\n"
"local function upgrade_to_1_10_0()\n"
"    create_vsequence_space()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"--- Tarantool 1.10.2\n"
"--------------------------------------------------------------------------------\n"
"local function upgrade_priv_to_1_10_2()\n"
"    local _priv = box.space._priv\n"
"    local _vpriv = box.space._vpriv\n"
"    local _space = box.space._space\n"
"    local _index = box.space._index\n"
"    _space:update({_priv.id}, {{'=', '[7][4].type', 'scalar'}})\n"
"    _space:update({_vpriv.id}, {{'=', '[7][4].type', 'scalar'}})\n"
"    _index:update({_priv.id, _priv.index.primary.id},\n"
"                  {{'=', 6, {{1, 'unsigned'}, {2, 'string'}, {3, 'scalar'}}}})\n"
"    _index:update({_vpriv.id, _vpriv.index.primary.id},\n"
"                  {{'=', 6, {{1, 'unsigned'}, {2, 'string'}, {3, 'scalar'}}}})\n"
"    _index:update({_priv.id, _priv.index.object.id},\n"
"                  {{'=', 6, {{2, 'string'}, {3, 'scalar'}}}})\n"
"    _index:update({_vpriv.id, _priv.index.object.id},\n"
"                  {{'=', 6, {{2, 'string'}, {3, 'scalar'}}}})\n"
"end\n"
"\n"
"local function create_vinyl_deferred_delete_space()\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _vinyl_deferred_delete = box.space[box.schema.VINYL_DEFERRED_DELETE_ID]\n"
"\n"
"    local format = {}\n"
"    format[1] = {name = 'space_id', type = 'unsigned'}\n"
"    format[2] = {name = 'lsn', type = 'unsigned'}\n"
"    format[3] = {name = 'tuple', type = 'array'}\n"
"\n"
"    log.info(\"create space _vinyl_deferred_delete\")\n"
"    _space:insert{_vinyl_deferred_delete.id, ADMIN, '_vinyl_deferred_delete',\n"
"                  'blackhole', 0, {group_id = 1}, format}\n"
"end\n"
"\n"
"local function upgrade_to_1_10_2()\n"
"    upgrade_priv_to_1_10_2()\n"
"    create_vinyl_deferred_delete_space()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.1.0\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function upgrade_priv_to_2_1_0()\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    -- Since we remove 1.7 compatibility in 2.1.0, we have to\n"
"    -- grant ALTER and DROP to all users with READ + WRITE on\n"
"    -- respective objects. We also grant CREATE on entities\n"
"    -- or on universe if a user has READ and WRITE on an entity\n"
"    -- or on universe respectively. We do not grant CREATE on\n"
"    -- objects, since it has no effect. We also skip grants for\n"
"    -- sequences since they were added after the new privileges\n"
"    -- and compatibility mode was always off for them.\n"
"    for _, user in _user:pairs() do\n"
"        if user[0] ~= ADMIN and user[0] ~= SUPER then\n"
"            for _, priv in _priv:pairs(user[0]) do\n"
"                if priv[3] ~= 'sequence' and\n"
"                   bit.band(priv[5], box.priv.W) ~= 0 and\n"
"                   bit.band(priv[5], box.priv.R) ~= 0 then\n"
"                    local new_privs = bit.bor(box.priv.A, box.priv.D)\n"
"                    if priv[3] == 'universe' or priv[4] == '' then\n"
"                        new_privs = bit.bor(new_privs, box.priv.C)\n"
"                    end\n"
"                    _priv:update({priv[2], priv[3], priv[4]},\n"
"                                 {{\"|\", 5, new_privs}})\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_to_2_1_0()\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _trigger = box.space[box.schema.TRIGGER_ID]\n"
"    local MAP = setmap({})\n"
"\n"
"    log.info(\"create space _trigger\")\n"
"    local format = {{name='name', type='string'},\n"
"                    {name='space_id', type='unsigned'},\n"
"                    {name='opts', type='map'}}\n"
"    _space:insert{_trigger.id, ADMIN, '_trigger', 'memtx', 0, MAP, format}\n"
"\n"
"    log.info(\"create index primary on _trigger\")\n"
"    _index:insert{_trigger.id, 0, 'primary', 'tree', { unique = true },\n"
"                  {{0, 'string'}}}\n"
"    log.info(\"create index secondary on _trigger\")\n"
"    _index:insert{_trigger.id, 1, 'space_id', 'tree', { unique = false },\n"
"                  {{1, 'unsigned'}}}\n"
"\n"
"    local fk_constr_ft = {{name='name', type='string'},\n"
"                          {name='child_id', type='unsigned'},\n"
"                          {name='parent_id', type='unsigned'},\n"
"                          {name='is_deferred', type='boolean'},\n"
"                          {name='match', type='string'},\n"
"                          {name='on_delete', type='string'},\n"
"                          {name='on_update', type='string'},\n"
"                          {name='child_cols', type='array'},\n"
"                          {name='parent_cols', type='array'}}\n"
"    log.info(\"create space _fk_constraint\")\n"
"    _space:insert{box.schema.FK_CONSTRAINT_ID, ADMIN, '_fk_constraint', 'memtx',\n"
"                  0, setmap({}), fk_constr_ft}\n"
"\n"
"    log.info(\"create index primary on _fk_constraint\")\n"
"    _index:insert{box.schema.FK_CONSTRAINT_ID, 0, 'primary', 'tree',\n"
"                  {unique = true}, {{0, 'string'}, {1, 'unsigned'}}}\n"
"\n"
"    log.info(\"create secondary index child_id on _fk_constraint\")\n"
"    _index:insert{box.schema.FK_CONSTRAINT_ID, 1, 'child_id', 'tree',\n"
"                  {unique = false}, {{1, 'unsigned'}}}\n"
"\n"
"    -- Nullability wasn't skipable. This was fixed in 1-7.\n"
"    -- Now, abscent field means NULL, so we can safely set second\n"
"    -- field in format, marking it nullable.\n"
"    log.info(\"Add nullable value field to space _schema\")\n"
"    local format = {}\n"
"    format[1] = {type='string', name='key'}\n"
"    format[2] = {type='any', name='value', is_nullable=true}\n"
"    _space:update({box.schema.SCHEMA_ID}, {{'=', 7, format}})\n"
"\n"
"    box.space._collation:replace{0, \"none\", ADMIN, \"BINARY\", \"\", setmap{}}\n"
"    box.space._collation:replace{3, \"binary\", ADMIN, \"BINARY\", \"\", setmap{}}\n"
"\n"
"    upgrade_priv_to_2_1_0()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.1.1\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function upgrade_to_2_1_1()\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    for _, index in _index:pairs() do\n"
"        local opts = index[5]\n"
"        if opts['sql'] ~= nil then\n"
"            opts['sql'] = nil\n"
"            _index:replace(box.tuple.new({index.id, index.iid, index.name,\n"
"                                        index.type, opts, index.parts}))\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.1.2\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function update_collation_strength_field()\n"
"    local _collation = box.space[box.schema.COLLATION_ID]\n"
"    for _, collation in _collation:pairs() do\n"
"        if collation[4] == 'ICU' and collation[6].strength == nil then\n"
"            local new_collation = collation:totable()\n"
"            new_collation[6].strength = 'tertiary'\n"
"            _collation:delete{collation[1]}\n"
"            _collation:insert(new_collation)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_to_2_1_2()\n"
"    update_collation_strength_field()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.1.3\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- Add new collations\n"
"local function upgrade_collation_to_2_1_3()\n"
"    local coll_lst = {\n"
"        {name=\"af\", loc_str=\"af\"},  -- Afrikaans\n"
"        {name=\"am\", loc_str=\"am\"},  -- Amharic (no character changes, just re-ordering)\n"
"        {name=\"ar\", loc_str=\"ar\"},  -- Arabic (use only \"standard\")\n"
"        {name=\"as\", loc_str=\"as\"},  -- Assamese\n"
"        {name=\"az\", loc_str=\"az\"},  -- Azerbaijani (Azeri)\n"
"        {name=\"be\", loc_str=\"be\"},  -- Belarusian\n"
"        {name=\"bn\", loc_str=\"bn\"},  -- Bengali (Bangla actually)\n"
"        {name=\"bs\", loc_str=\"bs\"},  -- Bosnian (tailored as Croatian)\n"
"        {name=\"bs_Cyrl\", loc_str=\"bs_Cyrl\"}, -- Bosnian in Cyrillic (tailored as Serbian)\n"
"        {name=\"ca\", loc_str=\"ca\"},  -- Catalan\n"
"        {name=\"cs\", loc_str=\"cs\"},  -- Czech\n"
"        {name=\"cy\", loc_str=\"cy\"},  -- Welsh\n"
"        {name=\"da\", loc_str=\"da\"},  -- Danish\n"
"        {name=\"de__phonebook\", loc_str=\"de_DE_u_co_phonebk\"}, -- German (umlaut as 'ae', 'oe', 'ue')\n"
"        {name=\"de_AT_phonebook\", loc_str=\"de_AT_u_co_phonebk\"}, -- Austrian German (umlaut primary greater)\n"
"        {name=\"dsb\", loc_str=\"dsb\"}, -- Lower Sorbian\n"
"        {name=\"ee\", loc_str=\"ee\"},  -- Ewe\n"
"        {name=\"eo\", loc_str=\"eo\"},  -- Esperanto\n"
"        {name=\"es\", loc_str=\"es\"},  -- Spanish\n"
"        {name=\"es__traditional\", loc_str=\"es_u_co_trad\"}, -- Spanish ('ch' and 'll' as a grapheme)\n"
"        {name=\"et\", loc_str=\"et\"},  -- Estonian\n"
"        {name=\"fa\", loc_str=\"fa\"},  -- Persian\n"
"        {name=\"fi\", loc_str=\"fi\"},  -- Finnish (v and w are primary equal)\n"
"        {name=\"fi__phonebook\", loc_str=\"fi_u_co_phonebk\"}, -- Finnish (v and w as separate characters)\n"
"        {name=\"fil\", loc_str=\"fil\"}, -- Filipino\n"
"        {name=\"fo\", loc_str=\"fo\"},  -- Faroese\n"
"        {name=\"fr_CA\", loc_str=\"fr_CA\"}, -- Canadian French\n"
"        {name=\"gu\", loc_str=\"gu\"},  -- Gujarati\n"
"        {name=\"ha\", loc_str=\"ha\"},  -- Hausa\n"
"        {name=\"haw\", loc_str=\"haw\"}, -- Hawaiian\n"
"        {name=\"he\", loc_str=\"he\"},  -- Hebrew\n"
"        {name=\"hi\", loc_str=\"hi\"},  -- Hindi\n"
"        {name=\"hr\", loc_str=\"hr\"},  -- Croatian\n"
"        {name=\"hu\", loc_str=\"hu\"},  -- Hungarian\n"
"        {name=\"hy\", loc_str=\"hy\"},  -- Armenian\n"
"        {name=\"ig\", loc_str=\"ig\"},  -- Igbo\n"
"        {name=\"is\", loc_str=\"is\"},  -- Icelandic\n"
"        {name=\"ja\", loc_str=\"ja\"},  -- Japanese\n"
"        {name=\"kk\", loc_str=\"kk\"},  -- Kazakh\n"
"        {name=\"kl\", loc_str=\"kl\"},  -- Kalaallisut\n"
"        {name=\"kn\", loc_str=\"kn\"},  -- Kannada\n"
"        {name=\"ko\", loc_str=\"ko\"},  -- Korean\n"
"        {name=\"kok\", loc_str=\"kok\"}, -- Konkani\n"
"        {name=\"ky\", loc_str=\"ky\"},  -- Kyrgyz\n"
"        {name=\"lkt\", loc_str=\"lkt\"}, -- Lakota\n"
"        {name=\"ln\", loc_str=\"ln\"},  -- Lingala\n"
"        {name=\"lt\", loc_str=\"lt\"},  -- Lithuanian\n"
"        {name=\"lv\", loc_str=\"lv\"},  -- Latvian\n"
"        {name=\"mk\", loc_str=\"mk\"},  -- Macedonian\n"
"        {name=\"ml\", loc_str=\"ml\"},  -- Malayalam\n"
"        {name=\"mr\", loc_str=\"mr\"},  -- Marathi\n"
"        {name=\"mt\", loc_str=\"mt\"},  -- Maltese\n"
"        {name=\"nb\", loc_str=\"nb\"},  -- Norwegian Bokmal\n"
"        {name=\"nn\", loc_str=\"nn\"},  -- Norwegian Nynorsk\n"
"        {name=\"nso\", loc_str=\"nso\"}, -- Northern Sotho\n"
"        {name=\"om\", loc_str=\"om\"},  -- Oromo\n"
"        {name=\"or\", loc_str=\"or\"},  -- Oriya (Odia)\n"
"        {name=\"pa\", loc_str=\"pa\"},  -- Punjabi\n"
"        {name=\"pl\", loc_str=\"pl\"},  -- Polish\n"
"        {name=\"ro\", loc_str=\"ro\"},  -- Romanian\n"
"        {name=\"sa\", loc_str=\"sa\"},  -- Sanskrit\n"
"        {name=\"se\", loc_str=\"se\"},  -- Northern Sami\n"
"        {name=\"si\", loc_str=\"si\"},  -- Sinhala\n"
"        {name=\"si__dictionary\", loc_str=\"si_u_co_dict\"}, -- Sinhala (U+0DA5 = U+0DA2,0DCA,0DA4)\n"
"        {name=\"sk\", loc_str=\"sk\"},  -- Slovak\n"
"        {name=\"sl\", loc_str=\"sl\"},  -- Slovenian\n"
"        {name=\"sq\", loc_str=\"sq\"},  -- Albanian (just \"standard\")\n"
"        {name=\"sr\", loc_str=\"sr\"},  -- Serbian\n"
"        {name=\"sr_Latn\", loc_str=\"sr_Latn\"}, -- Serbian in Latin (tailored as Croatian)\n"
"        {name=\"sv\", loc_str=\"sv\"},  -- Swedish (v and w are primary equal)\n"
"        {name=\"sv__reformed\", loc_str=\"sv_u_co_reformed\"}, -- Swedish (v and w as separate characters)\n"
"        {name=\"ta\", loc_str=\"ta\"},  -- Tamil\n"
"        {name=\"te\", loc_str=\"te\"},  -- Telugu\n"
"        {name=\"th\", loc_str=\"th\"},  -- Thai\n"
"        {name=\"tn\", loc_str=\"tn\"},  -- Tswana\n"
"        {name=\"to\", loc_str=\"to\"},  -- Tonga\n"
"        {name=\"tr\", loc_str=\"tr\"},  -- Turkish\n"
"        {name=\"ug_Cyrl\", loc_str=\"ug\"}, -- Uyghur in Cyrillic - is there such locale\?\n"
"        {name=\"uk\", loc_str=\"uk\"},  -- Ukrainian\n"
"        {name=\"ur\", loc_str=\"ur\"},  -- Urdu\n"
"        {name=\"vi\", loc_str=\"vi\"},  -- Vietnamese\n"
"        {name=\"vo\", loc_str=\"vo\"},  -- Volapük\n"
"        {name=\"wae\", loc_str=\"wae\"}, -- Walser\n"
"        {name=\"wo\", loc_str=\"wo\"},  -- Wolof\n"
"        {name=\"yo\", loc_str=\"yo\"},  -- Yoruba\n"
"        {name=\"zh\", loc_str=\"zh\"},  -- Chinese\n"
"        {name=\"zh__big5han\", loc_str=\"zh_u_co_big5han\"},  -- Chinese (ideographs: big5 order)\n"
"        {name=\"zh__gb2312han\", loc_str=\"zh_u_co_gb2312\"}, -- Chinese (ideographs: GB-2312 order)\n"
"        {name=\"zh__pinyin\", loc_str=\"zh_u_co_pinyin\"}, -- Chinese (ideographs: pinyin order)\n"
"        {name=\"zh__stroke\", loc_str=\"zh_u_co_stroke\"}, -- Chinese (ideographs: stroke order)\n"
"        {name=\"zh__zhuyin\", loc_str=\"zh_u_co_zhuyin\"}, -- Chinese (ideographs: zhuyin order)\n"
"    }\n"
"    local coll_strengths = {\n"
"        {s=\"s1\", opt={strength='primary'}},\n"
"        {s=\"s2\", opt={strength='secondary'}},\n"
"        {s=\"s3\", opt={strength='tertiary'}}\n"
"    }\n"
"\n"
"    local id = 4\n"
"    for _, collation in ipairs(coll_lst) do\n"
"        for _, strength in ipairs(coll_strengths) do\n"
"            local coll_name = 'unicode_' .. collation.name .. \"_\" .. strength.s\n"
"            log.info(\"creating collation %s\", coll_name)\n"
"            box.space._collation:replace{id, coll_name, ADMIN, \"ICU\", collation.loc_str, strength.opt }\n"
"            id = id + 1\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_to_2_1_3()\n"
"    upgrade_collation_to_2_1_3()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.2.1\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- Add sequence field to _space_sequence table\n"
"local function upgrade_sequence_to_2_2_1()\n"
"    log.info(\"add sequence field to space _space_sequence\")\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"    for _, v in _space_sequence:pairs() do\n"
"        if #v > 3 then\n"
"            -- Must be a sequence created after upgrade.\n"
"            -- It doesn't need to get updated.\n"
"            goto continue\n"
"        end\n"
"        -- Explicitly attach the sequence to the first index part.\n"
"        local pk = _index:get{v[1], 0}\n"
"        local part = pk[6][1]\n"
"        local field = part.field or part[1]\n"
"        local path = part.path or ''\n"
"        local t = _space_sequence:get(v[1])\n"
"        -- Update in-place is banned due to complexity of its\n"
"        -- handling. Delete + insert still work.\n"
"        t = t:update({{'!', 4, field}, {'!', 5, path}})\n"
"        _space_sequence:delete({v[1]})\n"
"        _space_sequence:insert(t)\n"
"        ::continue::\n"
"    end\n"
"    _space:update({_space_sequence.id}, {\n"
"        {'=', '[7][4]', {name = 'field', type = 'unsigned'}},\n"
"        {'=', '[7][5]', {name = 'path', type = 'string'}},\n"
"    })\n"
"end\n"
"\n"
"local function upgrade_ck_constraint_to_2_2_1()\n"
"    -- In previous Tarantool releases check constraints were\n"
"    -- stored in space opts. Now we use separate space\n"
"    -- _ck_constraint for this purpose. Perform legacy data\n"
"    -- migration.\n"
"    local MAP = setmap({})\n"
"    local _space = box.space._space\n"
"    local _index = box.space._index\n"
"    local _ck_constraint = box.space._ck_constraint\n"
"    log.info(\"create space _ck_constraint\")\n"
"    local format = {{name='space_id', type='unsigned'},\n"
"                    {name='name', type='string'},\n"
"                    {name='is_deferred', type='boolean'},\n"
"                    {name='language', type='str'}, {name='code', type='str'}}\n"
"    _space:insert{_ck_constraint.id, ADMIN, '_ck_constraint', 'memtx', 0, MAP, format}\n"
"\n"
"    log.info(\"create index primary on _ck_constraint\")\n"
"    _index:insert{_ck_constraint.id, 0, 'primary', 'tree',\n"
"                  {unique = true}, {{0, 'unsigned'}, {1, 'string'}}}\n"
"\n"
"    for _, space in _space:pairs() do\n"
"        local id = space[1]\n"
"        local name = space[3]\n"
"        local flags = space[6]\n"
"        if flags.checks then\n"
"            for i, check in pairs(flags.checks) do\n"
"                local expr_str = check.expr\n"
"                local check_name = check.name or\n"
"                                   \"CK_CONSTRAINT_\" .. i .. \"_\" .. name\n"
"                _ck_constraint:insert({id, check_name, false, 'SQL', expr_str})\n"
"            end\n"
"            flags.checks = nil\n"
"            _space:update({id}, {{'=', 6, flags}})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function create_vcollation_space()\n"
"    local _space = box.space._space\n"
"    local format = _space:get({box.schema.COLLATION_ID})[7]\n"
"    create_sysview(box.schema.COLLATION_ID, box.schema.VCOLLATION_ID)\n"
"    _space:update({box.schema.VCOLLATION_ID}, {{'=', 7, format}})\n"
"end\n"
"\n"
"local function upgrade_func_to_2_2_1()\n"
"    log.info(\"Update _func format\")\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"    for _, v in box.space._func:pairs() do\n"
"        _func:replace({v[1], v[2], v[3], v[4], v[5] or 'LUA', '', 'function',\n"
"                      {}, 'any', 'none', 'none', false, false, true,\n"
"                      v[15] or {'LUA'}, setmap({}), '', datetime, datetime})\n"
"    end\n"
"    local sql_builtin_list = {\n"
"        \"TRIM\", \"TYPEOF\", \"PRINTF\", \"UNICODE\", \"CHAR\", \"HEX\", \"VERSION\",\n"
"        \"QUOTE\", \"REPLACE\", \"SUBSTR\", \"GROUP_CONCAT\", \"JULIANDAY\", \"DATE\",\n"
"        \"TIME\", \"DATETIME\", \"STRFTIME\", \"CURRENT_TIME\", \"CURRENT_TIMESTAMP\",\n"
"        \"CURRENT_DATE\", \"LENGTH\", \"POSITION\", \"ROUND\", \"UPPER\", \"LOWER\",\n"
"        \"IFNULL\", \"RANDOM\", \"CEIL\", \"CEILING\", \"CHARACTER_LENGTH\",\n"
"        \"CHAR_LENGTH\", \"FLOOR\", \"MOD\", \"OCTET_LENGTH\", \"ROW_COUNT\", \"COUNT\",\n"
"        \"LIKE\", \"ABS\", \"EXP\", \"LN\", \"POWER\", \"SQRT\", \"SUM\", \"TOTAL\", \"AVG\",\n"
"        \"RANDOMBLOB\", \"NULLIF\", \"ZEROBLOB\", \"MIN\", \"MAX\", \"COALESCE\", \"EVERY\",\n"
"        \"EXISTS\", \"EXTRACT\", \"SOME\", \"GREATER\", \"LESSER\", \"SOUNDEX\",\n"
"        \"LIKELIHOOD\", \"LIKELY\", \"UNLIKELY\", \"_sql_stat_get\", \"_sql_stat_push\",\n"
"        \"_sql_stat_init\",\n"
"    }\n"
"    for _, v in pairs(sql_builtin_list) do\n"
"        local t = _func:auto_increment({ADMIN, v, 1, 'SQL_BUILTIN', '',\n"
"                                       'function', {}, 'any', 'none', 'none',\n"
"                                        false, false, true, {}, setmap({}), '',\n"
"                                        datetime, datetime})\n"
"        _priv:replace{ADMIN, PUBLIC, 'function', t[1], box.priv.X}\n"
"    end\n"
"    local t = _func:auto_increment({ADMIN, 'LUA', 1, 'LUA',\n"
"                        'function(code) return assert(loadstring(code))() end',\n"
"                        'function', {'string'}, 'any', 'none', 'none',\n"
"                        false, false, true, {'LUA', 'SQL'},\n"
"                        setmap({}), '', datetime, datetime})\n"
"    _priv:replace{ADMIN, PUBLIC, 'function', t[1], box.priv.X}\n"
"    local format = {}\n"
"    format[1] = {name='id', type='unsigned'}\n"
"    format[2] = {name='owner', type='unsigned'}\n"
"    format[3] = {name='name', type='string'}\n"
"    format[4] = {name='setuid', type='unsigned'}\n"
"    format[5] = {name='language', type='string'}\n"
"    format[6] = {name='body', type='string'}\n"
"    format[7] = {name='routine_type', type='string'}\n"
"    format[8] = {name='param_list', type='array'}\n"
"    format[9] = {name='returns', type='string'}\n"
"    format[10] = {name='aggregate', type='string'}\n"
"    format[11] = {name='sql_data_access', type='string'}\n"
"    format[12] = {name='is_deterministic', type='boolean'}\n"
"    format[13] = {name='is_sandboxed', type='boolean'}\n"
"    format[14] = {name='is_null_call', type='boolean'}\n"
"    format[15] = {name='exports', type='array'}\n"
"    format[16] = {name='opts', type='map'}\n"
"    format[17] = {name='comment', type='string'}\n"
"    format[18] = {name='created', type='string'}\n"
"    format[19] = {name='last_altered', type='string'}\n"
"    box.space._space:update({_func.id}, {{'=', 7, format}})\n"
"    box.space._index:update(\n"
"        {_func.id, _func.index.name.id},\n"
"        {{'=', 6, {{field = 2, type = 'string', collation = 2}}}})\n"
"end\n"
"\n"
"local function create_func_index()\n"
"    log.info(\"Create _func_index space\")\n"
"    local _func_index = box.space[box.schema.FUNC_INDEX_ID]\n"
"    local _space = box.space._space\n"
"    local _index = box.space._index\n"
"    local format = {{name='space_id', type='unsigned'},\n"
"                    {name='index_id', type='unsigned'},\n"
"                    {name='func_id',  type='unsigned'}}\n"
"    _space:insert{_func_index.id, ADMIN, '_func_index', 'memtx', 0,\n"
"                  setmap({}), format}\n"
"    _index:insert{_func_index.id, 0, 'primary', 'tree', {unique = true},\n"
"                  {{0, 'unsigned'}, {1, 'unsigned'}}}\n"
"    _index:insert{_func_index.id, 1, 'fid', 'tree', {unique = false},\n"
"                  {{2, 'unsigned'}}}\n"
"\n"
"end\n"
"\n"
"local function upgrade_to_2_2_1()\n"
"    upgrade_sequence_to_2_2_1()\n"
"    upgrade_ck_constraint_to_2_2_1()\n"
"    create_vcollation_space()\n"
"    upgrade_func_to_2_2_1()\n"
"    create_func_index()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.3.0\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function upgrade_to_2_3_0()\n"
"    log.info(\"Create GREATEST and LEAST SQL Builtins\")\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"    local new_builtins = {\"GREATEST\", \"LEAST\"}\n"
"    for _, v in pairs(new_builtins) do\n"
"        local t = _func:auto_increment({ADMIN, v, 1, 'SQL_BUILTIN', '',\n"
"                                       'function', {}, 'any', 'none', 'none',\n"
"                                        false, false, true, {}, setmap({}), '',\n"
"                                        datetime, datetime})\n"
"        _priv:replace{ADMIN, PUBLIC, 'function', t[1], box.priv.X}\n"
"    end\n"
"\n"
"    log.info(\"Extend _ck_constraint space format with is_enabled field\")\n"
"    local _ck_constraint = box.space._ck_constraint\n"
"    for _, tuple in _ck_constraint:pairs() do\n"
"        _ck_constraint:update({tuple[1], tuple[2]}, {{'=', 6, true}})\n"
"    end\n"
"    local format = {{name='space_id', type='unsigned'},\n"
"                    {name='name', type='string'},\n"
"                    {name='is_deferred', type='boolean'},\n"
"                    {name='language', type='str'},\n"
"                    {name='code', type='str'},\n"
"                    {name='is_enabled', type='boolean'}}\n"
"    _space:update({_ck_constraint.id}, {{'=', 7, format}})\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.3.1\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local function drop_func_collation()\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    box.space._index:update({_func.id, _func.index.name.id},\n"
"                            {{'=', 6, {{2, 'string'}}}})\n"
"end\n"
"\n"
"local function create_session_settings_space()\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local format = {}\n"
"    format[1] = {name='name', type='string'}\n"
"    format[2] = {name='value', type='any'}\n"
"    log.info(\"create space _session_settings\")\n"
"    _space:insert{box.schema.SESSION_SETTINGS_ID, ADMIN, '_session_settings',\n"
"                  'service', 2, {temporary = true}, format}\n"
"    log.info(\"create index _session_settings:primary\")\n"
"    _index:insert{box.schema.SESSION_SETTINGS_ID, 0, 'primary', 'tree',\n"
"                  {unique = true}, {{0, 'string'}}}\n"
"end\n"
"\n"
"local function upgrade_to_2_3_1()\n"
"    drop_func_collation()\n"
"    create_session_settings_space()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.7.1\n"
"--------------------------------------------------------------------------------\n"
"local function function_access()\n"
"    local _func = box.space._func\n"
"    local _priv = box.space._priv\n"
"    local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"    local funcs_to_change = {'LUA', 'box.schema.user.info'}\n"
"    for _, name in pairs(funcs_to_change) do\n"
"        local func = _func.index['name']:get(name)\n"
"        if func ~= nil and func.setuid ~= 0 then\n"
"            local id = func[1]\n"
"            log.info('remove old function \"'..name..'\"')\n"
"            _priv:delete({2, 'function', id})\n"
"            _func:delete({id})\n"
"            log.info('create function \"'..name..'\" with unset setuid')\n"
"            local new_func = func:update({{'=', 4, 0}, {'=', 18, datetime},\n"
"                                          {'=', 19, datetime}})\n"
"            _func:replace(new_func)\n"
"            log.info('grant execute on function \"'..name..'\" to public')\n"
"            _priv:replace{ADMIN, PUBLIC, 'function', id, box.priv.X}\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_to_2_7_1()\n"
"    function_access()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.9.1\n"
"--------------------------------------------------------------------------------\n"
"local function remove_sql_builtin_functions_from_func()\n"
"    local _func = box.space._func\n"
"    local _priv = box.space._priv\n"
"    for _, v in _func:pairs() do\n"
"        local id = v[1]\n"
"        local language = v[5]\n"
"        if language == \"SQL_BUILTIN\" then\n"
"            _priv:delete({2, 'function', id})\n"
"            _func:delete({id})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_to_2_9_1()\n"
"    remove_sql_builtin_functions_from_func()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.10.1\n"
"--------------------------------------------------------------------------------\n"
"local function grant_rw_access_on__session_settings_to_role_public()\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    log.info(\"grant read,write access on _session_settings space to public role\")\n"
"    _priv:replace({ADMIN, PUBLIC, 'space', box.schema.SESSION_SETTINGS_ID,\n"
"                   box.priv.R + box.priv.W})\n"
"end\n"
"\n"
"local function upgrade_to_2_10_1()\n"
"    grant_rw_access_on__session_settings_to_role_public()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.10.4\n"
"--------------------------------------------------------------------------------\n"
"local function revoke_execute_access_to_lua_function_from_role_public()\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    if box.func.LUA then\n"
"        local row = _priv:get{PUBLIC, 'function', box.func.LUA.id}\n"
"        local privilege = row and row[5] or nil\n"
"        if privilege and bit.band(privilege, box.priv.X) ~= 0 then\n"
"            local privilege = bit.bxor(privilege, box.priv.X)\n"
"            -- Note that X privilege sometimes implies R privilege,\n"
"            -- for example executable functions are visible in _vfunc.\n"
"            -- Let's make minimal changes, leaving R privilege instead of X.\n"
"            privilege = bit.bor(privilege, box.priv.R)\n"
"            log.info(\"revoke execute access to 'LUA' function from public role\")\n"
"            _priv:update({PUBLIC, 'function', box.func.LUA.id},\n"
"                         {{'=', 5, privilege}})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function make_vfunc_same_format_as_func()\n"
"    log.info(\"Make format of _vfunc the same as the format of _func\")\n"
"    local format = box.space._space:get({box.schema.FUNC_ID})[7]\n"
"    box.space._space:update({box.schema.VFUNC_ID}, {{'=', 7, format}})\n"
"end\n"
"\n"
"local function upgrade_to_2_10_4()\n"
"    revoke_execute_access_to_lua_function_from_role_public()\n"
"    make_vfunc_same_format_as_func()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.10.5\n"
"--------------------------------------------------------------------------------\n"
"local function create_vspace_sequence_space()\n"
"    create_sysview(box.schema.SPACE_SEQUENCE_ID, box.schema.VSPACE_SEQUENCE_ID)\n"
"end\n"
"\n"
"local function upgrade_to_2_10_5()\n"
"    create_vspace_sequence_space()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.11.0\n"
"--------------------------------------------------------------------------------\n"
"local function revoke_write_access_on__collation_from_role_public()\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    log.info(\"revoke write access on _collation space from public role\")\n"
"    _priv:delete{PUBLIC, 'space', box.schema.COLLATION_ID}\n"
"end\n"
"\n"
"local function convert_sql_constraints_to_tuple_constraints()\n"
"    local _space = box.space._space\n"
"    local _fk = box.space[box.schema.FK_CONSTRAINT_ID]\n"
"    local _ck = box.space[box.schema.CK_CONSTRAINT_ID]\n"
"    log.info(\"convert constraints from _ck_constraint and _fk_constraint\")\n"
"    for _, v in _fk:pairs() do\n"
"        local name = v[1]\n"
"        local child_id = v[2]\n"
"        local parent_id = v[3]\n"
"        local child_cols = v[8]\n"
"        local parent_cols = v[9]\n"
"        local def = _space:get{child_id}\n"
"        local mapping = setmap({})\n"
"        for i, id in pairs(child_cols) do\n"
"            mapping[id] = parent_cols[i]\n"
"        end\n"
"        local fk = def[6].foreign_key or {}\n"
"        fk[name] = {space = parent_id, field = mapping}\n"
"        _space:update({child_id}, {{'=', '[6].foreign_key', fk}})\n"
"        _fk:delete({name, child_id})\n"
"    end\n"
"    for _, v in _ck:pairs() do\n"
"        local space_id = v[1]\n"
"        local name = v[2]\n"
"        local code = v[5]\n"
"        local _func = box.space._func\n"
"        local def = _space:get{space_id}\n"
"        local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"        local func_name = 'check_' .. def[3] .. '_' .. name\n"
"        local t = _func:auto_increment({ADMIN, func_name, 1, 'SQL_EXPR', code,\n"
"                                       'function', {}, 'any', 'none', 'none',\n"
"                                        true, true, true, {'LUA'}, setmap({}),\n"
"                                        '', datetime, datetime})\n"
"        local ck = def.flags.constraint or {}\n"
"        ck[name] = t[1]\n"
"        _space:update({space_id}, {{'=', '[6].constraint', ck}})\n"
"        _ck:delete({space_id, name})\n"
"    end\n"
"end\n"
"\n"
"local function add_user_auth_history_and_last_modified()\n"
"    log.info(\"add auth_history and last_modified fields to space _user\")\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    local _vuser = box.space[box.schema.VUSER_ID]\n"
"    for _, v in _user:pairs() do\n"
"        if #v == 5 then\n"
"            _user:update(v[1], {{'=', 6, {}}, {'=', 7, 0}})\n"
"        end\n"
"    end\n"
"    local ops = {\n"
"        {'=', '[7][6]', {name = 'auth_history', type = 'array'}},\n"
"        {'=', '[7][7]', {name = 'last_modified', type = 'unsigned'}},\n"
"    }\n"
"    _space:update({_user.id}, ops)\n"
"    _space:update({_vuser.id}, ops)\n"
"end\n"
"\n"
"local function upgrade_to_2_11_0()\n"
"    revoke_write_access_on__collation_from_role_public()\n"
"    convert_sql_constraints_to_tuple_constraints()\n"
"    add_user_auth_history_and_last_modified()\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.11.1\n"
"--------------------------------------------------------------------------------\n"
"local function drop_schema_max_id()\n"
"    log.info(\"drop field max_id in space _schema\")\n"
"    box.space._schema:delete(\"max_id\")\n"
"end\n"
"\n"
"local function upgrade_to_2_11_1()\n"
"    drop_schema_max_id()\n"
"end\n"
"--------------------------------------------------------------------------------\n"
"\n"
"local handlers = {\n"
"    {version = mkversion(1, 7, 5), func = upgrade_to_1_7_5},\n"
"    {version = mkversion(1, 7, 6), func = upgrade_to_1_7_6},\n"
"    {version = mkversion(1, 7, 7), func = upgrade_to_1_7_7},\n"
"    {version = mkversion(1, 10, 0), func = upgrade_to_1_10_0},\n"
"    {version = mkversion(1, 10, 2), func = upgrade_to_1_10_2},\n"
"    {version = mkversion(2, 1, 0), func = upgrade_to_2_1_0},\n"
"    {version = mkversion(2, 1, 1), func = upgrade_to_2_1_1},\n"
"    {version = mkversion(2, 1, 2), func = upgrade_to_2_1_2},\n"
"    {version = mkversion(2, 1, 3), func = upgrade_to_2_1_3},\n"
"    {version = mkversion(2, 2, 1), func = upgrade_to_2_2_1},\n"
"    {version = mkversion(2, 3, 0), func = upgrade_to_2_3_0},\n"
"    {version = mkversion(2, 3, 1), func = upgrade_to_2_3_1},\n"
"    {version = mkversion(2, 7, 1), func = upgrade_to_2_7_1},\n"
"    {version = mkversion(2, 9, 1), func = upgrade_to_2_9_1},\n"
"    {version = mkversion(2, 10, 1), func = upgrade_to_2_10_1},\n"
"    {version = mkversion(2, 10, 4), func = upgrade_to_2_10_4},\n"
"    {version = mkversion(2, 10, 5), func = upgrade_to_2_10_5},\n"
"    {version = mkversion(2, 11, 0), func = upgrade_to_2_11_0},\n"
"    {version = mkversion(2, 11, 1), func = upgrade_to_2_11_1},\n"
"}\n"
"\n"
"-- Schema version of the snapshot.\n"
"local function get_version()\n"
"    local version = ffi.C.box_dd_version_id()\n"
"    local major = bit.band(bit.rshift(version, 16), 0xff)\n"
"    local minor = bit.band(bit.rshift(version, 8), 0xff)\n"
"    local patch = bit.band(version, 0xff)\n"
"\n"
"    return mkversion(major, minor, patch),\n"
"           string.format(\"%s.%s.%s\", major, minor, patch)\n"
"end\n"
"\n"
"local function schema_needs_upgrade()\n"
"    -- Schema needs upgrade if current schema version is greater\n"
"    -- than schema version of the snapshot.\n"
"    local schema_version, schema_version_str = get_version()\n"
"    if schema_version ~= nil and\n"
"        handlers[#handlers].version > schema_version then\n"
"        return true, schema_version_str\n"
"    end\n"
"    return false\n"
"end\n"
"\n"
"local trig_oldest_version = nil\n"
"\n"
"-- Some schema changes before version 1.7.7 make it impossible to recover from\n"
"-- older snapshot. The table below consists of before_replace triggers on system\n"
"-- spaces, which make old snapshot schema compatible with current Tarantool\n"
"-- (version 2.x). The triggers replace old format tuples with new ones\n"
"-- in-memory, thus making it possible to recover from a rather old snapshot\n"
"-- (up to schema version 1.6.8). Once the snapshot is recovered, a normal\n"
"-- upgrade procedure may set schema version to the latest one.\n"
"--\n"
"-- The triggers mostly repeat the corresponding upgrade_to_1_7_x functions,\n"
"-- which were used when pre-1.7.x snapshot schema was still recoverable.\n"
"--\n"
"-- When the triggers are used (i.e. when snapshot schema version is below 1.7.5,\n"
"-- the upgrade procedure works as follows:\n"
"-- * first the snapshot is recovered and 1.7.5-compatible schema is applied to\n"
"--   it in-memory with the help of triggers.\n"
"-- * then usual upgrade_to_X_X_X() handlers may be fired to turn schema into the\n"
"--   latest one.\n"
"local recovery_triggers = {\n"
"    {version = mkversion(1, 7, 1), tbl = {\n"
"        _user   = user_trig_1_7_1,\n"
"    }},\n"
"    {version = mkversion(1, 7, 2), tbl = {\n"
"        _index = index_trig_1_7_2,\n"
"    }},\n"
"    {version = mkversion(1, 7, 5), tbl = {\n"
"        _space = space_trig_1_7_5,\n"
"        _user  = user_trig_1_7_5,\n"
"    }},\n"
"    {version = mkversion(1, 7, 7), tbl = {\n"
"        _priv   = priv_trig_1_7_7,\n"
"    }},\n"
"}\n"
"\n"
"-- Once newer schema version is recovered (say, from an xlog following the old\n"
"-- snapshot), the triggers helping recover the old schema should be removed.\n"
"local function schema_trig_last(_, tuple)\n"
"    if tuple and tuple[1] == 'version' then\n"
"        local version = version_from_tuple(tuple)\n"
"        if version then\n"
"            log.info(\"Recovery trigger: recovered schema version %s. \"..\n"
"                     \"Removing outdated recovery triggers.\", version)\n"
"            box.internal.clear_recovery_triggers(version)\n"
"            trig_oldest_version = version\n"
"        end\n"
"    end\n"
"    return tuple\n"
"end\n"
"\n"
"recovery_triggers[#recovery_triggers].tbl['_schema'] = schema_trig_last\n"
"\n"
"local function on_init_set_recovery_triggers()\n"
"    log.info(\"Recovering snapshot with schema version %s\", trig_oldest_version)\n"
"    for _, trig_tbl in ipairs(recovery_triggers) do\n"
"        if trig_tbl.version > trig_oldest_version then\n"
"            for space, trig in pairs(trig_tbl.tbl) do\n"
"                box.space[space]:before_replace(trig)\n"
"                log.info(\"Set recovery trigger on space '%s' to comply with \"..\n"
"                         \"version %s format\", space, trig_tbl.version)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function set_recovery_triggers(version)\n"
"    trig_oldest_version = version\n"
"    box.ctl.on_schema_init(on_init_set_recovery_triggers)\n"
"end\n"
"\n"
"local function clear_recovery_triggers(version)\n"
"    for _, trig_tbl in ipairs(recovery_triggers) do\n"
"        if trig_tbl.version > trig_oldest_version and\n"
"           (not version or trig_tbl.version <= version) then\n"
"            for space, trig in pairs(trig_tbl.tbl) do\n"
"                box.space[space]:before_replace(nil, trig)\n"
"                log.info(\"Remove recovery trigger on space '%s' for version %s\",\n"
"                         space, trig_tbl.version)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function upgrade_from(version)\n"
"    if version < mkversion(1, 6, 8) then\n"
"        log.warn('can upgrade from 1.6.8 only')\n"
"        return\n"
"    end\n"
"\n"
"    for _, handler in ipairs(handlers) do\n"
"        if version >= handler.version then\n"
"            goto continue\n"
"        end\n"
"        handler.func()\n"
"        log.info(\"set schema version to %s\", handler.version)\n"
"        box.space._schema:replace({'version',\n"
"                                   handler.version.major,\n"
"                                   handler.version.minor,\n"
"                                   handler.version.patch})\n"
"        ::continue::\n"
"    end\n"
"end\n"
"\n"
"local function upgrade()\n"
"    upgrade_from(get_version())\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Downgrade part\n"
"--------------------------------------------------------------------------------\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.9.1\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- See remove_sql_builtin_functions_from_func and upgrades adding\n"
"-- SQL_BUILTIN functions.\n"
"local function restore_sql_builtin_functions(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"    local sql_builtin_list = {\n"
"        \"TRIM\", \"TYPEOF\", \"PRINTF\", \"UNICODE\", \"CHAR\", \"HEX\", \"VERSION\",\n"
"        \"QUOTE\", \"REPLACE\", \"SUBSTR\", \"GROUP_CONCAT\", \"JULIANDAY\", \"DATE\",\n"
"        \"TIME\", \"DATETIME\", \"STRFTIME\", \"CURRENT_TIME\", \"CURRENT_TIMESTAMP\",\n"
"        \"CURRENT_DATE\", \"LENGTH\", \"POSITION\", \"ROUND\", \"UPPER\", \"LOWER\",\n"
"        \"IFNULL\", \"RANDOM\", \"CEIL\", \"CEILING\", \"CHARACTER_LENGTH\",\n"
"        \"CHAR_LENGTH\", \"FLOOR\", \"MOD\", \"OCTET_LENGTH\", \"ROW_COUNT\", \"COUNT\",\n"
"        \"LIKE\", \"ABS\", \"EXP\", \"LN\", \"POWER\", \"SQRT\", \"SUM\", \"TOTAL\", \"AVG\",\n"
"        \"RANDOMBLOB\", \"NULLIF\", \"ZEROBLOB\", \"MIN\", \"MAX\", \"COALESCE\", \"EVERY\",\n"
"        \"EXISTS\", \"EXTRACT\", \"SOME\", \"GREATER\", \"LESSER\", \"SOUNDEX\",\n"
"        \"LIKELIHOOD\", \"LIKELY\", \"UNLIKELY\", \"_sql_stat_get\", \"_sql_stat_push\",\n"
"        \"_sql_stat_init\", \"GREATEST\", \"LEAST\",\n"
"    }\n"
"    local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"    local _func = box.space._func\n"
"    -- Otherwise we can't insert SQL_BUILTIN function. It is prohibited\n"
"    -- to add since 2.9.0.\n"
"    with_disabled_system_triggers(function()\n"
"        for _, func in ipairs(sql_builtin_list) do\n"
"            if _func.index.name:get(func) == nil then\n"
"                local t = _func:auto_increment{\n"
"                    ADMIN, func, 1, 'SQL_BUILTIN', '', 'function', {}, 'any',\n"
"                    'none', 'none', false, false, true, {}, setmap({}), '',\n"
"                    datetime, datetime}\n"
"                box.space._priv:replace{ADMIN, PUBLIC, 'function', t.id,\n"
"                                        box.priv.X}\n"
"            end\n"
"        end\n"
"    end)\n"
"end\n"
"\n"
"local function downgrade_from_2_9_1(issue_handler)\n"
"    restore_sql_builtin_functions(issue_handler)\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.10.0\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- See tarantool 2.10.0-beta2-169-gb9f6d3858.\n"
"local function remove_deferred_deletes(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"    log.info(\"remove defer_deletes from space options\")\n"
"    for _, space in box.space._space:pairs() do\n"
"        local new_flags = table.copy(space.flags)\n"
"        if new_flags.defer_deletes ~= nil then\n"
"            new_flags.defer_deletes = nil\n"
"            setmap(new_flags)\n"
"            box.space._space:update(space.id, {{'=', 'flags', new_flags}})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool-ee 2.10.0-beta2-97-g042a213.\n"
"local function disable_background_space_upgrade(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        if space.flags.upgrade then\n"
"            issue_handler(\n"
"                \"Background update is active in space '%s'. \" ..\n"
"                \"It is supported starting from version 2.10.0.\",\n"
"                space.name)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool 2.10.0-beta2-140-ga51313a45.\n"
"local function disable_tuple_compression(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        for _, format in pairs(space.format) do\n"
"            if format.compression then\n"
"                issue_handler(\n"
"                    \"Tuple compression is found in space '%s', field '%s'. \" ..\n"
"                    \"It is supported starting from version 2.10.0.\",\n"
"                    space.name, format.name)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool 2.10.0-beta2-200-gd950fdde4.\n"
"local function disable_core_field_foreign_key_constraints(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        for _, format in pairs(space.format) do\n"
"            if format.foreign_key then\n"
"                issue_handler(\n"
"                    \"Foreign key constraint is found in space '%s',\" ..\n"
"                    \" field '%s'. It is supported starting from\" ..\n"
"                    \" version 2.10.0.\",\n"
"                    space.name, format.name)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- Since we cannot distinguish between manually created core tuple foreign keys\n"
"-- and core tuple foreign keys generated by SQL foreign key conversion, we must\n"
"-- convert all core tuple foreign keys to SQL foreign keys. SQL foreign key were\n"
"-- converted to core foreign keys in tarantool 2.11.0-entrypoint-740-g930674810.\n"
"--\n"
"local function convert_tuple_foreing_keys_to_sql_foreing_keys(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"\n"
"    log.info(\"convert tuple foreign keys to SQL foreign keys\")\n"
"    local _fk = box.space._fk_constraint\n"
"    for _, space in box.space._space:pairs() do\n"
"        local new_space = space:totable()\n"
"        local is_space_changed = false\n"
"        if space.flags.foreign_key then\n"
"            for name, value in pairs(space.flags.foreign_key) do\n"
"                local parent_id = value.space or space.id\n"
"                local child_cols = {}\n"
"                local parent_cols = {}\n"
"                for k, v in pairs(value.field) do\n"
"                    table.insert(child_cols, k)\n"
"                    table.insert(parent_cols, v)\n"
"                end\n"
"                _fk:replace{name, space.id, parent_id, false, \"full\",\n"
"                            \"no_action\", \"no_action\", child_cols, parent_cols}\n"
"                new_space[6].foreign_key[name] = nil\n"
"                is_space_changed = true\n"
"            end\n"
"            new_space[6].foreign_key = nil\n"
"        end\n"
"        if is_space_changed then\n"
"            box.space._space:replace(new_space)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool 2.10.0-beta2-194-ged9b982d3.\n"
"local function disable_core_field_constraints(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        for _, format in pairs(space.format) do\n"
"            if format.constraint then\n"
"                issue_handler(\n"
"                    \"Field constraint is found in space '%s', field '%s'. \" ..\n"
"                    \"It is supported starting from version 2.10.0.\",\n"
"                    space.name, format.name)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool 2.10.0-beta2-196-g53f5d4e79.\n"
"local function disable_core_tuple_constraints(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        if space.flags.constraint then\n"
"            for name, _ in pairs(space.flags.constraint) do\n"
"                if issue_handler.constraints[name] == nil then\n"
"                    issue_handler(\n"
"                        \"Tuple constraint is found in space '%s'. \" ..\n"
"                        \"It is supported starting from version 2.10.0.\",\n"
"                        space.name)\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool 2.10.0-beta1-376-gd2a012455\n"
"local function disable_takes_raw_args(issue_handler)\n"
"    for _, func in box.space._func:pairs() do\n"
"        if func.opts.takes_raw_args then\n"
"            issue_handler(\n"
"                \"takes_raw_args option is set for function '%s'\" ..\n"
"                \" It is supported starting from version 2.10.0.\",\n"
"                func.name)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function downgrade_from_2_10_0(issue_handler)\n"
"    remove_deferred_deletes(issue_handler)\n"
"    disable_background_space_upgrade(issue_handler)\n"
"    disable_tuple_compression(issue_handler)\n"
"    disable_core_field_foreign_key_constraints(issue_handler)\n"
"    convert_tuple_foreing_keys_to_sql_foreing_keys(issue_handler)\n"
"    disable_core_field_constraints(issue_handler)\n"
"    disable_core_tuple_constraints(issue_handler)\n"
"    disable_takes_raw_args(issue_handler)\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.10.5\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- See create_vspace_sequence_space.\n"
"local function drop_vspace_sequence_space(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"    log.info(\"revoke grants for 'public' role for _vspace_sequence\")\n"
"    box.space._priv:delete{PUBLIC, 'space', box.schema.VSPACE_SEQUENCE_ID}\n"
"    local indexes = box.space._index:select(box.schema.VSPACE_SEQUENCE_ID)\n"
"    -- Otherwise we can't drop neither the primary index nor the space.\n"
"    with_disabled_system_triggers(function()\n"
"        for _, index in pairs(indexes) do\n"
"            log.info(\"drop index %s on _vspace_sequence\", index[3])\n"
"            box.space._index:delete{index[1], index[2]}\n"
"        end\n"
"        log.info(\"drop view _vspace_sequence\")\n"
"        box.space._space:delete{box.schema.VSPACE_SEQUENCE_ID}\n"
"    end)\n"
"end\n"
"\n"
"local function downgrade_from_2_10_5(issue_handler)\n"
"    drop_vspace_sequence_space(issue_handler)\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.11.0\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- See tarantool-ee 2.11.0-entrypoint-97-g67fccd4.\n"
"local function disable_zlib_tuple_compression(issue_handler)\n"
"    for _, space in box.space._space:pairs() do\n"
"        for _, format in pairs(space.format) do\n"
"            if format.compression and format.compression == 'zlib' then\n"
"                issue_handler(\n"
"                    \"Tuple compression with 'zlib' algo is found in\" ..\n"
"                    \" space '%s', field '%s'. \" ..\n"
"                    \"It is supported starting from version 2.11.0.\",\n"
"                    space.name, format.name)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- See tarantool 2.11.0-entrypoint-740-g930674810 and\n"
"-- tarantool 2.11.0-entrypoint-409-g0dea6493f.\n"
"--\n"
"local function convert_tuple_constraints_to_sql_check_constraints(issue_handler)\n"
"    if not issue_handler.dry_run then\n"
"        log.info(\"convert tuple constraints to SQL check constraints\")\n"
"    end\n"
"    local funcs = {}\n"
"    local _ck = box.space._ck_constraint\n"
"    for _, space in box.space._space:pairs() do\n"
"        local new_space = space:totable()\n"
"        local is_space_changed = false\n"
"        if space.flags.constraint then\n"
"            for name, func_id in pairs(space.flags.constraint) do\n"
"                local func = box.space._func:get{func_id}\n"
"                if func ~= nil and func.language == 'SQL_EXPR' then\n"
"                    funcs[func_id] = true\n"
"                    if not issue_handler.dry_run then\n"
"                        _ck:replace{space.id, name, false, \"SQL\", func.body,\n"
"                                    true}\n"
"                        new_space[6].constraint[name] = nil\n"
"                        is_space_changed = true\n"
"                    else\n"
"                        issue_handler.constraints[name] = true\n"
"                    end\n"
"                end\n"
"            end\n"
"            if not issue_handler.dry_run and\n"
"               next(new_space[6].constraint) == nil then\n"
"                new_space[6].constraint = nil\n"
"            end\n"
"        end\n"
"        if is_space_changed then\n"
"            box.space._space:replace(new_space)\n"
"            for id, _ in pairs(funcs) do\n"
"                box.space._func:delete(id)\n"
"                funcs[id] = nil\n"
"            end\n"
"        end\n"
"    end\n"
"    for _, func in box.space._func:pairs() do\n"
"        if func.language == 'SQL_EXPR' and funcs[func.id] == nil then\n"
"            issue_handler(\n"
"                \"Function '%s' has language type SQL_EXPR. \" ..\n"
"                \"It is supported starting from version 2.11.0.\",\n"
"                func.name)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- See tarantool-ee 2.11.0-entrypoint-104-ga005915.\n"
"local function disable_pap_sha256_auth_method(issue_handler)\n"
"    for _, user in box.space._user:pairs() do\n"
"        for k in pairs(user.auth) do\n"
"            if k == \"pap-sha256\" then\n"
"                issue_handler(\n"
"                    \"Auth type 'pap-sha256' is found for user '%s'. \" ..\n"
"                    \"It is supported starting from version 2.11.0.\",\n"
"                    user.name)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- Check corresponding upgrade's add_user_auth_history_and_last_modified.\n"
"-- See also tarantool 2.11.0-entrypoint-821-g1c33484d5.\n"
"local function remove_user_auth_history_and_last_modified(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"    log.info(\"remove auth_history and last_modified fields from space _user\")\n"
"    local ops = {{'#', '[7][6]', 2}}\n"
"    if box.space._space:get(box.space._user.id)[7][6] ~= nil then\n"
"        box.space._space:update(box.space._user.id, ops)\n"
"    end\n"
"    if box.space._space:get(box.space._vuser.id)[7][6] ~= nil then\n"
"        box.space._space:update(box.space._vuser.id, ops)\n"
"    end\n"
"    for _, user in box.space._user:pairs() do\n"
"        if #user == 7 then\n"
"            box.space._user:update(user[1], {{'#', 6, 2}})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function downgrade_from_2_11_0(issue_handler)\n"
"    disable_zlib_tuple_compression(issue_handler)\n"
"    convert_tuple_constraints_to_sql_check_constraints(issue_handler)\n"
"    disable_pap_sha256_auth_method(issue_handler)\n"
"    remove_user_auth_history_and_last_modified(issue_handler)\n"
"end\n"
"\n"
"--------------------------------------------------------------------------------\n"
"-- Tarantool 2.11.1\n"
"--------------------------------------------------------------------------------\n"
"\n"
"-- See drop_schema_max_id.\n"
"local function add_schema_max_id(issue_handler)\n"
"    if issue_handler.dry_run then\n"
"        return\n"
"    end\n"
"    log.info(\"add field max_id to space _schema\")\n"
"    local max_id = box.space._space.index.primary:max()[1]\n"
"    if max_id < box.schema.SYSTEM_ID_MAX then\n"
"        max_id = box.schema.SYSTEM_ID_MAX\n"
"    end\n"
"    box.space._schema:replace({\"max_id\", max_id})\n"
"end\n"
"\n"
"local function downgrade_from_2_11_1(issue_handler)\n"
"    add_schema_max_id(issue_handler)\n"
"end\n"
"\n"
"-- Versions should be ordered from newer to older.\n"
"--\n"
"-- Every step can be called in 2 modes. In dry_run mode (issue_handler.dry_run\n"
"-- is set) step should only check for downgrade issues that cannot be handled\n"
"-- without client help. In this mode step should NOT apply any changes.\n"
"-- In regular mode (issue_handler.dry_run is not set) step should actually\n"
"-- apply the required changes.\n"
"--\n"
"-- NOTICE: all downgrade steps SHOULD be idempotent.\n"
"--\n"
"-- We require steps to be idempotent because downgrade steps are run not\n"
"-- considering current schema version. For example when downgrade('2.10.0') is\n"
"-- run on Tarantool version 2.11.0 then step for 2.10.5 will be applied.\n"
"-- It will be applied if schema version is 2.11.0 and it will be applied\n"
"-- if schema version is 2.10.0.\n"
"--\n"
"local downgrade_handlers = {\n"
"    {version = mkversion(2, 11, 1), func = downgrade_from_2_11_1},\n"
"    {version = mkversion(2, 11, 0), func = downgrade_from_2_11_0},\n"
"    {version = mkversion(2, 10, 5), func = downgrade_from_2_10_5},\n"
"    {version = mkversion(2, 10, 0), func = downgrade_from_2_10_0},\n"
"    {version = mkversion(2, 9, 1), func = downgrade_from_2_9_1},\n"
"}\n"
"\n"
"-- This downgrade issue handler is used to raise an error when issue is\n"
"-- encountered.\n"
"local downgrade_raise_error = {}\n"
"\n"
"local downgrade_raise_error_mt = {\n"
"    __call = function(self, fmt, ...)\n"
"        error(string.format(fmt, ...))\n"
"    end\n"
"}\n"
"\n"
"downgrade_raise_error.new = function()\n"
"    local handler = {}\n"
"    return setmetatable(handler, downgrade_raise_error_mt)\n"
"end\n"
"\n"
"-- This downgrade issue handler is used to collect all downgrade issues.\n"
"local downgrade_list_issue = {}\n"
"\n"
"local downgrade_list_issue_mt = {\n"
"    __call = function(self, fmt, ...)\n"
"        table.insert(self.list, string.format(fmt, ...))\n"
"    end\n"
"}\n"
"\n"
"downgrade_list_issue.new = function()\n"
"    local handler = {}\n"
"    handler.list = {}\n"
"    handler.dry_run = true\n"
"    handler.constraints = {}\n"
"    return setmetatable(handler, downgrade_list_issue_mt)\n"
"end\n"
"\n"
"-- Find schema version which does not require upgrade for given application\n"
"-- version. For example:\n"
"--\n"
"-- app2schema_version(mkversion('2.10.3')) == mkversion('2.10.1')\n"
"-- app2schema_version(mkversion('2.10.0')) == mkversion('2.9.1')\n"
"local function app2schema_version(app_version)\n"
"    local schema_version\n"
"    for _, handler in ipairs(handlers) do\n"
"        if handler.version > app_version then\n"
"            break\n"
"        end\n"
"        schema_version = handler.version\n"
"    end\n"
"    return schema_version\n"
"end\n"
"\n"
"-- Call required downgrade step given application version we downgrade to.\n"
"-- Version should have mkversion type.\n"
"local function downgrade_steps(version, issue_handler)\n"
"    for _, handler in ipairs(downgrade_handlers) do\n"
"        if handler.version < version then\n"
"            break\n"
"        end\n"
"        if handler.version ~= version then\n"
"            handler.func(issue_handler)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- List of all Tarantool releases we can downgrade to.\n"
"local downgrade_versions = {\n"
"    \"2.8.2\",\n"
"    \"2.8.3\",\n"
"    \"2.8.4\",\n"
"    \"2.10.0\",\n"
"    \"2.10.1\",\n"
"    \"2.10.2\",\n"
"    \"2.10.3\",\n"
"    \"2.10.4\",\n"
"    \"2.10.5\",\n"
"    \"2.11.0\",\n"
"    \"2.11.1\",\n"
"}\n"
"\n"
"-- Downgrade or list downgrade issues depending of dry_run argument value.\n"
"--\n"
"-- If dry_run is true then list downgrade issues.  if dry_run is false then\n"
"-- downgrade.\n"
"--\n"
"-- In case of downgrade check for issues is done before making any changes.\n"
"-- If any issue is found then downgrade is failed and no any changes are done.\n"
"local function downgrade_impl(version_str, dry_run)\n"
"    box.internal.check_param(version_str, 'version_str', 'string')\n"
"    local version = mkversion.parse(version_str)\n"
"    if fun.index(version_str, downgrade_versions) == nil then\n"
"        error(\"Downgrade is only possible to version listed in\" ..\n"
"              \" box.schema.downgrade_versions().\")\n"
"    end\n"
"\n"
"    local schema_version_cur = get_version()\n"
"    local schema_version_dst = app2schema_version(version)\n"
"    if schema_version_cur < schema_version_dst then\n"
"        local err = \"Cannot downgrade as current schema version %s is older\" ..\n"
"                    \" then schema version %s for Tarantool %s\"\n"
"        error(err:format(schema_version_cur, schema_version_dst, version))\n"
"    end\n"
"\n"
"    local issue_handler = downgrade_list_issue.new()\n"
"    downgrade_steps(version, issue_handler)\n"
"    if dry_run then\n"
"        return issue_handler.list\n"
"    end\n"
"\n"
"    if #issue_handler.list > 0 then\n"
"        local err = issue_handler.list[1]\n"
"        if #issue_handler.list > 1 then\n"
"            local more = \" There are more downgrade issues. To list them\" ..\n"
"                         \" all call box.schema.downgrade_issues.\"\n"
"            err = err .. more\n"
"        end\n"
"        error(err)\n"
"    end\n"
"\n"
"    downgrade_steps(version, downgrade_raise_error.new())\n"
"\n"
"    log.info(\"set schema version to %s\", version)\n"
"    box.space._schema:replace{'version',\n"
"                              schema_version_dst.major,\n"
"                              schema_version_dst.minor,\n"
"                              schema_version_dst.patch}\n"
"end\n"
"\n"
"local function bootstrap()\n"
"    -- Disabling system triggers doesn't turn off space format checks.\n"
"    -- Since a system space format may be updated during the bootstrap\n"
"    -- sequence, we clear all formats so that we can insert any data\n"
"    -- into system spaces and reset them back after we're done.\n"
"    clear_system_formats()\n"
"\n"
"    with_disabled_system_triggers(function()\n"
"        -- erase current schema\n"
"        erase()\n"
"        -- insert initial schema\n"
"        initial_1_7_5()\n"
"        -- upgrade schema to the latest version\n"
"        upgrade_from(mkversion(1, 7, 5))\n"
"    end)\n"
"\n"
"    reset_system_formats()\n"
"\n"
"    -- save new bootstrap.snap\n"
"    box.snapshot()\n"
"end\n"
"\n"
"box.schema.upgrade = upgrade\n"
"box.schema.downgrade_versions = function()\n"
"    return table.copy(downgrade_versions)\n"
"end\n"
"box.schema.downgrade = function(version) downgrade_impl(version, false) end\n"
"box.schema.downgrade_issues = function(version)\n"
"    return downgrade_impl(version, true)\n"
"end\n"
"box.internal.bootstrap = bootstrap;\n"
"box.internal.schema_needs_upgrade = schema_needs_upgrade;\n"
"box.internal.get_snapshot_version = get_snapshot_version;\n"
"box.internal.set_recovery_triggers = set_recovery_triggers;\n"
"box.internal.clear_recovery_triggers = clear_recovery_triggers;\n"
""
;
