const char help_en_US_lua[] =
"--- help (en_US) 2.x\n"
"\n"
"return {\n"
"    help = [[\n"
"To get help, see the Tarantool manual at https://tarantool.io/en/doc/\n"
"To start the interactive Tarantool tutorial, type 'tutorial()' here.\n"
"\n"
"Available backslash commands:\n"
"\n"
"  \\set language <language>   -- set language (lua or sql)\n"
"  \\set output <format>       -- set output format (lua[,line|block] or yaml)\n"
"  \\set delimiter <delimiter> -- set expression delimiter\n"
"  \\help                      -- show this screen\n"
"  \\quit                      -- quit interactive console\n"
"]];\n"
"    tutorial = {\n"
"    [[\n"
"Tutorial -- Screen #1 -- Hello, Moon\n"
"====================================\n"
"\n"
"Welcome to the Tarantool tutorial.\n"
"It will introduce you to Tarantool’s Lua application server\n"
"and database server, which is what’s running what you’re seeing.\n"
"This is INTERACTIVE -- you’re expected to enter requests\n"
"based on the suggestions or examples in the screen’s text.\n"
"\n"
"The first request is:\n"
"\n"
"5.1, \"Olá\", \"Lua\"\n"
"------------------\n"
"\n"
"This isn’t your grandfather’s \"Hello World\" ...\n"
"the decimal literal 5.1 and the two strings inside\n"
"single quotes (\"Hello Moon\" in Portuguese) will just\n"
"be repeated, without need for a print() statement.\n"
"\n"
"Take that one-line request and enter it below after the\n"
"\"tarantool>\" prompt, then type Enter.\n"
"You’ll see the response:\n"
"---\n"
"- 5.1\n"
"- Olá\n"
"- Lua\n"
"...\n"
"Then you’ll get a chance to repeat -- perhaps entering\n"
"something else such as \"Longer String\",-1,-3,0.\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")>.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #2 -- Variables\n"
"==================================\n"
"\n"
"Improve on \"5.1, \"Olá\", \"Lua\"\"\n"
"by using variables rather than literals,\n"
"and put the strings inside braces, which means\n"
"they’re elements of a TABLE.\n"
"More in the Lua manual: https://www.lua.org/pil/2.html\n"
"\n"
"You don’t need to declare variables in advance\n"
"because Lua figures out the data type from what\n"
"you assign to it. Assignment is done with the \"=\" operator.\n"
"\n"
"If the data type of variable t is table, then the\n"
"elements can be referenced as t[1], t[2], and so on.\n"
"More in the Lua manual: https://www.lua.org/pil/2.5.html\n"
"\n"
"Request #2 is:\n"
"\n"
"n = 5.1\n"
"t = {\"Olá\", \"Lua\"}\n"
"n, t[1], t[2]\n"
"------------------\n"
"\n"
"Take all the three lines and enter them below after the\n"
"\"tarantool>\" prompt, then type Enter.\n"
"Or try different values in a different order.\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")>.\n"
"Or, to go to the previous screen, enter <tutorial(\"prev\")>.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #3 -- Loops\n"
"==============================\n"
"\n"
"Add action by using loops rather than static displays.\n"
"There are several syntaxes for loops in Lua,\n"
"but we’ll just use one:\n"
"for variable-name = start-value, end-value, 1 do loop-body end\n"
"which is good enough if you want to assign a\n"
"start-value to a variable, do what’s in the loop body,\n"
"add 1 to the variable, and repeat until it equals end-value.\n"
"More in the Lua manual: https://www.lua.org/pil/4.3.4.html.\n"
"\n"
"Request #3 is:\n"
"\n"
"result_table = {}\n"
"n = 5.1\n"
"for i=1,2,1 do result_table[i] = n * i end\n"
"result_table\n"
"------------------------------------------\n"
"\n"
"Take all four lines and enter them below after the\n"
"\"tarantool>\" prompt, then type Enter.\n"
"For adventure, change the loop to \"for i=1,3,1\"\n"
"(don’t worry, it won’t crash).\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")>.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #4 -- Operators\n"
"==================================\n"
"\n"
"Among the many operators that Lua supports, you most often see:\n"
"For arithmetic: * (multiply), + (add), - (subtract), / (divide).\n"
"For strings: .. (concatenate)\n"
"More in the Lua manual: https://www.lua.org/pil/3.1.html\n"
"\n"
"Request #4 is:\n"
"\n"
"n = 5.1\n"
"t = {\"Olá\", \"Lua\"}\n"
"for i=1,2,1 do n = n * 2 t[1] = t[1] .. t[2] end\n"
"n,t[1],t[2]\n"
"------------------------------------------------\n"
"\n"
"Before you type that in and see Tarantool display the result,\n"
"try to predict whether the display will be\n"
"(a) 20.4 OláLuaLua Lua\n"
"(b) 10.2 Olá Lua Lua Lua\n"
"(c) 5.1 Olá Lua\n"
"\n"
"The answer will appear when you type in the request.\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")>.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #5 -- Conditions\n"
"===================================\n"
"\n"
"A condition involves a comparison operator such as \"==\",\n"
"\">\", \">=\", \"<\", \"<=\". Conditions are used in statements\n"
"of the form if ... then.\n"
"More in the Lua manual: https://www.lua.org/pil/4.3.1.html\n"
"\n"
"Request #5 is:\n"
"\n"
"x = 17\n"
"if x * 2 > 34 then result = x else result = \"no\" end\n"
"result\n"
"----------------------------------------------------\n"
"\n"
"Before you type in those three lines and see Tarantool display\n"
"the result, try to predict whether the display will be\n"
"(a) 17\n"
"(b) 34\n"
"(c) no\n"
"The answer will appear when you type in the request.\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")>.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #6 -- Delimiters\n"
"===================================\n"
"\n"
"This is just to prepare for later exercises\n"
"which will go over many lines. There is a\n"
"Tarantool instruction that means <don’t execute\n"
"every time I type Enter; wait until I type a\n"
"special string called the \"delimiter\".>\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/reference/reference_lua/console/#console-delimiter\n"
"\n"
"Request #6 is:\n"
"\n"
"console = require(\"console\"); console.delimiter(\"!\")\n"
"----------------------------------------------------\n"
"\n"
"It’s not an exercise -- just do it.\n"
"Cancelling the delimiter could be done with\n"
"console.delimiter(\"\")!\n"
"but you’ll see \"!\" in following exercises.\n"
"\n"
"You'll need a custom delimiter only in the trial console at\n"
"https://tarantool.io/en/try-dev/.\n"
"Tarantool console in production is smarter.\n"
"It can tell when a multi-line request has not ended (for example,\n"
"if it sees that a function declaration does not have an end keyword,\n"
"as we'll be writing on the next screen).\n"
"\n"
"When you’re ready to go to the next screen, enter <tutorial(\"next\")!>.\n"
"Yes, <tutorial(\"next\")!> now has to end with an exclamation mark too!\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #7 -- Simple functions\n"
"=========================================\n"
"\n"
"A function, or a stored procedure that returns a value,\n"
"is a named set of Lua requests whose simplest form is\n"
"function function_name () body end\n"
"More in the Lua manual: https://www.lua.org/pil/5.html\n"
"\n"
"Request #7 is:\n"
"\n"
"n = 0\n"
"function func ()\n"
"for i=1,100,1 do n = n + i end\n"
"return n\n"
"end!\n"
"func()!\n"
"------------------------------\n"
"\n"
"This defines a function which sums all the numbers\n"
"between 1 and 100, and returns the final result.\n"
"The request \"func()!\" invokes the function.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #8 -- Improved functions\n"
"===========================================\n"
"\n"
"Improve the simple function by avoiding globals.\n"
"The variable n could be passed as a parameter\n"
"and the variable i could be declared as local.\n"
"More in the Lua manual: https://www.lua.org/pil/4.2.html\n"
"\n"
"Request #8 is:\n"
"\n"
"function func (n)\n"
"local i\n"
"for i=1,100,1 do n = n + i end\n"
"return n\n"
"end!\n"
"func(0)!\n"
"------------------------------\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #9 -- Comments\n"
"=================================\n"
"\n"
"There are several ways to add comments, but\n"
"one will do: (minus sign) (minus sign) comment-text.\n"
"More in the Lua manual: https://www.lua.org/pil/1.3.html\n"
"\n"
"Request #9 is:\n"
"\n"
"-- func is a function which returns a sum.\n"
"-- n is a parameter. i is a local variable.\n"
"-- \"!\" is a delimiter (introduced in Screen #6)\n"
"-- func is a function (introduced in Screen #7)\n"
"-- n is a parameter (introduced in Screen #8)\n"
"-- \"n = n + 1\" is an operator usage (introduced in Screen #4)\n"
"-- \"for ... do ... end\" is a loop (introduced in Screen #3)\n"
"function func(n) -- n is a parameter\n"
"local i -- i is a local variable\n"
"for i=1,100,1 do n = n + i end\n"
"return n\n"
"end!\n"
"-- invoke the function\n"
"func(0)!\n"
"-------------------------------------------\n"
"\n"
"Obviously it will work, so just type <tutorial(\"next\")!> now.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #10 -- Modules\n"
"=================================\n"
"\n"
"Many developers have gone to the trouble of making modules,\n"
"i.e. distributable packages of functions that have a general\n"
"utility. In the Lua world, modules are called \"rocks\".\n"
"More in the Luarocks list: https://luarocks.org/\n"
"\n"
"Most modules have to be \"required\", with the syntax\n"
"variable_name = require(\"module-name\")\n"
"which should look familiar because earlier you said\n"
"console = require(\"console\")\n"
"\n"
"At this point, if you just say the variable_name,\n"
"you’ll see a list of the module’s members and\n"
"functions. If then you use a \".\" operator as in\n"
"variable_name.function_name()\n"
"you’ll invoke a module’s function.\n"
"(At a different level you’ll have to use a \":\"\n"
"operator, as you’ll see in later examples.)\n"
"\n"
"Request #10 is:\n"
"\n"
"fiber = require(\"fiber\")!\n"
"fiber!\n"
"fiber.status()!\n"
"-------------------------\n"
"\n"
"First you’ll see a list of functions, one of which is \"status\".\n"
"Then you’ll see the fiber's current status (the fiber is running now).\n"
"More on fibers on the next screen, so type <tutorial(\"next\")!> now.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #11 -- The fiber module\n"
"==========================================\n"
"\n"
"Make a function that will run like a daemon in the\n"
"background until you cancel it. For this you need\n"
"a fiber. Tarantool is a \"cooperative multitasking\"\n"
"application server, which means that multiple\n"
"tasks each get a slice, but they have to yield\n"
"occasionally so that other tasks get a chance.\n"
"That’s what a properly designed fiber will do.\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/reference/reference_lua/fiber/\n"
"\n"
"Request #11 is:\n"
"\n"
"fiber = require(\"fiber\")!\n"
"gvar = 0!\n"
"function function_x()\n"
"for i=0,600,1 do\n"
"gvar = gvar + 1\n"
"fiber.sleep(1)\n"
"end\n"
"end!\n"
"fid = fiber.create(function_x)!\n"
"gvar!\n"
"-------------------------------\n"
"\n"
"The fiber.sleep(1) function will go to sleep for\n"
"one second, which is one way of yielding.\n"
"So the \"for i=0,600,1\" loop will go on for about 600 seconds (10 minutes).\n"
"During waking moments, gvar will go up by 1 -- and\n"
"gvar is deliberately a global variable. So it’s\n"
"possible to monitor it: slowly type \"gvar!\" a few\n"
"times and notice how the value mysteriously increases.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #12 -- The socket module\n"
"===========================================\n"
"\n"
"Connect to the Internet and send a message to Tarantool's web-site.\n"
"\n"
"Request #12 is:\n"
"\n"
"function socket_get ()\n"
"local socket, sock, result\n"
"socket = require(\"socket\")\n"
"sock = socket.tcp_connect(\"tarantool.io\", 80)\n"
"sock:send(\"GET / HTTP/1.0\\r\\nHost: tarantool.io\\r\\n\\r\\n\")\n"
"result = sock:read(17)\n"
"sock:close()\n"
"return result\n"
"end!\n"
"socket_get()!\n"
"--------------------------------\n"
"\n"
"Briefly these requests are opening a socket\n"
"and sending a \"GET\" request to tarantool.io’s server.\n"
"The response will be short, for example\n"
"\"- \"HTTP/1.1 302 OK\\r\\n\"\"\n"
"but it shows you’ve gotten in touch with a distant server.\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/reference/reference_lua/socket/\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #13 -- The box module\n"
"========================================\n"
"\n"
"So far you’ve seen Tarantool in action as a\n"
"Lua application server. Henceforth you’ll see\n"
"it as a DBMS (database management system) server\n"
"-- with Lua stored procedures.\n"
"\n"
"In serious situations you’d have to ask the\n"
"database administrator to create database objects\n"
"and grant read/write access to you, but here\n"
"you’re the \"admin\" user -- you have administrative\n"
"powers -- so you can start manipulating data immediately.\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/book/box/box_space/#box-space-replace\n"
"\n"
"Request #13 is:\n"
"\n"
"box.schema.space.create(\"tutor\")!\n"
"box.space.tutor:create_index(\"primary\",{})!\n"
"box.space.tutor:replace{1,\"First tuple\"}!\n"
"box.space.tutor:replace{2,\"Second tuple\"}!\n"
"box.space.tutor:replace{3,\"Third tuple\"}!\n"
"box.space.tutor:replace{4,\"Fourth tuple\"}!\n"
"box.space.tutor:replace{5,\"Fifth tuple\"}!\n"
"box.space.tutor!\n"
"-------------------------------------------\n"
"\n"
"Please ignore all the requests except the last one.\n"
"You’ll see a description of a space named tutor.\n"
"To understand the description, you just have to know that:\n"
"** fields are numbered item-storage areas\n"
"(vaguely like columns in an SQL DBMS)\n"
"** tuples are collections of fields, as are Lua tables\n"
"(vaguely like rows in an SQL DBMS)\n"
"** spaces are where Tarantool stores sets of tuples\n"
"(vaguely like tables in an SQL DBMS)\n"
"** indexes are objects that make lookups of tuples faster\n"
"(vaguely like indexes in an SQL DBMS)\n"
"Much of the description doesn’t matter right now; it’s\n"
"enough if you see that module box gets a space which is\n"
"named tutor, and it has one index on the first field.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #14 -- box.select()\n"
"======================================\n"
"\n"
"The most common data-manipulation function is box.select().\n"
"\n"
"One of the syntaxes is:\n"
"box.space.tutor.index.primary:select({1}, {iterator = \"GE\"})\n"
"and it returns a set of tuples via the index of the tutor\n"
"space.\n"
"Now that you know that, and considering that you already\n"
"know how to make functions and loops in Lua, it’s simple\n"
"to figure out how to search and display the first five\n"
"tuples in the database.\n"
"\n"
"Request #14 is:\n"
"\n"
"-- This function will select and display 5 tuples in space=tutor\n"
"function database_display (space_name)\n"
"local i\n"
"local result = \"\"\n"
"t = box.space[space_name].index.primary:select({1}, {iterator = \"GE\"})\n"
"for i=1,5,1 do\n"
"result = result .. t[i][1] .. \" \" .. t[i][2] .. \"\\n\"\n"
"end\n"
"return result\n"
"end!\n"
"database_display(\"tutor\")!\n"
"--------------------------\n"
"\n"
"So select() is returning a set of tuples into a Lua table\n"
"named t, and the loop is going to print each element of\n"
"the table. That is, when you call database_display()! you’ll\n"
"see a display of what’s in the tuples.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #15 -- box.replace()\n"
"=======================================\n"
"\n"
"Pick any of the tuples that were displayed on the last screen.\n"
"Recall that the first field is the indexed field.\n"
"That’s all you need to replace the rest of the fields with\n"
"new values. The syntax of box.replace(), pared down, is:\n"
"box.space.tutor:replace{primary-key-field, other-fields}\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/book/box/box_space/#box-space-replace\n"
"Tarantool by default keeps database changes in memory,\n"
"but box.replace() will cause a write to a log, and log\n"
"information can later be consolidated with another box\n"
"function (box.snapshot).\n"
"\n"
"Request #15 is:\n"
"\n"
"box.space.tutor:replace{1, \"My First Piece Of Data\"}!\n"
"-----------------------------------------------------\n"
"\n"
"If there is already a \"tuple\" (our equivalent of a record)\n"
"whose number is equal to 1, it will be replaced with your\n"
"new data. Otherwise it will be created for the first time.\n"
"The display will be the formal description of the new tuple.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #16 -- Create your own space\n"
"===============================================\n"
"\n"
"You’ve now selected and replaced tuples from the\n"
"tutor space, and you could select and replace many\n"
"tuples because you know how to make variables and\n"
"functions and loops that do selecting or replacing.\n"
"But you’ve been confined to a space and an index\n"
"that Tarantool started with.\n"
"Suppose that you want to create your own.\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/book/getting_started/using_docker/#creating-a-database\n"
"\n"
"Request #16 is:\n"
"\n"
"box.schema.space.create(\"test\", {engine=\"memtx\"})!\n"
"--------------------------------------------------\n"
"\n"
"The new space’s name will be \"test\" and the engine\n"
"will be \"memtx\" -- the engine which keeps all tuples\n"
"in memory, and writes changes to a log file to ensure\n"
"that data can’t be lost. Although \"memtx\" is the\n"
"default engine anyway, specifying it does no harm.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #17 -- Create your own index\n"
"===============================================\n"
"\n"
"Having a space isn’t enough -- you must have at\n"
"least one index. Indexes make access faster.\n"
"Indexes can be declared to be \"unique\", which\n"
"is important because some combination of the\n"
"fields must be unique, for identification purposes.\n"
"More in the Tarantool manual:\n"
"https://tarantool.io/en/doc/<version>/book/box/data_model/#index\n"
"\n"
"Request #17 is:\n"
"\n"
"box.space.test:create_index(\"primary\",{unique = true, parts = {1, \"NUM\"}})!\n"
"box.space.test:create_index(\"secondary\",{parts = {2, \"STR\"}})!\n"
"--------------------------------------------------------------\n"
"\n"
"This means the first index will be named primary,\n"
"will be unique, will be on the first field of each\n"
"tuple, and will be numeric. The second index will\n"
"be named secondary, doesn’t have to be unique, will\n"
"be on the second field of each tuple, and will be\n"
"in order by string value.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #18 -- Insert multiple tuples\n"
"================================================\n"
"\n"
"In a loop, put some tuples in your new space.\n"
"Because of the index definitions, the first field\n"
"must be a number, the second field must be a string,\n"
"and the later fields can be anything.\n"
"Use a function in the Lua string library to make\n"
"values for the second field.\n"
"More in the Lua manual: https://www.lua.org/pil/20.html\n"
"\n"
"Request #18 is:\n"
"\n"
"for i=65,70,1 do\n"
"box.space.test:replace{i, string.char(i)}\n"
"end!\n"
"-----------------------------------------\n"
"\n"
"Tip: to select the tuples later, use the function\n"
"that you created earlier: database_display(\"test\")!\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #19 -- Become another user\n"
"=============================================\n"
"\n"
"Remember, you’re currently \"admin\" -- administrator.\n"
"Now switch to being \"guest\", a much less powerful user.\n"
"\n"
"Request #19 is:\n"
"\n"
"box.session.su(\"guest\") -- switch user to \"guest\"!\n"
"box.space.test:replace{100,\"\"} -- try to add a tuple!\n"
"-----------------------------------------------------\n"
"\n"
"The result will be an error message telling you that\n"
"you don’t have the privilege to do that any more.\n"
"That’s good news. It shows that Tarantool prevents\n"
"unauthorized users from working with databases.\n"
"But you can say box.session.su(\"admin\")! to become\n"
"a powerful user again, because for this tutorial\n"
"the \"admin\" user isn’t protected by a password.\n"
"]];\n"
"\n"
"[[\n"
"Tutorial -- Screen #20 -- The bigger Tutorials\n"
"==============================================\n"
"\n"
"You can continue to type in whatever Lua instructions,\n"
"module requires, and database-manipulations you want,\n"
"here on this screen. But to really get into Tarantool,\n"
"you should download it so that you can be your own\n"
"administrator and create your own permanent databases. The\n"
"Tarantool manual has three significant Lua tutorials:\n"
"\n"
"Insert one million tuples with a Lua stored procedure,\n"
"Sum a JSON field for all tuples, and\n"
"Indexed pattern search.\n"
"\n"
"See https://tarantool.io/en/doc/<version>/tutorials/lua_tutorials/\n"
"\n"
"Request #20 is:\n"
"\n"
"((Whatever you want. Enjoy!))\n"
"\n"
"When you’re finished, don’t type <tutorial(\"next\")!>, just wander off\n"
"and have a nice day.\n"
"]];\n"
"    }; --[[ tutorial ]]--\n"
"}\n"
""
;
