const char memprof_humanize_lua[] =
"-- Simple human-readable renderer of LuaJIT's memprof profile.\n"
"--\n"
"-- Major portions taken verbatim or adapted from the LuaVela.\n"
"-- Copyright (C) 2015-2019 IPONWEB Ltd.\n"
"\n"
"local symtab = require \"utils.symtab\"\n"
"\n"
"local M = {}\n"
"\n"
"function M.render(events, symbols)\n"
"  local ids = {}\n"
"\n"
"  for id, _ in pairs(events) do\n"
"    table.insert(ids, id)\n"
"  end\n"
"\n"
"  table.sort(ids, function(id1, id2)\n"
"    return events[id1].num > events[id2].num\n"
"  end)\n"
"\n"
"  for i = 1, #ids do\n"
"    local event = events[ids[i]]\n"
"    print(string.format(\"%s: %d events\\t+%d bytes\\t-%d bytes\",\n"
"      symtab.demangle(symbols, event.loc),\n"
"      event.num,\n"
"      event.alloc,\n"
"      event.free\n"
"    ))\n"
"\n"
"    local prim_loc = {}\n"
"    for _, heap_chunk in pairs(event.primary) do\n"
"      table.insert(prim_loc, symtab.demangle(symbols, heap_chunk.loc))\n"
"    end\n"
"    if #prim_loc ~= 0 then\n"
"      table.sort(prim_loc)\n"
"      print(\"\\tOverrides:\")\n"
"      for j = 1, #prim_loc do\n"
"        print(string.format(\"\\t\\t%s\", prim_loc[j]))\n"
"      end\n"
"      print(\"\")\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"function M.profile_info(events, symbols)\n"
"  print(\"ALLOCATIONS\")\n"
"  M.render(events.alloc, symbols)\n"
"  print(\"\")\n"
"\n"
"  print(\"REALLOCATIONS\")\n"
"  M.render(events.realloc, symbols)\n"
"  print(\"\")\n"
"\n"
"  print(\"DEALLOCATIONS\")\n"
"  M.render(events.free, symbols)\n"
"  print(\"\")\n"
"end\n"
"\n"
"function M.leak_info(dheap)\n"
"  local leaks = {}\n"
"  for line, info in pairs(dheap) do\n"
"    -- Report \"INTERNAL\" events inconsistencies for profiling\n"
"    -- with enabled jit.\n"
"    if info.dbytes > 0 then\n"
"      table.insert(leaks, {line = line, dbytes = info.dbytes})\n"
"    end\n"
"  end\n"
"\n"
"  table.sort(leaks, function(l1, l2)\n"
"    return l1.dbytes > l2.dbytes\n"
"  end)\n"
"\n"
"  print(\"HEAP SUMMARY:\")\n"
"  for _, l in pairs(leaks) do\n"
"    print(string.format(\n"
"      \"%s holds %d bytes: %d allocs, %d frees\",\n"
"      l.line, l.dbytes, dheap[l.line].nalloc,\n"
"      dheap[l.line].nfree\n"
"    ))\n"
"  end\n"
"  print(\"\")\n"
"end\n"
"\n"
"function M.aliases(symbols)\n"
"  if #symbols.alias == 0 then return end\n"
"  print(\"ALIASES:\")\n"
"  for _, source in ipairs(symbols.alias) do\n"
"    print(symbols.alias[source]..\":\")\n"
"    local lineno = 1\n"
"    for line in source:gmatch(\"([^\\n]+)\") do\n"
"      print(string.format(\"%d\\t| %s\", lineno, line))\n"
"      lineno = lineno + 1\n"
"    end\n"
"    print(\"\\n\")\n"
"  end\n"
"end\n"
"\n"
"return M\n"
""
;
