const char sysprof_parse_lua[] =
"-- Parser of LuaJIT's sysprof binary stream.\n"
"-- The format spec can be found in <src/lj_sysprof.h>.\n"
"\n"
"local symtab = require \"utils.symtab\"\n"
"\n"
"local string_format = string.format\n"
"\n"
"local LJP_MAGIC = \"ljp\"\n"
"local LJP_CURRENT_VERSION = 2\n"
"\n"
"local M = {}\n"
"\n"
"M.VMST = {\n"
"  INTERP = 0,\n"
"  LFUNC  = 1,\n"
"  FFUNC  = 2,\n"
"  CFUNC  = 3,\n"
"  GC     = 4,\n"
"  EXIT   = 5,\n"
"  RECORD = 6,\n"
"  OPT    = 7,\n"
"  ASM    = 8,\n"
"  TRACE  = 9,\n"
"  SYMTAB = 10,\n"
"}\n"
"\n"
"\n"
"M.FRAME = {\n"
"  LFUNC  = 1,\n"
"  CFUNC  = 2,\n"
"  FFUNC  = 3,\n"
"  BOTTOM = 0x80\n"
"}\n"
"\n"
"local STREAM_END = 0x80\n"
"local SYMTAB_LFUNC_EVENT = 10\n"
"local SYMTAB_CFUNC_EVENT = 11\n"
"local SYMTAB_TRACE_EVENT = 12\n"
"\n"
"local function new_event()\n"
"  return {\n"
"    lua = {\n"
"      vmstate = 0,\n"
"      callchain = {},\n"
"      trace = {\n"
"        traceno = nil,\n"
"        addr = 0,\n"
"        line = 0,\n"
"      }\n"
"    },\n"
"    host = {\n"
"      callchain = {}\n"
"    }\n"
"  }\n"
"end\n"
"\n"
"local function parse_lfunc(reader, event, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"  local line = reader:read_uleb128()\n"
"  local loc = symtab.loc(symbols, { addr = addr, line = line })\n"
"  loc.type = M.FRAME.LFUNC\n"
"  table.insert(event.lua.callchain, 1, loc)\n"
"end\n"
"\n"
"local function parse_ffunc(reader, event, _)\n"
"  local ffid = reader:read_uleb128()\n"
"  table.insert(event.lua.callchain, 1, {\n"
"    type = M.FRAME.FFUNC,\n"
"    ffid = ffid,\n"
"  })\n"
"end\n"
"\n"
"local function parse_cfunc(reader, event, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"  local loc = symtab.loc(symbols, { addr = addr })\n"
"  loc.type = M.FRAME.CFUNC\n"
"  table.insert(event.lua.callchain, 1, loc)\n"
"end\n"
"\n"
"local frame_parsers = {\n"
"  [M.FRAME.LFUNC] = parse_lfunc,\n"
"  [M.FRAME.FFUNC] = parse_ffunc,\n"
"  [M.FRAME.CFUNC] = parse_cfunc\n"
"}\n"
"\n"
"local function parse_lua_callchain(reader, event, symbols)\n"
"  while true do\n"
"    local frame_header = reader:read_octet()\n"
"    if frame_header == M.FRAME.BOTTOM then\n"
"      break\n"
"    end\n"
"    frame_parsers[frame_header](reader, event, symbols)\n"
"  end\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_host_callchain(reader, event, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"\n"
"  while addr ~= 0 do\n"
"    local loc = symtab.loc(symbols, { addr = addr })\n"
"    table.insert(event.host.callchain, 1, loc)\n"
"    addr = reader:read_uleb128()\n"
"  end\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_trace_callchain(reader, event, symbols)\n"
"  event.lua.trace.traceno  = reader:read_uleb128()\n"
"  event.lua.trace.addr = reader:read_uleb128()\n"
"  event.lua.trace.line = reader:read_uleb128()\n"
"  event.lua.trace.gen = symtab.loc(symbols, event.lua.trace).gen\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_host_only(reader, event, symbols)\n"
"  parse_host_callchain(reader, event, symbols)\n"
"end\n"
"\n"
"local function parse_lua_host(reader, event, symbols)\n"
"  parse_lua_callchain(reader, event, symbols)\n"
"  parse_host_callchain(reader, event, symbols)\n"
"end\n"
"\n"
"local function parse_trace(reader, event, symbols)\n"
"  parse_trace_callchain(reader, event, symbols)\n"
"  -- parse_lua_callchain(reader, event)\n"
"end\n"
"\n"
"local function parse_symtab(reader, symbols, vmstate)\n"
"  if vmstate == SYMTAB_LFUNC_EVENT then\n"
"    symtab.parse_sym_lfunc(reader, symbols)\n"
"  elseif vmstate == SYMTAB_CFUNC_EVENT then\n"
"    symtab.parse_sym_cfunc(reader, symbols)\n"
"  elseif vmstate == SYMTAB_TRACE_EVENT then\n"
"    symtab.parse_sym_trace(reader, symbols)\n"
"  else\n"
"    error(\"Unknown symtab event\")\n"
"  end\n"
"end\n"
"\n"
"local event_parsers = {\n"
"  [M.VMST.INTERP] = parse_host_only,\n"
"  [M.VMST.LFUNC]  = parse_lua_host,\n"
"  [M.VMST.FFUNC]  = parse_lua_host,\n"
"  [M.VMST.CFUNC]  = parse_lua_host,\n"
"  [M.VMST.GC]     = parse_host_only,\n"
"  [M.VMST.EXIT]   = parse_host_only,\n"
"  [M.VMST.RECORD] = parse_host_only,\n"
"  [M.VMST.OPT]    = parse_host_only,\n"
"  [M.VMST.ASM]    = parse_host_only,\n"
"  [M.VMST.TRACE]  = parse_trace,\n"
"}\n"
"\n"
"local function parse_event(reader, events, symbols)\n"
"  local event = new_event()\n"
"\n"
"  local vmstate = reader:read_octet()\n"
"  if vmstate == STREAM_END then\n"
"    -- TODO: samples & overruns\n"
"    return false\n"
"  elseif SYMTAB_LFUNC_EVENT <= vmstate and vmstate <= SYMTAB_TRACE_EVENT then\n"
"    parse_symtab(reader, symbols, vmstate)\n"
"    return true\n"
"  end\n"
"\n"
"  assert(0 <= vmstate and vmstate <= 9, \"Vmstate \"..vmstate..\" is not valid\")\n"
"  event.lua.vmstate = vmstate\n"
"\n"
"  event_parsers[vmstate](reader, event, symbols)\n"
"\n"
"  table.insert(events, event)\n"
"  return true\n"
"end\n"
"\n"
"function M.parse(reader, symbols)\n"
"  local events = {}\n"
"\n"
"  local magic = reader:read_octets(3)\n"
"  local version = reader:read_octets(1)\n"
"  -- Dummy-consume reserved bytes.\n"
"  local _ = reader:read_octets(3)\n"
"\n"
"  if magic ~= LJP_MAGIC then\n"
"    error(\"Bad LJP format prologue: \"..magic)\n"
"  end\n"
"\n"
"  if string.byte(version) ~= LJP_CURRENT_VERSION then\n"
"    error(string_format(\n"
"      \"LJP format version mismatch: the tool expects %d, but your data is %d\",\n"
"      LJP_CURRENT_VERSION,\n"
"      string.byte(version)\n"
"    ))\n"
"  end\n"
"\n"
"  while parse_event(reader, events, symbols) do\n"
"    -- Empty body.\n"
"  end\n"
"\n"
"  return events\n"
"end\n"
"\n"
"return M\n"
""
;
