const char metrics_api_lua[] =
"-- vim: ts=4:sw=4:sts=4:expandtab\n"
"\n"
"local checks = require('checks')\n"
"\n"
"local Registry = require('metrics.registry')\n"
"\n"
"local Counter = require('metrics.collectors.counter')\n"
"local Gauge = require('metrics.collectors.gauge')\n"
"local Histogram = require('metrics.collectors.histogram')\n"
"local Summary = require('metrics.collectors.summary')\n"
"\n"
"local registry = rawget(_G, '__metrics_registry')\n"
"if not registry then\n"
"    registry = Registry.new()\n"
"end\n"
"registry.callbacks = {}\n"
"\n"
"rawset(_G, '__metrics_registry', registry)\n"
"\n"
"local function collectors()\n"
"    return registry.collectors\n"
"end\n"
"\n"
"local function register_callback(...)\n"
"    return registry:register_callback(...)\n"
"end\n"
"\n"
"local function unregister_callback(...)\n"
"    return registry:unregister_callback(...)\n"
"end\n"
"\n"
"local function invoke_callbacks()\n"
"    return registry:invoke_callbacks()\n"
"end\n"
"\n"
"local function get_collector_values(collector, result)\n"
"    for _, obs in ipairs(collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"end\n"
"\n"
"local function collect(opts)\n"
"    checks({invoke_callbacks = '\?boolean', default_only = '\?boolean'})\n"
"    opts = opts or {}\n"
"\n"
"    if opts.invoke_callbacks then\n"
"        registry:invoke_callbacks()\n"
"    end\n"
"\n"
"    local result = {}\n"
"    for _, collector in pairs(registry.collectors) do\n"
"        if opts.default_only then\n"
"            if collector.metainfo.default then\n"
"                get_collector_values(collector, result)\n"
"            end\n"
"        else\n"
"            get_collector_values(collector, result)\n"
"        end\n"
"    end\n"
"\n"
"    return result\n"
"end\n"
"\n"
"local function clear()\n"
"    registry:clear()\n"
"end\n"
"\n"
"local function counter(name, help, metainfo)\n"
"    checks('string', '\?string', '\?table')\n"
"\n"
"    return registry:find_or_create(Counter, name, help, metainfo)\n"
"end\n"
"\n"
"local function gauge(name, help, metainfo)\n"
"    checks('string', '\?string', '\?table')\n"
"\n"
"    return registry:find_or_create(Gauge, name, help, metainfo)\n"
"end\n"
"\n"
"local function histogram(name, help, buckets, metainfo)\n"
"    checks('string', '\?string', '\?table', '\?table')\n"
"    if buckets ~= nil and not Histogram.check_buckets(buckets) then\n"
"        error('Invalid value for buckets')\n"
"    end\n"
"\n"
"    return registry:find_or_create(Histogram, name, help, buckets, metainfo)\n"
"end\n"
"\n"
"local function summary(name, help, objectives, params, metainfo)\n"
"    checks('string', '\?string', '\?table', {\n"
"        age_buckets_count = '\?number',\n"
"        max_age_time = '\?number',\n"
"    }, '\?table')\n"
"    if objectives ~= nil and not Summary.check_quantiles(objectives) then\n"
"        error('Invalid value for objectives')\n"
"    end\n"
"    params = params or {}\n"
"    local age_buckets_count = params.age_buckets_count\n"
"    local max_age_time = params.max_age_time\n"
"    if max_age_time and max_age_time <= 0 then\n"
"        error('Max age must be positive')\n"
"    end\n"
"    if age_buckets_count and age_buckets_count < 1 then\n"
"        error('Age buckets count must be greater or equal than one')\n"
"    end\n"
"    if (max_age_time and not age_buckets_count) or (not max_age_time and age_buckets_count) then\n"
"        error('Age buckets count and max age must be present only together')\n"
"    end\n"
"\n"
"    return registry:find_or_create(Summary, name, help, objectives, params, metainfo)\n"
"end\n"
"\n"
"local function set_global_labels(label_pairs)\n"
"    checks('\?table')\n"
"\n"
"    label_pairs = label_pairs or {}\n"
"\n"
"    -- Verify label table\n"
"    for k, _ in pairs(label_pairs) do\n"
"        if type(k) ~= 'string' then\n"
"            error((\"bad label key (string expected, got %s)\"):format(type(k)))\n"
"        end\n"
"    end\n"
"\n"
"    registry:set_labels(label_pairs)\n"
"end\n"
"\n"
"return {\n"
"    registry = registry,\n"
"    collectors = collectors,\n"
"\n"
"    counter = counter,\n"
"    gauge = gauge,\n"
"    histogram = histogram,\n"
"    summary = summary,\n"
"\n"
"    collect = collect,\n"
"    clear = clear,\n"
"    register_callback = register_callback,\n"
"    unregister_callback = unregister_callback,\n"
"    invoke_callbacks = invoke_callbacks,\n"
"    set_global_labels = set_global_labels,\n"
"}\n"
""
;
