const char metrics_quantile_lua[] =
"local ffi = require('ffi')\n"
"local const = require('metrics.const')\n"
"\n"
"local quantile = {}\n"
"\n"
"if not pcall(ffi.typeof, \"sample\") then\n"
"    ffi.cdef[[\n"
"        typedef struct sample {int Delta, Width; double Value; } sample;\n"
"    ]]\n"
"end\n"
"\n"
"local sample_constructor = ffi.typeof('sample')\n"
"\n"
"local function quicksort(array, low, high)\n"
"    assert(low >= 0, 'Low bound must be non-negative')\n"
"    assert(high < ffi.sizeof(array) / ffi.sizeof('double'),\n"
"        'Upper bound must be lower than array size')\n"
"    if high - low < 1 then\n"
"        return array\n"
"    end\n"
"    local pivot = low\n"
"    for i = low + 1, high do\n"
"        if array[i] <= array[pivot] then\n"
"            if i == pivot + 1 then\n"
"                array[pivot], array[pivot + 1] = array[pivot + 1], array[pivot]\n"
"            else\n"
"                array[pivot], array[pivot + 1], array[i] = array[i], array[pivot], array[pivot + 1]\n"
"            end\n"
"            pivot = pivot + 1\n"
"        end\n"
"    end\n"
"    array = quicksort(array, low, pivot - 1)\n"
"    return quicksort(array, pivot + 1, high)\n"
"end\n"
"\n"
"quantile.quicksort = quicksort\n"
"\n"
"local function make_sample(value, width, delta)\n"
"    return sample_constructor(delta or 0, width or 0, value)\n"
"end\n"
"\n"
"local inf_obj = make_sample(math.huge)\n"
"\n"
"local function insert_sample(sample_obj, value, width, delta)\n"
"    sample_obj.Value = value\n"
"    sample_obj.Width = width\n"
"    sample_obj.Delta = delta\n"
"end\n"
"\n"
"local stream = {}\n"
"\n"
"-- Stream computes quantiles for a stream of float64s.\n"
"function stream.new(f, max_samples)\n"
"    if not max_samples then\n"
"        max_samples = 500\n"
"    end\n"
"    assert(max_samples > 0, 'max_samples must be positive')\n"
"    return setmetatable({\n"
"        stream = {\n"
"            f = f,\n"
"            l = {},\n"
"            n = 0,\n"
"        },\n"
"        b = {},\n"
"        sorted = true,\n"
"        __max_samples = max_samples,\n"
"    }, { __index = stream })\n"
"end\n"
"\n"
"function stream:flush()\n"
"    self:maybe_sort()\n"
"    self:merge(self.b, self.b_len)\n"
"    self.b_len = 0\n"
"end\n"
"\n"
"function stream:maybe_sort()\n"
"    if not self.sorted and self.b_len > 1 then\n"
"        self.sorted = true\n"
"        quicksort(self.b, 0, self.b_len - 1)\n"
"    end\n"
"end\n"
"\n"
"function stream:flushed()\n"
"    return self.stream.l_len > 0\n"
"end\n"
"\n"
"local function sample_copy(dst, src)\n"
"    dst.Value = src.Value\n"
"    dst.Width = src.Width or 0\n"
"    dst.Delta = src.Delta or 0\n"
"end\n"
"\n"
"function stream:sample_insert(value, width, delta, pos)\n"
"    local arr = self.stream.l\n"
"    local len = self.stream.l_len\n"
"    local cap = self.stream.l_cap\n"
"    local do_shift = true\n"
"    if not pos then\n"
"        pos = len + 1\n"
"        do_shift = false\n"
"    end\n"
"    if len == cap then\n"
"        cap = math.modf(cap * 1.5)\n"
"        local new_arr = ffi.new('sample[\?]', cap + 2)\n"
"\n"
"        for i = 0, pos - 1 do\n"
"            sample_copy(new_arr[i], arr[i])\n"
"        end\n"
"        insert_sample(new_arr[pos], value, width, delta )\n"
"        for i = pos + 1, len do\n"
"            sample_copy(new_arr[i], arr[i-1])\n"
"        end\n"
"        for i = len + 1, cap + 1 do\n"
"            new_arr[i] = inf_obj\n"
"        end\n"
"        self.stream.l_cap = cap\n"
"        self.stream.l = new_arr\n"
"        return\n"
"    end\n"
"    if do_shift then\n"
"        for i = len + 1, pos + 1, -1 do\n"
"            sample_copy(arr[i], arr[i-1])\n"
"        end\n"
"    end\n"
"    insert_sample(arr[pos], value, width, delta )\n"
"end\n"
"\n"
"local function sample_remove(arr, len, pos)\n"
"    for i = pos, len - 1 do\n"
"        sample_copy(arr[i], arr[i+1])\n"
"    end\n"
"    arr[len].Value = math.huge\n"
"end\n"
"\n"
"function stream:merge(samples, len)\n"
"    local s = self.stream\n"
"\n"
"    local i = 1\n"
"    local r = 0\n"
"    for z = 1, len do\n"
"        local sample = samples[z-1]\n"
"        for j = i, s.l_len do\n"
"            local c = s.l[j]\n"
"            if c.Value > sample then\n"
"                self:sample_insert(sample, 1, s.f(s, r) - 1, j)\n"
"                s.l_len = s.l_len + 1\n"
"\n"
"                i = j + 1\n"
"                goto inserted\n"
"            end\n"
"            r = r + c.Width\n"
"        end\n"
"        self:sample_insert(sample, 1, 0)\n"
"        s.l_len = s.l_len + 1\n"
"        i = i + 1\n"
"    ::inserted::\n"
"        s.n = s.n + 1\n"
"    end\n"
"end\n"
"\n"
"function stream:query(q)\n"
"    local s = self.stream\n"
"    local t = q * s.n\n"
"    t = t + s.f(s, t) / 2\n"
"\n"
"    local p = s.l[0]\n"
"    local r = 0\n"
"    for i = 1, s.l_len-1 do  -- samples buffer indexing starts from 0 to length-1\n"
"        local c = s.l[i]\n"
"        if r + c.Width + c.Delta > t then\n"
"            return p.Value\n"
"        end\n"
"        r = r + p.Width\n"
"        p = c\n"
"    end\n"
"    return p.Value\n"
"end\n"
"\n"
"function stream:compress()\n"
"    local s = self.stream\n"
"    if s.l_len < 2 then\n"
"        return\n"
"    end\n"
"    local x = make_sample(0)\n"
"    sample_copy(x, s.l[s.l_len])\n"
"    local xi = s.l_len\n"
"    local r = s.n - x.Width\n"
"\n"
"    for i = s.l_len - 1, 1, -1 do\n"
"        local c = make_sample(0)\n"
"        sample_copy(c, s.l[i])\n"
"        if c.Width + x.Width + x.Delta <= s.f(s, r) then\n"
"            x.Width = x.Width + c.Width\n"
"            sample_copy(s.l[xi], x)\n"
"            sample_remove(s.l, s.l_len, i)\n"
"            s.l_len = s.l_len - 1\n"
"\n"
"            xi = xi - 1\n"
"        else\n"
"            x = c\n"
"            xi = i\n"
"        end\n"
"        r = r - c.Width\n"
"    end\n"
"    self.compress_cnt = 0\n"
"end\n"
"\n"
"function quantile.NewTargeted(quantiles, max_samples)\n"
"    local qs={}\n"
"    local epss = {}\n"
"    for q, eps in pairs(quantiles) do\n"
"        assert(q >= 0 and q <= 1, 'Quantile must be in [0; 1]')\n"
"        table.insert(qs, q)\n"
"        table.insert(epss, eps)\n"
"    end\n"
"    local len = #qs\n"
"    local function fun(s, r)\n"
"        local m = math.huge\n"
"        local f\n"
"        for i = 1, len do\n"
"            local q = qs[i]\n"
"            local eps = epss[i]\n"
"            if q*s.n <= r then\n"
"                f = (2 * eps * r) / q\n"
"            else\n"
"                f = (2 * eps * (s.n - r)) / (1 - q)\n"
"            end\n"
"            if math.floor(f) < m then\n"
"                m = math.floor(f)\n"
"            end\n"
"        end\n"
"        return math.max(m, 1)\n"
"    end\n"
"    local s = stream.new(fun, max_samples)\n"
"    s.b = ffi.new('double[\?]', s.__max_samples)\n"
"\n"
"    for i = 0, s.__max_samples - 1 do\n"
"        s.b[i] = math.huge\n"
"    end\n"
"\n"
"    local minf_obj = make_sample(-math.huge)\n"
"\n"
"    s.stream.l = ffi.new('sample[\?]', s.__max_samples * 2 + 2)\n"
"    s.stream.l[0] = minf_obj\n"
"    for i = 1, s.__max_samples * 2 + 1 do\n"
"        s.stream.l[i] = inf_obj\n"
"    end\n"
"    s.b_len = 0\n"
"    s.stream.l_len = 0\n"
"    s.stream.l_cap = s.__max_samples * 2\n"
"    s.compress_cnt = 0\n"
"    return s\n"
"end\n"
"\n"
"-- Insert inserts v into the stream.\n"
"function quantile.Insert(stream_obj, v)\n"
"    stream_obj.b[stream_obj.b_len] = v\n"
"    stream_obj.b_len = stream_obj.b_len + 1\n"
"    stream_obj.compress_cnt = stream_obj.compress_cnt + 1\n"
"    stream_obj.sorted = false\n"
"    if stream_obj.b_len == stream_obj.__max_samples or\n"
"        stream_obj.compress_cnt == stream_obj.__max_samples then\n"
"        stream_obj:flush()\n"
"        stream_obj:compress()\n"
"    end\n"
"end\n"
"\n"
"-- Query returns the computed qth percentiles value. If s was created with\n"
"-- NewTargeted, and q is not in the set of quantiles provided a priori, Query\n"
"-- will return an unspecified result.\n"
"function quantile.Query(stream_obj, q)\n"
"    if not stream_obj:flushed() then\n"
"        -- Fast path when there hasn't been enough data for a flush;\n"
"        -- this also yields better accuracy for small sets of data.\n"
"        local l = stream_obj.b_len\n"
"\n"
"        -- if buffer is empty and wasn't flushed yet then quantile value is NaN\n"
"        if l == 0 then\n"
"            return const.NAN\n"
"        end\n"
"\n"
"        local i = math.modf(l * q)\n"
"        stream_obj:maybe_sort()\n"
"        return stream_obj.b[i]\n"
"    end\n"
"    stream_obj:flush()\n"
"    return stream_obj:query(q)\n"
"end\n"
"\n"
"\n"
"-- Reset reinitializes and clears the list reusing the samples buffer memory.\n"
"function quantile.Reset(stream_obj)\n"
"    stream_obj.stream.n = 0\n"
"    stream_obj.b_len = 0\n"
"    stream_obj.stream.l_len = 0\n"
"    for i = 1, stream_obj.__max_samples * 2 + 1 do\n"
"        stream_obj.stream.l[i] = inf_obj\n"
"    end\n"
"    for i = 0, stream_obj.__max_samples - 1 do\n"
"        stream_obj.b[i] = math.huge\n"
"    end\n"
"end\n"
"\n"
"return quantile\n"
""
;
