/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// RateLimitApplyConfiguration represents a declarative configuration of the RateLimit type for use
// with apply.
type RateLimitApplyConfiguration struct {
	Average         *int64                   `json:"average,omitempty"`
	Period          *intstr.IntOrString      `json:"period,omitempty"`
	Burst           *int64                   `json:"burst,omitempty"`
	SourceCriterion *dynamic.SourceCriterion `json:"sourceCriterion,omitempty"`
	Redis           *RedisApplyConfiguration `json:"redis,omitempty"`
}

// RateLimitApplyConfiguration constructs a declarative configuration of the RateLimit type for use with
// apply.
func RateLimit() *RateLimitApplyConfiguration {
	return &RateLimitApplyConfiguration{}
}

// WithAverage sets the Average field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Average field is set to the value of the last call.
func (b *RateLimitApplyConfiguration) WithAverage(value int64) *RateLimitApplyConfiguration {
	b.Average = &value
	return b
}

// WithPeriod sets the Period field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Period field is set to the value of the last call.
func (b *RateLimitApplyConfiguration) WithPeriod(value intstr.IntOrString) *RateLimitApplyConfiguration {
	b.Period = &value
	return b
}

// WithBurst sets the Burst field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Burst field is set to the value of the last call.
func (b *RateLimitApplyConfiguration) WithBurst(value int64) *RateLimitApplyConfiguration {
	b.Burst = &value
	return b
}

// WithSourceCriterion sets the SourceCriterion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SourceCriterion field is set to the value of the last call.
func (b *RateLimitApplyConfiguration) WithSourceCriterion(value dynamic.SourceCriterion) *RateLimitApplyConfiguration {
	b.SourceCriterion = &value
	return b
}

// WithRedis sets the Redis field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Redis field is set to the value of the last call.
func (b *RateLimitApplyConfiguration) WithRedis(value *RedisApplyConfiguration) *RateLimitApplyConfiguration {
	b.Redis = value
	return b
}
