/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_APP_ID_RESOLVER_V1_CLIENT_PROTOCOL_H
#define TREELAND_APP_ID_RESOLVER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_app_id_resolver_v1 The treeland_app_id_resolver_v1 protocol
 * @section page_ifaces_treeland_app_id_resolver_v1 Interfaces
 * - @subpage page_iface_treeland_app_id_resolver_manager_v1 - manager for app id resolver
 * - @subpage page_iface_treeland_app_id_resolver_v1 - app id resolver
 * @section page_copyright_treeland_app_id_resolver_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_app_id_resolver_manager_v1;
struct treeland_app_id_resolver_v1;

#ifndef TREELAND_APP_ID_RESOLVER_MANAGER_V1_INTERFACE
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_app_id_resolver_manager_v1 treeland_app_id_resolver_manager_v1
 * @section page_iface_treeland_app_id_resolver_manager_v1_desc Description
 *
 * Create a resolver object. Typically exactly one privileged helper
 * (a Wayland client with DBus access) binds this interface and serves
 * identification requests coming from the compositor.
 * @section page_iface_treeland_app_id_resolver_manager_v1_api API
 * See @ref iface_treeland_app_id_resolver_manager_v1.
 */
/**
 * @defgroup iface_treeland_app_id_resolver_manager_v1 The treeland_app_id_resolver_manager_v1 interface
 *
 * Create a resolver object. Typically exactly one privileged helper
 * (a Wayland client with DBus access) binds this interface and serves
 * identification requests coming from the compositor.
 */
extern const struct wl_interface treeland_app_id_resolver_manager_v1_interface;
#endif
#ifndef TREELAND_APP_ID_RESOLVER_V1_INTERFACE
#define TREELAND_APP_ID_RESOLVER_V1_INTERFACE
/**
 * @page page_iface_treeland_app_id_resolver_v1 treeland_app_id_resolver_v1
 * @section page_iface_treeland_app_id_resolver_v1_desc Description
 *
 * The compositor sends identify_request with a unique request_id and a pidfd.
 * The client must answer exactly once via respond(request_id, app_id). If
 * resolution fails respond with an empty string.
 * @section page_iface_treeland_app_id_resolver_v1_api API
 * See @ref iface_treeland_app_id_resolver_v1.
 */
/**
 * @defgroup iface_treeland_app_id_resolver_v1 The treeland_app_id_resolver_v1 interface
 *
 * The compositor sends identify_request with a unique request_id and a pidfd.
 * The client must answer exactly once via respond(request_id, app_id). If
 * resolution fails respond with an empty string.
 */
extern const struct wl_interface treeland_app_id_resolver_v1_interface;
#endif

#ifndef TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM
enum treeland_app_id_resolver_manager_v1_error {
	/**
	 * A resolver is already registered in this session with the manager
	 */
	TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_RESOLVER_ALREADY_EXISTS = 1,
};
#endif /* TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM */

#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_DESTROY 0
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_GET_RESOLVER 1


/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 */
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 */
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_GET_RESOLVER_SINCE_VERSION 1

/** @ingroup iface_treeland_app_id_resolver_manager_v1 */
static inline void
treeland_app_id_resolver_manager_v1_set_user_data(struct treeland_app_id_resolver_manager_v1 *treeland_app_id_resolver_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_app_id_resolver_manager_v1, user_data);
}

/** @ingroup iface_treeland_app_id_resolver_manager_v1 */
static inline void *
treeland_app_id_resolver_manager_v1_get_user_data(struct treeland_app_id_resolver_manager_v1 *treeland_app_id_resolver_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_app_id_resolver_manager_v1);
}

static inline uint32_t
treeland_app_id_resolver_manager_v1_get_version(struct treeland_app_id_resolver_manager_v1 *treeland_app_id_resolver_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_manager_v1);
}

/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 */
static inline void
treeland_app_id_resolver_manager_v1_destroy(struct treeland_app_id_resolver_manager_v1 *treeland_app_id_resolver_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_app_id_resolver_manager_v1,
			 TREELAND_APP_ID_RESOLVER_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 *
 * Create or bind a resolver object. Only one resolver may be registered
 * per session. Treeland is a multi-user compositor; different user
 * sessions may each register their own resolver. If a resolver is
 * already bound in the same session, the compositor will report an
 * error on the manager and will NOT create a new resolver object for
 * this request.
 */
static inline struct treeland_app_id_resolver_v1 *
treeland_app_id_resolver_manager_v1_get_resolver(struct treeland_app_id_resolver_manager_v1 *treeland_app_id_resolver_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_app_id_resolver_manager_v1,
			 TREELAND_APP_ID_RESOLVER_MANAGER_V1_GET_RESOLVER, &treeland_app_id_resolver_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_manager_v1), 0, NULL);

	return (struct treeland_app_id_resolver_v1 *) id;
}

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 * @struct treeland_app_id_resolver_v1_listener
 */
struct treeland_app_id_resolver_v1_listener {
	/**
	 * ask client to resolve pidfd to application id
	 *
	 * 
	 * @param request_id monotonic id generated by compositor
	 * @param pidfd pidfd referencing the target process
	 */
	void (*identify_request)(void *data,
				 struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1,
				 uint32_t request_id,
				 int32_t pidfd);
};

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
static inline int
treeland_app_id_resolver_v1_add_listener(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1,
					 const struct treeland_app_id_resolver_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_app_id_resolver_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_APP_ID_RESOLVER_V1_RESPOND 0
#define TREELAND_APP_ID_RESOLVER_V1_DESTROY 1

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_IDENTIFY_REQUEST_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_RESPOND_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_app_id_resolver_v1 */
static inline void
treeland_app_id_resolver_v1_set_user_data(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_app_id_resolver_v1, user_data);
}

/** @ingroup iface_treeland_app_id_resolver_v1 */
static inline void *
treeland_app_id_resolver_v1_get_user_data(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_app_id_resolver_v1);
}

static inline uint32_t
treeland_app_id_resolver_v1_get_version(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_v1);
}

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 *
 * Respond to an identify_request. The sandbox_engine_name must be provided and
 * matches the context in which the process is running (container, sandbox, etc).
 * If resolution fails, respond with an empty app_id.
 */
static inline void
treeland_app_id_resolver_v1_respond(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1, uint32_t request_id, const char *app_id, const char *sandbox_engine_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_app_id_resolver_v1,
			 TREELAND_APP_ID_RESOLVER_V1_RESPOND, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_v1), 0, request_id, app_id, sandbox_engine_name);
}

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
static inline void
treeland_app_id_resolver_v1_destroy(struct treeland_app_id_resolver_v1 *treeland_app_id_resolver_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_app_id_resolver_v1,
			 TREELAND_APP_ID_RESOLVER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_app_id_resolver_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
