// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "CornersProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::CornersPropertyPrivate
{
public:
    std::optional<CornerProperty> topLeft;
    std::optional<CornerProperty> topRight;
    std::optional<CornerProperty> bottomLeft;
    std::optional<CornerProperty> bottomRight;
};

CornersProperty::CornersProperty()
    : d(std::make_unique<CornersPropertyPrivate>())
{
}

CornersProperty::CornersProperty(const CornersProperty &other)
    : d(std::make_unique<CornersPropertyPrivate>())
{
    d->topLeft = other.d->topLeft;
    d->topRight = other.d->topRight;
    d->bottomLeft = other.d->bottomLeft;
    d->bottomRight = other.d->bottomRight;
}

CornersProperty::CornersProperty(CornersProperty &&other)
    : d(std::move(other.d))
{
}

CornersProperty::~CornersProperty() = default;

CornersProperty &CornersProperty::operator=(const CornersProperty &other)
{
    if (this != &other) {
        d->topLeft = other.d->topLeft;
        d->topRight = other.d->topRight;
        d->bottomLeft = other.d->bottomLeft;
        d->bottomRight = other.d->bottomRight;
    }
    return *this;
}

CornersProperty &CornersProperty::operator=(CornersProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<CornerProperty> CornersProperty::topLeft() const
{
    return d->topLeft;
}

CornerProperty CornersProperty::topLeft_or_new() const
{
    return d->topLeft.value_or(CornerProperty{});
}

void CornersProperty::setTopLeft(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->topLeft) {
        return;
    }

    d->topLeft = newValue;
}
std::optional<CornerProperty> CornersProperty::topRight() const
{
    return d->topRight;
}

CornerProperty CornersProperty::topRight_or_new() const
{
    return d->topRight.value_or(CornerProperty{});
}

void CornersProperty::setTopRight(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->topRight) {
        return;
    }

    d->topRight = newValue;
}
std::optional<CornerProperty> CornersProperty::bottomLeft() const
{
    return d->bottomLeft;
}

CornerProperty CornersProperty::bottomLeft_or_new() const
{
    return d->bottomLeft.value_or(CornerProperty{});
}

void CornersProperty::setBottomLeft(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->bottomLeft) {
        return;
    }

    d->bottomLeft = newValue;
}
std::optional<CornerProperty> CornersProperty::bottomRight() const
{
    return d->bottomRight;
}

CornerProperty CornersProperty::bottomRight_or_new() const
{
    return d->bottomRight.value_or(CornerProperty{});
}

void CornersProperty::setBottomRight(const std::optional<CornerProperty> &newValue)
{
    if (newValue == d->bottomRight) {
        return;
    }

    d->bottomRight = newValue;
}

bool CornersProperty::hasAnyValue() const
{
    if (d->topLeft.has_value() && d->topLeft->hasAnyValue()) {
        return true;
    }
    if (d->topRight.has_value() && d->topRight->hasAnyValue()) {
        return true;
    }
    if (d->bottomLeft.has_value() && d->bottomLeft->hasAnyValue()) {
        return true;
    }
    if (d->bottomRight.has_value() && d->bottomRight->hasAnyValue()) {
        return true;
    }
    return false;
}

bool CornersProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->topLeft.has_value() && !d->topLeft->isEmpty()) {
        return false;
    }
    if (d->topRight.has_value() && !d->topRight->isEmpty()) {
        return false;
    }
    if (d->bottomLeft.has_value() && !d->bottomLeft->isEmpty()) {
        return false;
    }
    if (d->bottomRight.has_value() && !d->bottomRight->isEmpty()) {
        return false;
    }

    return true;
}

void CornersProperty::resolveProperties(const CornersProperty &source, CornersProperty &destination)
{
    if (source.d->topLeft.has_value()) {
        CornerProperty property;
        if (destination.d->topLeft.has_value()) {
            property = destination.d->topLeft.value();
        }
        CornerProperty::resolveProperties(source.d->topLeft.value(), property);
        if (property.hasAnyValue()) {
            destination.d->topLeft = property;
        }
    }
    if (source.d->topRight.has_value()) {
        CornerProperty property;
        if (destination.d->topRight.has_value()) {
            property = destination.d->topRight.value();
        }
        CornerProperty::resolveProperties(source.d->topRight.value(), property);
        if (property.hasAnyValue()) {
            destination.d->topRight = property;
        }
    }
    if (source.d->bottomLeft.has_value()) {
        CornerProperty property;
        if (destination.d->bottomLeft.has_value()) {
            property = destination.d->bottomLeft.value();
        }
        CornerProperty::resolveProperties(source.d->bottomLeft.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottomLeft = property;
        }
    }
    if (source.d->bottomRight.has_value()) {
        CornerProperty property;
        if (destination.d->bottomRight.has_value()) {
            property = destination.d->bottomRight.value();
        }
        CornerProperty::resolveProperties(source.d->bottomRight.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottomRight = property;
        }
    }
}

CornersProperty CornersProperty::empty()
{
    CornersProperty result;
    result.d->topLeft = emptyValue<CornerProperty>();
    result.d->topRight = emptyValue<CornerProperty>();
    result.d->bottomLeft = emptyValue<CornerProperty>();
    result.d->bottomRight = emptyValue<CornerProperty>();
    return result;
}

bool Union::Properties::operator==(const CornersProperty &left, const CornersProperty &right)
{
    if (left.topLeft() != right.topLeft()) {
        return false;
    }
    if (left.topRight() != right.topRight()) {
        return false;
    }
    if (left.bottomLeft() != right.bottomLeft()) {
        return false;
    }
    if (left.bottomRight() != right.bottomRight()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::CornersProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "CornersProperty(" //
                    << "topLeft: " << type.topLeft() //
                    << ", topRight: " << type.topRight() //
                    << ", bottomLeft: " << type.bottomLeft() //
                    << ", bottomRight: " << type.bottomRight() //
                    << ")";
    return debug;
}