// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/IconProperty.h>

#include "AlignmentPropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype IconPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of IconProperty to QML.
 */
class IconPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit IconPropertyGroup(QuickStyle *style);

    void update(Union::Properties::IconProperty *newState);
    Q_SIGNAL void updated();

    void refreshColors();

    /*!
     * \qmlproperty AlignmentPropertyGroup IconPropertyGroup::alignment
     *
     * Exposes IconProperty::AlignmentProperty to QML.
     */
    Q_PROPERTY(AlignmentPropertyGroup *alignment READ alignment CONSTANT)
    AlignmentPropertyGroup *alignment() const;

    /*!
     * \qmlproperty qreal IconPropertyGroup::width
     *
     * Exposes IconProperty::width to QML.
     */
    Q_PROPERTY(QJSValue width READ width NOTIFY widthChanged)
    QJSValue width() const;
    Q_SIGNAL void widthChanged();

    /*!
     * \qmlproperty qreal IconPropertyGroup::height
     *
     * Exposes IconProperty::height to QML.
     */
    Q_PROPERTY(QJSValue height READ height NOTIFY heightChanged)
    QJSValue height() const;
    Q_SIGNAL void heightChanged();

    /*!
     * \qmlproperty QString IconPropertyGroup::name
     *
     * Exposes IconProperty::name to QML.
     */
    Q_PROPERTY(QJSValue name READ name NOTIFY nameChanged)
    QJSValue name() const;
    Q_SIGNAL void nameChanged();

    /*!
     * \qmlproperty QUrl IconPropertyGroup::source
     *
     * Exposes IconProperty::source to QML.
     */
    Q_PROPERTY(QJSValue source READ source NOTIFY sourceChanged)
    QJSValue source() const;
    Q_SIGNAL void sourceChanged();

    /*!
     * \qmlproperty Union::Color IconPropertyGroup::color
     *
     * Exposes IconProperty::color to QML.
     */
    Q_PROPERTY(QJSValue color READ color NOTIFY colorChanged)
    QJSValue color() const;
    Q_SIGNAL void colorChanged();

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<AlignmentPropertyGroup> m_alignment;

    Union::Properties::IconProperty *m_state = nullptr;
};