package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClientKey invokes the kms.GetClientKey API synchronously
func (client *Client) GetClientKey(request *GetClientKeyRequest) (response *GetClientKeyResponse, err error) {
	response = CreateGetClientKeyResponse()
	err = client.DoAction(request, response)
	return
}

// GetClientKeyWithChan invokes the kms.GetClientKey API asynchronously
func (client *Client) GetClientKeyWithChan(request *GetClientKeyRequest) (<-chan *GetClientKeyResponse, <-chan error) {
	responseChan := make(chan *GetClientKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClientKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClientKeyWithCallback invokes the kms.GetClientKey API asynchronously
func (client *Client) GetClientKeyWithCallback(request *GetClientKeyRequest, callback func(response *GetClientKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClientKeyResponse
		var err error
		defer close(result)
		response, err = client.GetClientKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClientKeyRequest is the request struct for api GetClientKey
type GetClientKeyRequest struct {
	*requests.RpcRequest
	ClientKeyId string `position:"Query" name:"ClientKeyId"`
}

// GetClientKeyResponse is the response struct for api GetClientKey
type GetClientKeyResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ClientKeyId   string `json:"ClientKeyId" xml:"ClientKeyId"`
	CreateTime    string `json:"CreateTime" xml:"CreateTime"`
	KeyAlgorithm  string `json:"KeyAlgorithm" xml:"KeyAlgorithm"`
	KeyOrigin     string `json:"KeyOrigin" xml:"KeyOrigin"`
	PublicKeyData string `json:"PublicKeyData" xml:"PublicKeyData"`
	NotAfter      string `json:"NotAfter" xml:"NotAfter"`
	NotBefore     string `json:"NotBefore" xml:"NotBefore"`
	AapName       string `json:"AapName" xml:"AapName"`
}

// CreateGetClientKeyRequest creates a request to invoke GetClientKey API
func CreateGetClientKeyRequest() (request *GetClientKeyRequest) {
	request = &GetClientKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "GetClientKey", "kms", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetClientKeyResponse creates a response to parse from GetClientKey response
func CreateGetClientKeyResponse() (response *GetClientKeyResponse) {
	response = &GetClientKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
