
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1fa7a */
    uint64_t offMsgShort : 17; /* max 0x1fa7c */
    uint64_t offMsgFull  : 17; /* max 0x1fa7c */
    uint64_t cchMsgFull  :  9; /* max 0x170 */
    int32_t  iCode       : 16;
    uint32_t cchDefine   :  6; /* max 0x2b */
    uint32_t cchMsgShort :  8; /* max 0x8a */
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2484*/ ] =
{
    { 0x01a4ac, 0x0058a3, 0x0058a3,  60, -27018,  18,  60 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00ddfa, 0x00c661, 0x00c661,  36, -27017,  32,  36 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x01085c, 0x00a640, 0x00a640,  40, -27016,  28,  40 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x00fec2, 0x009d10, 0x009d10,  42, -27015,  29,  42 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x00c176, 0x00b7e1, 0x00b7e1,  37, -27014,  36,  37 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x00aac8, 0x0081a8, 0x0081a8,  48, -27013,  40,  48 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x00a0d1, 0x00a338, 0x00a338,  41, -27012,  41,  41 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x00a9b0, 0x00e3fa, 0x00e3fa,  32, -27011,  40,  32 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x00bdf2, 0x00cbb8, 0x00cbb8,  35, -27010,  36,  35 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00cd7d, 0x00bbed, 0x00bbed,  37, -27009,  34,  37 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x00a480, 0x003c89, 0x003c89,  77, -27008,  41,  77 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x00b726, 0x00bbed, 0x00bbed,  37, -27007,  38,  37 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x00bb59, 0x00c1e2, 0x00c1e2,  36, -27006,  37,  36 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x00b240, 0x009b18, 0x009b18,  42, -27005,  38,  42 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x013632, 0x0088e4, 0x0088e4,  47, -27004,  25,  47 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00a730, 0x00bca6, 0x00bca6,  37, -27003,  40,  37 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x015263, 0x013ca4, 0x013ca4,  25, -27002,  23,  25 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x012796, 0x015543, 0x015543,  23, -27001,  26,  23 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x01a104, 0x014295, 0x014295,  24, -27000,  18,  24 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x01951a, 0x01b55a, 0x01b55a,  16, -26820,  19,  16 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x01bcda, 0x01d730, 0x01d730,  13, -26819,  16,  13 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x0175e4, 0x0133a8, 0x0133a8,  25, -26818,  21,  25 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00f5f6, 0x007c84, 0x007c84,  50, -26817,  30,  50 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x017c9b, 0x0101ee, 0x0101ee,  29, -26816,  20,  29 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x018fe8, 0x0113f4, 0x0113f4,  28, -26815,  19,  28 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x017d9f, 0x01b222, 0x01b222,  17, -26814,  20,  17 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x0163db, 0x018c45, 0x018c45,  19, -26813,  22,  19 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x017209, 0x019b9a, 0x019b9a,  18, -26812,  21,  18 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x012748, 0x00ccd0, 0x00ccd0,  35, -26811,  26,  35 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x015080, 0x00e05a, 0x00e05a,  32, -26810,  23,  32 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x017359, 0x010824, 0x010824,  28, -26804,  21,  28 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x01161d, 0x00b9e7, 0x00b9e7,  37, -26803,  27,  37 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00f75e, 0x00a38a, 0x00a38a,  41, -26802,  30,  41 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x01093c, 0x0146b5, 0x0146b5,  24, -26801,  28,  24 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x010537, 0x0071f1, 0x0071f1,  53, -26602,  29,  53 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00e13a, 0x01c4de, 0x01c4de,  15, -26601,  32,  15 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00fa10, 0x015dc1, 0x015dc1,  22, -26600,  30,  22 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x013745, 0x015a06, 0x015a06,  23, -26406,  25,  23 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x01d394, 0x01f12e, 0x01f12e,   9, -26405,  14,   9 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x0111fc, 0x00e61a, 0x00e61a,  32, -26404,  28,  32 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x01b200, 0x019b0a, 0x019b0a,  18, -26403,  17,  18 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x01708f, 0x019b0a, 0x019b0a,  18, -26402,  21,  18 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01e95a, 0x017f2f, 0x017f2f,  20, -26401,  11,  20 }, /* VERR_FTP_INIT_FAILED */
    { 0x017be7, 0x01a476, 0x01a476,  18, -26400,  20,  18 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x01da63, 0x007c20, 0x007c20,  50, -26203,  13,  50 }, /* VERR_IOQUEUE_BUSY */
    { 0x01d42e, 0x004972, 0x004972,  68, -26202,  14,  68 }, /* VERR_IOQUEUE_EMPTY */
    { 0x01d612, 0x00a219, 0x00a219,  41, -26201,  13,  41 }, /* VERR_IOQUEUE_FULL */
    { 0x011638, 0x00b5d0, 0x00b5d0,  38, -26200,  27,  38 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00efd2, 0x011710, 0x011710,  27, -26000,  31,  27 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x015aa7, 0x009595, 0x009595,  43, -25811,  23,  43 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x014f3f, 0x0095c0, 0x0095c0,  43, -25810,  23,  43 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x017a7f, 0x01e1b8, 0x01e1b8,  12, -25809,  20,  12 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x00b6da, 0x00f1be, 0x00f1be,  30, -25808,  38,  30 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x018083, 0x01e0bc, 0x01e0bc,  12, -25807,  20,  12 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x0105e5, 0x019e8e, 0x019e8e,  18, -25806,  29,  18 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00f650, 0x01906d, 0x01906d,  19, -25805,  30,  19 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x010a1c, 0x01ade2, 0x01ade2,  17, -25804,  28,  17 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x00fea5, 0x019d80, 0x019d80,  18, -25803,  29,  18 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00f9d4, 0x019436, 0x019436,  19, -25802,  30,  19 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x010798, 0x01a95f, 0x01a95f,  17, -25801,  28,  17 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01e8aa, 0x01f4d9, 0x01f4d9,   8, -25800,  11,   8 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x01a194, 0x01f9b9, 0x01f9b9,   5, -25799,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x019f9c, 0x01f950, 0x01f950,   5, -25798,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x019fae, 0x01f955, 0x01f955,   5, -25797,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x019fc0, 0x01f9d2, 0x01f9d2,   5, -25796,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x01a182, 0x01f98c, 0x01f98c,   5, -25795,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x01a01a, 0x01f9a5, 0x01f9a5,   5, -25794,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x019fd2, 0x01f978, 0x01f978,   5, -25793,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x019fe4, 0x01f982, 0x01f982,   5, -25792,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x01a008, 0x01f9c3, 0x01f9c3,   5, -25791,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x00bea6, 0x0114d4, 0x0114d4,  28, -25713,  36,  28 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x00c6ef, 0x00d43f, 0x00d43f,  33, -25712,  35,  33 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x013b5f, 0x01905a, 0x01905a,  19, -25711,  25,  19 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00c565, 0x01ad39, 0x01ad39,  17, -25710,  36,  17 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00f95c, 0x019047, 0x019047,  19, -25709,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x00dffa, 0x01c4ed, 0x01c4ed,  15, -25708,  32,  15 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00dcba, 0x017176, 0x017176,  21, -25707,  32,  21 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00d670, 0x01653b, 0x01653b,  22, -25706,  33,  22 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00f77c, 0x018aa4, 0x018aa4,  19, -25705,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x011b12, 0x01c089, 0x01c089,  15, -25704,  27,  15 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00d19a, 0x008d0e, 0x008d0e,  46, -25703,  34,  46 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00dbb9, 0x009513, 0x009513,  44, -25702,  33,  44 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x01003b, 0x011bea, 0x011bea,  27, -25701,  29,  27 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00f7f4, 0x009a70, 0x009a70,  42, -25700,  30,  42 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x0176a1, 0x009ce6, 0x009ce6,  42, -25501,  21,  42 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x01299e, 0x008c84, 0x008c84,  46, -25500,  26,  46 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01fa21, 0x01de46, 0x01de46,   6, -25395,   4,   6 }, /* VERR_ISOFS_IPE_5 */
    { 0x01fa25, 0x01df4e, 0x01df4e,   6, -25394,   4,   6 }, /* VERR_ISOFS_IPE_4 */
    { 0x01fa29, 0x01e06e, 0x01e06e,   6, -25393,   4,   6 }, /* VERR_ISOFS_IPE_3 */
    { 0x01fa2d, 0x01dca2, 0x01dca2,   6, -25392,   4,   6 }, /* VERR_ISOFS_IPE_2 */
    { 0x01fa31, 0x01de0a, 0x01de0a,   6, -25391,   4,   6 }, /* VERR_ISOFS_IPE_1 */
    { 0x0197ab, 0x0169ff, 0x0169ff,  21, -25390,  18,  21 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x0177b2, 0x00a59f, 0x00a59f,  41, -25352,  21,  41 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT */
    { 0x01a42e, 0x0101b4, 0x0101b4,  29, -25351,  18,  29 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_DIR */
    { 0x0181ff, 0x01bdaa, 0x01bdaa,  16, -25350,  20,  16 }, /* VERR_ISOFS_BOGUS_UDF_DIR_SIZE */
    { 0x013b2d, 0x01838f, 0x01838f,  20, -25349,  25,  20 }, /* VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD */
    { 0x015b43, 0x01a8b5, 0x01a8b5,  17, -25348,  22,  17 }, /* VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS */
    { 0x00dd3a, 0x01103c, 0x01103c,  28, -25347,  32,  28 }, /* VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH */
    { 0x015f79, 0x00fc0a, 0x00fc0a,  29, -25346,  22,  29 }, /* VERR_ISOFS_BOGUS_NEXT_AD_LENGTH */
    { 0x01e40f, 0x01daff, 0x01daff,  13, -25345,  12,  13 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01ab6e, 0x01ddb0, 0x01ddb0,  12, -25344,  17,  12 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01f461, 0x01710d, 0x01710d,  21, -25343,   8,  21 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01caaa, 0x01f301, 0x01f301,   8, -25342,  14,   8 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01dc1d, 0x01f17f, 0x01f17f,   9, -25341,  13,   9 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01f8db, 0x01e71e, 0x01e71e,  11, -25340,   6,  11 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x019ad4, 0x00b875, 0x00b875,  37, -25339,  18,  37 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x016afb, 0x017d3b, 0x017d3b,  20, -25338,  21,  20 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x01451d, 0x00bf36, 0x00bf36,  36, -25337,  24,  36 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x01703b, 0x0169ab, 0x0169ab,  21, -25336,  21,  21 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x01e038, 0x01d092, 0x01d092,  14, -25335,  12,  14 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01ec22, 0x01e0e0, 0x01e0e0,  12, -25334,  10,  12 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x01acf5, 0x00dd1a, 0x00dd1a,  32, -25333,  17,  32 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x0192a7, 0x009bc0, 0x009bc0,  42, -25332,  19,  42 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x01c020, 0x01a94e, 0x01a94e,  17, -25331,  15,  17 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x01a452, 0x00fdda, 0x00fdda,  29, -25330,  18,  29 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x017f6b, 0x00a618, 0x00a618,  40, -25329,  20,  40 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x010001, 0x0120fa, 0x0120fa,  27, -25327,  29,  27 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x01b5fa, 0x0166f3, 0x0166f3,  22, -25326,  16,  22 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x017749, 0x00db35, 0x00db35,  33, -25325,  21,  33 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01f589, 0x007b8a, 0x007b8a,  50, -25324,   8,  50 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01f409, 0x007a5e, 0x007a5e,  50, -25323,   8,  50 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01f481, 0x007f95, 0x007f95,  49, -25322,   8,  49 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x019118, 0x00981a, 0x00981a,  43, -25321,  19,  43 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x015b9b, 0x016c21, 0x016c21,  21, -25320,  22,  21 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x0115cc, 0x00beee, 0x00beee,  36, -25319,  27,  36 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x01cc5c, 0x009de2, 0x009de2,  42, -25318,  14,  42 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x012d7a, 0x00bc37, 0x00bc37,  37, -25317,  26,  37 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x01b266, 0x01020b, 0x01020b,  29, -25316,  17,  29 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x01c4c0, 0x0069e7, 0x0069e7,  55, -25315,  15,  55 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x01c2b4, 0x006afa, 0x006afa,  55, -25314,  15,  55 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01f9d7, 0x01490d, 0x01490d,  24, -25313,   5,  24 }, /* VERR_ISOFS_NO_PD */
    { 0x01f845, 0x015896, 0x015896,  23, -25312,   6,  23 }, /* VERR_ISOFS_NO_LVD */
    { 0x01f8b7, 0x01576b, 0x01576b,  23, -25311,   6,  23 }, /* VERR_ISOFS_NO_PVD */
    { 0x016d32, 0x00d460, 0x00d460,  33, -25310,  21,  33 }, /* VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD */
    { 0x01e734, 0x0141ed, 0x0141ed,  24, -25309,  11,  24 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01de94, 0x01524c, 0x01524c,  23, -25308,  12,  23 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01e278, 0x0150ae, 0x0150ae,  23, -25307,  12,  23 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01e57c, 0x00c032, 0x00c032,  36, -25306,  11,  36 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00e3ba, 0x012a6e, 0x012a6e,  26, -25305,  32,  26 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x01e0b0, 0x014a74, 0x014a74,  24, -25304,  12,  24 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x01cbb4, 0x00e6f9, 0x00e6f9,  32, -25303,  14,  32 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x01c691, 0x01c16a, 0x01c16a,  15, -25302,  15,  15 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01d36a, 0x01d156, 0x01d156,  14, -25301,  14,  14 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x019799, 0x012e64, 0x012e64,  26, -25300,  18,  26 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x012382, 0x00a8c0, 0x00a8c0,  40, -25162,  27,  40 }, /* VERR_ISOMK_IMPORT_UDF_FILE_WITH_STREAM_DIR */
    { 0x01b310, 0x00cb09, 0x00cb09,  35, -25161,  17,  35 }, /* VERR_ISOMK_IMPORT_UDF_UNSUPPORTED_FILE_TYPE */
    { 0x01a6b6, 0x00e5da, 0x00e5da,  32, -25160,  18,  32 }, /* VERR_ISOMK_IMPORT_UDF_SPARSE_FILE */
    { 0x01475d, 0x006032, 0x006032,  58, -25159,  24,  58 }, /* VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS */
    { 0x01c484, 0x017c0f, 0x017c0f,  20, -25158,  15,  20 }, /* VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG */
    { 0x00cef3, 0x004566, 0x004566,  70, -25157,  34,  70 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x00a6b8, 0x003bee, 0x003bee,  78, -25156,  40,  78 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x00c7e4, 0x003e52, 0x003e52,  75, -25155,  35,  75 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x00b953, 0x006117, 0x006117,  57, -25154,  37,  57 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x013457, 0x00425a, 0x00425a,  72, -25153,  25,  72 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00f06d, 0x00ac56, 0x00ac56,  39, -25152,  31,  39 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00daf3, 0x0055cd, 0x0055cd,  62, -25151,  33,  62 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00fc44, 0x00b408, 0x00b408,  38, -25150,  29,  38 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x00b772, 0x0069b0, 0x0069b0,  55, -25149,  37,  55 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x00cc44, 0x00c8fc, 0x00c8fc,  35, -25148,  35,  35 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00e92a, 0x00da2d, 0x00da2d,  33, -25147,  31,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x010ed0, 0x00d904, 0x00d904,  33, -25146,  28,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x010f5c, 0x00d4e4, 0x00d4e4,  33, -25145,  28,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x015ffd, 0x010707, 0x010707,  29, -25144,  22,  29 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00ddda, 0x009149, 0x009149,  45, -25143,  32,  45 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x01150c, 0x00a708, 0x00a708,  40, -25142,  28,  40 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00dab1, 0x008e4c, 0x008e4c,  45, -25141,  33,  45 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x012dfc, 0x00eefa, 0x00eefa,  31, -25140,  26,  31 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00fa4c, 0x006a1e, 0x006a1e,  55, -25133,  30,  55 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x012644, 0x005323, 0x005323,  62, -25132,  26,  62 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00ea9e, 0x0048ea, 0x0048ea,  68, -25131,  31,  68 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x014d14, 0x008652, 0x008652,  47, -25130,  24,  47 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x011ec3, 0x00ae03, 0x00c24e,  36, -25129,  20,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x011ec3, 0x00ae03, 0x00ae03,  39, -25128,  27,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x019d38, 0x010a54, 0x010a54,  28, -25127,  18,  28 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00ec50, 0x00f164, 0x00f164,  30, -25126,  31,  30 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x014565, 0x008ce0, 0x008ce0,  46, -25125,  24,  46 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x019d38, 0x01a15e, 0x01a15e,  18, -25124,  11,  18 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x01ad06, 0x01786f, 0x01786f,  21, -25123,  17,  21 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x011bcf, 0x00f704, 0x00f704,  30, -25122,  27,  30 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x010c4c, 0x00ed86, 0x00ed86,  31, -25121,  28,  31 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x015799, 0x00d505, 0x00d505,  33, -25120,  23,  33 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00ddba, 0x00d310, 0x00d310,  34, -25119,  32,  34 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x0171df, 0x0091cf, 0x0091cf,  44, -25118,  21,  44 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x01650f, 0x00dc7a, 0x00dc7a,  32, -25117,  22,  32 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x015799, 0x015360, 0x015360,  23, -25116,  16,  23 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x019ec4, 0x00558f, 0x00558f,  62, -25115,  18,  62 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x016383, 0x00502a, 0x00502a,  64, -25114,  22,  64 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x019ca8, 0x0126c6, 0x0126c6,  26, -25113,  18,  26 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00fb78, 0x01b255, 0x01b255,  17, -25112,  30,  17 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x013004, 0x00a758, 0x00a758,  40, -25111,  26,  40 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x01dbc2, 0x01243c, 0x01243c,  26, -25110,  13,  26 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x017623, 0x00a07f, 0x00a07f,  41, -25109,  21,  41 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x017b97, 0x017fe3, 0x017fe3,  20, -25108,  20,  20 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x010e28, 0x00ca14, 0x00ca14,  35, -25107,  28,  35 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00ec12, 0x0076a1, 0x0076a1,  51, -25106,  31,  51 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x010e98, 0x015024, 0x015024,  23, -25105,  28,  23 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x0120c4, 0x0136c8, 0x0136c8,  25, -25104,  27,  25 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x010092, 0x014955, 0x014955,  24, -25103,  29,  24 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01be8a, 0x01d47f, 0x01d47f,  13, -25102,  16,  13 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x01a1ee, 0x015f37, 0x015f37,  22, -25101,  18,  22 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01ec9a, 0x00f59c, 0x00f59c,  30, -25100,  10,  30 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x0187b2, 0x0103f8, 0x0103f8,  29, -25029,  20,  29 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x01d993, 0x00d244, 0x00d244,  34, -25028,  13,  34 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x018f89, 0x011deb, 0x011deb,  27, -25027,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x018f63, 0x011c71, 0x011c71,  27, -25026,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x018f76, 0x01157b, 0x01157b,  27, -25025,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x017b0b, 0x008358, 0x008358,  48, -25024,  20,  39 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x01b92a, 0x00dd9a, 0x00dd9a,  32, -25023,  16,  32 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01cb52, 0x015bb1, 0x015bb1,  22, -25022,  14,  22 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x01d9fb, 0x00da90, 0x00da90,  33, -25021,  13,  33 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x01db33, 0x00ecad, 0x00ecad,  31, -25020,  13,  31 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x01a5f0, 0x01223e, 0x01223e,  27, -25019,  18,  27 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x01d9d4, 0x01760e, 0x01760e,  21, -25018,  13,  21 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x01ceee, 0x00ee40, 0x00ee40,  31, -25017,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x01cefc, 0x00e7d5, 0x00e7d5,  31, -25016,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x01cf0a, 0x00e987, 0x00e987,  31, -25015,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x01cf18, 0x00e813, 0x00e813,  31, -25014,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x01cf26, 0x00ee7e, 0x00ee7e,  31, -25013,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x01cf42, 0x00ec31, 0x00ec31,  31, -25012,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01f341, 0x00e39a, 0x00e39a,  32, -25011,   8,  32 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01ecc2, 0x00d354, 0x00d354,  34, -25010,  10,  34 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x019ccc, 0x00ceaf, 0x00ceaf,  34, -25009,  18,  34 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x012f82, 0x006d8b, 0x006d8b,  54, -25008,  26,  54 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x014c9c, 0x005c1a, 0x005c1a,  59, -25007,  24,  59 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x0134d4, 0x0064e0, 0x0064e0,  57, -25006,  25,  57 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x01463d, 0x014355, 0x014355,  24, -25005,  24,  24 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x014b1c, 0x00d925, 0x00d925,  33, -25004,  24,  33 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x015e9d, 0x015782, 0x015782,  23, -25003,  22,  23 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x00cde3, 0x01fa74, 0x01fa74,   3, -25002,  34,   3 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x0136fa, 0x01324a, 0x01324a,  25, -25001,  25,  25 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x0110e4, 0x010e60, 0x010e60,  28, -25000,  28,  28 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x01c5b0, 0x008ae6, 0x008ae6,  46, -24804,  15,  46 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01eae2, 0x01b81a, 0x01b81a,  16, -24803,  10,  16 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x01c1e2, 0x00fe14, 0x00fe14,  29, -24802,  15,  29 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x01c529, 0x010676, 0x010676,  29, -24801,  15,  29 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01eb5a, 0x01b7ba, 0x01b7ba,  16, -24800,  10,  16 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x01bb0a, 0x01e519, 0x01e519,  11, -24707,  16,  11 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00f57e, 0x00df7a, 0x00df7a,  32, -24706,  30,  32 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x011250, 0x00f86c, 0x00f86c,  30, -24705,  28,  30 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x010d48, 0x0140cd, 0x0140cd,  24, -24704,  28,  24 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x01cc16, 0x0174e8, 0x0174e8,  21, -24703,  14,  21 }, /* VERR_JSON_IS_EMPTY */
    { 0x01c7ae, 0x012d46, 0x012d46,  26, -24702,  15,  26 }, /* VERR_JSON_MALFORMED */
    { 0x01a38c, 0x015377, 0x015377,  23, -24701,  18,  23 }, /* VERR_JSON_ITERATOR_END */
    { 0x01a6ea, 0x00a910, 0x00a910,  40, -24700,  17,  40 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x01acb1, 0x0121d2, 0x0121d2,  27, -24610,  17,  27 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00ccf3, 0x00573b, 0x00573b,  60, -24609,  35,  60 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x00c09e, 0x005d40, 0x005d40,  58, -24608,  36,  58 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x010db8, 0x0084d8, 0x0084d8,  48, -24607,  28,  48 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00f6c8, 0x00903b, 0x00903b,  45, -24606,  30,  45 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x01aa2b, 0x007431, 0x007431,  52, -24605,  17,  52 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x01bcea, 0x01aa1a, 0x01aa1a,  17, -24604,  16,  17 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x01b079, 0x01d583, 0x01d583,  13, -24603,  17,  13 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x01e140, 0x01f529, 0x01f529,   8, -24602,  12,   8 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01e566, 0x012181, 0x012181,  27, -24601,  11,  27 }, /* VERR_URI_TOO_SHORT */
    { 0x01ee0c, 0x01e427, 0x01e427,  12, -24600,  10,  12 }, /* VERR_URI_EMPTY */
    { 0x016315, 0x00f08c, 0x00f08c,  31, -24403,  22,  31 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00df5a, 0x0083e8, 0x0083e8,  48, -24402,  32,  48 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x016aa7, 0x01c457, 0x01c457,  15, -24400,  21,  15 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x016081, 0x00b6b4, 0x00b6b4,  38, -24399,  22,  38 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01e9fc, 0x008623, 0x008623,  47, -24398,  10,  47 }, /* VERR_CR_RANDOM_FAILED */
    { 0x01b75a, 0x008623, 0x008623,  47, -24397,  16,  47 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00f902, 0x00fda0, 0x00fda0,  29, -24396,  30,  29 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x015f63, 0x00fe6b, 0x00fe6b,  29, -24395,  22,  29 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01e85d, 0x015446, 0x015446,  23, -24205,  11,  23 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x00ffc7, 0x01111c, 0x01111c,  28, -24204,  29,  28 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x018353, 0x018b75, 0x018b75,  19, -24203,  20,  19 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x01920f, 0x01a086, 0x01a086,  18, -24202,  19,  18 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x00ed67, 0x012367, 0x012367,  27, -24201,  31,  27 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x011689, 0x00de9a, 0x00de9a,  32, -24200,  27,  32 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x0135ce, 0x009176, 0x009176,  45, -24002,  25,  45 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x0188dc, 0x01683d, 0x01683d,  22, -24001,  19,  22 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x014dcf, 0x0052a5, 0x0052a5,  63, -24000,  23,  63 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x01c907, 0x01f863, 0x01f863,   6, -23900,  15,   6 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x018ffb, 0x010415, 0x010415,  29, -23819,  19,  29 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x013826, 0x00ba0c, 0x00ba0c,  37, -23818,  25,  37 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x0131ff, 0x00a4a9, 0x00a4a9,  41, -23817,  25,  41 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x010b88, 0x012d2c, 0x012d2c,  26, -23816,  28,  26 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x01c9d9, 0x019164, 0x019164,  19, -23815,  15,  19 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x019af8, 0x006781, 0x006781,  56, -23813,  18,  56 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x013f60, 0x01828b, 0x01828b,  20, -23812,  25,  20 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x01594e, 0x00c2ba, 0x00c2ba,  36, -23811,  23,  36 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x013664, 0x007049, 0x007049,  53, -23810,  25,  53 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x01669b, 0x00759d, 0x00759d,  52, -23809,  22,  52 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x01186f, 0x00aa28, 0x00aa28,  40, -23808,  27,  40 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x017fcf, 0x007806, 0x007806,  50, -23807,  20,  50 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x01dbb5, 0x015993, 0x015993,  23, -23806,  13,  23 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x01952d, 0x01973f, 0x01973f,  18, -23805,  19,  18 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x017bab, 0x00c10a, 0x00c10a,  36, -23804,  20,  36 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x01c3ee, 0x004f2a, 0x004f2a,  64, -23803,  15,  64 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x01c002, 0x00c870, 0x00c870,  35, -23802,  15,  35 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x01c6cd, 0x01e41b, 0x01e41b,  12, -23801,  15,  12 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01e60b, 0x01166e, 0x01166e,  27, -23800,  11,  27 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x01b354, 0x01f2d1, 0x01f2d1,   8, -23700,  17,   8 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x0112dc, 0x00d83e, 0x00d83e,  33, -23527,  28,  33 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x0140b5, 0x019b2e, 0x019b2e,  18, -23526,  24,  18 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x013cd6, 0x018ecb, 0x018ecb,  19, -23525,  25,  19 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x016399, 0x01b46a, 0x01b46a,  16, -23524,  22,  16 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x015685, 0x01a750, 0x01a750,  17, -23523,  23,  17 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00cdc1, 0x00baa0, 0x00baa0,  37, -23522,  29,  37 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00cdc1, 0x009a1c, 0x009a1c,  42, -23521,  34,  42 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x014625, 0x010e0c, 0x010e0c,  28, -23520,  24,  28 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00fa88, 0x0093b3, 0x0093b3,  44, -23519,  30,  44 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x0106cd, 0x00f97a, 0x00f97a,  30, -23518,  29,  30 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x0118a5, 0x01367d, 0x01367d,  25, -23517,  27,  25 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x010cbc, 0x00fe88, 0x00fe88,  29, -23516,  28,  29 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x012fb6, 0x0172f0, 0x0172f0,  21, -23515,  26,  21 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00f39e, 0x00c349, 0x00c349,  36, -23514,  30,  36 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00cd5b, 0x00b324, 0x00b324,  38, -23513,  34,  38 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00cd5b, 0x00f920, 0x00f920,  30, -23512,  30,  30 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x01359c, 0x01792b, 0x01792b,  20, -23511,  25,  20 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00ebd4, 0x00a3dc, 0x00a3dc,  41, -23510,  31,  41 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x0199fd, 0x00f5d8, 0x00f5d8,  30, -23509,  18,  30 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x01493d, 0x01a4f4, 0x01a4f4,  18, -23508,  24,  18 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x013790, 0x016f2a, 0x016f2a,  21, -23507,  25,  21 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x0152d6, 0x00b34a, 0x00b34a,  38, -23506,  23,  38 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x0165bf, 0x00cb4f, 0x00cb4f,  35, -23505,  22,  35 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x0133da, 0x00989b, 0x00989b,  43, -23504,  25,  43 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01b299, 0x01fa7c, 0x01fa7c,   2, -23503,  17,   2 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x019670, 0x01dedc, 0x01dedc,  12, -23502,  19,  12 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00cf58, 0x006df7, 0x006df7,  54, -23501,  34,  54 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x01b9ca, 0x01eea2, 0x01eea2,  10, -23500,  16,  10 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x016013, 0x00cbdb, 0x00cbdb,  35, -23416,  22,  35 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x010c68, 0x0186ae, 0x0186ae,  20, -23415,  28,  20 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x014385, 0x018e7f, 0x018e7f,  19, -23414,  24,  19 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00e5ba, 0x012540, 0x012540,  26, -23413,  32,  26 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x01964a, 0x0130d3, 0x0130d3,  25, -23412,  19,  25 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x016f69, 0x0147ed, 0x0147ed,  24, -23411,  21,  24 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x0190cc, 0x01918a, 0x01918a,  19, -23410,  19,  19 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x0191e9, 0x013db7, 0x013db7,  25, -23409,  19,  25 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x011998, 0x0173ec, 0x0173ec,  21, -23408,  27,  21 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x01142c, 0x00f290, 0x00f290,  30, -23407,  28,  30 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x0107ec, 0x011544, 0x011544,  28, -23406,  28,  28 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x019be2, 0x01c736, 0x01c736,  15, -23405,  18,  15 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x009947, 0x0051e8, 0x0051e8,  63, -23404,  43,  63 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00caa0, 0x00abb8, 0x00abb8,  40, -23403,  35,  40 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x00f3f8, 0x004d21, 0x004d21,  66, -23402,  30,  66 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00eafb, 0x007838, 0x007838,  50, -23401,  31,  50 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x01c781, 0x01f851, 0x01f851,   6, -23400,  15,   6 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00e27a, 0x01e0d4, 0x01e0d4,  12, -23310,  32,  12 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x00f998, 0x0060a5, 0x0060a5,  57, -23309,  30,  57 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x00ee21, 0x0068d1, 0x0068d1,  56, -23308,  31,  56 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x00b99d, 0x00492e, 0x00492e,  68, -23307,  37,  68 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x0108cc, 0x006234, 0x006234,  57, -23306,  28,  57 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x010262, 0x0060de, 0x0060de,  57, -23305,  29,  57 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x00c7c1, 0x004b0a, 0x004b0a,  68, -23304,  35,  68 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x0193d7, 0x00e37a, 0x00e37a,  32, -23303,  19,  32 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x0122fb, 0x01e868, 0x01e868,  11, -23302,  27,  11 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x016943, 0x00b10f, 0x00b10f,  39, -23301,  21,  39 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x01b2bb, 0x01eea2, 0x01eea2,  10, -23300,  17,  10 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x0104c3, 0x00dfa2, 0x00dfa2,  24, -23109,  29,  24 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00b4ec, 0x01f2e9, 0x01f2e9,   8, -23108,  38,   8 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x0107b4, 0x015474, 0x015474,  23, -23107,  28,  23 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00d526, 0x010878, 0x010878,  28, -23106,  33,  28 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00d8c2, 0x00b42e, 0x00b42e,  38, -23105,  33,  38 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x013952, 0x013150, 0x013150,  25, -23104,  25,  25 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00f93e, 0x01e0d4, 0x01e0d4,  12, -23103,  30,  12 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00d3dc, 0x00d5cb, 0x00d5cb,  33, -23102,  33,  33 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00f4ac, 0x00991c, 0x00991c,  43, -23101,  30,  43 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011f4a, 0x00d4a2, 0x00d4a2,  33, -23100,  27,  33 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x01a7a5, 0x0199d9, 0x0199d9,  18, -23090,  17,  18 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x0185be, 0x013b78, 0x013b78,  25, -23037,  20,  25 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00c421, 0x0066d9, 0x0066d9,  56, -23036,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00c2de, 0x0065f9, 0x0065f9,  56, -23035,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x00b04c, 0x006e2d, 0x006e2d,  54, -23034,  39,  54 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x013425, 0x014fb1, 0x014fb1,  23, -23033,  25,  23 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x018c6b, 0x00786a, 0x00786a,  50, -23032,  19,  50 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f48e, 0x007d18, 0x007d18,  49, -23031,  30,  49 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x012e16, 0x00bb34, 0x00bb34,  37, -23030,  26,  37 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x011db5, 0x00c8b6, 0x00c8b6,  35, -23029,  27,  35 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x012470, 0x00e15a, 0x00e15a,  32, -23028,  26,  32 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x018961, 0x00c0c2, 0x00c0c2,  36, -23027,  19,  36 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x019319, 0x008886, 0x008886,  47, -23026,  19,  47 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x012984, 0x007bbc, 0x007bbc,  50, -23025,  26,  50 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x00e19a, 0x007c52, 0x007c52,  50, -23024,  32,  50 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00f542, 0x0144d5, 0x0144d5,  24, -23023,  30,  24 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x01472d, 0x01a626, 0x01a626,  18, -23022,  24,  18 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x013afb, 0x018987, 0x018987,  19, -23021,  25,  19 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x00d85f, 0x009b96, 0x009b96,  42, -23020,  33,  42 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00d1bc, 0x016a29, 0x016a29,  21, -23019,  34,  21 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x014d8a, 0x0045f2, 0x0045f2,  70, -23018,  23,  32 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x0133f3, 0x00d3fd, 0x00d3fd,  33, -23017,  25,  24 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x016a7d, 0x0109e4, 0x0109e4,  28, -23016,  21,  19 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x019281, 0x011c8c, 0x011c8c,  27, -23015,  19,  15 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x01487d, 0x015cfb, 0x015cfb,  22, -23014,  24,  10 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x015138, 0x01597c, 0x01597c,  23, -23013,  23,  11 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x014c6c, 0x019553, 0x019553,  19, -23012,  24,  19 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x01500d, 0x01b71a, 0x01b71a,  16, -23011,  23,   3 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x009f5c, 0x00fd66, 0x00fd66,  29, -23010,  42,  29 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00e21a, 0x00b073, 0x00b073,  39, -23009,  32,  39 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x012eb2, 0x00e65a, 0x00e65a,  32, -23008,  26,  32 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x011a55, 0x004fea, 0x004fea,  64, -23007,  27,  64 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x015640, 0x016d9b, 0x016d9b,  21, -23006,  23,  21 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x0163c5, 0x011074, 0x011074,  28, -23005,  22,   3 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x01806f, 0x019d5c, 0x019d5c,  18, -23004,  20,  18 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x01ba5a, 0x018ea5, 0x018ea5,  19, -23003,  16,  19 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x0118f6, 0x014a2d, 0x014a2d,  24, -23002,  27,   6 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01ac8f, 0x014a2d, 0x01e94f,  11, -23001,  17,   6 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x01bcaa, 0x01f539, 0x01f539,   8, -23000,  16,   3 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00fc9b, 0x00fbd0, 0x00fbd0,  29, -22992,  29,  29 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x019775, 0x00f560, 0x00f560,  30, -22991,  18,  30 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x01a783, 0x01ac3a, 0x01ac3a,  17, -22990,  17,  17 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x01d20c, 0x01f421, 0x01f421,   8, -22989,  14,   8 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x01d228, 0x01f5a1, 0x01f5a1,   8, -22988,  14,   8 }, /* VERR_LDRLX_NO_SONAME */
    { 0x01cfc0, 0x01d646, 0x01d646,  13, -22987,  14,  13 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x01a8c6, 0x011a70, 0x011a70,  27, -22986,  17,  27 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x01a8c6, 0x013263, 0x013263,  25, -22985,  16,  25 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01b94a, 0x013d53, 0x013d53,  25, -22984,  16,  25 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x017cd7, 0x019696, 0x019696,  19, -22983,  20,  19 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x016d47, 0x00bc12, 0x00bc12,  37, -22982,  21,  37 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x0167b9, 0x00dd7a, 0x00dd7a,  32, -22981,  22,  32 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x01ce0e, 0x01b0bd, 0x01b0bd,  17, -22980,  14,  17 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x0178ed, 0x01b024, 0x01b024,  17, -22979,  21,  17 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01e637, 0x01d55c, 0x01d55c,  13, -22978,  11,  13 }, /* VERR_LDR_BAD_FIXUP */
    { 0x01bf59, 0x01f762, 0x01f762,   7, -22977,  16,   7 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x0118c0, 0x014f9a, 0x014f9a,  23, -22976,  27,  23 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x015ec9, 0x01403d, 0x01403d,  24, -22975,  22,  24 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01cbc2, 0x01228f, 0x01228f,  27, -22974,  14,  27 }, /* VERR_LDRMACHO_TODO */
    { 0x011c56, 0x00a7f8, 0x00a7f8,  40, -22973,  27,  40 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00cae6, 0x00a8e8, 0x00a8e8,  40, -22972,  35,  40 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x0177c7, 0x01dd38, 0x01dd38,  12, -22971,  21,  12 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01b2cc, 0x01c961, 0x01c961,  15, -22970,  17,  15 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x015c35, 0x01b67a, 0x01b67a,  16, -22969,  22,  16 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01b046, 0x008ea6, 0x008ea6,  45, -22968,  17,  45 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x014505, 0x0086df, 0x0086df,  47, -22967,  24,  47 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x01a098, 0x0084a8, 0x0084a8,  48, -22966,  18,  28 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x01545d, 0x01356a, 0x01356a,  25, -22965,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x0152bf, 0x0131b4, 0x0131b4,  25, -22964,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x01a0aa, 0x013ee3, 0x013ee3,  25, -22963,  18,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x014505, 0x01f191, 0x01f191,   9, -22962,  18,   9 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x01569c, 0x00c48d, 0x00c48d,  36, -22961,  23,  36 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x014f84, 0x0157c7, 0x0157c7,  23, -22960,  23,  23 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x015851, 0x01af9c, 0x01af9c,  17, -22959,  23,  17 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x01a3e6, 0x007707, 0x007707,  51, -22958,  18,  51 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x017f93, 0x01eeb6, 0x01eeb6,  10, -22957,  20,  10 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01b376, 0x009e60, 0x009e60,  42, -22956,  17,  42 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x0138d5, 0x00bc81, 0x00bc81,  37, -22955,  25,  37 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x019b76, 0x00cbfe, 0x00cbfe,  35, -22954,  18,  35 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x0178c3, 0x00e43a, 0x00e43a,  32, -22953,  21,  32 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x01ca6f, 0x012f9c, 0x012f9c,  26, -22952,  15,  26 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x01c179, 0x01645f, 0x01645f,  22, -22951,  15,  22 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x0178c3, 0x00ab90, 0x00ab90,  40, -22950,  14,  40 }, /* VERR_LDR_FORWARDER */
    { 0x018af0, 0x00d547, 0x00d547,  33, -22930,  19,  33 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x019540, 0x017a07, 0x017a07,  20, -22929,  19,  20 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x019787, 0x0189ad, 0x0189ad,  19, -22928,  18,  19 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00b370, 0x00732d, 0x00732d,  52, -22927,  38,  52 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00bd3a, 0x00c79e, 0x00c79e,  35, -22926,  37,  35 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x01272e, 0x006979, 0x006979,  55, -22925,  26,  44 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x00d376, 0x016eac, 0x016eac,  21, -22924,  34,  21 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x00a004, 0x0042a2, 0x0042a2,  72, -22923,  41,  72 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x01a074, 0x00d62e, 0x00d62e,  33, -22922,  18,  12 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01b9da, 0x010ba4, 0x010ba4,  28, -22921,  16,  28 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01e37f, 0x015ded, 0x015ded,  22, -22919,  12,  22 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x00f434, 0x00ab18, 0x00ab18,  40, -22918,  30,  40 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x00f4e8, 0x0097c4, 0x0097c4,  43, -22917,  30,  43 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x017383, 0x01bb9a, 0x01bb9a,  16, -22916,  21,  16 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x01a7c7, 0x01b6da, 0x01b6da,  16, -22915,  17,  16 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x017590, 0x00f68c, 0x00f68c,  30, -22914,  21,  30 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x016d71, 0x01b6da, 0x01b6da,  16, -22913,  21,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x013137, 0x01b6da, 0x01b6da,  16, -22912,  25,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x0159c1, 0x01b6da, 0x01b6da,  16, -22911,  23,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x012d12, 0x0136e1, 0x0136e1,  25, -22910,  26,  25 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x011c3b, 0x00bfea, 0x00bfea,  36, -22909,  27,  36 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x01846b, 0x00e870, 0x00e870,  31, -22908,  20,  31 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x01409d, 0x007a2c, 0x007a2c,  50, -22907,  24,  50 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x017a1b, 0x010808, 0x010808,  28, -22906,  20,  28 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x0180d3, 0x00f146, 0x00f146,  30, -22905,  20,  30 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x01a3d4, 0x011ca7, 0x011ca7,  27, -22904,  18,  27 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x01531b, 0x008f2d, 0x008f2d,  45, -22903,  23,  45 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x018a45, 0x0125c2, 0x0125c2,  26, -22902,  19,  26 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x01ac7e, 0x012cf8, 0x012cf8,  26, -22901,  17,  26 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01d3be, 0x00e4ba, 0x00e4ba,  32, -22900,  14,  32 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01cdac, 0x01e9a2, 0x01ece0,  10, -22899,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01cea8, 0x01e9a2, 0x01eda8,  10, -22898,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01d1d4, 0x01e9a2, 0x01e9a2,  10, -22897,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01d27c, 0x01e9a2, 0x01ecb8,  10, -22896,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01d26e, 0x01e9a2, 0x01ea74,  10, -22895,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x018be7, 0x00bb0f, 0x014595,  24, -22857,  19,   5 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01f1f4, 0x01a7b6, 0x01a7b6,  17, -22856,   9,  17 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x01b99a, 0x009aee, 0x009aee,  42, -22855,  16,   5 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x01c7f9, 0x00f470, 0x00f470,  30, -22854,  15,  21 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x01842f, 0x01496d, 0x01496d,  24, -22853,  20,  15 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01f64a, 0x00364d, 0x01ce00,  14, -22852,   7,   4 }, /* VERR_ASN1_TOO_LONG */
    { 0x01d21a, 0x00b3e2, 0x0132f9,  25, -22851,  14,   5 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x01d1c6, 0x00364d, 0x0080b8,  48, -22850,  14,   4 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x018cf0, 0x008088, 0x008088,  48, -22849,  19,  18 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x0176f5, 0x00bb0f, 0x01239d,  27, -22848,  21,   5 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01bdea, 0x00bb0f, 0x016fe7,  21, -22847,  16,   5 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x018a58, 0x00bb0f, 0x014655,  24, -22846,  19,   5 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x010aa8, 0x00bb0f, 0x00db98,  33, -22845,  28,   5 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x017e17, 0x00bb0f, 0x0139e8,  25, -22844,  20,   5 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x01a25a, 0x00999c, 0x00999c,  43, -22843,  18,  19 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x01a27e, 0x00f88a, 0x00f88a,  30, -22842,  18,  16 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x01510a, 0x014145, 0x018d3c,  19, -22841,  23,   5 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x013d85, 0x00364d, 0x01383f,  25, -22840,  25,   4 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x013b91, 0x00b3e2, 0x00b3e2,  38, -22839,  25,   5 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x01cac6, 0x00b3e2, 0x0119ce,  27, -22838,  14,   5 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00cb72, 0x009d8e, 0x009d8e,  42, -22837,  35,  42 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x012c0e, 0x010b34, 0x010b34,  28, -22836,  26,  14 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x01926e, 0x013a33, 0x013a33,  25, -22835,  19,  11 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x01311e, 0x00364d, 0x006ecf,  54, -22834,  16,   4 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x01208e, 0x00bda9, 0x00bda9,  37, -22833,  27,  37 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00cd9f, 0x00ae2a, 0x00ae2a,  39, -22832,  34,  39 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x01311e, 0x014145, 0x014145,  24, -22831,  25,   5 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x01b1ef, 0x00d024, 0x00d024,  34, -22830,  17,   9 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x01bc3a, 0x006589, 0x006589,  56, -22829,  16,  47 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01eb46, 0x00364d, 0x01b0df,  17, -22828,  10,   4 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x016449, 0x00364d, 0x00eb96,  31, -22827,  22,   4 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01f03c, 0x00364d, 0x00f3da,  30, -22826,   9,   4 }, /* VERR_ASN1_NO_VTABLE */
    { 0x01984d, 0x01c7cc, 0x01c7cc,  15, -22825,  18,  15 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x019c96, 0x00d41e, 0x00d41e,  33, -22824,  18,  33 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x019b88, 0x00db56, 0x00db56,  33, -22823,  18,  33 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x01e260, 0x01657d, 0x01657d,  22, -22820,  12,  22 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01cd9e, 0x019751, 0x019751,  18, -22819,  14,  18 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x0125a8, 0x0118db, 0x0118db,  27, -22818,  26,  27 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x0168ed, 0x01c6dc, 0x01c6dc,  15, -22817,  22,  15 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x013344, 0x003633, 0x003633,  84, -22816,  25,  30 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x01415d, 0x0057ef, 0x0057ef,  60, -22815,  24,  19 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x016291, 0x003d22, 0x003d22,  76, -22814,  22,  19 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01af8b, 0x00bb0f, 0x00cd39,  34, -22813,  17,   5 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x015d11, 0x00bb0f, 0x0120df,  27, -22812,  22,   5 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x0110c8, 0x00bb0f, 0x00d8a1,  33, -22811,  28,   5 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x0124f2, 0x00bb0f, 0x00f0e9,  31, -22810,  26,   5 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x0127e4, 0x00bb0f, 0x00bb0f,  37, -22809,  26,   5 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x012880, 0x00bb0f, 0x00eb77,  31, -22808,  26,   5 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x016853, 0x00bb0f, 0x012166,  27, -22807,  22,   5 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x011c05, 0x00bb0f, 0x00dc5a,  32, -22806,  27,   5 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x015e2f, 0x00bb0f, 0x00c6cc,  35, -22805,  22,   5 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x010d2c, 0x00bb0f, 0x00da4e,  33, -22804,  28,   5 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x012b8c, 0x00bb0f, 0x00e797,  31, -22803,  26,   5 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x015515, 0x00bb0f, 0x010106,  29, -22802,  23,   5 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x012f1a, 0x01d13a, 0x01d13a,  14, -22801,  26,   6 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01fa65, 0x015052, 0x015052,  23, -22800,   3,  23 }, /* VERR_ASN1_ERROR */
    { 0x00c758, 0x0056ff, 0x0056ff,  60, -22739,  35,  60 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x01340c, 0x006e63, 0x006e63,  54, -22738,  25,  54 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x017af7, 0x00addc, 0x00addc,  39, -22737,  20,  39 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x0108e8, 0x010075, 0x010075,  29, -22736,  28,  29 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x01742b, 0x00ab68, 0x00ab68,  40, -22735,  21,  40 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01c8e9, 0x01e3af, 0x01e3af,  12, -22734,  15,  12 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x01b8aa, 0x018d4f, 0x018d4f,  19, -22733,  16,  19 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x0179f3, 0x01855a, 0x01855a,  20, -22732,  20,  20 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01d2de, 0x01736e, 0x01736e,  21, -22731,  14,  21 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01cc32, 0x0186fe, 0x0186fe,  20, -22730,  14,  20 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01c02f, 0x01b0f0, 0x01b0f0,  17, -22729,  15,  17 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x017f07, 0x017344, 0x017344,  21, -22728,  20,  21 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01d308, 0x00e7b6, 0x00e7b6,  31, -22727,  14,  31 }, /* VERR_XAR_NO_ENCODING */
    { 0x01c1f1, 0x01f4c1, 0x01f4c1,   8, -22726,  15,   8 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x013e98, 0x018137, 0x018137,  20, -22725,  25,  20 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x019817, 0x01a2c6, 0x01a2c6,  18, -22724,  18,  18 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x018493, 0x01335d, 0x01335d,  25, -22723,  20,  25 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x011bb4, 0x00e739, 0x00e739,  32, -22722,  27,  32 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x019d6e, 0x018902, 0x018902,  19, -22721,  18,  19 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x013cbd, 0x012b72, 0x012b72,  26, -22720,  25,  26 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x018596, 0x013939, 0x013939,  25, -22719,  20,  25 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x011d49, 0x00deda, 0x00deda,  32, -22718,  27,  32 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x010123, 0x004379, 0x004379,  71, -22717,  29,  71 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x018b29, 0x015bdd, 0x015bdd,  22, -22716,  19,  22 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x0186ea, 0x00b909, 0x00b909,  37, -22715,  20,  37 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x016593, 0x00ee9d, 0x00ee9d,  31, -22714,  22,  31 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01a93d, 0x01be2a, 0x01be2a,  16, -22713,  17,  16 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x010432, 0x00638a, 0x00638a,  57, -22712,  29,  57 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x0141bd, 0x00d046, 0x00d046,  34, -22711,  24,  34 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x018622, 0x00f6e6, 0x00f6e6,  30, -22710,  20,  30 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x015b59, 0x015d53, 0x015d53,  22, -22709,  22,  22 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x01adb0, 0x012610, 0x012610,  26, -22708,  17,  26 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x015bf3, 0x008298, 0x008298,  48, -22707,  22,  48 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x014bf4, 0x0175a5, 0x0175a5,  21, -22706,  24,  21 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x014bf4, 0x01b7ca, 0x01b7ca,  16, -22705,  13,  16 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x01c952, 0x009e36, 0x009e36,  42, -22704,  15,  42 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x0195d8, 0x019b40, 0x019b40,  18, -22703,  19,  18 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01d542, 0x01eedd, 0x01eedd,   9, -22702,  13,   9 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01cab8, 0x01f74d, 0x01f74d,   7, -22701,  14,   7 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x01ba8a, 0x01d458, 0x01d458,  13, -22700,  16,  13 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x018a1f, 0x00b15c, 0x00b15c,  38, -22600,  19,  38 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x0156b3, 0x018b3c, 0x018b3c,  19, -22503,  23,  19 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x01ca15, 0x01edb2, 0x01edb2,  10, -22502,  15,  10 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x016b10, 0x00fd0f, 0x00fd0f,  29, -22500,  21,  29 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00ce27, 0x0064a7, 0x0064a7,  57, -22430,  34,  57 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x01c1a6, 0x01c6af, 0x01c6af,  15, -22429,  15,  15 }, /* VERR_INSTALLATION_FAILED */
    { 0x01cb98, 0x01ae37, 0x01ae37,  17, -22428,  14,  17 }, /* VERR_REBOOT_NEEDED */
    { 0x01c745, 0x0130a0, 0x0130a0,  26, -22427,  15,  26 }, /* VERR_FLOAT_OVERFLOW */
    { 0x01bb8a, 0x011fd1, 0x011fd1,  27, -22426,  16,  27 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x016223, 0x006bd6, 0x006bd6,  55, -22425,  22,  55 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x016567, 0x016fbd, 0x016fbd,  21, -22424,  22,  21 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x01a83e, 0x015ad5, 0x015ad5,  22, -22423,  17,  22 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01d904, 0x01d77e, 0x01d77e,  13, -22422,  13,  13 }, /* VERR_EMPTY_STRING */
    { 0x018b16, 0x009d64, 0x009d64,  42, -22421,  19,  42 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x0183b7, 0x01481d, 0x01481d,  24, -22420,  20,  24 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x0144a5, 0x012cc4, 0x012cc4,  26, -22419,  24,  26 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x01e3eb, 0x01e02c, 0x01e02c,  12, -22418,  12,  12 }, /* VERR_INVALID_SESSION_ID */
    { 0x01e729, 0x01e4cc, 0x01e4cc,  11, -22417,  11,  11 }, /* VERR_INVALID_CLIENT_ID */
    { 0x016eeb, 0x01732f, 0x01732f,  21, -22416,  21,  21 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x0161f7, 0x0163f1, 0x0163f1,  22, -22415,  22,  22 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01ced2, 0x01b6fa, 0x01b6fa,  16, -22414,  14,  16 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x018ab7, 0x0025cb, 0x0025cb, 106, -22413,  19,  71 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x018097, 0x001b61, 0x001b61, 119, -22412,  20,  76 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x018762, 0x000ff0, 0x000ff0, 151, -22411,  20, 100 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x01b65a, 0x006fa7, 0x006fa7,  54, -22410,  16,  54 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01e805, 0x01e5c9, 0x01e5c9,  11, -22409,  11,  11 }, /* VERR_WRONG_TYPE */
    { 0x01fa7a, 0x01f11c, 0x01f11c,   9, -22408,   2,   9 }, /* VERR_MISMATCH */
    { 0x01b5da, 0x01f060, 0x01f060,   9, -22407,  16,   9 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00ef76, 0x009095, 0x009095,  45, -22406,  31,  45 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x018e6c, 0x00b28c, 0x00b28c,  38, -22405,  19,  38 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01c817, 0x00c988, 0x00c988,  35, -22404,  15,  35 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01e78c, 0x00a524, 0x00a524,  41, -22403,  11,  41 }, /* VERR_NOT_AVAILABLE */
    { 0x01dc6b, 0x01dc03, 0x01dc03,  13, -22402,  13,  13 }, /* VERR_UNEVEN_INPUT */
    { 0x01b101, 0x01ad6c, 0x01ad6c,  17, -22401,  17,  17 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01e7b8, 0x0098c6, 0x0098c6,  43, -22400,  11,  43 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01d62c, 0x01a6c8, 0x01a6c8,  17, -22360,  13,  17 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x00c445, 0x00c91f, 0x00c91f,  35, -22359,  36,  35 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x010a8c, 0x00aeed, 0x00aeed,  39, -22358,  28,  39 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00bac5, 0x009718, 0x009718,  43, -22357,  37,  43 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x011761, 0x010602, 0x010602,  29, -22356,  27,  29 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00e33a, 0x008058, 0x008058,  48, -22355,  32,  48 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x01611b, 0x00ff19, 0x00ff19,  29, -22354,  22,  29 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x016b25, 0x00a30f, 0x00a30f,  41, -22353,  21,  41 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x013e7f, 0x014235, 0x014235,  24, -22352,  25,  24 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x00d799, 0x00bcf0, 0x00bcf0,  37, -22351,  33,  37 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x0122e0, 0x0134a2, 0x0134a2,  25, -22350,  27,  25 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x017455, 0x00c77b, 0x00c77b,  35, -22320,  21,  35 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x0158db, 0x015657, 0x015657,  23, -22319,  23,  23 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x00eedb, 0x00283a, 0x00283a, 102, -22318,  31,  40 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x012d94, 0x00a576, 0x00a576,  41, -22317,  26,  41 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x017bd3, 0x014bdc, 0x014bdc,  24, -22316,  20,  24 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x00f830, 0x005685, 0x005685,  61, -22315,  30,  61 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x0122c5, 0x00c152, 0x00c152,  36, -22314,  27,  36 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x016e04, 0x0198cb, 0x0198cb,  18, -22313,  21,  18 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x019ff6, 0x0188b6, 0x0188b6,  19, -22312,  18,  19 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x019c3c, 0x01eba0, 0x01eba0,  10, -22311,  18,  10 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x01c8ad, 0x01063c, 0x01063c,  29, -22300,  15,  29 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x01b48a, 0x01662d, 0x01662d,  22, -22201,  16,  22 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x01cf6c, 0x00e719, 0x00e719,  32, -22200,  14,  32 }, /* VERR_DVM_MAP_EMPTY */
    { 0x0173d7, 0x007152, 0x007152,  53, -22158,  21,  53 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x01d35c, 0x017050, 0x017050,  21, -22157,  14,  21 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x0183cb, 0x004b4e, 0x004b4e,  67, -22156,  20,  67 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x01d576, 0x003cd6, 0x003cd6,  76, -22155,  13,  76 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x019dda, 0x006d1f, 0x006d1f,  54, -22154,  18,  54 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x01b321, 0x0050ea, 0x0050ea,  64, -22153,  17,  64 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x01351f, 0x004bd4, 0x004bd4,  67, -22152,  25,  67 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x01a572, 0x0093df, 0x0093df,  44, -22151,  18,  44 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01e600, 0x00bf12, 0x00bf12,  36, -22150,  11,  36 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x01daa4, 0x0099c7, 0x0099c7,  43, -22149,  13,  43 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x01351f, 0x010489, 0x010489,  29, -22148,  13,  29 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x016d08, 0x00a1c7, 0x00a1c7,  41, -22147,  21,  41 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x016d08, 0x014fc8, 0x014fc8,  23, -22146,  14,  23 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x01ad28, 0x006ce9, 0x006ce9,  54, -22145,  17,  54 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x011e72, 0x006ce9, 0x006ce9,  54, -22144,  27,  54 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01ea2e, 0x00c12e, 0x00c12e,  36, -22143,  10,  36 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x01def4, 0x00966c, 0x00966c,  43, -22142,  12,  43 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x01ad28, 0x010659, 0x010659,  29, -22141,  12,  29 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x01df30, 0x00ac08, 0x00ac08,  39, -22140,  12,  39 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x011e72, 0x00a294, 0x00a294,  41, -22139,  20,  41 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x01d85b, 0x016357, 0x016357,  22, -22138,  13,  22 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x01d4c0, 0x014265, 0x014265,  24, -22137,  13,  24 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01d3b0, 0x01a5de, 0x01a5de,  18, -22136,  14,  18 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x01d6bb, 0x01a5de, 0x01a5de,  18, -22135,  13,  18 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x017ea3, 0x01a5de, 0x01a5de,  18, -22134,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x01781b, 0x0190a6, 0x0190a6,  19, -22133,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x01e08c, 0x014e14, 0x014e14,  23, -22132,  12,  23 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x0169ea, 0x018a6b, 0x018a6b,  19, -22131,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x01636d, 0x01837b, 0x01837b,  20, -22130,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x01d59d, 0x01457d, 0x01457d,  24, -22129,  13,  24 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x016a53, 0x018d16, 0x018d16,  19, -22128,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x016475, 0x0185e6, 0x0185e6,  20, -22127,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x01d54f, 0x0140e5, 0x0140e5,  24, -22126,  13,  24 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x016055, 0x01879e, 0x01879e,  20, -22125,  22,  20 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x0153a5, 0x016f00, 0x016f00,  21, -22124,  23,  21 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x01d3e8, 0x0138a3, 0x0138a3,  25, -22123,  14,  25 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x01797b, 0x0199c7, 0x0199c7,  18, -22122,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x016a14, 0x018a91, 0x018a91,  19, -22121,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x01e020, 0x014eb5, 0x014eb5,  23, -22120,  12,  23 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x01793f, 0x011adc, 0x011adc,  27, -22119,  20,  27 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x0189f9, 0x0126fa, 0x0126fa,  26, -22118,  19,  26 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01e8c0, 0x00f010, 0x00f010,  31, -22117,  11,  31 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01f0cb, 0x01e3df, 0x01e3df,  12, -22116,   9,  12 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x01b4ea, 0x00e759, 0x00e759,  31, -22115,  16,  31 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x01c8bc, 0x01c4cf, 0x01c4cf,  15, -22114,  15,  15 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01f6b3, 0x01f2b9, 0x01f2b9,   8, -22113,   7,   8 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01ecae, 0x01f1fd, 0x01f1fd,   9, -22112,  10,   9 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x0121b7, 0x011af7, 0x011af7,  27, -22111,  27,  27 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x013b46, 0x00b182, 0x00b182,  38, -22110,  25,  38 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x0162ff, 0x00e8ae, 0x00e8ae,  31, -22109,  22,  31 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x016bb8, 0x00f812, 0x00f812,  30, -22108,  21,  30 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x015b2d, 0x017d77, 0x017d77,  20, -22107,  22,  20 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x012f4e, 0x01aa80, 0x01aa80,  17, -22106,  26,  17 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00f524, 0x01714c, 0x01714c,  21, -22105,  30,  21 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x01061f, 0x017c87, 0x017c87,  20, -22104,  29,  20 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01f188, 0x01d709, 0x01d709,  13, -22103,   9,  13 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x017c23, 0x01ed26, 0x01ed26,  10, -22102,  20,  10 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x01d4c0, 0x0134bb, 0x0134bb,  25, -22101,   9,  25 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01e894, 0x00c3fd, 0x00c3fd,  36, -22100,  11,  36 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x01dfc0, 0x010693, 0x010693,  29, -22005,  12,  29 }, /* VERR_ZIP_BAD_HEADER */
    { 0x01dcc0, 0x00db77, 0x00db77,  33, -22004,  12,  33 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01d6e2, 0x00d288, 0x00d288,  34, -22003,  13,  34 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01dd68, 0x0097ef, 0x0097ef,  43, -22002,  12,  43 }, /* VERR_ZIP_NO_MEMORY */
    { 0x01cc24, 0x014775, 0x014775,  24, -22001,  14,  24 }, /* VERR_ZIP_CORRUPTED */
    { 0x01f92f, 0x01f8cf, 0x01f8cf,   6, -22000,   6,   6 }, /* VERR_ZIP_ERROR */
    { 0x01dae5, 0x008f00, 0x008f00,  45,  -7602,  13,  45 }, /* VERR_GCM_NOT_HANDLED */
    { 0x01a761, 0x0049fa, 0x0049fa,  68,  -7400,  17,  35 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01f0d4, 0x01e307, 0x01e307,  12,  -7399,   9,  12 }, /* VERR_IOMMU_IPE_9 */
    { 0x01f0dd, 0x01e0f8, 0x01e0f8,  12,  -7398,   9,  12 }, /* VERR_IOMMU_IPE_8 */
    { 0x01f0e6, 0x01e0a4, 0x01e0a4,  12,  -7397,   9,  12 }, /* VERR_IOMMU_IPE_7 */
    { 0x01f0ef, 0x01dcd8, 0x01dcd8,  12,  -7396,   9,  12 }, /* VERR_IOMMU_IPE_6 */
    { 0x01f137, 0x01de40, 0x01de40,  12,  -7395,   9,  12 }, /* VERR_IOMMU_IPE_5 */
    { 0x01f0f8, 0x01df48, 0x01df48,  12,  -7394,   9,  12 }, /* VERR_IOMMU_IPE_4 */
    { 0x01f101, 0x01e068, 0x01e068,  12,  -7393,   9,  12 }, /* VERR_IOMMU_IPE_3 */
    { 0x01f10a, 0x01dc9c, 0x01dc9c,  12,  -7392,   9,  12 }, /* VERR_IOMMU_IPE_2 */
    { 0x01f113, 0x01de04, 0x01de04,  12,  -7391,   9,  12 }, /* VERR_IOMMU_IPE_1 */
    { 0x01f125, 0x01ded0, 0x01ded0,  12,  -7390,   9,  12 }, /* VERR_IOMMU_IPE_0 */
    { 0x0154e7, 0x003ba0, 0x003ba0,  78,  -7310,  23,  78 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01c2e0, 0x01a81c, 0x01a81c,  17,  -7309,  15,  17 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01c12e, 0x013a01, 0x013a01,  25,  -7308,  15,  25 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x0198ef, 0x009db8, 0x009db8,  42,  -7307,  18,  42 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01d868, 0x01ec72, 0x01ec72,  10,  -7306,  13,  10 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x014b94, 0x00506a, 0x00506a,  64,  -7305,  24,  64 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x019410, 0x01514f, 0x01514f,  23,  -7304,  19,  23 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x01399d, 0x01442d, 0x01442d,  24,  -7303,  25,  24 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x01364b, 0x016e19, 0x016e19,  21,  -7302,  25,  21 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x01972d, 0x013eb1, 0x013eb1,  25,  -7301,  18,  25 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x01a8f9, 0x01421d, 0x01421d,  24,  -7300,  17,  24 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x015726, 0x00af62, 0x00af62,  39,  -7206,  23,  39 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x01b6ea, 0x00eff1, 0x00eff1,  31,  -7205,  16,  31 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x00fbb3, 0x00539f, 0x00539f,  62,  -7204,  29,  62 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x01250c, 0x00a960, 0x00a960,  40,  -7203,  26,  40 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x012aa2, 0x00a457, 0x00a457,  41,  -7202,  26,  41 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x01a050, 0x00baea, 0x00baea,  37,  -7201,  18,  37 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x01d798, 0x00ebf3, 0x00ebf3,  31,  -7153,  13,  31 }, /* VERR_SHCLPB_NO_DATA */
    { 0x01c5bf, 0x01332b, 0x01332b,  25,  -7152,  15,  25 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x01c9ca, 0x0193b1, 0x0193b1,  19,  -7151,  15,  19 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x015ce5, 0x00ef94, 0x00ef94,  31,  -7150,  22,  31 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x012c5c, 0x005ccb, 0x005ccb,  59,  -7106,  26,  59 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x018e46, 0x0112f8, 0x0112f8,  28,  -7105,  19,  28 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x0124a4, 0x009799, 0x009799,  43,  -7104,  26,  43 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x012331, 0x00a668, 0x00a668,  40,  -7103,  27,  40 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x013a97, 0x009743, 0x009743,  43,  -7102,  25,  43 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x011797, 0x008fb4, 0x008fb4,  45,  -7101,  27,  45 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x01015d, 0x0078ce, 0x0078ce,  50,  -7100,  29,  50 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x014bac, 0x00a870, 0x00a870,  40,  -7000,  24,  40 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x016c36, 0x01e47f, 0x01e47f,  11,  -6908,  21,  11 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x017b6f, 0x002041, 0x002041, 111,  -6907,  20,  37 }, /* VERR_RECORDING_THROTTLED */
    { 0x0141a5, 0x0094e7, 0x0094e7,  44,  -6906,  24,  32 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x016def, 0x0094bb, 0x0094bb,  44,  -6905,  21,  44 }, /* VERR_RECORDING_RESTRICTED */
    { 0x01801f, 0x01aa91, 0x01aa91,  17,  -6904,  20,  17 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x019177, 0x01f00f, 0x01f00f,   9,  -6903,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x015401, 0x015edf, 0x015edf,  22,  -6902,  23,  22 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x01b068, 0x01284c, 0x01284c,  26,  -6901,  17,  26 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x0191d6, 0x01f08c, 0x01f08c,   9,  -6900,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01f63c, 0x01ebe6, 0x01ebe6,  10,  -6899,   7,  10 }, /* VERR_NEM_IPE_9 */
    { 0x01f5f6, 0x01e998, 0x01e998,  10,  -6898,   7,  10 }, /* VERR_NEM_IPE_8 */
    { 0x01f5fd, 0x01eb50, 0x01eb50,  10,  -6897,   7,  10 }, /* VERR_NEM_IPE_7 */
    { 0x01f604, 0x01ed44, 0x01ed44,  10,  -6896,   7,  10 }, /* VERR_NEM_IPE_6 */
    { 0x01f60b, 0x01edf8, 0x01edf8,  10,  -6895,   7,  10 }, /* VERR_NEM_IPE_5 */
    { 0x01f612, 0x01ec2c, 0x01ec2c,  10,  -6894,   7,  10 }, /* VERR_NEM_IPE_4 */
    { 0x01f619, 0x01ebaa, 0x01ebaa,  10,  -6893,   7,  10 }, /* VERR_NEM_IPE_3 */
    { 0x01f620, 0x01ecfe, 0x01ecfe,  10,  -6892,   7,  10 }, /* VERR_NEM_IPE_2 */
    { 0x01f627, 0x01ee20, 0x01ee20,  10,  -6891,   7,  10 }, /* VERR_NEM_IPE_1 */
    { 0x01f635, 0x01ec18, 0x01ec18,  10,  -6890,   7,  10 }, /* VERR_NEM_IPE_0 */
    { 0x01869a, 0x009ede, 0x009ede,  42,  -6817,  20,  42 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x013fab, 0x012ee6, 0x012ee6,  26,  -6816,  25,  26 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x013713, 0x00c63d, 0x00c63d,  36,  -6815,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x01372c, 0x00c19a, 0x00c19a,  36,  -6814,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x01380d, 0x00c3d9, 0x00c3d9,  36,  -6813,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x0137f4, 0x00c272, 0x00c272,  36,  -6812,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01e110, 0x01cfce, 0x01cfce,  14,  -6811,  12,  14 }, /* VERR_NEM_SET_TSC */
    { 0x01cdd6, 0x00a3b3, 0x00a3b3,  41,  -6810,  14,  41 }, /* VERR_NEM_FLUSH_TLB */
    { 0x01856e, 0x0184e2, 0x0184e2,  20,  -6809,  20,  20 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x01823b, 0x017bfb, 0x017bfb,  20,  -6808,  20,  20 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x019f0c, 0x010571, 0x010571,  29,  -6807,  18,  29 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x01b4ca, 0x012115, 0x012115,  27,  -6806,  16,  27 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x01bfb7, 0x00d64f, 0x00d64f,  33,  -6805,  15,  33 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01c0c5, 0x00fd49, 0x00fd49,  29,  -6804,  15,  29 }, /* VERR_NEM_RING3_ONLY */
    { 0x0137c2, 0x00c301, 0x00c301,  36,  -6803,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01e6c6, 0x01ee5c, 0x01ee5c,  10,  -6802,  11,  10 }, /* VERR_NEM_INIT_FAILED */
    { 0x01c011, 0x01b44a, 0x01b44a,  16,  -6801,  15,  16 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01d6c8, 0x01d260, 0x01d260,  14,  -6800,  13,  14 }, /* VERR_NEM_NOT_ENABLED */
    { 0x01f439, 0x01edbc, 0x01edbc,  10,  -6707,   8,  10 }, /* VERR_APIC_IPE_2 */
    { 0x01f441, 0x01e9c0, 0x01e9c0,  10,  -6706,   8,  10 }, /* VERR_APIC_IPE_1 */
    { 0x01f469, 0x01eca4, 0x01eca4,  10,  -6705,   8,  10 }, /* VERR_APIC_IPE_0 */
    { 0x019365, 0x00e51a, 0x00e51a,  32,  -6704,  19,  32 }, /* VERR_APIC_WRITE_INVALID */
    { 0x01dd20, 0x016b79, 0x016b79,  21,  -6703,  12,  21 }, /* VERR_APIC_INIT_FAILED */
    { 0x017f43, 0x0111a8, 0x0111a8,  28,  -6702,  20,  28 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x0146cd, 0x00ed0a, 0x00ed0a,  31,  -6701,  24,  31 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x018c32, 0x019306, 0x019306,  19,  -6700,  19,  19 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00f9f2, 0x007b58, 0x007b58,  50,  -6608,  30,  50 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x01800b, 0x017287, 0x017287,  21,  -6607,  20,  21 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x011560, 0x0014f5, 0x0014f5, 137,  -6606,  27,  23 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x017917, 0x01a5cc, 0x01a5cc,  18,  -6605,  20,  18 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x0100af, 0x00ce8d, 0x00ce8d,  34,  -6604,  29,  34 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x011947, 0x017527, 0x017527,  21,  -6603,  27,  21 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x012b58, 0x0181eb, 0x0181eb,  20,  -6602,  26,  20 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x0143fd, 0x00c9ce, 0x00c9ce,  35,  -6601,  24,  35 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x0176b6, 0x00146c, 0x00146c, 137,  -6600,  21,  35 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x01de10, 0x015e71, 0x015e71,  22,  -6500,  12,  22 }, /* VERR_DND_GUEST_ERROR */
    { 0x011528, 0x003687, 0x003687,  84,  -6401,  28,  41 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00f326, 0x00405b, 0x00405b,  74,  -6400,  30,  33 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x016d1d, 0x006c44, 0x006c44,  55,  -6318,  21,  55 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x0167fb, 0x0104e0, 0x0104e0,  29,  -6315,  22,  29 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x01bb2a, 0x01882a, 0x01882a,  20,  -6314,  16,  20 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x01044f, 0x008388, 0x008388,  48,  -6313,  29,  48 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x01149c, 0x00876c, 0x00876c,  47,  -6312,  28,  47 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x010bdc, 0x005d06, 0x005d06,  58,  -6311,  28,  58 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x0153d3, 0x00b55e, 0x00b55e,  38,  -6310,  23,  38 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x014c24, 0x01197d, 0x01197d,  27,  -6309,  24,  27 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x01289a, 0x00defa, 0x00defa,  32,  -6308,  26,  32 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x01bb7a, 0x01d1f0, 0x01d1f0,  14,  -6307,  16,  14 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x01d316, 0x01b8da, 0x01b8da,  16,  -6306,  14,  16 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x01946f, 0x00c391, 0x00c391,  36,  -6305,  19,  36 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x01753c, 0x00a4d2, 0x00a4d2,  41,  -6304,  21,  41 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01f72a, 0x01ebfa, 0x01ebfa,  10,  -6303,   7,  10 }, /* VERR_GIM_IPE_3 */
    { 0x01f731, 0x01e98e, 0x01e98e,  10,  -6302,   7,  10 }, /* VERR_GIM_IPE_2 */
    { 0x01f738, 0x01eb6e, 0x01eb6e,  10,  -6301,   7,  10 }, /* VERR_GIM_IPE_1 */
    { 0x01d4b3, 0x00eb39, 0x00eb39,  31,  -6300,  13,  31 }, /* VERR_GIM_NOT_ENABLED */
    { 0x013c40, 0x00b700, 0x00b700,  38,  -6225,  25,  38 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x0102d6, 0x0092ab, 0x0092ab,  44,  -6224,  29,  44 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00e90b, 0x00afb0, 0x00afb0,  39,  -6223,  31,  39 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00e49a, 0x00a5c8, 0x00a5c8,  40,  -6222,  32,  40 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x0123d3, 0x019e7c, 0x019e7c,  18,  -6221,  27,  18 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x01ca24, 0x015e71, 0x015e71,  22,  -6200,  15,  22 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x0151d9, 0x001242, 0x001242, 140,  -6001,  23,  33 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x014205, 0x003c3c, 0x003c3c,  77,  -6000,  24,   9 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x01e2c0, 0x0143e5, 0x0143e5,  24,  -5699,  12,  24 }, /* VERR_SUP_DRIVERLESS */
    { 0x00aa50, 0x003279, 0x003279,  89,  -5679,  40,  89 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x01388a, 0x00ce05, 0x00ce05,  34,  -5678,  25,  34 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x015e87, 0x018636, 0x018636,  20,  -5677,  22,  20 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x015a90, 0x018f17, 0x018f17,  19,  -5676,  23,  19 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x012fea, 0x0091a3, 0x0091a3,  44,  -5675,  26,  44 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01bd8a, 0x01bd0a, 0x01bd0a,  16,  -5674,  16,  16 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x00fbed, 0x0004b3, 0x0004b3, 213,  -5673,  29, 119 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x014ff6, 0x004cdf, 0x004cdf,  66,  -5672,  23,  66 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x018bfa, 0x004181, 0x004181,  73,  -5671,  19,  73 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x01b3ea, 0x005ba4, 0x005ba4,  59,  -5670,  16,  59 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01e008, 0x005497, 0x005497,  62,  -5669,  12,  62 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x01c916, 0x018b9b, 0x018b9b,  19,  -5668,  15,  19 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00de1a, 0x00ba56, 0x00ba56,  37,  -5667,  32,  37 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x017e3f, 0x00b9c2, 0x00b9c2,  37,  -5666,  20,  37 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x014865, 0x0027d3, 0x0027d3, 103,  -5665,  24, 103 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x012bc0, 0x00372f, 0x00372f,  84,  -5664,  26,  84 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x016e82, 0x0054d5, 0x0054d5,  62,  -5663,  21,  23 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x01c358, 0x000656, 0x000656, 181,  -5662,  15,  66 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00e832, 0x00c00e, 0x00c00e,  36,  -5661,  31,  36 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x0166c7, 0x01c6be, 0x01c6be,  15,  -5660,  22,  15 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00d8e3, 0x006c0d, 0x006c0d,  55,  -5659,  33,  55 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x018213, 0x013fc4, 0x013fc4,  25,  -5658,  20,  25 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x011058, 0x00940b, 0x00940b,  44,  -5657,  28,  44 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x013a1a, 0x004c5a, 0x004c5a,  67,  -5656,  25,  67 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x00fedf, 0x014925, 0x014925,  24,  -5655,  29,  24 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x00fc27, 0x012ba6, 0x012ba6,  26,  -5654,  29,  26 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x0109c8, 0x008478, 0x008478,  48,  -5653,  28,  48 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x0129b8, 0x006d55, 0x006d55,  54,  -5652,  26,  54 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x01306c, 0x00b025, 0x00b025,  39,  -5651,  26,  39 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x0106b0, 0x00ce49, 0x00ce49,  34,  -5650,  29,  34 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x00e01a, 0x00444e, 0x00444e,  70,  -5649,  32,  70 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x019624, 0x00d6f4, 0x00d6f4,  33,  -5648,  19,  33 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x018d29, 0x0099f2, 0x0099f2,  42,  -5647,  19,  42 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x018c0d, 0x018eb8, 0x018eb8,  19,  -5646,  19,  19 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x013696, 0x0135b5, 0x0135b5,  25,  -5645,  25,  25 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x0147d5, 0x01a638, 0x01a638,  18,  -5644,  24,  18 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x0164e3, 0x0117b2, 0x0117b2,  27,  -5643,  22,  27 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x019dc8, 0x0102b9, 0x0102b9,  29,  -5642,  18,  29 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x017788, 0x01559f, 0x01559f,  23,  -5641,  21,  23 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x019ed6, 0x0151c2, 0x0151c2,  23,  -5640,  18,  23 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x01a4e2, 0x00d7fc, 0x00d7fc,  33,  -5639,  18,  33 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x00f8e4, 0x013506, 0x013506,  25,  -5638,  30,  25 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x011f9b, 0x00ed48, 0x00ed48,  31,  -5637,  27,  31 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x01925b, 0x00e67a, 0x00e67a,  32,  -5636,  19,  32 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x015a34, 0x01912b, 0x01912b,  19,  -5635,  23,  19 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x010fe8, 0x00d332, 0x00d332,  34,  -5634,  28,  34 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x015dab, 0x006829, 0x006829,  56,  -5633,  22,  56 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x01707a, 0x007465, 0x007465,  52,  -5632,  21,  52 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x019034, 0x00d200, 0x00d200,  34,  -5631,  19,  10 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x019b52, 0x009b42, 0x009b42,  42,  -5630,  18,  42 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x019b52, 0x01606b, 0x01606b,  22,  -5629,  12,  22 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x015ccf, 0x00c5d1, 0x00c5d1,  36,  -5628,  22,  12 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x014085, 0x014c3c, 0x014c3c,  24,  -5627,  24,  24 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x017e7b, 0x007ea0, 0x007ea0,  49,  -5626,  20,  49 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x019bf4, 0x00c4d5, 0x00c4d5,  36,  -5625,  18,  36 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x01343e, 0x001685, 0x001685, 131,  -5624,  25, 131 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x016d5c, 0x01c2fe, 0x01c2fe,  15,  -5623,  21,  15 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x0164cd, 0x01a212, 0x01a212,  18,  -5622,  22,  18 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x014d73, 0x0178ae, 0x0178ae,  21,  -5621,  23,  21 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00df3a, 0x005db4, 0x005db4,  58,  -5620,  32,  58 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x019991, 0x00241d, 0x00241d, 108,  -5619,  18,  41 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x015a1d, 0x012c90, 0x012c90,  26,  -5618,  23,  26 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x0142c5, 0x0131cd, 0x0131cd,  25,  -5617,  24,  25 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x0126e0, 0x011a04, 0x011a04,  27,  -5616,  26,  27 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01db81, 0x01b9ea, 0x01b9ea,  16,  -5615,  13,  16 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x017884, 0x01f519, 0x01f519,   8,  -5614,  21,   8 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x012e30, 0x019c84, 0x019c84,  18,  -5613,  26,  18 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x01a871, 0x0170a4, 0x0170a4,  21,  -5612,  17,  21 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x015612, 0x01c98e, 0x01c98e,  15,  -5611,  23,  15 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x0105c8, 0x019235, 0x019235,  19,  -5610,  29,  19 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x016abc, 0x018187, 0x018187,  20,  -5609,  21,  20 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x01c296, 0x016189, 0x016189,  22,  -5608,  15,  22 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01beca, 0x01eb0a, 0x01eb0a,  10,  -5607,  16,  10 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x016b64, 0x01c3fd, 0x01c3fd,  15,  -5606,  21,  15 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x01b54a, 0x01e20c, 0x01e20c,  12,  -5605,  16,  12 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x0125dc, 0x018ede, 0x018ede,  19,  -5604,  26,  19 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x01277c, 0x00a4fb, 0x00a4fb,  41,  -5603,  26,  41 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x017caf, 0x00c8d9, 0x00c8d9,  35,  -5602,  20,  35 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x013c59, 0x009303, 0x009303,  44,  -5601,  25,  44 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x017677, 0x01baaa, 0x01baaa,  16,  -5600,  21,  16 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x0123ee, 0x01ec40, 0x01ec40,  10,  -5499,  26,  10 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x0121ed, 0x01f7e0, 0x01f7e0,   7,  -5498,  27,   7 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x00fdbd, 0x00e0da, 0x00e0da,  32,  -5497,  29,  32 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x00f2cc, 0x016e2e, 0x016e2e,  21,  -5496,  30,  21 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x012574, 0x00b82b, 0x00b82b,  37,  -5494,  26,  37 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x011090, 0x016407, 0x016407,  22,  -5493,  28,  22 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x00d266, 0x012130, 0x012130,  27,  -5492,  34,  27 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x012ad6, 0x0095eb, 0x0095eb,  43,  -5491,  26,  43 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x017161, 0x0180bf, 0x0180bf,  20,  -5490,  21,  20 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x01932c, 0x01cd74, 0x01cd74,  14,  -5489,  19,  14 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x015909, 0x016e43, 0x016e43,  21,  -5488,  23,  21 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x016811, 0x01b87a, 0x01b87a,  16,  -5487,  22,  16 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x014e9e, 0x01c33a, 0x01c33a,  15,  -5486,  23,  15 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x014ee3, 0x010f08, 0x010f08,  28,  -5485,  23,  28 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x01851e, 0x014cb4, 0x014cb4,  24,  -5484,  20,  24 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x019708, 0x00fcf2, 0x00fcf2,  29,  -5483,  19,  29 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x00fa6a, 0x010a00, 0x010a00,  28,  -5482,  30,  28 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x014e59, 0x00bfc6, 0x00bfc6,  36,  -5481,  23,  36 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x014b7c, 0x0193c4, 0x0193c4,  19,  -5480,  24,  19 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x013ff5, 0x0033d8, 0x0033d8,  87,  -5479,  24,  54 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x01469d, 0x008508, 0x008508,  48,  -5478,  24,  48 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x011330, 0x008208, 0x008208,  48,  -5477,  28,  48 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x00ef57, 0x019c18, 0x019c18,  18,  -5476,  31,  18 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x016433, 0x01cc94, 0x01cc94,  14,  -5475,  22,  14 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01bfe4, 0x01a9c5, 0x01a9c5,  17,  -5474,  15,  17 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01f1d9, 0x01997f, 0x01997f,  18,  -5408,   9,  18 }, /* VERR_DBGC_IPE */
    { 0x01c110, 0x012dc8, 0x012dc8,  26,  -5407,  15,  26 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01c853, 0x01ebb4, 0x01ebb4,  10,  -5405,  15,  10 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01e503, 0x01de1c, 0x01de1c,  12,  -5404,  11,  12 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x012936, 0x00ae9f, 0x00ae9f,  39,  -5403,  26,  39 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01eab0, 0x0126ac, 0x0126ac,  26,  -5400,  10,  26 }, /* VERR_DBGC_QUIT */
    { 0x01f9e9, 0x01dc37, 0x01dc37,  13,  -5399,   4,  13 }, /* VERR_IEM_IPE_9 */
    { 0x01f9ed, 0x01d73d, 0x01d73d,  13,  -5398,   4,  13 }, /* VERR_IEM_IPE_8 */
    { 0x01f9f1, 0x01d827, 0x01d827,  13,  -5397,   4,  13 }, /* VERR_IEM_IPE_7 */
    { 0x01f9f5, 0x01d8f7, 0x01d8f7,  13,  -5396,   4,  13 }, /* VERR_IEM_IPE_6 */
    { 0x01f9f9, 0x01d501, 0x01d501,  13,  -5395,   4,  13 }, /* VERR_IEM_IPE_5 */
    { 0x01f9fd, 0x01d694, 0x01d694,  13,  -5394,   4,  13 }, /* VERR_IEM_IPE_4 */
    { 0x01fa01, 0x01d834, 0x01d834,  13,  -5393,   4,  13 }, /* VERR_IEM_IPE_3 */
    { 0x01fa05, 0x01d4a6, 0x01d4a6,  13,  -5392,   4,  13 }, /* VERR_IEM_IPE_2 */
    { 0x01fa0d, 0x01d5eb, 0x01d5eb,  13,  -5391,   4,  13 }, /* VERR_IEM_IPE_1 */
    { 0x016cf3, 0x007f33, 0x007f33,  49,  -5390,  21,  49 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x017401, 0x00a690, 0x00a690,  40,  -5389,  21,  22 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x018686, 0x01ce2a, 0x01ce2a,  14,  -5384,  20,  14 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00f344, 0x0149cd, 0x0149cd,  24,  -5383,  30,  24 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x01a3b0, 0x017011, 0x017011,  21,  -5382,  18,  21 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x01bd6a, 0x012e4a, 0x012e4a,  26,  -5381,  16,  26 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x0127ca, 0x017b83, 0x017b83,  20,  -5380,  26,  20 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01ef25, 0x010bc0, 0x010bc0,  28,  -5377,   9,  28 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01ef2e, 0x010df0, 0x010df0,  28,  -5376,   9,  28 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01ef49, 0x0112c0, 0x0112c0,  28,  -5375,   9,  28 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01ef37, 0x0113a0, 0x0113a0,  28,  -5374,   9,  28 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01f281, 0x01188a, 0x01188a,  27,  -5373,   8,  27 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01f241, 0x012316, 0x012316,  27,  -5372,   8,  27 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01f249, 0x011cdd, 0x011cdd,  27,  -5371,   8,  27 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01f251, 0x011b48, 0x011b48,  27,  -5370,   8,  27 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01f261, 0x01172b, 0x01172b,  27,  -5369,   8,  27 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01f269, 0x0122aa, 0x0122aa,  27,  -5368,   8,  27 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01f279, 0x011d9a, 0x011d9a,  27,  -5367,   8,  27 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01f271, 0x011b2d, 0x011b2d,  27,  -5366,   8,  27 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01ef25, 0x0116bf, 0x0116bf,  27,  -5365,   8,  27 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x01a128, 0x0149fd, 0x0149fd,  24,  -5364,  18,  24 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01e8d6, 0x01a992, 0x01a992,  17,  -5363,  11,  17 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x014175, 0x01a2d8, 0x01a2d8,  18,  -5362,  24,  18 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x01b40a, 0x00bdce, 0x00bdce,  36,  -5361,  16,  36 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x01bff3, 0x01bcba, 0x01bcba,  16,  -5360,  15,  16 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01ef1c, 0x012259, 0x012259,  27,  -5355,   9,  27 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01eeef, 0x011ac1, 0x011ac1,  27,  -5354,   9,  27 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01eef8, 0x011ede, 0x011ede,  27,  -5353,   9,  27 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01ef13, 0x011746, 0x011746,  27,  -5352,   9,  27 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01f229, 0x01258e, 0x01258e,  26,  -5351,   8,  26 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01f231, 0x01291c, 0x01291c,  26,  -5350,   8,  26 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01f239, 0x012422, 0x012422,  26,  -5349,   8,  26 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01f551, 0x012d60, 0x012d60,  26,  -5348,   8,  26 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01f289, 0x0125f6, 0x0125f6,  26,  -5347,   8,  26 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01f291, 0x012762, 0x012762,  26,  -5346,   8,  26 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01f2c1, 0x012fd0, 0x012fd0,  26,  -5345,   8,  26 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01f2c9, 0x012abc, 0x012abc,  26,  -5344,   8,  26 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01eeef, 0x012b3e, 0x012b3e,  26,  -5343,   8,  26 }, /* VERR_IEM_REG_IPE_1 */
    { 0x013907, 0x0103be, 0x0103be,  29,  -5341,  25,  29 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x0133c1, 0x011410, 0x011410,  28,  -5340,  25,  28 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01ee48, 0x01da70, 0x01da70,  13,  -5339,  10,  13 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01ed9e, 0x01d639, 0x01d639,  13,  -5338,  10,  13 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01ee16, 0x01d716, 0x01d716,  13,  -5337,  10,  13 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01ee2a, 0x01da08, 0x01da08,  13,  -5336,  10,  13 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01ee34, 0x01dad8, 0x01dad8,  13,  -5335,  10,  13 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01ee3e, 0x01d50e, 0x01d50e,  13,  -5334,  10,  13 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x01764d, 0x01c9ac, 0x01c9ac,  15,  -5333,  21,  15 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x01dab1, 0x01ed62, 0x01ed62,  10,  -5332,  13,  10 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x013ab0, 0x00e1da, 0x00e1da,  32,  -5331,  25,  32 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x019efa, 0x018726, 0x018726,  20,  -5330,  18,  20 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00ea22, 0x00a9d8, 0x00a9d8,  40,  -5329,  31,  40 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x016919, 0x01c9e8, 0x01c9e8,  15,  -5328,  21,  15 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x01d979, 0x01ed3a, 0x01ed3a,  10,  -5327,  13,  10 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01ea42, 0x01d569, 0x01d569,  13,  -5326,  10,  13 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x01e2ef, 0x019805, 0x019805,  18,  -5325,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x01e2fb, 0x01a3f8, 0x01a3f8,  18,  -5324,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x014e70, 0x013052, 0x013052,  26,  -5323,  23,  26 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x01029c, 0x009cbc, 0x009cbc,  42,  -5322,  29,  42 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x017566, 0x0105ab, 0x0105ab,  29,  -5321,  21,  29 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x01e1a0, 0x017440, 0x017440,  21,  -5320,  12,  21 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x01c9bb, 0x00e778, 0x00e778,  31,  -5304,  15,  31 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01ed94, 0x0098f1, 0x0098f1,  43,  -5303,  10,  43 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x01ca60, 0x00c22a, 0x00c22a,  36,  -5302,  15,  36 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x01c754, 0x00df1a, 0x00df1a,  32,  -5301,  15,  32 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x018582, 0x013d6c, 0x013d6c,  25,  -5300,  20,  25 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x00da6f, 0x00a405, 0x00a405,  41,  -5209,  33,  41 }, /* VERR_GVMM_GVMCPU_STRUCT_NOT_PAGE_ALIGNED */
    { 0x00f254, 0x00b61c, 0x00b61c,  38,  -5208,  30,  38 }, /* VERR_GVMM_GVM_STRUCT_NOT_PAGE_ALIGNED */
    { 0x00e41a, 0x00a406, 0x00a406,  40,  -5207,  32,  40 }, /* VERR_GVMM_VMCPU_STRUCT_NOT_PAGE_ALIGNED */
    { 0x010dd4, 0x00c07a, 0x00c07a,  36,  -5206,  28,  36 }, /* VERR_GVMM_VM_STRUCT_NOT_PAGE_ALIGNED */
    { 0x010ac4, 0x0083b8, 0x0083b8,  48,  -5205,  28,  48 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01f3f9, 0x01cfdc, 0x01cfdc,  14,  -5204,   8,  14 }, /* VERR_GVMM_IPE_2 */
    { 0x01f4a1, 0x01d298, 0x01d298,  14,  -5203,   8,  14 }, /* VERR_GVMM_IPE_1 */
    { 0x01afad, 0x00e6ba, 0x00e6ba,  32,  -5202,  17,  32 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x017ef3, 0x009c3e, 0x009c3e,  42,  -5201,  20,  42 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x01cf7a, 0x011a3a, 0x011a3a,  27,  -5200,  14,  27 }, /* VERR_GVMM_INSTANCE */
    { 0x00eb58, 0x003a63, 0x003a63,  81,  -5102,  31,  22 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x017953, 0x003e9d, 0x003e9d,  75,  -5101,  20,  19 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00f182, 0x0046c4, 0x0046c4,  69,  -5100,  30,  17 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x018047, 0x00ea60, 0x00ea60,  31,  -5003,  20,  31 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x0145ad, 0x00e63a, 0x00e63a,  32,  -5002,  24,  32 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x018e0d, 0x00dc3a, 0x00dc3a,  32,  -5001,  19,  32 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01e7e4, 0x014ccc, 0x014ccc,  24,  -5000,  11,  24 }, /* VERR_FAM_OPEN_FAILED */
    { 0x01c13d, 0x01b398, 0x01b398,  17,  -4904,  15,  17 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x018802, 0x013551, 0x013551,  25,  -4903,  20,  25 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x019a7b, 0x01c826, 0x01c826,  15,  -4902,  18,  15 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x00fe4e, 0x00b68e, 0x00b68e,  38,  -4901,  29,  38 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x01a614, 0x01f339, 0x01f339,   8,  -4900,  18,   8 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x00b09a, 0x007013, 0x007013,  54,  -4700,  39,  54 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x01d030, 0x00789c, 0x00789c,  50,  -4698,  14,  50 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01d4e7, 0x00c5f5, 0x00c5f5,  36,  -4697,  13,  36 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01f5a9, 0x00dad2, 0x00dad2,  33,  -4696,   8,  33 }, /* VERR_COM_VM_ERROR */
    { 0x01e826, 0x00b5aa, 0x00b5aa,  38,  -4695,  11,  38 }, /* VERR_COM_FILE_ERROR */
    { 0x01e5a8, 0x01f923, 0x01f923,   6,  -4694,  11,   6 }, /* VERR_COM_IPRT_ERROR */
    { 0x01f67b, 0x0127fe, 0x0127fe,  26,  -4693,   7,  26 }, /* VERR_COM_PDM_ERROR */
    { 0x01a464, 0x016996, 0x016996,  21,  -4692,  18,  21 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01e616, 0x00ebb5, 0x00ebb5,  31,  -4691,  11,  31 }, /* VERR_COM_HOST_ERROR */
    { 0x01f70e, 0x01cdc8, 0x01cdc8,  14,  -4690,   7,  14 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01ed1c, 0x01f93b, 0x01f93b,   6,  -4689,  10,   6 }, /* VERR_COM_XML_ERROR */
    { 0x0191fc, 0x010e7c, 0x010e7c,  28,  -4688,  19,  28 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x019829, 0x014c54, 0x014c54,  24,  -4687,  18,  24 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x0181af, 0x003589, 0x003589,  85,  -4686,  20,  85 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x01bf99, 0x01d04c, 0x01d04c,  14,  -4600,  15,  14 }, /* VERR_COM_UNEXPECTED */
    { 0x01c04d, 0x00ea7f, 0x00ea7f,  31,  -4304,  15,  31 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x01c14c, 0x013ae2, 0x013ae2,  25,  -4303,  15,  25 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x01beda, 0x00e0fa, 0x00e0fa,  32,  -4302,  16,  32 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00f452, 0x011234, 0x011234,  28,  -4301,  30,  28 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x0194bb, 0x009870, 0x009870,  43,  -4300,  19,  43 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x01bb4a, 0x01f09e, 0x01f09e,   9,  -4206,  16,   9 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x01c880, 0x01a7fa, 0x01a7fa,  17,  -4204,  15,  17 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01e66e, 0x01f371, 0x01f371,   8,  -4203,  11,   8 }, /* VERR_DIS_INVALID_MODRM */
    { 0x0194f4, 0x01c538, 0x01c538,  15,  -4202,  19,  15 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x01bf49, 0x010f40, 0x010f40,  28,  -4201,  16,  28 }, /* VERR_DIS_GEN_FAILURE */
    { 0x01e3c7, 0x01b83a, 0x01b83a,  16,  -4200,  12,  16 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x01c41b, 0x01d8ea, 0x01d8ea,  13,  -4116,  15,  13 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01f815, 0x01dd98, 0x01dd98,  12,  -4115,   6,  12 }, /* VERR_HM_IPE_5 */
    { 0x01f81b, 0x01e128, 0x01e128,  12,  -4114,   6,  12 }, /* VERR_HM_IPE_4 */
    { 0x01f8f9, 0x01df00, 0x01df00,  12,  -4113,   6,  12 }, /* VERR_HM_IPE_3 */
    { 0x015c09, 0x013dd0, 0x013dd0,  25,  -4112,  22,  25 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x018ef1, 0x01ab3b, 0x01ab3b,  17,  -4111,  19,  17 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x019e6a, 0x0130ba, 0x0130ba,  25,  -4110,  18,  25 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01f8ff, 0x01e098, 0x01e098,  12,  -4109,   6,  12 }, /* VERR_HM_IPE_2 */
    { 0x01f905, 0x01e2b4, 0x01e2b4,  12,  -4108,   6,  12 }, /* VERR_HM_IPE_1 */
    { 0x01dc10, 0x00e4fa, 0x00e4fa,  32,  -4107,  13,  32 }, /* VERR_HM_WRONG_CPU */
    { 0x015fbb, 0x00e07a, 0x00e07a,  32,  -4106,  22,  32 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x01d0d8, 0x010c84, 0x010c84,  28,  -4105,  14,  28 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x01bc6a, 0x01ccbe, 0x01ccbe,  14,  -4104,  16,  14 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x01dd80, 0x014d2c, 0x014d2c,  24,  -4103,  12,  24 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x018d03, 0x00d1de, 0x00d1de,  34,  -4100,  19,  34 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x010904, 0x0072f9, 0x0072f9,  52,  -4075,  28,  52 }, /* VERR_SVM_HOST_VM_HSAVE_PA_INVALID */
    { 0x014efa, 0x00b454, 0x00b454,  38,  -4074,  23,  38 }, /* VERR_SVM_HOST_SVME_NOT_ENABLED */
    { 0x0182c7, 0x00f66e, 0x00f66e,  30,  -4073,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x0182ef, 0x00f1fa, 0x00f1fa,  30,  -4072,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x018303, 0x00f1a0, 0x00f1a0,  30,  -4071,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x018317, 0x00f506, 0x00f506,  30,  -4070,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x01da56, 0x00932f, 0x00932f,  44,  -4066,  13,  44 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01f7a8, 0x01eaba, 0x01eaba,  10,  -4065,   7,  10 }, /* VERR_SVM_IPE_5 */
    { 0x01f7af, 0x01edc6, 0x01edc6,  10,  -4064,   7,  10 }, /* VERR_SVM_IPE_4 */
    { 0x01f5e1, 0x01ec04, 0x01ec04,  10,  -4063,   7,  10 }, /* VERR_SVM_IPE_3 */
    { 0x01f5e8, 0x01ec90, 0x01ec90,  10,  -4062,   7,  10 }, /* VERR_SVM_IPE_2 */
    { 0x01f6f2, 0x01ea7e, 0x01ea7e,  10,  -4061,   7,  10 }, /* VERR_SVM_IPE_1 */
    { 0x01e9e8, 0x01439d, 0x01439d,  24,  -4060,  10,  24 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x01af7a, 0x00fd2c, 0x00fd2c,  29,  -4059,  17,  29 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x01b80a, 0x01b57a, 0x01b57a,  16,  -4058,  16,  16 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x01bfc6, 0x0185d2, 0x0185d2,  20,  -4057,  15,  20 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01ede4, 0x01eb3c, 0x01eb3c,  10,  -4056,  10,  10 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01e454, 0x01f7cb, 0x01f7cb,   7,  -4055,  11,   7 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01e475, 0x012223, 0x012223,  27,  -4054,  11,  27 }, /* VERR_SVM_IN_USE */
    { 0x01d771, 0x00ae51, 0x00ae51,  39,  -4053,  13,  39 }, /* VERR_SVM_DISABLED */
    { 0x01f069, 0x00e9e4, 0x00e9e4,  31,  -4052,   9,  31 }, /* VERR_SVM_NO_SVM */
    { 0x01757b, 0x010ca0, 0x010ca0,  28,  -4051,  21,  28 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x01624f, 0x01841b, 0x01841b,  20,  -4050,  22,  20 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x015d69, 0x00e2ba, 0x00e2ba,  32,  -4042,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x015cb9, 0x00e69a, 0x00e69a,  32,  -4041,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x015c8d, 0x00dfba, 0x00dfba,  32,  -4040,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x015ca3, 0x00e25a, 0x00e25a,  32,  -4039,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x0150f3, 0x012dae, 0x012dae,  26,  -4038,  23,  26 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01db40, 0x01ba6a, 0x01ba6a,  16,  -4034,  13,  16 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01cd58, 0x01e26c, 0x01e26c,  12,  -4033,  14,  12 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x013e34, 0x005b69, 0x005b69,  59,  -4032,  25,  59 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x017662, 0x006899, 0x006899,  56,  -4031,  21,  56 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x00fd83, 0x013d3a, 0x013d3a,  25,  -4030,  29,  25 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x01692e, 0x00f8c6, 0x00f8c6,  30,  -4029,  21,  30 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x013871, 0x006711, 0x006711,  56,  -4028,  25,  56 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01f746, 0x01ec7c, 0x01ec7c,  10,  -4027,   7,  10 }, /* VERR_VMX_IPE_5 */
    { 0x01f754, 0x01ea88, 0x01ea88,  10,  -4026,   7,  10 }, /* VERR_VMX_IPE_4 */
    { 0x01f777, 0x01ed30, 0x01ed30,  10,  -4025,   7,  10 }, /* VERR_VMX_IPE_3 */
    { 0x01f77e, 0x01e9b6, 0x01e9b6,  10,  -4024,   7,  10 }, /* VERR_VMX_IPE_2 */
    { 0x01f785, 0x01ec68, 0x01ec68,  10,  -4023,   7,  10 }, /* VERR_VMX_IPE_1 */
    { 0x013a7e, 0x00a848, 0x00a848,  40,  -4022,  25,  40 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01cf50, 0x00a0a8, 0x00a0a8,  41,  -4021,  14,  41 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x014805, 0x01a518, 0x01a518,  18,  -4019,  24,  18 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x015aeb, 0x007e3e, 0x007e3e,  49,  -4018,  22,  49 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x011368, 0x0142dd, 0x0142dd,  24,  -4017,  28,  24 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x01c574, 0x01d8dd, 0x01d8dd,  13,  -4016,  15,  13 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01ea92, 0x01f599, 0x01f599,   8,  -4015,  10,   8 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01a9b4, 0x01a73f, 0x01a73f,  17,  -4014,  17,  17 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x019a8d, 0x010384, 0x010384,  29,  -4013,  18,  29 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x013231, 0x008d98, 0x008d98,  45,  -4012,  25,  45 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x01721e, 0x0062a6, 0x0062a6,  57,  -4011,  21,  57 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01f1eb, 0x00aca4, 0x00aca4,  39,  -4009,   9,  39 }, /* VERR_VMX_NO_VMX */
    { 0x01b8fa, 0x0171b5, 0x0171b5,  21,  -4006,  16,  21 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x015e19, 0x01841b, 0x01841b,  20,  -4005,  22,  20 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x01c466, 0x01c637, 0x01c637,  15,  -4004,  15,  15 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01d96c, 0x003d6e, 0x003d6e,  76,  -4003,  13,  76 }, /* VERR_VMX_RESERVED */
    { 0x003da9, 0x00ced1, 0x00ced1,  34,  -4002,  16,  34 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x003d99, 0x008971, 0x008971,  47,  -4001,  14,  14 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01dca8, 0x00a780, 0x00a780,  40,  -4000,  12,  40 }, /* VERR_VMX_VMXON_FAILED */
    { 0x01cc4e, 0x007f02, 0x007f02,  49,  -3907,  14,  49 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x018dc1, 0x00acf2, 0x00acf2,  39,  -3906,  19,  39 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x01ae15, 0x00956a, 0x00956a,  43,  -3905,  17,  43 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01d465, 0x00ad40, 0x00ad40,  39,  -3904,  13,  39 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01d3f6, 0x0124be, 0x0124be,  26,  -3900,  14,  26 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00e3da, 0x008c28, 0x008c28,  46,  -3831,  32,  46 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x0148dd, 0x00f7d6, 0x00f7d6,  30,  -3830,  24,  30 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x017734, 0x019bbe, 0x019bbe,  18,  -3829,  21,  18 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00e1fa, 0x004a82, 0x004a82,  68,  -3828,  32,  68 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x013c72, 0x01615d, 0x01615d,  22,  -3826,  25,  22 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x014415, 0x01615d, 0x01615d,  22,  -3825,  24,  22 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x01a49a, 0x012f68, 0x012f68,  26,  -3824,  18,  26 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x013c0e, 0x01466d, 0x01466d,  24,  -3823,  25,  24 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x015c4b, 0x0154a2, 0x0154a2,  23,  -3822,  22,  23 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x017899, 0x00bccb, 0x00bccb,  37,  -3821,  21,  37 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x01883e, 0x01b62a, 0x01b62a,  16,  -3820,  20,  16 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x01d110, 0x01cb1a, 0x01cb1a,  14,  -3819,  14,  14 }, /* VERR_GMM_MTX_FLAGS */
    { 0x01d528, 0x0156f8, 0x0156f8,  23,  -3818,  13,  23 }, /* VERR_GMM_INSTANCE */
    { 0x01a90a, 0x01503b, 0x01503b,  23,  -3817,  17,  23 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x01da22, 0x017d4f, 0x017d4f,  20,  -3816,  13,  20 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00e6da, 0x002d52, 0x002d52,  98,  -3815,  32,  98 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x013984, 0x00b21a, 0x00b21a,  38,  -3814,  25,  38 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x019c2a, 0x006fdd, 0x006fdd,  54,  -3813,  18,  54 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x019ab1, 0x00ef19, 0x00ef19,  31,  -3812,  18,  31 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x01db26, 0x01e6a5, 0x01e6a5,  11,  -3811,  13,  11 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x01b41a, 0x00a0fa, 0x00a0fa,  41,  -3810,  16,  41 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01c376, 0x01a5ba, 0x01a5ba,  18,  -3809,  15,  18 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x01acd3, 0x010958, 0x010958,  28,  -3808,  17,  28 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x01a64a, 0x01017a, 0x01017a,  29,  -3807,  18,  29 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01e3f7, 0x016827, 0x016827,  22,  -3806,  12,  22 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x00fe31, 0x00b538, 0x00b538,  38,  -3805,  29,  38 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x0128b4, 0x0080e8, 0x0080e8,  48,  -3804,  26,  48 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x0148ad, 0x0156ca, 0x0156ca,  23,  -3803,  24,  23 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x01779d, 0x003381, 0x003381,  87,  -3802,  21,  19 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x019f42, 0x00c4b1, 0x00c4b1,  36,  -3801,  18,  36 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x017a57, 0x00a2e6, 0x00a2e6,  41,  -3778,  20,  41 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x018367, 0x007bee, 0x007bee,  50,  -3777,  20,  50 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x01583a, 0x014b64, 0x014b64,  24,  -3776,  23,  24 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x00f272, 0x010f24, 0x010f24,  28,  -3775,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x00fb5a, 0x010fcc, 0x010fcc,  28,  -3774,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x00fac4, 0x01134c, 0x01134c,  28,  -3773,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x00fb3c, 0x010e44, 0x010e44,  28,  -3772,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x00fb1e, 0x0113bc, 0x0113bc,  28,  -3771,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x00fb00, 0x0107d0, 0x0107d0,  28,  -3770,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x01319b, 0x00a988, 0x00a988,  40,  -3769,  25,  40 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x015069, 0x009b6c, 0x009b6c,  42,  -3768,  23,  42 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x015b6f, 0x017416, 0x017416,  21,  -3767,  22,  21 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x0119b3, 0x008c56, 0x008c56,  46,  -3766,  27,  46 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x019423, 0x01c682, 0x01c682,  15,  -3765,  19,  15 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x018457, 0x00f84e, 0x00f84e,  30,  -3764,  20,  30 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01c592, 0x01dbe9, 0x01dbe9,  13,  -3763,  15,  13 }, /* VERR_SUPLIB_IS_FILE */
    { 0x018123, 0x01db4d, 0x01db4d,  13,  -3762,  20,  13 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x019a33, 0x00cf9c, 0x00cf9c,  34,  -3761,  18,  34 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00eabd, 0x00f722, 0x00f722,  30,  -3760,  31,  30 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01c8da, 0x013e66, 0x013e66,  25,  -3759,  15,  25 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01ce8c, 0x0193fd, 0x0193fd,  19,  -3758,  14,  19 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x0190df, 0x00b5f6, 0x00b5f6,  38,  -3757,  19,  38 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x01a236, 0x01d05a, 0x01d05a,  14,  -3756,  18,  14 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x0185aa, 0x01da15, 0x01da15,  13,  -3755,  20,  13 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x0106ea, 0x019dec, 0x019dec,  18,  -3754,  29,  18 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x019637, 0x01dd5c, 0x01dd5c,  12,  -3753,  19,  12 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x019763, 0x01e708, 0x01e708,  11,  -3752,  18,  11 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x018e33, 0x01de64, 0x01de64,  12,  -3751,  19,  12 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x0165a9, 0x01c2a5, 0x01c2a5,  15,  -3750,  22,  15 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x016643, 0x009c68, 0x009c68,  42,  -3749,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x016659, 0x009e0c, 0x009e0c,  42,  -3748,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x0111e0, 0x008a5c, 0x008a5c,  46,  -3747,  28,  46 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x01dff0, 0x011cc2, 0x011cc2,  27,  -3745,  12,  27 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x0143b5, 0x011b99, 0x011b99,  27,  -3744,  24,  27 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x0139cf, 0x00b4c6, 0x00b4c6,  38,  -3743,  25,  38 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x017638, 0x00d2ee, 0x00d2ee,  34,  -3742,  21,  34 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01ec54, 0x00707e, 0x00707e,  53,  -3741,  10,  53 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x0143cd, 0x00b89a, 0x00b89a,  37,  -3740,  24,  37 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x017638, 0x0102f3, 0x0102f3,  29,  -3739,  16,  29 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x0157de, 0x00310e, 0x00310e,  93,  -3738,  23,  93 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x010cf4, 0x008dc5, 0x008dc5,  45,  -3737,  28,  45 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x013b14, 0x00a242, 0x00a242,  41,  -3736,  25,  41 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x012b24, 0x005f10, 0x005f10,  58,  -3735,  26,  58 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x015a62, 0x005fbe, 0x005fbe,  58,  -3734,  23,  58 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x01c188, 0x00f4ca, 0x00f4ca,  30,  -3733,  15,  30 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x0146fd, 0x008828, 0x008828,  47,  -3732,  24,  47 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x018a32, 0x01bbda, 0x01bbda,  16,  -3731,  19,  16 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x013600, 0x00b92e, 0x00b92e,  37,  -3730,  25,  37 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x01718b, 0x009845, 0x009845,  43,  -3729,  21,  43 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x01a1dc, 0x0188ef, 0x0188ef,  19,  -3728,  18,  19 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x01ab90, 0x01527a, 0x01527a,  23,  -3727,  17,  23 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x01b56a, 0x019b64, 0x019b64,  18,  -3726,  16,  18 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x01ba3a, 0x010554, 0x010554,  29,  -3725,  16,  29 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x0179df, 0x00d4c3, 0x00d4c3,  33,  -3724,  20,  33 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x018866, 0x0153bc, 0x0153bc,  23,  -3723,  20,  23 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x012007, 0x00f79a, 0x00f79a,  30,  -3722,  27,  30 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x01ae04, 0x00dcfa, 0x00dcfa,  32,  -3721,  17,  32 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x01ba7a, 0x011e57, 0x011e57,  27,  -3720,  16,  27 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x0181d7, 0x014685, 0x014685,  24,  -3719,  20,  24 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x01cae2, 0x01874e, 0x01874e,  20,  -3718,  14,  20 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x0181d7, 0x01e3bb, 0x01e3bb,  12,  -3717,  12,  12 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x01c0a7, 0x01c278, 0x01c278,  15,  -3716,  15,  15 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01e59d, 0x01beba, 0x01beba,  16,  -3715,  11,  16 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x01a602, 0x01e080, 0x01e080,  12,  -3714,  18,  12 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01d605, 0x01e35b, 0x01e35b,  12,  -3713,  13,  12 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x01bbfa, 0x01d1b8, 0x01d1b8,  14,  -3712,  16,  14 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x017fa7, 0x00eb1a, 0x00eb1a,  31,  -3711,  20,  31 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x01bf89, 0x01c25a, 0x01c25a,  15,  -3710,  16,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x01c6eb, 0x01cd20, 0x01cd20,  14,  -3709,  15,  14 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x01cb7c, 0x01c925, 0x01c925,  15,  -3708,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x01d43c, 0x01c925, 0x01c925,  15,  -3707,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x01c0f2, 0x01d51b, 0x01d51b,  13,  -3706,  15,  13 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01eaa6, 0x01b53a, 0x01b53a,  16,  -3705,  10,  16 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01e64d, 0x01e230, 0x01e230,  12,  -3704,  11,  12 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x0178d8, 0x019683, 0x019683,  19,  -3703,  21,  19 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x01df0c, 0x018dfa, 0x018dfa,  19,  -3702,  12,  19 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x01d0a0, 0x00b642, 0x00b642,  38,  -3701,  14,  38 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x01d102, 0x015fa5, 0x015fa5,  22,  -3700,  14,  22 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x0108b0, 0x01375e, 0x01375e,  25,  -3611,  28,  25 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x0100e9, 0x00e17a, 0x00e17a,  32,  -3610,  29,  32 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00f8a8, 0x00accb, 0x00accb,  39,  -3609,  30,  39 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x015166, 0x0091fb, 0x0091fb,  44,  -3608,  23,  44 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x0152ed, 0x007ac2, 0x007ac2,  50,  -3607,  23,  50 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x012274, 0x00879b, 0x00879b,  47,  -3606,  27,  47 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x013295, 0x008bcc, 0x008bcc,  46,  -3605,  25,  46 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x012a20, 0x00481d, 0x00481d,  69,  -3604,  26,  69 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x012408, 0x007a90, 0x007a90,  50,  -3603,  26,  50 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x01bd7a, 0x007cb6, 0x007cb6,  49,  -3602,  16,  49 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x018b4f, 0x007361, 0x007361,  52,  -3601,  19,  52 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x01ae7b, 0x00d7ba, 0x00d7ba,  33,  -3600,  17,  33 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x01b189, 0x00e968, 0x00e968,  31,  -3504,  17,  31 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x017f57, 0x00b2fe, 0x00b2fe,  38,  -3503,  20,  38 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x010c14, 0x00900e, 0x00900e,  45,  -3502,  28,  45 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x01aa5e, 0x0040a5, 0x0040a5,  74,  -3500,  17,  30 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x011803, 0x003970, 0x003a12,  81,  -3408,  27,  32 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x013920, 0x00af89, 0x00af89,  39,  -3407,  25,  39 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x013f79, 0x00c296, 0x00c296,  36,  -3406,  25,  36 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x015f8f, 0x003970, 0x003970,  81,  -3405,  22,  32 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x017e53, 0x011100, 0x011100,  28,  -3404,  20,  28 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x017dc7, 0x002cf0, 0x002cf0,  98,  -3403,  20,  35 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x01b134, 0x018d9b, 0x018d9b,  19,  -3402,  17,  19 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x0162d3, 0x00ab40, 0x00ab40,  40,  -3401,  22,  40 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x01e313, 0x002a38, 0x002a38, 101,  -3400,  12,  25 }, /* VERR_VUSB_NO_PORTS */
    { 0x01da3c, 0x019248, 0x019248,  19,  -3302,  13,  19 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01e658, 0x00deba, 0x00deba,  32,  -3301,  11,  32 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x01995b, 0x016895, 0x016895,  22,  -3300,  18,  22 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x01d5f8, 0x01cbec, 0x01cbec,  14,  -3290,  13,  14 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x014aec, 0x00dcda, 0x00dcda,  32,  -3289,  24,  26 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x0116f5, 0x00d002, 0x00d002,  34,  -3288,  27,  34 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x01412d, 0x011b7e, 0x011b7e,  27,  -3287,  24,  27 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x01587f, 0x012692, 0x012692,  26,  -3286,  23,  26 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x016f54, 0x009616, 0x009616,  43,  -3285,  21,  43 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x019611, 0x0158c4, 0x0158c4,  23,  -3284,  19,  23 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x016e6d, 0x001da4, 0x001da4, 113,  -3282,  21,  49 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x011596, 0x008f5a, 0x008f5a,  45,  -3281,  27,  45 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x018faf, 0x01c31c, 0x01c31c,  15,  -3280,  19,  15 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x0190f2, 0x00d222, 0x00d222,  34,  -3279,  19,  34 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x01cb36, 0x0174fd, 0x0174fd,  21,  -3278,  14,  21 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x012f34, 0x00c712, 0x00c712,  35,  -3277,  26,  35 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x016c75, 0x0124d8, 0x0124d8,  26,  -3276,  21,  26 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x01df60, 0x00f3bc, 0x00f3bc,  30,  -3275,  12,  30 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x01ae9d, 0x00dc1a, 0x00dc1a,  32,  -3274,  17,  32 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x01cb8a, 0x005777, 0x005777,  60,  -3273,  14,  60 }, /* VERR_VD_IOCTX_HALT */
    { 0x017a2f, 0x008148, 0x008148,  48,  -3272,  20,  48 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01dacb, 0x01d764, 0x01d764,  13,  -3271,  13,  13 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x01c21e, 0x01f04e, 0x01f04e,   9,  -3270,  15,   9 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x01c32b, 0x01eed4, 0x01eed4,   9,  -3267,  15,   9 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x0172db, 0x01945c, 0x01945c,  19,  -3265,  21,  19 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x01c970, 0x01f15b, 0x01f15b,   9,  -3260,  15,   9 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x012caa, 0x00c893, 0x00c893,  35,  -3253,  26,  35 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x01c556, 0x015abe, 0x015abe,  23,  -3252,  15,  23 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x01b6ca, 0x00d880, 0x00d880,  33,  -3251,  16,  33 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x01a84f, 0x0096c2, 0x0096c2,  43,  -3250,  17,  18 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x01c200, 0x01648b, 0x01648b,  22,  -3245,  15,  22 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x01bc0a, 0x00cb95, 0x00cb95,  35,  -3244,  16,  35 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01c287, 0x00de3a, 0x00de3a,  32,  -3243,  15,  32 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x01b035, 0x0155b6, 0x0155b6,  23,  -3242,  17,  23 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01aa6f, 0x0129d2, 0x0129d2,  26,  -3241,  17,  26 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x01bf39, 0x01eb28, 0x01eb28,  10,  -3240,  16,  10 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x0174a9, 0x01bbaa, 0x01bbaa,  16,  -3233,  21,  16 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01bbba, 0x013e02, 0x013e02,  25,  -3232,  16,  25 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x019ee8, 0x0119e9, 0x0119e9,  27,  -3231,  18,  27 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x01ca33, 0x01ef01, 0x01ef01,   9,  -3230,  15,   9 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x01c7db, 0x010cd8, 0x010cd8,  28,  -3220,  15,  13 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x0160ad, 0x009463, 0x009463,  44,  -3215,  22,  44 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01c098, 0x00f02f, 0x00f02f,  31,  -3214,  15,  31 }, /* VERR_VD_DEK_MISSING */
    { 0x01d0ca, 0x007569, 0x007569,  52,  -3213,  14,  19 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x01c565, 0x006318, 0x006318,  57,  -3212,  15,  24 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01f164, 0x01181e, 0x01181e,  27,  -3211,   9,  27 }, /* VERR_VD_INVALID_SIZE */
    { 0x01424d, 0x00e53a, 0x00e53a,  32,  -3210,  24,  32 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01ed12, 0x005c90, 0x005c90,  59,  -3208,  10,  59 }, /* VERR_VD_UUID_MISMATCH */
    { 0x01cf96, 0x01aad5, 0x01aad5,  17,  -3207,  14,  17 }, /* VERR_VD_BLOCK_FREE */
    { 0x01a9a3, 0x0177f1, 0x0177f1,  21,  -3206,  17,  21 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x018add, 0x01aa4d, 0x01aa4d,  17,  -3205,  19,  17 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01dcb4, 0x017cc3, 0x017cc3,  20,  -3204,  12,  20 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01e6fd, 0x01c790, 0x01c790,  15,  -3203,  11,  15 }, /* VERR_VD_NOT_OPENED */
    { 0x01dd8c, 0x01b332, 0x01b332,  17,  -3202,  12,  17 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01ea10, 0x00ad8e, 0x00ad8e,  39,  -3201,  10,  39 }, /* VERR_VD_INVALID_STATE */
    { 0x01f033, 0x01f6e4, 0x01f6e4,   7,  -3200,   9,   7 }, /* VERR_VD_INVALID_TYPE */
    { 0x01cce8, 0x008a8a, 0x008a8a,  46,  -3105,  14,  46 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x0144ed, 0x0036db, 0x0036db,  84,  -3104,  24,  84 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x01b77a, 0x006e99, 0x006e99,  54,  -3103,  16,  54 }, /* VERR_HOSTIF_BLOCKING */
    { 0x01dc2a, 0x0087ca, 0x0087ca,  47,  -3102,  13,  47 }, /* VERR_HOSTIF_IOCTL */
    { 0x0131e6, 0x00c056, 0x00c056,  36,  -3101,  25,  36 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x01d378, 0x00a2bd, 0x00a2bd,  41,  -3100,  14,  41 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x01b7ea, 0x001cc1, 0x001cc1, 114,  -3002,  16,  36 }, /* VERR_NAT_REDIR_SETUP */
    { 0x019105, 0x005c55, 0x005c55,  59,  -3001,  19,  42 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x0145f5, 0x00e45a, 0x00e45a,  32,  -2909,  24,  32 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x018dd4, 0x017e67, 0x017e67,  20,  -2908,  19,  20 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x01824f, 0x012c28, 0x012c28,  26,  -2907,  20,  26 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x01baca, 0x01b9aa, 0x01b9aa,  16,  -2905,  16,  16 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x01ccb0, 0x011dd0, 0x011dd0,  27,  -2904,  14,  27 }, /* VERR_HGCM_INTERNAL */
    { 0x01983b, 0x013baa, 0x013baa,  25,  -2902,  18,  25 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x01be0a, 0x012bf4, 0x012bf4,  26,  -2900,  16,  26 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x01619f, 0x01d2a6, 0x01d2a6,  14,  -2899,  22,  14 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x018033, 0x01e38b, 0x01e38b,  12,  -2897,  20,  12 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x012832, 0x0184ba, 0x0184ba,  20,  -2896,  26,  20 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x01484d, 0x00d134, 0x00d134,  34,  -2895,  24,  34 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x014ad4, 0x00d967, 0x00d967,  33,  -2894,  24,  33 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x014ce4, 0x01b96a, 0x01b96a,  16,  -2893,  24,  16 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01f4e1, 0x006a55, 0x006a55,  55,  -2892,   8,  55 }, /* VERR_PDM_HM_IPE */
    { 0x01a8d7, 0x004e26, 0x004e26,  65,  -2891,  17,  65 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00d481, 0x00711d, 0x00711d,  53,  -2890,  33,  53 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00cf7a, 0x00eccc, 0x00eccc,  31,  -2889,  34,  31 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01f3b9, 0x01db19, 0x01db19,  13,  -2888,   8,  13 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x01d4da, 0x018928, 0x018928,  19,  -2887,  13,  19 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x0104a6, 0x00afd7, 0x00afd7,  39,  -2886,  29,  39 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01e7ef, 0x018263, 0x018263,  20,  -2885,  11,  20 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01e8b5, 0x01864a, 0x01864a,  20,  -2884,  11,  20 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x01b3ba, 0x00ad67, 0x00ad67,  39,  -2883,  16,  39 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x01d88f, 0x0158f2, 0x0158f2,  23,  -2882,  13,  23 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x01d3da, 0x01bd5a, 0x01bd5a,  16,  -2881,  14,  16 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x010974, 0x005ff8, 0x005ff8,  58,  -2880,  28,  58 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x015121, 0x00dbda, 0x00dbda,  32,  -2879,  23,  32 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x01a0f2, 0x000eb8, 0x000eb8, 156,  -2878,  18,  13 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x01a356, 0x000d7a, 0x000d7a, 160,  -2877,  18,  17 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x01a37a, 0x000f54, 0x000f54, 156,  -2876,  18,  13 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x01860e, 0x000b92, 0x000b92, 163,  -2875,  20,  20 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x019a69, 0x000901, 0x000901, 165,  -2874,  18,  22 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x017b33, 0x0007b4, 0x0007b4, 167,  -2873,  20,  24 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x0198b9, 0x00070b, 0x00070b, 169,  -2872,  18,  26 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x019da4, 0x000aef, 0x000aef, 163,  -2871,  18,  20 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x01a0bc, 0x0009a6, 0x0009a6, 165,  -2870,  18,  22 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x011314, 0x012e7e, 0x012e7e,  26,  -2869,  28,  26 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x014aa4, 0x016173, 0x016173,  22,  -2868,  24,  22 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x0147bd, 0x015d27, 0x015d27,  22,  -2867,  24,  22 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x01887a, 0x00276c, 0x00276c, 103,  -2866,  20,  59 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x010058, 0x00ca7d, 0x00ca7d,  35,  -2865,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x00fc7e, 0x00c735, 0x00c735,  35,  -2864,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x016dda, 0x00ac7d, 0x00ac7d,  39,  -2863,  21,  39 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01e433, 0x009437, 0x009437,  44,  -2862,  11,  32 }, /* VERR_PDM_NO_USBPROXY */
    { 0x01df18, 0x008b9e, 0x008b9e,  46,  -2861,  12,  46 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01e48a, 0x00a7a8, 0x00a7a8,  40,  -2860,  11,  40 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x01b72a, 0x016709, 0x016709,  22,  -2859,  16,  22 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x01bd9a, 0x0059cc, 0x0059cc,  59,  -2858,  16,  14 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x018b03, 0x010a38, 0x010a38,  28,  -2857,  19,  28 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01a8e8, 0x001c4e, 0x001c4e, 115,  -2856,  17,  47 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01ce7e, 0x01433d, 0x01433d,  24,  -2855,  14,  24 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x019222, 0x004638, 0x004638,  70,  -2854,  19,  23 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x018b62, 0x0045ac, 0x0045ac,  70,  -2853,  19,  23 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x01e0c8, 0x014dfd, 0x014dfd,  23,  -2852,  12,  23 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x015235, 0x007ed1, 0x007ed1,  49,  -2851,  23,  49 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x01c269, 0x00541b, 0x00541b,  62,  -2850,  15,  62 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x01b7aa, 0x006189, 0x006189,  57,  -2849,  16,  57 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x01be5a, 0x005e62, 0x005e62,  58,  -2848,  16,  58 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x01c439, 0x006551, 0x006551,  56,  -2847,  15,  56 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x013c8b, 0x008328, 0x008328,  48,  -2846,  25,  48 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01f429, 0x01be6a, 0x01be6a,  16,  -2845,   8,  16 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x018546, 0x017aa7, 0x017aa7,  20,  -2844,  20,  20 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x0147a5, 0x00e9c5, 0x00e9c5,  31,  -2843,  24,  31 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x0140fd, 0x011218, 0x011218,  28,  -2842,  24,  28 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x0180ab, 0x01cc08, 0x01cc08,  14,  -2841,  20,  14 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01e495, 0x00b136, 0x00b136,  38,  -2840,  11,  10 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x01919d, 0x005a42, 0x005a42,  59,  -2839,  19,  14 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x0196bc, 0x01032d, 0x01032d,  29,  -2838,  19,  29 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x0180e7, 0x01c6a0, 0x01c6a0,  15,  -2837,  20,  15 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x0161b5, 0x010a38, 0x010a38,  28,  -2836,  22,  28 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a72e, 0x001f63, 0x001f63, 111,  -2835,  17,  43 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x01d882, 0x003e06, 0x003e06,  76,  -2834,  13,  56 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01ea9c, 0x002f37, 0x002f37,  95,  -2833,  10,  29 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x013d21, 0x0030b1, 0x0030b1,  93,  -2832,  25,  51 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x019449, 0x01c6a0, 0x01c6a0,  15,  -2831,  19,  15 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x015ef5, 0x010eb4, 0x010eb4,  28,  -2830,  22,  28 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01a794, 0x001e85, 0x001e85, 111,  -2829,  17,  43 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x018e59, 0x0059cc, 0x0059cc,  59,  -2828,  19,  14 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x019352, 0x01b387, 0x01b387,  17,  -2827,  19,  17 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x015e5b, 0x006749, 0x006749,  56,  -2826,  22,  56 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x018aca, 0x00b8bf, 0x00b8bf,  37,  -2825,  19,  37 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01e53a, 0x00269e, 0x00269e, 103,  -2823,  11,  21 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x0136af, 0x00a175, 0x00a175,  41,  -2822,  25,  41 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x013c8b, 0x002635, 0x002635, 105,  -2821,  18, 105 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x01a4be, 0x007964, 0x007964,  50,  -2820,  18,  50 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01d6ae, 0x00332a, 0x00332a,  87,  -2819,  13,  17 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x017abb, 0x004793, 0x004793,  69,  -2818,  20,  51 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01d89c, 0x005459, 0x005459,  62,  -2817,  13,  44 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01db67, 0x005648, 0x005648,  61,  -2816,  13,  43 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x01d180, 0x0110ac, 0x0110ac,  28,  -2815,  14,  28 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x01c475, 0x006669, 0x006669,  56,  -2814,  15,  26 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x01bd1a, 0x00935b, 0x00935b,  44,  -2813,  16,  44 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x01a680, 0x0034dd, 0x0034dd,  87,  -2812,  18,  53 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x01c4fc, 0x0029d2, 0x0029d2, 102,  -2811,  15,  50 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x01a506, 0x0024f5, 0x0024f5, 108,  -2810,  18,  17 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x01b51a, 0x001087, 0x001087, 150,  -2809,  16,  38 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x01b64a, 0x00085b, 0x00085b, 166,  -2808,  16,  46 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x01cc86, 0x00b1ce, 0x00b1ce,  38,  -2807,  14,  38 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x019482, 0x000a4b, 0x000a4b, 164,  -2806,  19,  39 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x018816, 0x0039c1, 0x0039c1,  81,  -2805,  20,  15 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x013538, 0x0032d2, 0x0032d2,  88,  -2804,  19,  54 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x013eca, 0x002c8e, 0x002c8e,  98,  -2803,  25,  64 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x013538, 0x003220, 0x003220,  89,  -2802,  25,  55 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x01819b, 0x002db4, 0x002db4,  98,  -2801,  20,  15 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01e8f7, 0x010310, 0x010310,  29,  -2800,  11,  29 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x01542f, 0x00ee5f, 0x00ee5f,  31,  -2721,  23,  31 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x01b19a, 0x017773, 0x017773,  21,  -2720,  17,  21 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00ede3, 0x004f6a, 0x004f6a,  64,  -2719,  31,  64 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x012de2, 0x0168d7, 0x0168d7,  22,  -2718,  26,  22 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x0164a1, 0x004407, 0x004407,  71,  -2717,  22,  71 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x013bf5, 0x0170ce, 0x0170ce,  21,  -2716,  25,  21 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x019e34, 0x01001e, 0x01001e,  29,  -2715,  18,  29 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x01b47a, 0x01a26c, 0x01a26c,  18,  -2713,  16,  18 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x01c943, 0x01c0d4, 0x01c0d4,  15,  -2709,  15,  15 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01af14, 0x00157e, 0x00157e, 132,  -2705,  17,   7 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01afbe, 0x000588, 0x000588, 206,  -2704,  17,   7 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x014745, 0x011170, 0x011170,  28,  -2703,  24,  28 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x01be1a, 0x00bba3, 0x00bba3,  37,  -2702,  16,  37 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x018532, 0x00bb7e, 0x00bb7e,  37,  -2701,  20,  37 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x0169c0, 0x01a2fc, 0x01a2fc,  18,  -2663,  21,  18 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x016ed6, 0x019e58, 0x019e58,  18,  -2662,  21,  18 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x01d252, 0x01ec0e, 0x01ec0e,  10,  -2661,  14,  10 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x012526, 0x01a2b4, 0x01a2b4,  18,  -2660,  26,  18 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x017a43, 0x015f4d, 0x015f4d,  22,  -2653,  20,  22 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x017eb7, 0x0167e5, 0x0167e5,  22,  -2652,  20,  22 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x018fd5, 0x01b1bc, 0x01b1bc,  17,  -2651,  19,  17 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00ee02, 0x013bdc, 0x013bdc,  25,  -2650,  31,  25 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x01a320, 0x00f9b6, 0x00f9b6,  30,  -2638,  18,  30 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01e52f, 0x006a8c, 0x006a8c,  55,  -2637,  11,  55 }, /* VERR_IOM_HM_IPE */
    { 0x01f0b0, 0x01e449, 0x01e449,  11,  -2636,   9,  11 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01f0c2, 0x01e902, 0x01e902,  11,  -2635,   9,  11 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01f149, 0x01e965, 0x01e965,  11,  -2634,   9,  11 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x01ce62, 0x019a57, 0x019a57,  18,  -2633,  14,  18 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x01cdf2, 0x0198a7, 0x0198a7,  18,  -2632,  14,  18 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x01ce46, 0x019c4e, 0x019c4e,  18,  -2631,  14,  18 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x01958c, 0x009068, 0x009068,  45,  -2630,  19,  45 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x01a2a2, 0x004a3e, 0x004a3e,  68,  -2614,  18,  68 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x0155cd, 0x008448, 0x008448,  48,  -2613,  23,  48 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x013376, 0x008fe1, 0x008fe1,  45,  -2612,  25,  36 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x01ad7d, 0x00dbfa, 0x00dbfa,  32,  -2611,  17,  32 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x014db8, 0x001789, 0x001789, 125,  -2610,  23,  23 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x01c0b6, 0x01ae8c, 0x01ae8c,  17,  -2609,  15,  17 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x0171f4, 0x002bc9, 0x002bc9,  99,  -2608,  21,  33 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x019021, 0x002906, 0x002906, 102,  -2607,  19,  34 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x01b63a, 0x00342f, 0x00342f,  87,  -2606,  16,  45 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x01d81a, 0x007f64, 0x007f64,  49,  -2605,  13,  14 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x014c0c, 0x0022d6, 0x0022d6, 109,  -2604,  24,  41 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x0179a3, 0x006861, 0x006861,  56,  -2603,  20,  56 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x012714, 0x001d33, 0x001d33, 113,  -2602,  26,  40 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x01785a, 0x002ed7, 0x002ed7,  96,  -2601,  21,  52 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x019f30, 0x006519, 0x006519,  56,  -2600,  18,  21 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x01e337, 0x006909, 0x006909,  56,  -2509,  12,  56 }, /* VERR_SELM_HM_IPE */
    { 0x01c367, 0x006f3b, 0x006f3b,  54,  -2508,  15,  54 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x01bdda, 0x008ab8, 0x008ab8,  46,  -2507,  16,  46 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x0153ea, 0x010eec, 0x010eec,  28,  -2506,  23,  28 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01ec4a, 0x01c15b, 0x01c15b,  15,  -2505,  10,  15 }, /* VERR_SELM_INVALID_LDT */
    { 0x01ee02, 0x0194a8, 0x0194a8,  19,  -2504,  10,  19 }, /* VERR_SELM_NO_TSS */
    { 0x015b17, 0x0023b0, 0x0023b0, 109,  -2502,  22,  43 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x0162e9, 0x002268, 0x002268, 110,  -2501,  22,  43 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x01678d, 0x00218c, 0x00218c, 110,  -2500,  22,  43 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x01df90, 0x006941, 0x006941,  56,  -2409,  12,  56 }, /* VERR_TRPM_HM_IPE */
    { 0x01f449, 0x01dfcc, 0x01dfcc,  12,  -2408,   8,  12 }, /* VERR_TRPM_IPE_3 */
    { 0x01f451, 0x01ddc8, 0x01ddc8,  12,  -2407,   8,  12 }, /* VERR_TRPM_IPE_2 */
    { 0x01f459, 0x01e104, 0x01e104,  12,  -2406,   8,  12 }, /* VERR_TRPM_IPE_1 */
    { 0x01b167, 0x01a882, 0x01a882,  17,  -2405,  17,  17 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01e621, 0x017967, 0x017967,  20,  -2404,  11,  20 }, /* VERR_TRPM_PANIC */
    { 0x01b79a, 0x00f614, 0x00f614,  30,  -2403,  16,  30 }, /* VERR_TRPM_DONT_PANIC */
    { 0x015d3d, 0x0020b0, 0x0020b0, 110,  -2402,  22,  43 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x01ad17, 0x0073c9, 0x0073c9,  52,  -2401,  17,  12 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x019e22, 0x006dc1, 0x006dc1,  54,  -2400,  18,  13 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01f827, 0x01f0b9, 0x01f0b9,   9,  -2299,   6,   9 }, /* VERR_TM_IPE_9 */
    { 0x01f833, 0x01f095, 0x01f095,   9,  -2298,   6,   9 }, /* VERR_TM_IPE_8 */
    { 0x01f83f, 0x01f176, 0x01f176,   9,  -2297,   6,   9 }, /* VERR_TM_IPE_7 */
    { 0x01f86f, 0x01f1e2, 0x01f1e2,   9,  -2296,   6,   9 }, /* VERR_TM_IPE_6 */
    { 0x01f887, 0x01f07a, 0x01f07a,   9,  -2295,   6,   9 }, /* VERR_TM_IPE_5 */
    { 0x01f88d, 0x01effd, 0x01effd,   9,  -2294,   6,   9 }, /* VERR_TM_IPE_4 */
    { 0x01f899, 0x01f1c7, 0x01f1c7,   9,  -2293,   6,   9 }, /* VERR_TM_IPE_3 */
    { 0x01f89f, 0x01ef91, 0x01ef91,   9,  -2292,   6,   9 }, /* VERR_TM_IPE_2 */
    { 0x01f8a5, 0x01f1a3, 0x01f1a3,   9,  -2291,   6,   9 }, /* VERR_TM_IPE_1 */
    { 0x011d13, 0x00be82, 0x00be82,  36,  -2214,  27,  36 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x01bbea, 0x017f1b, 0x017f1b,  20,  -2213,  16,  20 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x01bf29, 0x0149b5, 0x0149b5,  24,  -2212,  16,  24 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x015571, 0x01d8c3, 0x01d8c3,  13,  -2211,  23,  13 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x01c60a, 0x0109ac, 0x0109ac,  28,  -2210,  15,  28 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x01bafa, 0x00f6aa, 0x00f6aa,  30,  -2209,  16,  30 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x014a8c, 0x013cef, 0x013cef,  25,  -2208,  24,  25 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x01b6aa, 0x007501, 0x007501,  52,  -2207,  16,  52 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x011464, 0x010140, 0x010140,  29,  -2206,  28,  29 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01c664, 0x018f2a, 0x018f2a,  19,  -2205,  15,  19 }, /* VERR_TM_GIP_VERSION */
    { 0x01b5aa, 0x01b7fa, 0x01b7fa,  16,  -2204,  16,  16 }, /* VERR_TM_GIP_REQUIRED */
    { 0x019949, 0x00582b, 0x00582b,  60,  -2203,  18,  60 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01ea6a, 0x008028, 0x008028,  48,  -2202,  10,  20 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01ec36, 0x01406d, 0x01406d,  24,  -2201,  10,  24 }, /* VERR_TM_INVALID_STATE */
    { 0x01cccc, 0x013086, 0x013086,  26,  -2200,  14,  26 }, /* VERR_TM_LOAD_STATE */
    { 0x01f349, 0x01de88, 0x01de88,  12,  -2165,   8,  12 }, /* VERR_CFGM_IPE_1 */
    { 0x01a1ca, 0x009f86, 0x009f86,  42,  -2164,  18,  42 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x0190b9, 0x00dfda, 0x00dfda,  32,  -2163,  19,  32 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x01ae26, 0x007996, 0x007996,  50,  -2162,  17,  50 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x01a70c, 0x0079fa, 0x0079fa,  50,  -2161,  17,  50 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x01bdca, 0x00abe0, 0x00abe0,  40,  -2160,  16,  40 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x01c8cb, 0x00b396, 0x00b396,  38,  -2110,  15,  38 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x019579, 0x006b68, 0x006b68,  55,  -2109,  19,  26 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x01de4c, 0x0199a3, 0x0199a3,  18,  -2108,  12,  18 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01d7cc, 0x00af3b, 0x00af3b,  39,  -2107,  13,  39 }, /* VERR_CFGM_NOT_STRING */
    { 0x01d2c2, 0x01d8a9, 0x01d8a9,  13,  -2106,  14,  13 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01e4c1, 0x01ab2a, 0x01ab2a,  17,  -2105,  11,  17 }, /* VERR_CFGM_NO_NODE */
    { 0x01d800, 0x015629, 0x015629,  23,  -2104,  13,  23 }, /* VERR_CFGM_NO_PARENT */
    { 0x01cdba, 0x01f3c9, 0x01f3c9,   8,  -2103,  14,   8 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x01ad4a, 0x00e35a, 0x00e35a,  32,  -2102,  17,  22 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x01cd90, 0x01cfea, 0x01cfea,  14,  -2101,  14,  14 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x019d26, 0x00d112, 0x00d112,  34,  -2100,  18,  34 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x018974, 0x01a40a, 0x01a40a,  18,  -2007,  19,  18 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01d687, 0x01efc7, 0x01efc7,   9,  -2006,  13,   9 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01e5d4, 0x00d2aa, 0x00d2aa,  34,  -2005,  11,  34 }, /* VERR_VRDP_INVALID_MODE */
    { 0x0157b0, 0x005d7a, 0x005d7a,  58,  -2004,  23,  58 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01f319, 0x0157f5, 0x0157f5,  23,  -2003,   8,  23 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x01bc4a, 0x0149e5, 0x0149e5,  24,  -2002,  16,  24 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x016b8e, 0x00da0c, 0x00da0c,  33,  -2001,  21,  33 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x0192cd, 0x017edf, 0x017edf,  20,  -2000,  19,  20 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x01b3a9, 0x00fb96, 0x00fb96,  29,  -1919,  17,  29 }, /* VERR_VM_REQUEST_KILLED */
    { 0x01c673, 0x01b4da, 0x01b4da,  16,  -1918,  15,  16 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x013e1b, 0x00affe, 0x00affe,  39,  -1917,  25,  39 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x0197bd, 0x01d952, 0x01d952,  13,  -1916,  18,  13 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01e55b, 0x01bdfa, 0x01bdfa,  16,  -1915,  11,  16 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x01b59a, 0x008b14, 0x008b14,  46,  -1914,  16,  46 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x0168ab, 0x007b26, 0x007b26,  50,  -1913,  22,  33 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x0195c5, 0x014835, 0x014835,  24,  -1912,  19,  24 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x01ba2a, 0x00560b, 0x00560b,  61,  -1911,  16,  25 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x01b82a, 0x006435, 0x006435,  57,  -1910,  16,  25 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x016dc5, 0x008857, 0x008857,  47,  -1909,  21,  16 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x017d13, 0x0085f4, 0x0085f4,  47,  -1908,  20,  15 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01e8e1, 0x0082f8, 0x0082f8,  48,  -1907,  11,  10 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x01cca2, 0x003534, 0x003534,  85,  -1906,  14,  50 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x0151ab, 0x003ab4, 0x003ab4,  79,  -1905,  23,  34 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00f127, 0x002343, 0x002343, 109,  -1904,  31,  55 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x019495, 0x002b65, 0x002b65, 100,  -1903,  19,  11 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x01b4aa, 0x0021fa, 0x0021fa, 110,  -1902,  16,   5 }, /* VERR_VM_REQUEST_STATE */
    { 0x01b5ea, 0x000c35, 0x000c35, 163,  -1901,  16,   9 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x01d590, 0x0123b8, 0x0123b8,  27,  -1900,  13,  27 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x010b6c, 0x01e164, 0x01e164,  12,  -1880,  28,  12 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00c84d, 0x005ed6, 0x005ed6,  58,  -1879,  35,  58 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01f65f, 0x01e397, 0x01e397,  12,  -1878,   7,  12 }, /* VERR_SSM_IPE_3 */
    { 0x01f666, 0x01e1ac, 0x01e1ac,  12,  -1877,   7,  12 }, /* VERR_SSM_IPE_2 */
    { 0x01f689, 0x01dcf0, 0x01dcf0,  12,  -1876,   7,  12 }, /* VERR_SSM_IPE_1 */
    { 0x01d164, 0x00fc61, 0x00fc61,  29,  -1875,  14,  29 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01d84e, 0x0085c5, 0x0085c5,  47,  -1874,  13,  47 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x0194e1, 0x009971, 0x009971,  43,  -1873,  19,  43 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01ee52, 0x00948f, 0x00948f,  44,  -1872,  10,  44 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01d9c7, 0x01efa3, 0x01efa3,   9,  -1871,  13,   9 }, /* VERR_SSM_STREAM_ERROR */
    { 0x01b002, 0x018b88, 0x018b88,  19,  -1870,  17,  19 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x01436d, 0x01a332, 0x01a332,  18,  -1869,  24,  18 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x017c5f, 0x00bfa2, 0x00bfa2,  36,  -1868,  20,  36 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x015823, 0x00bd15, 0x00bd15,  37,  -1867,  23,  37 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x014b04, 0x014f28, 0x014f28,  23,  -1866,  24,  23 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01b9fa, 0x010bf8, 0x010bf8,  28,  -1865,  16,  28 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x01a170, 0x0049b6, 0x0049b6,  68,  -1864,  18,  49 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x01a71d, 0x005e28, 0x005e28,  58,  -1863,  17,  58 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x013619, 0x00591b, 0x00591b,  59,  -1862,  25,  59 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x0175cf, 0x00c82a, 0x00c82a,  35,  -1861,  21,  35 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x01c709, 0x01c2d1, 0x01c2d1,  15,  -1860,  15,  15 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x0159ef, 0x014bc4, 0x014bc4,  24,  -1859,  23,  24 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01cde4, 0x01dbdc, 0x01dbdc,  13,  -1858,  14,  13 }, /* VERR_SSM_CANCELLED */
    { 0x015e45, 0x005a07, 0x005a07,  59,  -1857,  22,  59 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x0187ee, 0x0056c2, 0x0056c2,  61,  -1856,  20,  61 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01ae59, 0x005b2e, 0x005b2e,  59,  -1855,  17,  59 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x015a4b, 0x01beaa, 0x01beaa,  16,  -1853,  23,  16 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x018bc1, 0x0053dd, 0x0053dd,  62,  -1850,  19,  62 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x017bbf, 0x0052e4, 0x0052e4,  63,  -1849,  20,  63 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01e970, 0x00d0ac, 0x00d0ac,  34,  -1848,  10,  34 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x017db3, 0x0172c6, 0x0172c6,  21,  -1847,  20,  21 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x0166dd, 0x0051a9, 0x0051a9,  63,  -1846,  22,  63 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x017830, 0x002a9d, 0x002a9d, 100,  -1845,  21,  39 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x019b1c, 0x001358, 0x001358, 138,  -1844,  18,  26 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x0156e1, 0x00a056, 0x00a056,  41,  -1843,  23,  41 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x01aef2, 0x00111d, 0x00111d, 149,  -1842,  17,  59 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00ffe4, 0x002561, 0x002561, 106,  -1841,  29,  26 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x014e42, 0x005867, 0x005867,  60,  -1840,  23,  15 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x018c58, 0x011448, 0x011448,  28,  -1833,  19,  28 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01e81b, 0x011448, 0x011448,  28,  -1832,  11,  28 }, /* VERR_SSM_INVALID_STATE */
    { 0x01aca0, 0x0061c2, 0x0061c2,  57,  -1831,  17,  57 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x01c655, 0x006b9f, 0x006b9f,  55,  -1830,  15,  55 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x014025, 0x0165d5, 0x0165d5,  22,  -1827,  24,  22 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x014025, 0x017845, 0x017845,  21,  -1826,  18,  21 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x010c30, 0x013f47, 0x013f47,  25,  -1825,  28,  25 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x01219c, 0x00e2da, 0x00e2da,  32,  -1824,  27,  32 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x01219c, 0x00f740, 0x00f740,  30,  -1823,  23,  30 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x015b85, 0x0191b0, 0x0191b0,  19,  -1822,  22,  19 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x016f93, 0x0197e1, 0x0197e1,  18,  -1821,  21,  18 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x01203d, 0x0164b7, 0x0164b7,  22,  -1820,  27,  22 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x0167cf, 0x00cf36, 0x00cf36,  34,  -1819,  22,  34 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x013105, 0x010a70, 0x010a70,  28,  -1818,  25,  28 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x013105, 0x01ab5d, 0x01ab5d,  17,  -1817,  19,  17 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x016cb4, 0x018c1f, 0x018c1f,  19,  -1816,  21,  19 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x016105, 0x011d2e, 0x011d2e,  27,  -1815,  22,  27 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x01a66e, 0x012a3a, 0x012a3a,  26,  -1814,  18,  26 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x01939e, 0x012456, 0x012456,  26,  -1813,  19,  26 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x016601, 0x01d875, 0x01d875,  13,  -1812,  22,  13 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x01833f, 0x011138, 0x011138,  28,  -1811,  20,  28 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x010c30, 0x012022, 0x012022,  27,  -1810,  14,  27 }, /* VERR_SSM_INTEGRITY */
    { 0x01bada, 0x00fdf7, 0x00fdf7,  29,  -1802,  16,  29 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01dd2c, 0x01b93a, 0x01b93a,  16,  -1801,  12,  16 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x01b74a, 0x01c583, 0x01c583,  15,  -1800,  16,  15 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x018bae, 0x01ea06, 0x01ea06,  10,  -1771,  19,  10 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x019f1e, 0x01b08a, 0x01b08a,  17,  -1770,  18,  17 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x014715, 0x0075d1, 0x0075d1,  52,  -1768,  24,  52 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x018776, 0x004de5, 0x004de5,  65,  -1767,  20,  65 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01e4a0, 0x015937, 0x015937,  23,  -1765,  11,  23 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x01b6ba, 0x01548b, 0x01548b,  23,  -1764,  16,  23 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x016239, 0x00bc5c, 0x00bc5c,  37,  -1763,  22,  37 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00d156, 0x004709, 0x004709,  69,  -1762,  34,  69 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x0194ce, 0x01f057, 0x01f057,   9,  -1761,  19,   9 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x018a0c, 0x01c11f, 0x01c11f,  15,  -1760,  19,  15 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x013f92, 0x011fec, 0x011fec,  27,  -1757,  25,  27 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x01c772, 0x0100cc, 0x0100cc,  29,  -1756,  15,  29 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01f359, 0x01e684, 0x01e684,  11,  -1755,   8,  11 }, /* VERR_CPUM_IPE_2 */
    { 0x01f4a9, 0x01e7ad, 0x01e7ad,  11,  -1754,   8,  11 }, /* VERR_CPUM_IPE_1 */
    { 0x011854, 0x00b8e4, 0x00b8e4,  37,  -1753,  27,  37 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x015d95, 0x003f7d, 0x003f7d,  74,  -1752,  22,  74 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x013777, 0x00de7a, 0x00de7a,  32,  -1751,  25,  32 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x01b8ca, 0x00b74c, 0x00b74c,  38,  -1750,  16,  38 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x01a248, 0x0096ed, 0x0096ed,  43,  -1702,  18,  43 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x01a9e7, 0x01d006, 0x01d006,  14,  -1701,  17,  14 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x01b60a, 0x005956, 0x005956,  59,  -1700,  16,  59 }, /* VERR_MM_RAM_CONFLICT */
    { 0x01a0e0, 0x01db8e, 0x01db8e,  13,  -1692,  18,  13 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x0169d5, 0x00ec6f, 0x00ec6f,  31,  -1691,  21,  31 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x019e10, 0x01d9ba, 0x01d9ba,  13,  -1690,  18,  13 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x01a80b, 0x008538, 0x008538,  47,  -1689,  17,  47 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x01c97f, 0x0090ef, 0x0090ef,  45,  -1688,  15,  45 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x01d18e, 0x01696c, 0x01696c,  21,  -1687,  14,  21 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01eccc, 0x01f331, 0x01f331,   8,  -1686,  10,   8 }, /* VERR_PGM_MODE_IPE */
    { 0x01c844, 0x007605, 0x007605,  52,  -1685,  15,  52 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x013efc, 0x008b70, 0x008b70,  46,  -1684,  25,  46 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x01832b, 0x01c8f8, 0x01c8f8,  15,  -1683,  20,  15 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x014985, 0x014475, 0x014475,  24,  -1682,  24,  24 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x015fd1, 0x00b978, 0x00b978,  37,  -1681,  22,  37 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x019151, 0x0151f0, 0x0151f0,  23,  -1680,  19,  23 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x01570f, 0x0134ed, 0x0134ed,  25,  -1679,  23,  25 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01edee, 0x01dfe4, 0x01dfe4,  12,  -1678,  10,  12 }, /* VERR_PGM_POOL_IPE */
    { 0x0142ad, 0x00a14c, 0x00a14c,  41,  -1677,  24,  41 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x01d74a, 0x015dd7, 0x015dd7,  22,  -1676,  13,  22 }, /* VERR_PGM_MAPPING_IPE */
    { 0x019a0f, 0x01234c, 0x01234c,  27,  -1675,  18,  27 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x019c60, 0x01552c, 0x01552c,  23,  -1674,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x019bac, 0x015920, 0x015920,  23,  -1673,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x019bd0, 0x015418, 0x015418,  23,  -1672,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x019c06, 0x015207, 0x015207,  23,  -1671,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x01a30e, 0x011b63, 0x011b63,  27,  -1670,  18,  27 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x01dfd8, 0x00ce6b, 0x00ce6b,  34,  -1669,  12,  34 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01e847, 0x00cd16, 0x00cd16,  35,  -1668,  11,  35 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x01c30d, 0x005513, 0x005513,  62,  -1667,  15,  62 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x01aba1, 0x017272, 0x017272,  21,  -1666,  17,  21 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x01d0ae, 0x01d7bf, 0x01d7bf,  13,  -1665,  14,  13 }, /* VERR_PGM_PML4_MAPPING */
    { 0x01b97a, 0x012ecc, 0x012ecc,  26,  -1664,  16,  26 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x01dc78, 0x01445d, 0x01445d,  24,  -1663,  12,  24 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x01b69a, 0x01c4b1, 0x01c4b1,  15,  -1662,  16,  15 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x017398, 0x00cfbe, 0x00cfbe,  34,  -1661,  21,  34 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x01899a, 0x00e949, 0x00e949,  31,  -1660,  19,  31 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x017a6b, 0x00eceb, 0x00eceb,  31,  -1659,  20,  31 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x01775e, 0x00d9eb, 0x00d9eb,  33,  -1658,  21,  33 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x015b01, 0x00d9a9, 0x00d9a9,  33,  -1657,  22,  33 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01d723, 0x01448d, 0x01448d,  24,  -1656,  13,  24 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01aee1, 0x014abc, 0x014abc,  24,  -1655,  17,  24 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x018e92, 0x01eff4, 0x01eff4,   9,  -1654,  19,   9 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x01cfb2, 0x013f15, 0x013f15,  25,  -1653,  14,  25 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x019507, 0x010d80, 0x010d80,  28,  -1652,  19,  28 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x0192e0, 0x00776d, 0x00776d,  51,  -1651,  19,  51 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01dd08, 0x014b4c, 0x014b4c,  24,  -1647,  12,  24 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x016a92, 0x00cc21, 0x00cc21,  35,  -1646,  21,  35 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x018f04, 0x015c1f, 0x015c1f,  22,  -1645,  19,  22 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x01a062, 0x00d178, 0x00d178,  34,  -1643,  18,  34 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x01d757, 0x01c9f7, 0x01c9f7,  15,  -1642,  13,  15 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01f152, 0x01e6d1, 0x01e6d1,  11,  -1641,   9,  11 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01e831, 0x01da8a, 0x01da8a,  13,  -1640,  11,  13 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01e43e, 0x011fb6, 0x011fb6,  27,  -1639,  11,  27 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x016c8a, 0x005f4a, 0x005f4a,  58,  -1638,  21,  58 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01c718, 0x012208, 0x012208,  27,  -1637,  15,  27 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x01a5a8, 0x0146e5, 0x0146e5,  24,  -1636,  18,  24 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x0161e1, 0x00b2b2, 0x00b2b2,  38,  -1635,  22,  38 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x0179b7, 0x00c51d, 0x00c51d,  36,  -1634,  20,  36 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x0175f9, 0x0090c2, 0x0090c2,  45,  -1633,  21,  45 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x01a860, 0x01077b, 0x01077b,  29,  -1632,  17,  29 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x01ba9a, 0x00d3ba, 0x00d3ba,  34,  -1631,  16,  34 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x01adc1, 0x00ae78, 0x00ae78,  39,  -1630,  17,  39 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01e9d4, 0x010fb0, 0x010fb0,  28,  -1629,  10,  28 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x017305, 0x012073, 0x012073,  27,  -1628,  21,  27 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00fae2, 0x000170, 0x000170, 334,  -1627,  30,  65 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00e7f4, 0x0041ca, 0x0041ca,  72,  -1626,  31,  72 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x017137, 0x01296a, 0x01296a,  26,  -1619,  21,  26 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x017ecb, 0x008b42, 0x008b42,  46,  -1618,  20,  46 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x019093, 0x01177c, 0x01177c,  27,  -1617,  19,  27 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x0171a0, 0x00aa00, 0x00aa00,  40,  -1612,  21,  40 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x015291, 0x00ba31, 0x00ba31,  37,  -1611,  23,  37 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x015754, 0x0092d7, 0x0092d7,  44,  -1610,  23,  44 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x01ba1a, 0x007290, 0x007290,  53,  -1609,  16,  53 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x01d022, 0x005956, 0x005956,  59,  -1608,  14,  59 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x01dea0, 0x010b18, 0x010b18,  28,  -1607,  12,  28 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x017a93, 0x0048a6, 0x0048a6,  68,  -1606,  20,  19 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x0090d7, 0x016a3e, 0x016a3e,  21,  -1605,  22,  21 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x01abb2, 0x01ef88, 0x01ef88,   9,  -1604,  17,   9 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x011f80, 0x005e9c, 0x005e9c,  58,  -1603,  27,  58 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x012a88, 0x00626d, 0x00626d,  57,  -1602,  26,  57 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00fcd5, 0x001900, 0x001900, 124,  -1601,  29,  45 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x01a52a, 0x0072c5, 0x0072c5,  52,  -1600,  18,  52 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x01e343, 0x00a1f0, 0x00a1f0,  41,  -1504,  12,  41 }, /* VERR_CSAM_HM_IPE */
    { 0x0137db, 0x01cc78, 0x01cc78,  14,  -1432,  25,  14 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x01e1d0, 0x007932, 0x007932,  50,  -1431,  12,  50 }, /* VERR_PATM_HM_IPE */
    { 0x01d084, 0x01b73a, 0x01b73a,  16,  -1428,  14,  16 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x01a970, 0x00ef38, 0x00ef38,  31,  -1426,  17,  31 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x01b3fa, 0x0180fb, 0x0180fb,  20,  -1425,  16,  20 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x01c619, 0x01b8ba, 0x01b8ba,  16,  -1406,  15,  16 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x01b78a, 0x01aed0, 0x01aed0,  17,  -1405,  16,  17 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x01c99d, 0x01ca51, 0x01ca51,  15,  -1403,  15,  15 }, /* VERR_PATCH_DISABLED */
    { 0x01eee6, 0x01d6ef, 0x01d6ef,  13,  -1402,   9,  13 }, /* VERR_PATCH_NOT_FOUND */
    { 0x01af36, 0x004332, 0x004332,  71,  -1401,  17,  71 }, /* VERR_PATCHING_REFUSED */
    { 0x01e29c, 0x01dbdc, 0x01dbdc,  13,  -1241,  12,  13 }, /* VERR_DBGF_CANCELLED */
    { 0x00d988, 0x00be16, 0x00be16,  36,  -1240,  33,  36 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x0132ae, 0x01248a, 0x01248a,  26,  -1238,  25,  26 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x01b233, 0x00a898, 0x00a898,  40,  -1237,  17,  40 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x01b288, 0x00a5f0, 0x00a5f0,  40,  -1236,  17,  40 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01f5d9, 0x017acf, 0x017acf,  20,  -1235,   8,  20 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01f5c1, 0x0183f3, 0x0183f3,  20,  -1234,   8,  20 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01f5d1, 0x0187c6, 0x0187c6,  20,  -1233,   8,  20 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01f5c9, 0x017e03, 0x017e03,  20,  -1232,   8,  20 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01f221, 0x017f7f, 0x017f7f,  20,  -1231,   8,  20 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01f559, 0x018407, 0x018407,  20,  -1230,   8,  20 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01f591, 0x0183a3, 0x0183a3,  20,  -1229,   8,  20 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01f569, 0x017e2b, 0x017e2b,  20,  -1228,   8,  20 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01f571, 0x018227, 0x018227,  20,  -1227,   8,  20 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x01118c, 0x0076d4, 0x0076d4,  51,  -1226,  28,  51 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x01d6fc, 0x008d3c, 0x008d3c,  46,  -1225,  13,  46 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01f946, 0x01bd3a, 0x01bd3a,  16,  -1223,   5,  16 }, /* VERR_DBGF_IPE_1 */
    { 0x01ca7e, 0x00a938, 0x00a938,  40,  -1222,  15,  40 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x01df54, 0x013e4d, 0x013e4d,  25,  -1221,  12,  25 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x01b89a, 0x007ff7, 0x007ff7,  49,  -1220,  16,  49 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01e4ed, 0x01a6d9, 0x01a6d9,  17,  -1219,  11,  17 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01e545, 0x01a7d8, 0x01a7d8,  17,  -1218,  11,  17 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x01b52a, 0x011f65, 0x011f65,  27,  -1217,  16,  27 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01efd9, 0x01e2a8, 0x01e2a8,  12,  -1216,   9,  12 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01efe2, 0x01e044, 0x01e044,  12,  -1215,   9,  12 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x016c9f, 0x01746a, 0x01746a,  21,  -1214,  21,  21 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01f2a9, 0x01b09b, 0x01b09b,  17,  -1213,   8,  17 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x01ce9a, 0x01f90b, 0x01f90b,   6,  -1210,  14,   6 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x01ce1c, 0x01c197, 0x01c197,  15,  -1209,  14,  15 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01f021, 0x01eb96, 0x01eb96,  10,  -1208,   9,  10 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01f531, 0x00f2ea, 0x00f2ea,  30,  -1204,   8,  30 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x01ac29, 0x019a45, 0x019a45,  18,  -1203,  17,  18 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x01e134, 0x0067b9, 0x0067b9,  56,  -1201,  12,  56 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x01e224, 0x004faa, 0x004faa,  64,  -1200,  12,  64 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x019ae6, 0x006c7b, 0x006c7b,  55,  -1158,  18,  32 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x016ad1, 0x00b584, 0x00b584,  38,  -1156,  21,  38 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x0177dc, 0x017065, 0x017065,  21,  -1154,  21,  21 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01cd82, 0x007226, 0x007226,  53,  -1149,  14,  53 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x01c101, 0x00b1a8, 0x00b1a8,  38,  -1148,  15,  38 }, /* VERR_EM_INTERPRETER */
    { 0x0162a7, 0x008238, 0x008238,  48,  -1133,  22,  40 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01e7d9, 0x010840, 0x010840,  28,  -1114,  11,  28 }, /* VERR_EM_NO_MEMORY */
    { 0x016c60, 0x0087f9, 0x0087f9,  47,  -1028,  21,  47 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x013a65, 0x017d63, 0x017d63,  20,  -1027,  25,  20 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01f218, 0x01a692, 0x01a692,  18,  -1026,   9,  18 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01e8cb, 0x01d386, 0x01d386,  14,  -1025,  11,  14 }, /* VERR_VM_RESTORED */
    { 0x016131, 0x00953f, 0x00953f,  43,  -1024,  22,  43 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x01e218, 0x010d9c, 0x010d9c,  28,  -1023,  12,  28 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01e679, 0x01e4ab, 0x01e4ab,  11,  -1022,  11,  11 }, /* VERR_INVALID_CPU_INDEX */
    { 0x01cec4, 0x0158ad, 0x0158ad,  23,  -1021,  14,  23 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x01ad8e, 0x001806, 0x001806, 125,  -1020,  17,  28 }, /* VERR_SERVICE_DISABLED */
    { 0x01e918, 0x01f511, 0x01f511,   8,  -1019,  11,   8 }, /* VERR_TOO_MANY_CPUS */
    { 0x01f4f1, 0x01eb82, 0x01eb82,  10,  -1018,   8,  10 }, /* VERR_INVALID_CPU_ID */
    { 0x01d068, 0x01ed76, 0x01ed76,  10,  -1017,  14,  10 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01eac4, 0x01ed76, 0x01ed76,  10,  -1016,  10,  10 }, /* VERR_INVALID_VM_HANDLE */
    { 0x01d2d0, 0x01c50b, 0x01c50b,  15,  -1015,  14,  15 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x010d64, 0x015349, 0x015349,  23,  -1014,  28,  23 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x0139b6, 0x01c40c, 0x01c40c,  15,  -1013,  25,  15 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01f9be, 0x01a200, 0x01a200,  18,  -1012,   5,  18 }, /* VERR_INVALID_RPL */
    { 0x01e984, 0x00d0f0, 0x00d0f0,  34,  -1011,  10,  10 }, /* VERR_INVALID_SELECTOR */
    { 0x014fdf, 0x016e97, 0x016e97,  21,  -1010,  23,  21 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x01c24b, 0x01d44a, 0x01d44a,  14,  -1009,  15,  14 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x01c06b, 0x019925, 0x019925,  18,  -1008,  15,  18 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x0197cf, 0x019f8a, 0x019f8a,  18,  -1007,  18,  18 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01e46a, 0x01ed8a, 0x01ed8a,  10,  -1006,  11,  10 }, /* VERR_CFG_NO_VALUE */
    { 0x01e3a3, 0x01430d, 0x01430d,  24,  -1005,  12,  24 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01cb0c, 0x01cc6a, 0x01cc6a,  14,  -1004,  14,  14 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01ee84, 0x01e9f2, 0x01e9f2,  10,  -1003,  10,  10 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01ee84, 0x01f99b, 0x01f99b,   5,  -1002,   5,   5 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01e90d, 0x0044da, 0x0044da,  70,  -1001,  11,  70 }, /* VERR_DONT_PANIC */
    { 0x01ee98, 0x017fbb, 0x017fbb,  20,  -1000,  10,  20 }, /* VERR_NO_VM_MEMORY */
    { 0x015304, 0x0074cd, 0x0074cd,  52,   -965,  23,  52 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x01a91b, 0x01b61a, 0x01b61a,  16,   -964,  17,  16 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x01a224, 0x01959f, 0x01959f,  19,   -963,  18,  19 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x01aab3, 0x01be3a, 0x01be3a,  16,   -962,  17,  16 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x01a92c, 0x01d172, 0x01d172,  14,   -961,  17,  14 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x01de34, 0x014f56, 0x014f56,  23,   -960,  12,  23 }, /* VERR_PKZIP_NO_EOCB */
    { 0x01b365, 0x01bdba, 0x01bdba,  16,   -953,  17,  16 }, /* VERR_POLL_SET_IS_FULL */
    { 0x01a14c, 0x013312, 0x013312,  25,   -952,  18,  25 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x015e03, 0x00dc9a, 0x00dc9a,  32,   -951,  22,  32 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x0160d9, 0x01913e, 0x01913e,  19,   -950,  22,  19 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x01c20f, 0x017ddb, 0x017ddb,  20,   -947,  15,  20 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x01214b, 0x011a8b, 0x011a8b,  27,   -946,  27,  27 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x01a440, 0x011a8b, 0x011a8b,  27,   -945,  18,  27 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x019883, 0x00e23a, 0x00e23a,  32,   -944,  18,  32 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x015c61, 0x00c469, 0x00c469,  36,   -943,  22,  36 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01d1aa, 0x00873d, 0x00873d,  47,   -942,  14,  47 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x010f78, 0x0112a4, 0x0112a4,  28,   -941,  28,  28 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x01c3df, 0x01ef64, 0x01ef64,   9,   -940,  15,   9 }, /* VERR_TAR_EMPTY_NAME */
    { 0x01c349, 0x009fb0, 0x009fb0,  42,   -939,  15,  31 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x01befa, 0x01ac6d, 0x01ac6d,  17,   -938,  16,  17 }, /* VERR_TAR_ZERO_HEADER */
    { 0x01c89e, 0x01b61a, 0x01b61a,  16,   -937,  15,  16 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x01c5ec, 0x011ea8, 0x011ea8,  27,   -936,  15,  27 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x018c91, 0x0152a8, 0x0152a8,  23,   -935,  19,  23 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x01b88a, 0x017e8f, 0x017e8f,  20,   -934,  16,  20 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x0173ad, 0x006631, 0x006631,  56,   -933,  21,  56 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x016ec1, 0x0063fc, 0x0063fc,  57,   -932,  21,  57 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x01b91a, 0x003fc7, 0x003fc7,  74,   -931,  16,  74 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x01810f, 0x00ad19, 0x00ad19,  39,   -930,  20,  39 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x01810f, 0x017def, 0x017def,  20,   -929,  15,  20 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x0189c0, 0x0050aa, 0x0050aa,  64,   -928,  19,  64 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01f1ac, 0x013858, 0x013858,  25,   -927,   9,  25 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x01b3ca, 0x0148c5, 0x0148c5,  24,   -926,  16,  24 }, /* VERR_TAR_END_OF_FILE */
    { 0x01d7d9, 0x00dd5a, 0x00dd5a,  32,   -925,  13,  32 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x016341, 0x016777, 0x016777,  22,   -906,  22,  22 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x017902, 0x014ecc, 0x014ecc,  23,   -905,  21,  23 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x01afcf, 0x00b512, 0x00b512,  38,   -904,  17,  38 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x01b49a, 0x010ae0, 0x010ae0,  28,   -903,  16,  28 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x019f78, 0x0138bc, 0x0138bc,  25,   -902,  18,  25 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x011cf8, 0x0082c8, 0x0082c8,  48,   -901,  27,  48 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x016761, 0x01126c, 0x01126c,  28,   -900,  22,  28 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x01e248, 0x01f658, 0x01f658,   7,   -899,  12,   7 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01f3f1, 0x0162bd, 0x0162bd,  22,   -898,   8,  22 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x01573d, 0x0145dd, 0x0145dd,  24,   -897,  23,  24 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x01d7a5, 0x00e29a, 0x00e29a,  32,   -896,  13,  32 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x01d404, 0x01327c, 0x01327c,  25,   -895,  14,  25 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01b7da, 0x018852, 0x018852,  20,   -894,  16,  20 }, /* VERR_HTTP_REDIRECTED */
    { 0x01d6d5, 0x010894, 0x010894,  28,   -893,  13,  28 }, /* VERR_HTTP_ABORTED */
    { 0x00e4da, 0x00a361, 0x00a361,  41,   -892,  32,  41 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x013169, 0x00e57a, 0x00e57a,  32,   -891,  25,  32 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x019080, 0x01be4a, 0x01be4a,  16,   -890,  19,  16 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x016ae6, 0x00c965, 0x00c965,  35,   -889,  21,  33 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x01cee0, 0x009bea, 0x009bea,  42,   -888,  14,  42 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x01933f, 0x0079c8, 0x0079c8,  50,   -887,  19,  24 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01f3d9, 0x008e1f, 0x008e1f,  45,   -886,   8,  45 }, /* VERR_HTTP_NOT_FOUND */
    { 0x01dd44, 0x016db0, 0x016db0,  21,   -885,  12,  21 }, /* VERR_HTTP_INIT_FAILED */
    { 0x0170e3, 0x018cca, 0x018cca,  19,   -884,  21,  19 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x01e1f4, 0x01d535, 0x01d535,  13,   -879,  12,  13 }, /* VERR_S3_CANCELED */
    { 0x01b1de, 0x012866, 0x012866,  26,   -878,  17,  26 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x019d02, 0x01c934, 0x01c934,  15,   -877,  18,  15 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01f82d, 0x0184f6, 0x0184f6,  20,   -876,   6,  20 }, /* VERR_S3_NOT_FOUND */
    { 0x01aebf, 0x01c547, 0x01c547,  15,   -875,  17,  15 }, /* VERR_S3_ACCESS_DENIED */
    { 0x018ca4, 0x014c84, 0x014c84,  24,   -855,  19,  24 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x01dd50, 0x0160c3, 0x0160c3,  22,   -851,  12,  22 }, /* VERR_CACHE_EMPTY */
    { 0x01e4b6, 0x016e58, 0x016e58,  21,   -850,  11,  21 }, /* VERR_CACHE_FULL */
    { 0x016d86, 0x00976e, 0x00976e,  43,   -829,  21,  43 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x01499d, 0x007639, 0x007639,  52,   -827,  24,  52 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00d7db, 0x008df2, 0x008df2,  45,   -826,  33,  45 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x01c4a2, 0x009d3a, 0x009d3a,  42,   -825,  15,  42 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01f793, 0x01e6f2, 0x01e6f2,  11,   -803,   7,  11 }, /* VERR_CPU_IPE_1 */
    { 0x01ace4, 0x009f08, 0x009f08,  42,   -802,  17,  42 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01f78c, 0x01efb5, 0x01efb5,   9,   -801,   7,   9 }, /* VERR_CPU_NOT_FOUND */
    { 0x01dccc, 0x01c05c, 0x01c05c,  15,   -800,  12,  15 }, /* VERR_CPU_OFFLINE */
    { 0x01d324, 0x009697, 0x009697,  43,   -753,  14,  43 }, /* VERR_ENV_VAR_UNSET */
    { 0x01cf5e, 0x011aa6, 0x011aa6,  27,   -752,  14,  27 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01e5df, 0x009f32, 0x00a6e0,  40,   -750,  11,  26 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x01400d, 0x003ab4, 0x003ab4,  79,   -704,  24,  34 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00e31a, 0x002343, 0x002343, 109,   -703,  32,  55 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x01815f, 0x0028a0, 0x0028a0, 102,   -702,  20,  12 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01ac4b, 0x001fd2, 0x001fd2, 111,   -701,  17,   6 }, /* VERR_RT_REQUEST_STATE */
    { 0x01b013, 0x000cd8, 0x000cd8, 162,   -700,  17,  10 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x012818, 0x01027f, 0x01027f,  29,   -696,  26,  29 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x01893b, 0x00e03a, 0x00e03a,  32,   -695,  19,  32 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x01ab7f, 0x0161cb, 0x0161cb,  22,   -694,  17,  22 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01f6c1, 0x00b4a0, 0x00b4a0,  38,   -693,   7,  38 }, /* VERR_CV_IPE */
    { 0x01f3d1, 0x008bfa, 0x008bfa,  46,   -692,   8,  46 }, /* VERR_CV_TODO */
    { 0x01e92e, 0x00c685, 0x00c685,  36,   -691,  11,  36 }, /* VERR_CV_BAD_FORMAT */
    { 0x01e014, 0x012902, 0x012902,  26,   -689,  12,  26 }, /* VERR_DBG_MOD_IPE */
    { 0x01e797, 0x009387, 0x009387,  44,   -688,  11,  44 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01efbe, 0x00faa6, 0x00faa6,  30,   -687,   9,  30 }, /* VERR_DBG_TODO */
    { 0x017d27, 0x00e88f, 0x00e88f,  31,   -686,  20,  31 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x018d75, 0x01627b, 0x01627b,  22,   -685,  19,  22 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x01c646, 0x01dfb4, 0x01dfb4,  12,   -684,  15,  12 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01eb00, 0x01e11c, 0x01e11c,  12,   -683,  10,  12 }, /* VERR_DWARF_IPE */
    { 0x016685, 0x011911, 0x011911,  27,   -682,  22,  27 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x016f15, 0x012cde, 0x012cde,  26,   -681,  21,  26 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x019913, 0x01ae48, 0x01ae48,  17,   -680,  18,  17 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01e7a2, 0x01e2e3, 0x01e2e3,  12,   -679,  11,  12 }, /* VERR_DWARF_TODO */
    { 0x01dd14, 0x011154, 0x011154,  28,   -678,  12,  28 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x01df78, 0x013a4c, 0x013a4c,  25,   -677,  12,  25 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x01b66a, 0x01418d, 0x01418d,  24,   -676,  16,  24 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x01cf34, 0x0132e0, 0x0132e0,  25,   -675,  14,  25 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x01e34f, 0x01de70, 0x01de70,  12,   -674,  12,  12 }, /* VERR_DWARF_BAD_INFO */
    { 0x01e923, 0x01bc7a, 0x01bc7a,  16,   -673,  11,  16 }, /* VERR_DWARF_BAD_POS */
    { 0x01cafe, 0x01cd04, 0x01cd04,  14,   -672,  14,  14 }, /* VERR_DWARF_BAD_STRING */
    { 0x01e755, 0x00ff53, 0x00ff53,  29,   -671,  11,  29 }, /* VERR_DWARF_BAD_LNE */
    { 0x01965d, 0x00ccad, 0x00ccad,  35,   -670,  19,  35 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01e62c, 0x01aae6, 0x01aae6,  17,   -669,  11,  17 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x012c76, 0x01d236, 0x01d236,  14,   -668,  26,  14 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x0127b0, 0x0089cf, 0x0089cf,  47,   -667,  26,  47 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x0187da, 0x00e2fa, 0x00e2fa,  32,   -666,  20,  32 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x01ad9f, 0x014055, 0x014055,  24,   -665,  17,  24 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x01b178, 0x0144bd, 0x0144bd,  24,   -664,  17,  24 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00f308, 0x002705, 0x002705, 103,   -663,  30,  31 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x011ef9, 0x002ff5, 0x002ff5,  94,   -662,  27,  24 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x01075e, 0x00296c, 0x00296c, 102,   -661,  29,  30 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x01deb8, 0x009e8a, 0x009e8a,  42,   -660,  12,  42 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x011e8d, 0x00911c, 0x00911c,  45,   -659,  27,  45 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x0175ba, 0x003829, 0x003829,  82,   -658,  21,  32 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x01747f, 0x00197c, 0x00197c, 124,   -657,  21,  41 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x017c4b, 0x011839, 0x011839,  27,   -656,  20,  27 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01f1b5, 0x011839, 0x011839,  27,   -655,   9,  27 }, /* VERR_DBG_INVALID_RVA */
    { 0x017b47, 0x01b85a, 0x01b85a,  16,   -654,  20,  16 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x01894e, 0x01c5a1, 0x01c5a1,  15,   -653,  19,  15 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x01db9b, 0x003053, 0x003053,  94,   -652,  13,  34 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x01d8b6, 0x010724, 0x010724,  29,   -651,  13,  29 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x019eb2, 0x010b50, 0x010b50,  28,   -650,  18,  28 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x01bc9a, 0x014895, 0x014895,  24,   -649,  16,  24 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01f1d0, 0x011839, 0x011839,  27,   -648,   9,  27 }, /* VERR_LDR_INVALID_RVA */
    { 0x01a488, 0x01ccf6, 0x01ccf6,  14,   -647,  18,  14 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00ea03, 0x010f94, 0x010f94,  28,   -641,  31,  28 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00eda5, 0x009ac4, 0x009ac4,  42,   -640,  31,  42 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x012a54, 0x011f14, 0x011f14,  27,   -639,  26,  27 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x011e21, 0x013fdd, 0x013fdd,  24,   -638,  27,  24 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x0170f8, 0x0128e8, 0x0128e8,  26,   -637,  21,  26 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x016be2, 0x00c325, 0x00c325,  36,   -636,  21,  36 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x0145c5, 0x00b0e8, 0x00b0e8,  39,   -635,  24,  39 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01c1d3, 0x01f006, 0x01f006,   9,   -634,  15,   9 }, /* VERR_LDRELF_VERSION */
    { 0x01c88f, 0x007ddc, 0x007ddc,  49,   -633,  15,  49 }, /* VERR_LDRELF_MACHINE */
    { 0x01e1c4, 0x00467e, 0x00467e,  70,   -632,  12,  70 }, /* VERR_LDRELF_EXEC */
    { 0x01e5ea, 0x004c17, 0x004c17,  67,   -631,  11,  67 }, /* VERR_LDRELF_DYN */
    { 0x01a02c, 0x00d5aa, 0x00d5aa,  33,   -630,  18,  33 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x017026, 0x00aaa0, 0x00aaa0,  40,   -628,  21,  40 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x014325, 0x005551, 0x005551,  62,   -627,  24,  62 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x0154b9, 0x007e0d, 0x007e0d,  49,   -626,  23,  49 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x016b4f, 0x013bc3, 0x013bc3,  25,   -625,  21,  25 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01ed4e, 0x019871, 0x019871,  18,   -624,  10,  18 }, /* VERR_LDRPE_TLS */
    { 0x01bc5a, 0x008e79, 0x008e79,  45,   -623,  16,  45 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x014d5c, 0x00ca37, 0x00ca37,  35,   -622,  23,  35 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x016f7e, 0x00f7b8, 0x00f7b8,  30,   -621,  21,  30 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x018c7e, 0x005dee, 0x005dee,  58,   -620,  19,  58 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x01c0e3, 0x01cbfa, 0x01cbfa,  14,   -619,  15,  14 }, /* VERR_LDR_IMAGE_HASH */
    { 0x017c73, 0x01edda, 0x01edda,  10,   -618,  20,  10 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x01580c, 0x00b266, 0x00b266,  38,   -617,  23,  38 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x01d841, 0x00bd5f, 0x00bd5f,  37,   -616,  13,  37 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01e592, 0x013470, 0x013470,  25,   -615,  11,  25 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x01aeae, 0x00f1dc, 0x00f1dc,  30,   -614,  17,  30 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01e810, 0x01f379, 0x01f379,   8,   -612,  11,   8 }, /* VERR_IMAGE_TOO_BIG */
    { 0x019cba, 0x007187, 0x007187,  53,   -611,  18,  53 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01ed58, 0x01f083, 0x01f083,   9,   -610,  10,   9 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01ee7a, 0x0199eb, 0x0199eb,  18,   -609,  10,  18 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x01e05c, 0x01e1dc, 0x01e1dc,  12,   -608,  12,  12 }, /* VERR_BAD_EXE_FORMAT */
    { 0x01e367, 0x007fc6, 0x007fc6,  49,   -607,  12,  21 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01eb32, 0x0089a0, 0x0089a0,  47,   -606,  10,  47 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01ebf0, 0x0088b5, 0x0088b5,  47,   -605,  10,  47 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01ea60, 0x008942, 0x008942,  47,   -604,  10,  47 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01ebc8, 0x0086b0, 0x0086b0,  47,   -603,  10,  47 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01eb14, 0x00870e, 0x00870e,  47,   -602,  10,  47 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01e89f, 0x008178, 0x008178,  48,   -601,  11,  48 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x01c3a3, 0x016525, 0x016525,  22,   -600,  15,  22 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x01b145, 0x011f2f, 0x011f2f,  27,   -566,  17,  27 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x013c27, 0x010245, 0x010245,  29,   -563,  25,  29 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x0111c4, 0x00e5fa, 0x00e5fa,  32,   -562,  28,  32 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x01c871, 0x00f0ab, 0x00f0ab,  31,   -561,  15,  31 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x0199b5, 0x00cfe0, 0x00cfe0,  34,   -560,  18,  34 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x01a981, 0x01db74, 0x01db74,  13,   -559,  17,  13 }, /* VERR_IPC_SEND_ABORTED */
    { 0x018672, 0x01bf79, 0x01bf79,  16,   -558,  20,  16 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x019566, 0x01c2c2, 0x01c2c2,  15,   -557,  19,  15 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x0165eb, 0x01a4d0, 0x01a4d0,  18,   -556,  22,  18 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x01b0ce, 0x01dbcf, 0x01dbcf,  13,   -555,  17,  13 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x017b1f, 0x01bf09, 0x01bf09,  16,   -554,  20,  16 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x01c3c1, 0x017248, 0x017248,  21,   -553,  15,  21 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x01beea, 0x01e642, 0x01e642,  11,   -552,  16,  11 }, /* VERR_RESOURCE_IN_USE */
    { 0x0111c4, 0x01f9af, 0x01f9af,   5,   -551,   4,   5 }, /* VERR_IPC */
    { 0x01cb28, 0x01517d, 0x01517d,  23,   -550,  14,  23 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x017122, 0x0155e4, 0x0155e4,  23,   -522,  21,  23 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x018173, 0x007d7a, 0x007d7a,  49,   -521,  20,  49 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x01b8ea, 0x01aff1, 0x01aff1,  17,   -520,  16,  17 }, /* VERR_UDP_SERVER_STOP */
    { 0x016c4b, 0x015194, 0x015194,  23,   -502,  21,  23 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x0181c3, 0x007d49, 0x007d49,  49,   -501,  20,  49 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x01bb5a, 0x01ab4c, 0x01ab4c,  17,   -500,  16,  17 }, /* VERR_TCP_SERVER_STOP */
    { 0x01a8a4, 0x0103a1, 0x0103a1,  29,   -469,  17,  29 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01e4f8, 0x01cbd0, 0x01cbd0,  14,   -468,  11,  14 }, /* VERR_NET_INIT_FAILED */
    { 0x013d9e, 0x00be5e, 0x00be5e,  36,   -467,  25,  36 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x01c5ce, 0x01eace, 0x01eace,  10,   -466,  15,  10 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x016c0c, 0x01d48c, 0x01d48c,  13,   -465,  21,  13 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x01d332, 0x01e8ec, 0x01e8ec,  11,   -464,  14,  11 }, /* VERR_NET_HOST_DOWN */
    { 0x014e2b, 0x0195b2, 0x0195b2,  19,   -461,  23,  19 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x013de9, 0x0116a4, 0x0116a4,  27,   -460,  25,  27 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x016ba3, 0x0116a4, 0x0116a4,  27,   -459,  21,  27 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x01d5c4, 0x00d6b2, 0x00d6b2,  33,   -458,  13,  33 }, /* VERR_NET_SHUTDOWN */
    { 0x01c03e, 0x01900e, 0x01900e,  19,   -457,  15,  19 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01c7bd, 0x0188c9, 0x0188c9,  19,   -456,  15,  19 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x01a6a4, 0x014a15, 0x014a15,  24,   -455,  18,  24 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x010197, 0x01566e, 0x01566e,  23,   -454,  29,  23 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x015588, 0x00d60d, 0x00d60d,  33,   -453,  23,  33 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x010197, 0x00c1be, 0x00c1be,  36,   -452,  21,  36 }, /* VERR_NET_CONNECTION_RESET */
    { 0x01bc8a, 0x016981, 0x016981,  21,   -451,  16,  21 }, /* VERR_NET_UNREACHABLE */
    { 0x01ef40, 0x01d12c, 0x01d12c,  14,   -450,   9,  14 }, /* VERR_NET_DOWN */
    { 0x0154fe, 0x01632b, 0x01632b,  22,   -449,  23,  22 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x018cb7, 0x01d0f4, 0x01d0f4,  14,   -448,  19,  14 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x016265, 0x00d068, 0x00d068,  34,   -447,  22,  34 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x0159d8, 0x01a13a, 0x01a13a,  18,   -446,  23,  18 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x01af69, 0x01ddd4, 0x01ddd4,  12,   -445,  17,  12 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x0196cf, 0x01eb64, 0x01eb64,  10,   -444,  19,  10 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x01b95a, 0x01e5b3, 0x01e5b3,  11,   -443,  16,  11 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x014b34, 0x0186d6, 0x0186d6,  20,   -442,  24,  20 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x019937, 0x014d44, 0x014d44,  24,   -441,  18,  24 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01dbf6, 0x01ce38, 0x01ce38,  14,   -440,  13,  14 }, /* VERR_NET_MSG_SIZE */
    { 0x0129ec, 0x00ff36, 0x00ff36,  29,   -439,  26,  29 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x01dce4, 0x004212, 0x004212,  72,   -438,  12,  39 }, /* VERR_NET_NOT_SOCKET */
    { 0x01ab19, 0x016b3a, 0x016b3a,  21,   -437,  17,  21 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x01b3da, 0x01878a, 0x01878a,  20,   -436,  16,  20 }, /* VERR_NET_IN_PROGRESS */
    { 0x01af47, 0x012950, 0x012950,  26,   -406,  17,  26 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x01da49, 0x015965, 0x015965,  23,   -405,  13,  23 }, /* VERR_NET_NO_NETWORK */
    { 0x01e170, 0x012f00, 0x012f00,  26,   -404,  12,  26 }, /* VERR_NET_PRINT_ERROR */
    { 0x01ddbc, 0x01e69a, 0x01e69a,  11,   -403,  12,  11 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x01ddec, 0x01e23c, 0x01e23c,  12,   -402,  12,  12 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x0171ca, 0x00e0ba, 0x00e0ba,  32,   -401,  21,  32 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01ef76, 0x00f380, 0x00f380,  30,   -400,   9,  30 }, /* VERR_NET_IO_ERROR */
    { 0x019a9f, 0x00af14, 0x00af14,  39,   -377,  18,  39 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x019c72, 0x00bf7e, 0x00bf7e,  36,   -376,  18,  36 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x01521e, 0x00cac3, 0x00cac3,  35,   -375,  23,  35 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x01d28a, 0x00b47a, 0x00b47a,  38,   -374,  14,  38 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x01396b, 0x002c2c, 0x002c2c,  98,   -373,  25,  44 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x01b43a, 0x00c541, 0x00c541,  36,   -372,  16,  36 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x01971b, 0x00c589, 0x00c589,  36,   -371,  18,  36 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x01cb6e, 0x008268, 0x008268,  48,   -370,  14,  48 }, /* VERR_SEM_LV_NESTED */
    { 0x011e3c, 0x00ffaa, 0x00ffaa,  29,   -369,  27,  29 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x0196a9, 0x00ff8d, 0x00ff8d,  29,   -368,  19,  29 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x01d938, 0x00f416, 0x00f416,  30,   -367,  13,  30 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x01b86a, 0x00c9ab, 0x00c9ab,  35,   -366,  16,  35 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01f19a, 0x01a65c, 0x01a65c,  18,   -365,   9,  18 }, /* VERR_DEADLOCK */
    { 0x01e550, 0x007dab, 0x007dab,  49,   -364,  11,  49 }, /* VERR_SEM_NESTED */
    { 0x01cd12, 0x00cf14, 0x00cf14,  34,   -363,  14,  34 }, /* VERR_SEM_DESTROYED */
    { 0x01f7ee, 0x01cad4, 0x01cad4,  14,   -362,   7,  14 }, /* VERR_SEM_NOT_FOUND */
    { 0x01c5dd, 0x00f632, 0x00f632,  30,   -361,  15,  30 }, /* VERR_SEM_OWNER_DIED */
    { 0x01f018, 0x01f491, 0x01f491,   8,   -360,   9,   8 }, /* VERR_SEM_BUSY */
    { 0x01f6c8, 0x01ad5b, 0x01ad5b,  17,   -359,   7,  17 }, /* VERR_ALREADY_RESET */
    { 0x01f399, 0x019cde, 0x019cde,  18,   -358,   8,  18 }, /* VERR_ALREADY_POSTED */
    { 0x01e14c, 0x00d08a, 0x00d08a,  34,   -357,  12,  34 }, /* VERR_TOO_MANY_POSTS */
    { 0x01deac, 0x0189d3, 0x0189d3,  19,   -356,  12,  19 }, /* VERR_TOO_MANY_OPENS */
    { 0x01f651, 0x00b3bc, 0x00b3bc,  38,   -355,   7,  38 }, /* VERR_NOT_OWNER */
    { 0x018f9c, 0x01cd4a, 0x01cd4a,  14,   -354,  19,  14 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01e87e, 0x01b277, 0x01b277,  17,   -353,  11,  17 }, /* VERR_SEM_IS_SET */
    { 0x01be9a, 0x00ca5a, 0x00ca5a,  35,   -352,  16,  35 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x01a893, 0x01daf2, 0x01daf2,  13,   -351,  17,  13 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01f857, 0x01555a, 0x01555a,  23,   -350,   6,  23 }, /* VERR_SEM_ERROR */
    { 0x01dec4, 0x00b850, 0x00b850,  37,   -308,  12,  37 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01e50e, 0x00ba7b, 0x00ba7b,  37,   -307,  11,  37 }, /* VERR_PIPE_NOT_READ */
    { 0x01eb78, 0x016617, 0x016617,  22,   -306,  10,  22 }, /* VERR_MORE_DATA */
    { 0x01bcca, 0x01af58, 0x01af58,  17,   -305,  16,  17 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01f8bd, 0x01f579, 0x01f579,   8,   -304,   6,   8 }, /* VERR_NO_DATA */
    { 0x01ea56, 0x01e6dc, 0x01e6dc,  11,   -303,  10,  11 }, /* VERR_PIPE_BUSY */
    { 0x01f8e7, 0x01f881, 0x01f881,   6,   -302,   6,   6 }, /* VERR_BAD_PIPE */
    { 0x01e1e8, 0x01e200, 0x01e200,  12,   -301,  12,  12 }, /* VERR_BROKEN_PIPE */
    { 0x01e9ca, 0x00ed29, 0x00ed29,  31,   -300,  10,  31 }, /* VERR_PIPE_IO_ERROR */
    { 0x01c3b2, 0x0114b8, 0x0114b8,  28,   -257,  15,  28 }, /* VERR_IO_GEN_FAILURE */
    { 0x01d8d0, 0x0170b9, 0x0170b9,  21,   -256,  13,  21 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01e6bb, 0x017c37, 0x017c37,  20,   -255,  11,  20 }, /* VERR_IO_BAD_LENGTH */
    { 0x01f769, 0x01abc3, 0x01abc3,  17,   -254,   7,  17 }, /* VERR_IO_CRC */
    { 0x01df3c, 0x01729c, 0x01729c,  21,   -253,  12,  21 }, /* VERR_IO_BAD_COMMAND */
    { 0x01e9de, 0x015bc7, 0x015bc7,  22,   -252,  10,  22 }, /* VERR_IO_NOT_READY */
    { 0x01f072, 0x019ac2, 0x019ac2,  18,   -251,   9,  18 }, /* VERR_IO_BAD_UNIT */
    { 0x01f140, 0x0115b1, 0x0115b1,  27,   -250,   9,  27 }, /* VERR_DEV_IO_ERROR */
    { 0x014f6d, 0x0081d8, 0x0081d8,  48,   -234,  23,  48 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x015eb3, 0x0062df, 0x0062df,  57,   -233,  22,  24 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01e73f, 0x01e76b, 0x01e76b,  11,   -232,  11,  11 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x01cd2e, 0x01e76b, 0x01e76b,  11,   -231,  14,  11 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01f20f, 0x01e76b, 0x01e76b,  11,   -230,   9,  11 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01d5aa, 0x01f259, 0x01f259,   8,   -229,  13,   5 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01d5b7, 0x01f259, 0x01f2f1,   8,   -228,  13,   5 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01d5de, 0x01f259, 0x01f4b1,   8,   -227,  13,   5 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01d5d1, 0x01f259, 0x01f419,   8,   -226,  13,   5 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01d5aa, 0x018de7, 0x018de7,  19,   -225,  11,  19 }, /* VERR_INTERNAL_ERROR */
    { 0x016958, 0x011c20, 0x011c20,  27,   -202,  21,  27 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x01e32b, 0x01ef6d, 0x01ef6d,   9,   -201,  12,   9 }, /* VERR_NO_MORE_FILES */
    { 0x01f045, 0x01046c, 0x01046c,  29,   -200,   9,  29 }, /* VERR_SEARCH_ERROR */
    { 0x01c23c, 0x01cd3c, 0x01cd3c,  14,   -165,  15,  14 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x01b343, 0x01671f, 0x01671f,  22,   -164,  17,  22 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x019f66, 0x019a21, 0x019a21,  18,   -163,  18,  18 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x01de28, 0x01dd74, 0x01dd74,  12,   -162,  12,  12 }, /* VERR_IS_A_SOCKET */
    { 0x01e9ac, 0x01ee8e, 0x01ee8e,  10,   -161,  10,  10 }, /* VERR_IS_A_FIFO */
    { 0x01d9ad, 0x018f3d, 0x018f3d,  19,   -160,  13,  19 }, /* VERR_IS_A_SYMLINK */
    { 0x01aaf7, 0x0150c5, 0x0150c5,  23,   -159,  17,  23 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x0141d5, 0x00a820, 0x00a820,  40,   -158,  24,  40 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x0184ce, 0x008a2d, 0x008a2d,  47,   -157,  20,  47 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01ca42, 0x01afe0, 0x01afe0,  17,   -156,  15,  17 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x01d7e6, 0x011288, 0x011288,  28,   -155,  13,  28 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x01dc44, 0x01d2fa, 0x01d2fa,  14,   -154,  13,  14 }, /* VERR_DRIVE_LOCKED */
    { 0x01dfa8, 0x01ccda, 0x01ccda,  14,   -153,  12,  14 }, /* VERR_DISK_CHANGE */
    { 0x01ed80, 0x01e939, 0x01e939,  11,   -152,  10,  11 }, /* VERR_DISK_FULL */
    { 0x01f79a, 0x01cd66, 0x01cd66,  14,   -151,   7,  14 }, /* VERR_INVALID_DRIVE */
    { 0x01ebd2, 0x00efb3, 0x00efb3,  31,   -150,  10,  31 }, /* VERR_DISK_IO_ERROR */
    { 0x019db6, 0x002b01, 0x002b01, 100,   -147,  18,  41 }, /* VERR_STALE_FILE_HANDLE */
    { 0x00fcb8, 0x00211e, 0x00211e, 110,   -146,  29,  65 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x01a772, 0x01b1cd, 0x01b1cd,  17,   -145,  17,  17 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x019f54, 0x008f87, 0x008f87,  45,   -144,  18,  45 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x01add2, 0x00f362, 0x00f362,  30,   -143,  17,  30 }, /* VERR_PATH_IS_RELATIVE */
    { 0x011962, 0x00d691, 0x00d691,  33,   -142,  27,  33 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01d499, 0x019d4a, 0x019d4a,  18,   -141,  13,  18 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01ee70, 0x00e1ba, 0x00e1ba,  32,   -140,  10,  32 }, /* VERR_IS_A_FILE */
    { 0x01f361, 0x00e09a, 0x00e09a,  32,   -139,   8,  32 }, /* VERR_NOT_A_FILE */
    { 0x01d1e2, 0x0155fb, 0x0155fb,  23,   -138,  14,  23 }, /* VERR_RESOURCE_BUSY */
    { 0x00d946, 0x0063c3, 0x0063c3,  57,   -137,  33,  57 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x018e20, 0x00b668, 0x00b668,  38,   -136,  19,  38 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x0185fa, 0x00a54d, 0x00a54d,  41,   -135,  20,  41 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x0198dd, 0x01e373, 0x01e373,  12,   -134,  18,  12 }, /* VERR_FILE_AIO_CANCELED */
    { 0x014a5d, 0x004da4, 0x004da4,  65,   -133,  24,  65 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01cbde, 0x004b91, 0x004b91,  67,   -132,  14,  67 }, /* VERR_FILE_AIO_BUSY */
    { 0x018d88, 0x00d2cc, 0x00d2cc,  34,   -131,  19,  34 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x017512, 0x004862, 0x004862,  68,   -130,  21,  68 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x01a53c, 0x009a9a, 0x009a9a,  42,   -129,  18,  42 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01eeca, 0x0070e8, 0x0070e8,  53,   -128,  10,  53 }, /* VERR_FILE_TOO_BIG */
    { 0x01c51a, 0x00e55a, 0x00e55a,  32,   -127,  15,  32 }, /* VERR_IS_A_DIRECTORY */
    { 0x01dc51, 0x00e59a, 0x00e59a,  32,   -126,  13,  32 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01e6b0, 0x016bf7, 0x016bf7,  21,   -125,  11,  21 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01c394, 0x01301e, 0x01301e,  26,   -124,  15,  26 }, /* VERR_FILE_LOCK_LOST */
    { 0x01d472, 0x00eadc, 0x00eadc,  31,   -123,  13,  31 }, /* VERR_FILE_NOT_LOCKED */
    { 0x01a41c, 0x00b1f4, 0x00b1f4,  38,   -122,  18,  22 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x01c7ea, 0x01603f, 0x01603f,  22,   -121,  15,  22 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x01c6fa, 0x011480, 0x011480,  28,   -120,  15,  28 }, /* VERR_FILENAME_TOO_LONG */
    { 0x01da97, 0x013038, 0x013038,  26,   -119,  13,  26 }, /* VERR_NOT_SAME_DEVICE */
    { 0x016147, 0x0130ec, 0x0130ec,  25,   -118,  22,  25 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01e2cc, 0x01666f, 0x01666f,  22,   -117,  12,  22 }, /* VERR_CANT_CREATE */
    { 0x017cff, 0x0070b3, 0x0070b3,  53,   -116,  20,  53 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01dde0, 0x014115, 0x014115,  24,   -115,  12,  24 }, /* VERR_FILE_LOCK_FAILED */
    { 0x01a344, 0x009227, 0x009227,  44,   -114,  18,  44 }, /* VERR_SHARING_VIOLATION */
    { 0x01cb60, 0x01c835, 0x01c835,  15,   -113,  14,  15 }, /* VERR_WRITE_PROTECT */
    { 0x01f431, 0x01efd0, 0x01efd0,   9,   -112,   8,   9 }, /* VERR_WRITE_ERROR */
    { 0x01f715, 0x01f389, 0x01f389,   8,   -111,   7,   8 }, /* VERR_READ_ERROR */
    { 0x01fa15, 0x0182db, 0x0182db,  20,   -110,   4,  20 }, /* VERR_EOF */
    { 0x01c385, 0x0159aa, 0x0159aa,  23,   -109,  15,  23 }, /* VERR_SEEK_ON_DEVICE */
    { 0x01d148, 0x019895, 0x019895,  18,   -108,  14,  18 }, /* VERR_NEGATIVE_SEEK */
    { 0x01c385, 0x01f8ed, 0x01f8ed,   6,   -107,   5,   6 }, /* VERR_SEEK */
    { 0x01abf6, 0x01d95f, 0x01d95f,  13,   -106,  17,  13 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01f311, 0x018277, 0x018277,  20,   -105,   8,  20 }, /* VERR_ALREADY_EXISTS */
    { 0x01f8f3, 0x011020, 0x011020,  28,   -104,   6,  28 }, /* VERR_INVALID_NAME */
    { 0x01f499, 0x01f7b6, 0x01f7b6,   7,   -103,   8,   7 }, /* VERR_PATH_NOT_FOUND */
    { 0x01f561, 0x01f7fc, 0x01f7fc,   7,   -102,   8,   7 }, /* VERR_FILE_NOT_FOUND */
    { 0x01f73f, 0x01996d, 0x01996d,  18,   -101,   7,  18 }, /* VERR_OPEN_FAILED */
    { 0x01eaec, 0x012058, 0x012058,  27,   -100,  10,  27 }, /* VERR_FILE_IO_ERROR */
    { 0x01f3a1, 0x018fc2, 0x018fc2,  19,    -99,   8,  19 }, /* VERR_MISSING */
    { 0x01ecd6, 0x017d8b, 0x017d8b,  20,    -98,  10,  20 }, /* VERR_DUPLICATE */
    { 0x01e852, 0x01d244, 0x01d244,  14,    -97,  11,  14 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01d66d, 0x008cb2, 0x008cb2,  46,    -96,  13,  46 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01f391, 0x01ea38, 0x01ea38,  10,    -95,   8,  10 }, /* VERR_NO_CHANGE */
    { 0x01a584, 0x002e16, 0x002e16,  97,    -93,  18,  32 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x01a116, 0x00e8ec, 0x00e8ec,  31,    -92,  18,  31 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01f299, 0x004ac6, 0x004ac6,  68,    -91,   8,  68 }, /* VERR_IGNORED */
    { 0x01d19c, 0x01ac07, 0x01ac07,  17,    -90,  14,  17 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x0150dc, 0x014e87, 0x014e87,  23,    -89,  23,  23 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x01bc1a, 0x00aec6, 0x00aec6,  39,    -88,  16,  39 }, /* VERR_CALLBACK_RETURN */
    { 0x01af03, 0x01b211, 0x01b211,  17,    -87,  17,  17 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x01ae6a, 0x013f2e, 0x013f2e,  25,    -86,  17,  25 }, /* VERR_DANGLING_OBJECTS */
    { 0x01aa09, 0x018cdd, 0x018cdd,  19,    -85,  17,  19 }, /* VERR_OBJECT_DESTROYED */
    { 0x014445, 0x0173c2, 0x0173c2,  21,    -84,  24,  21 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01cf88, 0x01e2d7, 0x01e2d7,  12,    -83,  14,  12 }, /* VERR_END_OF_STRING */
    { 0x01b156, 0x005361, 0x005361,  62,    -82,  17,  21 }, /* VERR_PREEMPT_DISABLED */
    { 0x01d0e6, 0x00c206, 0x00c206,  36,    -81,  14,  36 }, /* VERR_NO_MORE_HANDLES */
    { 0x01b123, 0x01a82d, 0x01a82d,  17,    -80,  17,  17 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01f6a5, 0x01fa39, 0x01fa39,   4,    -79,   7,   4 }, /* VERR_INVALID_STATE */
    { 0x01fa68, 0x01ef9a, 0x01ef9a,   9,    -78,   3,   9 }, /* VERR_NOT_FOUND */
    { 0x01bc2a, 0x01b45a, 0x01b45a,  16,    -77,  16,  16 }, /* VERR_TRAILING_SPACES */
    { 0x01c07a, 0x0184a6, 0x0184a6,  20,    -76,  15,  20 }, /* VERR_TRAILING_CHARS */
    { 0x01f875, 0x01ba0a, 0x01ba0a,  16,    -75,   6,  16 }, /* VERR_MAP_FAILED */
    { 0x01d78b, 0x00cc8a, 0x00cc8a,  35,    -74,  13,  35 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01d92b, 0x0066a1, 0x0066a1,  56,    -73,  13,  56 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01ddf8, 0x0077d3, 0x0077d3,  51,    -72,  12,  51 }, /* VERR_NO_LOW_MEMORY */
    { 0x01ce70, 0x00606c, 0x00606c,  57,    -71,  14,  23 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01e97a, 0x006ac3, 0x006ac3,  55,    -70,  10,  55 }, /* VERR_CANCELLED */
    { 0x01b84a, 0x00b0c1, 0x00b0c1,  39,    -69,  16,  39 }, /* VERR_TIMER_SUSPENDED */
    { 0x01d660, 0x00bf5a, 0x00bf5a,  36,    -68,  13,  36 }, /* VERR_TIMER_ACTIVE */
    { 0x01e3d3, 0x00d81d, 0x00d81d,  33,    -67,  12,  33 }, /* VERR_MEMORY_BUSY */
    { 0x018915, 0x0061fb, 0x0061fb,  57,    -66,  19,  57 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01d2b4, 0x005227, 0x005227,  63,    -65,  14,  63 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01df9c, 0x0089fe, 0x0089fe,  47,    -64,  12,  47 }, /* VERR_NO_STR_MEMORY */
    { 0x0172b1, 0x008596, 0x008596,  47,    -63,  21,  47 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01b50a, 0x009641, 0x009641,  43,    -62,  16,  43 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01ca06, 0x00a19e, 0x00a19e,  41,    -61,  15,  41 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x016fd2, 0x007900, 0x007900,  50,    -60,  21,  50 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x011384, 0x0040ef, 0x0040ef,  73,    -59,  28,  73 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x01d7f3, 0x00927f, 0x00927f,  44,    -58,  13,  44 }, /* VERR_NO_TRANSLATION */
    { 0x01a54e, 0x00b797, 0x00b797,  37,    -57,  18,  37 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01f2f9, 0x00a7d0, 0x00a7d0,  40,    -56,   8,  40 }, /* VERR_NO_DIGITS */
    { 0x01df84, 0x00a42e, 0x00a42e,  41,    -55,  12,  41 }, /* VERR_NUMBER_TOO_BIG */
    { 0x01d7b2, 0x01a9f8, 0x01a9f8,  17,    -54,  13,  17 }, /* VERR_OUT_OF_RANGE */
    { 0x01f581, 0x01f321, 0x01f321,   8,    -53,   8,   8 }, /* VERR_PARSE_ERROR */
    { 0x01eb8c, 0x01f381, 0x01f381,   8,    -52,  10,   8 }, /* VERR_TRY_AGAIN */
    { 0x01bb6a, 0x00d6d3, 0x00d6d3,  33,    -51,  16,  33 }, /* VERR_PROCESS_RUNNING */
    { 0x01e4e2, 0x01f80f, 0x01f80f,   6,    -50,  11,   6 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x01db0c, 0x0120a9, 0x0120a9,  27,    -49,  13,  27 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01d076, 0x004ea8, 0x004ea8,  65,    -48,  14,  10 }, /* VERR_STATE_CHANGED */
    { 0x01c862, 0x012bda, 0x012bda,  26,    -47,  15,  26 }, /* VERR_SIGNAL_INVALID */
    { 0x01bfd5, 0x0191c3, 0x0191c3,  19,    -46,  15,  19 }, /* VERR_SIGNAL_PENDING */
    { 0x01c448, 0x010741, 0x010741,  29,    -45,  15,  29 }, /* VERR_SIGNAL_REFUSED */
    { 0x01985f, 0x01caf0, 0x01caf0,  14,    -44,  18,  14 }, /* VERR_MAX_PROCS_REACHED */
    { 0x01a560, 0x016fa8, 0x016fa8,  21,    -43,  18,  21 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01e5be, 0x01c1c4, 0x01c1c4,  15,    -42,  11,  15 }, /* VERR_TOO_MUCH_DATA */
    { 0x01bf69, 0x011e06, 0x011e06,  27,    -41,  16,  27 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01f3a9, 0x01f369, 0x01f369,   8,    -40,   8,   8 }, /* VERR_TIMEOUT */
    { 0x01e403, 0x01aac4, 0x01aac4,  17,    -39,  12,  17 }, /* VERR_INTERRUPTED */
    { 0x01cfa4, 0x01d340, 0x01d340,  14,    -38,  14,  14 }, /* VERR_ACCESS_DENIED */
    { 0x01fa59, 0x01f9b4, 0x01f9b4,   5,    -37,   3,   5 }, /* VERR_NOT_SUPPORTED */
    { 0x01eb1e, 0x01ed08, 0x01ed08,  10,    -36,  10,  10 }, /* VERR_INVALID_FUNCTION */
    { 0x01db5a, 0x00c619, 0x00c619,  36,    -35,  13,  36 }, /* VERR_UNRESOLVED_ERROR */
    { 0x01ac18, 0x01b2ff, 0x01b2ff,  17,    -34,  17,  17 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01e7fa, 0x01a368, 0x01a368,  18,    -33,  11,  18 }, /* VERR_TIMER_BUSY */
    { 0x01f206, 0x008d6a, 0x008d6a,  46,    -32,   9,   9 }, /* VERR_INVALID_CONTEXT */
    { 0x017ceb, 0x018f50, 0x018f50,  19,    -31,  20,  19 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x01b112, 0x01873a, 0x01873a,  20,    -30,  17,  20 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x01ca8d, 0x01c2ef, 0x01c2ef,  15,    -29,  15,  15 }, /* VERR_THREAD_IS_DEAD */
    { 0x01dc5e, 0x01865e, 0x01865e,  20,    -28,  13,  20 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01d61f, 0x011a1f, 0x011a1f,  27,    -27,  13,  27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01d6a1, 0x00bbc8, 0x00bbc8,  37,    -26,  13,  37 }, /* VERR_NO_CONT_MEMORY */
    { 0x019d92, 0x004d63, 0x004d63,  65,    -24,  18,  65 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x01cff8, 0x005266, 0x005266,  63,    -23,  14,  63 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x01e188, 0x0176cb, 0x0176cb,  21,    -22,  12,  21 }, /* VERR_WRONG_ORDER */
    { 0x01f71c, 0x016029, 0x016029,  22,    -21,   7,  22 }, /* VERR_INVALID_FMODE */
    { 0x01de7c, 0x010d10, 0x010d10,  28,    -20,  12,  28 }, /* VERR_NO_TMP_MEMORY */
    { 0x01efac, 0x00f5ba, 0x00f5ba,  30,    -19,   9,  30 }, /* VERR_NOT_SYMLINK */
    { 0x01f682, 0x01ead8, 0x01ead8,  10,    -18,   7,  10 }, /* VERR_NOT_EQUAL */
    { 0x01f723, 0x01d0bc, 0x01d0bc,  14,    -13,   7,  14 }, /* VERR_INVALID_FLAGS */
    { 0x01d91e, 0x0132c7, 0x0132c7,  25,    -12,  13,  25 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01ec5e, 0x01b057, 0x01b057,  17,    -11,  10,  17 }, /* VERR_VERSION_MISMATCH */
    { 0x01a1a6, 0x019ea0, 0x019ea0,  18,    -10,  18,  18 }, /* VERR_PERMISSION_DENIED */
    { 0x01f509, 0x01c727, 0x01c727,  15,     -9,   8,  15 }, /* VERR_ALREADY_LOADED */
    { 0x01f4b9, 0x01efc7, 0x01efc7,   9,     -8,   8,   9 }, /* VERR_NO_MEMORY */
    { 0x01f8d5, 0x01d653, 0x01d653,  13,     -7,   6,  13 }, /* VERR_IDT_FAILED */
    { 0x01f16d, 0x01ee66, 0x01ee66,  10,     -6,   9,  10 }, /* VERR_INVALID_POINTER */
    { 0x01f7e7, 0x015d7f, 0x015d7f,  22,     -5,   7,  22 }, /* VERR_LOCK_FAILED */
    { 0x01f3c1, 0x01f3e9, 0x01f3e9,   8,     -4,   8,   8 }, /* VERR_INVALID_HANDLE */
    { 0x01f7d2, 0x01c493, 0x01c493,  15,     -3,   7,  15 }, /* VERR_INVALID_MAGIC */
    { 0x01e6e7, 0x01e524, 0x01e524,  11,     -2,  11,  11 }, /* VERR_INVALID_PARAMETER */
    { 0x01b42a, 0x00be3a, 0x00be3a,  36,     -1,  16,  36 }, /* VERR_GENERAL_FAILURE */
    { 0x01f4c9, 0x01f479, 0x01f479,   8,      0,   8,   8 }, /* VINF_SUCCESS */
    { 0x01c22d, 0x01e524, 0x01e524,  11,      2,  15,  11 }, /* VWRN_INVALID_PARAMETER */
    { 0x01e873, 0x01c493, 0x01c493,  15,      3,  11,  15 }, /* VWRN_INVALID_MAGIC */
    { 0x01e254, 0x01f3e9, 0x01f3e9,   8,      4,  12,   8 }, /* VWRN_INVALID_HANDLE */
    { 0x01a596, 0x019ea0, 0x019ea0,  18,     10,  18,  18 }, /* VINF_PERMISSION_DENIED */
    { 0x01d9a0, 0x0132c7, 0x0132c7,  25,     12,  13,  25 }, /* VINF_NOT_IMPLEMENTED */
    { 0x01da7d, 0x01865e, 0x01865e,  20,     28,  13,  20 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01fa5f, 0x01f9b4, 0x01f9b4,   5,     37,   3,   5 }, /* VINF_NOT_SUPPORTED */
    { 0x01e158, 0x01aac4, 0x01aac4,  17,     39,  12,  17 }, /* VINF_INTERRUPTED */
    { 0x01f521, 0x01f369, 0x01f369,   8,     40,   8,   8 }, /* VINF_TIMEOUT */
    { 0x01b98a, 0x011e06, 0x011e06,  27,     41,  16,  27 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01a290, 0x004011, 0x004011,  74,     48,  18,  19 }, /* VWRN_STATE_CHANGED */
    { 0x01edd0, 0x01f381, 0x01f381,   8,     52,  10,   8 }, /* VINF_TRY_AGAIN */
    { 0x01bd4a, 0x00a42e, 0x00a42e,  41,     55,  16,  41 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01dee8, 0x00a7d0, 0x00a7d0,  40,     56,  12,  40 }, /* VWRN_NO_DIGITS */
    { 0x016903, 0x00b797, 0x00b797,  37,     57,  22,  37 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x01abd4, 0x00927f, 0x00927f,  44,     58,  17,  44 }, /* VWRN_NO_TRANSLATION */
    { 0x01938b, 0x0184a6, 0x0184a6,  20,     76,  19,  20 }, /* VWRN_TRAILING_CHARS */
    { 0x01829f, 0x01b45a, 0x01b45a,  16,     77,  20,  16 }, /* VWRN_TRAILING_SPACES */
    { 0x01f66d, 0x01b5ba, 0x01b5ba,  16,     78,   7,  16 }, /* VWRN_NOT_FOUND */
    { 0x01e74a, 0x01e5f5, 0x01e5f5,  11,     79,  11,  11 }, /* VWRN_INVALID_STATE */
    { 0x01768c, 0x0142f5, 0x0142f5,  24,     80,  21,  24 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01cb44, 0x01e2d7, 0x01e2d7,  12,     83,  14,  12 }, /* VINF_END_OF_STRING */
    { 0x01b0ac, 0x011602, 0x011602,  27,     85,  17,  27 }, /* VINF_OBJECT_DESTROYED */
    { 0x01731a, 0x013f2e, 0x013f2e,  25,     86,  21,  25 }, /* VWRN_DANGLING_OBJECTS */
    { 0x01b76a, 0x00aec6, 0x00aec6,  39,     88,  16,  39 }, /* VINF_CALLBACK_RETURN */
    { 0x01f2d9, 0x01d412, 0x01d412,  14,     95,   8,  14 }, /* VINF_NO_CHANGE */
    { 0x01e83c, 0x004ee9, 0x004ee9,  65,     97,  11,  65 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01df24, 0x018277, 0x018277,  20,    105,  12,  20 }, /* VWRN_ALREADY_EXISTS */
    { 0x01fa09, 0x0182db, 0x0182db,  20,    110,   4,  20 }, /* VINF_EOF */
    { 0x01abe5, 0x008ed3, 0x008ed3,  45,    203,  17,  45 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01f541, 0x019cde, 0x019cde,  18,    358,   8,  18 }, /* VINF_ALREADY_POSTED */
    { 0x01e944, 0x003f33, 0x003f33,  74,    364,  11,  37 }, /* VINF_SEM_NESTED */
    { 0x01d9e1, 0x007af4, 0x007af4,  50,    367,  13,  50 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x01b68a, 0x01a6fb, 0x01a6fb,  17,    500,  16,  17 }, /* VINF_TCP_SERVER_STOP */
    { 0x0189e6, 0x00c36d, 0x00c36d,  36,    503,  19,  36 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x01bcfa, 0x01a6fb, 0x01a6fb,  17,    520,  16,  17 }, /* VINF_UDP_SERVER_STOP */
    { 0x0195fe, 0x00c5ad, 0x00c5ad,  36,    523,  19,  36 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x018712, 0x009253, 0x009253,  44,    564,  20,  44 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x01b244, 0x00a123, 0x00a123,  41,    565,  17,  41 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x0163af, 0x00c9f1, 0x00c9f1,  35,    690,  22,  35 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01e663, 0x009f32, 0x009f32,  42,    750,  11,  26 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x01255a, 0x002e77, 0x002e77,  96,    751,  26,  96 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x01ce54, 0x00bd84, 0x00bd84,  37,    753,  14,  37 }, /* VINF_ENV_VAR_UNSET */
    { 0x01c42a, 0x01641d, 0x01641d,  22,    828,  15,  22 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x01da2f, 0x01ca9c, 0x01ca9c,  14,    948,  13,  14 }, /* VINF_TAR_DIR_PATH */
    { 0x01efeb, 0x01f99b, 0x01f99b,   5,   1002,   9,   5 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x0174d3, 0x0087f9, 0x0087f9,  47,   1028,  21,  47 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x01d4f4, 0x009fda, 0x009fda,  42,   1100,  13,  42 }, /* VINF_EM_TERMINATE */
    { 0x017551, 0x001a71, 0x001a71, 120,   1101,  21,  25 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x01427d, 0x001ae9, 0x001ae9, 120,   1102,  24, 120 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x015868, 0x0012ce, 0x0012ce, 138,   1103,  23, 138 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x01d986, 0x00c4f9, 0x00c4f9,  36,   1104,  13,  36 }, /* VINF_EM_DBG_EVENT */
    { 0x01e074, 0x005bdf, 0x005bdf,  59,   1105,  12,  59 }, /* VINF_EM_DBG_STOP */
    { 0x01bfa8, 0x0067f1, 0x0067f1,  56,   1106,  15,  56 }, /* VINF_EM_DBG_STEPPED */
    { 0x01a1b8, 0x0042ea, 0x0042ea,  72,   1107,  18,  72 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x01bfa8, 0x0043c0, 0x0043c0,  71,   1108,  12,  31 }, /* VINF_EM_DBG_STEP */
    { 0x01f6d6, 0x00512a, 0x00512a,  64,   1109,   7,  64 }, /* VINF_EM_OFF */
    { 0x000096, 0x0057b3, 0x0057b3,  60,   1110,  11,  60 }, /* VINF_EM_SUSPEND */
    { 0x01ef5b, 0x006f05, 0x006f05,  54,   1111,   9,  54 }, /* VINF_EM_RESET */
    { 0x00008c, 0x003486, 0x003486,  87,   1112,   8,  87 }, /* VINF_EM_HALT */
    { 0x0000a4, 0x009c92, 0x009c92,  42,   1113,  10,  42 }, /* VINF_EM_RESUME */
    { 0x010850, 00000000, 00000000, 368,   1114,  11,  80 }, /* VINF_EM_NO_MEMORY */
    { 0x0197f3, 0x0002be, 0x0002be, 281,   1115,  18,  39 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x012e98, 0x0003d7, 0x0003d7, 220,   1116,  26,  41 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x012e98, 0x00391f, 0x00391f,  81,   1118,  14,  31 }, /* VINF_EM_RESCHEDULE */
    { 0x01d4cd, 0x00ff70, 0x00ff70,  29,   1120,  13,  29 }, /* VINF_EM_WAIT_SIPI */
    { 0x019dfe, 0x00316b, 0x00316b,  91,   1121,  18,  41 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x013ac9, 0x003b52, 0x003b52,  78,   1122,  17,  39 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x015a79, 0x000e1a, 0x000e1a, 158,   1123,  23,  58 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x014de6, 0x004494, 0x004494,  70,   1124,  19,  32 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x014de6, 0x002f96, 0x002f96,  95,   1125,  23,  57 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x0113d8, 0x003b03, 0x003b03,  79,   1126,  28,  41 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00e851, 0x011653, 0x011653,  27,   1127,  21,  27 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00f04e, 0x007395, 0x007395,  52,   1128,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00e851, 0x007499, 0x007499,  52,   1129,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00ec8e, 0x00766d, 0x00766d,  52,   1130,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00f108, 0x00646e, 0x00646e,  57,   1131,  31,  32 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x01d911, 0x01538e, 0x01538e,  23,   1135,  13,  23 }, /* VINF_EM_RAW_TO_R3 */
    { 0x0176e0, 0x016f3f, 0x016f3f,  21,   1136,  21,  21 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x013ac9, 0x00d5ec, 0x00d5ec,  33,   1137,  25,  33 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x016097, 0x0138ee, 0x0138ee,  25,   1138,  22,  25 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x01ab08, 0x00c3b5, 0x00c3b5,  36,   1139,  17,  36 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x018d62, 0x01a2ea, 0x01a2ea,  18,   1150,  19,  18 }, /* VINF_EM_PENDING_REQUEST */
    { 0x01460d, 0x01034a, 0x01034a,  29,   1151,  24,  29 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x0166b1, 0x010367, 0x010367,  29,   1152,  22,  29 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x01b70a, 0x00474e, 0x00474e,  69,   1155,  16,  32 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x013218, 0x0117cd, 0x0117cd,  27,   1157,  25,  27 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x012af0, 0x00b806, 0x00b806,  37,   1159,  26,  37 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x0115e7, 0x00b2d8, 0x00b2d8,  38,   1160,  27,  38 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x012c42, 0x0058df, 0x0058df,  60,   1161,  26,  60 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x01687f, 0x001e15, 0x001e15, 112,   1162,  22,  33 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01d11e, 0x00edc4, 0x00edc4,  31,   1202,  14,  31 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x01cba6, 0x00d757, 0x00d757,  33,   1205,  14,  33 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x01c3d0, 0x00c807, 0x00c807,  35,   1206,  15,  35 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x01e0ec, 0x01ebb4, 0x01ebb4,  10,   1207,  12,  10 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x01d03e, 0x01c197, 0x01c197,  15,   1209,  14,  15 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x016cde, 0x002489, 0x002489, 108,   1211,  21,  18 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x013182, 0x001bd8, 0x001bd8, 118,   1212,  25,  22 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01ea24, 0x003ee8, 0x003ee8,  75,   1224,  10,  75 }, /* VINF_DBGF_BP_HALT */
    { 0x01888e, 0x008118, 0x008118,  48,   1239,  20,  48 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x0160ef, 0x008681, 0x008681,  47,   1400,  22,  47 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x01a0ce, 0x01d420, 0x01d420,  14,   1404,  18,  14 }, /* VWRN_PATCH_ENABLED */
    { 0x019e46, 0x01c79f, 0x01c79f,  15,   1407,  18,  15 }, /* VWRN_PATCH_REMOVED */
    { 0x0192ba, 0x00d9ca, 0x00d9ca,  33,   1408,  19,  33 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x018a7e, 0x00d736, 0x00d736,  33,   1409,  19,  33 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x01b4fa, 0x00d0ce, 0x00d0ce,  34,   1410,  16,  34 }, /* VINF_PATM_PATCH_INT3 */
    { 0x0164f9, 0x00d568, 0x00d568,  33,   1411,  22,  33 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x014cfc, 0x00db14, 0x00db14,  33,   1412,  24,  33 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x0179cb, 0x01262a, 0x01262a,  26,   1413,  20,  26 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x0167a3, 0x00f236, 0x00f236,  30,   1414,  22,  30 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x0174be, 0x0104fd, 0x0104fd,  29,   1415,  21,  29 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x011004, 0x00ac2f, 0x00ac2f,  39,   1416,  28,  39 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x016bcd, 0x01454d, 0x01454d,  24,   1427,  21,  24 }, /* VWRN_PATCH_END_BRANCH */
    { 0x01bf19, 0x017ff7, 0x017ff7,  20,   1429,  16,  20 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x01c5fb, 0x00beca, 0x00beca,  36,   1430,  15,  36 }, /* VINF_PATCH_CONTINUE */
    { 0x014da1, 0x01d014, 0x01d014,  14,   1500,  23,  14 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x010228, 0x01bb1a, 0x01bb1a,  16,   1501,  29,  16 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01acc2, 0x01cc40, 0x01cc40,  14,   1502,  17,  14 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x01798f, 0x00a02d, 0x00a02d,  41,   1503,  20,  41 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01eec0, 0x0128ce, 0x0128ce,  26,   1613,  10,  26 }, /* VINF_PGM_SYNC_CR3 */
    { 0x017233, 0x00d715, 0x00d715,  33,   1614,  21,  33 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x0135e7, 0x007ce7, 0x007ce7,  49,   1615,  25,  49 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x01850a, 0x0013e2, 0x0013e2, 138,   1616,  20,  31 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x01d9ee, 0x01265e, 0x01265e,  26,   1622,  13,  26 }, /* VINF_PGM_CACHED_PAGE */
    { 0x01bbca, 0x001708, 0x001708, 129,   1623,  16, 129 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x015332, 0x0011b2, 0x0011b2, 144,   1625,  23,  23 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x015c77, 0x00b2b2, 0x00b2b2,  38,   1635,  22,  38 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x01a39e, 0x010990, 0x010990,  28,   1643,  18,  28 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x017ae3, 0x00aaf0, 0x00aaf0,  40,   1644,  20,  40 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x01ac5c, 0x00de5a, 0x00de5a,  32,   1758,  17,  32 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x019d14, 0x00d778, 0x00d778,  33,   1759,  18,  33 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x015097, 0x008913, 0x008913,  47,   1766,  23,  47 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x016ffc, 0x00cc67, 0x00cc67,  35,   1769,  21,  35 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x012b0a, 0x018bd4, 0x018bd4,  19,   1851,  26,  19 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00f218, 0x00773a, 0x00773a,  51,   1852,  30,  51 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x0186c2, 0x00c942, 0x00c942,  35,   1854,  20,  35 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x0192f3, 0x005ab8, 0x005ab8,  59,   1864,  19,  59 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x01ba4a, 0x0116da, 0x0116da,  27,   2008,  16,  27 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x01b1ab, 0x008418, 0x008418,  48,   2009,  17,  48 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x0137a9, 0x00e47a, 0x00e47a,  32,   2010,  25,  32 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x018443, 0x00d398, 0x00d398,  34,   2011,  20,  34 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x01674b, 0x006f71, 0x006f71,  54,   2012,  22,  54 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x0196f5, 0x01051a, 0x01051a,  29,   2013,  19,  29 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x01d3cc, 0x00c0e6, 0x00c0e6,  36,   2503,  14,  36 }, /* VINF_SELM_SYNC_GDT */
    { 0x01be7a, 0x01338f, 0x01338f,  25,   2615,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x01b58a, 0x013d08, 0x013d08,  25,   2616,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x0196e2, 0x017494, 0x017494,  21,   2620,  19,  21 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x0182b3, 0x016551, 0x016551,  22,   2621,  20,  22 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x011d7f, 0x001602, 0x001602, 131,   2622,  27,  30 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x0188a2, 0x01d2ec, 0x01d2ec,  14,   2623,  14,  14 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x01c808, 0x01c763, 0x01c763,  15,   2624,  15,  15 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x0188a2, 0x01814b, 0x01814b,  20,   2625,  20,  20 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x015fe7, 0x001883, 0x001883, 125,   2626,  22,  23 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x01b9ba, 0x00f2ae, 0x00f2ae,  30,   2712,  16,  30 }, /* VINF_VMM_CALL_TRACER */
    { 0x01b4ba, 0x016cc9, 0x016cc9,  21,   2714,  16,  21 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01f0a7, 0x014535, 0x014535,  24,   2824,   9,  24 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x013583, 0x008328, 0x008328,  48,   2846,  25,  48 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x011d64, 0x01b2dd, 0x01b2dd,  17,   2898,  27,  17 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x01770a, 0x00c6a9, 0x00c6a9,  35,   2901,  21,  35 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x0195eb, 0x009eb4, 0x009eb4,  42,   2903,  19,  42 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x01b90a, 0x01c628, 0x01c628,  15,   2906,  16,  15 }, /* VINF_HGCM_SAVE_STATE */
    { 0x017806, 0x0117e8, 0x0117e8,  27,   3209,  21,  27 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x01847f, 0x0065c1, 0x0065c1,  56,   3283,  20,  56 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x014f11, 0x0103db, 0x0103db,  29,   3501,  23,  29 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x0101d1, 0x004520, 0x004520,  70,   3746,  29,  70 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00fa2e, 0x010afc, 0x010afc,  28,   3827,  30,  28 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x01dabe, 0x00eebc, 0x00eebc,  31,   3901,  13,  31 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x01b5ca, 0x009a46, 0x009a46,  42,   3902,  16,  42 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x01dc90, 0x0073fd, 0x0073fd,  52,   3903,  12,  52 }, /* VINF_GVM_YIELDED */
    { 0x01e45f, 0x010920, 0x010920,  28,   4033,  11,  28 }, /* VINF_VMX_VMEXIT */
    { 0x0168c1, 0x005991, 0x005991,  59,   4035,  22,  59 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x015f0b, 0x00387b, 0x00387b,  82,   4036,  22,  82 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x016869, 0x006351, 0x006351,  57,   4037,  22,  57 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01e713, 0x00d589, 0x00d589,  33,   4067,  11,  33 }, /* VINF_SVM_VMEXIT */
    { 0x01ed6c, 0x004c9d, 0x004c9d,  66,   4068,  10,  66 }, /* VINF_SVM_VMRUN */
    { 0x016735, 0x005af3, 0x005af3,  59,   4069,  22,  59 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x01baba, 0x007e6f, 0x007e6f,  49,   4117,  16,  49 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x01baea, 0x00adb5, 0x00adb5,  39,   4118,  16,  39 }, /* VINF_HM_PENDING_XCPT */
    { 0x01771f, 0x01a03e, 0x01a03e,  18,   4400,  21,  18 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x01adf3, 0x00725b, 0x00725b,  53,   4500,  17,  53 }, /* VINF_VHWA_CMD_PENDING */
    { 0x01a7e9, 0x005a7d, 0x005a7d,  59,   4800,  17,  59 }, /* VINF_AIO_TASK_PENDING */
    { 0x01b2aa, 0x0037d6, 0x0037d6,  83,   5150,  17,  83 }, /* VINF_PCI_MAPPING_DONE */
    { 0x01ceb6, 0x001ef4, 0x001ef4, 111,   5305,  14,  72 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x019cf0, 0x004138, 0x004138,  73,   5306,  18,  52 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x01b2ee, 0x008567, 0x008567,  47,   5310,  14,  47 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x01b2ee, 0x0071bc, 0x0071bc,  53,   5311,  17,  53 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x012a06, 0x003dba, 0x003dba,  76,   5312,  26,  76 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x01d67a, 0x009c14, 0x009c14,  42,   5313,  13,  42 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x01a3c2, 0x00b7bc, 0x00b7bc,  37,   5319,  18,  37 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x016a68, 0x01620d, 0x01620d,  22,   5401,  21,  22 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x01725d, 0x0154d0, 0x0154d0,  23,   5402,  21,  23 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x01aaa2, 0x01de58, 0x01de58,  12,   5406,  17,  12 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x01e194, 0x0143e5, 0x0143e5,  24,   5699,  12,  24 }, /* VINF_SUP_DRIVERLESS */
    { 0x00e8cd, 0x00aa78, 0x00aa78,  40,   6220,  31,  40 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x01aa3c, 0x00a26b, 0x00a26b,  41,   6316,  17,  41 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x013489, 0x006b31, 0x006b31,  55,   6317,  25,  55 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x012678, 0x003783, 0x003783,  83,   6605,  26,  19 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00ea41, 0x0019f8, 0x0019f8, 121,   6609,  31, 121 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x01d1fe, 0x0114f0, 0x0114f0,  28,   6810,  14,  28 }, /* VINF_NEM_FLUSH_TLB */
    { 0x0148f5, 0x0094e7, 0x0094e7,  44,   6906,  24,  32 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x0183df, 0x002041, 0x002041, 111,   6907,  20,  37 }, /* VINF_RECORDING_THROTTLED */
    { 0x00f0ca, 0x0031c6, 0x0031c6,  90,   6908,  31,  17 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x01bd2a, 0x0047d8, 0x0047d8,  69,   7200,  16,  69 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00e11a, 0x006150, 0x006150,  57,   7311,  32,  57 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x01478d, 0x00516a, 0x00516a,  63,   7600,  12,  63 }, /* VINF_GCM_HANDLED */
    { 0x01478d, 0x006cb2, 0x006cb2,  55,   7601,  24,  55 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x01dba8, 0x0077a0, 0x0077a0,  51,  22301,  13,  51 }, /* VINF_LOG_DISABLED */
    { 0x01e31f, 0x01af25, 0x01af25,  17,  22302,  12,  17 }, /* VINF_LOG_NO_LOGGER */
    { 0x01a9d6, 0x01ad6c, 0x01ad6c,  17,  22401,  17,  17 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x0193ea, 0x00b28c, 0x00b28c,  38,  22405,  19,  38 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00cb2c, 0x009095, 0x009095,  45,  22406,  35,  45 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01c1b5, 0x01e5c9, 0x01e5c9,  11,  22409,  15,  11 }, /* VWRN_WRONG_TYPE */
    { 0x015f21, 0x0038cd, 0x0038cd,  82,  22424,  22,  82 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x01805b, 0x011fd1, 0x011fd1,  27,  22426,  20,  27 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x019378, 0x0130a0, 0x0130a0,  26,  22427,  19,  26 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x01d3a2, 0x01ae37, 0x01ae37,  17,  22428,  14,  17 }, /* VINF_REBOOT_NEEDED */
    { 0x019901, 0x004e67, 0x004e67,  65,  22501,  18,  65 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01e587, 0x01192c, 0x01192c,  27,  22821,  11,  27 }, /* VINF_ASN1_MORE_DATA */
    { 0x01ebbe, 0x0035de, 0x0035de,  85,  22822,  10,  85 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01d34e, 0x005f84, 0x005f84,  58,  22900,  14,  58 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x00fefc, 0x00df9a, 0x00df9a,  32,  23109,  29,  32 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x019294, 0x01bb3a, 0x01bb3a,  16,  23814,  19,  16 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x018dae, 0x01a086, 0x01a086,  18,  24202,  19,  18 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x017b5b, 0x018b75, 0x018b75,  19,  24203,  20,  19 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x01058e, 0x01111c, 0x01111c,  28,  24204,  29,  28 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x014a45, 0x007535, 0x007535,  52,  25007,  24,  52 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00e9a6, 0x01c089, 0x01c089,  15,  25704,  31,  15 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this. @remarks It might seem odd at first that this has lower priority than VINF_EM_HALT, VINF_EM_SUSPEND, and VINF_EM_RESUME. The reason is that these events are vital to correctly operating the VM. Also, they can\'t normally occur together with an out-of-memory condition, and even if that should happen the condition will be rediscovered before executing any more code." */
    '\xff','\x89','w','e','\'','v','e',' ','g','o','t',' ','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',' ','\x2a','\x89','w','e',' ','n','e','e','d',' ','\x08','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x08','d','e','a','l',' ','\x1c','t','h','i','s','.',' ','@','r','e','m','a','r','k','s',' ','I','t',' ','m','i','g','h','t',' ','s','e','e','m',' ','o','d','d',' ','a','t',' ','f','i','r','s','t',' ','\x89','\xcb','\x1d','l','o','w','e','r',' ','p','r','i','o','r','i','t','y',' ','t','h','a','n',' ','\x1a','E','M','_','H','A','L','T',',',' ','\x1a','E','M','_','S','U','S','P','E','N','D',',',' ','\x2a','\x1a','E','M','_','R','E','S','U','M','E','.',' ','\x03','r','e','a','s','o','n',' ','\x09','\x89','t','h','e','s','e',' ','e','v','e','n','t','s',' ','a','r','e',' ','v','i','t','a','l',' ','\x08','c','o','r','r','e','c','t','l','y',' ','o','p','e','r','a','t','i','n','g',' ','\x02','V','M','.',' ','A','l','s','o',',',' ','t','h','e','y',' ','c','a','n','\'','t',' ','n','o','r','m','a','l','l','y',' ','o','c','c','u','r',' ','t','o','g','e','t','h','e','r',' ','\x1c','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',',',' ','\x2a','e','v','e','n',' ','i','f',' ','\x89','\xef','h','a','p','p','e','n',' ','\x02','c','o','n','d','i','t','i','o','n',' ','w','i','l','l',' ','\x8f','r','e','d','i','s','c','o','v','e','r','e','d',' ','b','e','f','o','r','e',' ','e','x','e','c','u','t','i','n','g',' ','a','n','y',' ','\xfc','\x5e',
/* 0x00170 = "Conflict between the core memory and the intermediate paging context, try again. There are some very special conditions applying to the intermediate paging context (used during the world switches), and some times we continuously run into these when asking the host kernel for memory during VM init. Let us know if you run into this and we\'ll adjust the code so it tries harder to avoid it." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x5c','\x2a','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',' ','T','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','v','e','r','y',' ','s','p','e','c','i','a','l',' ','c','o','n','d','i','t','i','o','n','s',' ','a','p','p','l','y','i','n','g',' ','\x08','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',' ','(','u','s','e','d',' ','d','u','r','i','n','g',' ','\x02','w','o','r','l','d',' ','s','w','i','t','c','h','e','s',')',',',' ','\x2a','s','o','m','e',' ','t','i','m','e','s',' ','w','e',' ','c','o','n','t','i','n','u','o','u','s','l','y',' ','r','u','n',' ','i','n','t','o',' ','t','h','e','s','e',' ','\xf3','a','s','k','i','n','g',' ','\x02','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0e','\x5c','d','u','r','i','n','g',' ','\xd0',' ','i','n','i','t','.',' ','L','e','t',' ','u','s',' ','k','n','o','w',' ','i','f',' ','y','o','u',' ','r','u','n',' ','i','n','t','o',' ','\xcb','\x2a','w','e','\'','l','l',' ','a','d','j','u','s','t',' ','\x02','c','o','d','e',' ','s','o',' ','i','t',' ','t','r','i','e','s',' ','h','a','r','d','e','r',' ','\x08','a','v','o','i','d',' ','i','t','.',
/* 0x002be = "Indicating that we should reschedule to recompiled execution. Typically caused by the main execution engine not being capable of executing code in the current CPU state, or would be doing it too slowly, and we must fall back to recompiled execution. @remarks Important to have a higher priority (lower number) than the other rescheduling status codes." */
    '\xff','\x89','w','e',' ','\xef','r','e','s','c','h','e','d','u','l','e',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\x05','\xdc','c','a','p','a','b','l','e',' ','\x14','e','x','e','c','u','t','i','n','g',' ','c','o','d','e',' ','\x0d','\x02','\xd5','C','P','U',' ','s','t','a','t','e',',',' ','\x86','w','o','u','l','d',' ','\x8f','d','o','i','n','g',' ','i','t',' ','\x8d','s','l','o','w','l','y',',',' ','\x2a','w','e',' ','m','u','s','t',' ','f','a','l','l',' ','b','a','c','k',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','@','r','e','m','a','r','k','s',' ','I','m','p','o','r','t','a','n','t',' ','\x08','\xed','a',' ','h','i','g','h','e','r',' ','p','r','i','o','r','i','t','y',' ','(','l','o','w','e','r',' ','n','u','m','b','e','r',')',' ','t','h','a','n',' ','\x02','o','t','h','e','r',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x003d7 = "Indicating that we should reschedule to the main execution engine. Mainly triggered in recompiled execution mode to switch back to the main execution engine when the CPU state is compatible with it again (or we\'re past the expensive portion of code that is deemed faster to recompile)." */
    '\xff','\x89','w','e',' ','\xef','r','e','s','c','h','e','d','u','l','e',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',' ','M','a','i','n','l','y',' ','t','r','i','g','g','e','r','e','d',' ','\x0d','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','\x08','s','w','i','t','c','h',' ','b','a','c','k',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xf3','\x02','C','P','U',' ','\xae','\x09','c','o','m','p','a','t','i','b','l','e',' ','\x1c','i','t',' ','a','g','a','i','n',' ','(','o','r',' ','w','e','\'','r','e',' ','p','a','s','t',' ','\x02','e','x','p','e','n','s','i','v','e',' ','p','o','r','t','i','o','n',' ','\x14','c','o','d','e',' ','\x89','\x09','d','e','e','m','e','d',' ','f','a','s','t','e','r',' ','\x08','r','e','c','o','m','p','i','l','e',')','.',
/* 0x004b3 = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process. (You will only see this message if you got potentially fatally buggy anti-virus software installed.)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','\xe3','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x5c','\x0e','a',' ','c','h','u','n','k',' ','\x14','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\x89','s','h','o','u','l','d','n','\'','t',' ','\x8f','p','r','e','s','e','n','t',' ','\x0d','o','u','r',' ','p','r','o','c','e','s','s','.',' ','(','Y','o','u',' ','w','i','l','l',' ','\xfd','s','e','e',' ','\xcb','m','e','s','s','a','g','e',' ','i','f',' ','y','o','u',' ','g','o','t',' ','p','o','t','e','n','t','i','a','l','l','y',' ','f','a','t','a','l','l','y',' ','b','u','g','g','y',' ','a','n','t','i','-','v','i','r','u','s',' ','s','o','f','t','w','a','r','e',' ','i','n','s','t','a','l','l','e','d','.',')','.',
/* 0x00588 = "The VMMR0.r0 module version does not match VBoxVMM.dll/so/dylib. If you just upgraded VirtualBox, please terminate all VMs and make sure that neither VBoxNetDHCP nor VBoxNetNAT is running. Then try again. If this error persists, try re-installing VirtualBox." */
    '\x03','V','M','M','R','0','.','r','0',' ','m','o','d','u','l','e',' ','\xb5','\x9e','\x05','\xe4','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','I','f',' ','y','o','u',' ','j','u','s','t',' ','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',',',' ','p','l','e','a','s','e',' ','t','e','r','m','i','n','a','t','e',' ','a','l','l',' ','V','M','s',' ','\x2a','m','a','k','e',' ','s','u','r','e',' ','\x89','n','e','i','t','h','e','r',' ','V','B','o','x','N','e','t','D','H','C','P',' ','n','o','r',' ','V','B','o','x','N','e','t','N','A','T',' ','\x09','r','u','n','n','i','n','g','.',' ','T','h','e','n',' ','t','r','y',' ','a','g','a','i','n','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00656 = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes. http://www.symantec.com/connect/articles/creating-application-control-exclusions-symantec-endpoint-protection-121." */
    '\x17','\x0c','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\x8f','d','i','s','a','b','l','e','d',' ','\x0e','\x02','\xe3','B','o','x',' ','\xd0',' ','p','r','o','c','e','s','s','e','s','.',' ','h','t','t','p',':','/','/','w','w','w','.','s','y','m','a','n','t','e','c','.','c','o','m','/','c','o','n','n','e','c','t','/','a','r','t','i','c','l','e','s','/','c','r','e','a','t','i','n','g','-','a','p','p','l','i','c','a','t','i','o','n','-','c','o','n','t','r','o','l','-','e','x','c','l','u','s','i','o','n','s','-','s','y','m','a','n','t','e','c','-','e','n','d','p','o','i','n','t','-','p','r','o','t','e','c','t','i','o','n','-','1','2','1','.',
/* 0x0070b = "The USB device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','i','n','s','t','a','n','c','e',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x007b4 = "The USB device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','h','e','l','p','e','r',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x0085b = "Not possible to attach further drivers to the driver. A driver which doesn't support attachments (below of course) will return this status code if it found that further drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','r','i','v','e','r','.',' ','A',' ','\xa9','\xc1','\xa6','\xb2','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x14','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xcb','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x8f','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x00901 = "The driver instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa9','i','n','s','t','a','n','c','e',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x009a6 = "The device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00a4b = "The PCI bus assigned to a device didn\'t have room for it. Either too many devices are configured on the same PCI bus, or there are some internal problem where PDM/PCI doesn't free up slots when unplugging devices." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x08','a',' ','\x8b','d','i','d','n','\'','t',' ','\xed','r','o','o','m',' ','\x0e','i','t','.',' ','E','i','t','h','e','r',' ','\x8d','\xa4','d','e','v','i','c','e','s',' ','a','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','o','n',' ','\x02','s','a','m','e',' ','P','C','I',' ','b','u','s',',',' ','\x86','t','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','\x13','p','r','o','b','l','e','m',' ','w','h','e','r','e',' ','P','D','M','/','P','C','I',' ','\xa6','f','r','e','e',' ','u','p',' ','s','l','o','t','s',' ','\xf3','u','n','p','l','u','g','g','i','n','g',' ','d','e','v','i','c','e','s','.',
/* 0x00aef = "The device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','h','e','l','p','e','r',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00b92 = "The driver helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa9','h','e','l','p','e','r',' ','\xc2','\xb5','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00c35 = "Invalid VM request type. For the VMR3ReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','\xd0',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','V','M','R','3','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00cd8 = "Invalid RT request type. For the RTReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','R','T',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','R','T','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00d7a = "Generic USB device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','U','S','B',' ','\x8b','\xc2','\xb5','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00e1a = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code. The interrupt needed to be handled by the host OS and hypervisor execution must be resumed. VM state is not complete at this point." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x8f','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S',' ','\x2a','h','y','p','e','r','v','i','s','o','r',' ','e','x','e','c','u','t','i','o','n',' ','m','u','s','t',' ','\x8f','r','e','s','u','m','e','d','.',' ','\xd0',' ','\xae','\x09','\x05','c','o','m','p','l','e','t','e',' ','a','t',' ','\xcb','p','o','i','n','t','.',
/* 0x00eb8 = "Generic driver structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\xa9','\xc2','\xb5','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00f54 = "Generic device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\x8b','\xc2','\xb5','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xed','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xed','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xcb','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe3','B','o','x','.',
/* 0x00ff0 = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user. TCB is also called \'Act as part of the operating system\'." */
    '\x17','\x9e','\x05','\xed','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x82','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','T','C','B',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','A','c','t',' ','a','s',' ','p','a','r','t',' ','\x14','\x02','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m','\'','.',
/* 0x01087 = "Not possible to attach drivers to the device. A device which doesn't support attachments (below of course) will return this status code if it found that drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','e','v','i','c','e','.',' ','A',' ','\x8b','\xc1','\xa6','\xb2','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x14','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xcb','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x8f','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x0111d = "The CPUID instruction returns different information when loading than when saved. Normally caused by hardware changes on the host, but could also be caused by changes in the BIOS setup." */
    '\x03','C','P','U','I','D',' ','\xbb','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\xf3','l','o','a','d','i','n','g',' ','t','h','a','n',' ','\xf3','s','a','v','e','d','.',' ','N','o','r','m','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','h','a','r','d','w','a','r','e',' ','c','h','a','n','g','e','s',' ','o','n',' ','\x02','h','o','s','t',',',' ','b','u','t',' ','c','o','u','l','d',' ','a','l','s','o',' ','\x8f','c','a','u','s','e','d',' ','\xb9','c','h','a','n','g','e','s',' ','\x0d','\x02','B','I','O','S',' ','s','e','t','u','p','.',
/* 0x011b2 = "SyncPage modified the PDE. This is an internal status code used to communicate back to the #PF handler that the PDE was (probably) marked not-present and it should restart the instruction." */
    'S','y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',' ','T','h','i','s',' ','\x09','\x60','\x13','s','t','a','t','u','s',' ','c','o','d','e',' ','u','s','e','d',' ','\x08','c','o','m','m','u','n','i','c','a','t','e',' ','b','a','c','k',' ','\x08','\x02','#','P','F',' ','h','a','n','d','l','e','r',' ','\x89','\x02','P','D','E',' ','\x10','(','p','r','o','b','a','b','l','y',')',' ','m','a','r','k','e','d',' ','n','o','t','-','p','r','e','s','e','n','t',' ','\x2a','i','t',' ','\xef','r','e','s','t','a','r','t',' ','\x02','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x01242 = "The VirtualBox version is not supported by one of the extension packs.
You have probably upgraded VirtualBox recently. Please upgrade the extension packs to versions compatible with this VirtualBox release." */
    '\x03','\xe3','B','o','x',' ','\xb5','\x09','\x05','\xf2','\xb9','o','n','e',' ','\x14','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.','\x0a','Y','o','u',' ','\xed','p','r','o','b','a','b','l','y',' ','u','p','g','r','a','d','e','d',' ','\xe3','B','o','x',' ','r','e','c','e','n','t','l','y','.',' ','P','l','e','a','s','e',' ','u','p','g','r','a','d','e',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s',' ','\x08','v','e','r','s','i','o','n','s',' ','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\xcb','\xe3','B','o','x',' ','r','e','l','e','a','s','e','.',
/* 0x012ce = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xcb','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01358 = "The state doesn't match the VM configuration in one or another way. (There are certain PCI reconfiguration which the OS could potentially do which can cause this problem. Check this out when it happens.)." */
    '\x03','\xae','\xa6','\xe4','\x02','\xd0',' ','\xea','\x0d','o','n','e',' ','\x86','a','n','o','t','h','e','r',' ','w','a','y','.',' ','(','T','h','e','r','e',' ','a','r','e',' ','c','e','r','t','a','i','n',' ','P','C','I',' ','r','e','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xc1','\x02','O','S',' ','c','o','u','l','d',' ','p','o','t','e','n','t','i','a','l','l','y',' ','d','o',' ','\xc1','c','a','n',' ','c','a','u','s','e',' ','\xcb','p','r','o','b','l','e','m','.',' ','C','h','e','c','k',' ','\xcb','o','u','t',' ','\xf3','i','t',' ','h','a','p','p','e','n','s','.',')','.',
/* 0x013e2 = "Go ahead with the default Read/Write operation. This is returned by a R3 physical or virtual handler when it wants the PGMPhys[Read|Write] routine do the reading/writing." */
    'G','o',' ','a','h','e','a','d',' ','\x1c','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xcf',' ','T','h','i','s',' ','\x09','r','e','t','u','r','n','e','d',' ','\xb9','a',' ','R','3',' ','p','h','y','s','i','c','a','l',' ','\x86','v','i','r','t','u','a','l',' ','h','a','n','d','l','e','r',' ','\xf3','i','t',' ','w','a','n','t','s',' ','\x02','P','G','M','P','h','y','s','[','R','e','a','d','|','W','r','i','t','e',']',' ','r','o','u','t','i','n','e',' ','d','o',' ','\x02','r','e','a','d','i','n','g','/','w','r','i','t','i','n','g','.',
/* 0x0146c = "Host backend couldn\'t be initialized. Happen if the audio server is not reachable, audio hardware is not available or similar. We should use the NULL audio driver." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\x8f','i','n','i','t','i','a','l','i','z','e','d','.',' ','H','a','p','p','e','n',' ','i','f',' ','\x02','a','u','d','i','o',' ','s','e','r','v','e','r',' ','\x09','\x05','r','e','a','c','h','a','b','l','e',',',' ','a','u','d','i','o',' ','h','a','r','d','w','a','r','e',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','s','i','m','i','l','a','r','.',' ','W','e',' ','\xef','u','s','e',' ','\x02','N','U','L','L',' ','a','u','d','i','o',' ','d','r','i','v','e','r','.',
/* 0x014f5 = "Stream could not be created. This might due to missing host (backend) drivers or a host not having the required hardware, or that the requested stream configuration is not supported by the host backend." */
    'S','t','r','e','a','m',' ','c','o','u','l','d',' ','\x05','\x8f','c','r','e','a','t','e','d','.',' ','T','h','i','s',' ','m','i','g','h','t',' ','d','u','e',' ','\x08','m','i','s','s','i','n','g',' ','h','o','s','t',' ','(','b','a','c','k','e','n','d',')',' ','d','r','i','v','e','r','s',' ','\x86','a',' ','h','o','s','t',' ','\x05','h','a','v','i','n','g',' ','\x02','r','e','q','u','i','r','e','d',' ','h','a','r','d','w','a','r','e',',',' ','\x86','\x89','\x02','\xc0','s','t','r','e','a','m',' ','\xea','\x09','\x05','\xf2','\xb9','\x02','h','o','s','t',' ','b','a','c','k','e','n','d','.',
/* 0x0157e = "The VMMRC.rc module version does not match VBoxVMM.dll/so/dylib. Re-install if you are a user. Developers should make sure the build is complete or try with a clean build." */
    '\x03','V','M','M','R','C','.','r','c',' ','m','o','d','u','l','e',' ','\xb5','\x9e','\x05','\xe4','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','R','e','-','i','n','s','t','a','l','l',' ','i','f',' ','y','o','u',' ','a','r','e',' ','a',' ','u','s','e','r','.',' ','D','e','v','e','l','o','p','e','r','s',' ','\xef','m','a','k','e',' ','s','u','r','e',' ','\x02','b','u','i','l','d',' ','\x09','c','o','m','p','l','e','t','e',' ','\x86','t','r','y',' ','\x1c','a',' ','c','l','e','a','n',' ','b','u','i','l','d','.',
/* 0x01602 = "Reason for leaving RZ: Pending I/O port write. Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xcb','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xcb','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x1a','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01685 = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x17','\x0c','\x12','I','m','a','g','e',' ','\xe1','\x09','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x2a','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','\xc8','\x10','u','n','m','a','p','p','e','d',' ','\x86','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x01708 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xb9','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xf3','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\x8f','u','p','d','a','t','e','d',' ','\x1e','\x02','\xa1','\xab','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xb9','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x01789 = "The MMIO range specified for removal was invalid. The range didn\'t match quite match a set of existing ranges. It\'s not possible to remove parts of a MMIO range, only one or more full ranges." */
    '\x03','\xf9',' ','\xe5','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','i','n','v','a','l','i','d','.',' ','\x03','\xe5','d','i','d','n','\'','t',' ','\xe4','q','u','i','t','e',' ','\xe4','a',' ','s','e','t',' ','\x14','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','s','.',' ','I','t','\'','s',' ','\x05','p','o','s','s','i','b','l','e',' ','\x08','r','e','m','o','v','e',' ','p','a','r','t','s',' ','\x14','a',' ','\xf9',' ','r','a','n','g','e',',',' ','\xfd','o','n','e',' ','\x86','\xfc','f','u','l','l',' ','r','a','n','g','e','s','.',
/* 0x01806 = "The service was disabled on the host. Returned by pfnInit in VBoxService to indicated a non-fatal error that should results in the particular service being disabled." */
    '\x03','s','e','r','v','i','c','e',' ','\x10','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','p','f','n','I','n','i','t',' ','\x0d','V','B','o','x','S','e','r','v','i','c','e',' ','\x08','i','n','d','i','c','a','t','e','d',' ','a',' ','n','o','n','-','f','a','t','a','l',' ','\x07','\x89','\xef','r','e','s','u','l','t','s',' ','\x0d','\x02','p','a','r','t','i','c','u','l','a','r',' ','s','e','r','v','i','c','e',' ','\xdc','d','i','s','a','b','l','e','d','.',
/* 0x01883 = "Reason for leaving RZ: Pending MMIO write.  Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xf9',' ','w','r','i','t','e','.',' ',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xcb','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xcb','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x1a','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01900 = "The physical handler range has no corresponding RAM range. If this is MMIO, see todo above the return. If not MMIO, then it\'s someone else\'s fault..." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\xe5','\x1d','\xeb','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',' ','I','f',' ','\xcb','\x09','M','M','I','O',',',' ','s','e','e',' ','t','o','d','o',' ','a','b','o','v','e',' ','\x02','r','e','t','u','r','n','.',' ','I','f',' ','\x05','M','M','I','O',',',' ','t','h','e','n',' ','i','t','\'','s',' ','s','o','m','e','o','n','e',' ','e','l','s','e','\'','s',' ','f','a','u','l','t','.','.','.',
/* 0x0197c = "Address conflict within a module/segment. Attempted to add a segment, symbol or line number that fully or partially overlaps with an existing one." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','e','g','m','e','n','t',',',' ','s','y','m','b','o','l',' ','\x86','l','i','n','e',' ','\xde','\x89','f','u','l','l','y',' ','\x86','p','a','r','t','i','a','l','l','y',' ','o','v','e','r','l','a','p','s',' ','\x1c','\x60','e','x','i','s','t','i','n','g',' ','o','n','e','.',
/* 0x019f8 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xd1','\x0e','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x14','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x01a71 = "Hypervisor code was stepped. EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x10','s','t','e','p','p','e','d','.',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xcb','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01ae9 = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xac','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xcb','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01b61 = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user. APT is also called \'Replace a process level token\'." */
    '\x17','\x9e','\x05','\xed','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','A','P','T',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','R','e','p','l','a','c','e',' ','a',' ','\x82','l','e','v','e','l',' ','t','o','k','e','n','\'','.',
/* 0x01bd8 = "The value was zero extended to fit. For queries this means that the register is narrower than the queried value. For setters this means that the value is narrower than the register." */
    '\x03','\xd1','\x10','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xcb','m','e','a','n','s',' ','\x89','\x02','\xbd','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd2',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xcb','m','e','a','n','s',' ','\x89','\x02','\xd1','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x01c4e = "The version of the USB device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb5','\x14','\x02','U','S','B',' ','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xcb','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x01cc1 = "Failed while setting up a redirector rule. There probably is a conflict between the rule and some existing service on the computer." */
    '\x80','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',' ','T','h','e','r','e',' ','p','r','o','b','a','b','l','y',' ','\x09','a',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','r','u','l','e',' ','\x2a','s','o','m','e',' ','e','x','i','s','t','i','n','g',' ','s','e','r','v','i','c','e',' ','o','n',' ','\x02','c','o','m','p','u','t','e','r','.',
/* 0x01d33 = "The specified I/O port range intruded on an existing range. There is a I/O port conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe5','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','I','/','O',' ','p','o','r','t',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbd','\x02','s','a','m','e',' ','\xe5','t','w','i','c','e','.',
/* 0x01da4 = "Reading from the image was not possible because the offset is out of the image range. This usually indicates that there is a minor corruption in the image meta data." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x1b','\x10','\x05','p','o','s','s','i','b','l','e',' ','\x1e','\x02','o','f','f','s','e','t',' ','\x09','o','u','t',' ','\x14','\x02','\x1b','r','a','n','g','e','.',' ','T','h','i','s',' ','u','s','u','a','l','l','y',' ','i','n','d','i','c','a','t','e','s',' ','\x89','t','h','e','r','e',' ','\x09','a',' ','m','i','n','o','r',' ','c','o','r','r','u','p','t','i','o','n',' ','\x0d','\x02','\x1b','m','e','t','a',' ','d','a','t','a','.',
/* 0x01e15 = "Emulate split-lock access on SMP. This is also used for dealing with locked alignment conflicts with the host in general from IEM." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',' ','T','h','i','s',' ','\x09','a','l','s','o',' ','u','s','e','d',' ','\x0e','d','e','a','l','i','n','g',' ','\x1c','l','o','c','k','e','d',' ','a','l','i','g','n','m','e','n','t',' ','c','o','n','f','l','i','c','t','s',' ','\x1c','\x02','h','o','s','t',' ','\x0d','g','e','n','e','r','a','l',' ','f','r','o','m',' ','I','E','M','.',
/* 0x01e85 = "The version of the driver registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb5','\x14','\x02','\xa9','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xcb','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x01ef4 = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW). This is not used outside the instruction implementations." */
    '\x06','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',' ','T','h','i','s',' ','\x09','\x05','u','s','e','d',' ','o','u','t','s','i','d','e',' ','\x02','\xbb','i','m','p','l','e','m','e','n','t','a','t','i','o','n','s','.',
/* 0x01f63 = "The version of the device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb5','\x14','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xcb','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x01fd2 = "Invalid RT request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','R','T',' ','\x94','\xfb',' ','\x03','\xae','\x14','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xb0','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x02041 = "Recording has been throttled due to current settings. This e.g. can happen when submitting more video frames than the current FPS setting allows." */
    'R','e','c','o','r','d','i','n','g',' ','\x1d','\xaf','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x08','\xd5','s','e','t','t','i','n','g','s','.',' ','T','h','i','s',' ','e','.','g','.',' ','c','a','n',' ','h','a','p','p','e','n',' ','\xf3','s','u','b','m','i','t','t','i','n','g',' ','\xfc','v','i','d','e','o',' ','f','r','a','m','e','s',' ','t','h','a','n',' ','\x02','\xd5','F','P','S',' ','s','e','t','t','i','n','g',' ','a','l','l','o','w','s','.',
/* 0x020b0 = "Reason for leaving RC: Guest tried to write to our IDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the idtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd0',' ','w','i','l','l',' ','\x8f','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','i','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x0211e = "There are not enough events available on the host to create the I/O context. This exact meaning is host platform dependent." */
    'T','h','e','r','e',' ','a','r','e',' ','\x05','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x08','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',' ','T','h','i','s',' ','e','x','a','c','t',' ','m','e','a','n','i','n','g',' ','\x09','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','d','e','p','e','n','d','e','n','t','.',
/* 0x0218c = "Reason for leaving RC: Guest tried to write to our GDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the gdtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd0',' ','w','i','l','l',' ','\x8f','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','g','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x021fa = "Invalid VM request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','\xd0',' ','\x94','\xfb',' ','\x03','\xae','\x14','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xb0','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x02268 = "Reason for leaving RC: Guest tried to write to our LDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ldtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd0',' ','w','i','l','l',' ','\x8f','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','l','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x022d6 = "The specified I/O port range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe5','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xfd','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x02343 = "The status field has not been updated yet as the request is still pending completion. Someone queried the iStatus field before the request has been fully processed." */
    '\x03','s','t','a','t','u','s',' ','\xf5','\x1d','\x05','\xaf','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\x94','\x09','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',' ','S','o','m','e','o','n','e',' ','q','u','e','r','i','e','d',' ','\x02','i','S','t','a','t','u','s',' ','\xf5','b','e','f','o','r','e',' ','\x02','\x94','\x1d','\xaf','f','u','l','l','y',' ','p','r','o','c','e','s','s','e','d','.',
/* 0x023b0 = "Reason for leaving RC: Guest tried to write to our TSS - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ltr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd0',' ','w','i','l','l',' ','\x8f','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','l','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x0241d = "Process Verification Failure: Found executable memory allocated in the process. There is only supposed be executable memory associated with image file mappings (DLLs & EXE)." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',' ','T','h','e','r','e',' ','\x09','\xfd','s','u','p','p','o','s','e','d',' ','\x8f','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','s','s','o','c','i','a','t','e','d',' ','\x1c','\x1b','\x18','m','a','p','p','i','n','g','s',' ','(','D','L','L','s',' ','&',' ','E','X','E',')','.',
/* 0x02489 = "The value was truncated to fit. For queries this means that the register is wider than the queried value. For setters this means that the value is wider than the register." */
    '\x03','\xd1','\x10','t','r','u','n','c','a','t','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xcb','m','e','a','n','s',' ','\x89','\x02','\xbd','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd2',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xcb','m','e','a','n','s',' ','\x89','\x02','\xd1','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x024f5 = "No attached driver. The PDMDRVHLP::pfnAttach and PDMDEVHLP::pfnDriverAttach will return this error when no driver was configured to be attached." */
    '\xce','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','\x03','P','D','M','D','R','V','H','L','P',':',':','p','f','n','A','t','t','a','c','h',' ','\x2a','P','D','M','D','E','V','H','L','P',':',':','p','f','n','D','r','i','v','e','r','A','t','t','a','c','h',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xcb','\x07','\xf3','\xeb','\xa9','\x10','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x8f','a','t','t','a','c','h','e','d','.',
/* 0x02561 = "The format of a data unit has changed. A SSM user returns this if it\'s not able to read the format for other reasons than u32Version." */
    '\x03','f','o','r','m','a','t',' ','\x14','a',' ','\x90','u','n','i','t',' ','\x1d','c','h','a','n','g','e','d','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xcb','i','f',' ','i','t','\'','s',' ','\x05','a','b','l','e',' ','\x08','r','e','a','d',' ','\x02','f','o','r','m','a','t',' ','\x0e','o','t','h','e','r',' ','r','e','a','s','o','n','s',' ','t','h','a','n',' ','u','3','2','V','e','r','s','i','o','n','.',
/* 0x025cb = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user. IQ is also called \'Increase quotas\'." */
    '\x17','\x9e','\x05','\xed','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','a',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','I','Q',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','I','n','c','r','e','a','s','e',' ','q','u','o','t','a','s','\'','.',
/* 0x02635 = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xa9','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','\xdc','a','t','t','a','c','h','e','d',',',' ','\x86','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x83','o','n',' ','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x0269e = "The configured driver wasn\'t found. Either the necessary driver modules wasn\'t loaded, the name was misspelled, or it was a misconfiguration." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xa9','w','a','s','n','\'','t',' ','\x7d',' ','E','i','t','h','e','r',' ','\x02','n','e','c','e','s','s','a','r','y',' ','\xa9','m','o','d','u','l','e','s',' ','w','a','s','n','\'','t',' ','l','o','a','d','e','d',',',' ','\x02','\xf8','\x10','m','i','s','s','p','e','l','l','e','d',',',' ','\x86','i','t',' ','\x10','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02705 = "The length of the segment name is out of range. This means it is an empty string or that it is greater or equal to RTDBG_SEGMENT_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','s','e','g','m','e','n','t',' ','\xf8','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc9','\x86','\x89','i','t',' ','\x09','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x0276c = "The driver properties were invalid, and as a consequence construction failed. Caused my unusable media or similar problems." */
    '\x03','\xa9','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x2a','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x24',' ','C','a','u','s','e','d',' ','m','y',' ','u','n','u','s','a','b','l','e',' ','m','e','d','i','a',' ','\x86','s','i','m','i','l','a','r',' ','p','r','o','b','l','e','m','s','.',
/* 0x027d3 = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x2a','N','t','P','r','o','t','e','c','t','\xe3','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','r','i','d',' ','\x14','\x86','p','a','s','s','i','f','y',' ','\x60','n','o','n','-','\x1b','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x0283a = "Too many digest algorithms used by PKCS #7 signed data. This is an internal limitation of the code that aims at saving kernel stack space." */
    '\xee','\xa4','\xc4','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',' ','T','h','i','s',' ','\x09','\x60','\x13','l','i','m','i','t','a','t','i','o','n',' ','\x14','\x02','c','o','d','e',' ','\x89','a','i','m','s',' ','a','t',' ','s','a','v','i','n','g',' ','k','e','r','n','e','l',' ','s','t','a','c','k',' ','s','p','a','c','e','.',
/* 0x028a0 = "Invalid RT request packet. One or more of the RT controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','R','T',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xfc','\x14','\x02','R','T',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02906 = "The specified MMIO range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','\xf9',' ','\xe5','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xfd','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x0296c = "The length of the symbol name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_SYMBOL_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','s','y','m','b','o','l',' ','\xf8','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc9','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x029d2 = "The media geometry hasn\'t been set yet, so it cannot be obtained. The caller should then calculate the geometry from the media size." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xaf','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xba','\x8f','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xef','t','h','e','n',' ','c','a','l','c','u','l','a','t','e',' ','\x02','g','e','o','m','e','t','r','y',' ','f','r','o','m',' ','\x02','m','e','d','i','a',' ','s','i','z','e','.',
/* 0x02a38 = "No available ports on the hub. This error is returned when a device is attempted created and/or attached to a hub which is out of ports." */
    '\xce','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',' ','T','h','i','s',' ','\x07','\x09','r','e','t','u','r','n','e','d',' ','\xf3','a',' ','\x8b','\x09','a','t','t','e','m','p','t','e','d',' ','c','r','e','a','t','e','d',' ','a','n','d','/','o','r',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','h','u','b',' ','\xc1','\x09','o','u','t',' ','\x14','p','o','r','t','s','.',
/* 0x02a9d = "The virtual clock frequency differs too much. The clock source for the virtual time isn\'t reliable or the code have changed." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\x8d','m','u','c','h','.',' ','\x03','c','l','o','c','k',' ','s','o','u','r','c','e',' ','\x0e','\x02','v','i','r','t','u','a','l',' ','t','i','m','e',' ','i','s','n','\'','t',' ','r','e','l','i','a','b','l','e',' ','\x86','\x02','c','o','d','e',' ','\xed','c','h','a','n','g','e','d','.',
/* 0x02b01 = "The native file handle got stale while it was open. Can occur with files on network shares when the server is unresponsive." */
    '\x03','n','a','t','i','v','e',' ','\x18','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x10','o','p','e','n','.',' ','C','a','n',' ','o','c','c','u','r',' ','\x1c','f','i','l','e','s',' ','o','n',' ','n','e','t','w','o','r','k',' ','s','h','a','r','e','s',' ','\xf3','\x02','s','e','r','v','e','r',' ','\x09','u','n','r','e','s','p','o','n','s','i','v','e','.',
/* 0x02b65 = "Invalid VM request packet. One or more of the VM controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','\xd0',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xfc','\x14','\x02','\xd0',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02bc9 = "The specified MMIO range intruded on an existing range. There is a MMIO conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','\xf9',' ','\xe5','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','\xf9',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbd','\x02','s','a','m','e',' ','\xe5','t','w','i','c','e','.',
/* 0x02c2c = "The lock validator detected an existing deadlock. The deadlock was not caused by the current operation, but existed already." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x60','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',' ','\x03','d','e','a','d','l','o','c','k',' ','\x10','\x05','c','a','u','s','e','d',' ','\xb9','\x02','\xd5','o','p','e','r','a','t','i','o','n',',',' ','b','u','t',' ','e','x','i','s','t','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x02c8e = "The below driver doesn't export a interface required by the drive having attached it. Typical misconfiguration problem." */
    '\x03','b','e','l','o','w',' ','\xa9','\xa6','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x02cf0 = "General failure during URB queuing. This will go away when the queueing gets proper status code handling." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',' ','T','h','i','s',' ','w','i','l','l',' ','g','o',' ','a','w','a','y',' ','\xf3','\x02','q','u','e','u','e','i','n','g',' ','g','e','t','s',' ','p','r','o','p','e','r',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','h','a','n','d','l','i','n','g','.',
/* 0x02d52 = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x10','d','e','c','l','i','n','e','d',' ','-',' ','\x8d','\xa4','V','M','s',',',' ','\x8d','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\x8d','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02db4 = "A device encountered an unknown configuration value. This means that the device is potentially misconfigured and the device construction or unit attachment failed because of this." */
    'A',' ','\x8b','\x98','\x60','u','n','k','n','o','w','n',' ','\xea','\xd2',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\x8b','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\x8b','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x86','u','n','i','t',' ','a','t','t','a','c','h','m','e','n','t',' ','\x88','\x1e','\x14','t','h','i','s','.',
/* 0x02e16 = "The caller does not have a reference to the object. This status is used when two threads is caught sharing the same object reference." */
    '\x03','c','a','l','l','e','r',' ','\x9e','\x05','\xed','a',' ','r','e','f','e','r','e','n','c','e',' ','\x08','\x02','o','b','j','e','c','t','.',' ','T','h','i','s',' ','s','t','a','t','u','s',' ','\x09','u','s','e','d',' ','\xf3','t','w','o',' ','t','h','r','e','a','d','s',' ','\x09','c','a','u','g','h','t',' ','s','h','a','r','i','n','g',' ','\x02','s','a','m','e',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x02e77 = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xcc','\x08','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0d','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x08','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x02ed7 = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range. IOMR3IOPortRegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','I','/','O',' ','p','o','r','t',' ','\xe5','d','i','d','n','\'','t',' ','\xed','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','I','O','P','o','r','t','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x8f','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x02f37 = "No PCI Bus is available to register the device with. This is usually a misconfiguration or in rare cases a buggy pci device." */
    '\xce','P','C','I',' ','B','u','s',' ','\x09','a','v','a','i','l','a','b','l','e',' ','\x08','\xbd','\x02','\x8b','w','i','t','h','.',' ','T','h','i','s',' ','\x09','u','s','u','a','l','l','y',' ','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x86','\x0d','r','a','r','e',' ','c','a','s','e','s',' ','a',' ','b','u','g','g','y',' ','p','c','i',' ','d','e','v','i','c','e','.',
/* 0x02f96 = "Reason for leaving RC: A Ring switch was attempted using software interrupt. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xcb','\x0d','R','E','M','.',
/* 0x02ff5 = "The length of the file name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_FILE_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','\x18','\xf8','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc9','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','F','I','L','E','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x03053 = "The specified segment:offset address was invalid. Typically an attempt at addressing outside the segment boundary." */
    '\x03','\x16','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x10','i','n','v','a','l','i','d','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','a','t','t','e','m','p','t',' ','a','t',' ','a','d','d','r','e','s','s','i','n','g',' ','o','u','t','s','i','d','e',' ','\x02','s','e','g','m','e','n','t',' ','b','o','u','n','d','a','r','y','.',
/* 0x030b1 = "Not possible to detach a driver because the above driver/device doesn't support it. The above entity doesn't implement the pfnDetach call." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','d','e','t','a','c','h',' ','a',' ','\xa9','\x1e','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xa6','\xb2','i','t','.',' ','\x03','a','b','o','v','e',' ','e','n','t','i','t','y',' ','\xa6','i','m','p','l','e','m','e','n','t',' ','\x02','p','f','n','D','e','t','a','c','h',' ','c','a','l','l','.',
/* 0x0310e = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xd0',' ','\x82','\x10','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x08','v','b','o','x','d','r','v',' ','\x1e','s','o','m','e','o','n','e',' ','\xed','m','a','n','a','g','e','d',' ','\x08','o','p','e','n',' ','\x02','\x82','\x86','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x1c','\x8d','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x0316b = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC. The trap is generally forwarded to the REM and executed there." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xc1','c','o','u','l','d','n','\'','t',' ','\x8f','h','a','n','d','l','e','d',' ','\x0d','R','C','.',' ','\x03','t','r','a','p',' ','\x09','g','e','n','e','r','a','l','l','y',' ','f','o','r','w','a','r','d','e','d',' ','\x08','\x02','R','E','M',' ','\x2a','e','x','e','c','u','t','e','d',' ','t','h','e','r','e','.',
/* 0x031c6 = "Encoding skipped. Can happen if e.g. a frame is not visible or does not need to be encoded for whatever reason." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',' ','C','a','n',' ','h','a','p','p','e','n',' ','i','f',' ','e','.','g','.',' ','a',' ','f','r','a','m','e',' ','\x09','\x05','v','i','s','i','b','l','e',' ','\x86','\x9e','\x05','n','e','e','d',' ','\x08','\x8f','e','n','c','o','d','e','d',' ','\x0e','w','h','a','t','e','v','e','r',' ','r','e','a','s','o','n','.',
/* 0x03220 = "The above driver doesn't export a interface required by a driver being attached to it. Typical misconfiguration problem." */
    '\x03','a','b','o','v','e',' ','\xa9','\xa6','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','a',' ','\xa9','\xdc','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x03279 = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x8f','s','i','g','n','e','d',' ','\x1c','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x14','\xe3','B','o','x',' ','\x86','o','n','e',' ','\x14','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x032d2 = "A device didn\'t find a required interface with an attached driver. Typical misconfiguration problem." */
    'A',' ','\x8b','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x1c','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x0332a = "The block driver type wasn\'t supported. Misconfiguration of the kind you get when attaching a floppy to an IDE controller." */
    '\x03','b','l','o','c','k',' ','\xa9','\xda','w','a','s','n','\'','t',' ','\x95',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x14','\x02','k','i','n','d',' ','y','o','u',' ','g','e','t',' ','\xf3','a','t','t','a','c','h','i','n','g',' ','a',' ','f','l','o','p','p','y',' ','\x08','\x60','I','D','E',' ','c','o','n','t','r','o','l','l','e','r','.',
/* 0x03381 = "Hit the global allocation limit. If you know there is still sufficient memory available, try raising the limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','\xfa','l','i','m','i','t','.',' ','I','f',' ','y','o','u',' ','k','n','o','w',' ','t','h','e','r','e',' ','\x09','s','t','i','l','l',' ','s','u','f','f','i','c','i','e','n','t',' ','\x5c','a','v','a','i','l','a','b','l','e',',',' ','t','r','y',' ','r','a','i','s','i','n','g',' ','\x02','l','i','m','i','t','.',
/* 0x033d8 = "Syntax error - you hit a debugger feature which isn\'t implemented yet. (Feel free to help implement it.)." */
    '\xe2','\x07','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xc1','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',' ','(','F','e','e','l',' ','f','r','e','e',' ','\x08','h','e','l','p',' ','i','m','p','l','e','m','e','n','t',' ','i','t','.',')','.',
/* 0x0342f = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range. IOMR3MMIORegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','\xf9',' ','\xe5','d','i','d','n','\'','t',' ','\xed','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','M','M','I','O','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x8f','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x03486 = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    '\xff','\x89','\x02','\xd0',' ','\x1d','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xbb','\x2a','\x89','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','\xef','w','a','i','t',' ','\x0e','\x60','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x034dd = "The media translation hasn\'t been set yet, so it cannot be obtained. The caller should then guess the translation." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xaf','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xba','\x8f','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xef','t','h','e','n',' ','g','u','e','s','s',' ','\x02','t','r','a','n','s','l','a','t','i','o','n','.',
/* 0x03534 = "A VM api requiring EMT was called from another thread. Use the VMR3ReqCall() apis to call it!." */
    'A',' ','\xd0',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x10','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',' ','U','s','e',' ','\x02','V','M','R','3','R','e','q','C','a','l','l','(',')',' ','a','p','i','s',' ','\x08','c','a','l','l',' ','i','t','!','.',
/* 0x03589 = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xb9','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xc1','\x9e','\x05','n','e','e','d',' ','\x08','\x8f','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x1e','\x02','c','l','i','e','n','t',' ','\x9e','\x05','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x14','t','h','e','m','.',
/* 0x035de = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','n','o','t','h','i','n','g',' ','\x10','w','r','i','t','t','e','n',' ','\x2a','\x02','\xd9','\xef','\x8f','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x03633 = "The dotted-string representation of an ASN.1 OBJECT IDENTIFIER would be too long for our internal representation." */
    '\x03','d','o','t','t','e','d','-','\xc9','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x14','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','w','o','u','l','d',' ','\x8f','\x8d','l','o','n','g',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x03687 = "The configuration constructor in main failed due to an internal consistency error. Consult the release log of the VM for further details." */
    '\x03','\xea','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','\x60','\x13','c','o','n','s','i','s','t','e','n','c','y',' ','\x7b',' ','C','o','n','s','u','l','t',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x14','\x02','\xd0',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x036db = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x10','\x16','i','t','\'','s',' ','\x05','a','l','l','o','w','e','d',' ','\x08','\xed','a','n','y',' ','i','n','i','t',' ','\x86','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x0372f = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','\xe3','M','e','m','o','r','y',' ','\x88','o','n',' ','a',' ','c','h','u','n','k',' ','\x14','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\xc1','s','h','o','u','l','d','n','\'','t',' ','\x8f','p','r','e','s','e','n','t',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x03783 = "There is more data available. This can happen due to a buffer wraparound of a buffer read/write operation." */
    'T','h','e','r','e',' ','\x09','\xfc','\x90','a','v','a','i','l','a','b','l','e','.',' ','T','h','i','s',' ','c','a','n',' ','h','a','p','p','e','n',' ','d','u','e',' ','\x08','a',' ','b','u','f','f','e','r',' ','w','r','a','p','a','r','o','u','n','d',' ','\x14','a',' ','b','u','f','f','e','r',' ','r','e','a','d','/','w','r','i','t','e',' ','\xcf',
/* 0x037d6 = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','\xe1','h','a','n','d','l','e','r',' ','\x89','t','e','l','l','s',' ','\x02','B','U','S',' ','\x89','i','t',' ','\x1d','d','o','n','e',' ','\x02','\xe1','a','l','r','e','a','d','y','.',
/* 0x03829 = "Duplicate symbol within the module. Attempted to add a symbol which name already exists within the module." */
    'D','u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','y','m','b','o','l',' ','\xc1','\xf8','\x22','e','x','i','s','t','s',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0387b = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x14','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x09','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0d','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x038cd = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xb9','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x08','i','n','d','i','c','a','t','e',' ','\x89','\x02','t','h','r','e','a','d',' ','\x09','(','o','r',' ','\xef','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x0391f = "Indicating that a rescheduling now is required. Typically caused by interrupts having changed the EIP." */
    '\xff','\x89','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x09','r','e','q','u','i','r','e','d','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','i','n','t','e','r','r','u','p','t','s',' ','h','a','v','i','n','g',' ','c','h','a','n','g','e','d',' ','\x02','E','I','P','.',
/* 0x03970 = "Not permitted to open the USB device. The user doesn't have access to the device in the usbfs, check the mount options." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa6','\xed','a','c','c','e','s','s',' ','\x08','\x02','\x8b','\x0d','\x02','u','s','b','f','s',',',' ','c','h','e','c','k',' ','\x02','m','o','u','n','t',' ','o','p','t','i','o','n','s','.',
/* 0x039c1 = "A driver encountered an unknown configuration value. This means that the driver is potentially misconfigured and the driver construction failed because of this." */
    'A',' ','\xa9','\x98','\x60','u','n','k','n','o','w','n',' ','\xea','\xd2',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\xa9','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\xa9','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x88','\x1e','\x14','t','h','i','s','.',
/* 0x03a12 = "Not permitted to open the USB device. The user doesn't have access to the device node, check group memberships." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa6','\xed','a','c','c','e','s','s',' ','\x08','\x02','\x8b','n','o','d','e',',',' ','c','h','e','c','k',' ','g','r','o','u','p',' ','m','e','m','b','e','r','s','h','i','p','s','.',
/* 0x03a63 = "Nested paging not active. PCI passthrough currently works only if nested paging is active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xfd','i','f',' ','n','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x09','a','c','t','i','v','e','.',
/* 0x03ab4 = "The request has been freed, don\'t read the status now. Someone is reading the iStatus field of a freed request packet." */
    '\x03','\x94','\x1d','\xaf','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',' ','S','o','m','e','o','n','e',' ','\x09','r','e','a','d','i','n','g',' ','\x02','i','S','t','a','t','u','s',' ','\xf5','\x14','a',' ','f','r','e','e','d',' ','\x94','p','a','c','k','e','t','.',
/* 0x03b03 = "Reason for leaving RC: A privileged instruction was attempted executed. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xbb','\x10','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xcb','\x0d','R','E','M','.',
/* 0x03b52 = "Reason for leaving RC: Interrupted by external interrupt. The interrupt needed to be handled by the host OS." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x8f','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S','.',
/* 0x03ba0 = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    'I','O','M','M','U',' ','i','n','s','t','a','n','c','e',' ','\xba','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\x86','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x03bee = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xf3','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x03c3c = "The host is not supported. Uninstall the extension pack. Returned by the VBOXEXTPACKREG::pfnInstalled." */
    '\x03','h','o','s','t',' ','\x09','\x05','\x95',' ','U','n','i','n','s','t','a','l','l',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','\x02','V','B','O','X','E','X','T','P','A','C','K','R','E','G',':',':','p','f','n','I','n','s','t','a','l','l','e','d','.',
/* 0x03c89 = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\xeb','t','e','r','m','i','n','a','t','i','n','g',' ','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xb7','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x14','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x03cd6 = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\xa5',' ','\x91','\xfd','\x1d','a',' ','s','i','n','g','l','e',' ','\x1f','\x2a','i','t',' ','\x09','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x08','\x8f','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x18','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x03d22 = "A component value of an ASN.1 OBJECT IDENTIFIER is too big for our internal representation (32-bits)." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xd1','\x14','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x09','\x8d','b','i','g',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','(','3','2','-','b','i','t','s',')','.',
/* 0x03d6e = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x0e','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\x89','w','e',' ','w','i','s','h',' ','\x08','O','R',' ','\x1c','\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R',' ','\x2a','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',
/* 0x03dba = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x2a','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x03e06 = "The device is not a registered PCI device and thus cannot perform any PCI operations. The device forgot to register it self." */
    '\x03','\x8b','\x09','\x05','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\x8b','\x2a','t','h','u','s',' ','\xba','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',' ','\x03','\x8b','f','o','r','g','o','t',' ','\x08','\xbd','i','t',' ','s','e','l','f','.',
/* 0x03e52 = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xd3','e','x','t','e','n','s','i','o','n',' ','\xb7','\x0d','\x02','\xfe','\xb3',' ','i','n','d','i','c','a','t','e','s',' ','\xfc','e','n','t','r','i','e','s',' ','\xf3','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','b','o','o','t',' ','\xd3','s','e','c','t','o','r','.',
/* 0x03e9d = "VT-x/AMD-V not active. PCI passthrough currently works only if VT-x/AMD-V is active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xfd','i','f',' ','V','T','-','x','/','A','M','D','-','V',' ','\x09','a','c','t','i','v','e','.',
/* 0x03ee8 = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xb9','a',' ','\xac','c','a','l','l','b','a','c','k',' ','\xf3','\xa1','e','x','e','c','u','t','i','o','n',' ','\xef','\x8f','s','u','s','p','e','n','d','e','d',' ','\x2a','\x02','\xd0',' ','\xef','\x8f','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x03f33 = "The release call only release a semaphore nesting, i.e. the caller is still holding the semaphore." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','\xfd','r','e','l','e','a','s','e',' ','a',' ','\xec','n','e','s','t','i','n','g',',',' ','i','.','e','.',' ','\x02','c','a','l','l','e','r',' ','\x09','s','t','i','l','l',' ','h','o','l','d','i','n','g',' ','\x02','s','e','m','a','p','h','o','r','e','.',
/* 0x03f7d = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x88','\x08','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x14','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x03fc7 = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf5','\x10','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xc1','\xcb','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\x9e','\x05','s','u','p','p','o','r','t','.',
/* 0x04011 = "Warning, the state changed. This is a generic error message and needs a context to make sense." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xae','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x0405b = "The configuration constructor in main failed due to a COM error. Check the release log of the VM for further details." */
    '\x03','\xea','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','a',' ','C','O','M',' ','\x7b',' ','C','h','e','c','k',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x14','\x02','\xd0',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x040a5 = "One of the custom modes was incorrect. The format or bit count of the custom mode value is invalid." */
    'O','n','e',' ','\x14','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x10','i','n','c','o','r','r','e','c','t','.',' ','\x03','f','o','r','m','a','t',' ','\x86','b','i','t',' ','c','o','u','n','t',' ','\x14','\x02','c','u','s','t','o','m',' ','m','o','d','e',' ','\xd1','\x09','i','n','v','a','l','i','d','.',
/* 0x040ef = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc1','\x09','r','e','s','e','r','v','e','d',' ','\x0e','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\x86','0','x','f','f','f','e',')','.',
/* 0x04138 = "Returns by rep-prefixed string instruction if they yield because of pending FFs. The status code is internal to IEM." */
    'R','e','t','u','r','n','s',' ','\xb9','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xc9','\xbb','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x1e','\x14','p','e','n','d','i','n','g',' ','F','F','s','.',' ','\x03','s','t','a','t','u','s',' ','c','o','d','e',' ','\x09','\x13','\x08','I','E','M','.',
/* 0x04181 = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x05','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xb9','\x02','\xd0',' ','p','r','o','c','e','s','s','.',
/* 0x041ca = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','\xe5','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x08','H','C',' ','p','t','r',' ','\x05','s','a','f','e','.',
/* 0x04212 = "Attempted socket operation with a non-socket handle. (This includes closed handles.)." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x83','\x1c','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',' ','(','T','h','i','s',' ','i','n','c','l','u','d','e','s',' ','c','l','o','s','e','d',' ','h','a','n','d','l','e','s','.',')','.',
/* 0x0425a = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xd3','e','x','t','e','n','s','i','o','n',' ','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x10','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0d','\x02','p','r','e','v','i','o','u','s',' ','\xb7','\x86','\x1d','\x60','\x81','\xa2','I','D','.',
/* 0x042a2 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xa7','\x02','s','i','g','n','e','d',' ','\x90','\xd9','\x08','\x8f','\x02','\x8e','I','D',' ','\x14','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x042ea = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    '\xff','\x89','a',' ','\xac','\x10','h','i','t',' ','\x2a','\x89','E','M',' ','\xef','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x2a','\x0d','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x09','\xeb','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x04332 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\x8d','c','o','m','p','l','e','x',' ','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x04379 = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x14','e','l','e','m','e','n','t','s',' ','\x0d','\x02','X','A','R',' ','\x18','\x9e','\x05','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x08','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x60','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x043c0 = "Indicating that EM should single step an instruction. The instruction is stepped in the current execution mode (RAW/REM)." */
    '\xff','\x89','E','M',' ','\xef','s','i','n','g','l','e',' ','s','t','e','p',' ','\x60','i','n','s','t','r','u','c','t','i','o','n','.',' ','\x03','\xbb','\x09','s','t','e','p','p','e','d',' ','\x0d','\x02','\xd5','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','(','R','A','W','/','R','E','M',')','.',
/* 0x04407 = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x10','f','o','u','n','d',' ','\x08','\x8f','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x0e','d','e','t','a','i','l','s','.',
/* 0x0444e = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','\xed','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x04494 = "Reason for leaving RC: A Ring switch was attempted. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xcb','\x0d','R','E','M','.',
/* 0x044da = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x09','t','o','a','s','t','e','d',' ','\x2a','\x02','V','M','M',' ','\xef','\x8f','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','\xeb','n','e','e','d',' ','\x08','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x04520 = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x04566 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xf3','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x14','\x02','b','o','o','t',' ','\xd3','s','e','c','o','t','r','.',
/* 0x045ac = "The device doesn't support runtime driver attaching. The PDMDEVREG::pfnAttach callback function is NULL." */
    '\x03','\x8b','\xa6','\xb2','r','u','n','t','i','m','e',' ','\xa9','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','E','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x045f2 = "The NotBefore and NotAfter values of an X.509 Validity object seems to have been swapped around." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x2a','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x14','\x60','X','.','5','0','9',' ','V','a','l','i','d','i','t','y',' ','\x8e','s','e','e','m','s',' ','\x08','\xed','\xaf','s','w','a','p','p','e','d',' ','a','r','o','u','n','d','.',
/* 0x04638 = "The driver doesn't support runtime driver attaching. The PDMDRVREG::pfnAttach callback function is NULL." */
    '\x03','\xa9','\xa6','\xb2','r','u','n','t','i','m','e',' ','\xa9','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','R','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x0467e = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1b','\x09','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xc6','c','a','n',' ','\xfd','d','e','a','l',' ','\x1c','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x046c4 = "RamPreAlloc not set. RAM pre-allocation is currently a requirement for PCI passthrough." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x05','s','e','t','.',' ','R','A','M',' ','p','r','e','-','\xfa','\x09','c','u','r','r','e','n','t','l','y',' ','a',' ','r','e','q','u','i','r','e','m','e','n','t',' ','\x0e','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h','.',
/* 0x04709 = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xd0',' ','c','o','n','f','i','g','.',
/* 0x0474e = "Reason for leaving RC: A triple-fault condition. Currently, causes a guru meditation." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',' ','C','u','r','r','e','n','t','l','y',',',' ','c','a','u','s','e','s',' ','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x04793 = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xea','h','a','d',' ','\x60','u','n','k','n','o','w','n',' ','\xd2',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x047d8 = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xb9','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x08','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x0481d = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1c','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x04862 = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x8f','c','a','n','c','e','l','e','d',' ','\x86','p','r','e','p','a','r','e','d',' ','\x0e','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x1e','i','t',' ','\x09','s','t','i','l','l',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x048a6 = "Invalid GC physical range. Usually used when a specified range crosses a RAM region boundary." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',' ','U','s','u','a','l','l','y',' ','u','s','e','d',' ','\xf3','a',' ','\x16','\xe5','c','r','o','s','s','e','s',' ','a',' ','R','A','M',' ','r','e','g','i','o','n',' ','b','o','u','n','d','a','r','y','.',
/* 0x048ea = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xb1','\xb3',' ','\x7f','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x19','r','e','c','o','r','d',' ','\x89','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x0492e = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc4','a','t','t','r','i','b','u','t','e','.',
/* 0x04972 = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xa6','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x08','c','o','m','m','i','t',' ','\x86','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x049b6 = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct. Use the extended API." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','\xf5','f','e','d',' ','\x08','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\x86','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',' ','U','s','e',' ','\x02','e','x','t','e','n','d','e','d',' ','A','P','I','.',
/* 0x049fa = "The selected platform architecture is not supported. Depends on the context (host / VM)." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x09','\x05','\x95',' ','D','e','p','e','n','d','s',' ','o','n',' ','\x02','c','o','n','t','e','x','t',' ','(','h','o','s','t',' ','/',' ','V','M',')','.',
/* 0x04a3e = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','\xdc','r','e','a','d',' ','\x10','\x05','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x2a','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x08','s','i','z','e','.',
/* 0x04a82 = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x1c','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x04ac6 = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\x89','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x8f','u','s','e','d','.',
/* 0x04b0a = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e','.',
/* 0x04b4e = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\xa5',' ','\x91','\x1f','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xbc','n','e','e','d','s',' ','\x08','\x8f','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x18','s','y','s','t','e','m',' ','\x86','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x04b91 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\x8f','d','e','s','t','r','o','y','e','d',' ','\x1e','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x04bd4 = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',',',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x04c17 = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1b','\x09','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xc6','c','a','n',' ','\xfd','d','e','a','l',' ','\x1c','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x04c5a = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x88','\x1c','\x60','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xf3','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x18','a','p','p','r','o','a','c','h','.',
/* 0x04c9d = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x08','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x04cdf = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xad','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xf3','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd0',' ','p','r','o','c','e','s','s','.',
/* 0x04d21 = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\x8f','e','x','a','c','t','l','y',' ','o','n','e',' ','\xc4','\xbf','\x08','g','o',' ','\x1c','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xb7','r','e','q','u','i','r','e','d',' ','\xb9','S','P','C','.',
/* 0x04d63 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x80','\x08','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xb7','\xc1','p','o','i','n','t','s',' ','\x08','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x04da4 = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\x8f','s','u','b','m','i','t','t','e','d',' ','\x1e','\x89','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x14','\x02','c','o','n','t','e','x','t','.',
/* 0x04de5 = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04e26 = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\x8b','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x5c','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x04e67 = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x10','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x04ea8 = "The state changed. This is a generic error message and needs a context to make sense." */
    '\x03','\xae','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x04ee9 = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x09','\x05','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x1c','\xcb','a','l','l','o','c','a','t','i','o','n','.',
/* 0x04f2a = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xb9','\xeb','D','E','K','-','I','n','f','o',' ','\xf5','\x1c','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x10','\x7d',
/* 0x04f6a = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x1c','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x04faa = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x08','\x8f','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x04fea = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xbf','\x0d','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\x8a','p','a','r','t',' ','\x9e','\x05','\xe4','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1c','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0502a = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xb1','\xb3',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','\xbe','s','p','a','c','e',' ','s','i','z','e','s',' ','\x14','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0506a = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x0e','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','\xed','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x050aa = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x10','\x98','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x14','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x050ea = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xfd','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x0512a = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    '\xff','\x89','\x02','\xd0',' ','\x09','\xdc','t','u','r','n','e','d',' ','o','f','f',' ','\x2a','\x89','\x02','E','M',' ','\xef','e','x','i','t',' ','\x08','\x02','\xd0',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x0516a = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x10','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x051a9 = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x0e','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x08','f','i','n','i','s','h','.',
/* 0x051e8 = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xc4','\xbf','\x0d','\x02','i','n','d','i','r','e','c','t',' ','\x90','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x14','\xc4','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','\x90','s','t','r','u','c','t','u','r','e','.',
/* 0x05227 = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x05266 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x09','\xeb','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x0e','s','t','o','r','i','n','g',' ','\x02','\xd5','t','h','r','e','a','d','.',
/* 0x052a5 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x08','\x8f','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x052e4 = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x05323 = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xb1','\xb3',' ','\x7f','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x19','r','e','c','o','r','d',' ','\x1c','a',' ','\xdf','\x89','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x05361 = "Preemption is disabled. The requested operation can only be performed when preemption is enabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x09','d','i','s','a','b','l','e','d','.',' ','\x03','\xc0','\x83','c','a','n',' ','\xfd','\x8f','p','e','r','f','o','r','m','e','d',' ','\xf3','p','r','e','e','m','p','t','i','o','n',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x0539f = "Too many write or write/read recursions on read/write critical section." */
    '\xee','\xa4','w','r','i','t','e',' ','\x86','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x053dd = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x0541b = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xce','R','T','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1c','\x02','\xd5','\xd0',' ','\x2a','t','h','u','s',' ','\x02','R','T','C',' ','\x86','C','M','O','S',' ','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d','.',
/* 0x05459 = "The \'Type\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xea','h','a','d',' ','\x60','u','n','k','n','o','w','n',' ','\xd2',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x05497 = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x82','\x05','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xba','\x8f','r','e','v','a','l','i','d','a','t','e','d',' ','\xf3','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd0',' ','p','r','o','c','e','s','s','.',
/* 0x054d5 = "Process Purification Failure: KERNE32.DLL already mapped into the initial process (suspended)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.','D','L','L',' ','\x22','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','i','n','i','t','i','a','l',' ','\x82','(','s','u','s','p','e','n','d','e','d',')','.',
/* 0x05513 = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x10','c','a','l','l','e','d',' ','\x0d','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x8f','u','s','e','d','.',
/* 0x05551 = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc6','\x98','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc1','h','a','s','n','\'','t',' ','\xaf','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0558f = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xb1','\xb3',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','\xbe','s','e','t',' ','s','i','z','e','s',' ','\x14','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x055cd = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xd3','\x0d','\x02','\xfe','\xb3',' ','\x09','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\x86','i','t',' ','\x09','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xc8','\xa2','e','n','t','r','y','.',
/* 0x0560b = "Was not able to open the support driver. Generic open error used when none of the other ones fit." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','o','p','e','n',' ','\x02','\xb2','d','r','i','v','e','r','.',' ','\x96','o','p','e','n',' ','\x07','u','s','e','d',' ','\xf3','n','o','n','e',' ','\x14','\x02','o','t','h','e','r',' ','o','n','e','s',' ','f','i','t','.',
/* 0x05648 = "No \'Type\' attribute in the DrvBlock configuration. Misconfiguration." */
    '\xce','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x05685 = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xc4','\xbf','\x14','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xb7','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x14','\xc4','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x056c2 = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1e','\x02','\xae','g','r','e','w',' ','\x08','b','i','g','.',
/* 0x056ff = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xa7','\x02','a','r','c','h','i','v','e','d',' ','\x2a','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x90','s','i','z','e','s',' ','\x08','\x8f','\x02','s','a','m','e',' ','\x0e','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x0573b = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0d','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x05777 = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','\xd5','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x057b3 = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    '\xff','\x89','\x02','\xd0',' ','\x1d','\xaf','s','u','s','p','e','n','d','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xef','w','a','i','t',' ','\x0e','\x94','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x08','d','o',' ','n','e','x','t','.',
/* 0x057ef = "Too many components in an ASN.1 OBJECT IDENTIFIER for our internal representation." */
    '\xee','\xa4','c','o','m','p','o','n','e','n','t','s',' ','\x0d','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0582b = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x10','s','t','u','c','k',' ','\x0d','\x60','u','n','s','t','a','b','l','e',' ','\xae','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x2a','r','e','t','u','r','n','e','d','.',
/* 0x05867 = "Unsupported data unit version. A SSM user returns this if it doesn't know the u32Version." */
    '\x87','\x90','u','n','i','t',' ','v','e','r','s','i','o','n','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xcb','i','f',' ','i','t',' ','\xa6','k','n','o','w',' ','\x02','u','3','2','V','e','r','s','i','o','n','.',
/* 0x058a3 = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x09','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x058df = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x0e','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x09','h','a','n','d','l','e','d','.',
/* 0x0591b = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1e','\x14','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x05956 = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x08','\xbd','a',' ','R','A','M',' ','\xe5','\x14','\xc1','p','a','r','t','s',' ','a','r','e',' ','\x22','c','o','v','e','r','e','d',' ','\xb9','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x05991 = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xc0','n','e','s','t','e','d','-','\xa1','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x059cc = "Driver name clash. Another driver with the same name as the one being registered exists." */
    'D','r','i','v','e','r',' ','\xf8','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\xa9','\x1c','\x02','s','a','m','e',' ','\xf8','a','s',' ','\x02','o','n','e',' ','\xdc','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05a07 = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x1e','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x05a42 = "Device name clash. Another device with the same name as the one being registered exists." */
    'D','e','v','i','c','e',' ','\xf8','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\x8b','\x1c','\x02','s','a','m','e',' ','\xf8','a','s',' ','\x02','o','n','e',' ','\xdc','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05a7d = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x8f','c','a','l','l','e','d','.',
/* 0x05ab8 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xd0',' ','\x10','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\x86','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x05af3 = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xc0','n','e','s','t','e','d','-','\xa1','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x05b2e = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1e','\x14','\x8d','\xa4','p','a','s','s','e','s','.',
/* 0x05b69 = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x80','\x08','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x05ba4 = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xad','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xf3','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd0',' ','p','r','o','c','e','s','s','.',
/* 0x05bdf = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    '\xff','\x89','\x02','\xd0',' ','\xef','\x8f','s','u','s','p','e','n','d','e','d',' ','\x0e','d','e','b','u','g','g','i','n','g',' ','\x1e','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x08','i','n','s','p','e','c','t',' ','\x02','\xd0',' ','\xfb',
/* 0x05c1a = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','n','a','m','e','s','p','a','c','e',' ','\xc1','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb2','i','t','.',
/* 0x05c55 = "Failed to convert the specified Guest IP to a binary IP address. Malformed input." */
    '\x80','\x08','c','o','n','v','e','r','t',' ','\x02','\x16','G','u','e','s','t',' ','I','P',' ','\x08','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',' ','M','a','l','f','o','r','m','e','d',' ','i','n','p','u','t','.',
/* 0x05c90 = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x2a','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\x8f','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x08','U','U','I','D','.',
/* 0x05ccb = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x0e','\x60','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x05d06 = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xba','\x8f','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x08','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x05d40 = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x1c','\x81','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x05d7a = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x90','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x05db4 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','\x09','\xfc','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x05dee = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc6','\x98','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc1','h','a','s','n','\'','t',' ','\xaf','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x05e28 = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1e','\x14','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x7b',
/* 0x05e62 = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xce','A','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1c','\x02','\xd5','\xd0',' ','\x2a','t','h','u','s',' ','\x02','A','P','I','C',' ','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d','.',
/* 0x05e9c = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbd','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','p','h','y','s','i','c','a','l',' ','\xe5','\x14','\xc1','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x05ed6 = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','\xf5','c','o','n','t','a','i','n','e','d',' ','\x60','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\x89','\xef','\xfd','\x8f','u','s','e','d',' ','\xf3','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x05f10 = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x1d','\x8d','\xa4','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x2a','p','r','o','b','e','s','.',
/* 0x05f4a = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0d','R','i','n','g','-','0',' ','\x86','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x05f84 = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    'I','m','a','g','e',' ','\x0c','W','a','r','n','i','n','g',':',' ','\xce','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x05fbe = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x08','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x05ff8 = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\x8b','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x06032 = "UDF file cannot be import as it has discontiguous allocation descriptors or is a sparse file." */
    'U','D','F',' ','\x18','\xba','\x8f','\xfe','a','s',' ','i','t',' ','\x1d','d','i','s','c','o','n','t','i','g','u','o','u','s',' ','\xfa','d','e','s','c','r','i','p','t','o','r','s',' ','\x86','\x09','a',' ','s','p','a','r','s','e',' ','f','i','l','e','.',
/* 0x0606c = "Failed to initialize a memory object. Exactly what this means is OS specific." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x5c','o','b','j','e','c','t','.',' ','E','x','a','c','t','l','y',' ','w','h','a','t',' ','\xcb','m','e','a','n','s',' ','\x09','O','S',' ','s','p','e','c','i','f','i','c','.',
/* 0x060a5 = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x14','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc4','a','t','t','r','i','b','u','t','e','.',
/* 0x060de = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x14','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x06117 = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xd3','e','x','t','e','n','s','i','o','n',' ','\xb7','\x0d','\x02','\xfe','\xb3',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xc1','w','i','l','l',' ','\x8f','l','o','s','t','.',
/* 0x06150 = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x06189 = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xce','D','M','A','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1c','\x02','\xd5','\xd0',' ','\x2a','t','h','u','s',' ','\x02','D','M','A',' ','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d','.',
/* 0x061c2 = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x08','l','o','a','d',' ','\xfc','\x90','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x061fb = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x06234 = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x14','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e','.',
/* 0x0626d = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbd','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','v','i','r','t','u','a','l',' ','\xe5','\x14','\xc1','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x062a6 = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x10','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\xe3','B','o','x','.',
/* 0x062df = "Internal error: Uninitialized status code. @remarks This is used by value elsewhere." */
    '\x06','\xc5','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x5e',' ','@','r','e','m','a','r','k','s',' ','T','h','i','s',' ','\x09','u','s','e','d',' ','\xb9','\xd1','e','l','s','e','w','h','e','r','e','.',
/* 0x06318 = "Configuration value is unknown. This indicates misconfiguration." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd1','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06351 = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x0638a = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\x9f','\x14','\xd9','X','M','L',' ','\x1f','(','t','o','c',')',' ','\x1d','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xb0','i','t',' ','\x08','\x8f','\x60','\xfd','c','h','i','l','d',' ','\x86','\x02','r','o','o','t',' ','\x1f','(','x','a','r',')','.',
/* 0x063c3 = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\x8f','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x08','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x063fc = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf5','y','i','e','l','d','e','d',' ','a',' ','\xd1','\x8d','l','a','r','g','e',' ','\x0e','\x02','\x13','v','a','r','i','a','b','l','e',' ','\x14','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x06435 = "Was not able to load the support driver. On linux, open returned ENODEV." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','l','o','a','d',' ','\x02','\xb2','d','r','i','v','e','r','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','D','E','V','.',
/* 0x0646e = "Reason for leaving RC: Partly handled GDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x064a7 = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x064e0 = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x18','\x09','\x8d','b','i','g',' ','\x0e','\x02','\xd5','\xb3',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xb3',' ','l','e','v','e','l',' ','3',')','.',
/* 0x06519 = "The specified I/O port range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe5','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x06551 = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xce','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1c','\x02','\xd5','\xd0',' ','\x2a','t','h','u','s',' ','\x02','P','I','C',' ','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d','.',
/* 0x06589 = "There are unconsumed bytes after decoding an ASN.1 object." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x60','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x065c1 = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0d','\x02','\x1b','\x2a','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x065f9 = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xa8','\xbc','\xe6','\x85','m','i','n','i','m','u','m',' ','\xd1','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06631 = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x2a','m','a','j','o','r',' ','\x8b','\xde','\xda','\x09','\x8d','s','m','a','l','l',' ','\x08','h','o','l','d',' ','\x02','\xd1','s','t','o','r','e','d',' ','\x0d','\x02','t','a','r',' ','\xe9',
/* 0x06669 = "Mount failed because a media was already mounted. Unmount the media and retry the mount." */
    'M','o','u','n','t',' ','\x88','\x1e','a',' ','m','e','d','i','a',' ','\x10','\x22','m','o','u','n','t','e','d','.',' ','U','n','m','o','u','n','t',' ','\x02','m','e','d','i','a',' ','\x2a','r','e','t','r','y',' ','\x02','m','o','u','n','t','.',
/* 0x066a1 = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf3','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x5c','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x066d9 = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xa8','\xbc','\xe6','\x85','m','a','x','i','m','u','m',' ','\xd1','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06711 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x0e','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x2a','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x06749 = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x0e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x14','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x06781 = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x08','\x60','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x067b9 = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x10','\x22','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x067f1 = "Indicating success single stepping and that EM should report that event to the debugger." */
    '\xff','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x2a','\x89','E','M',' ','\xef','r','e','p','o','r','t',' ','\x89','e','v','e','n','t',' ','\x08','\x02','d','e','b','u','g','g','e','r','.',
/* 0x06829 = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x17','\x0c','\x12','A','n',' ','u','n','k','n','o','w','n',' ','\x2a','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x06861 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','\xe5','\x16','\x0e','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\x86','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x06899 = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x80','\x08','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x068d1 = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc4','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x06909 = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','S','E','L','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf3','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06941 = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','T','R','P','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf3','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06979 = "Page hash table is too long (covers signature data, i.e. itself)." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9f','\x09','\x8d','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.','e','.',' ','i','t','s','e','l','f',')','.',
/* 0x069b0 = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','p','o','i','n','t','s',' ','\x08','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x14','\x02','\x1b','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x069e7 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xfd','d','e','a','l',' ','\x1c','o','n','e','.',
/* 0x06a1e = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xb1','\xb3',' ','\x7f','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','\xcb','\x09','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x06a55 = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','P','D','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf3','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06a8c = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','I','O','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf3','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06ac3 = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x83','\x10','c','a','n','c','e','l','l','e','d',' ','\xb9','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\x86','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x06afa = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xfd','d','e','a','l',' ','\x1c','o','n','e','.',
/* 0x06b31 = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x06b68 = "The specified string / bytes buffer was to small. Specify a larger one and retry." */
    '\x03','\x16','\xc9','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x10','\x08','s','m','a','l','l','.',' ','S','p','e','c','i','f','y',' ','a',' ','l','a','r','g','e','r',' ','o','n','e',' ','\x2a','r','e','t','r','y','.',
/* 0x06b9f = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x90','u','n','i','t',' ','\x0d','\x02','s','a','v','e','d',' ','\xae','\x18','\x10','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x0e','\x04','i','t','.',
/* 0x06bd6 = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xcc','\x08','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\x86','\xfc','\x14','\x02','a','r','g','u','m','e','n','t','s',' ','\x08','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x82','\x09','\xb0','\x08','u','s','e','.',
/* 0x06c0d = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x1b','r','e','q','u','i','r','e','s',' ','\x08','\x8f','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x06c44 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\x89','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x09','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x06c7b = "Guest tried to trigger a CPU hang. The guest is probably up to no good." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',' ','\x03','\xa1','\x09','p','r','o','b','a','b','l','y',' ','u','p',' ','\x08','\xeb','g','o','o','d','.',
/* 0x06cb2 = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xbb','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x2a','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x06ce9 = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\x86','\x19','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x06d1f = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xfd','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x06d55 = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x17','\x0c','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x14','\x02','\x82','\x9e','\x05','\xe4','\x02','\xd1','\x0d','\x02','o','p','t','i','o','n','a','l',' ','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x06d8b = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x1e','\xeb','n','a','m','e','s','p','a','c','e',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb2','i','t','.',
/* 0x06dc1 = "No active trap. Cannot query or reset a non-existing trap." */
    '\xce','a','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','q','u','e','r','y',' ','\x86','r','e','s','e','t',' ','a',' ','n','o','n','-','e','x','i','s','t','i','n','g',' ','t','r','a','p','.',
/* 0x06df7 = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x10','p','r','e','s','e','n','t','e','d',' ','\x08','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\x89','\x9e','\x05','t','a','k','e',' ','a','n','y','.',
/* 0x06e2d = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xa8','\xbc','\xe6','\x85','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06e63 = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x06e99 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x80','\x08','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x06ecf = "ASN.1 object length goes beyond the end of the byte stream being decoded." */
    'A','S','N','.','1',' ','\x8e','l','e','n','g','t','h',' ','g','o','e','s',' ','b','e','y','o','n','d',' ','\x02','e','n','d',' ','\x14','\x02','b','y','t','e',' ','s','t','r','e','a','m',' ','\xdc','d','e','c','o','d','e','d','.',
/* 0x06f05 = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    '\xff','\x89','\x02','\xd0',' ','\x1d','\xaf','r','e','s','e','t',' ','\x2a','\x89','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x08','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x06f3b = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xa1','G','D','T',' ','s','o',' ','f','u','l','l',' ','\x89','w','e',' ','\xba','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x0e','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x06f71 = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x09','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x06fa7 = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\x89','\x02','\x82','\x9e','\x05','\xed','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x08','p','e','r','f','o','r','m',' ','\x02','\xcf',
/* 0x06fdd = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x08','\x8f','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x07013 = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x05','m','o','n','i','t','o','r','e','d',' ','\xb9','\x02','g','u','e','s','t','.',
/* 0x07049 = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x0707e = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1c','\x02','c','l','i','e','n','t',' ','\x82','c','o','u','l','d',' ','\x05','\x8f','l','o','c','a','t','e','d','.',
/* 0x070b3 = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x82','\x1d','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x14','\x02','f','i','l','e','.',
/* 0x070e8 = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x08','g','r','o','w',' ','a',' ','\x18','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xb9','\x02','\x82','\x86','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x0711d = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xa9','\x09','\x22','r','e','m','o','v','e','d',',',' ','\x05','\xfc','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x07152 = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xbc','\xfd','\x1f','a','t',' ','\x02','e','n','d',' ','\x14','\x02','\xa5',' ','\x91','\x09','\x8d','s','h','o','r','t',' ','\x08','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x07187 = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xc6','r','e','s','o','l','v','e','d',' ','\x60','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x08','\x60','a','d','d','r','e','s','s',' ','\x08','b','i','g',' ','\x0e','\x02','\x1b','f','o','r','m','a','t','.',
/* 0x071bc = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x1e','\x14','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x071f1 = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x07226 = "Internal EM error caused by an unknown warning or informational status code." */
    '\x06','E','M',' ','\x07','c','a','u','s','e','d',' ','\xb9','\x60','u','n','k','n','o','w','n',' ','w','a','r','n','i','n','g',' ','\x86','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x5e',
/* 0x0725b = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x8f','c','a','l','l','e','d','.',
/* 0x07290 = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x80','\x08','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x1e','\x02','\xd5','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0d','\xa1','o','s',' ','m','e','m','o','r','y','.',
/* 0x072c5 = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x08','c','r','e','a','t','e',' ','a',' ','G','C',' ','\xe1','\xc1','c','o','n','f','l','i','c','t','s',' ','\x1c','\x60','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x072f9 = "Host API has not set a valid physical address of host-state area." */
    'H','o','s','t',' ','A','P','I',' ','\x1d','\x05','s','e','t',' ','a',' ','v','a','l','i','d',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','\x14','h','o','s','t','-','\xae','a','r','e','a','.',
/* 0x0732d = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xab','h','a','s','h',' ','\x9f','h','a','s','h','e','s',' ','\x90','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x2a','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x07361 = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','b','u','s','y',' ','(','u','s','e','d',' ','\xb9','s','o','m','e','o','n','e',')','.',
/* 0x07395 = "Reason for leaving RC: Unhandled TSS write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x073c9 = "Active trap. Cannot assert a new trap when one is already active." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','a','s','s','e','r','t',' ','a',' ','n','e','w',' ','t','r','a','p',' ','\xf3','o','n','e',' ','\x09','\x22','a','c','t','i','v','e','.',
/* 0x073fd = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x10','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x07431 = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xc9','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x07465 = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x10','f','o','u','n','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x07499 = "Reason for leaving RC: Unhandled LDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x074cd = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0d','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x07501 = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x1d','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x07535 = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','o','n','e',' ','\x14','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x07569 = "Interface is unknown. This indicates misconfiguration." */
    'I','n','t','e','r','f','a','c','e',' ','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0759d = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x075d1 = "Invalid nested hardware virtualization feature combination." */
    '\x0b','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x07605 = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xab','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x08','M','M','I','O','/','M','M','I','O','2','.',
/* 0x07639 = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x1d','a','r','g','u','m','e','n','t',' ','\x1c','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x0766d = "Reason for leaving RC: Unhandled IDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x076a1 = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xb1','\xb3',' ','s','t','a','r','t','s',' ','\x1c','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xcd','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x076d4 = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x14','t','r','i','e','s',' ','\x08','a','d','d',' ','\x60','i','n','t','3',' ','\xac','\x9f','\x08','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x07707 = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\x95',
/* 0x0773a = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x0e','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x05','\x08','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x0776d = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\x98','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x077a0 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x09','d','i','s','a','b','l','e','d',' ','\x86','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x8f','c','r','e','a','t','e','d','.',
/* 0x077d3 = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf3','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x1c','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x07806 = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07838 = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x08','\x8f','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x0786a = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xa8','\xbc','\xe6','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','s','u','b','j','e','c','t',' ','\x9e','\x05','\xe4','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x0789c = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x08','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\x9e','\x05','e','x','i','s','t','.',
/* 0x078ce = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x14','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x07900 = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0d','\x02','s','u','r','r','o','g','a','t','e',' ','\xe5','(','0','x','d','8','0','0',' ','\x08','0','x','d','f','f','f',')','.',
/* 0x07932 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x09','\x05','u','s','e','d',' ','\x1e','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x07964 = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\x86','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x88','\x1e','\x02','\xa9','\x22','h','a','d',' ','a',' ','\xa9','a','t','t','a','c','h','e','d','.',
/* 0x07996 = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\x8f','i','n','s','e','r','t','e','d',' ','\x1e','o','n','e',' ','\x1c','\x02','s','a','m','e',' ','\xf8','e','x','i','s','t','s','.',
/* 0x079c8 = "The request is for something forbidden. Authorization will not help." */
    '\x03','\x94','\x09','\x0e','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',' ','A','u','t','h','o','r','i','z','a','t','i','o','n',' ','w','i','l','l',' ','\x05','h','e','l','p','.',
/* 0x079fa = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\x8f','i','n','s','e','r','t','e','d',' ','\x1e','o','n','e',' ','\x1c','\x02','s','a','m','e',' ','\xf8','e','x','i','s','t','s','.',
/* 0x07a2c = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x07a5e = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xaf','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07a90 = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1c','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x07ac2 = "Failed to initialize a virtual network interface instance." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x07af4 = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x0e','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x09','s','a','f','e',' ','\x08','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x07b26 = "Saving the VM state is temporarily not allowed. Try again later." */
    'S','a','v','i','n','g',' ','\x02','\xd0',' ','\xae','\x09','t','e','m','p','o','r','a','r','i','l','y',' ','\x05','a','l','l','o','w','e','d','.',' ','T','r','y',' ','a','g','a','i','n',' ','l','a','t','e','r','.',
/* 0x07b58 = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x07b8a = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xaf','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07bbc = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xa8','\xbc','\xe6','H','i','t',' ','\x02','m','a','x',' ','\x8a','\xbc','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x07bee = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xcc','\x08','s','e','a','l',' ','t','e','x','t',' ','\x5c','a','g','a','i','n',' ','\x08','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x07c20 = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x1d','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xc1','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x07c52 = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xa8','\xbc','\xe6','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x07c84 = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\x98','\xfc','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0d','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x07cb6 = "Failed to create or connect to a networking interface filter." */
    '\x80','\x08','c','r','e','a','t','e',' ','\x86','c','o','n','n','e','c','t',' ','\x08','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x07ce7 = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xb9','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x07d18 = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xa8','\xbc','\xe6','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9e','\x05','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\x8a','n','a','m','e','.',
/* 0x07d49 = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x07d7a = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x07dab = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x05','p','e','r','m','i','t','t','e','d',' ','\x0e','\xcb','\xec','t','y','p','e','.',
/* 0x07ddc = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x1b','\x10','c','r','e','a','t','e','d',' ','\x0e','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x07e0d = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xc6','\x98','\x60','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x07e3e = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x09','\x05','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','\xf3','\x25','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x07e6f = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xa1','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x07ea0 = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','\xeb','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x82','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x07ed1 = "Unable to open the host interface due to a sharing violation ." */
    '\xcc','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x08','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x07f02 = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xde','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x07f33 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x14','\x02','\xbb','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x07f64 = "The specified MMIO range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','\xf9',' ','\xe5','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x07f95 = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xaf','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07fc6 = "The iprt loader recognized an a.out image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','\x60','a','.','o','u','t',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x07ff7 = "No trace buffer available, please change the VM config." */
    '\xce','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xd0',' ','c','o','n','f','i','g','.',
/* 0x08028 = "The timer was in a unknown state. Corruption or stupid coding error." */
    '\x03','t','i','m','e','r',' ','\x10','\x0d','a',' ','u','n','k','n','o','w','n',' ','\xfb',' ','C','o','r','r','u','p','t','i','o','n',' ','\x86','s','t','u','p','i','d',' ','c','o','d','i','n','g',' ','\x7b',
/* 0x08058 = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x08088 = "Unimplemented ASN.1 tag reached the RTAsn1DynType code." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','A','S','N','.','1',' ','t','a','g',' ','r','e','a','c','h','e','d',' ','\x02','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x080b8 = "ASN.1 tag and flags/class mismatch in RTAsn1DynType code." */
    'A','S','N','.','1',' ','t','a','g',' ','\x2a','f','l','a','g','s','/','c','l','a','s','s',' ','m','i','s','m','a','t','c','h',' ','\x0d','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x080e8 = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x08','f','r','e','e',' ','\xfc','\x5c','t','h','a','n',' ','w','h','a','t',' ','\x10','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x08118 = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x08','R','i','n','g','-','3','.',
/* 0x08148 = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','\xfc','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x08178 = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x081a8 = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x081d8 = "Internal error: Supposedly unreachable default case in a switch." */
    '\x06','\xc5','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0d','a',' ','s','w','i','t','c','h','.',
/* 0x08208 = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xe2','\x07','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x09','a',' ','s','e','t','-','\xfd','s','y','m','b','o','l','.',
/* 0x08238 = "Reason for leaving RC: jump inside generated patch jump. Fatal error." */
    '\x84','\x0e','\x25','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',' ','F','a','t','a','l',' ','\x7b',
/* 0x08268 = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x08298 = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\x9f','\x14','\xd9','\xdf','\x0d','\x02','\xa2','d','i','d','n','\'','t',' ','\xe4','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x082c8 = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xb7','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','c','o','u','l','d','n','\'','t',' ','\x8f','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x082f8 = "The VM state was invalid for the requested operation. Go check the \'VM Statechart Diagram.gif\'." */
    '\x03','\xd0',' ','\xae','\x10','\x81','\x0e','\x02','\xc0','\xcf',' ','G','o',' ','c','h','e','c','k',' ','\x02','\'','\xd0',' ','S','t','a','t','e','c','h','a','r','t',' ','D','i','a','g','r','a','m','.','g','i','f','\'','.',
/* 0x08328 = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','\xeb','\xa9','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x08358 = "Internal ISO maker error: Inconsistency produing trans.tbl file." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.','t','b','l',' ','f','i','l','e','.',
/* 0x08388 = "Failed to write to a memory region while performing a hypercall." */
    '\x80','\x08','w','r','i','t','e',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x083b8 = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xd0',' ','\x1e','\x05','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','\xed','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x083e8 = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x08418 = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x08','\x8f','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x08448 = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xf9',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x1c','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x08478 = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x17','\x0c','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x14','\x02','\x82','\x9e','\x05','\xe4','\x02','\xd1','\x0d','\x02','\x18','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x084a8 = "Encountered a section type that\'s not known to the loader. (probably invalid)." */
    '\x97','a',' ','\xc8','\xda','t','h','a','t','\'','s',' ','\x05','k','n','o','w','n',' ','\x08','\x02','l','o','a','d','e','r','.',' ','(','p','r','o','b','a','b','l','y',' ','i','n','v','a','l','i','d',')','.',
/* 0x084d8 = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x08508 = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xe2','\x07','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\x94','\x0e','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x08538 = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x83','\x0d','s','i','m','p','l','i','f','i','e','d',' ','\x5c','m','a','n','a','g','e','m','e','n','t',' ','m','o','d','e','.',
/* 0x08567 = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x14','\xd5','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x08596 = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\x97','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc1','\xba','\x8f','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x085c5 = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','w','r','i','t','e',' ','a',' ','\x5c','b','l','o','c','k',' ','\xc1','\x09','\x8d','b','i','g',' ','\x08','e','n','c','o','d','e','.',
/* 0x085f4 = "The support driver is not installed. On linux, open returned ENOENT." */
    '\x03','\xb2','\xa9','\x09','\x05','i','n','s','t','a','l','l','e','d','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','E','N','T','.',
/* 0x08623 = "Failed getting cryptographically strong random bytes." */
    '\x80','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x08652 = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xb1','\xb3',' ','\x7f','a',' ','\x19','\x1c','a',' ','\xfc','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x08681 = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x086b0 = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x086df = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xb9','s','e','g','m','e','n','t',' ','a','s',' ','\xb0','\xb9','\x02','l','o','a','d','e','r','.',
/* 0x0870e = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0873d = "Encountered an unsupported portable archive exchange (pax) header." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','\xe9',
/* 0x0876c = "Failed to read to a memory region while performing a hypercall." */
    '\x80','\x08','r','e','a','d',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x0879b = "Failed to retrieve a virtual network interface link ID." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x087ca = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xf8','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x24',
/* 0x087f9 = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d',' ','\x0e','c','o','m','p','l','e','t','i','n','g',' ','\xa9','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x08828 = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x1d','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xde','\x14','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x08857 = "The support driver is not accessible. On linux, open returned EPERM." */
    '\x03','\xb2','\xa9','\x09','\x05','a','c','c','e','s','s','i','b','l','e','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','P','E','R','M','.',
/* 0x08886 = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xa8','\xbc','\xe6','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','m','a','r','k','e','d',' ','a','s',' ','a',' ','\x8a','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x088b5 = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x088e4 = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\xdf','s','e','t',' ','\x0d','\x02','\xa2','c','o','m','p','a','r','e','d',' ','\x08','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x08913 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\x89','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x08942 = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08971 = "Invalid VMCS pointer. (Can be OR\'ed with VERR_VMX_INVALID_VMCS_FIELD.)." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r','.',' ','(','C','a','n',' ','\x8f','O','R','\'','e','d',' ','\x1c','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',')','.',
/* 0x089a0 = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc6','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa6','\xb2','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x089cf = "No debug module interpreter matching the debug info." */
    '\xce','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x089fe = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x08a2d = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\x9e','\x05','\xb2','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x08a5c = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\x94','\x09','c','u','r','r','e','n','t','l','y',' ','\xdc','s','e','r','v','i','c','e','d','.',
/* 0x08a8a = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x08ab8 = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xd8','\x07','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xa1','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\x9f','u','p','d','a','t','i','n','g','.',
/* 0x08ae6 = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x87','c','r','e','a','t','e',' ','\xda','\x0d','\x60','R','T','V','f','s','O','b','j','O','p','e','n',' ','\x86','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x08b14 = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x60','A','P','I',' ','\xc1','\xba','\x8f','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x08b42 = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xa1','\xab','\x09','a',' ','r','e','s','e','r','v','e','d','/','\xf9',' ','\xab','\x2a','\x9e','\x05','\xed','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x08b70 = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xab','\xe1','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x1c','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x08b9e = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x08bcc = "Failed to create a virtual network interface instance." */
    '\x80','\x08','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x08bfa = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x08c28 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','\xdf','\x14','\x02','o','n','e',' ','\x86','\xfc','r','e','g','i','o','n','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x08c56 = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x09','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x2a','i','t',' ','\x1d','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x08c84 = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x10','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xc0','\x90','c','o','u','l','d',' ','\x8f','r','e','c','e','i','v','e','d','.',
/* 0x08cb2 = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf3','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x08ce0 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xb1','\xb3',' ','\x7f','a',' ','\x19','r','e','c','o','r','d',' ','\x1c','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x08d0e = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xa2','f','i','e','l','d','.',
/* 0x08d3c = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xac','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d',' ','\xb9','o','n','e',' ','\x86','\xfc','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x08d6a = "Invalid context. Typically an API was used by the wrong thread." */
    '\x0b','c','o','n','t','e','x','t','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','A','P','I',' ','\x10','u','s','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x08d98 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0d','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x08dc5 = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc9','\x9f','o','f','f','s','e','t',' ','\x09','b','a','d','.',
/* 0x08df2 = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x08e1f = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x1d','\x05','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x08e4c = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xd3','b','l','o','c','k',' ','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x60','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xa2','I','D','.',
/* 0x08e79 = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xc6','\xa6','k','n','o','w',' ','h','o','w',' ','\x08','d','e','a','l',' ','\x1c','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x90','\x19','\xb7','y','e','t','.',
/* 0x08ea6 = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x1b','\x09','3','2','-','b','i','t',' ','\x2a','\x7f','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\x86','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x08ed3 = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x88','\x08','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x90','\xc1','\x10','r','e','q','u','e','s','t','e','d','.',
/* 0x08f00 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x83','\x10','\x05','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x08f2d = "Image Verification Failure: Error reading authenticode signature data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x08f5a = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1b','\x09','\x05','p','o','s','s','i','b','l','e',' ','\x1e','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x09','\x08','s','e','v','e','r','e','.',
/* 0x08f87 = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xbc','\x09','\x05','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x1c','r','o','o','t',')',',',' ','\xb0','\x60','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x08fb4 = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x08fe1 = "The MMIO handler was called for a bogus address! Internal error!." */
    '\x03','\xf9',' ','h','a','n','d','l','e','r',' ','\x10','c','a','l','l','e','d',' ','\x0e','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',' ','\x06','e','r','r','o','r','!','.',
/* 0x0900e = "Unexpected PCI region change during VGA saved state loading." */
    '\x85','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xae','l','o','a','d','i','n','g','.',
/* 0x0903b = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\x9e','\x05','d','e','c','o','d','e',' ','\x08','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x09068 = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x10','g','i','v','e','n',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x09095 = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x14','\x02','r','e','q','u','e','s','t','.',
/* 0x090c2 = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xab','\x09','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x08','\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x090ef = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\x86','\xfc','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x81','d','u','e',' ','\x08','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','\xdc','s','e','t','.',
/* 0x0911c = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x16','\xf3','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x09','\x22','\x0d','u','s','e','.',
/* 0x09149 = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xd3','v','a','l','i','d','a','t','i','o','n',' ','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x60','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x09176 = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','\xeb','s','e','n','s','e',' ','\x08','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x091a3 = "Error creating an event semaphore for used with asynchronous reads." */
    '\xad','c','r','e','a','t','i','n','g',' ','\x60','e','v','e','n','t',' ','\xec','\x0e','u','s','e','d',' ','\x1c','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x091cf = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xb1','\xb3',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1c','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x091fb = "Failed to open a virtual network interface instance." */
    '\x80','\x08','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x09227 = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x18','\x09','\xdc','u','s','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x09253 = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x10','\x8d','s','m','a','l','l',',',' ','\x86','\x8d','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x0927f = "Error while characters translation (unicode and so)." */
    '\xad','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x2a','s','o',')','.',
/* 0x092ab = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x092d7 = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1e','\x14','a',' ','c','o','n','f','l','i','c','t',' ','\x1c','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x5e',
/* 0x09303 = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x17','\x0c','\x12','\x03','\x5c','p','r','o','t','e','c','t','i','o','n',' ','\x14','a',' ','\x1b','\x18','\xc8','\x9e','\x05','\xe4','w','h','a','t',' ','\x02','\xc8','\xa2','p','r','e','s','c','r','i','b','e','s','.',
/* 0x0932f = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xa1','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x0935b = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x09','\x05','m','o','u','n','t','e','d',',',' ','\x83','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x09387 = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','\xe4','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x093b3 = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x093df = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0940b = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x8f','s','i','g','n','e','d',' ','\x1c','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x14','\xe3','B','o','x','.',
/* 0x09437 = "Couldn\'t find the USB Proxy device. Using OSE?." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',' ','U','s','i','n','g',' ','O','S','E','?','.',
/* 0x09463 = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x08','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x0948f = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x0e','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x094bb = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x09','\x05','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x08','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x094e7 = "Recording limit (time, size, ...) has been reached." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',')',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x09513 = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x0953f = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','\xd0',' ','\xc2','\xa6','\xe4','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x0956a = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xc2','\xdf','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x09595 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x24',
/* 0x095c0 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x24',
/* 0x095eb = "Syntax error - an argument or subargument contains nothing useful." */
    '\xe2','\x07','-',' ','\x60','a','r','g','u','m','e','n','t',' ','\x86','s','u','b','a','r','g','u','m','e','n','t',' ','\x7f','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x09616 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xcc','\x08','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x18','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x09641 = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xc9','c','l','a','i','m','i','n','g',' ','\x08','\x8f','\x0d','U','T','F','-','1','6',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x0966c = "VFS chain element only provides file system stream (fss) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x09697 = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x1d','\xaf','r','e','c','o','r','d','e','d',' ','a','s',' ','\xdc','u','n','s','e','t','.',
/* 0x096c2 = "iSCSI: Invalid header, i.e. dummy for validity check." */
    'i','S','C','S','I',':',' ','\x0b','h','e','a','d','e','r',',',' ','i','.','e','.',' ','d','u','m','m','y',' ','\x0e','v','a','l','i','d','i','t','y',' ','c','h','e','c','k','.',
/* 0x096ed = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xda','e','n','d','e','d',' ','u','p',' ','\x0d','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x09718 = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x7f','\xeb','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x09743 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x0976e = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x60','i','n','d','e','x','.',
/* 0x09799 = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x097c4 = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    'I','m','a','g','e',' ','\x0c','\x12','R','a','w',' ','\x90','o','f','f','s','e','t','s',' ','\x2a','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x097ef = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x14','\x5c','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\x86','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x0981a = "Unknown paritition ID found in the partition map table." */
    '\xd8','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0d','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x09845 = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0d','\x02','s','e','s','s','i','o','n',' ','\x09','t','a','l','k','i','n','g',' ','\x08','\x02','t','r','a','c','e','r','.',
/* 0x09870 = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x88','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x0989b = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x09','\x8d','l','o','n','g',' ','\x0e','\x02','k','e','y',' ','u','s','e','d',' ','\xf3','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x098c6 = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x10','c','a','u','g','h','t','.',
/* 0x098f1 = "Invalid effective segment register number passed to an IEM function." */
    '\x0b','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xbd','\xde','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0991c = "Error extracting a public key from the certificate." */
    '\xad','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x09947 = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\xaa','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x15','I','N','_','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0X09972 = "Someone is trying to skip backwards in the stream..." */
    'o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0d','\x02','s','t','r','e','a','m','.','.','.',
/* 0x0999c = "Normalization of ASN.1 time object didn\'t work out." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x14','A','S','N','.','1',' ','t','i','m','e',' ','\x8e','d','i','d','n','\'','t',' ','w','o','r','k',' ','o','u','t','.',
/* 0x099c7 = "VFS chain element takes a file system stream (fss) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x099f2 = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x09','t','a','r','g','e','t','i','n','g',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x09a1c = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x09a46 = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xa1','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x14','\x02','c','a','l','l','.',
/* 0x09a70 = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x05','k','n','o','w',' ','h','o','w',' ','\x08','h','a','n','d','l','e',' ','\x02','\xd9','\xda','\x0d','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x09a9a = "No pending request the aio context has to wait for completion." */
    '\xce','p','e','n','d','i','n','g',' ','\x94','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x1d','\x08','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x09ac4 = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xc6','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\x9f','\x0e','\x02','i','m','a','g','e','.',
/* 0x09aee = "The ASN.1 encoding is too deeply nested for the decoder." */
    '\x03','A','S','N','.','1',' ','e','n','c','o','d','i','n','g',' ','\x09','\x8d','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','\x0e','\x02','d','e','c','o','d','e','r','.',
/* 0x09b18 = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x09b42 = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x17','\x0c','\x12','\xad','a','l','l','o','c','a','t','i','n','g',' ','\xae','\x5c','\x86','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x09b6c = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x14','\x60','\x13','a','p','p','l','i','c','a','t','i','o','n',' ','\x9e','\x05','\xe4','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x1b','\xbc','\x9a',
/* 0x09b96 = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','\xf8','m','a','p',' ','e','n','t','r','y','.',
/* 0x09bc0 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xcd','\x1d','\x60','z','e','r','o',' ','l','e','n','g','t','h',' ','\x86','\x81','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x09bea = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x05','u','n','d','e','r','s','t','a','n','d',' ','\x02','\x94','d','u','e',' ','\x08','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x09c14 = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0d','\x02','s','a','m','e',' ','T','B','.',
/* 0x09c3e = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\x9e','\x05','\xb2','\x02','\xe5','\x14','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x09c68 = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xd0',' ','\x82','(','2',')','.',
/* 0x09c92 = "Indicating that the VM has been resumed and that the thread should start executing." */
    '\xff','\x89','\x02','\xd0',' ','\x1d','\xaf','r','e','s','u','m','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xef','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x09cbc = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x11','\x80','\x08','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xae','o','n',' ','e','n','d','i','f','.',
/* 0x09ce6 = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x09','\x81','\x86','\x05','\xf2','\xb9','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x09d10 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','\xf8','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xc9','b','l','o','c','k','.',
/* 0x09d3a = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x09d64 = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x09','\x05','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x09d8e = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc9','\x09','\x05','a','c','c','o','r','d','i','n','g',' ','\x08','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x09db8 = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x09de2 = "Unable to find partition descriptor for a partition map table entry." */
    '\xcc','\x08','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xcd','\x0e','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9f','e','n','t','r','y','.',
/* 0x09e0c = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xd0',' ','\x82','(','1',')','.',
/* 0x09e36 = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\x9f','\x14','\xd9','(','T','O','C',')',' ','\x09','\x8d','s','m','a','l','l',' ','\x2a','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\x8f','v','a','l','i','d','.',
/* 0x09e60 = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xa2','\x09','b','a','d',' ','\x86','\x7f','n','e','w',' ','\x2a','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x09e8a = "No line number was found for the specified address/ordinal/whatever." */
    '\xce','l','i','n','e',' ','\xde','\x10','f','o','u','n','d',' ','\x0e','\x02','\x16','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x09eb4 = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0d','b','a','c','k','g','r','o','u','n','d','.',
/* 0x09ede = "NEM is missing a require feature in the host API." */
    'N','E','M',' ','\x09','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0d','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x09f08 = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x14','\x02','\xc0','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0d','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x09f32 = "The specified environment variable was not found. (RTEnvUnsetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','U','n','s','e','t','E','x',')','.',
/* 0x09f5c = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x09f86 = "An unknown config node (key) was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x09fb0 = "Not a uniform standard tape v0.0 archive header." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.','0',' ','a','r','c','h','i','v','e',' ','\xe9',
/* 0x09fda = "Indicating that the VM is being terminated and that the execution shall stop." */
    '\xff','\x89','\x02','\xd0',' ','\x09','\xdc','t','e','r','m','i','n','a','t','e','d',' ','\x2a','\x89','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x0a004 = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','L','D','R','V','I','_','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x0a02d = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x84','\x0e','\x25','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0d','r','i','n','g','-','3','.',
/* 0x0a056 = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','\xdf','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xae','\x2a','\x02','\xd0',' ','c','o','n','f','i','g','.',
/* 0x0a07f = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xb1','\xb3',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xcd','v','e','r','s','i','o','n','.',
/* 0x0a0a8 = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1e','\x14','\x81','V','M','C','S',' ','l','a','u','n','c','h','-','\xfb',
/* 0x0a0d1 = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','S','T','R','I','N','G','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0a0fa = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xab','\x08','\x8f','u','p','d','a','t','e','d',' ','\x86','f','r','e','e','d',' ','\x10','n','o','t','e','d',' ','o','w','n','e','d',' ','\xb9','\x02','c','a','l','l','e','r','.',
/* 0x0a123 = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x10','\x8d','s','m','a','l','l',',',' ','\x86','\x8d','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x0a14c = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x10','m','a','d','e',' ','\x08','g','r','o','w',' ','\x60','\x22','m','a','x','e','d',' ','o','u','t',' ','\xab','p','o','o','l','.',
/* 0x0a175 = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xa9','\xea','\x09','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x0a19e = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xc9','c','l','a','i','m','i','n','g',' ','\x08','\x8f','U','T','F','-','8',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x0a1c7 = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x86','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0a1f0 = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x09','\x05','u','s','e','d',' ','\x1e','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x0a219 = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x09','f','u','l','l',' ','\x2a','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','\xfc','r','e','q','u','e','s','t','s','.',
/* 0x0a242 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc9','\x9f','\x09','\x8d','l','a','r','g','e','.',
/* 0x0a26b = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x0a294 = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','\x18','\x2a','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0a2bd = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x0a2e6 = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x85','\xbb','\x98','\x0e','\xc1','t','h','e','r','e',' ','\x09','\xeb','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x9a',
/* 0x0a30f = "Expected PKCS #7 object to ship at least one certificate." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0a338 = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x0a361 = "Certificate cannot be authenticated with the given CA certificates." */
    '\xa8','\xba','\x8f','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x1c','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0a38a = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x09','\x05','w','i','t','h','i','n',' ','\x02','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0e','n','o','d','e','s','.',
/* 0x0a3b3 = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xbd','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x60','e','r','r','o','r',')','.',
/* 0x0a3dc = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0a405 = "GVMCPU struct size is not compatible with the host page size." */
    'G','V','M','C','P','U',' ','s','t','r','u','c','t',' ','\xdf','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\x02','h','o','s','t',' ','\xab','s','i','z','e','.',
/* 0x0a42e = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\x98','a',' ','\xd1','\xc1','\x10','\x8d','b','i','g',' ','\x0e','\x02','t','a','r','g','e','t','.',
/* 0x0a457 = "Too many readers on read/write critical section." */
    '\xee','\xa4','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0a480 = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','M','I','S','S','I','N','G',
/* 0x0a4a9 = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x0a4d2 = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9e','\x05','\xb2','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0a4fb = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x14','\x02','\xc8','\x0d','\x02','\x1b','\x18','\x09','\x05','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0a524 = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','\x05','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x0a54d = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\x94','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\x8f','c','a','n','c','e','l','e','d','.',
/* 0x0a576 = "No digest algorithms listed in PKCS #7 signed data." */
    '\xce','\xc4','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0d','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x0a59f = "No allocation descriptors for non-zero sized UDF object." */
    '\xce','\xfa','d','e','s','c','r','i','p','t','o','r','s',' ','\x0e','n','o','n','-','z','e','r','o',' ','s','i','z','e','d',' ','U','D','F',' ','o','b','j','e','c','t','.',
/* 0x0a5c8 = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','\xed','\xaf','r','e','a','c','h','e','d','.',
/* 0x0a5f0 = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1e','\x02','L','1',' ','l','o','o','k','u','p',' ','\x9f','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0a618 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xcd','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf4',
/* 0x0a640 = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xdf','\x9e','\x05','\xe4','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0a668 = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x0a690 = "Restart the current instruction. For testing only." */
    'R','e','s','t','a','r','t',' ','\x02','\xd5','i','n','s','t','r','u','c','t','i','o','n','.',' ','F','o','r',' ','t','e','s','t','i','n','g',' ','o','n','l','y','.',
/* 0x0a6b8 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x0a6e0 = "The specified environment variable was not found. (RTEnvGetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','G','e','t','E','x',')','.',
/* 0x0a708 = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xd3','v','a','l','i','d','a','t','i','o','n',' ','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x0a730 = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','V','E','R','S','I','O','N','_','I','N','V','A','L','I','D',
/* 0x0a758 = "Import ISO uses a logical block size other than 2KB." */
    '\xb1','\xb3',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','\xdf','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x0a780 = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1e','i','t',' ','\x10','\x22','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x0a7a8 = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x0a7d0 = "The number being converted (string) contained no digits." */
    '\x03','\xde','\xdc','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','\xeb','d','i','g','i','t','s','.',
/* 0x0a7f8 = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0d','\x02','f','i','l','e','.',
/* 0x0a820 = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\x9e','\x05','\xb2','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x14','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0a848 = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x08','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x0a870 = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x09','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x14','H','y','p','e','r','-','V','.',
/* 0x0a898 = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1e','\x02','L','2',' ','l','o','o','k','u','p',' ','\x9f','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0a8c0 = "UDF file cannot be imported because it has a stream directory." */
    'U','D','F',' ','\x18','\xba','\x8f','i','m','p','o','r','t','e','d',' ','\x1e','i','t',' ','\x1d','a',' ','s','t','r','e','a','m',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0a8e8 = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x2a','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0d','s','e','g','m','e','n','t','.',
/* 0x0a910 = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\x9e','\x05','w','o','r','k',' ','\x1c','\x02','\xd1','\xda','\x14','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xd2',
/* 0x0a938 = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x08','r','e','s','u','m','e',' ','a',' ','\xd0',' ','\x86','C','P','U',' ','\x89','\x09','\x22','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x0a960 = "Too many writes on read/write critical section." */
    '\xee','\xa4','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0a988 = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x13','a','p','p','l','i','c','a','t','i','o','n',' ','\x9e','\x05','r','e','s','i','d','e',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\x9a',
/* 0x0a9b0 = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x0a9d8 = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x11','W','r','o','n','g',' ','j','u','m','p',' ','\xbb','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x14','T','B','.',
/* 0x0aa00 = "Failed to fix mappings because the proposed memory area was to small." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1e','\x02','p','r','o','p','o','s','e','d',' ','\x5c','a','r','e','a',' ','\x10','\x08','s','m','a','l','l','.',
/* 0x0aa28 = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x0aa50 = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\xe7','V','P','_','\x15','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x0aa78 = "A guest control object has changed its overall status." */
    'A',' ','\xa1','c','o','n','t','r','o','l',' ','\x8e','\x1d','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0aaa0 = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xc6','\x98','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0d','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x0aac8 = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x0aaf0 = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x08','r','i','n','g',' ','3','.',
/* 0x0ab18 = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xa2','m','a','g','i','c',' ','\x2a','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\x9e','\x05','m','a','t','c','h','.',
/* 0x0ab40 = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xc0','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0ab68 = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc4','\x14','\x02','e','x','t','r','a','c','t','e','d',' ','\x90','\x9e','\x05','\xe4','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0ab90 = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x1e','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x0abb8 = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xc4','\xbf','\x0d','\x02','S','i','g','n','e','r','I','n','f','o',' ','\x9e','\x05','\xe4','\x02','o','n','e',' ','\x0d','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x0abe0 = "The path of a new node contained slashes or was empty." */
    '\x03','\xbc','\x14','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\x86','\x10','e','m','p','t','y','.',
/* 0x0ac08 = "VFS chain element only provides I/O stream (ios) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0ac2f = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x84','\x0e','\x25','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\x89','s','e','t','s',' ','I','F','.',
/* 0x0ac56 = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x60','\x81','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xd2',
/* 0x0ac7d = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x0aca4 = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e',' ','\x0d','h','a','r','d','w','a','r','e','.',
/* 0x0accb = "Failed to retrieve underlying (lower mac) link." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x0acf2 = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xd0',' ','\xc2','\xb5','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ad19 = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xa2','\xf5','\x10','\x05','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x0ad40 = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xd0',' ','\xc2','\xdf','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ad67 = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x10','c','a','l','l','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x0ad8e = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x8f','d','o','n','e',' ','\x0d','\xd5','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','\xfb',
/* 0x0adb5 = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x0addc = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc4','\x14','\x02','a','r','c','h','i','v','e','d',' ','\x90','\x9e','\x05','\xe4','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0ae03 = "Import ISO contains a \'.\' or \'..\' directory record with a bad name length." */
    '\xb1','\xb3',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x19','r','e','c','o','r','d',' ','\x1c','a',' ','b','a','d',' ','\xf8','l','e','n','g','t','h','.',
/* 0x0ae2a = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x09','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x0ae51 = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x0ae78 = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x0e','\x02','d','y','n','a','m','i','c',' ','\xe1','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x0ae9f = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xba','\x8f','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x1d','\x05','\xaf','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0aec6 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xb9','a',' ','c','a','l','l','b','a','c','k',' ','\x86','s','i','m','i','l','a','r','.',
/* 0x0aeed = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x0af14 = "Internal error in the lock validator or related components." */
    '\x06','\x07','\x0d','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\x86','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x0af3b = "The value is not a zero terminated character string." */
    '\x03','\xd1','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x0af62 = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0af89 = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xc0','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d',' ','\x1e','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x0afb0 = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','\xed','\xaf','r','e','a','c','h','e','d','.',
/* 0x0afd7 = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x09','\xf2','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x0affe = "Too many arguments passed to a VM request / request corruption." */
    '\xee','\xa4','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x08','a',' ','\xd0',' ','\x94','/',' ','\x94','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0b025 = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x0b04c = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x0b073 = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x2a','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xb5','\x8a','2','.',
/* 0x0b09a = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x15','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x0b0c1 = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x8f','s','t','o','p','p','e','d',' ','\x1e','i','t','\'','s',' ','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0b0e8 = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xc6','\xba','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x0b10f = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','\x1e','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x0b136 = "The device wasn\'t found. There was no registered device by that name." */
    '\x03','\x8b','w','a','s','n','\'','t',' ','\x7d',' ','T','h','e','r','e',' ','\x10','\xeb','r','e','g','i','s','t','e','r','e','d',' ','\x8b','\xb9','\x89','n','a','m','e','.',
/* 0x0b15c = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\x8f','o','p','e','n','e','d',' ','\x1e','i','t',' ','\x09','c','o','r','r','u','p','t','.',
/* 0x0b182 = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x09','\xfd','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0b1a8 = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x10','u','n','a','b','l','e',' ','\x08','d','e','a','l',' ','\x1c','\x02','\xbb','a','t',' ','h','a','n','d','.',
/* 0x0b1ce = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x09','o','u','t',' ','\x14','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x83','\x24',
/* 0x0b1f4 = "The type of media was not recognized. Not formatted?." */
    '\x03','\xda','\x14','m','e','d','i','a',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',' ','N','o','t',' ','f','o','r','m','a','t','t','e','d','?','.',
/* 0x0b21a = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x1d','\xaf','m','a','p','p','e','d',' ','\x8d','\xa4','t','i','m','e','s',' ','\x22','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x0b240 = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b266 = "Failed to resolve an imported (external) symbol." */
    '\x80','\x08','r','e','s','o','l','v','e',' ','\x60','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x0b28c = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x09','r','e','s','t','r','i','c','t','e','d',' ','\x0d','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x0b2b2 = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0b2d8 = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0b2fe = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x86','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x0b324 = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x0b34a = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\x86','e','q','u','a','l',' ','\x08','\x02','k','e','y','.',
/* 0x0b370 = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','P','A','G','E','_','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0b396 = "The value is not a zero terminated password string." */
    '\x03','\xd1','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x0b3bc = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x05','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x0b3e2 = "Unexpected ASN.1 tag class/flag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','c','l','a','s','s','/','f','l','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x0b408 = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x60','\x1b','\x1c','\x60','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x0b42e = "Error getting extensions from the certificate." */
    '\xad','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0b454 = "Host API has not enabled SVME bit in EFER MSR." */
    'H','o','s','t',' ','A','P','I',' ','\x1d','\x05','e','n','a','b','l','e','d',' ','S','V','M','E',' ','b','i','t',' ','\x0d','E','F','E','R',' ','M','S','R','.',
/* 0x0b47a = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x0b4a0 = "Internal processing error the CodeView debug information reader." */
    '\x06','\x04','\x07','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x0b4c6 = "Failed to measure the TSC delta between two CPUs." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x0b4ec = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','X','5','0','9','_','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0b512 = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x16','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t','.',
/* 0x0b538 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','r','e','p','o','r','t',' ','\x8d','\xa4','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x0b55e = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\x8b','\x09','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x1c','G','I','M',' ','\xf3','i','t',' ','o','u','g','h','t',' ','\x08','b','e','.',
/* 0x0b584 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x16','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xba','e','x','e','c','u','t','e',' ','\xa1','c','o','d','e',' ','\x0d','\x02','\xd5','\xfb',
/* 0x0b5aa = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x05','a','c','c','e','s','s','i','b','l','e',' ','\x86','e','r','r','o','n','e','o','u','s',' ','\x18','c','o','n','t','e','n','t','s','.',
/* 0x0b5d0 = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x10','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x0e','u','s','e',' ','\x1c','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x0b5f6 = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\x9a',
/* 0x0b61c = "GVM struct size is not compatible with the host page size." */
    'G','V','M',' ','s','t','r','u','c','t',' ','\xdf','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\x02','h','o','s','t',' ','\xab','s','i','z','e','.',
/* 0x0b642 = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x05','\xb2','\x02','\xc0','i','n','t','e','r','f','a','c','e','.',
/* 0x0b668 = "A request was not prepared and thus could not be submitted." */
    'A',' ','\x94','\x10','\x05','p','r','e','p','a','r','e','d',' ','\x2a','t','h','u','s',' ','c','o','u','l','d',' ','\x05','\x8f','s','u','b','m','i','t','t','e','d','.',
/* 0x0b68e = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x09','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','d','e','v','i','c','e','.',
/* 0x0b6b4 = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x88','\x08','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x0b6da = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x0b700 = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xa1','\x82','t','e','r','m','i','n','a','t','e','d',' ','\x1c','\x60','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x0b726 = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b74c = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x60','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x0b772 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b797 = "Encountered a \'-\' during conversion to an unsigned value." */
    '\x97','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x08','\x60','u','n','s','i','g','n','e','d',' ','\xd2',
/* 0x0b7bc = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x0b7e1 = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x0b806 = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0b82b = "Syntax error - the argument does not allow a range to be specified." */
    '\xe2','\x07','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\x9e','\x05','a','l','l','o','w',' ','a',' ','\xe5','\x08','\x8f','s','p','e','c','i','f','i','e','d','.',
/* 0x0b850 = "Expected write pipe, got a read pipe instead." */
    '\xa7','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0b875 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x09','\x8d','s','m','a','l','l',' ','\x08','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x0b89a = "Error enumerating all processes in the session." */
    '\xad','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0d','\x02','s','e','s','s','i','o','n','.',
/* 0x0b8bf = "The name of the module clashed with an existing module." */
    '\x03','\xf8','\x14','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x1c','\x60','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x0b8e4 = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x14','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x0b909 = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0d','\x02','\xa2','\xa6','\xe4','\x02','o','n','e',' ','\x0d','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x0b92e = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xba','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0d','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x0b953 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x0b978 = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x0b99d = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','M','I','S','S','I','N','G','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0b9c2 = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xd8','\x5c','\xda','\x14','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x0b9e7 = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x9e','\x05','p','o','i','n','t',' ','\x08','\x02','s','t','a','r','t',' ','\x14','a',' ','n','o','d','e','.',
/* 0x0ba0c = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x0ba31 = "Failed to fix mappings because a mapping rejected the address." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1e','a',' ','\xe1','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x0ba56 = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x1b','\x18','\x09','\x05','o','w','n','e','d',' ','\xb9','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x09','i','t',' ','\xef','b','e','.',
/* 0x0ba7b = "Expected read pipe, got a write pipe instead." */
    '\xa7','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0baa0 = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0bac5 = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','\xb6','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0baea = "Failed to abort entering a critical section in ring-0." */
    '\x80','\x08','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xc8','\x0d','r','i','n','g','-','0','.',
/* 0x0bb0f = "Invalid ASN.1 ISO-646/VISIBLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','\xb3','-','6','4','6','/','V','I','S','I','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0bb34 = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xa8','\xbc','\xe6','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9e','\x05','p','e','r','m','i','t','s',' ','\x02','\x8a','n','a','m','e','.',
/* 0x0bb59 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0bb7e = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x84','\x0e','\x25','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x0bba3 = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x2a','C','P','U','M','.',
/* 0x0bbc8 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x08','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x0bbed = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0bc12 = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','f','i','x','u','p',' ','\xc8','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0bc37 = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9f','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf4',
/* 0x0bc5c = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','v','a','l','i','d','.',
/* 0x0bc81 = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\x95',
/* 0x0bca6 = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xb5','s','e','t','.',
/* 0x0bccb = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0b','\xab','c','o','u','n','t',' ','g','i','v','e','n',' ','\x08','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x0bcf0 = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x90','\x1d','\xeb','\xc4','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x0bd15 = "The field does not follow immediately the previous one." */
    '\x03','\xf5','\x9e','\x05','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x0bd3a = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x15','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0bd5f = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x2a','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x0bd84 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x09','\x60','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x0bda9 = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x0bdce = "Recompiler: Duplicate argument variable number." */
    '\x11','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x0bdf2 = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x0be16 = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xac','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x60','\x81','s','t','a','t','u','s',' ','\x5e',
/* 0x0be3a = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x0be5e = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x10','s','u','b','m','i','t','t','e','d',' ','\xb9','g','u','e','s','t','.',
/* 0x0be82 = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x09','\x05','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x08','g','r','o','w','.',
/* 0x0bea6 = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x0beca = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x0beee = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','\xe1','\x9f','\x09','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x0bf12 = "VFS chain element takes a file system (vfs) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0bf36 = "Too many ICB indirections, possibly a loop." */
    '\xee','\xa4','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x0bf5a = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x8f','s','t','a','r','t','e','d',' ','\x1e','i','t','\'','s',' ','\x22','a','c','t','i','v','e','.',
/* 0x0bf7e = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x14','\x02','e','v','e','n','t','.',
/* 0x0bfa2 = "The field contains an invalid callback or transformation index." */
    '\x03','\xf5','\x7f','\x60','\x81','c','a','l','l','b','a','c','k',' ','\x86','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x0bfc6 = "Syntax error - an undefined variable was referenced." */
    '\xe2','\x07','-',' ','\x60','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x10','r','e','f','e','r','e','n','c','e','d','.',
/* 0x0bfea = "Image Verification Failure: Authenticode parsing output." */
    'I','m','a','g','e',' ','\x0c','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x0c00e = "The image is required to force integrity checks." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x0c032 = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xcd','\x0d','\xbe','\xcd','s','e','q','u','e','n','c','e','.',
/* 0x0c056 = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\x8b','\xf8','\x09','\x8d','l','o','n','g','.',
/* 0x0c07a = "VM struct size is not compatible with the host page size." */
    '\xd0',' ','s','t','r','u','c','t',' ','\xdf','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1c','\x02','h','o','s','t',' ','\xab','s','i','z','e','.',
/* 0x0c09e = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0c0c2 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xa8','\xbc','\xe6','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','a',' ','\xb5','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c0e6 = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x84','\x0e','\x25','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\x9f','\x08','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x0c10a = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x14','\x02','D','E','K','-','I','n','f','o',' ','\xf5','\x09','\x8d','l','o','n','g','.',
/* 0x0c12e = "VFS chain element only provides file system (vfs) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0c152 = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','\xf2','\xb9','\x02','P','K','C','S',' ','#','7',' ','\x5e',
/* 0x0c176 = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x0c19a = "NEM init failed because of missing kernel API (#4)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0c1be = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x0c1e2 = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0c206 = "No more handles available, too many open handles." */
    '\xce','\xfc','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\x8d','\xa4','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x0c22a = "Invalid address mode passed to an IEM function." */
    '\x0b','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0c24e = "Import ISO contains a \'.\' or \'..\' directory record with a bad name." */
    '\xb1','\xb3',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x19','r','e','c','o','r','d',' ','\x1c','a',' ','b','a','d',' ','n','a','m','e','.',
/* 0x0c272 = "NEM init failed because of missing kernel API (#2)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0c296 = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xc0','\x83','\xba','\x8f','p','e','r','f','o','r','m','e','d',' ','\x1e','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','\xdc','r','e','s','e','t','.',
/* 0x0c2ba = "Error encoding the password for key decryption." */
    '\xad','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x0e','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x0c2de = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0X0c302 = "NEM init failed because of missing kernel API (#1)." */
    'E','M',' ','i','n','i','t',' ','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0c325 = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xc6','\x98','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xda','\xc1','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0c349 = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','c','o','n','t','e','x','t','.',
/* 0x0c36d = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x1d','\xeb','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1c','i','t','.',
/* 0x0c391 = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xa1','\x1d','\x05','s','e','t','u','p',' ','u','s','e',' ','\x14','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0c3b5 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x84','\x0e','\x25','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xa1','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x0c3d9 = "NEM init failed because of missing kernel API (#3)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0c3fd = "The VFS chain specification does not have a valid prefix." */
    '\x03','\xa5',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x9e','\x05','\xed','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x0c421 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0c445 = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','D','I','G','E','S','T','_','E','N','C','R','Y','P','T','_','\x99',
/* 0x0c469 = "Encountered an unsupported Solaris Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0c48d = "Encountered a load command that\'s not implemented." */
    '\x97','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0c4b1 = "Unable to allocate more pages from the host system." */
    '\xcc','\x08','a','l','l','o','c','a','t','e',' ','\xfc','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x0c4d5 = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x17','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','\x82','\x5c','\x0e','c','o','m','p','a','r','i','n','g',' ','\x1c','d','i','s','k',' ','d','a','t','a','.',
/* 0x0c4f9 = "Generic debug event, suspend the VM for debugging." */
    '\x96','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xd0',' ','\x0e','d','e','b','u','g','g','i','n','g','.',
/* 0x0c51d = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0c541 = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x0c565 = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','P','A','R','S','E','_','S','T','R','I','N','G','_','A','S','_','B','O','O','L',
/* 0x0c589 = "Invalid parameters passed to the lock validator." */
    '\x0b','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x08','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x0c5ad = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x1d','\xeb','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1c','i','t','.',
/* 0x0c5d1 = "Process Verification Failure: No KERNE32.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xce','K','E','R','N','E','3','2','.','D','L','L',' ','\xe1','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0c5f5 = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xae','p','r','e','v','e','n','t','s',' ','\x02','\xcf',
/* 0x0c619 = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x7b',
/* 0x0c63d = "NEM init failed because of missing kernel API (#5)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1e','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0c661 = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xc9','\x09','\x05','t','e','r','m','i','n','a','t','e','d','.',
/* 0x0c685 = "Unable to parse the CodeView debug information." */
    '\xcc','\x08','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c6a9 = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x0c6cc = "Invalid ASN.1 T61/TELETEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','T','6','1','/','T','E','L','E','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0c6ef = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x0c712 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','\xe5','\x9e','\x05','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x0c735 = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0c758 = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x99',
/* 0x0c77b = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xad','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xc4','\x0e','a',' ','P','K','C','S',' ','#','7',' ','\xd6','\xcf',
/* 0x0c79e = "The page hash table is not strictly ordered by offset." */
    '\x03','\xab','h','a','s','h',' ','\x9f','\x09','\x05','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xb9','o','f','f','s','e','t','.',
/* 0x0c7c1 = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','M','I','S','S','I','N','G','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x0c7e4 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x0c807 = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','d','i','s','a','b','l','e','d',' ','a',' ','\xac','\xc1','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x0c82a = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x10','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x0c84d = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','S','S','M','_','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0c870 = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','\xeb','p','a','s','s','w','o','r','d',' ','\x10','g','i','v','e','n','.',
/* 0x0c893 = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x05','d','e','c','r','y','p','t','e','d','.',
/* 0x0c8b6 = "Certificate path validator: Name constraints permits no names." */
    '\xa8','\xbc','\xe6','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','\xeb','n','a','m','e','s','.',
/* 0x0c8d9 = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x14','\x02','\xc8','\x0d','\x02','\x1b','\x18','\x09','\x05','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0c8fc = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x09','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x0c91f = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xc4','\xbf','\x9e','\x05','\xe4','\x02','o','n','e',' ','\x0d','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c942 = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x0c965 = "Couldn\'t connect to the server (proxy?)." */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x08','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',')','.',
/* 0x0c988 = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\x95',
/* 0x0c9ab = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\x86','s','p','e','a','k',' ','o','u','t',' ','\x14','t','u','r','n',' ','\x7b',
/* 0x0c9ce = "No host backend attached / available." */
    '\xce','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0c9f1 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','\xdf','\x10','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x0ca14 = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xb1','\xb3',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xbe','\xcd','v','e','r','s','i','o','n','.',
/* 0x0ca37 = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xc6','\x98','a',' ','\x8a','\x1c','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','\xda','\x86','\xc2','r','e','v','i','s','i','o','n','.',
/* 0x0ca5a = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','\xec','\x09','o','w','n','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0ca7d = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x05','s','u','s','p','e','n','d','e','d','.',
/* 0x0caa0 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\xaa','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x99',
/* 0x0cac3 = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x10','a','t','t','e','m','p','t','e','d','.',
/* 0x0cae6 = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','L','D','R','M','A','C','H','O','_','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0cb09 = "Only regular files supported by the UDF importer." */
    'O','n','l','y',' ','r','e','g','u','l','a','r',' ','f','i','l','e','s',' ','\xf2','\xb9','\x02','U','D','F',' ','i','m','p','o','r','t','e','r','.',
/* 0x0cb2c = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    'V','W','R','N','_','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0cb4f = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','\x8d','l','o','n','g',' ','\x0e','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x0cb72 = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xf7','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G',
/* 0x0cb95 = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x09','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x0cbb8 = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x1c','\x60','\x81','t','o','k','e','n','.',
/* 0x0cbdb = "PE image data without any valid content was not expected." */
    'P','E',' ','\x1b','\x90','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xd9','\x10','\x05','e','x','p','e','c','t','e','d','.',
/* 0x0cbfe = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','f','o','r','w','a','r','d','e','r','s',' ','\x1d','\x05','\xaf','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0cc21 = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x1c','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x0cc44 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x0cc67 = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xb9','n','a','m','e','.',
/* 0x0cc8a = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\x86','p','h','y','s','i','c','a','l',')',' ','\x09','\x8d','b','i','g','.',
/* 0x0ccad = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xd1','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x0ccd0 = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','i','n','s','e','r','t',' ','m','o','d','e',' ','\x1c','\x81','k','e','y',' ','r','a','n','g','e','.',
/* 0x0ccf3 = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','M','I','S','S','I','N','G','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0cd16 = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0cd39 = "Invalid ASN.1 OBJECT IDENTIFIER encoding." */
    '\x0b','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x0cd5b = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x15','K','N','O','W','N','_','E','V','P',
/* 0x0cd7d = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0cd9f = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xf7','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0cdc1 = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','S','I','Z','E',
/* 0x0cde3 = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x0ce05 = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x24',
/* 0x0ce27 = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','I','N','T','E','G','R','I','T','Y','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0ce49 = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','\xed','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x0ce6b = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\x86','\x02','P','D','P','E','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0ce8d = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x83','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x0ceaf = "No space for rock ridge \'CE\' entry in directory record." */
    '\xce','s','p','a','c','e',' ','\x0e','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xb7','\x0d','\x19','r','e','c','o','r','d','.',
/* 0x0ced1 = "Invalid VMCS index or write to read-only element." */
    '\x0b','V','M','C','S',' ','i','n','d','e','x',' ','\x86','w','r','i','t','e',' ','\x08','r','e','a','d','-','\xfd','e','l','e','m','e','n','t','.',
/* 0x0cef3 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0X0cf15 = "Semaphore destroyed while waiting." */
    'e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0cf36 = "The file contained a data unit which no-one wants." */
    '\x03','\x18','c','o','n','t','a','i','n','e','d',' ','a',' ','\x90','u','n','i','t',' ','\xc1','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0cf58 = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\xb6','P','A','R','A','M','E','T','E','R','S',
/* 0x0cf7a = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\xb8','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0cf9c = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xc1','i','s','n','\'','t',' ','a',' ','\x18','n','o','r',' ','a',' ','\x19','\x9a',
/* 0x0cfbe = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xab','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xae','\x2a','\x02','V','M','.',
/* 0x0cfe0 = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0d002 = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','\xdf','\x14','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x1b','\x09','\x8d','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x0d024 = "Long ASN.1 tag form is not implemented." */
    'L','o','n','g',' ','A','S','N','.','1',' ','t','a','g',' ','f','o','r','m',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0d046 = "The table of content XML document does not have a toc element." */
    '\x03','\x9f','\x14','\xd9','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\x9e','\x05','\xed','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x0d068 = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x05','\xf2','\xb9','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x0d08a = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x0e','\x02','e','v','e','n','t',' ','\xec','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x0d0ac = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x90','\x0d','\x02','s','a','v','e','d',' ','\xae','\xa6','c','o','n','f','o','r','m',' ','\x08','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0d0ce = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','i','n','t','3',' ','\x1c','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d0f0 = "Invalid selector. Usually beyond table limits." */
    '\x0b','s','e','l','e','c','t','o','r','.',' ','U','s','u','a','l','l','y',' ','b','e','y','o','n','d',' ','\x9f','l','i','m','i','t','s','.',
/* 0x0d112 = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xd1','\x10','\x8d','b','i','g',' ','\x0e','\x02','\xc0','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0d134 = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','\x90','\x08','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0d156 = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0d178 = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0d19a = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0d1bc = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0d1de = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x09','a','b','o','u','t',' ','\x08','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0d200 = "Process Verification Failure: No NTDLL.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xce','N','T','D','L','L','.','D','L','L',' ','\xe1','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0d222 = "The image is the correct format but is corrupted." */
    '\x03','\x1b','\x09','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0d244 = "Internal ISO maker error: Finalization problem #1." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0d266 = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x0d288 = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xb5','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0d2aa = "Internal error, VRDP packet is in wrong operation mode." */
    '\x06','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x09','\x0d','w','r','o','n','g',' ','\x83','m','o','d','e','.',
/* 0x0d2cc = "The request could not be canceled because it already completed." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x8f','c','a','n','c','e','l','e','d',' ','\x1e','i','t',' ','\x22','c','o','m','p','l','e','t','e','d','.',
/* 0x0d2ee = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x07','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0d310 = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xb1','\xb3',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1c','\x60','o','u','t',' ','\x14','b','o','u','n','d','s',' ','\x90','e','x','t','e','n','t','.',
/* 0x0d332 = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x17','\x0c','\x12','\x03','\xf8','\x14','\x60','\x1b','\x18','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','\xe1','r','e','g','i','o','n','s','.',
/* 0x0d354 = "Internal ISO maker error: Rock ridge read problem." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0d376 = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','S','I','Z','E','_','O','V','E','R','F','L','O','W',
/* 0x0d398 = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x1d','s','t','a','r','t','e','d',' ','O','K',' ','\x2a','w','i','l','l',' ','r','u','n','.',
/* 0x0d3ba = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x14','\x02','d','y','n','a','m','i','c',' ','\xe1','c','a','c','h','e',' ','\x24',
/* 0x0d3dc = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0d3fd = "Empty sub-string set inside X.509 name." */
    'E','m','p','t','y',' ','s','u','b','-','\xc9','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x0d41e = "Unsupported escape sequence encountered in TeletexString." */
    '\x87','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0d43f = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x0d460 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xbe','\xcd','\x1d','a',' ','\x8d','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0d481 = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\xb8','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0x0d4a2 = "Error reading a certificate in PEM format from BIO." */
    '\xad','r','e','a','d','i','n','g',' ','a',' ','\x8a','\x0d','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0d4c3 = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x1d','\xeb','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1c','i','t','.',
/* 0x0d4e4 = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x60','\x81','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x0d505 = "Import ISO contains a root directory with a bad record length." */
    '\xb1','\xb3',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1c','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0d526 = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0d547 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d568 = "Reason for leaving RC: #PF for monitored patch page." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x0e','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0d589 = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0d5aa = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xc6','\xa6','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0d5cb = "Error extracting RSA from the public key." */
    '\xad','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0d5ec = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0d60d = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0d62e = "Generic BER parse error. Will be refined later." */
    '\x96','B','E','R',' ','p','a','r','s','e',' ','\x7b',' ','W','i','l','l',' ','\x8f','r','e','f','i','n','e','d',' ','l','a','t','e','r','.',
/* 0x0d64f = "NEM failed to create a native VM instance." */
    'N','E','M',' ','\x88','\x08','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xd0',' ','i','n','s','t','a','n','c','e','.',
/* 0x0d670 = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0d691 = "A path does not start with a root specification." */
    'A',' ','\xbc','\x9e','\x05','s','t','a','r','t',' ','\x1c','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0d6b2 = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0d6d3 = "The process specified to a non-block wait had not exited." */
    '\x03','\x82','\x16','\x08','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x05','e','x','i','t','e','d','.',
/* 0x0d6f4 = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x17','\x0c','\x12','\x85','\xc8','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0d715 = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x05','m','a','r','k','e','d',' ','\x0e','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0d736 = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x1c','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d757 = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','e','n','a','b','l','e','d',' ','a',' ','\xac','\xc1','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x0d778 = "Return to ring-3 to write the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0d799 = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','\xb6','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0x0d7ba = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','\x05','\x7d',
/* 0x0d7db = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x0d7fc = "Process Verification Failure: Error determining the full path of System32." */
    '\x17','\x0c','\x12','\xad','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xbc','\x14','S','y','s','t','e','m','3','2','.',
/* 0x0d81d = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x5c','\x1e','i','t','\'','s',' ','u','s','e','d',' ','\x0d','m','a','p','p','i','n','g','.',
/* 0x0d83e = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0d85f = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','M','I','S','S','I','N','G','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x0d880 = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x8f','d','o','n','e',' ','\x0d','\xd5','\x1b','\xfb',
/* 0x0d8a1 = "Invalid ASN.1 UNIVERSAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','N','I','V','E','R','S','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0d8c2 = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0d8e3 = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\xe7','V','P','_','\x15','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0d904 = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x81','f','l','a','g','s',' ','s','e','t','.',
/* 0x0d925 = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xd3','\xc8','\x09','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0d946 = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0d967 = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','r','o','o','m',' ','\x08','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0d988 = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xf6','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0d9a9 = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xe5','f','r','o','m',' ','s','a','v','e','d',' ','\xfb',
/* 0x0d9ca = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','G','P',' ','\x1c','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d9eb = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xab','f','r','o','m',' ','s','a','v','e','d',' ','\xfb',
/* 0x0da0c = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x7b',
/* 0x0da2d = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x0da4e = "Invalid ASN.1 PRINTABLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','P','R','I','N','T','A','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0da6f = "VERR_GVMM_GVMCPU_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','G','V','M','C','P','U','_','S','T','R','U','C','T','_','\x15','P','A','G','E','_','A','L','I','G','N','E','D',
/* 0x0da90 = "Internal ISO maker error: Descriptor miscounting." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0dab1 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0dad2 = "Virtual machine error occurred attempting the operation." */
    '\xe3',' ','m','a','c','h','i','n','e',' ','\x07','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xcf',
/* 0x0daf3 = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','M','I','S','S','I','N','G','_','F','I','N','A','L','_','O','R','_','\x9c','B','I','G',
/* 0x0db14 = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x84','\x0e','\x25','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xbb','c','a','l','l','e','d',' ','a','t',' ','\xd5','e','i','p','.',
/* 0x0db35 = "Invalid or unsupported logical block size." */
    '\x0b','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0db56 = "Unknown escape sequence encountered in TeletexString." */
    '\xd8','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0db77 = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0db98 = "Invalid ASN.1 GENERALIZED TIME encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L','I','Z','E','D',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x0dbb9 = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0dbda = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0dbfa = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x81','I','/','O',' ','p','o','r','t',' ','\xdf','\x10','\x16','\x0e','a',' ','r','e','a','d',' ','\x86','w','r','i','t','e',' ','\xcf',
/* 0x0dc1a = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x1d','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0dc3a = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x18','\x08','\x02','l','i','s','t',' ','\x08','\x8f','m','o','n','i','t','o','r','e','d','.',
/* 0x0dc5a = "Invalid ASN.1 VIDEOTEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','V','I','D','E','O','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0dc7a = "Import ISO contains a zero sized root directory." */
    '\xb1','\xb3',' ','\x7f','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0dc9a = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x09','\x22','p','r','e','s','e','n','t',' ','\x0d','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0dcba = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0dcda = "The size of the raw floppy image is too big (>2.88MB)." */
    '\x03','\xdf','\x14','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x1b','\x09','\x8d','b','i','g',' ','(','>','2','.','8','8','M','B',')','.',
/* 0x0dcfa = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\x8e','\x0e','\x02','s','e','s','s','i','o','n',' ','\x86','\x1b','\x1d','\x22','\xaf','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0dd1a = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xcd','\x1d','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0dd3a = "VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH" */
    '\x01','\xe8','B','O','G','U','S','_','A','L','L','O','C','A','T','I','O','N','_','E','X','T','E','N','T','_','L','E','N','G','T','H',
/* 0x0dd5a = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x14','a',' ','t','a','r',' ','\xa2','r','e','c','o','r','d',' ','\xa6','m','a','t','c','h','.',
/* 0x0dd7a = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','\xc6','\xc8','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0dd9a = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','B','o','o','t',' ','\xd3','\x18','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0ddba = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xa3','\xc3','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0ddda = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0ddfa = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','T','R','I','N','G','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0de1a = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\xe7','V','P','_','\x15','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0de3a = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x8f','d','o','n','e',' ','\x0d','\xd5','\x1b','\xfb',
/* 0x0de5a = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0de7a = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0de9a = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xc4','\xbf','c','o','n','t','e','x','t','.',
/* 0x0deba = "Virtual address was not allocated by the library." */
    '\xe3',' ','a','d','d','r','e','s','s',' ','\x10','\x05','a','l','l','o','c','a','t','e','d',' ','\xb9','\x02','l','i','b','r','a','r','y','.',
/* 0x0deda = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0defa = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9e','\x05','\xb2','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0df1a = "Invalid operand size passed to an IEM function." */
    '\x0b','o','p','e','r','a','n','d',' ','\xdf','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0df3a = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\xe7','V','P','_','\xb4','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0df5a = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0df7a = "Bad UTF-16 surrogate pair sequence." */
    '\x92','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0df9a = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\x8a','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0dfba = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','1',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0dfda = "An unknown config value was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','\xd1','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0dffa = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','S','T','R','I','N','G',
/* 0x0e01a = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\xe7','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','F','O','R','C','E','_','I','N','T','E','G','R','I','T','Y',
/* 0x0e03a = "No unwind information for the specified location." */
    '\xce','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x0e','\x02','\x16','l','o','c','a','t','i','o','n','.',
/* 0x0e05a = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xcf',
/* 0x0e07a = "No 32-bit to 64-bit switcher in place." */
    '\xce','3','2','-','b','i','t',' ','\x08','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0d','p','l','a','c','e','.',
/* 0x0e09a = "A file operation was attempted on a non-file object." */
    'A',' ','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x18','o','b','j','e','c','t','.',
/* 0x0e0ba = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x09','b','u','s','y',' ','\x86','\x09','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s','.',
/* 0x0e0da = "Syntax error - too many arguments for static storage." */
    '\xe2','\x07','-',' ','\x8d','\xa4','a','r','g','u','m','e','n','t','s',' ','\x0e','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0e0fa = "Invalid session ID in managed object reference." */
    '\x0b','s','e','s','s','i','o','n',' ','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x0e11a = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x1a','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0e13a = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x0e15a = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xa8','\xbc','\xe6','\x0b','p','o','l','i','c','y',' ','\xe1','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x0e17a = "Failed to open underlying link instance." */
    '\x80','\x08','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0e19a = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','M','I','S','S','I','N','G','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x0e1ba = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x18','o','b','j','e','c','t','.',
/* 0x0e1da = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x11','O','u','t',' ','\x14','\x5c','\x0e','\x02','\xbb','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0e1fa = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0e21a = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0e23a = "Encountered an unsupported GNU Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0e25a = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','0',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e27a = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x93',
/* 0x0e29a = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\x8f','r','e','s','o','l','v','e','d','.',
/* 0x0e2ba = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','3',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e2da = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0e2fa = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0e31a = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0e33a = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\xaa','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0e35a = "Path to child node was invalid (i.e. empty)." */
    'P','a','t','h',' ','\x08','c','h','i','l','d',' ','n','o','d','e',' ','\x10','\x81','(','i','.','e','.',' ','e','m','p','t','y',')','.',
/* 0x0e37a = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x90','\xd6','\x88','d','u','e',' ','\x08','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0e39a = "Internal ISO maker error: Buggy namespace table." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0e3ba = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\xe8','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0e3da = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xa0','R','E','G','I','O','N','S','_','S','I','Z','E',
/* 0x0e3fa = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','\x81','n','o','d','e',' ','n','a','m','e','.',
/* 0x0e41a = "VERR_GVMM_VMCPU_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','V','M','C','P','U','_','S','T','R','U','C','T','_','\x15','P','A','G','E','_','A','L','I','G','N','E','D',
/* 0x0e43a = "Too long forwarder chain or there is a loop." */
    '\xee','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\x91','\x86','t','h','e','r','e',' ','\x09','a',' ','l','o','o','p','.',
/* 0x0e45a = "Too many calls to the service from a client." */
    '\xee','\xa4','c','a','l','l','s',' ','\x08','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x0e47a = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x1d','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0e49a = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0x0e4ba = "Image Verification Failure: No Authenticode Signature." */
    'I','m','a','g','e',' ','\x0c','\x12','\xce','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x0e4da = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0e4fa = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x10','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0e51a = "APIC register/MSR write invalid." */
    'A','P','I','C',' ','r','e','g','i','s','t','e','r','/','M','S','R',' ','w','r','i','t','e',' ','i','n','v','a','l','i','d','.',
/* 0x0e53a = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x09','\x05','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0e55a = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x19','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x19','o','b','j','e','c','t','.',
/* 0x0e57a = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x09','m','i','s','s','i','n','g',' ','\x86','\x1d','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0e59a = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x19','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x19','o','b','j','e','c','t','.',
/* 0x0e5ba = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0e5da = "UDF file cannot be import sparse files at present." */
    'U','D','F',' ','\x18','\xba','\x8f','\xfe','s','p','a','r','s','e',' ','f','i','l','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x0e5fa = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','r','e','c','e','i','v','e','.',
/* 0x0e61a = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x0e63a = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x19','\x08','\x02','l','i','s','t',' ','\x08','\x8f','m','o','n','i','t','o','r','e','d','.',
/* 0x0e65a = "Certificate extensions requires certificate version 3 or later." */
    '\xa8','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\x8a','\xb5','3',' ','\x86','l','a','t','e','r','.',
/* 0x0e67a = "Process Verification Failure: Error querying thread information." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0e69a = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','2',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e6ba = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x5e',
/* 0x0e6da = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','M','E','M','O','R','Y','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0X0e6fa = "Descriptor tag sector number mismatch." */
    'e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xde','m','i','s','m','a','t','c','h','.',
/* 0x0e719 = "The volume map doesn't contain any valid volume." */
    '\x03','\xbe','m','a','p',' ','\xa6','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0e739 = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0e759 = "VFS chain does not terminate with the desired object type." */
    '\xa5',' ','\x91','\x9e','\x05','t','e','r','m','i','n','a','t','e',' ','\x1c','\x02','d','e','s','i','r','e','d',' ','\x8e','t','y','p','e','.',
/* 0x0e778 = "Invalid instruction length passed to an IEM function." */
    '\x0b','\xbb','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0e797 = "Invalid ASN.1 NUMERIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','M','E','R','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e7b6 = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x1f','\x0e','X','A','R',' ','\x90','s','t','r','e','a','m','.',
/* 0x0e7d5 = "Internal ISO maker error: Namespace problem #5." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0e7f4 = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\xd7','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0e813 = "Internal ISO maker error: Namespace problem #3." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0e832 = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\xe7','V','P','_','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x15','E','N','F','O','R','C','E','D',
/* 0x0e851 = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0e870 = "Image Verification Failure: Error allocating memory for section headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xc8','h','e','a','d','e','r','s','.',
/* 0x0e88f = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x14','i','n','f','o','r','m','a','t','i','o','n',' ','\x24',
/* 0x0e8ae = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0e8cd = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    'V','W','R','N','_','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0e8ec = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x08','\x02','\x8e','\x09','\x05','a','l','l','o','w','e','d','.',
/* 0x0e90b = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0e92a = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0e949 = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xab','f','r','o','m',' ','s','a','v','e','d',' ','\xfb',
/* 0x0e968 = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x60','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0e987 = "Internal ISO maker error: Namespace problem #4." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0e9a6 = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    'V','W','R','N','_','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e9c5 = "The device instance have no such logical unit." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xed','\xeb','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x0e9e4 = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x0ea03 = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','S','T','R','I','N','G','_','T','A','B',
/* 0x0ea22 = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\xf1','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0ea41 = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x1a','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0ea60 = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x08','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x10','l','o','s','t','.',
/* 0x0ea7f = "Unsupported interface for managed object reference." */
    '\x87','i','n','t','e','r','f','a','c','e',' ','\x0e','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x0ea9e = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\xa3','\xc3','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0eabd = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','S','U','P','L','I','B','_','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x0eadc = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x10','\x05','l','o','c','k','e','d','.',
/* 0x0eafb = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\xaa','S','P','C','_','\x15','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0eb1a = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x92','V','T','G',' ','\xa2','-',' ','\xdf','\xd1','\x09','\x05','a',' ','m','u','l','t','i','p','l','e',' ','\x14','\x02','\xc2','s','i','z','e','.',
/* 0x0eb39 = "No GIM provider is configured for this VM." */
    '\xce','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x0e','\xcb','V','M','.',
/* 0x0eb58 = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb6','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0eb77 = "Invalid ASN.1 GRAPHIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','R','A','P','H','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0eb96 = "ASN.1 object has no pfnCheckSanity method." */
    'A','S','N','.','1',' ','\x8e','\x1d','\xeb','p','f','n','C','h','e','c','k','S','a','n','i','t','y',' ','m','e','t','h','o','d','.',
/* 0x0ebb5 = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x7b',
/* 0x0ebd4 = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\xaa','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x15','I','M','P','L',
/* 0x0ebf3 = "No clipboard data available for requested format." */
    '\xce','c','l','i','p','b','o','a','r','d',' ','\x90','a','v','a','i','l','a','b','l','e',' ','\x0e','\xc0','f','o','r','m','a','t','.',
/* 0x0ec12 = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\xa3','\xc3','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0ec31 = "Internal ISO maker error: Namespace problem #1." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0ec50 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xa3','\xc3','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0ec6f = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','\xe5','l','o','o','k','u','p',' ','\x5e',
/* 0x0ec8e = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0ecad = "Internal ISO maker error: Expected path to start with root slash." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','\xa7','\xbc','\x08','s','t','a','r','t',' ','\x1c','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0eccc = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xa9','\x91','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0eceb = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xe5','f','r','o','m',' ','s','a','v','e','d',' ','\xfb',
/* 0x0ed0a = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x09','m','a','s','k','e','d',' ','\xb9','T','P','R','.',
/* 0x0ed29 = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x7b',
/* 0x0ed48 = "Process Verification Failure: Error query virtual memory information." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0ed67 = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\xaa','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','C','T','X','_','C','O','P','Y','_','\x9d',
/* 0x0ed86 = "Import ISO contains a root directory without the directory flag set." */
    '\xb1','\xb3',' ','\x7f','a',' ','r','o','o','t',' ','\x19','w','i','t','h','o','u','t',' ','\x02','\x19','f','l','a','g',' ','s','e','t','.',
/* 0x0eda5 = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\xb6','S','Y','M','B','O','L','_','O','R','_','\xb6','S','T','R','I','N','G','_','T','A','B','S',
/* 0x0edc4 = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x08','h','a','l','t',' ','a',' ','\xd0',' ','\x86','C','P','U',' ','\x89','\x10','\x22','h','a','l','t','e','d','.',
/* 0x0ede3 = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0ee02 = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9c','M','A','N','Y','_','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0ee21 = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B','_','\x99',
/* 0x0ee40 = "Internal ISO maker error: Namespace problem #6." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0ee5f = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x09','\x05','\xf2','\x0e','\xcb','\xd0',' ','t','a','r','g','e','t','.',
/* 0x0ee7e = "Internal ISO maker error: Namespace problem #2." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0ee9d = "Bad or missing XAR checksum element." */
    '\x92','\x86','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0eebc = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x14','\x02','c','a','l','l','.',
/* 0x0eedb = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\xaa','P','K','C','S','7','_','\x9c','M','A','N','Y','_','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x0eefa = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xd3','b','l','o','c','k',' ','\x0d','\x02','\xfe','\xb3',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0ef19 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x1d','\x22','\xaf','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0ef38 = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x0e','p','a','t','c','h','i','n','g','.',
/* 0x0ef57 = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x0ef76 = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0X0ef95 = "Shared Clipboard transfer ID not found." */
    'h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x05','\x7d',
/* 0x0efb3 = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x7b',
/* 0x0efd2 = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0eff1 = "Internal error in read-write critical section." */
    '\x06','\x07','\x0d','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0f010 = "VFS chain element takes exactly one argument." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0f02f = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x0e','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x0f04e = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0x0f06d = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','B','O','O','T','_','I','N','D',
/* 0x0f08c = "Unknown character class in glob pattern." */
    '\xd8','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0d','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0f0ab = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0f0ca = "VWRN_RECORDING_ENCODING_SKIPPED" */
    'V','W','R','N','_','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','S','K','I','P','P','E','D',
/* 0x0f0e9 = "Invalid ASN.1 GENERAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0f108 = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0f127 = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0f146 = "Image Verification Failure: Error determining the file length." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x18','l','e','n','g','t','h','.',
/* 0x0f164 = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xb1','\xb3',' ','\x7f','a',' ','\x19','\x1c','\x60','e','x','t','e','n','t',' ','\x89','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0f182 = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb6','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0f1a0 = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','1',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f1be = "Invalid initialization vector length." */
    '\x0b','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0f1dc = "The image base address is to high for this image type." */
    '\x03','\x1b','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x09','\x08','h','i','g','h',' ','\x0e','\xcb','\x1b','t','y','p','e','.',
/* 0x0f1fa = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','2',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f218 = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x1a','S','S','M','_','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0f236 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf9',' ','w','r','i','t','e','.',
/* 0x0f254 = "VERR_GVMM_GVM_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','G','V','M','_','S','T','R','U','C','T','_','\x15','P','A','G','E','_','A','L','I','G','N','E','D',
/* 0x0f272 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x0f290 = "Expected PE image data inside indirect data object." */
    '\xa7','P','E',' ','\x1b','\x90','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x90','o','b','j','e','c','t','.',
/* 0x0f2ae = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x84','\x0e','\x25','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0d','r','i','n','g','-','0','.',
/* 0x0f2cc = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x0f2ea = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xf6',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x16','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0f308 = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f326 = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x9d',
/* 0x0f344 = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\xf1','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f362 = "A path is relative, expected an absolute path." */
    'A',' ','\xbc','\x09','r','e','l','a','t','i','v','e',',',' ','\xb0','\x60','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0f380 = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x7b',
/* 0x0f39e = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x93',
/* 0x0f3bc = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x09','\xeb','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','i','s','k','.',
/* 0x0f3da = "ASN.1 object has no virtual method table." */
    'A','S','N','.','1',' ','\x8e','\x1d','\xeb','v','i','r','t','u','a','l',' ','m','e','t','h','o','d',' ','t','a','b','l','e','.',
/* 0x0f3f8 = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\xaa','S','P','C','_','\x15','E','X','A','C','T','L','Y','_','O','N','E','_','D','I','G','E','S','T','_','A','L','G','O',
/* 0x0f416 = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x08','t','a','k','e',' ','a',' ','\xec','\x0d','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x0f434 = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','L','D','R','V','I','_','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x99',
/* 0x0f452 = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x0f','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0f470 = "Expected valid data pointer for ASN.1 object." */
    '\xa7','v','a','l','i','d',' ','\x90','p','o','i','n','t','e','r',' ','\x0e','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x0f48e = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','A','L','T','_','N','A','M','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x0f4ac = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0f4ca = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x8e','\x09','\x8d','l','a','r','g','e','.',
/* 0x0f4e8 = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','L','D','R','V','I','_','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x0f506 = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','0',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f524 = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\xa5','_','\xdb','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0f542 = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xe0','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0f560 = "internal fixup chain isn\'t implemented yet." */
    '\x13','f','i','x','u','p',' ','\x91','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0f57e = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\xa0','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0f59c = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x08','\xfe','\x60','u','n','k','n','o','w','n',' ','\xb3',' ','f','o','r','m','a','t','.',
/* 0x0f5ba = "The specified path does not point at a symbolic link." */
    '\x03','\x16','\xbc','\x9e','\x05','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0f5d8 = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','\xeb','\x9e','\x05','\xe4','u','p',' ','\x08','\x02','\xd5','d','a','t','a','.',
/* 0x0f5f6 = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x9c','M','A','N','Y','_','N','O','D','E','S',
/* 0x0f614 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x84','\x0e','\x25','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0d','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0f632 = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x14','\xcb','\xec','\x1d','e','n','d','e','d','.',
/* 0x0f650 = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f66e = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xeb','3',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f68c = "Image Verification Failure: More than one certificate table entry." */
    'I','m','a','g','e',' ','\x0c','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\x8a','\x9f','e','n','t','r','y','.',
/* 0x0f6aa = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0f6c8 = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x15','V','A','L','I','D','_','U','T','F','8',
/* 0x0f6e6 = "XML error while parsing the table of content." */
    'X','M','L',' ','\x07','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x0f704 = "Import ISO contains a root directory with multiple extents." */
    '\xb1','\xb3',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1c','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0f722 = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x60','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x9a',
/* 0x0f740 = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x0f75e = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0f77c = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','B','O','O','L',
/* 0x0f79a = "A driver may only register one VTG object per session." */
    'A',' ','\xa9','m','a','y',' ','\xfd','\xbd','o','n','e',' ','V','T','G',' ','\x8e','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0f7b8 = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xc6','\x98','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0f7d6 = "The size of the shared module was out of range." */
    '\x03','\xdf','\x14','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x0f7f4 = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','\x15','\xc7',
/* 0x0f812 = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0f830 = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','A','L','G','O','_','\x15','\xb4','_','I','N','_','L','I','S','T',
/* 0x0f84e = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xbc','\x09','\x05','\x02','s','a','m','e',' ','\x8e','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x0f86c = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0f88a = "Failed to normalize ASN.1 time object." */
    '\x80','\x08','n','o','r','m','a','l','i','z','e',' ','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x0f8a8 = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x15','\xb4',
/* 0x0f8c6 = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x0f8e4 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','N','M','_','\x9d',
/* 0x0f902 = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\xaa','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x93',
/* 0x0f920 = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L','.',
/* 0x0f93e = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','X','5','0','9','_','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0f95c = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','A','T','E',
/* 0x0f97a = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0f998 = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','\xa0','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0f9b6 = "Internal processing error while merging status codes." */
    '\x06','\x04','\x07','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0f9d4 = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f9f2 = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0fa10 = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0fa2e = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x1a','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xf0','R','E','G','I','S','T','E','R','E','D',
/* 0x0fa4c = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\xa3','\xc3','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0fa6a = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','C','O','R','R','E','C','T','_','A','R','G','_','T','Y','P','E',
/* 0x0fa88 = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x9d',
/* 0x0faa6 = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x0fac4 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x0fae2 = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\xd7','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0fb00 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x0fb1e = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x0fb3c = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x0fb5a = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x0fb78 = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\xa3','\xc3','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0x0fb96 = "The VM request was killed at VM termination." */
    '\x03','\xd0',' ','\x94','\x10','k','i','l','l','e','d',' ','a','t',' ','\xd0',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x0fbb3 = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9c','M','A','N','Y','_','R','E','C','U','R','S','I','O','N','S',
/* 0x0fbd0 = "Import module ordinal is out of bounds." */
    '\xb1','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0fbed = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe7','V','P','_','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x0fc0a = "Bogus length for continuation allocation descriptor." */
    'B','o','g','u','s',' ','l','e','n','g','t','h',' ','\x0e','c','o','n','t','i','n','u','a','t','i','o','n',' ','\xfa','\xf4',
/* 0x0fc27 = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x9d',
/* 0x0fc44 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\xe0','I','M','A','G','E','_','S','I','Z','E',
/* 0x0fc61 = "Encountered an bad (/unknown) record type." */
    '\x97','\x60','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x0fc7e = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\xf0','S','U','S','P','E','N','D','E','D',
/* 0x0fc9b = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\xc3','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0fcb8 = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0x0fcd5 = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\xb6','R','A','M','_','R','A','N','G','E',
/* 0x0fcf2 = "Syntax error - out of regular heap memory." */
    '\xe2','\x07','-',' ','o','u','t',' ','\x14','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x0fd0f = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x09','\x05','\xf2','\xb9','\x02','h','a','r','d','w','a','r','e',' ','\x86','\x02','O','S','.',
/* 0x0fd2c = "Unable to start VM execution due to an invalid guest state." */
    '\xcc','\x08','s','t','a','r','t',' ','\xd0',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x08','\x60','\x81','\xa1','\xfb',
/* 0x0fd49 = "NEM can only operate from ring-3." */
    'N','E','M',' ','c','a','n',' ','\xfd','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0fd66 = "Certificate serial number length is out of bounds." */
    '\xa8','s','e','r','i','a','l',' ','\xde','l','e','n','g','t','h',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0fd83 = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','V','M','X','_','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x0fda0 = "Failed to derivate key from password." */
    '\x80','\x08','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x0fdbd = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x0fdda = "Invalid partition index in a location." */
    '\x0b','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0d','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x0fdf7 = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x16','\x90','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x0fe14 = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x0fe31 = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x9c','M','U','C','H',
/* 0x0fe4e = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x0fe6b = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xb5','\x09','\x8d','o','l','d',' ','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcf',
/* 0x0fe88 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0fea5 = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x0fec2 = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x9c','L','A','R','G','E',
/* 0x0fedf = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x9d',
/* 0x0fefc = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x1a','X','5','0','9','_','\x15','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0ff19 = "Expected PKCS #7 object to not contain any CRLs." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','\x05','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x0ff36 = "Destination address required." */
    'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x0ff53 = "Bad DWARF extended line number opcode." */
    '\x92','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xde','o','p','c','o','d','e','.',
/* 0x0ff70 = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x0e','S','I','P','I',' ','m','o','d','e','.',
/* 0x0ff8d = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0ffaa = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0ffc7 = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\xaa','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x0ffe4 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','S','S','M','_','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x10001 = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\xe8','\xa0','L','V','D','_','F','I','L','E','_','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x1001e = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x1003b = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x0f','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x10058 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x15','S','U','S','P','E','N','D','E','D',
/* 0x10075 = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x90','\x1d','e','x','c','e','e','d','e','d',' ','\x02','\xb0','s','i','z','e','.',
/* 0x10092 = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\xa3','\xc3','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x100af = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x100cc = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x16','C','P','U',' ','\xba','\x8f','f','o','u','n','d',' ','\x0d','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x100e9 = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x93',
/* 0x10106 = "Invalid ASN.1 UTF-8 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','F','-','8',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x10123 = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x15','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x10140 = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x09','\x8d','l','a','r','g','e','.',
/* 0x1015d = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0x1017a = "The specified shared page was not actually private." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xab','\x10','\x05','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x10197 = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x101b4 = "No allocation descriptors for UDF directory." */
    '\xce','\xfa','d','e','s','c','r','i','p','t','o','r','s',' ','\x0e','U','D','F',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x101d1 = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    'V','W','R','N','_','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x101ee = "Unexpected NULL pointer to right subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x1020b = "Too many partition maps in the logical volume descriptor." */
    '\xee','\xa4','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf4',
/* 0x10228 = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    'V','W','R','N','_','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x10245 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','s','e','n','d','.',
/* 0x10262 = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B','_','\x99',
/* 0x1027f = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x1029c = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\xf1','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x93',
/* 0x102b9 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x5c','r','e','g','i','o','n',' ','\x09','\x8d','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x102d6 = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x102f3 = "Error opening the ApiPort LPC object." */
    '\xad','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x10310 = "An invalid LUN specification was given." */
    'A','n',' ','\x81','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x10','g','i','v','e','n','.',
/* 0x1032d = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xa1','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','\xe4','\x02','\xa1','\xdc','l','o','a','d','e','d','.',
/* 0x1034a = "Start instruction stepping (debug only)." */
    'S','t','a','r','t',' ','\xbb','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x10367 = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x10384 = "Failed to enable and lock VT-x features." */
    '\x80','\x08','e','n','a','b','l','e',' ','\x2a','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x103a1 = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x08','u','s','e',' ','\x8d','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x103be = "Recompiler: No host register available for variables." */
    '\x11','\xce','h','o','s','t',' ','\xbd','a','v','a','i','l','a','b','l','e',' ','\x0e','v','a','r','i','a','b','l','e','s','.',
/* 0x103db = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x09','r','e','s','i','z','i','n','g','.',
/* 0x103f8 = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x18','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x10415 = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\x9e','\x05','\xe4','\x02','k','e','y','.',
/* 0x10432 = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x1044f = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','W','R','I','T','E','_','\x93',
/* 0x1046c = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x7b',
/* 0x10489 = "VFS chain element takes a directory (dir) object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x104a6 = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\xb8','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x104c3 = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','X','5','0','9','_','\x15','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x104e0 = "No debug connection configured." */
    '\xce','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x104fd = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf9',' ','r','e','a','d','.',
/* 0x1051a = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\x8f','e','n','a','b','l','e','d',' ','\x0e','\x02','c','l','i','e','n','t','.',
/* 0x10537 = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x10554 = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x1d','\x22','\xaf','o','p','e','n','e','d',' ','\x0d','\xcb','s','e','s','s','s','i','o','n','.',
/* 0x10571 = "NEM failed to unmap page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x1058e = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x105ab = "Recompiler: Too deeply nested conditionals." */
    '\x11','\xee','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x105c8 = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\xe7','V','P','_','\xa0','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x105e5 = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x10602 = "Unsupported PKCS #7 signer info version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x1061f = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\xa5','_','\xdb','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x1063c = "The internal logger revision did not match." */
    '\x03','\x13','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x10659 = "VFS chain element only provides directory (dir) objects." */
    '\xa5',' ','\x91','\x1f','\xfd','p','r','o','v','i','d','e','s',' ','\x19','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x10676 = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x10693 = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x90','s','t','a','r','t','e','d',' ','\x1c','a',' ','b','a','d',' ','\xe9',
/* 0x106b0 = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\xe7','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x106cd = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x93',
/* 0x106ea = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9c','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x10707 = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xd3','\xb7','\x0d','\x02','\xfe','\xb3',' ','\x1d','\x60','u','n','k','n','o','w','n',' ','t','y','p','e','.',
/* 0x10724 = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xeb','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x10741 = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x82','\x1d','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x1075e = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x1077b = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x14','\x02','d','y','n','a','m','i','c',' ','\xe1','c','a','c','h','e',' ','\x24',
/* 0x10798 = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x107b4 = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','X','5','0','9','_','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x107d0 = "Unable to establish trusted of VM process (0)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','0',')','.',
/* 0x107ec = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\xaa','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','S','I','Z','E','_','\x99',
/* 0x10808 = "Image Verification Failure: Error allocating memory for state data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xae','d','a','t','a','.',
/* 0x10824 = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x08','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x10840 = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x14','\x1a','E','M','_','\xb6','M','E','M','O','R','Y','.',
/* 0x1085c = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','I','Z','E','_','M','A','L','F','O','R','M','E','D',
/* 0x10878 = "Error getting a data from the extension." */
    '\xad','g','e','t','t','i','n','g',' ','a',' ','\x90','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x10894 = "The current HTTP request was forcefully aborted." */
    '\x03','\xd5','H','T','T','P',' ','\x94','\x10','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x108b0 = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x15','\xb4',
/* 0x108cc = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','\xa0','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x108e8 = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','_','E','X','C','E','E','D','E','D',
/* 0x10904 = "VERR_SVM_HOST_VM_HSAVE_PA_INVALID" */
    '\x01','S','V','M','_','H','O','S','T','_','\xd0','_','H','S','A','V','E','_','P','A','_','I','N','V','A','L','I','D',
/* 0x10920 = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','\xd0','-','e','x','i','t','.',
/* 0x1093c = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x10958 = "The specified shared page was not actually shared." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xab','\x10','\x05','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x10974 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\xb8','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','M','I','S','S','I','N','G',
/* 0x10990 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x109ac = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x08','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x109c8 = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe7','V','P','_','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x109e4 = "Empty set inside X.509 name." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x10a00 = "Syntax error - incorrect argument type." */
    '\xe2','\x07','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x10a1c = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x10a38 = "Invalid entry in the device registration structure." */
    '\x0b','\xb7','\x0d','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x10a54 = "Import ISO contains a directory with a bad record length." */
    '\xb1','\xb3',' ','\x7f','a',' ','\x19','\x1c','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x10a70 = "Invalid unit magic (internal data tag)." */
    '\x0b','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x90','t','a','g',')','.',
/* 0x10a8c = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','C','E','R','T','_','\x15','S','H','I','P','P','E','D',
/* 0x10aa8 = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xf7','\x0f','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x10ac4 = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x15','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x10ae0 = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x18','l','i','s','t',' ','\xa6','\xe4','\x08','\x02','\xd9','\x14','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x10afc = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x10b18 = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','\x05','\x7d',
/* 0x10b34 = "Too little data in ASN.1 byte stream." */
    '\xee','l','i','t','t','l','e',' ','\x90','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x10b50 = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xeb','l','i','n','e',' ','\xde','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x10b6c = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','S','S','M','_','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x10b88 = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x10ba4 = "Image Verification Failure: Internal error in signature parser." */
    'I','m','a','g','e',' ','\x0c','\x12','\x06','\x07','\x0d','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x10bc0 = "Recompiler: Variable management internal processing error #13." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','3','.',
/* 0x10bdc = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x10bf8 = "Invalid size of a SSM field with the specified transformation." */
    '\x0b','\xdf','\x14','a',' ','S','S','M',' ','\xf5','\x1c','\x02','\x16','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x10c14 = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\xd4','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x10c30 = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x10c4c = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\xa3','\xc3','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x10c68 = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x10c84 = "Unexpected MSR in the auto-load/store area." */
    '\x85','M','S','R',' ','\x0d','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x10ca0 = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x05','s','e','t',' ','\x0d','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x10cbc = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x93',
/* 0x10cd8 = "Generic: Invalid image file header. Use this for plugins." */
    'G','e','n','e','r','i','c',':',' ','\x0b','\x1b','\x18','\xe9',' ','U','s','e',' ','\xcb','\x0e','p','l','u','g','i','n','s','.',
/* 0x10cf4 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x10d10 = "Failed to allocate temporary memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x10d2c = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xf7','\x0f','P','R','I','N','T','A','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x10d48 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x0f','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x10d64 = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','P','A','G','E','_','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x15','P','R','E','S','E','N','T',
/* 0x10d80 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x10d9c = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','\xe3','B','o','x',' ','b','u','i','l','d',' ','\x9e','\x05','\xb2','r','a','w','-','m','o','d','e','.',
/* 0x10db8 = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x10dd4 = "VERR_GVMM_VM_STRUCT_NOT_PAGE_ALIGNED" */
    '\x01','G','V','M','M','_','\xd0','_','S','T','R','U','C','T','_','\x15','P','A','G','E','_','A','L','I','G','N','E','D',
/* 0x10df0 = "Recompiler: Variable management internal processing error #12." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','2','.',
/* 0x10e0c = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x24',
/* 0x10e28 = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xc3','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x10e44 = "Unable to establish trusted of VM process (2)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','2',')','.',
/* 0x10e60 = "No validation entry in the boot catalog." */
    '\xce','v','a','l','i','d','a','t','i','o','n',' ','\xb7','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x10e7c = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xae','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x10e98 = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\xa3','\xc3','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0x10eb4 = "Invalid entry in the driver registration structure." */
    '\x0b','\xb7','\x0d','\x02','\xa9','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x10ed0 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','F','L','A','G','S',
/* 0x10eec = "The guest LDT selector is out of bounds." */
    '\x03','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x10f08 = "Syntax error - the specified function is not a function." */
    '\xe2','\x07','-',' ','\x02','\x16','f','u','n','c','t','i','o','n',' ','\x09','\x05','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x10f24 = "Unable to establish trusted of VM process (5)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','5',')','.',
/* 0x10f40 = "Generic failure during disassembly." */
    '\x96','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x10f5c = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\x0f','B','O','O','T','_','M','E','D','I','A','_','T','Y','P','E',
/* 0x10f78 = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x10f94 = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xc6','\x98','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xc9','t','a','b','l','e','.',
/* 0x10fb0 = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','\xe1','c','a','c','h','e',' ','\x0e','p','h','y','s','i','c','a','l',' ','\x5c','\x24',
/* 0x10fcc = "Unable to establish trusted of VM process (4)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','4',')','.',
/* 0x10fe8 = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\xe7','V','P','_','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x11004 = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x1a','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x11020 = "Invalid (malformed) file/path name." */
    '\x0b','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x1103c = "Bogus allocation descriptor length field value in an allocation extent descriptor." */
    'B','o','g','u','s',' ','\xfa','\xcd','l','e','n','g','t','h',' ','\xf5','\xd1','\x0d','\x60','\xfa','e','x','t','e','n','t',' ','\xf4',
/* 0x11058 = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\xe7','V','P','_','\x15','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x11074 = "Unknown X.509 certificate signature algorithm." */
    '\xd8','X','.','5','0','9',' ','\x8a','s','i','g','n','a','t','u','r','e',' ','a','l','g','o','r','i','t','h','m','.',
/* 0x11090 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x110ac = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x09','l','o','c','k','e','d',' ','\x2a','\xba','\x8f','u','n','m','o','u','n','t','e','d','.',
/* 0x110c8 = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xf7','\x0f','U','N','I','V','E','R','S','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x110e4 = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','\xb6','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x11100 = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x88','\x1e','\x02','U','S','B',' ','\x8b','\xf8','\x10','\x05','\x7d',
/* 0x1111c = "Severely compromised digest." */
    'S','e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x11138 = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xae','\x18','m','a','g','i','c',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x11154 = "Encountered an unexpected attribute form." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x11170 = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x1118c = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xf6','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x111a8 = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x05','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x111c4 = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x111e0 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x111fc = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x11218 = "The device instance have no base interface." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xed','\xeb','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x11234 = "Invalid format of managed object reference." */
    '\x0b','f','o','r','m','a','t',' ','\x14','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x11250 = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','M','I','S','S','I','N','G','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x1126c = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xc4','\xda','u','s','e','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','i','s','n','\'','t',' ','\x95',
/* 0x11288 = "The specified disk or diskette cannot be accessed." */
    '\x03','\x16','d','i','s','k',' ','\x86','d','i','s','k','e','t','t','e',' ','\xba','\x8f','a','c','c','e','s','s','e','d','.',
/* 0x112a4 = "A non-directory entry has a name ending with a slash." */
    'A',' ','n','o','n','-','\x19','\xb7','\x1d','a',' ','\xf8','e','n','d','i','n','g',' ','\x1c','a',' ','s','l','a','s','h','.',
/* 0x112c0 = "Recompiler: Variable management internal processing error #11." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','1','.',
/* 0x112dc = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x93',
/* 0x112f8 = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x05','\x7d',
/* 0x11314 = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9c','M','A','N','Y','_','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x11330 = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x1134c = "Unable to establish trusted of VM process (3)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','3',')','.',
/* 0x11368 = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','V','M','X','_','\xd4','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','T','Y','P','E',
/* 0x11384 = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x113a0 = "Recompiler: Variable management internal processing error #10." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','0','.',
/* 0x113bc = "Unable to establish trusted of VM process (1)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd0',' ','\x82','(','1',')','.',
/* 0x113d8 = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x1a','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x113f4 = "Unexpected NULL pointer to left subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x11410 = "Recompiler: No temporary host register available." */
    '\x11','\xce','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xbd','a','v','a','i','l','a','b','l','e','.',
/* 0x1142c = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\xaa','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0x11448 = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','\xae','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcf',
/* 0x11464 = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x9c','B','I','G',
/* 0x11480 = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\x86','e','x','t','e','n','s','i','o','n',' ','\x09','\x8d','l','o','n','g','.',
/* 0x1149c = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x93',
/* 0x114b8 = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x114d4 = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xa2','p','a','r','m','a','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x114f0 = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xbd','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x1150c = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x11528 = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x11544 = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x90','\xc4','\xdf','\x9e','\x05','\xe4','\x02','\xc4','a','l','g','o','r','i','t','h','m','.',
/* 0x11560 = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x15','C','R','E','A','T','E',
/* 0x1157b = "Internal ISO maker error: Read file data probem #1." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','R','e','a','d',' ','\x18','\x90','p','r','o','b','e','m',' ','#','1','.',
/* 0x11596 = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x115b1 = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x8b','i','/','o',' ','\x7b',
/* 0x115cc = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\xe8','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x115e7 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x11602 = "Generic object was destroyed by the call status." */
    '\x96','\x8e','\x10','d','e','s','t','r','o','y','e','d',' ','\xb9','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x1161d = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x11638 = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x11653 = "Reason for leaving RZ: Emulate instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x1166e = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x05','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x11689 = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\xaa','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','I','N','I','T','_','\x9d',
/* 0x116a4 = "Too many references: can\'t splice." */
    '\xee','\xa4','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x116bf = "Recompiler: Variable management internal processing error #1." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','.',
/* 0x116da = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\x89','\x09','\x05','\x95',
/* 0x116f5 = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','O','P','T','I','C','A','L','_','\x9c','S','M','A','L','L',
/* 0x11710 = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x1172b = "Recompiler: Variable management internal processing error #5." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','5','.',
/* 0x11746 = "Recompiler: Register allocator internal processing error #10." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','0','.',
/* 0x11761 = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','V','E','R','S','I','O','N',
/* 0x1177c = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x14','\x02','h','o','s','t',' ','\x09','\x05','\xf2','y','e','t','.',
/* 0x11797 = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x117b2 = "Process Verification Failure: There are too many DLLs loaded." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','a','r','e',' ','\x8d','\xa4','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x117cd = "Reason for leaving RC: Inject a TRPM event." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x117e8 = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x94','f','i','n','i','s','h','e','d','.',
/* 0x11803 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x1181e = "The image is too small or too large for this format." */
    '\x03','\x1b','\x09','\x8d','s','m','a','l','l',' ','\x86','\x8d','l','a','r','g','e',' ','\x0e','\xcb','f','o','r','m','a','t','.',
/* 0x11839 = "Invalid image relative virtual address." */
    '\x0b','\x1b','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x11854 = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x9c','M','A','N','Y','_','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x1186f = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\xaa','K','E','Y','_','M','I','S','S','I','N','G','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x1188a = "Recompiler: Variable management internal processing error #9." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','9','.',
/* 0x118a5 = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','T','Y','P','E','_','\x9d',
/* 0x118c0 = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x118db = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc9','\xda','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x118f6 = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','P','A','T','H','S','_','I','N','T','E','R','N','A','L','_','\x9d',
/* 0x11911 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x1192c = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x90','a','v','a','i','l','a','b','l','e','.',
/* 0x11947 = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb6','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x11962 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x15','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x1197d = "The guest has not setup use of the hypercalls." */
    '\x03','\xa1','\x1d','\x05','s','e','t','u','p',' ','u','s','e',' ','\x14','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x11998 = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x15','P','R','E','S','E','N','T',
/* 0x119b3 = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','S','U','P','L','I','B','_','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x119ce = "Unexpected ASN.1 tag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x119e9 = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','s','i','g','n','a','t','u','r','e','.',
/* 0x11a04 = "Process Verification Failure: A DLL was found more than once." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','\xfc','t','h','a','n',' ','o','n','c','e','.',
/* 0x11a1f = "No memory available for page table or page directory." */
    '\xce','\x5c','a','v','a','i','l','a','b','l','e',' ','\x0e','\xab','\x9f','\x86','\xab','d','i','r','e','c','t','o','r','y','.',
/* 0x11a3a = "Internal error obtaining the GVMM instance." */
    '\x06','\x07','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x11a55 = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x11a70 = "Bad iterdata2 (EXEPACK2) data." */
    '\x92','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x11a8b = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','\xf5','\x0d','\x02','t','a','r',' ','\xe9',
/* 0x11aa6 = "Invalid environment variable name." */
    '\x0b','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x11ac1 = "Recompiler: Register allocator internal processing error #12." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','2','.',
/* 0x11adc = "VFS chain element expected at least one argument." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x11af7 = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xba','\x8f','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x11b12 = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x11b2d = "Recompiler: Variable management internal processing error #2." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','2','.',
/* 0x11b48 = "Recompiler: Variable management internal processing error #6." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','6','.',
/* 0x11b63 = "Internal processing error in the PGM physical handler code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x11b7e = "The size of the raw image is not dividable by 2048." */
    '\x03','\xdf','\x14','\x02','r','a','w',' ','\x1b','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','2','0','4','8','.',
/* 0x11b99 = "Failed to calculate the TSC frequency." */
    '\x80','\x08','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x11bb4 = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x11bcf = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\xa3','\xc3','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x11bea = "Invalid UTF-8 encoding in the response." */
    '\x0b','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0d','\x02','r','e','s','p','o','n','s','e','.',
/* 0x11c05 = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xf7','\x0f','V','I','D','E','O','T','E','X','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x11c20 = "No more search handles available." */
    '\xce','\xfc','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x11c3b = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','L','D','R','V','I','_','\xb6','M','E','M','O','R','Y','_','P','A','R','S','E','_','O','U','T','P','U','T',
/* 0x11c56 = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','L','D','R','M','A','C','H','O','_','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x11c71 = "Internal ISO maker error: Read file data probem #2." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','R','e','a','d',' ','\x18','\x90','p','r','o','b','e','m',' ','#','2','.',
/* 0x11c8c = "Non-string object inside X.509 name object." */
    'N','o','n','-','\xc9','\x8e','i','n','s','i','d','e',' ','X','.','5','0','9',' ','\xf8','o','b','j','e','c','t','.',
/* 0x11ca7 = "Image Verification Failure: Error reading file for hashing." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','\x18','\x0e','h','a','s','h','i','n','g','.',
/* 0x11cc2 = "Failed to get the delta-adjusted TSC value." */
    '\x80','\x08','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xd2',
/* 0x11cdd = "Recompiler: Variable management internal processing error #7." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','7','.',
/* 0x11cf8 = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','F','I','L','E','_','F','O','R','M','A','T',
/* 0x11d13 = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x11d2e = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','\xf5','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x11d49 = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x11d64 = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x1a','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x11d7f = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x11d9a = "Recompiler: Variable management internal processing error #3." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','3','.',
/* 0x11db5 = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb6','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x11dd0 = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x05','p','e','r','f','o','r','m',' ','\xc0','\x83','\x1e','\x14','\x60','\x13','\x7b',
/* 0x11deb = "Internal ISO maker error: Read file data probem #3." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','R','e','a','d',' ','\x18','\x90','p','r','o','b','e','m',' ','#','3','.',
/* 0x11e06 = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\x8d','s','m','a','l','l',' ','\x08','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x11e21 = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x11e3c = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x11e57 = "Bad VTG probe location record." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x11e72 = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\xa5','_','\xdb','O','N','L','Y','_','F','I','L','E','_','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x11e8d = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x11ea8 = "The size field should be zero for links and symlinks." */
    '\x03','\xdf','\xf5','\xef','\x8f','z','e','r','o',' ','\x0e','l','i','n','k','s',' ','\x2a','s','y','m','l','i','n','k','s','.',
/* 0x11ec3 = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\xa3','\xc3','D','O','T','_','D','I','R','_','R','E','C','_','\xa0','N','A','M','E','_','L','E','N','G','T','H',
/* 0x11ede = "Recompiler: Register allocator internal processing error #11." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','1','.',
/* 0x11ef9 = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','F','I','L','E','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x11f14 = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xc6','\x98','\x60','\x81','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x11f2f = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x05','\x7d',
/* 0x11f4a = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','X','5','0','9','_','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x11f65 = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',
/* 0x11f80 = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x11f9b = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x9d',
/* 0x11fb6 = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xab','\x89','i','s','n','\'','t',' ','R','A','M','.',
/* 0x11fd1 = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x11fec = "Invalid CPUMCPU offset in MSR range." */
    '\x0b','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0d','M','S','R',' ','r','a','n','g','e','.',
/* 0x12007 = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\xdd','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x12022 = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xae','\x18','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x1203d = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','B','O','X','_','V','E','R','S','I','O','N',
/* 0x12058 = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x18','i','/','o',' ','\x7b',
/* 0x12073 = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x09','\x05','\xf2','y','e','t','.',
/* 0x1208e = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xf7','C','U','R','S','O','R','_','\xa0','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x120a9 = "Error while parsing UUID string." */
    '\xad','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x120c4 = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\xa3','\xc3','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x120df = "Invalid ASN.1 BMP STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','M','P',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x120fa = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x81','\x18','s','e','t',' ','\xcd','l','o','c','a','t','i','o','n','.',
/* 0x12115 = "NEM failed to map page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x12130 = "Syntax error - unbalanced parenthesis." */
    '\xe2','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x1214b = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x12166 = "Invalid ASN.1 IA5 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','I','A','5',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x12181 = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x09','\x8d','s','h','o','r','t',' ','\x08','\x8f','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x1219c = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x121b7 = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\xa5','_','\xdb','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x121d2 = "Expected URI using the \'file:\' scheme." */
    '\xa7','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x121ed = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9c','M','A','N','Y','_','A','R','G','U','M','E','N','T','S',
/* 0x12208 = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xab','\x1c','\x60','\x81','P','a','g','e',' ','I','D','.',
/* 0x12223 = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x1223e = "Internal ISO maker error: Unexpected empty component." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','\x85','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x12259 = "Recompiler: Register allocator internal processing error #13." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','3','.',
/* 0x12274 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x15','\xb4',
/* 0x1228f = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0d','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x122aa = "Recompiler: Variable management internal processing error #4." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','4','.',
/* 0x122c5 = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','P','A','R','A','M','S','_','\x15','I','M','P','L',
/* 0x122e0 = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','V','E','R','S','I','O','N',
/* 0x122fb = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x15','\xb4',
/* 0x12316 = "Recompiler: Variable management internal processing error #8." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','8','.',
/* 0x12331 = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x1234c = "Too many loops looking for a page to reuse." */
    '\xee','\xa4','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x0e','a',' ','\xab','\x08','r','e','u','s','e','.',
/* 0x12367 = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','c','l','o','n','e',' ','\x02','\xc4','\xbf','c','o','n','t','e','x','t','.',
/* 0x12382 = "VERR_ISOMK_IMPORT_UDF_FILE_WITH_STREAM_DIR" */
    '\x01','\xa3','\xc3','U','D','F','_','F','I','L','E','_','W','I','T','H','_','S','T','R','E','A','M','_','D','I','R',
/* 0x1239d = "Invalid ASN.1 BIT STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','I','T',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x123b8 = "The specified at reset handler wasn\'t found." */
    '\x03','\x16','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x123d3 = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','S','T','A','T','E',
/* 0x123ee = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9c','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x12408 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x12422 = "Recompiler: Register allocator internal processing error #7." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','7','.',
/* 0x1243c = "Import ISO contains a bad supplementary volume descriptor." */
    '\xb1','\xb3',' ','\x7f','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xf4',
/* 0x12456 = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xae','\x18','\xdf','d','i','d','n','\'','t',' ','\xe4','\x02','o','n','e',' ','\x0d','\x02','\xe9',
/* 0x12470 = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x0f','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x1248a = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xf6',' ','\x1d','\xeb','\xfc','f','r','e','e',' ','\xac','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x124a4 = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x124be = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x09','o','u','t',' ','\x14','\xd0',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x124d8 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x09','\x05','u','p',' ','\x08','d','a','t','e',' ','\x1c','\x02','i','m','a','g','e','.',
/* 0x124f2 = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xf7','\x0f','G','E','N','E','R','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1250c = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9c','M','A','N','Y','_','W','R','I','T','E','R','S',
/* 0x12526 = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9c','M','A','N','Y','_','\xf9','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x12540 = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x1b','\xab','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x1255a = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    'V','W','R','N','_','E','N','V','_','\x15','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x12574 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb6','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x1258e = "Recompiler: Register allocator internal processing error #9." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','9','.',
/* 0x125a8 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xf7','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G','_','\x15','I','M','P','L',
/* 0x125c2 = "Image Verification Failure: Error reading section headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','\xc8','h','e','a','d','e','r','s','.',
/* 0x125dc = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\xe7','V','P','_','\xa0','F','I','L','E','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x125f6 = "Recompiler: Register allocator internal processing error #5." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','5','.',
/* 0x12610 = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\x9f','\x14','\xd9','\xc9','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','\xe4','\x02','\xdf','\x16','\x0d','\x02','\xe9',
/* 0x1262a = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xbb','\x1c','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x12644 = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\xa3','\xc3','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x1265e = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xab','\x09','c','a','c','h','e','d','.',
/* 0x12678 = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x1a','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x12692 = "The size of the raw image is not dividable by 512." */
    '\x03','\xdf','\x14','\x02','r','a','w',' ','\x1b','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','5','1','2','.',
/* 0x126ac = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\x89','c','a','u','s','e','s',' ','D','B','G','C',' ','\x08','q','u','i','t','.',
/* 0x126c6 = "Import ISO uses invalid volume sequence number." */
    '\xb1','\xb3',' ','u','s','e','s',' ','\x81','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x126e0 = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\xe7','V','P','_','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x126fa = "VFS chain element expected at most one argument." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x12714 = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x1272e = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x9c','L','O','N','G',
/* 0x12748 = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x0f','K','E','Y','_','R','A','N','G','E',
/* 0x12762 = "Recompiler: Register allocator internal processing error #4." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','4','.',
/* 0x1277c = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\xe7','V','P','_','S','E','C','T','I','O','N','_','\x15','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x12796 = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x127b0 = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\xb6','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x127ca = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\xf1','E','M','I','T','_','C','A','S','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x127e4 = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xf7','\x0f','V','I','S','I','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x127fe = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x7b',
/* 0x12818 = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x12832 = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x1284c = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x12866 = "Can\'t delete bucket with keys." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x1c','k','e','y','s','.',
/* 0x12880 = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xf7','\x0f','G','R','A','P','H','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1289a = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x128b4 = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x9c','M','U','C','H',
/* 0x128ce = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\x03','u','r','g','e',' ','\x08','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x128e8 = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xc6','\x98','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x12902 = "Internal processing error in the debug module reader code." */
    '\x06','\x04','\x07','\x0d','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x1291c = "Recompiler: Register allocator internal processing error #8." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','8','.',
/* 0x12936 = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','S','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x12950 = "Name is not unique on the network." */
    'N','a','m','e',' ','\x09','\x05','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x1296a = "No page directory available for the hypervisor." */
    '\xce','\xab','\x19','a','v','a','i','l','a','b','l','e',' ','\x0e','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x12984 = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x1299e = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x129b8 = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe7','V','P','_','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x129d2 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x129ec = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x12a06 = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x1a','\xf1','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x12a20 = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x12a3a = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x14','\x02','s','a','v','e','d',' ','\xae','\x18','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x12a54 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x12a6e = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x90','\x08','c','h','e','c','k',' ','\xcd','C','R','C','.',
/* 0x12a88 = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x12aa2 = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9c','M','A','N','Y','_','R','E','A','D','E','R','S',
/* 0x12abc = "Recompiler: Register allocator internal processing error #2." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','2','.',
/* 0x12ad6 = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x12af0 = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x12b0a = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x1a','S','S','M','_','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0x12b24 = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','\x9c','M','A','N','Y','_','P','R','O','B','E','S',
/* 0x12b3e = "Recompiler: Register allocator internal processing error #1." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','.',
/* 0x12b58 = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb6','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x12b72 = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','\xdf','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x12b8c = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xf7','\x0f','N','U','M','E','R','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12ba6 = "Process Verification Failure: Error querying image information." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y','i','n','g',' ','\x1b','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x12bc0 = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe7','V','P','_','F','R','E','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x12bda = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','\xdc','p','o','s','t','e','d',' ','\x09','\x05','c','o','r','r','e','c','t','.',
/* 0x12bf4 = "Requested service does not exist." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x9e','\x05','e','x','i','s','t','.',
/* 0x12c0e = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xf7','C','U','R','S','O','R','_','\x9c','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x12c28 = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x22','e','x','i','s','t','s','.',
/* 0x12c42 = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x1a','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0x12c5c = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x12c76 = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\xa0','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x12c90 = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x17','\x0c','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x18','\xf8','\x2a','\x82','\x1b','\xf8','\x9e','\x05','\xe4','u','p','.',
/* 0x12caa = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','V','D','_','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x12cc4 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x82','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x12cde = "Expression stack overflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x12cf8 = "Image Verification Failure: Error reading image headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','\x1b','h','e','a','d','e','r','s','.',
/* 0x12d12 = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x12d2c = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','\x05','e','x','p','e','c','t','e','d','.',
/* 0x12d46 = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x12d60 = "Recompiler: Register allocator internal processing error #6." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','6','.',
/* 0x12d7a = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\xe8','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x12d94 = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\xaa','P','K','C','S','7','_','\xb6','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x12dae = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xae','i','n','v','a','l','i','d','.',
/* 0x12dc8 = "Generic debugger command failure." */
    '\x96','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x12de2 = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','N','E','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x12dfc = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\xa0','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12e16 = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','N','A','M','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x12e30 = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\xe7','V','P','_','\xa0','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','S','I','Z','E',
/* 0x12e4a = "Recompiler: Totally unexpected memory size." */
    '\x11','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x5c','s','i','z','e','.',
/* 0x12e64 = "Descriptor tag is all zeros." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x12e7e = "Too many instances of a usb device." */
    '\xee','\xa4','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x12e98 = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x1a','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x12eb2 = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x12ecc = "Internal processing error in the PGM handy page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','h','a','n','d','y',' ','\xab','a','l','l','o','c','a','t','o','r','.',
/* 0x12ee6 = "NEM failed to query dirty page bitmap." */
    'N','E','M',' ','\x88','\x08','q','u','e','r','y',' ','d','i','r','t','y',' ','\xab','b','i','t','m','a','p','.',
/* 0x12f00 = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x7b',
/* 0x12f1a = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xf7','S','T','R','I','N','G','_','T','Y','P','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x12f34 = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','V','D','_','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x15','M','E','T',
/* 0x12f4e = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\xa5','_','\xdb','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0x12f68 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x1d','\x8d','\xa4','r','e','g','i','o','n','s','.',
/* 0x12f82 = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\xa3','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x12f9c = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x12fb6 = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x93',
/* 0x12fd0 = "Recompiler: Register allocator internal processing error #3." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','3','.',
/* 0x12fea = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\xe7','V','P','_','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x93',
/* 0x13004 = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\xa3','\xc3','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E','_','\x15','2','K','B',
/* 0x1301e = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xc5','l','o','c','k',' ','\x10','l','o','s','t','.',
/* 0x13038 = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x18','\x08','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x13052 = "Recompiler: Failed to allocate more memory for debug info." */
    '\x11','\x80','\x08','a','l','l','o','c','a','t','e',' ','\xfc','\x5c','\x0e','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x1306c = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\xe7','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','N','X','_','C','O','M','P','A','T',
/* 0x13086 = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xae','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x130a0 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x130ba = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x130d3 = "Internal SPC error: Bad object moniker data pointer." */
    '\x06','S','P','C',' ','\xc5','\x92','\x8e','m','o','n','i','k','e','r',' ','\x90','p','o','i','n','t','e','r','.',
/* 0x130ec = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\x8f','d','e','l','e','t','e','d','.',
/* 0x13105 = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','M','A','G','I','C',
/* 0x1311e = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xf7','C','U','R','S','O','R','_','\xa0','L','E','N','G','T','H','_','E','N','C','O','D','I','N','G',
/* 0x13137 = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x13150 = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x05','\x7d',
/* 0x13169 = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x13182 = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x1a','\xf6','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x1319b = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','S','U','P','L','I','B','_','\x0f','I','N','T','E','R','N','A','L','_','A','P','P','_','D','I','R',
/* 0x131b4 = "Encountered a init function section." */
    '\x97','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x131cd = "Process Verification Failure: Image section region is too large." */
    '\x17','\x0c','\x12','I','m','a','g','e',' ','\xc8','r','e','g','i','o','n',' ','\x09','\x8d','l','a','r','g','e','.',
/* 0x131e6 = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x131ff = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','M','I','S','S','I','N','G',
/* 0x13218 = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x1a','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x13231 = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','V','M','X','_','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x1324a = "No default entry in the boot catalog." */
    '\xce','d','e','f','a','u','l','t',' ','\xb7','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x13263 = "Bad iterdata (EXEPACK) data." */
    '\x92','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x1327c = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\x8f','r','e','s','o','l','v','e','d','.',
/* 0x13295 = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x93',
/* 0x132ae = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xf6','_','B','P','_','O','W','N','E','R','_','\xb6','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x132c7 = "The request function is not implemented." */
    '\x03','\x94','f','u','n','c','t','i','o','n',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x132e0 = "Bad DWARF abbreviation data." */
    '\x92','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x132f9 = "Unexpected ASN.1 fake/dummy object." */
    '\x85','A','S','N','.','1',' ','f','a','k','e','/','d','u','m','m','y',' ','o','b','j','e','c','t','.',
/* 0x13312 = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','s','e','t','.',
/* 0x1332b = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x88','\x7b',
/* 0x13344 = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xf7','O','B','J','I','D','_','\x9c','L','O','N','G','_','S','T','R','I','N','G','_','F','O','R','M',
/* 0x1335d = "Bad length element in table of content sub-element." */
    '\x92','l','e','n','g','t','h',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x13376 = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xf9','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x1338f = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xf9',' ','\xbd','r','e','a','d',',',' ','f','i','l','l',' ','\x1c','0','0','.',
/* 0x133a8 = "Too deep walk during lookup." */
    '\xee','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x133c1 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\xf1','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb6','F','R','E','E','_','T','M','P',
/* 0x133da = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\xaa','P','K','I','X','_','H','A','S','H','_','\x9c','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x133f3 = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x1340c = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x13425 = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x1343e = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\xe7','V','P','_','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x9d',
/* 0x13457 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x0f','I','D',
/* 0x13470 = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x13489 = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x1a','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x134a2 = "Unsupported PKCS #7 signed data version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x90','v','e','r','s','i','o','n','.',
/* 0x134bb = "The VFS chain specification is empty." */
    '\x03','\xa5',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x09','e','m','p','t','y','.',
/* 0x134d4 = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\xa3','F','I','L','E','_','\x9c','B','I','G','_','R','E','Q','_','\xb3','_','L','E','V','E','L','_','3',
/* 0x134ed = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x09','\x22','e','n','g','a','g','e','d','.',
/* 0x13506 = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','\xe1','n','a','m','e','.',
/* 0x1351f = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\xa5','_','\xdb','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\xa5',
/* 0x13538 = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x13551 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x09','\x05','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','e','v','i','c','e','.',
/* 0x1356a = "Encountered a term function section." */
    '\x97','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x13583 = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x1a','\xb8','\xb6','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x1359c = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\xaa','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x15','K','N','O','W','N',
/* 0x135b5 = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x17','\x0c','\x12','\x03','\x82','\x1d','\x8d','\xa4','v','i','r','t','u','a','l',' ','\x5c','r','e','g','i','o','n','s','.',
/* 0x135ce = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x135e7 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x1a','\xd7','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x13600 = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\xdd','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x13619 = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','S','S','M','_','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x13632 = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','I','Z','E','_','I','N','V','A','L','I','D',
/* 0x1364b = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x93',
/* 0x13664 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\xaa','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x1367d = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xda','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x13696 = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\xe7','V','P','_','\x9c','M','A','N','Y','_','M','E','M','O','R','Y','_','R','E','G','I','O','N','S',
/* 0x136af = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\xb8','C','F','G','_','M','I','S','S','I','N','G','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x136c8 = "Import ISO contains more than one el torito descriptor." */
    '\xb1','\xb3',' ','\x7f','\xfc','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','\xf4',
/* 0x136e1 = "Image Verification Failure: Invalid security directory entry." */
    'I','m','a','g','e',' ','\x0c','\x12','\x0b','s','e','c','u','r','i','t','y',' ','\x19','e','n','t','r','y','.',
/* 0x136fa = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','\xb6','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x13713 = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x1372c = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x13745 = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x1375e = "Failed to get underlying link ID." */
    '\x80','\x08','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x13777 = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x13790 = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x137a9 = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x1a','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x137c2 = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x137db = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x8c','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x137f4 = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x1380d = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x13826 = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x1383f = "ASN.1 bit string object is out of bounds." */
    'A','S','N','.','1',' ','b','i','t',' ','\xc9','\x8e','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x13858 = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x18','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x13871 = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','A','L','L','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x1388a = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\xe7','V','P','_','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x138a3 = "VFS chain element takes exactly three arguments." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xca',
/* 0x138bc = "A digest doesn't match the corresponding file." */
    'A',' ','\xc4','\xa6','\xe4','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x138d5 = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','L','D','R','M','A','C','H','O','_','O','T','H','E','R','_','E','N','D','I','A','N','_','\x15','\xc7',
/* 0x138ee = "Reason for leaving RC: Encountered a stale selector." */
    '\x84','\x0e','\x25','R','C',':',' ','\x97','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x13907 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\xf1','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb6','F','R','E','E','_','V','A','R',
/* 0x13920 = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x13939 = "Bad offset element in table of content sub-element." */
    '\x92','o','f','f','s','e','t',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x13952 = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','X','5','0','9','_','\xb6','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x1396b = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x13984 = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x9c','M','A','N','Y','_','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x1399d = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x139b6 = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','P','A','G','E','_','M','A','P','_','L','E','V','E','L','4','_','\x15','P','R','E','S','E','N','T',
/* 0x139cf = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x139e8 = "Invalid ASN.1 UTC TIME encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','C',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x13a01 = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x13a1a = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\xe7','V','P','_','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x13a33 = "Not more data in ASN.1 byte stream." */
    'N','o','t',' ','\xfc','\x90','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x13a4c = "Encountered an unknown attribute form." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x13a65 = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','P','A','G','E','_','T','A','B','L','E','_','B','I','T','S',
/* 0x13a7e = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xd0',
/* 0x13a97 = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x13ab0 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\xf1','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x13ac9 = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x1a','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x13ae2 = "Invalid object ID in managed object reference." */
    '\x0b','\x8e','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x13afb = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb6','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x13b14 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x9c','B','I','G',
/* 0x13b2d = "VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD" */
    '\x01','\xe8','B','O','G','U','S','_','U','D','F','_','D','S','T','R','I','N','G','_','F','I','E','L','D',
/* 0x13b46 = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\xa5','_','\xdb','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x13b5f = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x13b78 = "Certificate path builder: Encountered bad certificate context." */
    '\xa8','\xbc','b','u','i','l','d','e','r',':',' ','\x97','b','a','d',' ','\x8a','c','o','n','t','e','x','t','.',
/* 0x13b91 = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xf7','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x99',
/* 0x13baa = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x13bc3 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xc6','\xa6','g','r','o','k',' ','\x02','C','O','M',' ','\xcd','\x90','\x19','e','n','t','r','y','.',
/* 0x13bdc = "Too many I/O port registrations." */
    '\xee','\xa4','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x13bf5 = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x13c0e = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','V','E','R','S','I','O','N','_','\x9c','L','O','N','G',
/* 0x13c27 = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x13c40 = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x13c59 = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\xe7','V','P','_','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x99',
/* 0x13c72 = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x9c','M','A','N','Y','_','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x13c8b = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\xb8','\xb6','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x13ca4 = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','a',' ','\xb5','s','e','t',' ','\xc1','\x09','\x05','\x95',
/* 0x13cbd = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x13cd6 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x13cef = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x88','\x08','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','\xfb',
/* 0x13d08 = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xf9',' ','\xbd','r','e','a','d',',',' ','f','i','l','l',' ','\x1c','F','F','.',
/* 0x13d21 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\xb8','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x15','P','O','S','S','I','B','L','E',
/* 0x13d3a = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','\xf5','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x13d53 = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xab','m','a','p',' ','\xb7','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x13d6c = "The instruction is not yet implemented by IEM." */
    '\x03','\xbb','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x13d85 = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xf7','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x13d9e = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x13db7 = "Bad SPC object moniker UUID field." */
    '\x92','S','P','C',' ','\x8e','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x13dd0 = "Unsupported CPU feature combination." */
    '\x87','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x13de9 = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x13e02 = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x13e1b = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','\x9c','M','A','N','Y','_','A','R','G','S','_','I','P','E',
/* 0x13e34 = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','S','M','X','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x13e4d = "Internal processing error #1 in the DBGF event tracing code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf6',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x5e',
/* 0x13e66 = "Failed to fstat a native handle (hardening)." */
    '\x80','\x08','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x13e7f = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\xaa','P','K','C','S','7','_','\xe0','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M',
/* 0x13e98 = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x13eb1 = "Failed to read the device table entry due to an invalid offset." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9f','\xb7','d','u','e',' ','\x08','\x60','\x81','o','f','f','s','e','t','.',
/* 0x13eca = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x13ee3 = "Encountered a section type that\'s not implemented." */
    '\x97','a',' ','\xc8','\xda','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x13efc = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x13f15 = "No guest mappings when SMP is enabled." */
    '\xce','\xa1','m','a','p','p','i','n','g','s',' ','\xf3','S','M','P',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x13f2e = "Generic dangling objects status." */
    '\x96','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x13f47 = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x13f60 = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\xaa','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x9d',
/* 0x13f79 = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x13f92 = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\xa0','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x13fab = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','N','E','M','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x93',
/* 0x13fc4 = "Internal processing error: Not build certificate." */
    '\x06','\x04','\xc5','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x13fdd = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xc6','\x98','\x60','\x81','s','y','m','b','o','l',' ','\xf8','o','f','f','s','e','t','.',
/* 0x13ff5 = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1400d = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x14025 = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','I','R','_','M','A','G','I','C',
/* 0x1403d = "Bad symbol table size in Mach-O image." */
    '\x92','s','y','m','b','o','l',' ','\x9f','\xdf','\x0d','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x14055 = "The file is not a valid NM map file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x1406d = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x10','\x05','\x0d','\x02','c','o','r','r','e','c','t',' ','\xae','\x0e','\x02','\x94','\xcf',
/* 0x14085 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\xe7','V','P','_','\xb6','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x1409d = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','L','D','R','V','I','_','\xb6','M','E','M','O','R','Y','_','S','I','G','N','A','T','U','R','E',
/* 0x140b5 = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x140cd = "Invalid UTF-16 escape sequence." */
    '\x0b','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x140e5 = "VFS chain element takes exactly four arguments." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xca',
/* 0x140fd = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\xb6','I','B','A','S','E',
/* 0x14115 = "Unable to lock a region of a file." */
    '\xcc','\x08','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x14','a',' ','f','i','l','e','.',
/* 0x1412d = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x14145 = "Bad ASN.1 object length encoding." */
    '\x92','A','S','N','.','1',' ','\x8e','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x1415d = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xf7','O','B','J','I','D','_','\x9c','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x14175 = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\xf1','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x1418d = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x10','\x05','\x7d',
/* 0x141a5 = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x141bd = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x141d5 = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x141ed = "Too many partition descriptors." */
    '\xee','\xa4','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x14205 = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x9b','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x1421d = "Failed to read the device table entry from guest memory." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9f','\xb7','f','r','o','m',' ','\xa1','m','e','m','o','r','y','.',
/* 0x14235 = "Unknown digest algorithm used by PKCS #7 object." */
    '\xd8','\xc4','\xbf','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x1424d = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','V','D','_','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x14265 = "VFS chain element expected non-empty argument." */
    '\xa5',' ','\x91','\x1f','\xb0','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x1427d = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x14295 = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x142ad = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\xd7','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x142c5 = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\xe7','V','P','_','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x9c','L','A','R','G','E',
/* 0x142dd = "Unexpected interruption exit type." */
    '\x85','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x142f5 = "Generic out of resources warning." */
    '\x96','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x1430d = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','\xea','f','i','l','e','.',
/* 0x14325 = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0x1433d = "Invalid host interface version." */
    '\x0b','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x14355 = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xd3','e','n','t','r','y','.',
/* 0x1436d = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','P','A','D','D','I','N','G','_','S','I','Z','E',
/* 0x14385 = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','\xe0','A','T','T','R','I','B','U','T','E',
/* 0x1439d = "Unknown or unrecognized SVM exit." */
    '\xd8','\x86','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x143b5 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\xdd','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x143cd = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\xdd','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x9d',
/* 0x143e5 = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0d','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x143fd = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x15','A','T','T','A','C','H','E','D',
/* 0x14415 = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x9c','M','A','N','Y','_','P','E','R','_','\xd0','_','M','O','D','U','L','E','S',
/* 0x1442d = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x0e','\x02','a','d','d','r','e','s','s','.',
/* 0x14445 = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','P','A','G','E','_','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x1445d = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x14475 = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x09','\x05','\xf2','\xb9','\xcb','b','u','i','l','d','.',
/* 0x1448d = "Encountered an unexpected page state in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xab','\xae','\x0d','\x02','s','a','v','e','d',' ','\xfb',
/* 0x144a5 = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x144bd = "The specified address range wraps around." */
    '\x03','\x16','a','d','d','r','e','s','s',' ','\xe5','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x144d5 = "Certificate path validator: Unknown critical certificate extension." */
    '\xa8','\xbc','\xe6','\xd8','c','r','i','t','i','c','a','l',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x144ed = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x14505 = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x1451d = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\xe8','\x9c','M','A','N','Y','_','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x14535 = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x10','\x22','l','o','a','d','e','d','.',
/* 0x1454d = "Terminate search branch." */
    'T','e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x14565 = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\xa3','\xc3','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1457d = "VFS chain element takes exactly five arguments." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xca',
/* 0x14595 = "Invalid ASN.1 INTEGER encoding." */
    '\x0b','A','S','N','.','1',' ','I','N','T','E','G','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x145ad = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x93',
/* 0x145c5 = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x145dd = "Unexpected cURL error configure the proxy." */
    '\x85','c','U','R','L',' ','\x07','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x145f5 = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x9c','M','A','N','Y','_','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x1460d = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x14625 = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x93',
/* 0x1463d = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x14655 = "Invalid ASN.1 BOOLEAN encoding." */
    '\x0b','A','S','N','.','1',' ','B','O','O','L','E','A','N',' ','e','n','c','o','d','i','n','g','.',
/* 0x1466d = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xb5','\xc9','\x09','\x8d','l','o','n','g','.',
/* 0x14685 = "Bad VTG probe enabled data." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x1469d = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xa0','R','E','S','U','L','T','_','T','Y','P','E',
/* 0x146b5 = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x146cd = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x146e5 = "No CR3 root shadow page table." */
    '\xce','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xab','t','a','b','l','e','.',
/* 0x146fd = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x9c','M','A','N','Y','_','P','R','O','V','I','D','E','R','S',
/* 0x14715 = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x1472d = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb6','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x14745 = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x1475d = "VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS" */
    '\x01','\xa3','\xc3','U','D','F','_','D','I','S','C','O','N','T','I','G','U','O','U','S','_','A','D','S',
/* 0x14775 = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x90','\x10','c','o','r','r','u','p','t','e','d','.',
/* 0x1478d = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x1a','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x147a5 = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x15','\xb4',
/* 0x147bd = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9c','M','A','N','Y','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x147d5 = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\xe7','V','P','_','\x9c','M','A','N','Y','_','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0x147ed = "Internal SPC error: Bad object moniker choice value." */
    '\x06','S','P','C',' ','\xc5','\x92','\x8e','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xd2',
/* 0x14805 = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','V','M','X','_','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x1481d = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','\xea','r','e','q','u','e','s','t','e','d','.',
/* 0x14835 = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xb2','\xa9','\xa6','\xe4','\x02','\xb5','\x14','\x02','u','s','e','r','.',
/* 0x1484d = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x14865 = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\xe7','V','P','_','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x93',
/* 0x1487d = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','T','R','I','N','G',
/* 0x14895 = "Invalid segment:offset address." */
    '\x0b','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x148ad = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xd0','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0x148c5 = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x14','\x18','r','e','c','o','r','d',' ','\x10','r','e','a','d','.',
/* 0x148dd = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\xa0','S','H','A','R','E','D','_','M','O','D','U','L','E','_','S','I','Z','E',
/* 0x148f5 = "VINF_RECORDING_LIMIT_REACHED" */
    '\x1a','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x1490d = "No partition descriptors found." */
    '\xce','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x14925 = "Process Verification Failure: Error querying debug port." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x1493d = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\xaa','P','K','I','X','_','\x0f','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x14955 = "Import ISO contains more than one primary volume descriptor." */
    '\xb1','\xb3',' ','\x7f','\xfc','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xbe','\xf4',
/* 0x1496d = "Expected primitive ASN.1 object." */
    '\xa7','p','r','i','m','i','t','i','v','e',' ','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x14985 = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\xd7','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x1499d = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x0f','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x149b5 = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x149cd = "Recompiler: Fixed jump is out of range." */
    '\x11','F','i','x','e','d',' ','j','u','m','p',' ','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x149e5 = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x149fd = "Recompiler: Uninitialized variable." */
    '\x11','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x14a15 = "No buffer space available." */
    '\xce','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x14a2d = "Internal error in the X.509 certificate path building and verification code." */
    '\x06','\x07','\x0d','\x02','X','.','5','0','9',' ','\x8a','\xbc','b','u','i','l','d','i','n','g',' ','\x2a','\xd6','\x5e',
/* 0x14a45 = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x1a','\xa3','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x14a5d = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','F','I','L','E','_','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0X14a75 = "Descriptor CRC mismatch." */
    'e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x14a8c = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x14aa4 = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\xb8','\x9c','M','A','N','Y','_','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x14abc = "Encountered an unexpected page type in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xab','\xda','\x0d','\x02','s','a','v','e','d',' ','\xfb',
/* 0x14ad4 = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x14aec = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','F','L','O','P','P','Y','_','\x9c','B','I','G',
/* 0x14b04 = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','S','S','M','_','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x14b1c = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','\x0f','S','E','C','T','I','O','N','_','S','I','Z','E',
/* 0x14b34 = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x14b4c = "Internal processing error #1 in page access handler code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\xab','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x14b64 = "Unable to make text memory writeable (hardening)." */
    '\xcc','\x08','m','a','k','e',' ','t','e','x','t',' ','\x5c','w','r','i','t','e','a','b','l','e',' ','\x9a',
/* 0x14b7c = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','N','V','E','R','S','I','O','N','_','\x93',
/* 0x14b94 = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x14bac = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\xdd','\xb6','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x14bc4 = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\x89','c','a','n',' ','\x8f','c','a','n','c','e','l','l','e','d','.',
/* 0x14bdc = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd9','\x09','\x05','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x14bf4 = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x9c','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x14c0c = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x15','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x14c24 = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x15','E','N','A','B','L','E','D',
/* 0x14c3c = "Process Verification Failure: An image mapping failed to report a name." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\xe1','\x88','\x08','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x14c54 = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','\xdc','\x0d','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x14c6c = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\xaa','X','5','0','9','_','P','U','B','L','I','C','_','K','E','Y','_','\x9c','S','M','A','L','L',
/* 0x14c84 = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x14c9c = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\xa3','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x14cb4 = "Syntax error - out of scratch memory." */
    '\xe2','\x07','-',' ','o','u','t',' ','\x14','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x14ccc = "FAM failed to open a connection." */
    'F','A','M',' ','\x88','\x08','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x14ce4 = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x14cfc = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x1a','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x14d14 = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\xa3','\xc3','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x14d2c = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x14d44 = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xda','\x0e','s','o','c','k','e','t','.',
/* 0x14d5c = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x14d73 = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\xe7','V','P','_','I','M','A','G','E','_','F','I','L','E','_','C','L','O','S','E','_','\x9d',
/* 0x14d8a = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\xaa','X','5','0','9','_','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x14da1 = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    'V','W','R','N','_','C','S','A','M','_','T','R','A','P','_','\x15','H','A','N','D','L','E','D',
/* 0x14db8 = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xf9','_','R','A','N','G','E',
/* 0x14dcf = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x14de6 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x1a','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x14dfd = "Unable to open the host interface." */
    '\xcc','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x14e14 = "VFS chain element takes exactly six arguments." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xca',
/* 0x14e2b = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x14e42 = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','S','S','M','_','\x9b','D','A','T','A','_','U','N','I','T','_','V','E','R','S','I','O','N',
/* 0x14e59 = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','V','A','R','I','A','B','L','E','_','\x15','\xb4',
/* 0x14e70 = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\xf1','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x14e87 = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x14e9e = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','F','U','N','C','T','I','O','N','_','\x15','\xb4',
/* 0x14eb5 = "VFS chain element takes exactly two arguments." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xca',
/* 0x14ecc = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xda','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x14ee3 = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x15','A','_','F','U','N','C','T','I','O','N',
/* 0x14efa = "VERR_SVM_HOST_SVME_NOT_ENABLED" */
    '\x01','S','V','M','_','H','O','S','T','_','S','V','M','E','_','\x15','E','N','A','B','L','E','D',
/* 0x14f11 = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x1a','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x14f28 = "The specified field is outside the structure." */
    '\x03','\x16','\xf5','\x09','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x14f3f = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x93',
/* 0x14f56 = "No end of central directory record found." */
    '\xce','e','n','d',' ','\x14','c','e','n','t','r','a','l',' ','\x19','r','e','c','o','r','d',' ','\x7d',
/* 0x14f6d = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x8c','\x15','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x14f84 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xe0','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0X14f9b = "Duplicate segment name." */
    'u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x14fb1 = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xa8','\xbc','\xe6','\x03','\x8a','\x09','\x05','v','a','l','i','d',' ','a','t',' ','\x02','\x16','t','i','m','e','.',
/* 0x14fc8 = "VFS chain element takes a file object as input." */
    '\xa5',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x14fdf = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x14ff6 = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\xe7','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x9d',
/* 0x1500d = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','\x9b','V','E','R','S','I','O','N',
/* 0x15024 = "Import ISO contains more than one joliet volume descriptor." */
    '\xb1','\xb3',' ','\x7f','\xfc','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xbe','\xf4',
/* 0x1503b = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x24',
/* 0x15052 = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x15069 = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','S','U','P','L','I','B','_','\x0f','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x15080 = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x15097 = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x1a','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x150ae = "Too many primary volume descriptors." */
    '\xee','\xa4','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x150c5 = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x05','a','l','l','o','w','e','d','.',
/* 0x150dc = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x150f3 = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','L','A','U','N','C','H','_','S','T','A','T','E',
/* 0x1510a = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xf7','T','I','M','E','_','\xa0','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x15121 = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\xb8','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x15138 = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\xaa','X','5','0','9','_','\x0f','N','A','M','E','_','S','T','R','I','N','G','_','T','A','G',
/* 0x1514f = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x88','\x0e','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x15166 = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x93',
/* 0x1517d = "Invalid offset in an L4 dataspace." */
    '\x0b','o','f','f','s','e','t',' ','\x0d','\x60','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x15194 = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x151ab = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x151c2 = "Process Verification Failure: The process has more than one thread." */
    '\x17','\x0c','\x12','\x03','\x82','\x1d','\xfc','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x151d9 = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','V','E','R','S','I','O','N','_','\x99',
/* 0x151f0 = "Failed to get a guest page which is expected to be present." */
    '\x80','\x08','g','e','t',' ','a',' ','\xa1','\xab','\xc1','\x09','\xb0','\x08','\x8f','p','r','e','s','e','n','t','.',
/* 0x15207 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xab','\xe1','\x5e',
/* 0x1521e = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x15235 = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\xb8','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1524c = "Too many logical volume descriptors." */
    '\xee','\xa4','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x15263 = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','V','E','R','S','I','O','N','_','\x15','\xc7',
/* 0x1527a = "There is no tracer present." */
    'T','h','e','r','e',' ','\x09','\xeb','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x15291 = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x152a8 = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','\xf5','\xef','\x05','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x152bf = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x152d6 = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x152ed = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x93',
/* 0x15304 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x1531b = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9d','_','S','I','G','N','A','T','U','R','E',
/* 0x15332 = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x1a','\xd7','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x15349 = "Page directory pointer not present." */
    'P','a','g','e',' ','\x19','p','o','i','n','t','e','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x15360 = "Import ISO contains a bad root directory record." */
    '\xb1','\xb3',' ','\x7f','a',' ','b','a','d',' ','r','o','o','t',' ','\x19','r','e','c','o','r','d','.',
/* 0x15377 = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x1538e = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','R','i','n','g','-','3',' ','\x83','p','e','n','d','i','n','g','.',
/* 0x153a5 = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x153bc = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x1d','\x22','\xaf','r','e','g','i','s','t','e','r','e','d','.',
/* 0x153d3 = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x153ea = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x15401 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x93',
/* 0x15418 = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xab','\xe1','\x5e',
/* 0x1542f = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x15','\xc7','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x15446 = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xc4','\x05','\xf2','\x0d','\xcb','c','o','n','t','e','x','t','.',
/* 0x1545d = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x15474 = "Error formatting an extension." */
    '\xad','f','o','r','m','a','t','t','i','n','g',' ','\x60','e','x','t','e','n','s','i','o','n','.',
/* 0x1548b = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xa2','\x09','\x05','v','a','l','i','d','.',
/* 0x154a2 = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xf8','\x09','\x8d','l','o','n','g','.',
/* 0x154b9 = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','S','I','Z','E',
/* 0x154d0 = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x1d','\x22','\xaf','r','e','g','i','s','t','e','r','e','d','.',
/* 0x154e7 = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','I','O','M','M','U','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x154fe = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x15515 = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xf7','\x0f','U','T','F','8','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1552c = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xab','\xe1','\x5e',
/* 0x15543 = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\xa2','m','a','g','i','c','.',
/* 0x1555a = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xec','\x7b',
/* 0x15571 = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x15588 = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x1559f = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x1b','\xe1','\x09','\x8d','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x155b6 = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','I','m','a','g','e',' ','p','r','o','p','e','r','t','y',' ','\x05','\x7d',
/* 0x155cd = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xf9','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x9d',
/* 0x155e4 = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x155fb = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\x86','r','e','s','o','u','r','c','e',' ','\x09','b','u','s','y','.',
/* 0x15612 = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\xe7','V','P','_','\xa0','S','E','C','T','I','O','N','_','F','I','L','E','_','S','I','Z','E',
/* 0x15629 = "No parent node specified." */
    '\xce','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x15640 = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x15657 = "Error creating digest algorithm calculator." */
    '\xad','c','r','e','a','t','i','n','g',' ','\xc4','\xbf','c','a','l','c','u','l','a','t','o','r','.',
/* 0x1566e = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xb9','p','e','e','r','.',
/* 0x15685 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x1569c = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x156b3 = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x9b','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x156ca = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xd0',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x156e1 = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','M','E','M','O','R','Y','_','S','I','Z','E','_','\x99',
/* 0x156f8 = "Failed to obtain the GMM instance." */
    '\x80','\x08','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x1570f = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\xd7','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x15726 = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x1573d = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x15754 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x1576b = "No primary volume descriptors found." */
    '\xce','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x15782 = "Entry in a boot catalog section is empty." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xd3','\xc8','\x09','e','m','p','t','y','.',
/* 0x15799 = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\xa3','\xc3','\xa0','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x157b0 = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x157c7 = "Encountered an unknown load command." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x157de = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\xdd','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x157f5 = "Unsupported VRDP protocol feature." */
    '\x87','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x1580c = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x15','\xb4',
/* 0x15823 = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x15','C','O','N','S','E','C','U','T','I','V','E',
/* 0x1583a = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x15','W','R','I','T','E','A','B','L','E',
/* 0x15851 = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x15868 = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x1587f = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','5','1','2',
/* 0x15896 = "No logical volume descriptors found." */
    '\xce','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x158ad = "The requested feature is not supported in raw-mode." */
    '\x03','\xc0','f','e','a','t','u','r','e',' ','\x09','\x05','\xf2','\x0d','r','a','w','-','m','o','d','e','.',
/* 0x158c4 = "Unable to parse the XML in DMG file." */
    '\xcc','\x08','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0d','D','M','G',' ','f','i','l','e','.',
/* 0x158db = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','C','R','E','A','T','E','_','\x9d',
/* 0x158f2 = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xc8','\xdc','d','e','l','e','t','e','d',' ','\x10','\x05','\x7d',
/* 0x15909 = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','N','U','M','B','E','R','_','\x9c','B','I','G',
/* 0x15920 = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xab','\xe1','\x5e',
/* 0x15937 = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xbd','\xd1','\x09','\x05','v','a','l','i','d','.',
/* 0x1594e = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\xaa','K','E','Y','_','P','A','S','S','W','O','R','D','_','E','N','C','O','D','I','N','G',
/* 0x15965 = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x09','\x05','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x1597c = "Invalid string tag for a X.509 name object." */
    '\x0b','\xc9','t','a','g',' ','\x0e','a',' ','X','.','5','0','9',' ','\xf8','o','b','j','e','c','t','.',
/* 0x15993 = "Unsupported key encryption cipher." */
    '\x87','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x159aa = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x08','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x159c1 = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x159d8 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x15','\xc7',
/* 0x159ef = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','S','S','M','_','\xb6','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x15a06 = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x1d','\xaf','r','e','a','c','h','e','d','.',
/* 0x15a1d = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\xe7','V','P','_','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x99',
/* 0x15a34 = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x9d',
/* 0x15a4b = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','S','S','M','_','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x15a62 = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','\x15','A','D','J','A','C','E','N','T',
/* 0x15a79 = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x1a','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x15a90 = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\xe7','V','P','_','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x15aa7 = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x93',
/* 0x15abe = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0b','\x8b','\xda','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x15ad5 = "Too many references to an object." */
    '\xee','\xa4','r','e','f','e','r','e','n','c','e','s',' ','\x08','\x60','o','b','j','e','c','t','.',
/* 0x15aeb = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','\x15','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x15b01 = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x15','\xb4',
/* 0x15b17 = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x15b2d = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\xa5','_','\xdb','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x15b43 = "VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS" */
    '\x01','\xe8','\x9c','M','A','N','Y','_','F','I','L','E','_','F','R','A','G','M','E','N','T','S',
/* 0x15b59 = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x15b6f = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','S','U','P','L','I','B','_','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x15b85 = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','H','D','R',
/* 0x15b9b = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\xe8','\xe0','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','T','Y','P','E',
/* 0x15bb1 = "Internal ISO maker error: Buffer size." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x15bc7 = "Device i/o: Not ready." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x15bdd = "Bad digest length encountered in the table of content." */
    '\x92','\xc4','l','e','n','g','t','h',' ','\x98','\x0d','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x15bf3 = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','S','I','Z','E','_','\x99',
/* 0x15c09 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x9b','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x15c1f = "Unable to use the range for a large page." */
    '\xcc','\x08','u','s','e',' ','\x02','\xe5','\x0e','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x15c35 = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','O','B','J','E','C','T','_','F','I','L','E',
/* 0x15c4b = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x15c61 = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x9b','S','O','L','A','R','I','S','_','H','D','R','_','T','Y','P','E',
/* 0x15c77 = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x1a','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x15c8d = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x15ca3 = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x15cb9 = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x15ccf = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\xe7','V','P','_','\xb6','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0x15ce5 = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x15','\xb4',
/* 0x15cfb = "Empty string in X.509 name object." */
    'E','m','p','t','y',' ','\xc9','\x0d','X','.','5','0','9',' ','\xf8','o','b','j','e','c','t','.',
/* 0x15d11 = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xf7','\x0f','B','M','P','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15d27 = "Too many instances of a device." */
    '\xee','\xa4','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','d','e','v','i','c','e','.',
/* 0x15d3d = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x15d53 = "The table of content isn\'t valid UTF-8." */
    '\x03','\x9f','\x14','\xd9','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x15d69 = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x15d7f = "Failed to lock the address range." */
    '\x80','\x08','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x15d95 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x9d',
/* 0x15dab = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\xe7','V','P','_','\x15','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x15dc1 = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x15dd7 = "Internal processing error related to guest mappings." */
    '\x06','\x04','\x07','r','e','l','a','t','e','d',' ','\x08','\xa1','m','a','p','p','i','n','g','s','.',
/* 0x15ded = "Unsupported image target architecture." */
    '\x87','\x1b','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x15e03 = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x15e19 = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','V','M','X','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xd0',
/* 0x15e2f = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xf7','\x0f','T','6','1','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15e45 = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','S','S','M','_','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x15e5b = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\xb8','\xb6','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x15e71 = "Guest side reported an error." */
    'G','u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x60','\x7b',
/* 0x15e87 = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\xe7','V','P','_','Q','U','E','R','Y','_','H','A','N','D','L','E','_','T','Y','P','E',
/* 0x15e9d = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\xa3','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x15eb3 = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x8c','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x15ec9 = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','T','A','B','_','S','I','Z','E',
/* 0x15edf = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x15ef5 = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x15f0b = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x1a','V','M','X','_','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x15f21 = "VINF_THREAD_IS_TERMINATING" */
    '\x1a','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x15f37 = "Too many volume descriptors in the import ISO." */
    '\xee','\xa4','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x0d','\x02','\xfe','I','S','O','.',
/* 0x15f4d = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x05','m','a','p','p','e','d','.',
/* 0x15f63 = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\xaa','O','P','E','N','S','S','L','_','V','E','R','S','I','O','N','_','\x9c','O','L','D',
/* 0x15f79 = "VERR_ISOFS_BOGUS_NEXT_AD_LENGTH" */
    '\x01','\xe8','B','O','G','U','S','_','N','E','X','T','_','A','D','_','L','E','N','G','T','H',
/* 0x15f8f = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x15fa5 = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x10','\x05','\x7d',
/* 0x15fbb = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\xb6','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x15fd1 = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\xd7','P','H','Y','S','_','N','U','L','L','_','P','A','G','E','_','P','A','R','A','M',
/* 0x15fe7 = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf9','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x15ffd = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\xa3','\xc3','B','O','O','T','_','C','A','T','_','\xe0','H','E','A','D','E','R','_','I','D',
/* 0x16013 = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','\xb6','C','O','N','T','E','N','T',
/* 0x16029 = "Invalid file mode mask (RTFMODE)." */
    '\x0b','\x18','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x1603f = "Media not present in drive." */
    'M','e','d','i','a',' ','\x05','p','r','e','s','e','n','t',' ','\x0d','d','r','i','v','e','.',
/* 0x16055 = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x1606b = "Process Verification Failure: Error allocating memory." */
    '\x17','\x0c','\x12','\xad','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x16081 = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\xaa','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x16097 = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x1a','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x160ad = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','V','D','_','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0x160c3 = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','e','m','p','t','y','.',
/* 0x160d9 = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x15','P','O','L','L','A','B','L','E',
/* 0x160ef = "VWRN_CONTINUE_ANALYSIS" */
    'V','W','R','N','_','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0x16105 = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','C','H','I','N','E',
/* 0x1611b = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\xaa','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','\xb6','C','R','L','S',
/* 0x16131 = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xd0','_','H','A','N','D','L','E',
/* 0x16147 = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x1615d = "The guest has reported too many modules." */
    '\x03','\xa1','\x1d','r','e','p','o','r','t','e','d',' ','\x8d','\xa4','m','o','d','u','l','e','s','.',
/* 0x16173 = "Too many instances of a driver." */
    '\xee','\xa4','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','d','r','i','v','e','r','.',
/* 0x16189 = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x17','\x0c','\x12','\x92','n','e','w','-','\xa2','o','f','f','s','e','t',' ','\x0d','\x02','M','Z',' ','\xe9',
/* 0x1619f = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x0f','S','T','A','T','E',
/* 0x161b5 = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x161cb = "No unwind information was found." */
    '\xce','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x7d',
/* 0x161e1 = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x161f7 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x1620d = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x16223 = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\xb6','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x16239 = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x1624f = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xd0',
/* 0x16265 = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x15','\xc7',
/* 0x1627b = "Not an integer property." */
    'N','o','t',' ','\x60','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x16291 = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xf7','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x9c','B','I','G',
/* 0x162a7 = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x162bd = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\x9e','\x05','\xb2','\x02','\xc0','f','u','n','c','t','i','o','n','.',
/* 0x162d3 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x15','A','T','T','A','C','H','E','D',
/* 0x162e9 = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x162ff = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\xa5','_','\xdb','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x16315 = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\xe0','C','H','A','R','_','C','L','A','S','S',
/* 0x1632b = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xc0','a','d','d','r','e','s','s','.',
/* 0x16341 = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x15','\xb4',
/* 0x16357 = "Invalid argument to VFS chain element." */
    '\x0b','a','r','g','u','m','e','n','t',' ','\x08','\xa5',' ','\x91','e','l','e','m','e','n','t','.',
/* 0x1636d = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x16383 = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\xa3','\xc3','V','O','L','U','M','E','_','S','P','A','C','E','_','S','I','Z','E','_','\x99',
/* 0x16399 = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x163af = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x1a','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','S','I','Z','E',
/* 0x163c5 = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\xaa','X','5','0','9','_','\xe0','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x163db = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x163f1 = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x16407 = "Syntax error - unbalanced quotes." */
    '\xe2','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x1641d = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x60','o','p','t','i','o','n','.',
/* 0x16433 = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','M','M','A','N','D','_','\x15','\xb4',
/* 0x16449 = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xf7','\xb6','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x1645f = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x09','\x05','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x16475 = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x1648b = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0b','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x164a1 = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x164b7 = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xb5','n','u','m','b','e','r','s',' ','\x0d','\x02','\xe9',
/* 0x164cd = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\xe7','V','P','_','I','M','A','G','E','_','F','I','L','E','_','O','P','E','N','_','\x9d',
/* 0x164e3 = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\xe7','V','P','_','\x9c','M','A','N','Y','_','D','L','L','S','_','L','O','A','D','E','D',
/* 0x164f9 = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x1a','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x1650f = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\xa3','\xc3','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x16525 = "Invalid executable signature." */
    '\x0b','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x1653b = "Wrong JSON type for integer value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','i','n','t','e','g','e','r',' ','\xd2',
/* 0x16551 = "Reason for leaving RZ: I/O port write." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x16567 = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x1657d = "Expected a different time tag." */
    '\xa7','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x16593 = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\xa0','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x165a9 = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x15','A','B','S','O','L','U','T','E',
/* 0x165bf = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x9c','L','O','N','G',
/* 0x165d5 = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xae','\x19','m','a','g','i','c',' ','\x09','w','r','o','n','g','.',
/* 0x165eb = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x16601 = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','E','R','S','I','O','N',
/* 0x16617 = "More data available in pipe." */
    'M','o','r','e',' ','\x90','a','v','a','i','l','a','b','l','e',' ','\x0d','p','i','p','e','.',
/* 0x1662d = "There is no volume behind the current one." */
    'T','h','e','r','e',' ','\x09','\xeb','\xbe','b','e','h','i','n','d',' ','\x02','\xd5','o','n','e','.',
/* 0x16643 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\xdd','\x15','B','U','D','D','I','N','G','_','\xd0','_','P','R','O','C','E','S','S','_','2',
/* 0x16659 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\xdd','\x15','B','U','D','D','I','N','G','_','\xd0','_','P','R','O','C','E','S','S','_','1',
/* 0x1666f = "File or directory can\'t be created." */
    'F','i','l','e',' ','\x86','\x19','c','a','n','\'','t',' ','\x8f','c','r','e','a','t','e','d','.',
/* 0x16685 = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0x1669b = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\xaa','K','E','Y','_','\x9c','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x166b1 = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x1a','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x166c7 = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\xe7','V','P','_','\xd4','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x166dd = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','S','S','M','_','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x166f3 = "Unsupported domain ID in logical volume descriptor." */
    '\x87','d','o','m','a','i','n',' ','I','D',' ','\x0d','l','o','g','i','c','a','l',' ','\xbe','\xf4',
/* 0x16709 = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x1671f = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x16735 = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x1a','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x15','A','C','T','I','V','E',
/* 0x1674b = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x1a','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x16761 = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x9b','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x16777 = "No attribute of the specified types was found." */
    '\xce','a','t','t','r','i','b','u','t','e',' ','\x14','\x02','\x16','t','y','p','e','s',' ','\x10','\x7d',
/* 0x1678d = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x167a3 = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x1a','P','A','T','M','_','H','C','_','\xf9','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x167b9 = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x167cf = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','\x15','\xb4',
/* 0x167e5 = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x22','m','a','p','p','e','d','.',
/* 0x167fb = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\xb6','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x16811 = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','O','P','E','R','A','T','I','O','N',
/* 0x16827 = "The page to be freed or updated was not found." */
    '\x03','\xab','\x08','\x8f','f','r','e','e','d',' ','\x86','u','p','d','a','t','e','d',' ','\x10','\x05','\x7d',
/* 0x1683d = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x08','d','i','v','i','d','e',' ','\xb9','z','e','r','o','.',
/* 0x16853 = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xf7','\x0f','I','A','5','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x16869 = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x1a','V','M','X','_','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x1687f = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x1a','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x16895 = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x10','\x05','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x168ab = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xd0','_','S','A','V','E','_','S','T','A','T','E','_','\x15','A','L','L','O','W','E','D',
/* 0x168c1 = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x1a','V','M','X','_','I','N','T','E','R','C','E','P','T','_','\x15','A','C','T','I','V','E',
/* 0x168d7 = "NEM returned in the wrong state." */
    'N','E','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xfb',
/* 0x168ed = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xf7','O','B','J','I','D','_','\x0f','D','O','T','T','E','D','_','S','T','R','I','N','G',
/* 0x16903 = "VWRN_NEGATIVE_UNSIGNED" */
    'V','W','R','N','_','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x16919 = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\xf1','F','I','X','U','P','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x1692e = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x16943 = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\xaa','P','K','C','S','7','_','\xb6','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x16958 = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\xb6','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0X1696d = "Shadow mode \'none\' internal error." */
    'h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x13','\x7b',
/* 0x16981 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x09','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x16996 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\x8e','\xae','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x169ab = "No direct ICB entries found." */
    '\xce','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x7d',
/* 0x169c0 = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xf9','_','R','E','G','I','O','N','_','\x15','M','A','P','P','E','D',
/* 0x169d5 = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\xd7','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x169ea = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x169ff = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x0e','U','D','F','.',
/* 0x16a14 = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x16a29 = "Duplicate certificate extension." */
    'D','u','p','l','i','c','a','t','e',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x16a3e = "Invalid GC physical address." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x16a53 = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x16a68 = "VWRN_DBGC_CMD_PENDING" */
    'V','W','R','N','_','D','B','G','C','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x16a7d = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x16a92 = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','B','A','L','L','O','O','N','E','D',
/* 0x16aa7 = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\xe0','V','A','R','I','A','B','L','E',
/* 0x16abc = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\xe7','V','P','_','\xa0','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x16ad1 = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x16ae6 = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x16afb = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\xe8','\x9c','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x16b10 = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x16b25 = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\xaa','P','K','C','S','7','_','\xb6','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x16b3a = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x22','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x16b4f = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x16b64 = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\xe7','V','P','_','\xa0','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x16b79 = "APIC initialization failed." */
    'A','P','I','C',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x16b8e = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x16ba3 = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x9c','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x16bb8 = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\xa5','_','\xdb','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x16bcd = "VWRN_PATCH_END_BRANCH" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x16be2 = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x15','\xc7',
/* 0x16bf7 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x19','\x1c','f','i','l','e','s','.',
/* 0x16c0c = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x16c21 = "Unknown partition map entry type." */
    '\xd8','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb7','t','y','p','e','.',
/* 0x16c36 = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','\x93',
/* 0x16c4b = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x16c60 = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x16c75 = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','V','D','_','C','A','C','H','E','_','\x15','U','P','_','T','O','_','D','A','T','E',
/* 0x16c8a = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\xd7','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x16c9f = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xf6','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x16cb4 = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','H','E','A','D','E','R',
/* 0x16cc9 = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xd8','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x16cde = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x1a','\xf6','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x16cf3 = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\xf1','A','S','P','E','C','T','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x16d08 = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\xa5','_','\xdb','T','A','K','E','S','_','F','I','L','E','_','O','R','_','I','O','S',
/* 0x16d1d = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x0f','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x16d32 = "VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD" */
    '\x01','\xe8','\x9c','B','I','G','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x16d47 = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x16d5c = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\xe7','V','P','_','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x9d',
/* 0x16d71 = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','T','Y','P','E',
/* 0x16d86 = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','M','I','S','S','I','N','G',
/* 0x16d9b = "Certificate signature algorithm mismatch." */
    '\xa8','s','i','g','n','a','t','u','r','e',' ','\xbf','m','i','s','m','a','t','c','h','.',
/* 0x16db0 = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x16dc5 = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xd0','_','D','R','I','V','E','R','_','\x15','A','C','C','E','S','S','I','B','L','E',
/* 0x16dda = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\xb8','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x16def = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x16e04 = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','O','S','S','L','_','V','E','R','I','F','Y','_','\x93',
/* 0x16e19 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x24',
/* 0x16e2e = "Syntax error - expected binary operator." */
    '\xe2','\x07','-',' ','\xb0','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x16e43 = "Syntax error - numeric overflow." */
    '\xe2','\x07','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x16e58 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','f','u','l','l','.',
/* 0x16e6d = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','V','D','_','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x16e82 = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\xe7','V','P','_','K','E','R','N','E','L','3','2','_','\xf0','M','A','P','P','E','D',
/* 0x16e97 = "Out of selector bounds." */
    'O','u','t',' ','\x14','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x16eac = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9f','\xdf','o','v','e','r','f','l','o','w','.',
/* 0x16ec1 = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x9c','L','A','R','G','E',
/* 0x16ed6 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xf9','_','R','E','G','I','O','N','_','\xf0','M','A','P','P','E','D',
/* 0x16eeb = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','T','Y','P','E',
/* 0x16f00 = "VFS chain element expected at least three arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xca',
/* 0x16f15 = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x16f2a = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','n','e','g','a','t','i','v','e','.',
/* 0x16f3f = "Reason for leaving RZ: Timer pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x16f54 = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','V','D','_','D','M','G','_','\x15','\xb4','_','I','N','S','I','D','E','_','X','A','R',
/* 0x16f69 = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\xaa','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x16f7e = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x16f93 = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','F','O','O','T','E','R',
/* 0x16fa8 = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xde','r','e','a','c','h','e','d','.',
/* 0x16fbd = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x09','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x16fd2 = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x16fe7 = "Invalid ASN.1 NULL encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','L','L',' ','e','n','c','o','d','i','n','g','.',
/* 0x16ffc = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x1a','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x17011 = "Recompiler: Bad segment register number for memory access." */
    '\x11','\x92','s','e','g','m','e','n','t',' ','\xbd','\xde','\x0e','\x5c','a','c','c','e','s','s','.',
/* 0x17026 = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x1703b = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\xe8','\xb6','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x17050 = "VFS chain doesn't end with a path only element." */
    '\xa5',' ','\x91','\xa6','e','n','d',' ','\x1c','a',' ','\xbc','\xfd','e','l','e','m','e','n','t','.',
/* 0x17065 = "Unexpected guest mapping conflict detected." */
    '\x85','\xa1','\xe1','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x1707a = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\xe7','V','P','_','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x1708f = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x93',
/* 0x170a4 = "Process Verification Failure: Bad virtual section address." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc8','a','d','d','r','e','s','s','.',
/* 0x170b9 = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x05','\x7d',
/* 0x170ce = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xfb',
/* 0x170e3 = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9d',
/* 0x170f8 = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x1710d = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','\xfa','\xf4',
/* 0x17122 = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x17137 = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\xd7','\xb6','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x1714c = "Expected a right parentheses." */
    '\xa7','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x17161 = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xd4','O','P','E','R','A','T','O','R',
/* 0x17176 = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','d','o','u','b','l','e',' ','\xd2',
/* 0x1718b = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\xdd','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x171a0 = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','\x9c','S','M','A','L','L',
/* 0x171b5 = "Unable to switch due to invalid host state." */
    '\xcc','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','h','o','s','t',' ','\xfb',
/* 0x171ca = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x171df = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\xa3','\xc3','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x171f4 = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xf9','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x17209 = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','L','E','F','T','_','H','E','I','G','H','T',
/* 0x1721e = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x17233 = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x1a','\xd7','\xb6','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x17248 = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x05','\x7d',
/* 0x1725d = "VWRN_DBGC_ALREADY_REGISTERED" */
    'V','W','R','N','_','D','B','G','C','_','\xf0','R','E','G','I','S','T','E','R','E','D',
/* 0x17272 = "Failed to obtain a pool page." */
    '\x80','\x08','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x17287 = "Generic audio device enumeration error." */
    '\x96','a','u','d','i','o',' ','\x8b','e','n','u','m','e','r','a','t','i','o','n',' ','\x7b',
/* 0x1729c = "Device i/o: Bad command." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','c','o','m','m','a','n','d','.',
/* 0x172b1 = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x172c6 = "One of the structure magics was wrong." */
    'O','n','e',' ','\x14','\x02','\xc2','m','a','g','i','c','s',' ','\x10','w','r','o','n','g','.',
/* 0x172db = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','V','D','_','P','A','R','A','L','L','E','L','S','_','\x0f','H','E','A','D','E','R',
/* 0x172f0 = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xd6','\x24',
/* 0x17305 = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\xd7','\x9b','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x1731a = "VWRN_DANGLING_OBJECTS" */
    'V','W','R','N','_','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x1732f = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x17344 = "Bad timestamp for XAR file." */
    '\x92','t','i','m','e','s','t','a','m','p',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17359 = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x1736e = "Bad file group id for XAR file." */
    '\x92','\x18','g','r','o','u','p',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17383 = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0x17398 = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','P','R','O','T',
/* 0x173ad = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x9c','L','A','R','G','E',
/* 0x173c2 = "A page count is out of range." */
    'A',' ','\xab','c','o','u','n','t',' ','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x173d7 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\xa5','_','\xdb','\x9c','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x173ec = "Internal SPC error: The PE image data is missing." */
    '\x06','S','P','C',' ','\xc5','\x03','P','E',' ','\x1b','\x90','\x09','m','i','s','s','i','n','g','.',
/* 0x17401 = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\xf1','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x17416 = "The file or directory is world writable (hardening)." */
    '\x03','\x18','\x86','\x19','\x09','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\x9a',
/* 0x1742b = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x99',
/* 0x17440 = "Recompiler: Translation block allocation failed." */
    '\x11','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','\xfa','\x24',
/* 0x17455 = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','C','A','L','C','_','\x9d',
/* 0x1746a = "The register is read-only and cannot be modified." */
    '\x03','\xbd','\x09','r','e','a','d','-','\xfd','\x2a','\xba','\x8f','m','o','d','i','f','i','e','d','.',
/* 0x1747f = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x17494 = "Reason for leaving RZ: I/O port read." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x174a9 = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','V','D','_','V','D','I','_','C','O','M','M','E','N','T','_','\x9c','L','O','N','G',
/* 0x174be = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x1a','P','A','T','M','_','H','C','_','\xf9','_','P','A','T','C','H','_','R','E','A','D',
/* 0x174d3 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x1a','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x174e8 = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\x86','a','r','r','a','y',' ','\x09','e','m','p','t','y','.',
/* 0x174fd = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x83','\x09','\x05','\xf2','\x0e','\xcb','i','m','a','g','e','.',
/* 0x17512 = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x17527 = "No free output streams." */
    '\xce','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x1753c = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x17551 = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0x17566 = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\xf1','C','O','N','D','_','\x9c','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1757b = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x17590 = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x175a5 = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9f','\x14','\xd9','\x09','\x8d','b','i','g','.',
/* 0x175ba = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x175cf = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','S','S','M','_','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0x175e4 = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x9c','D','E','E','P',
/* 0x175f9 = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x1760e = "Internal ISO maker error: Empty path." */
    '\x06','\xb3',' ','m','a','k','e','r',' ','\xc5','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x17623 = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xc3','\xe7','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x17638 = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\xdd','A','P','I','P','O','R','T','_','O','P','E','N','_','\x9d','_','T','Y','P','E',
/* 0x1764d = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\xf1','L','A','B','E','L','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x17662 = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x17677 = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\xe7','V','P','_','M','E','M','O','R','Y','_','V','S','_','F','I','L','E','_','\x99',
/* 0x1768c = "VWRN_OUT_OF_RESOURCES" */
    'V','W','R','N','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x176a1 = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x0f','B','A','U','D','R','A','T','E',
/* 0x176b6 = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x93',
/* 0x176cb = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x176e0 = "VINF_EM_RAW_TIMER_PENDING" */
    '\x1a','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x176f5 = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xf7','\x0f','B','I','T','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1770a = "VINF_HGCM_CLIENT_REJECTED" */
    '\x1a','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x1771f = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x1a','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x17734 = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x15','\xb4',
/* 0x17749 = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\xe8','\x9b','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E',
/* 0x1775e = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','P','A','G','E','_','\x15','\xb4',
/* 0x17773 = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0d','r','i','n','g','-','0','.',
/* 0x17788 = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\xe7','V','P','_','\x9c','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x1779d = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x177b2 = "VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT" */
    '\x01','\xe8','\xb6','A','D','S','_','F','O','R','_','U','D','F','_','O','B','J','E','C','T',
/* 0x177c7 = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','F','I','X','U','P','_','T','Y','P','E',
/* 0x177dc = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\xd4','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x177f1 = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xaf','s','e','t','.',
/* 0x17806 = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x1a','V','D','_','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x1781b = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x17830 = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','S','S','M','_','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x17845 = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xae','\x19','w','i','n','t','e','r','t','i','d','e','s',' ','\x7b',
/* 0x1785a = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\xb6','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x1786f = "Import ISO contains a too deep directory subtree." */
    '\xb1','\xb3',' ','\x7f','a',' ','\x8d','d','e','e','p',' ','\x19','s','u','b','t','r','e','e','.',
/* 0x17884 = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\xe7','V','P','_','\xa0','S','I','Z','E','_','O','F','_','H','E','A','D','E','R','S',
/* 0x17899 = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x178ae = "Process Verification Failure: Error closing image file handle." */
    '\x17','\x0c','\x12','\xad','c','l','o','s','i','n','g',' ','\x1b','\x18','h','a','n','d','l','e','.',
/* 0x178c3 = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\xdb','\x9c','L','O','N','G',
/* 0x178d8 = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\xdd','K','E','R','N','E','L','_','\x9c','O','L','D','_','F','O','R','_','V','T','X',
/* 0x178ed = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x17902 = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x99',
/* 0x17917 = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x15','R','E','A','D','Y',
/* 0x1792b = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x1793f = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\xa5','_','\xdb','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x17953 = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb6','H','M',
/* 0x17967 = "Reason for leaving RC: Double Fault." */
    '\x84','\x0e','\x25','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x1797b = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x1798f = "VINF_CSAM_PENDING_ACTION" */
    '\x1a','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x179a3 = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x15','\xb4',
/* 0x179b7 = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x179cb = "VINF_PATCH_EMULATE_INSTR" */
    '\x1a','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x179df = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x179f3 = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','D','E','V','I','C','E','_','N','O',
/* 0x17a07 = "Image hash mismatch." */
    'I','m','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x17a1b = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','L','D','R','V','I','_','\xb6','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x17a2f = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','V','D','_','\x15','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x17a43 = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x15','M','A','P','P','E','D',
/* 0x17a57 = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','S','U','P','L','I','B','_','\xd4','I','N','S','T','R','U','C','T','I','O','N',
/* 0x17a6b = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x15','\xb4',
/* 0x17a7f = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','T','A','G','_','L','E','N','G','T','H',
/* 0x17a93 = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0x17aa7 = "The driver instance could not be found." */
    '\x03','\xa9','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x8f','\x7d',
/* 0x17abb = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\xb8','B','L','O','C','K','_','\xe0','T','R','A','N','S','L','A','T','I','O','N',
/* 0x17acf = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','9',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17ae3 = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x1a','\xd7','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x17af7 = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x99',
/* 0x17b0b = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\xa3','\x8c','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x17b1f = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x17b33 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x17b47 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x17b5b = "VINF_CR_DIGEST_COMPROMISED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x17b6f = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x17b83 = "Recompiler: Unimplemented case." */
    '\x11','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x17b97 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\xa3','\xc3','\xa0','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x17bab = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\xaa','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x9c','L','O','N','G',
/* 0x17bbf = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x17bd3 = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\xaa','P','K','C','S','7','_','\x15','S','I','G','N','E','D','_','D','A','T','A',
/* 0x17be7 = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9d',
/* 0x17bfb = "NEM failed to get registers." */
    'N','E','M',' ','\x88','\x08','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x17c0f = "UDF directory too large for import." */
    'U','D','F',' ','\x19','\x8d','l','a','r','g','e',' ','\x0e','i','m','p','o','r','t','.',
/* 0x17c23 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\xa5','_','\xdb','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x17c37 = "Device i/o: Bad length." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','l','e','n','g','t','h','.',
/* 0x17c4b = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x17c5f = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','C','A','L','L','B','A','C','K',
/* 0x17c73 = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x17c87 = "Expected a left parentheses." */
    '\xa7','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x17c9b = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xd4','N','U','L','L','_','R','I','G','H','T',
/* 0x17caf = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\xe7','V','P','_','S','E','C','T','I','O','N','_','\x15','M','A','P','P','E','D',
/* 0x17cc3 = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x1b','\x09','\x05','o','p','e','n','e','d','.',
/* 0x17cd7 = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\xa0','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x17ceb = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','P','A','G','E','_','T','A','B','L','E','_','\x15','P','R','E','S','E','N','T',
/* 0x17cff = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','F','I','L','E','_','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x17d13 = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xd0','_','D','R','I','V','E','R','_','\x15','I','N','S','T','A','L','L','E','D',
/* 0x17d27 = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x93',
/* 0x17d3b = "Too deep ICB recursion." */
    '\xee','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x17d4f = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x24',
/* 0x17d63 = "Reserved page table bits set." */
    'R','e','s','e','r','v','e','d',' ','\xab','\x9f','b','i','t','s',' ','s','e','t','.',
/* 0x17d77 = "Expected an element separator (| or :)." */
    '\xa7','\x60','\x1f','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\x86',':',')','.',
/* 0x17d8b = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x17d9f = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','N','E','W','_','H','E','I','G','H','T',
/* 0x17db3 = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','S','S','M','_','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x17dc7 = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x93','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x17ddb = "Too long name or link string." */
    '\xee','l','o','n','g',' ','\xf8','\x86','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x17def = "A number tar header field was malformed." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf5','\x10','m','a','l','f','o','r','m','e','d','.',
/* 0x17e03 = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','6',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17e17 = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xf7','\x0f','U','T','C','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x17e2b = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17e3f = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\xe7','V','P','_','U','N','K','O','W','N','_','M','E','M','_','T','Y','P','E',
/* 0x17e53 = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x15','\xb4',
/* 0x17e67 = "Too many clients for the service." */
    '\xee','\xa4','c','l','i','e','n','t','s',' ','\x0e','\x02','s','e','r','v','i','c','e','.',
/* 0x17e7b = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\xe7','V','P','_','\xb6','\xb4','_','\xb6','E','X','E','_','M','A','P','P','I','N','G',
/* 0x17e8f = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','\xf5','\x0d','a',' ','t','a','r',' ','\xa2','\x09','b','a','d','.',
/* 0x17ea3 = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x17eb7 = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\xf0','M','A','P','P','E','D',
/* 0x17ecb = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','R','E','S','E','R','V','E','D',
/* 0x17edf = "Unsupported ISO protocol feature." */
    '\x87','\xb3',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x17ef3 = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x17f07 = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','T','I','M','E','S','T','A','M','P',
/* 0x17f1b = "Invalid timer queue number." */
    '\x0b','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x17f2f = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x17f43 = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x17f57 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x17f6b = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\xe8','\xa0','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x17f7f = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','5',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17f93 = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','F','I','L','E','_','T','Y','P','E',
/* 0x17fa7 = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x15','M','U','L','T','I','P','L','E',
/* 0x17fbb = "Failed to allocate VM memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\xd0',' ','m','e','m','o','r','y','.',
/* 0x17fcf = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\xaa','K','E','Y','_','\xd4','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x17fe3 = "Import ISO contains a bad primary volume descriptor." */
    '\xb1','\xb3',' ','\x7f','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xbe','\xf4',
/* 0x17ff7 = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x24',
/* 0x1800b = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x93',
/* 0x1801f = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x15','\xc7',
/* 0x18033 = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x15','\xb4',
/* 0x18047 = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x1805b = "VWRN_FLOAT_UNDERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x1806f = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\xaa','X','5','0','9','_','\xb6','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x18083 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','K','E','Y','_','L','E','N','G','T','H',
/* 0x18097 = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x180ab = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x15','\xb4',
/* 0x180bf = "Syntax error - invalid operator usage." */
    '\xe2','\x07','-',' ','\x81','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x180d3 = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','L','D','R','V','I','_','F','I','L','E','_','L','E','N','G','T','H','_','\x9d',
/* 0x180e7 = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x180fb = "No conflicts to resolve." */
    '\xce','c','o','n','f','l','i','c','t','s',' ','\x08','r','e','s','o','l','v','e','.',
/* 0x1810f = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\xa0','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x18123 = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','S','U','P','L','I','B','_','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x18137 = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x90','\x1f','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1814b = "Reason for leaving RZ: MMIO read/write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf9',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x1815f = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x18173 = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x18187 = "Process Verification Failure: Bad optional header field." */
    '\x17','\x0c','\x12','\x92','o','p','t','i','o','n','a','l',' ','\xa2','f','i','e','l','d','.',
/* 0x1819b = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xe0','C','F','G','_','V','A','L','U','E','S',
/* 0x181af = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x181c3 = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x181d7 = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0x181eb = "No free input streams." */
    '\xce','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x181ff = "VERR_ISOFS_BOGUS_UDF_DIR_SIZE" */
    '\x01','\xe8','B','O','G','U','S','_','U','D','F','_','D','I','R','_','S','I','Z','E',
/* 0x18213 = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\xe7','V','P','_','\x15','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x18227 = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x1823b = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x1824f = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x18263 = "Internal processing error #2 in the PDM Thread code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x18277 = "The object in question already exists." */
    '\x03','\x8e','\x0d','q','u','e','s','t','i','o','n',' ','\x22','e','x','i','s','t','s','.',
/* 0x1828b = "EVP_DecryptInit_ex failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x24',
/* 0x1829f = "VWRN_TRAILING_SPACES" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x182b3 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x182c7 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x182db = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','f','i','l','e','.',
/* 0x182ef = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x18303 = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x18317 = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x1832b = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\xd7','\x9c','M','A','N','Y','_','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x1833f = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','G','I','C',
/* 0x18353 = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\xaa','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x18367 = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x15','S','E','A','L','E','D',
/* 0x1837b = "VFS chain element expected at least five arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xca',
/* 0x1838f = "Bogus UDF dstring field value." */
    'B','o','g','u','s',' ','U','D','F',' ','d','s','t','r','i','n','g',' ','\xf5','\xd2',
/* 0x183a3 = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x183b7 = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x183cb = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\xa5','_','\xdb','T','Y','P','E','_','\x99','_','P','A','T','H','_','O','N','L','Y',
/* 0x183df = "VINF_RECORDING_THROTTLED" */
    '\x1a','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x183f3 = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','8',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x18407 = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x1841b = "Unable to start VM execution." */
    '\xcc','\x08','s','t','a','r','t',' ','\xd0',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x1842f = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xf7','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x18443 = "VINF_VRDP_THREAD_STARTED" */
    '\x1a','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x18457 = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','S','U','P','L','I','B','_','\x15','S','A','M','E','_','O','B','J','E','C','T',
/* 0x1846b = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','L','D','R','V','I','_','\xb6','M','E','M','O','R','Y','_','S','H','D','R','S',
/* 0x1847f = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x1a','V','D','_','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x18493 = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xa0','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0X184a7 = "Trailing characters." */
    'r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x184ba = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\x94','I','D',' ','\x09','\x22','e','x','i','s','t','i','n','g','.',
/* 0x184ce = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x184e2 = "NEM failed to set registers." */
    'N','E','M',' ','\x88','\x08','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x184f6 = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x1850a = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x1a','\xd7','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1851e = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb6','S','C','R','A','T','C','H',
/* 0x18532 = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x18546 = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x15','\xb4',
/* 0x1855a = "Bad file inode device number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\x8b','\xde','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1856e = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x18582 = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\xf1','I','N','S','T','R','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x18596 = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xa0','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x185aa = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x185be = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\xaa','X','5','0','9','_','C','P','B','_','\xa0','C','E','R','T','_','C','T','X',
/* 0x185d2 = "Unexpected SVM exception exit." */
    '\x85','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x185e6 = "VFS chain element expected at least four arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xca',
/* 0x185fa = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x15','S','U','B','M','I','T','T','E','D',
/* 0x1860e = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x18622 = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','P','A','R','S','E','_','\x9d',
/* 0x18636 = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x24',
/* 0x1864a = "Internal processing error #1 in the PDM Thread code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x1865e = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x18672 = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x18686 = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\xf1','E','M','I','T','_','\xd4','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x1869a = "VERR_NEM_MISSING_FEATURE" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','F','E','A','T','U','R','E',
/* 0x186ae = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x05','\xb0','\x0d','S','P','C',' ','P','E',' ','\x1b','d','a','t','a','.',
/* 0x186c2 = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x1a','S','S','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x186d6 = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x186ea = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x99',
/* 0x186fe = "Bad file user id for XAR file." */
    '\x92','\x18','u','s','e','r',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x18712 = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x1a','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x18726 = "Recompiler: Hit instruction buffer size limit." */
    '\x11','H','i','t',' ','\xbb','b','u','f','f','e','r',' ','\xdf','l','i','m','i','t','.',
/* 0x1873a = "The specified thread is not waitable." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','\x05','w','a','i','t','a','b','l','e','.',
/* 0x1874e = "Bad VTG argument list descriptor." */
    '\x92','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','\xf4',
/* 0x18762 = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x18776 = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x1878a = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x1879e = "VFS chain element expected at most three arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xca',
/* 0x187b2 = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\xa3','R','R','_','S','P','I','L','L','_','F','I','L','E','_','F','U','L','L',
/* 0x187c6 = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','7',' ','\x0d','\x02','\xf6',' ','\xac','m','a','n','a','g','e','r',' ','\x5e',
/* 0x187da = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x15','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x187ee = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','S','S','M','_','S','T','A','T','E','_','G','R','E','W','_','\x9c','B','I','G',
/* 0x18802 = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x15','A','T','T','A','C','H','E','D',
/* 0x18816 = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xe0','C','F','G','_','V','A','L','U','E','S',
/* 0x1882a = "Generic hypercall operation failure." */
    '\x96','h','y','p','e','r','c','a','l','l',' ','\x83','f','a','i','l','u','r','e','.',
/* 0x1883e = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x18852 = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x10','r','e','d','i','r','e','c','t','e','d','.',
/* 0x18866 = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xf0','R','E','G','I','S','T','E','R','E','D',
/* 0x1887a = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\xb8','D','R','I','V','E','R','_','\x0f','P','R','O','P','E','R','T','I','E','S',
/* 0x1888e = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x1a','\xf6','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0x188a2 = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf9','_','R','E','A','D','_','W','R','I','T','E',
/* 0x188b6 = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x24',
/* 0x188c9 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x09','\x22','c','o','n','n','e','c','t','e','d','.',
/* 0x188dc = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x188ef = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x09','u','n','l','o','a','d','i','n','g','.',
/* 0x18902 = "Bad size element in table of content sub-element." */
    '\x92','\xdf','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x18915 = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\xb6','C','O','D','E','_','P','O','I','N','T','_','M','E','M','O','R','Y',
/* 0x18928 = "Bad PCI configuration." */
    '\x92','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x1893b = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x15','\xb4',
/* 0x1894e = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x18961 = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','V','3','_','C','E','R','T',
/* 0x18974 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x18987 = "Certificate path validator: No trusted certificate paths." */
    '\xa8','\xbc','\xe6','\xce','t','r','u','s','t','e','d',' ','\x8a','p','a','t','h','s','.',
/* 0x1899a = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','\x15','\xb4',
/* 0x189ad = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x189c0 = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x189d3 = "The semaphore has been opened too many times." */
    '\x03','\xec','\x1d','\xaf','o','p','e','n','e','d',' ','\x8d','\xa4','t','i','m','e','s','.',
/* 0x189e6 = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x1a','T','C','P','_','S','E','R','V','E','R','_','\xb6','C','L','I','E','N','T',
/* 0x189f9 = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\xa5','_','\xdb','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x18a0c = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x9c','M','A','N','Y','_','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x18a1f = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x18a32 = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xa0','A','R','G','_','F','L','A','G','S',
/* 0x18a45 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9d','_','S','H','D','R','S',
/* 0x18a58 = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xf7','\x0f','B','O','O','L','E','A','N','_','E','N','C','O','D','I','N','G',
/* 0x18a6b = "VFS chain element expected at most five arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xca',
/* 0x18a7e = "VINF_PATM_PATCH_TRAP_PF" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x18a91 = "VFS chain element expected at least two arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xca',
/* 0x18aa4 = "Wrong JSON type for bool value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','b','o','o','l',' ','\xd2',
/* 0x18ab7 = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x18aca = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18add = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x18af0 = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','F','O','R','M','A','T',
/* 0x18b03 = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\xb8','\x0f','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x18b16 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\xb6','S','T','R','I','N','G','_','T','E','R','M','I','N','A','T','O','R',
/* 0x18b29 = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\xa0','D','I','G','E','S','T','_','L','E','N','G','T','H',
/* 0x18b3c = "Unsupported firmware property." */
    '\x87','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x18b4f = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x18b62 = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\xb8','D','E','V','I','C','E','_','\xb6','R','T','_','A','T','T','A','C','H',
/* 0x18b75 = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x18b88 = "The field contains a value that is out of range." */
    '\x03','\xf5','\x7f','a',' ','\xd1','\x89','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x18b9b = "The image is outside the expected range." */
    '\x03','\x1b','\x09','o','u','t','s','i','d','e',' ','\x02','\xb0','r','a','n','g','e','.',
/* 0x18bae = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x9b','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x18bc1 = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x18bd4 = "Vote for another pass." */
    'V','o','t','e',' ','\x0e','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x18be7 = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xf7','\x0f','I','N','T','E','G','E','R','_','E','N','C','O','D','I','N','G',
/* 0x18bfa = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\xe7','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','\x15','\xb4',
/* 0x18c0d = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\xe7','V','P','_','\x9c','M','A','N','Y','_','S','E','C','T','I','O','N','S',
/* 0X18c20 = "Saved state header integrity error." */
    'a','v','e','d',' ','\xae','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x18c32 = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x15','P','E','N','D','I','N','G',
/* 0x18c45 = "Bad left right height." */
    '\x92','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x18c58 = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9c','L','I','T','T','L','E',
/* 0x18c6b = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','I','S','S','U','E','R','_','\x99',
/* 0x18c7e = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x18c91 = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','T','Y','P','E',
/* 0x18ca4 = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','S','I','Z','E',
/* 0x18cb7 = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x18cca = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x18cdd = "Generic object destroyed status." */
    '\x96','\x8e','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x18cf0 = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xf7','D','Y','N','T','Y','P','E','_','T','A','G','_','\x15','I','M','P','L',
/* 0x18d03 = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x18d16 = "VFS chain element expected at most four arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xca',
/* 0x18d29 = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\xe7','V','P','_','\xd4','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x18d3c = "Bad ASN.1 time object." */
    '\x92','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x18d4f = "Bad file inode number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\xde','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x18d62 = "VINF_EM_PENDING_REQUEST" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x18d75 = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x15','U','I','N','T','_','P','R','O','P',
/* 0x18d88 = "VERR_FILE_AIO_COMPLETED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x18d9b = "Failed to allocate memory for a URB." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\x5c','\x0e','a',' ','U','R','B','.',
/* 0x18dae = "VINF_CR_DIGEST_DEPRECATED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x18dc1 = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x99','_','\xd0','_','S','T','R','U','C','T','_','V','E','R',
/* 0x18dd4 = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x9c','M','A','N','Y','_','C','L','I','E','N','T','S',
/* 0x18de7 = "Internal error - this should never happen." */
    '\x06','\x07','-',' ','\xcb','\xef','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x18dfa = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x18e0d = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','F','I','L','E','_','\x93',
/* 0x18e20 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x15','P','R','E','P','A','R','E','D',
/* 0x18e33 = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x15','C','L','E','A','N',
/* 0x18e46 = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x15','\xb4',
/* 0x18e59 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\xb8','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18e6c = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x18e7f = "Unknown SPC PE image attribute." */
    '\xd8','S','P','C',' ','P','E',' ','\x1b','a','t','t','r','i','b','u','t','e','.',
/* 0x18e92 = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\xd7','\x0f','S','A','V','E','D','_','P','A','G','E','_','S','T','A','T','E',
/* 0x18ea5 = "Path not verified yet." */
    'P','a','t','h',' ','\x05','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x18eb8 = "Process Verification Failure: An image has too many sections." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x1d','\x8d','\xa4','s','e','c','t','i','o','n','s','.',
/* 0x18ecb = "Expected ECDSA private key." */
    '\xa7','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x18ede = "Process Verification Failure: Bad file alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\x18','a','l','i','g','n','m','e','n','t',' ','\xd1','\x0d','\x1b','\xe9',
/* 0x18ef1 = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\xe0','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x18f04 = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\xd7','\x0f','L','A','R','G','E','_','P','A','G','E','_','R','A','N','G','E',
/* 0x18f17 = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x18f2a = "TM does not support the GIP version." */
    'T','M',' ','\x9e','\x05','\xb2','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x18f3d = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x18f50 = "Pagetable not present." */
    'P','a','g','e','t','a','b','l','e',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x18f63 = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\xa3','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','2',
/* 0x18f76 = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\xa3','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','1',
/* 0x18f89 = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\xa3','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','3',
/* 0x18f9c = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x9c','M','A','N','Y','_','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x18faf = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','\x15','\xc7',
/* 0x18fc2 = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x18fd5 = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x18fe8 = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\xd4','N','U','L','L','_','L','E','F','T',
/* 0x18ffb = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x99',
/* 0x1900e = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x19021 = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x15','\xf9','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x19034 = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\xe7','V','P','_','\xb6','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x19047 = "Wrong JSON type for date value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','d','a','t','e',' ','\xd2',
/* 0x1905a = "A path parameter was not set." */
    'A',' ','\xbc','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x1906d = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x19080 = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x9d',
/* 0x19093 = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\xd7','\x9b','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x190a6 = "VFS chain element expected at least six arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xca',
/* 0x190b9 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xe0','V','A','L','U','E',
/* 0x190cc = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\xaa','S','P','C','_','\xe0','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x190df = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','S','T','A','T','_','E','N','U','M','_','\x93',
/* 0x190f2 = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','V','D','_','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x19105 = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0x19118 = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\xe8','\xe0','P','A','R','T','_','M','A','P','_','T','Y','P','E','_','I','D',
/* 0x1912b = "Process Verification Failure: Error querying process name." */
    '\x17','\x0c','\x12','\xad','q','u','e','r','y','i','n','g',' ','\x82','n','a','m','e','.',
/* 0x1913e = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x09','\x05','p','o','l','l','a','b','l','e','.',
/* 0x19151 = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','G','E','T','_','I','P','E',
/* 0x19164 = "Failed to generate RSA key." */
    '\x80','\x08','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x19177 = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x15','\xc7',
/* 0x1918a = "Unknown SPC object moniker UUID." */
    '\xd8','S','P','C',' ','\x8e','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x1919d = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\xb8','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x191b0 = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x191c3 = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x09','\x22','p','e','n','d','i','n','g','.',
/* 0x191d6 = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x15','\xb4',
/* 0x191e9 = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\xaa','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x191fc = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x0f','S','E','S','S','I','O','N','_','S','T','A','T','E',
/* 0x1920f = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\xaa','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x19222 = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xb6','R','T','_','A','T','T','A','C','H',
/* 0x19235 = "Process Verification Failure: Bad section alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\xc8','a','l','i','g','n','m','e','n','t',' ','\xd1','\x0d','\x1b','\xe9',
/* 0x19248 = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x08','V','B','o','x','G','u','e','s','t',' ','\xa9','\x24',
/* 0x1925b = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\xe7','V','P','_','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x9d',
/* 0x1926e = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xf7','C','U','R','S','O','R','_','\xb6','M','O','R','E','_','D','A','T','A',
/* 0x19281 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','\x15','S','T','R','I','N','G',
/* 0x19294 = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x1a','\xaa','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x192a7 = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\xe8','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x192ba = "VINF_PATM_PATCH_TRAP_GP" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x192cd = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xb3','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x192e0 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\xd7','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xf9',
/* 0x192f3 = "VINF_SSM_LIVE_SUSPENDED" */
    '\x1a','S','S','M','_','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x19306 = "No pending interrupt." */
    '\xce','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x19319 = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','C','A','_','C','E','R','T',
/* 0x1932c = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','N','U','M','B','E','R',
/* 0x1933f = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x19352 = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x19365 = "VERR_APIC_WRITE_INVALID" */
    '\x01','A','P','I','C','_','W','R','I','T','E','_','I','N','V','A','L','I','D',
/* 0x19378 = "VWRN_FLOAT_OVERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x1938b = "VWRN_TRAILING_CHARS" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x1939e = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','S','I','Z','E',
/* 0x193b1 = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xa1','\x7b',
/* 0x193c4 = "Syntax error - a type conversion failed." */
    '\xe2','\x07','-',' ','a',' ','\xda','c','o','n','v','e','r','s','i','o','n',' ','\x24',
/* 0x193d7 = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','K','E','Y','_','U','S','A','G','E','_','\x99',
/* 0x193ea = "VINF_ACCOUNT_RESTRICTED" */
    '\x1a','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x193fd = "Failed to stat a file/dir (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\x9a',
/* 0x19410 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','\x93',
/* 0x19423 = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','S','U','P','L','I','B','_','O','W','N','E','R','_','\x15','R','O','O','T',
/* 0x19436 = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x19449 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x1945c = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0b','\x1b','\x18','\xe9',
/* 0x1946f = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x15','E','N','A','B','L','E','D',
/* 0x19482 = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\xb8','\x9c','P','C','I','_','M','A','N','Y','_','D','E','V','I','C','E','S',
/* 0x19495 = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x194a8 = "No valid TSS present." */
    '\xce','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x194bb = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x15','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x194ce = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x0f','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x194e1 = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','S','S','M','_','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x194f4 = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\xb6','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x19507 = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x1951a = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x1952d = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\xaa','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x15','\xc7',
/* 0x19540 = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','I','M','A','G','E','_','H','A','S','H','_','\x99',
/* 0x19553 = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x09','\x8d','s','m','a','l','l','.',
/* 0x19566 = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x19579 = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x15','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x1958c = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\xe0','O','P','C','O','D','E',
/* 0x1959f = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x19','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x195b2 = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x195c5 = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xd0','_','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x195d8 = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x9b','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x195eb = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x1a','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x195fe = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x1a','U','D','P','_','S','E','R','V','E','R','_','\xb6','C','L','I','E','N','T',
/* 0x19611 = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','V','D','_','D','M','G','_','X','M','L','_','P','A','R','S','E','_','\x9d',
/* 0x19624 = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\xe7','V','P','_','\xd4','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x19637 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9c','S','H','O','R','T',
/* 0x1964a = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\xaa','S','P','C','_','M','O','N','I','K','E','R','_','\xa0','D','A','T','A',
/* 0x1965d = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0x19670 = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\xaa','P','K','I','X','_','\xe0','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x19683 = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x09','\x8d','o','l','d','.',
/* 0x19696 = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','L','X',' ','\x8e','\x9f','\x24',
/* 0x196a9 = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x196bc = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x196cf = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','T','Y','P','E','_','\x15','\xc7',
/* 0x196e2 = "VINF_IOM_R3_IOPORT_READ" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x196f5 = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x1a','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x19708 = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb6','M','E','M','O','R','Y',
/* 0x1971b = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1972d = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','I','O','M','M','U','_','D','T','E','_','\xa0','O','F','F','S','E','T',
/* 0x1973f = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x09','\x05','\x95',
/* 0x19751 = "Expected a different string tag." */
    '\xa7','a',' ','d','i','f','f','e','r','e','n','t',' ','\xc9','t','a','g','.',
/* 0x19763 = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9c','L','O','N','G',
/* 0x19775 = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x15','\xc7',
/* 0x19787 = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','\x99',
/* 0x19799 = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\xe8','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x197ab = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\xe8','U','D','F','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x197bd = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xd0','_','\xd4','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x197cf = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x15','P','R','E','S','E','N','T',
/* 0x197e1 = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x197f3 = "VINF_EM_RESCHEDULE_REM" */
    '\x1a','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x19805 = "Recompiler: Debug info internal processing error #2." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x13','\x04','\x07','#','2','.',
/* 0x19817 = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','E','L','E','M','E','N','T',
/* 0x19829 = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x1983b = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x0f','C','M','D','_','A','D','D','R','E','S','S',
/* 0x1984d = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xf7','T','E','L','E','T','E','X','_','\x9b','C','H','A','R','S','E','T',
/* 0x1985f = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x19871 = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xc6','\xa6','\xb2','\x02','T','L','S',' ','\x90','\x19','y','e','t','.',
/* 0x19883 = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x9b','G','N','U','_','H','D','R','_','T','Y','P','E',
/* 0x19895 = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x18','s','t','a','r','t','.',
/* 0x198a7 = "Internal processing error #2 in the I/O port code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x198b9 = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x198cb = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xd6','\x24',
/* 0x198dd = "VERR_FILE_AIO_CANCELED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x198ef = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','I','O','M','M','U','_','C','M','D','_','\x0f','F','O','R','M','A','T',
/* 0x19901 = "VINF_SYS_MAY_POWER_OFF" */
    '\x1a','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x19913 = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\xe0','L','O','C','_','O','P','C','O','D','E',
/* 0x19925 = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x19937 = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','T','Y','P','E',
/* 0x19949 = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x1995b = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x15','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x1996d = "File/Device open failed." */
    'F','i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x24',
/* 0x1997f = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0d','\x02','D','B','G','C',' ','\x5e',
/* 0x19991 = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\xe7','V','P','_','\xb4','_','E','X','E','C','_','M','E','M','O','R','Y',
/* 0x199a3 = "The value is not a byte string." */
    '\x03','\xd1','\x09','\x05','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x199b5 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x93',
/* 0x199c7 = "VFS chain element expected at most two arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xca',
/* 0x199d9 = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x24',
/* 0x199eb = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x05','\x7d',
/* 0x199fd = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x99',
/* 0x19a0f = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\xd7','P','O','O','L','_','\x9c','M','A','N','Y','_','L','O','O','P','S',
/* 0x19a21 = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x19a33 = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','S','U','P','L','I','B','_','\x15','D','I','R','_','\x15','F','I','L','E',
/* 0x19a45 = "The DBGF has no more free breakpoint slots." */
    '\x03','\xf6',' ','\x1d','\xeb','\xfc','f','r','e','e',' ','\xac','s','l','o','t','s','.',
/* 0x19a57 = "Internal processing error #3 in the I/O port code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x19a69 = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19a7b = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x19a8d = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','L','O','C','K','I','N','G','_','\x93',
/* 0x19a9f = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','I','N','T','E','R','N','A','L','_','\x9d',
/* 0x19ab1 = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\xf0','M','A','P','P','E','D',
/* 0X19ac3 = "Device i/o: Bad unit." */
    'e','v','i','c','e',' ','i','/','o',':',' ','\x92','u','n','i','t','.',
/* 0x19ad4 = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\xe8','I','C','B','_','E','N','T','R','Y','_','\x9c','S','M','A','L','L',
/* 0x19ae6 = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x19af8 = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\xaa','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x93',
/* 0x19b0a = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x05','\x7d',
/* 0x19b1c = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','O','N','F','I','G','_','\x99',
/* 0x19b2e = "Expected ECDSA public key." */
    '\xa7','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x19b40 = "Unsupported hashing function." */
    '\x87','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x19b52 = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\xe7','V','P','_','\xb6','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x19b64 = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x1d','\x05','\xaf','o','p','e','n','e','d','.',
/* 0x19b76 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x15','\xc7',
/* 0x19b88 = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xf7','T','E','L','E','T','E','X','_','\xe0','E','S','C','_','S','E','Q',
/* 0x19b9a = "Bad left tree height." */
    '\x92','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x19bac = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','3',
/* 0x19bbe = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x19bd0 = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','2',
/* 0x19be2 = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\xaa','S','P','C','_','\xe0','D','I','G','E','S','T','_','A','L','G','O',
/* 0x19bf4 = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\xe7','V','P','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x9d',
/* 0x19c06 = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','1',
/* 0x19c18 = "Syntax error - Invalid command name." */
    '\xe2','\x07','-',' ','\x0b','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x19c2a = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x15','M','A','P','P','E','D',
/* 0x19c3c = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','I','N','T','E','R','N','A','L','_','\x9d',
/* 0x19c4e = "Internal processing error #1 in the I/O port code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x19c60 = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','4',
/* 0x19c72 = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x15','S','I','G','N','A','L','L','E','R',
/* 0x19c84 = "Process Verification Failure: Bad virtual section size." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc8','s','i','z','e','.',
/* 0x19c96 = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xf7','T','E','L','E','T','E','X','_','\x9b','E','S','C','_','S','E','Q',
/* 0x19ca8 = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\xa3','\xc3','\x0f','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x19cba = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x9c','B','I','G',
/* 0x19ccc = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\xa3','R','R','_','\xb6','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x19cde = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','\xec','\x1d','\x22','\xaf','p','o','s','t','e','d','.',
/* 0x19cf0 = "VINF_IEM_YIELD_PENDING_FF" */
    '\x1a','\xf1','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x19d02 = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\xf0','E','X','I','S','T','S',
/* 0x19d14 = "VINF_CPUM_R3_MSR_WRITE" */
    '\x1a','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x19d26 = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x9c','B','I','G',
/* 0x19d38 = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\xa3','\xc3','\xa0','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x19d4a = "Unexpected filesystem object type." */
    '\x85','f','i','l','e','s','y','s','t','e','m',' ','\x8e','t','y','p','e','.',
/* 0x19d5c = "The certificate path has no trust anchor." */
    '\x03','\x8a','\xbc','\x1d','\xeb','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x19d6e = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x19d80 = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x19d92 = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x93','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x19da4 = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','H','L','P','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19db6 = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','F','I','L','E','_','H','A','N','D','L','E',
/* 0x19dc8 = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\xe7','V','P','_','\x9c','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x19dda = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\xa5','_','\xdb','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x19dec = "The specified path has too many components (hardening)." */
    '\x03','\x16','\xbc','\x1d','\x8d','\xa4','c','o','m','p','o','n','e','n','t','s',' ','\x9a',
/* 0x19dfe = "VINF_EM_RAW_GUEST_TRAP" */
    '\x1a','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x19e10 = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\xd7','\x9c','M','A','N','Y','_','R','A','M','_','R','A','N','G','E','S',
/* 0x19e22 = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\xb6','A','C','T','I','V','E','_','T','R','A','P',
/* 0x19e34 = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x19e46 = "VWRN_PATCH_REMOVED" */
    'V','W','R','N','_','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x19e58 = "MMIO region is already mapped." */
    '\xf9',' ','r','e','g','i','o','n',' ','\x09','\x22','m','a','p','p','e','d','.',
/* 0x19e6a = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x19e7c = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x82','\x09','\x0d','a',' ','w','r','o','n','g',' ','\xfb',
/* 0x19e8e = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x19ea0 = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x19eb2 = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\xb6','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x19ec4 = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\xa3','\xc3','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x99',
/* 0x19ed6 = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\xe7','V','P','_','T','H','R','E','A','D','_','\x15','A','L','O','N','E',
/* 0x19ee8 = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','V','D','_','V','D','I','_','\x0f','S','I','G','N','A','T','U','R','E',
/* 0x19efa = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\xf1','I','N','S','T','R','_','B','U','F','_','\x9c','L','A','R','G','E',
/* 0x19f0c = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','N','E','M','_','U','N','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x19f1e = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x9b','I','D','_','R','E','G','I','S','T','E','R',
/* 0x19f30 = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x19f42 = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x19f54 = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x15','R','E','L','A','T','I','V','E',
/* 0x19f66 = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x19f78 = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','D','I','G','E','S','T','_','\x99',
/* 0x19f8a = "Selector not present." */
    'S','e','l','e','c','t','o','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x19f9c = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','8',
/* 0x19fae = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','7',
/* 0x19fc0 = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','6',
/* 0x19fd2 = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','3',
/* 0x19fe4 = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','2',
/* 0x19ff6 = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x1a008 = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','1',
/* 0x1a01a = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','4',
/* 0x1a02c = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x1a03e = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x08','h','o','s','t','.',
/* 0x1a050 = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x93',
/* 0x1a062 = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','\xf0','A','L','I','A','S','E','D',
/* 0x1a074 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','B','E','R','_','\x9d',
/* 0x1a086 = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x1a098 = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\xe0','S','E','C','T','I','O','N',
/* 0x1a0aa = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','S','E','C','T','I','O','N',
/* 0x1a0bc = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a0ce = "VWRN_PATCH_ENABLED" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x1a0e0 = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\xd7','\x9c','M','A','N','Y','_','R','O','M','_','R','A','N','G','E','S',
/* 0x1a0f2 = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a104 = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x1a116 = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0x1a128 = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\xf1','V','A','R','_','\x15','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x1a13a = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x05','\x95',
/* 0x1a14c = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x15','\xb4',
/* 0x1a15e = "Import ISO contains a bad directory record." */
    '\xb1','\xb3',' ','\x7f','a',' ','b','a','d',' ','\x19','r','e','c','o','r','d','.',
/* 0x1a170 = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','S','S','M','_','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x1a182 = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','5',
/* 0x1a194 = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9d','_','9',
/* 0x1a1a6 = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x1a1b8 = "VINF_EM_DBG_BREAKPOINT" */
    '\x1a','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x1a1ca = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xe0','N','O','D','E',
/* 0x1a1dc = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x1a1ee = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\xa3','\xc3','\x9c','M','A','N','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x1a200 = "Invalid requested privilege level." */
    '\x0b','\xc0','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x1a212 = "Process Verification Failure: Error opening image file." */
    '\x17','\x0c','\x12','\xad','o','p','e','n','i','n','g',' ','\x1b','f','i','l','e','.',
/* 0x1a224 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','C','D','F','_','H','E','A','D','E','R',
/* 0x1a236 = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','D','I','R','_','E','N','U','M','_','\x93',
/* 0x1a248 = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\xa0','T','R','A','P','_','T','Y','P','E','_','I','P','E',
/* 0x1a25a = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xf7','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x99',
/* 0x1a26c = "Internal processing error #1 in the switcher code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','s','w','i','t','c','h','e','r',' ','\x5e',
/* 0x1a27e = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xf7','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x9d',
/* 0x1a290 = "VWRN_STATE_CHANGED" */
    'V','W','R','N','_','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x1a2a2 = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x1a2b4 = "Too many MMIO registrations." */
    '\xee','\xa4','\xf9',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x1a2c6 = "Bad file element in XAR table of content." */
    '\x92','\x18','\x1f','\x0d','X','A','R',' ','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x1a2d8 = "Recompiler: Out of stack slots." */
    '\x11','O','u','t',' ','\x14','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x1a2ea = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xd0',' ','\x94','p','a','c','k','e','t','.',
/* 0x1a2fc = "MMIO region is not mapped." */
    '\xf9',' ','r','e','g','i','o','n',' ','\x09','\x05','m','a','p','p','e','d','.',
/* 0x1a30e = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\xd7','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x1a320 = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x1a332 = "The field contains an invalid padding size." */
    '\x03','\xf5','\x7f','\x60','\x81','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x1a344 = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1a356 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','D','E','V','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a368 = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x82','t','i','m','e','r',' ','\x09','b','u','s','y','.',
/* 0x1a37a = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','C','E','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a38c = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x1a39e = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x1a','\xd7','H','A','N','D','L','E','R','_','\xf0','A','L','I','A','S','E','D',
/* 0x1a3b0 = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\xf1','E','M','I','T','_','\xa0','S','E','G','_','R','E','G','_','N','O',
/* 0x1a3c2 = "VINF_IEM_RECOMPILE_END_TB" */
    '\x1a','\xf1','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x1a3d4 = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9d','_','H','A','S','H',
/* 0x1a3e6 = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9b','M','A','C','H','I','N','E',
/* 0x1a3f8 = "Recompiler: Debug info internal processing error #1." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x13','\x04','\x07','#','1','.',
/* 0x1a40a = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x1d','\xaf','r','e','j','e','c','t','e','d','.',
/* 0x1a41c = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x15','R','E','C','O','G','N','I','Z','E','D',
/* 0x1a42e = "VERR_ISOFS_NO_ADS_FOR_UDF_DIR" */
    '\x01','\xe8','\xb6','A','D','S','_','F','O','R','_','U','D','F','_','D','I','R',
/* 0x1a440 = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\xa0','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x1a452 = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\xe8','\x0f','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x1a464 = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x0f','O','B','J','E','C','T','_','S','T','A','T','E',
/* 0x1a476 = "FTP Internal Server Error." */
    'F','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x1a488 = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x0f','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x1a49a = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x9c','M','A','N','Y','_','R','E','G','I','O','N','S',
/* 0x1a4ac = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x1a4be = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xf0','A','T','T','A','C','H','E','D',
/* 0x1a4d0 = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x1a4e2 = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\xe7','V','P','_','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x1a4f4 = "Invalid signature length." */
    '\x0b','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x1a506 = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\xb8','\xb6','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x1a518 = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xd0',' ','e','x','i','t',' ','\x5e',
/* 0x1a52a = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x1a53c = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','F','I','L','E','_','A','I','O','_','\xb6','R','E','Q','U','E','S','T',
/* 0x1a54e = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x1a560 = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0x1a572 = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\xa5','_','\xdb','T','A','K','E','S','_','D','I','R','_','O','R','_','\xa5',
/* 0x1a584 = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\xb6','R','E','F','E','R','E','N','C','E',
/* 0x1a596 = "VINF_PERMISSION_DENIED" */
    '\x1a','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x1a5a8 = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\xd7','\xb6','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x1a5ba = "The page to be freed was already freed." */
    '\x03','\xab','\x08','\x8f','f','r','e','e','d',' ','\x10','\x22','f','r','e','e','d','.',
/* 0x1a5cc = "Stream is not ready for requested operation." */
    'S','t','r','e','a','m',' ','\x09','\x05','r','e','a','d','y',' ','\x0e','\xc0','\xcf',
/* 0x1a5de = "VFS chain element expected at most six arguments." */
    '\xa5',' ','\x91','\x1f','\xb0','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xca',
/* 0x1a5f0 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\xa3','\x8c','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x1a602 = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\xdd','V','T','G','_','S','T','R','I','N','G','_','\x9c','L','O','N','G',
/* 0x1a614 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','T','Y','P','E','_','\x15','\xc7',
/* 0x1a626 = "Certificate path validator: No valid certificate policy." */
    '\xa8','\xbc','\xe6','\xce','v','a','l','i','d',' ','\x8a','p','o','l','i','c','y','.',
/* 0x1a638 = "Process Verification Failure: An image has too many regions." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x1d','\x8d','\xa4','r','e','g','i','o','n','s','.',
/* 0x1a64a = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','P','A','G','E','_','\x15','P','R','I','V','A','T','E',
/* 0x1a65c = "Deadlock detected." */
    'D','e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x1a66e = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','C','R','C',
/* 0x1a680 = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\xb8','T','R','A','N','S','L','A','T','I','O','N','_','\x15','S','E','T',
/* 0x1a692 = "The requested feature is not supported by NEM." */
    '\x03','\xc0','f','e','a','t','u','r','e',' ','\x09','\x05','\xf2','\xb9','N','E','M','.',
/* 0x1a6a4 = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\xb6','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x1a6b6 = "VERR_ISOMK_IMPORT_UDF_SPARSE_FILE" */
    '\x01','\xa3','\xc3','U','D','F','_','S','P','A','R','S','E','_','F','I','L','E',
/* 0x1a6c8 = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd9','\x09','\x05','d','a','t','a','.',
/* 0x1a6d9 = "Internal processing error #2 in the DBGF stack code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf6',' ','s','t','a','c','k',' ','\x5e',
/* 0x1a6ea = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x0f','T','Y','P','E',
/* 0x1a6fb = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x10','s','t','o','p','p','e','d','.',
/* 0x1a70c = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x1a71d = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','S','S','M','_','L','I','V','E','_','F','A','T','A','L','_','\x9d',
/* 0x1a72e = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\xb8','\xe0','D','E','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a73f = "Unable to switch due to invalid guest state." */
    '\xcc','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','\xa1','\xfb',
/* 0x1a750 = "Expected RSA private key." */
    '\xa7','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x1a761 = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x15','\xc7',
/* 0x1a772 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x1a783 = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\xa0','F','O','R','W','A','R','D','E','R',
/* 0x1a794 = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\xb8','\xe0','D','R','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a7a5 = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\xaa','X','5','0','9','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x1a7b6 = "Generic unexpected object ID error." */
    '\x96','u','n','e','x','p','e','c','t','e','d',' ','\x8e','I','D',' ','\x7b',
/* 0x1a7c7 = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','L','D','R','V','I','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1a7d8 = "Internal processing error #1 in the DBGF stack code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf6',' ','s','t','a','c','k',' ','\x5e',
/* 0x1a7e9 = "VINF_AIO_TASK_PENDING" */
    '\x1a','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x1a7fa = "Invalid parameter index." */
    '\x0b','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x1a80b = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\xd7','\x15','\xc7','_','F','O','R','_','N','E','M','_','M','O','D','E',
/* 0x1a81c = "IOMMU device is not present." */
    'I','O','M','M','U',' ','\x8b','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1a82d = "Generic out of resources error." */
    '\x96','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s',' ','\x7b',
/* 0x1a83e = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x9c','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x1a84f = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','H','E','A','D','E','R',
/* 0x1a860 = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x9d',
/* 0x1a871 = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\xe7','V','P','_','\xa0','S','E','C','T','I','O','N','_','R','V','A',
/* 0x1a882 = "Bad TRPM_TRAP_IN_OP." */
    '\x92','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x1a893 = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x9c','M','A','N','Y','_','S','E','M','A','P','H','O','R','E','S',
/* 0x1a8a4 = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x15','U','N','S','U','P','P','O','R','T','E','D',
/* 0x1a8b5 = "Too fragmented file." */
    '\xee','f','r','a','g','m','e','n','t','e','d',' ','f','i','l','e','.',
/* 0x1a8c6 = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\xa0','I','T','E','R','D','A','T','A','2',
/* 0x1a8d7 = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\xb8','\x15','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x1a8e8 = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\xb8','\xe0','U','S','B','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a8f9 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','I','O','M','M','U','_','D','T','E','_','R','E','A','D','_','\x93',
/* 0x1a90a = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x1a91b = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\xe0','T','Y','P','E','_','F','L','A','G',
/* 0x1a92c = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x1a93d = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','D','I','G','E','S','T','_','\x99',
/* 0x1a94e = "Unsupported file system charset." */
    '\x87','\x18','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x1a95f = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1a970 = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x1a981 = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x1a992 = "Recompiler: Unexpected kind of variable." */
    '\x11','\x85','k','i','n','d',' ','\x14','v','a','r','i','a','b','l','e','.',
/* 0x1a9a3 = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','V','D','_','G','E','O','M','E','T','R','Y','_','\x15','S','E','T',
/* 0x1a9b4 = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','V','M','X','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1a9c5 = "Syntax error - buggy parser." */
    '\xe2','\x07','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x1a9d6 = "VINF_BUFFER_UNDERFLOW" */
    '\x1a','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1a9e7 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\xb6','M','E','M','O','R','Y',
/* 0x1a9f8 = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x1aa09 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1aa1a = "Invalid escape sequence." */
    '\x0b','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x1aa2b = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x1aa3c = "VINF_GIM_R3_HYPERCALL" */
    '\x1a','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x1aa4d = "Image is read-only." */
    'I','m','a','g','e',' ','\x09','r','e','a','d','-','o','n','l','y','.',
/* 0x1aa5e = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x0f','C','U','S','T','O','M','_','M','O','D','E',
/* 0x1aa6f = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','M','D','K','_','\x9b','V','E','R','S','I','O','N',
/* 0x1aa80 = "Expected a provider name." */
    '\xa7','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x1aa91 = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x05','\xf2','\xb9','\x02','c','o','d','e','c','.',
/* 0x1aaa2 = "VINF_DBGC_BP_NO_COMMAND" */
    '\x1a','D','B','G','C','_','B','P','_','\xb6','C','O','M','M','A','N','D',
/* 0x1aab3 = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','L','F','_','H','E','A','D','E','R',
/* 0x1aac4 = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x1aad5 = "No data for this block in image." */
    '\xce','\x90','\x0e','\xcb','b','l','o','c','k',' ','\x0d','i','m','a','g','e','.',
/* 0x1aae6 = "Unexpected end of DWARF unit." */
    '\x85','e','n','d',' ','\x14','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x1aaf7 = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x15','A','L','L','O','W','E','D',
/* 0x1ab08 = "VINF_EM_RAW_IRET_TRAP" */
    '\x1a','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x1ab19 = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\xf0','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1ab2a = "No node was specified." */
    '\xce','n','o','d','e',' ','\x10','s','p','e','c','i','f','i','e','d','.',
/* 0x1ab3b = "Unknown I/O instruction." */
    '\xd8','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x1ab4c = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x1ab5d = "Unit header integrity error." */
    'U','n','i','t',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x1ab6e = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\xe8','W','R','O','N','G','_','F','I','L','E','_','T','Y','P','E',
/* 0x1ab7f = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\xb6','U','N','W','I','N','D','_','I','N','F','O',
/* 0x1ab90 = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','P','R','E','S','E','N','T',
/* 0x1aba1 = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\xd7','P','O','O','L','_','G','E','T','_','P','A','G','E','_','\x93',
/* 0x1abb2 = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\xd7','\x0f','P','A','G','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x1abc3 = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x7b',
/* 0x1abd4 = "VWRN_NO_TRANSLATION" */
    'V','W','R','N','_','\xb6','T','R','A','N','S','L','A','T','I','O','N',
/* 0x1abe5 = "VWRN_NO_DIRENT_INFO" */
    'V','W','R','N','_','\xb6','D','I','R','E','N','T','_','I','N','F','O',
/* 0x1abf6 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x9c','M','A','N','Y','_','O','P','E','N','_','F','I','L','E','S',
/* 0x1ac07 = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x14','t','w','o','.',
/* 0x1ac18 = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x1ac29 = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xf6','_','\xb6','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x1ac3a = "Bad forwarder entry." */
    '\x92','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x1ac4b = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1ac5c = "VINF_CPUM_R3_MSR_READ" */
    '\x1a','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x1ac6d = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xa2','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x1ac7e = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9d','_','H','D','R',
/* 0x1ac8f = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\xaa','X','5','0','9','_','I','N','T','E','R','N','A','L','_','\x9d',
/* 0x1aca0 = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9c','M','U','C','H',
/* 0x1acb1 = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x15','F','I','L','E','_','S','C','H','E','M','E',
/* 0x1acc2 = "VWRN_CSAM_PAGE_NOT_FOUND" */
    'V','W','R','N','_','C','S','A','M','_','P','A','G','E','_','\x15','\xb4',
/* 0x1acd3 = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','P','A','G','E','_','\x15','S','H','A','R','E','D',
/* 0x1ace4 = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x15','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x1acf5 = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\xe8','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x1ad06 = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\xa3','\xc3','\x9c','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x1ad17 = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1ad28 = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\xa5','_','\xdb','O','N','L','Y','_','D','I','R','_','O','R','_','\xa5',
/* 0x1ad39 = "Unable to parse string as bool." */
    '\xcc','\x08','p','a','r','s','e',' ','\xc9','a','s',' ','b','o','o','l','.',
/* 0x1ad4a = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x0f','C','H','I','L','D','_','P','A','T','H',
/* 0x1ad5b = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','\xec','\x1d','\x22','\xaf','r','e','s','e','t','.',
/* 0x1ad6c = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x1ad7d = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','S','I','Z','E',
/* 0x1ad8e = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x1ad9f = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x15','N','M','_','M','A','P','_','F','I','L','E',
/* 0x1adb0 = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x99',
/* 0x1adc1 = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\xd7','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x1add2 = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0X1ade3 = "EVP_DecryptInit failed." */
    'V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1adf3 = "VINF_VHWA_CMD_PENDING" */
    '\x1a','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x1ae04 = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\xdd','V','T','G','_','\xf0','R','E','G','I','S','T','E','R','E','D',
/* 0x1ae15 = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x99','_','V','M','C','P','U','_','S','I','Z','E',
/* 0x1ae26 = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x1ae37 = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d','.',
/* 0x1ae48 = "Unknown location opcode." */
    '\xd8','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x1ae59 = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','S','S','M','_','\x9c','M','A','N','Y','_','P','A','S','S','E','S',
/* 0x1ae6a = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x1ae7b = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x15','\xb4',
/* 0x1ae8c = "The MMIO range specified for removal was not found." */
    '\x03','\xf9',' ','\xe5','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','\x05','\x7d',
/* 0x1ae9d = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','V','D','_','C','A','C','H','E','_','\xf0','E','X','I','S','T','S',
/* 0x1aeae = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x9c','H','I','G','H',
/* 0x1aebf = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x1aed0 = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x1aee1 = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\xd7','L','O','A','D','_','\xd4','P','A','G','E','_','T','Y','P','E',
/* 0x1aef2 = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','P','U','I','D','_','\x99',
/* 0x1af03 = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x0f','B','A','S','E','6','4','_','E','N','C','O','D','I','N','G',
/* 0x1af14 = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1af25 = "No logger instance." */
    '\xce','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x1af36 = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x1af47 = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x15','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x1af58 = "Pipe is not connected." */
    'P','i','p','e',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x1af69 = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x15','\xc7',
/* 0x1af7a = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1af8b = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xf7','\x0f','O','B','J','I','D','_','E','N','C','O','D','I','N','G',
/* 0x1af9c = "Bad load command(s)." */
    '\x92','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x1afad = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x1afbe = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1afcf = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x15','\xb4',
/* 0x1afe0 = "Too many symbolic links." */
    '\xee','\xa4','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x1aff1 = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x1b002 = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','V','A','L','U','E',
/* 0x1b013 = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1b024 = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x1b035 = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','V','D','_','V','M','D','K','_','V','A','L','U','E','_','\x15','\xb4',
/* 0x1b046 = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','L','D','R','M','A','C','H','O','_','B','I','T','_','M','I','X',
/* 0x1b057 = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x1b068 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x93',
/* 0x1b079 = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x0f','P','O','R','T','_','N','U','M','B','E','R',
/* 0x1b08a = "Unsupported CPU ID register." */
    '\x87','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x1b09b = "The requested type conversion was not supported." */
    '\x03','\xc0','\xda','c','o','n','v','e','r','s','i','o','n',' ','\x10','\x05','\x95',
/* 0x1b0ac = "VINF_OBJECT_DESTROYED" */
    '\x1a','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1b0bd = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','L','X',' ','\xa2','\x24',
/* 0x1b0ce = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x1b0df = "ASN.1 object is not present." */
    'A','S','N','.','1',' ','\x8e','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1b0f0 = "Bad file mode for XAR file." */
    '\x92','\x18','m','o','d','e',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1b101 = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1b112 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x15','W','A','I','T','A','B','L','E',
/* 0x1b123 = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x1b134 = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\xb6','U','R','B','_','M','E','M','O','R','Y',
/* 0x1b145 = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x15','\xb4',
/* 0x1b156 = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x1b167 = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\xa0','T','R','A','P','_','I','N','_','O','P',
/* 0x1b178 = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x1b189 = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x15','\xb4',
/* 0x1b19a = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x1b1ab = "VINF_VRDP_PROCESS_PDU" */
    '\x1a','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x1b1bc = "Invalid I/O port handle." */
    '\x0b','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x1b1cd = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x1b1de = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x15','E','M','P','T','Y',
/* 0x1b1ef = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xf7','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x1b200 = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x15','\xb4',
/* 0x1b211 = "Invalid Base64 encoding." */
    '\x0b','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x1b222 = "Bad new tree height." */
    '\x92','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x1b233 = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xf6','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x93',
/* 0x1b244 = "VINF_IPC_SEND_MSG_CUT" */
    '\x1a','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x1b255 = "Import ISO contains more than volume." */
    '\xb1','\xb3',' ','\x7f','\xfc','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x1b266 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\xe8','\x9c','M','A','N','Y','_','P','A','R','T','_','M','A','P','S',
/* 0x1b277 = "The semaphore is set and cannot be closed." */
    '\x03','\xec','\x09','s','e','t',' ','\x2a','\xba','\x8f','c','l','o','s','e','d','.',
/* 0x1b288 = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xf6','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x93',
/* 0x1b299 = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\xaa','P','K','I','X','_','I','N','T','E','R','N','A','L','_','\x9d',
/* 0x1b2aa = "VINF_PCI_MAPPING_DONE" */
    '\x1a','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x1b2bb = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','G','E','N','E','R','I','C','_','\x9d',
/* 0x1b2cc = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','B','O','L',
/* 0x1b2dd = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\x94','\x09','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x1b2ee = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x1a','\xf1','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x1b2ff = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x1b310 = "VERR_ISOMK_IMPORT_UDF_UNSUPPORTED_FILE_TYPE" */
    '\x01','\xa3','\xc3','U','D','F','_','\x9b','F','I','L','E','_','T','Y','P','E',
/* 0x1b321 = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\xa5','_','\xdb','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x1b332 = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd1','\x05','\x7d',
/* 0x1b343 = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x1b354 = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\xaa','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x9d',
/* 0x1b365 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x1b376 = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','H','E','A','D','E','R',
/* 0x1b387 = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','\xf8','\x09','\x8d','l','o','n','g','.',
/* 0x1b398 = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x09','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x1b3a9 = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x1b3ba = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\xb8','T','H','R','E','A','D','_','\x0f','C','A','L','L','E','R',
/* 0x1b3ca = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x1b3da = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1b3ea = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\xe7','V','P','_','S','T','U','B','_','O','P','E','N','_','\x9d',
/* 0x1b3fa = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\xb6','C','O','N','F','L','I','C','T',
/* 0x1b40a = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\xf1','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x1b41a = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x15','P','A','G','E','_','O','W','N','E','R',
/* 0x1b42a = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x1b43a = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x1b44a = "NEM is not available." */
    'N','E','M',' ','\x09','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x1b45a = "Trailing spaces." */
    'T','r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x1b46a = "Expected RSA public key." */
    '\xa7','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1b47a = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x8c','1',
/* 0x1b48a = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\xb6','V','O','L','U','M','E',
/* 0x1b49a = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','F','I','L','E','_','\x99',
/* 0x1b4aa = "VERR_VM_REQUEST_STATE" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1b4ba = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x1a','V','M','M','_','\xe0','R','I','N','G','3','_','C','A','L','L',
/* 0x1b4ca = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','N','E','M','_','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x1b4da = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x7b',
/* 0x1b4ea = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\xa5','_','\xdb','F','I','N','A','L','_','T','Y','P','E','_','\x99',
/* 0x1b4fa = "VINF_PATM_PATCH_INT3" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x1b50a = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x0f','U','T','F','1','6','_','E','N','C','O','D','I','N','G',
/* 0x1b51a = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xb6','A','T','T','A','C','H',
/* 0x1b52a = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xf6','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x1b53a = "Bad VTG bit count value." */
    '\x92','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xd2',
/* 0x1b54a = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\xe7','V','P','_','\xa0','I','M','A','G','E','_','B','A','S','E',
/* 0x1b55a = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1b56a = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','O','P','E','N','E','D',
/* 0x1b57a = "Unexpected SVM patch type." */
    '\x85','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x1b58a = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x1a','I','O','M','_','\xf9','_','U','N','U','S','E','D','_','F','F',
/* 0x1b59a = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xd0','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0x1b5aa = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x1b5ba = "Generic not found warning." */
    '\x96','\x05','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x1b5ca = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x1a','G','V','M','_','\x15','B','U','S','Y','_','I','N','_','G','C',
/* 0x1b5da = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x9c','B','I','G',
/* 0x1b5ea = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xd0','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1b5fa = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\xe8','\xa0','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x1b60a = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1b61a = "Encountered an unknown type flag." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','\xda','f','l','a','g','.',
/* 0x1b62a = "Internal processing error in the page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','\xab','a','l','l','o','c','a','t','o','r','.',
/* 0x1b63a = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\xb6','R','3','_','\xf9','_','R','A','N','G','E',
/* 0x1b64a = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xb6','A','T','T','A','C','H',
/* 0x1b65a = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x15','H','E','L','D',
/* 0x1b66a = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x15','\xb4',
/* 0x1b67a = "Bad MH_OBJECT file." */
    '\x92','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x1b68a = "VINF_TCP_SERVER_STOP" */
    '\x1a','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b69a = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\xd7','S','A','V','E','D','_','R','E','C','_','T','Y','P','E',
/* 0x1b6aa = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\xa0','C','L','O','C','K',
/* 0x1b6ba = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','H','D','R',
/* 0x1b6ca = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','S','T','A','T','E',
/* 0x1b6da = "Image Verification Failure:." */
    'I','m','a','g','e',' ','\x0c','F','a','i','l','u','r','e',':','.',
/* 0x1b6ea = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x1b6fa = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x1d','\x8d','\xa4','C','P','U','s','.',
/* 0x1b70a = "VINF_EM_TRIPLE_FAULT" */
    '\x1a','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x1b71a = "Unsupported X.509 certificate version." */
    '\x87','X','.','5','0','9',' ','\x8a','v','e','r','s','i','o','n','.',
/* 0x1b72a = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\xb8','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x1b73a = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x1b74a = "VERR_SSM_UNIT_EXISTS" */
    '\x01','S','S','M','_','U','N','I','T','_','E','X','I','S','T','S',
/* 0x1b75a = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\xaa','R','A','N','D','O','M','_','S','E','T','U','P','_','\x93',
/* 0x1b76a = "VINF_CALLBACK_RETURN" */
    '\x1a','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1b77a = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x1b78a = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\xf0','D','I','S','A','B','L','E','D',
/* 0x1b79a = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x1b7aa = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\xb8','\xb6','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x1b7ba = "Unknown file system format." */
    '\xd8','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1b7ca = "The table of content (TOC) is too big." */
    '\x03','\x9f','\x14','\xd9','(','T','O','C',')',' ','\x09','\x8d','b','i','g','.',
/* 0x1b7da = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x1b7ea = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0x1b7fa = "TM requires GIP." */
    'T','M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x1b80a = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\xd4','P','A','T','C','H','_','T','Y','P','E',
/* 0x1b81a = "Unsupported file system format." */
    '\x87','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1b82a = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xd0','_','D','R','I','V','E','R','_','L','O','A','D','_','\x9d',
/* 0x1b83a = "Invalid opcode byte(s)." */
    '\x0b','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x1b84a = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x1b85a = "Invalid segment offset." */
    '\x0b','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x1b86a = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x1b87a = "Syntax error - invalid operation attempted." */
    '\xe2','\x07','-',' ','\x81','\x83','a','t','t','e','m','p','t','e','d','.',
/* 0x1b88a = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\xa0','M','O','D','E','_','F','I','E','L','D',
/* 0x1b89a = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xf6','_','\xb6','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x1b8aa = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','I','N','O','D','E',
/* 0x1b8ba = "Patch was already enabled." */
    'P','a','t','c','h',' ','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x1b8ca = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x1b8da = "Unknown or invalid GIM provider." */
    '\xd8','\x86','\x81','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x1b8ea = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b8fa = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','V','M','X','_','\x0f','H','O','S','T','_','S','T','A','T','E',
/* 0x1b90a = "VINF_HGCM_SAVE_STATE" */
    '\x1a','H','G','C','M','_','S','A','V','E','_','S','T','A','T','E',
/* 0x1b91a = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x15','\xc7',
/* 0x1b92a = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\xa3','\x8c','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x1b93a = "The specified data unit wasn\'t found." */
    '\x03','\x16','\x90','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x1b94a = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\xa0','P','A','G','E','_','M','A','P',
/* 0x1b95a = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x15','\xc7',
/* 0x1b96a = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\x94','\x10','c','a','n','c','e','l','e','d','.',
/* 0x1b97a = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\xd7','H','A','N','D','Y','_','P','A','G','E','_','I','P','E',
/* 0x1b98a = "VINF_BUFFER_OVERFLOW" */
    '\x1a','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1b99a = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xf7','\x9c','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1b9aa = "Invalid HGCM client id." */
    '\x0b','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x1b9ba = "VINF_VMM_CALL_TRACER" */
    '\x1a','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x1b9ca = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\xaa','P','K','I','X','_','G','E','N','E','R','I','C','_','\x9d',
/* 0x1b9da = "VERR_LDRVI_PARSE_IPE" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','I','P','E',
/* 0x1b9ea = "Process Verification Failure: The process is being debugged." */
    '\x17','\x0c','\x12','\x03','\x82','\x09','\xdc','d','e','b','u','g','g','e','d','.',
/* 0x1b9fa = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','S','I','Z','E',
/* 0x1ba0a = "Failed to map a memory object." */
    '\x80','\x08','m','a','p',' ','a',' ','\x5c','o','b','j','e','c','t','.',
/* 0x1ba1a = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x1ba2a = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xd0','_','D','R','I','V','E','R','_','O','P','E','N','_','\x9d',
/* 0x1ba3a = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xf0','O','P','E','N','E','D',
/* 0x1ba4a = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    'V','W','R','N','_','V','R','D','P','_','P','D','U','_','\x15','\xc7',
/* 0x1ba5a = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\xaa','X','5','0','9','_','\x15','V','E','R','I','F','I','E','D',
/* 0x1ba6a = "Generic VM-exit failure." */
    '\x96','\xd0','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x1ba7a = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','B','E','_','L','O','C',
/* 0x1ba8a = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x1ba9a = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x9d',
/* 0x1baaa = "Process Verification Failure: The memory content does not match the image file." */
    '\x17','\x0c','\x12','\x03','\x5c','\xd9','\x9e','\x05','\xe4','\x02','\x1b','f','i','l','e','.',
/* 0x1baba = "VINF_HM_DOUBLE_FAULT" */
    '\x1a','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x1baca = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x0f','C','L','I','E','N','T','_','I','D',
/* 0x1bada = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','S','S','M','_','U','N','I','T','_','\x15','O','W','N','E','R',
/* 0x1baea = "VINF_HM_PENDING_XCPT" */
    '\x1a','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x1bafa = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\xf0','T','I','C','K','I','N','G',
/* 0x1bb0a = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x0f','C','O','D','E','P','O','I','N','T',
/* 0x1bb1a = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x1bb2a = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x93',
/* 0x1bb3a = "The key was decrypted." */
    '\x03','k','e','y',' ','\x10','d','e','c','r','y','p','t','e','d','.',
/* 0x1bb4a = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x9c','L','O','N','G','_','I','N','S','T','R',
/* 0x1bb5a = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1bb6a = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x1bb7a = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x93',
/* 0x1bb8a = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x1bb9a = "Image Verification Failure: Invalid section count." */
    'I','m','a','g','e',' ','\x0c','\x12','\x0b','\xc8','c','o','u','n','t','.',
/* 0x1bbaa = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xc9','\x09','\x8d','l','o','n','g','.',
/* 0x1bbba = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','D','I','_','\x9b','V','E','R','S','I','O','N',
/* 0x1bbca = "VINF_PGM_GCPHYS_ALIASED" */
    '\x1a','\xd7','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x1bbda = "Bad argument flags." */
    '\x92','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x1bbea = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x0f','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x1bbfa = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\xdd','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x1bc0a = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','F','O','R','M','A','T',
/* 0x1bc1a = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1bc2a = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x1bc3a = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xf7','C','U','R','S','O','R','_','\x15','A','T','_','E','N','D',
/* 0x1bc4a = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x9d',
/* 0x1bc5a = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0x1bc6a = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\xf0','E','N','A','B','L','E','D','_','I','P','E',
/* 0x1bc7a = "Bad DWARF position." */
    '\x92','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x1bc8a = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x1bc9a = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x0f','S','E','G','_','O','F','F','S','E','T',
/* 0x1bcaa = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\xaa','X','5','0','9','_','G','E','N','E','R','I','C','_','\x9d',
/* 0x1bcba = "Recompiler: Out of variables." */
    '\x11','O','u','t',' ','\x14','v','a','r','i','a','b','l','e','s','.',
/* 0x1bcca = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x15','C','O','N','N','E','C','T','E','D',
/* 0x1bcda = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','H','E','I','G','H','T',
/* 0x1bcea = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','_','S','E','Q',
/* 0x1bcfa = "VINF_UDP_SERVER_STOP" */
    '\x1a','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1bd0a = "Error getting the file mode." */
    '\xad','g','e','t','t','i','n','g',' ','\x02','\x18','m','o','d','e','.',
/* 0x1bd1a = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','\x15','M','O','U','N','T','E','D',
/* 0x1bd2a = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x1a','\xb8','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1bd3a = "Internal processing error #1 in the DBGF core code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf6',' ','c','o','r','e',' ','\x5e',
/* 0x1bd4a = "VWRN_NUMBER_TOO_BIG" */
    'V','W','R','N','_','N','U','M','B','E','R','_','\x9c','B','I','G',
/* 0x1bd5a = "Internal processing error in the critical section code." */
    '\x06','\x04','\x07','\x0d','\x02','c','r','i','t','i','c','a','l',' ','\xc8','\x5e',
/* 0x1bd6a = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\xf1','E','M','I','T','_','\xa0','M','E','M','_','S','I','Z','E',
/* 0x1bd7a = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x93',
/* 0x1bd8a = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\xe7','V','P','_','F','I','L','E','_','M','O','D','E','_','\x9d',
/* 0x1bd9a = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\xb8','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1bdaa = "Bogus UDF directory size." */
    'B','o','g','u','s',' ','U','D','F',' ','\x19','s','i','z','e','.',
/* 0x1bdba = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x1bdca = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x0f','N','O','D','E','_','P','A','T','H',
/* 0x1bdda = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x9d',
/* 0x1bdea = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xf7','\x0f','N','U','L','L','_','E','N','C','O','D','I','N','G',
/* 0x1bdfa = "Encountered an unexpected VM state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xd0',' ','\xfb',
/* 0x1be0a = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x15','\xb4',
/* 0x1be1a = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x99',
/* 0x1be2a = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\x9f','\x14','\xd9','\xc4','\xa6','m','a','t','c','h','.',
/* 0x1be3a = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x1be4a = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x7b',
/* 0x1be5a = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\xb8','\xb6','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1be6a = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','\x05','\x7d',
/* 0x1be7a = "VINF_IOM_MMIO_UNUSED_00" */
    '\x1a','I','O','M','_','\xf9','_','U','N','U','S','E','D','_','0','0',
/* 0x1be8a = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\xa3','\xc3','\x0f','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x1be9a = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\xf0','O','W','N','E','D',
/* 0x1beaa = "Vote for giving up." */
    'V','o','t','e',' ','\x0e','g','i','v','i','n','g',' ','u','p','.',
/* 0x1beba = "Bad VTG attribute value." */
    '\x92','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xd2',
/* 0x1beca = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\xe7','V','P','_','\xa0','I','M','A','G','E','_','S','I','Z','E',
/* 0x1beda = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x0f','S','E','S','S','I','O','N','_','I','D',
/* 0x1beea = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x1befa = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0X1bf0a = "Receive timeout." */
    'e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x1bf19 = "VINF_PATM_SPINLOCK_FAILED" */
    '\x1a','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x93',
/* 0x1bf29 = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x9c','M','A','N','Y','_','T','I','M','E','R','S',
/* 0x1bf39 = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','H','E','A','D','E','R',
/* 0x1bf49 = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1bf59 = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\xb6','I','M','A','G','E','_','U','U','I','D',
/* 0x1bf69 = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1bf79 = "Receive aborted." */
    'R','e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x1bf89 = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x9c','M','U','C','H',
/* 0x1bf99 = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x1bfa8 = "VINF_EM_DBG_STEPPED" */
    '\x1a','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x1bfb7 = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','N','E','M','_','\xd0','_','C','R','E','A','T','E','_','\x93',
/* 0x1bfc6 = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\xd4','X','C','P','T','_','E','X','I','T',
/* 0x1bfd5 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x1bfe4 = "VERR_DBGC_PARSE_BUG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','B','U','G',
/* 0x1bff3 = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\xf1','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x1c002 = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\xaa','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x1c011 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','N','E','M','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x1c020 = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\xe8','F','S','D','_','\x9b','C','H','A','R','_','S','E','T',
/* 0x1c02f = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','M','O','D','E',
/* 0x1c03e = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x15','C','O','N','N','E','C','T','E','D',
/* 0x1c04d = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x9b','I','N','T','E','R','F','A','C','E',
/* 0x1c05c = "The specified cpu is offline." */
    '\x03','\x16','c','p','u',' ','\x09','o','f','f','l','i','n','e','.',
/* 0x1c06b = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x15','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x1c07a = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x1c089 = "Unable to decode date value." */
    '\xcc','\x08','d','e','c','o','d','e',' ','d','a','t','e',' ','\xd2',
/* 0x1c098 = "VERR_VD_DEK_MISSING" */
    '\x01','V','D','_','D','E','K','_','M','I','S','S','I','N','G',
/* 0x1c0a7 = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','V','I','D','E','R',
/* 0x1c0b6 = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xf9','_','R','A','N','G','E','_','\x15','\xb4',
/* 0x1c0c5 = "VERR_NEM_RING3_ONLY" */
    '\x01','N','E','M','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x1c0d4 = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x7b',
/* 0x1c0e3 = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x1c0f2 = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','M','I','S','C',
/* 0x1c101 = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x1c110 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','_','\x93',
/* 0x1c11f = "Too many CPUID leaves." */
    '\xee','\xa4','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x1c12e = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','I','O','M','M','U','_','C','M','D','_','H','W','_','\x9d',
/* 0x1c13d = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x1c14c = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x0f','O','B','J','E','C','T','_','I','D',
/* 0x1c15b = "Invalid guest LDT selector." */
    '\x0b','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x1c16a = "Bad descriptor tag checksum." */
    '\x92','\xcd','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x1c179 = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x15','F','O','R','W','A','R','D','E','R',
/* 0x1c188 = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x9c','L','A','R','G','E',
/* 0x1c197 = "The OS was not detected." */
    '\x03','O','S',' ','\x10','\x05','d','e','t','e','c','t','e','d','.',
/* 0x1c1a6 = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x93',
/* 0x1c1b5 = "VWRN_WRONG_TYPE" */
    'V','W','R','N','_','W','R','O','N','G','_','T','Y','P','E',
/* 0x1c1c4 = "Data size overflow." */
    'D','a','t','a',' ','\xdf','o','v','e','r','f','l','o','w','.',
/* 0x1c1d3 = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','V','E','R','S','I','O','N',
/* 0x1c1e2 = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\xa5','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x1c1f1 = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\xe0','F','I','L','E','_','T','Y','P','E',
/* 0x1c200 = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','W','R','I','T','E',
/* 0x1c20f = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x1c21e = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','V','D','_','R','A','W','_','\x0f','H','E','A','D','E','R',
/* 0x1c22d = "VWRN_INVALID_PARAMETER" */
    'V','W','R','N','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1c23c = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x1c24b = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x15','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x1c25a = "Bad VTG header - to high value." */
    '\x92','V','T','G',' ','\xa2','-',' ','\x08','h','i','g','h',' ','\xd2',
/* 0x1c269 = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\xb8','\xb6','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x1c278 = "Bad VTG provider descriptor." */
    '\x92','V','T','G',' ','p','r','o','v','i','d','e','r',' ','\xf4',
/* 0x1c287 = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','S','T','A','T','E',
/* 0x1c296 = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\xe7','V','P','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1c2a5 = "The specified path was not absolute (hardening)." */
    '\x03','\x16','\xbc','\x10','\x05','a','b','s','o','l','u','t','e',' ','\x9a',
/* 0x1c2b4 = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\xe8','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0X1c2c3 = "Send cancelled." */
    'e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x1c2d1 = "The operation has already been cancelled." */
    '\x03','\x83','\x1d','\x22','\xaf','c','a','n','c','e','l','l','e','d','.',
/* 0x1c2e0 = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','I','O','M','M','U','_','\x15','P','R','E','S','E','N','T',
/* 0x1c2ef = "The specified thread is dead." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','d','e','a','d','.',
/* 0x1c2fe = "Process Verification Failure: Error reading image file header." */
    '\x17','\x0c','\x12','\xad','r','e','a','d','i','n','g',' ','\x1b','\x18','\xe9',
/* 0x1c30d = "VERR_PGM_NOT_USED_IN_MODE" */
    '\x01','\xd7','\x15','U','S','E','D','_','I','N','_','M','O','D','E',
/* 0x1c31c = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1b','\x09','\x05','\x95',
/* 0x1c32b = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','V','D','_','D','M','G','_','\x0f','H','E','A','D','E','R',
/* 0x1c33a = "Syntax error - function not found." */
    '\xe2','\x07','-',' ','f','u','n','c','t','i','o','n',' ','\x05','\x7d',
/* 0x1c349 = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x15','U','S','T','A','R','_','V','0','0',
/* 0x1c358 = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\xe7','V','P','_','S','Y','S','F','E','R','_','D','L','L',
/* 0x1c367 = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x9c','F','U','L','L',
/* 0x1c376 = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','P','A','G','E','_','\xf0','F','R','E','E',
/* 0x1c385 = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x1c394 = "VERR_FILE_LOCK_LOST" */
    '\x01','F','I','L','E','_','L','O','C','K','_','L','O','S','T',
/* 0x1c3a3 = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x0f','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x1c3b2 = "VERR_IO_GEN_FAILURE" */
    '\x01','I','O','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1c3c1 = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x15','\xb4',
/* 0x1c3d0 = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x1a','\xf6','_','B','P','_','\xf0','D','I','S','A','B','L','E','D',
/* 0x1c3df = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x1c3ee = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\xaa','K','E','Y','_','\xb6','D','E','K','_','I','N','F','O',
/* 0x1c3fd = "Process Verification Failure: Bad image signature." */
    '\x17','\x0c','\x12','\x92','\x1b','s','i','g','n','a','t','u','r','e','.',
/* 0x1c40c = "PML4 entry not present." */
    'P','M','L','4',' ','\xb7','\x05','p','r','e','s','e','n','t','.',
/* 0x1c41b = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x0f','H','M','6','4','O','N','3','2','O','P',
/* 0x1c42a = "VINF_GETOPT_NOT_OPTION" */
    '\x1a','G','E','T','O','P','T','_','\x15','O','P','T','I','O','N',
/* 0x1c439 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\xb8','\xb6','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1c448 = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x1c457 = "Unknown glob variable." */
    '\xd8','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x1c466 = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','V','M','X','_','\x0f','V','M','X','O','N','_','P','T','R',
/* 0x1c475 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x1c484 = "VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG" */
    '\x01','\xa3','\xc3','U','D','F','_','D','I','R','_','\x9c','B','I','G',
/* 0x1c493 = "Invalid magic or cookie." */
    '\x0b','m','a','g','i','c',' ','\x86','c','o','o','k','i','e','.',
/* 0x1c4a2 = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\xe0','O','P','T','I','O','N',
/* 0x1c4b1 = "Unknown saved state record." */
    '\xd8','s','a','v','e','d',' ','\xae','r','e','c','o','r','d','.',
/* 0x1c4c0 = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\xe8','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x1c4cf = "VFS chain element provider not found." */
    '\xa5',' ','\x91','\x1f','p','r','o','v','i','d','e','r',' ','\x05','\x7d',
/* 0x1c4de = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xb5','\x09','\x05','\x95',
/* 0x1c4ed = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','\xc9','\xd2',
/* 0x1c4fc = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\xb8','G','E','O','M','E','T','R','Y','_','\x15','S','E','T',
/* 0x1c50b = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xa6','\xb2','S','M','P','.',
/* 0x1c51a = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x1c529 = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\xa5','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x1c538 = "No read callback." */
    '\xce','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x1c547 = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x7b',
/* 0x1c556 = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','T','Y','P','E',
/* 0x1c565 = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','V','D','_','\xe0','C','F','G','_','V','A','L','U','E','S',
/* 0x1c574 = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','V','M','X','_','\xd4','E','X','C','E','P','T','I','O','N',
/* 0x1c583 = "The specified data unit already exist." */
    '\x03','\x16','\x90','u','n','i','t',' ','\x22','e','x','i','s','t','.',
/* 0x1c592 = "VERR_SUPLIB_IS_FILE" */
    '\x01','S','U','P','L','I','B','_','I','S','_','F','I','L','E',
/* 0x1c5a1 = "Invalid segment index." */
    '\x0b','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x1c5b0 = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\xa5','_','\x9b','C','R','E','A','T','E','_','T','Y','P','E',
/* 0x1c5bf = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x93',
/* 0x1c5ce = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x9d',
/* 0x1c5dd = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x1c5ec = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','S','I','Z','E','_','\x15','Z','E','R','O',
/* 0x1c5fb = "VINF_PATCH_CONTINUE" */
    '\x1a','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x1c60a = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\xf0','P','A','U','S','E','D',
/* 0x1c619 = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\xf0','E','N','A','B','L','E','D',
/* 0x1c628 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x09','s','a','v','i','n','g',' ','\xfb',
/* 0x1c637 = "Invalid VMXON pointer." */
    '\x0b','V','M','X','O','N',' ','p','o','i','n','t','e','r','.',
/* 0x1c646 = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x0f','V','A','L','U','E',
/* 0x1c655 = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','S','S','M','_','\xb6','L','O','A','D','_','E','X','E','C',
/* 0x1c664 = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','V','E','R','S','I','O','N',
/* 0x1c673 = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xd0','_','F','A','T','A','L','_','W','A','I','T','_','\x9d',
/* 0x1c682 = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x09','\x05','r','o','o','t',' ','\x9a',
/* 0x1c691 = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\xe8','\xa0','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x1c6a0 = "Invalid host bit mask." */
    '\x0b','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x1c6af = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x1d','\x24',
/* 0x1c6be = "Unexpected number of valid paths." */
    '\x85','\xde','\x14','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x1c6cd = "VERR_CR_KEY_FORMAT_NOT_SUPPORTED" */
    '\x01','\xaa','K','E','Y','_','F','O','R','M','A','T','_','\x15','\xc7',
/* 0x1c6dc = "Invalid dotted string." */
    '\x0b','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x1c6eb = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x9c','F','E','W',
/* 0x1c6fa = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x9c','L','O','N','G',
/* 0x1c709 = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','S','S','M','_','\xf0','C','A','N','C','E','L','L','E','D',
/* 0x1c718 = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\xd7','P','H','Y','S','_','\x0f','P','A','G','E','_','I','D',
/* 0x1c727 = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x1c736 = "The digest algorithm is not known to us." */
    '\x03','\xc4','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x1c745 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x1c754 = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\xf1','\x0f','O','P','E','R','A','N','D','_','S','I','Z','E',
/* 0x1c763 = "Reason for leaving RZ: MMIO write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf9',' ','w','r','i','t','e','.',
/* 0x1c772 = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x15','\xb4',
/* 0x1c781 = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\xaa','S','P','C','_','G','E','N','E','R','I','C','_','\x9d',
/* 0x1c790 = "Virtual HDD is not opened." */
    '\xe3',' ','H','D','D',' ','\x09','\x05','o','p','e','n','e','d','.',
/* 0x1c79f = "Patch was removed." */
    'P','a','t','c','h',' ','\x10','r','e','m','o','v','e','d','.',
/* 0x1c7ae = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x1c7bd = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\xf0','C','O','N','N','E','C','T','E','D',
/* 0x1c7cc = "Unsupported character set." */
    '\x87','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x1c7db = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','V','D','_','G','E','N','_','\x0f','H','E','A','D','E','R',
/* 0x1c7ea = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x15','P','R','E','S','E','N','T',
/* 0x1c7f9 = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xf7','\x0f','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x1c808 = "VINF_IOM_R3_MMIO_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf9','_','W','R','I','T','E',
/* 0x1c817 = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x15','\xc7',
/* 0x1c826 = "The specified LUN is invalid." */
    '\x03','\x16','L','U','N',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x1c835 = "Write protect error." */
    'W','r','i','t','e',' ','p','r','o','t','e','c','t',' ','\x7b',
/* 0x1c844 = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\xd7','P','H','Y','S','_','\xf9','_','E','X','_','I','P','E',
/* 0x1c853 = "VERR_DBGC_BP_EXISTS" */
    '\x01','D','B','G','C','_','B','P','_','E','X','I','S','T','S',
/* 0x1c862 = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x1c871 = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x93',
/* 0x1c880 = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1c88f = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x1c89e = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\xe0','T','Y','P','E','_','F','L','A','G',
/* 0x1c8ad = "VERR_LOG_REVIS