/** @file
 * VirtualBox API class wrapper code for IPerformanceMetric.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PERFORMANCEMETRIC

#include "PerformanceMetricWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PerformanceMetricWrap)

//
// IPerformanceMetric properties
//

STDMETHODIMP PerformanceMetricWrap::COMGETTER(MetricName)(BSTR *aMetricName)
{
    LogRelFlow(("{%p} %s: enter aMetricName=%p\n", this, "PerformanceMetric::getMetricName", aMetricName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMetricName);
        BSTROutConverter TmpMetricName(aMetricName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_METRICNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMetricName(TmpMetricName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_METRICNAME_RETURN(this, hrc, 0 /*normal*/,TmpMetricName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_METRICNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_METRICNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMetricName=%ls hrc=%Rhrc\n", this, "PerformanceMetric::getMetricName", *aMetricName, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(Object)(IUnknown **aObject)
{
    LogRelFlow(("{%p} %s: enter aObject=%p\n", this, "PerformanceMetric::getObject", aObject));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aObject);
        ComTypeOutConverter<IUnknown> TmpObject(aObject);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_OBJECT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getObject(TmpObject.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_OBJECT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpObject.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_OBJECT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_OBJECT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aObject=%p hrc=%Rhrc\n", this, "PerformanceMetric::getObject", *aObject, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "PerformanceMetric::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "PerformanceMetric::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(Period)(ULONG *aPeriod)
{
    LogRelFlow(("{%p} %s: enter aPeriod=%p\n", this, "PerformanceMetric::getPeriod", aPeriod));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPeriod);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_PERIOD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPeriod(aPeriod);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_PERIOD_RETURN(this, hrc, 0 /*normal*/,*aPeriod);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_PERIOD_RETURN(this, hrc, 1 /*hrc exception*/,*aPeriod);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_PERIOD_RETURN(this, hrc, 9 /*unhandled exception*/,*aPeriod);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPeriod=%RU32 hrc=%Rhrc\n", this, "PerformanceMetric::getPeriod", *aPeriod, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(Count)(ULONG *aCount)
{
    LogRelFlow(("{%p} %s: enter aCount=%p\n", this, "PerformanceMetric::getCount", aCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_COUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCount(aCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_COUNT_RETURN(this, hrc, 0 /*normal*/,*aCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_COUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_COUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCount=%RU32 hrc=%Rhrc\n", this, "PerformanceMetric::getCount", *aCount, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(Unit)(BSTR *aUnit)
{
    LogRelFlow(("{%p} %s: enter aUnit=%p\n", this, "PerformanceMetric::getUnit", aUnit));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUnit);
        BSTROutConverter TmpUnit(aUnit);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_UNIT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUnit(TmpUnit.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_UNIT_RETURN(this, hrc, 0 /*normal*/,TmpUnit.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_UNIT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_UNIT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUnit=%ls hrc=%Rhrc\n", this, "PerformanceMetric::getUnit", *aUnit, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(MinimumValue)(LONG *aMinimumValue)
{
    LogRelFlow(("{%p} %s: enter aMinimumValue=%p\n", this, "PerformanceMetric::getMinimumValue", aMinimumValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinimumValue);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MINIMUMVALUE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinimumValue(aMinimumValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MINIMUMVALUE_RETURN(this, hrc, 0 /*normal*/,*aMinimumValue);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MINIMUMVALUE_RETURN(this, hrc, 1 /*hrc exception*/,*aMinimumValue);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MINIMUMVALUE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinimumValue);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinimumValue=%RI32 hrc=%Rhrc\n", this, "PerformanceMetric::getMinimumValue", *aMinimumValue, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(MaximumValue)(LONG *aMaximumValue)
{
    LogRelFlow(("{%p} %s: enter aMaximumValue=%p\n", this, "PerformanceMetric::getMaximumValue", aMaximumValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaximumValue);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MAXIMUMVALUE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaximumValue(aMaximumValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MAXIMUMVALUE_RETURN(this, hrc, 0 /*normal*/,*aMaximumValue);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MAXIMUMVALUE_RETURN(this, hrc, 1 /*hrc exception*/,*aMaximumValue);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCEMETRIC_GET_MAXIMUMVALUE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaximumValue);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaximumValue=%RI32 hrc=%Rhrc\n", this, "PerformanceMetric::getMaximumValue", *aMaximumValue, hrc));
    return hrc;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute1IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute2IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute3IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute4IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute5IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute6IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute7IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceMetricWrap::COMGETTER(InternalAndReservedAttribute8IPerformanceMetric)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPerformanceMetric methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PerformanceMetricWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PerformanceMetricWrap, IPerformanceMetric)
#endif // VBOX_WITH_XPCOM
