/*

    MIDI Virtual Piano Keyboard
    Copyright (C) 2008-2024, Pedro Lopez-Cabanillas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; If not, see http://www.gnu.org/licenses/
 
*/

/********************************************************************************
** Form generated from reading UI file 'vpiano.ui'
**
** Created by: Qt User Interface Compiler version 6.8.1
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_VPIANO_H
#define UI_VPIANO_H

#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QIcon>
#include <QtWidgets/QApplication>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QMainWindow>
#include <QtWidgets/QMenu>
#include <QtWidgets/QMenuBar>
#include <QtWidgets/QStatusBar>
#include <QtWidgets/QToolBar>
#include <QtWidgets/QWidget>
#include <drumstick/pianokeybd.h>

QT_BEGIN_NAMESPACE

class Ui_VPiano
{
public:
    QAction *actionExit;
    QAction *actionPreferences;
    QAction *actionConnections;
    QAction *actionAbout;
    QAction *actionAboutQt;
    QAction *actionNotes;
    QAction *actionControllers;
    QAction *actionBender;
    QAction *actionPrograms;
    QAction *actionStatusBar;
    QAction *actionPanic;
    QAction *actionResetAll;
    QAction *actionReset;
    QAction *actionEditKM;
    QAction *actionContents;
    QAction *actionWebSite;
    QAction *actionImportSoundFont;
    QAction *actionExtraControls;
    QAction *actionEditExtra;
    QAction *actionEditPrograms;
    QAction *actionEditExtraControls;
    QAction *actionShortcuts;
    QAction *actionOctaveUp;
    QAction *actionOctaveDown;
    QAction *actionTransposeUp;
    QAction *actionTransposeDown;
    QAction *actionChannelUp;
    QAction *actionChannelDown;
    QAction *actionNextController;
    QAction *actionPreviousController;
    QAction *actionControllerUp;
    QAction *actionControllerDown;
    QAction *actionNextBank;
    QAction *actionPreviousBank;
    QAction *actionNextProgram;
    QAction *actionPreviousProgram;
    QAction *actionVelocityUp;
    QAction *actionVelocityDown;
    QAction *actionAboutTranslation;
    QAction *actionKeyboardInput;
    QAction *actionMouseInput;
    QAction *actionTouchScreenInput;
    QAction *actionColorPalette;
    QAction *actionColorScale;
    QAction *actionWindowFrame;
    QAction *actionNever;
    QAction *actionWhen_Activated;
    QAction *actionAlways;
    QAction *actionSharps;
    QAction *actionFlats;
    QAction *actionNothing;
    QAction *actionHorizontal;
    QAction *actionVertical;
    QAction *actionAutomatic;
    QAction *actionMinimal;
    QAction *actionLoad_Configuration;
    QAction *actionSave_Configuration;
    QAction *actionOctave_Subscript_Designation;
    QWidget *centralwidget;
    QGridLayout *gridLayout;
    drumstick::widgets::PianoKeybd *pianokeybd;
    QMenuBar *menubar;
    QMenu *menuFile;
    QMenu *menuEdit;
    QMenu *menuHelp;
    QMenu *menuLanguage;
    QMenu *menuView;
    QMenu *menuNames;
    QMenu *menuBlack_Keys_Names;
    QMenu *menuNames_Orientation;
    QMenu *menuTools;
    QMenu *menuNotes;
    QMenu *menuControllers;
    QMenu *menuPrograms;
    QMenu *menuNote_Input;
    QStatusBar *statusBar;
    QToolBar *toolBarNotes;
    QToolBar *toolBarPrograms;
    QToolBar *toolBarControllers;
    QToolBar *toolBarExtra;
    QToolBar *toolBarBender;

    void setupUi(QMainWindow *VPiano)
    {
        if (VPiano->objectName().isEmpty())
            VPiano->setObjectName("VPiano");
        VPiano->resize(980, 196);
        VPiano->setWindowTitle(QString::fromUtf8("Virtual MIDI Piano Keyboard"));
        QIcon icon;
        icon.addFile(QString::fromUtf8(":/vpiano/vmpk_32x32.png"), QSize(), QIcon::Mode::Normal, QIcon::State::Off);
        VPiano->setWindowIcon(icon);
        actionExit = new QAction(VPiano);
        actionExit->setObjectName("actionExit");
        actionExit->setMenuRole(QAction::QuitRole);
        actionPreferences = new QAction(VPiano);
        actionPreferences->setObjectName("actionPreferences");
        actionPreferences->setMenuRole(QAction::PreferencesRole);
        actionConnections = new QAction(VPiano);
        actionConnections->setObjectName("actionConnections");
        actionConnections->setMenuRole(QAction::NoRole);
        actionAbout = new QAction(VPiano);
        actionAbout->setObjectName("actionAbout");
        actionAbout->setMenuRole(QAction::AboutRole);
        actionAboutQt = new QAction(VPiano);
        actionAboutQt->setObjectName("actionAboutQt");
        actionAboutQt->setMenuRole(QAction::AboutQtRole);
        actionNotes = new QAction(VPiano);
        actionNotes->setObjectName("actionNotes");
        actionNotes->setCheckable(true);
        actionNotes->setMenuRole(QAction::NoRole);
        actionControllers = new QAction(VPiano);
        actionControllers->setObjectName("actionControllers");
        actionControllers->setCheckable(true);
        actionControllers->setMenuRole(QAction::NoRole);
        actionBender = new QAction(VPiano);
        actionBender->setObjectName("actionBender");
        actionBender->setCheckable(true);
        actionBender->setMenuRole(QAction::NoRole);
        actionPrograms = new QAction(VPiano);
        actionPrograms->setObjectName("actionPrograms");
        actionPrograms->setCheckable(true);
        actionPrograms->setMenuRole(QAction::NoRole);
        actionStatusBar = new QAction(VPiano);
        actionStatusBar->setObjectName("actionStatusBar");
        actionStatusBar->setCheckable(true);
        actionStatusBar->setChecked(true);
        actionStatusBar->setMenuRole(QAction::NoRole);
        actionPanic = new QAction(VPiano);
        actionPanic->setObjectName("actionPanic");
#if QT_CONFIG(shortcut)
        actionPanic->setShortcut(QString::fromUtf8("Esc"));
#endif // QT_CONFIG(shortcut)
        actionPanic->setMenuRole(QAction::NoRole);
        actionResetAll = new QAction(VPiano);
        actionResetAll->setObjectName("actionResetAll");
        actionResetAll->setMenuRole(QAction::NoRole);
        actionReset = new QAction(VPiano);
        actionReset->setObjectName("actionReset");
        actionReset->setMenuRole(QAction::NoRole);
        actionEditKM = new QAction(VPiano);
        actionEditKM->setObjectName("actionEditKM");
        actionEditKM->setMenuRole(QAction::NoRole);
        actionContents = new QAction(VPiano);
        actionContents->setObjectName("actionContents");
#if QT_CONFIG(shortcut)
        actionContents->setShortcut(QString::fromUtf8("F1"));
#endif // QT_CONFIG(shortcut)
        actionContents->setMenuRole(QAction::NoRole);
        actionWebSite = new QAction(VPiano);
        actionWebSite->setObjectName("actionWebSite");
        actionWebSite->setMenuRole(QAction::NoRole);
        actionImportSoundFont = new QAction(VPiano);
        actionImportSoundFont->setObjectName("actionImportSoundFont");
        actionImportSoundFont->setMenuRole(QAction::NoRole);
        actionExtraControls = new QAction(VPiano);
        actionExtraControls->setObjectName("actionExtraControls");
        actionExtraControls->setCheckable(true);
        actionExtraControls->setMenuRole(QAction::NoRole);
        actionEditExtra = new QAction(VPiano);
        actionEditExtra->setObjectName("actionEditExtra");
        actionEditExtra->setMenuRole(QAction::NoRole);
        actionEditPrograms = new QAction(VPiano);
        actionEditPrograms->setObjectName("actionEditPrograms");
        actionEditPrograms->setEnabled(false);
        actionEditPrograms->setVisible(false);
        actionEditPrograms->setMenuRole(QAction::NoRole);
        actionEditPrograms->setIconVisibleInMenu(false);
        actionEditExtraControls = new QAction(VPiano);
        actionEditExtraControls->setObjectName("actionEditExtraControls");
        actionEditExtraControls->setMenuRole(QAction::NoRole);
        actionShortcuts = new QAction(VPiano);
        actionShortcuts->setObjectName("actionShortcuts");
        actionShortcuts->setMenuRole(QAction::NoRole);
        actionOctaveUp = new QAction(VPiano);
        actionOctaveUp->setObjectName("actionOctaveUp");
#if QT_CONFIG(shortcut)
        actionOctaveUp->setShortcut(QString::fromUtf8("Right"));
#endif // QT_CONFIG(shortcut)
        actionOctaveUp->setMenuRole(QAction::NoRole);
        actionOctaveDown = new QAction(VPiano);
        actionOctaveDown->setObjectName("actionOctaveDown");
#if QT_CONFIG(shortcut)
        actionOctaveDown->setShortcut(QString::fromUtf8("Left"));
#endif // QT_CONFIG(shortcut)
        actionOctaveDown->setMenuRole(QAction::NoRole);
        actionTransposeUp = new QAction(VPiano);
        actionTransposeUp->setObjectName("actionTransposeUp");
#if QT_CONFIG(shortcut)
        actionTransposeUp->setShortcut(QString::fromUtf8("Ctrl+Right"));
#endif // QT_CONFIG(shortcut)
        actionTransposeUp->setMenuRole(QAction::NoRole);
        actionTransposeDown = new QAction(VPiano);
        actionTransposeDown->setObjectName("actionTransposeDown");
#if QT_CONFIG(shortcut)
        actionTransposeDown->setShortcut(QString::fromUtf8("Ctrl+Left"));
#endif // QT_CONFIG(shortcut)
        actionTransposeDown->setMenuRole(QAction::NoRole);
        actionChannelUp = new QAction(VPiano);
        actionChannelUp->setObjectName("actionChannelUp");
#if QT_CONFIG(shortcut)
        actionChannelUp->setShortcut(QString::fromUtf8("Up"));
#endif // QT_CONFIG(shortcut)
        actionChannelUp->setMenuRole(QAction::NoRole);
        actionChannelDown = new QAction(VPiano);
        actionChannelDown->setObjectName("actionChannelDown");
#if QT_CONFIG(shortcut)
        actionChannelDown->setShortcut(QString::fromUtf8("Down"));
#endif // QT_CONFIG(shortcut)
        actionChannelDown->setMenuRole(QAction::NoRole);
        actionNextController = new QAction(VPiano);
        actionNextController->setObjectName("actionNextController");
#if QT_CONFIG(shortcut)
        actionNextController->setShortcut(QString::fromUtf8("Ctrl++"));
#endif // QT_CONFIG(shortcut)
        actionNextController->setMenuRole(QAction::NoRole);
        actionPreviousController = new QAction(VPiano);
        actionPreviousController->setObjectName("actionPreviousController");
#if QT_CONFIG(shortcut)
        actionPreviousController->setShortcut(QString::fromUtf8("Ctrl+-"));
#endif // QT_CONFIG(shortcut)
        actionPreviousController->setMenuRole(QAction::NoRole);
        actionControllerUp = new QAction(VPiano);
        actionControllerUp->setObjectName("actionControllerUp");
        actionControllerUp->setMenuRole(QAction::NoRole);
        actionControllerDown = new QAction(VPiano);
        actionControllerDown->setObjectName("actionControllerDown");
        actionControllerDown->setMenuRole(QAction::NoRole);
        actionNextBank = new QAction(VPiano);
        actionNextBank->setObjectName("actionNextBank");
#if QT_CONFIG(shortcut)
        actionNextBank->setShortcut(QString::fromUtf8("Ctrl+PgUp"));
#endif // QT_CONFIG(shortcut)
        actionNextBank->setMenuRole(QAction::NoRole);
        actionPreviousBank = new QAction(VPiano);
        actionPreviousBank->setObjectName("actionPreviousBank");
#if QT_CONFIG(shortcut)
        actionPreviousBank->setShortcut(QString::fromUtf8("Ctrl+PgDown"));
#endif // QT_CONFIG(shortcut)
        actionPreviousBank->setMenuRole(QAction::NoRole);
        actionNextProgram = new QAction(VPiano);
        actionNextProgram->setObjectName("actionNextProgram");
#if QT_CONFIG(shortcut)
        actionNextProgram->setShortcut(QString::fromUtf8("PgUp"));
#endif // QT_CONFIG(shortcut)
        actionNextProgram->setMenuRole(QAction::NoRole);
        actionPreviousProgram = new QAction(VPiano);
        actionPreviousProgram->setObjectName("actionPreviousProgram");
#if QT_CONFIG(shortcut)
        actionPreviousProgram->setShortcut(QString::fromUtf8("PgDown"));
#endif // QT_CONFIG(shortcut)
        actionPreviousProgram->setMenuRole(QAction::NoRole);
        actionVelocityUp = new QAction(VPiano);
        actionVelocityUp->setObjectName("actionVelocityUp");
#if QT_CONFIG(shortcut)
        actionVelocityUp->setShortcut(QString::fromUtf8("End"));
#endif // QT_CONFIG(shortcut)
        actionVelocityUp->setMenuRole(QAction::NoRole);
        actionVelocityDown = new QAction(VPiano);
        actionVelocityDown->setObjectName("actionVelocityDown");
#if QT_CONFIG(shortcut)
        actionVelocityDown->setShortcut(QString::fromUtf8("Home"));
#endif // QT_CONFIG(shortcut)
        actionVelocityDown->setMenuRole(QAction::NoRole);
        actionAboutTranslation = new QAction(VPiano);
        actionAboutTranslation->setObjectName("actionAboutTranslation");
        actionAboutTranslation->setMenuRole(QAction::NoRole);
        actionKeyboardInput = new QAction(VPiano);
        actionKeyboardInput->setObjectName("actionKeyboardInput");
        actionKeyboardInput->setCheckable(true);
        actionKeyboardInput->setChecked(true);
        actionKeyboardInput->setMenuRole(QAction::NoRole);
        actionMouseInput = new QAction(VPiano);
        actionMouseInput->setObjectName("actionMouseInput");
        actionMouseInput->setCheckable(true);
        actionMouseInput->setChecked(true);
        actionMouseInput->setMenuRole(QAction::NoRole);
        actionTouchScreenInput = new QAction(VPiano);
        actionTouchScreenInput->setObjectName("actionTouchScreenInput");
        actionTouchScreenInput->setCheckable(true);
        actionTouchScreenInput->setChecked(true);
        actionTouchScreenInput->setMenuRole(QAction::NoRole);
        actionColorPalette = new QAction(VPiano);
        actionColorPalette->setObjectName("actionColorPalette");
        actionColorPalette->setMenuRole(QAction::NoRole);
        actionColorScale = new QAction(VPiano);
        actionColorScale->setObjectName("actionColorScale");
        actionColorScale->setCheckable(true);
        actionColorScale->setMenuRole(QAction::NoRole);
        actionWindowFrame = new QAction(VPiano);
        actionWindowFrame->setObjectName("actionWindowFrame");
        actionWindowFrame->setCheckable(true);
        actionWindowFrame->setChecked(true);
        actionWindowFrame->setMenuRole(QAction::NoRole);
        actionNever = new QAction(VPiano);
        actionNever->setObjectName("actionNever");
        actionNever->setCheckable(true);
        actionNever->setChecked(true);
        actionWhen_Activated = new QAction(VPiano);
        actionWhen_Activated->setObjectName("actionWhen_Activated");
        actionWhen_Activated->setCheckable(true);
        actionAlways = new QAction(VPiano);
        actionAlways->setObjectName("actionAlways");
        actionAlways->setCheckable(true);
        actionSharps = new QAction(VPiano);
        actionSharps->setObjectName("actionSharps");
        actionSharps->setCheckable(true);
        actionSharps->setChecked(true);
        actionFlats = new QAction(VPiano);
        actionFlats->setObjectName("actionFlats");
        actionFlats->setCheckable(true);
        actionFlats->setChecked(false);
        actionNothing = new QAction(VPiano);
        actionNothing->setObjectName("actionNothing");
        actionNothing->setCheckable(true);
        actionHorizontal = new QAction(VPiano);
        actionHorizontal->setObjectName("actionHorizontal");
        actionHorizontal->setCheckable(true);
        actionHorizontal->setChecked(true);
        actionVertical = new QAction(VPiano);
        actionVertical->setObjectName("actionVertical");
        actionVertical->setCheckable(true);
        actionAutomatic = new QAction(VPiano);
        actionAutomatic->setObjectName("actionAutomatic");
        actionAutomatic->setCheckable(true);
        actionMinimal = new QAction(VPiano);
        actionMinimal->setObjectName("actionMinimal");
        actionMinimal->setCheckable(true);
        actionLoad_Configuration = new QAction(VPiano);
        actionLoad_Configuration->setObjectName("actionLoad_Configuration");
        actionSave_Configuration = new QAction(VPiano);
        actionSave_Configuration->setObjectName("actionSave_Configuration");
        actionOctave_Subscript_Designation = new QAction(VPiano);
        actionOctave_Subscript_Designation->setObjectName("actionOctave_Subscript_Designation");
        actionOctave_Subscript_Designation->setCheckable(true);
        actionOctave_Subscript_Designation->setChecked(true);
        centralwidget = new QWidget(VPiano);
        centralwidget->setObjectName("centralwidget");
        gridLayout = new QGridLayout(centralwidget);
        gridLayout->setObjectName("gridLayout");
        gridLayout->setContentsMargins(0, 0, 0, 0);
        pianokeybd = new drumstick::widgets::PianoKeybd(centralwidget);
        pianokeybd->setObjectName("pianokeybd");

        gridLayout->addWidget(pianokeybd, 0, 0, 1, 1);

        VPiano->setCentralWidget(centralwidget);
        menubar = new QMenuBar(VPiano);
        menubar->setObjectName("menubar");
        menubar->setGeometry(QRect(0, 0, 980, 23));
        menuFile = new QMenu(menubar);
        menuFile->setObjectName("menuFile");
        menuEdit = new QMenu(menubar);
        menuEdit->setObjectName("menuEdit");
        menuHelp = new QMenu(menubar);
        menuHelp->setObjectName("menuHelp");
        menuLanguage = new QMenu(menuHelp);
        menuLanguage->setObjectName("menuLanguage");
        menuView = new QMenu(menubar);
        menuView->setObjectName("menuView");
        menuNames = new QMenu(menuView);
        menuNames->setObjectName("menuNames");
        menuBlack_Keys_Names = new QMenu(menuView);
        menuBlack_Keys_Names->setObjectName("menuBlack_Keys_Names");
        menuNames_Orientation = new QMenu(menuView);
        menuNames_Orientation->setObjectName("menuNames_Orientation");
        menuTools = new QMenu(menubar);
        menuTools->setObjectName("menuTools");
        menuNotes = new QMenu(menuTools);
        menuNotes->setObjectName("menuNotes");
        menuControllers = new QMenu(menuTools);
        menuControllers->setObjectName("menuControllers");
        menuPrograms = new QMenu(menuTools);
        menuPrograms->setObjectName("menuPrograms");
        menuNote_Input = new QMenu(menuTools);
        menuNote_Input->setObjectName("menuNote_Input");
        VPiano->setMenuBar(menubar);
        statusBar = new QStatusBar(VPiano);
        statusBar->setObjectName("statusBar");
        statusBar->setSizeGripEnabled(true);
        VPiano->setStatusBar(statusBar);
        toolBarNotes = new QToolBar(VPiano);
        toolBarNotes->setObjectName("toolBarNotes");
        QSizePolicy sizePolicy(QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Fixed);
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(toolBarNotes->sizePolicy().hasHeightForWidth());
        toolBarNotes->setSizePolicy(sizePolicy);
        toolBarNotes->setFocusPolicy(Qt::NoFocus);
        toolBarNotes->setToolButtonStyle(Qt::ToolButtonTextOnly);
        VPiano->addToolBar(Qt::ToolBarArea::TopToolBarArea, toolBarNotes);
        toolBarPrograms = new QToolBar(VPiano);
        toolBarPrograms->setObjectName("toolBarPrograms");
        sizePolicy.setHeightForWidth(toolBarPrograms->sizePolicy().hasHeightForWidth());
        toolBarPrograms->setSizePolicy(sizePolicy);
        toolBarPrograms->setFocusPolicy(Qt::NoFocus);
        toolBarPrograms->setToolButtonStyle(Qt::ToolButtonTextOnly);
        VPiano->addToolBar(Qt::ToolBarArea::TopToolBarArea, toolBarPrograms);
        toolBarControllers = new QToolBar(VPiano);
        toolBarControllers->setObjectName("toolBarControllers");
        sizePolicy.setHeightForWidth(toolBarControllers->sizePolicy().hasHeightForWidth());
        toolBarControllers->setSizePolicy(sizePolicy);
        toolBarControllers->setFocusPolicy(Qt::NoFocus);
        toolBarControllers->setToolButtonStyle(Qt::ToolButtonTextOnly);
        VPiano->addToolBar(Qt::ToolBarArea::TopToolBarArea, toolBarControllers);
        VPiano->insertToolBarBreak(toolBarControllers);
        toolBarExtra = new QToolBar(VPiano);
        toolBarExtra->setObjectName("toolBarExtra");
        sizePolicy.setHeightForWidth(toolBarExtra->sizePolicy().hasHeightForWidth());
        toolBarExtra->setSizePolicy(sizePolicy);
        toolBarExtra->setFocusPolicy(Qt::NoFocus);
        toolBarExtra->setToolButtonStyle(Qt::ToolButtonTextOnly);
        VPiano->addToolBar(Qt::ToolBarArea::TopToolBarArea, toolBarExtra);
        toolBarBender = new QToolBar(VPiano);
        toolBarBender->setObjectName("toolBarBender");
        sizePolicy.setHeightForWidth(toolBarBender->sizePolicy().hasHeightForWidth());
        toolBarBender->setSizePolicy(sizePolicy);
        toolBarBender->setFocusPolicy(Qt::NoFocus);
        toolBarBender->setToolButtonStyle(Qt::ToolButtonTextOnly);
        VPiano->addToolBar(Qt::ToolBarArea::TopToolBarArea, toolBarBender);

        menubar->addAction(menuFile->menuAction());
        menubar->addAction(menuEdit->menuAction());
        menubar->addAction(menuTools->menuAction());
        menubar->addAction(menuView->menuAction());
        menubar->addAction(menuHelp->menuAction());
        menuFile->addAction(actionLoad_Configuration);
        menuFile->addAction(actionSave_Configuration);
        menuFile->addSeparator();
        menuFile->addAction(actionImportSoundFont);
        menuFile->addSeparator();
        menuFile->addAction(actionExit);
        menuEdit->addAction(actionConnections);
        menuEdit->addAction(actionPreferences);
        menuEdit->addAction(actionEditKM);
        menuEdit->addAction(actionEditExtraControls);
        menuEdit->addAction(actionShortcuts);
        menuEdit->addAction(actionColorPalette);
        menuHelp->addAction(actionContents);
        menuHelp->addAction(actionWebSite);
        menuHelp->addAction(menuLanguage->menuAction());
        menuHelp->addSeparator();
        menuHelp->addAction(actionAbout);
        menuHelp->addAction(actionAboutTranslation);
        menuHelp->addAction(actionAboutQt);
        menuView->addAction(actionNotes);
        menuView->addAction(actionControllers);
        menuView->addAction(actionBender);
        menuView->addAction(actionPrograms);
        menuView->addAction(actionExtraControls);
        menuView->addSeparator();
        menuView->addAction(menuNames->menuAction());
        menuView->addAction(menuBlack_Keys_Names->menuAction());
        menuView->addAction(menuNames_Orientation->menuAction());
        menuView->addAction(actionOctave_Subscript_Designation);
        menuView->addAction(actionColorScale);
        menuView->addAction(actionStatusBar);
        menuView->addAction(actionWindowFrame);
        menuNames->addAction(actionNever);
        menuNames->addAction(actionMinimal);
        menuNames->addAction(actionWhen_Activated);
        menuNames->addAction(actionAlways);
        menuBlack_Keys_Names->addAction(actionSharps);
        menuBlack_Keys_Names->addAction(actionFlats);
        menuBlack_Keys_Names->addAction(actionNothing);
        menuNames_Orientation->addAction(actionHorizontal);
        menuNames_Orientation->addAction(actionVertical);
        menuNames_Orientation->addAction(actionAutomatic);
        menuTools->addAction(actionChannelUp);
        menuTools->addAction(actionChannelDown);
        menuTools->addAction(menuNotes->menuAction());
        menuTools->addAction(menuControllers->menuAction());
        menuTools->addAction(menuPrograms->menuAction());
        menuTools->addAction(menuNote_Input->menuAction());
        menuNotes->addAction(actionOctaveUp);
        menuNotes->addAction(actionOctaveDown);
        menuNotes->addAction(actionTransposeUp);
        menuNotes->addAction(actionTransposeDown);
        menuNotes->addAction(actionVelocityUp);
        menuNotes->addAction(actionVelocityDown);
        menuControllers->addAction(actionNextController);
        menuControllers->addAction(actionPreviousController);
        menuControllers->addAction(actionControllerUp);
        menuControllers->addAction(actionControllerDown);
        menuPrograms->addAction(actionNextBank);
        menuPrograms->addAction(actionPreviousBank);
        menuPrograms->addAction(actionNextProgram);
        menuPrograms->addAction(actionPreviousProgram);
        menuNote_Input->addAction(actionKeyboardInput);
        menuNote_Input->addAction(actionMouseInput);
        menuNote_Input->addAction(actionTouchScreenInput);
        toolBarNotes->addAction(actionPanic);
        toolBarNotes->addSeparator();
        toolBarPrograms->addAction(actionEditPrograms);
        toolBarControllers->addAction(actionResetAll);
        toolBarControllers->addSeparator();
        toolBarExtra->addAction(actionEditExtra);
        toolBarExtra->addSeparator();
        toolBarBender->addAction(actionReset);
        toolBarBender->addSeparator();

        retranslateUi(VPiano);
        QObject::connect(actionExit, &QAction::triggered, VPiano, qOverload<>(&QMainWindow::close));
        QObject::connect(actionNotes, &QAction::toggled, toolBarNotes, &QToolBar::setVisible);
        QObject::connect(actionControllers, &QAction::toggled, toolBarControllers, &QToolBar::setVisible);
        QObject::connect(actionBender, &QAction::toggled, toolBarBender, &QToolBar::setVisible);
        QObject::connect(actionPrograms, &QAction::toggled, toolBarPrograms, &QToolBar::setVisible);
        QObject::connect(actionStatusBar, &QAction::toggled, statusBar, &QStatusBar::setVisible);
        QObject::connect(actionExtraControls, &QAction::toggled, toolBarExtra, &QToolBar::setVisible);

        QMetaObject::connectSlotsByName(VPiano);
    } // setupUi

    void retranslateUi(QMainWindow *VPiano)
    {
        actionExit->setText(QCoreApplication::translate("VPiano", "&Quit", nullptr));
#if QT_CONFIG(statustip)
        actionExit->setStatusTip(QCoreApplication::translate("VPiano", "Exit the program", nullptr));
#endif // QT_CONFIG(statustip)
        actionPreferences->setText(QCoreApplication::translate("VPiano", "&Preferences", nullptr));
#if QT_CONFIG(statustip)
        actionPreferences->setStatusTip(QCoreApplication::translate("VPiano", "Edit the program settings", nullptr));
#endif // QT_CONFIG(statustip)
        actionConnections->setText(QCoreApplication::translate("VPiano", "MIDI &Connections", nullptr));
#if QT_CONFIG(statustip)
        actionConnections->setStatusTip(QCoreApplication::translate("VPiano", "Edit the MIDI connections", nullptr));
#endif // QT_CONFIG(statustip)
        actionAbout->setText(QCoreApplication::translate("VPiano", "&About", nullptr));
#if QT_CONFIG(statustip)
        actionAbout->setStatusTip(QCoreApplication::translate("VPiano", "Show the About box", nullptr));
#endif // QT_CONFIG(statustip)
        actionAboutQt->setText(QCoreApplication::translate("VPiano", "About &Qt", nullptr));
#if QT_CONFIG(statustip)
        actionAboutQt->setStatusTip(QCoreApplication::translate("VPiano", "Show the Qt about box", nullptr));
#endif // QT_CONFIG(statustip)
        actionNotes->setText(QCoreApplication::translate("VPiano", "&Notes", nullptr));
#if QT_CONFIG(statustip)
        actionNotes->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Notes toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        actionControllers->setText(QCoreApplication::translate("VPiano", "&Controllers", nullptr));
#if QT_CONFIG(statustip)
        actionControllers->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Controller toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        actionBender->setText(QCoreApplication::translate("VPiano", "Pitch &Bender", nullptr));
#if QT_CONFIG(statustip)
        actionBender->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Pitch Bender toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        actionPrograms->setText(QCoreApplication::translate("VPiano", "&Programs", nullptr));
#if QT_CONFIG(statustip)
        actionPrograms->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Programs toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        actionStatusBar->setText(QCoreApplication::translate("VPiano", "&Status Bar", nullptr));
#if QT_CONFIG(statustip)
        actionStatusBar->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Status Bar", nullptr));
#endif // QT_CONFIG(statustip)
        actionPanic->setText(QCoreApplication::translate("VPiano", "Panic", nullptr));
#if QT_CONFIG(statustip)
        actionPanic->setStatusTip(QCoreApplication::translate("VPiano", "Stops all active notes", nullptr));
#endif // QT_CONFIG(statustip)
        actionResetAll->setText(QCoreApplication::translate("VPiano", "Reset All", nullptr));
#if QT_CONFIG(statustip)
        actionResetAll->setStatusTip(QCoreApplication::translate("VPiano", "Resets all the controllers", nullptr));
#endif // QT_CONFIG(statustip)
        actionReset->setText(QCoreApplication::translate("VPiano", "Reset", nullptr));
#if QT_CONFIG(statustip)
        actionReset->setStatusTip(QCoreApplication::translate("VPiano", "Resets the Bender value", nullptr));
#endif // QT_CONFIG(statustip)
        actionEditKM->setText(QCoreApplication::translate("VPiano", "&Keyboard Map", nullptr));
#if QT_CONFIG(statustip)
        actionEditKM->setStatusTip(QCoreApplication::translate("VPiano", "Edit the current keyboard layout", nullptr));
#endif // QT_CONFIG(statustip)
        actionContents->setText(QCoreApplication::translate("VPiano", "&Contents", nullptr));
#if QT_CONFIG(statustip)
        actionContents->setStatusTip(QCoreApplication::translate("VPiano", "Open the index of the help document", nullptr));
#endif // QT_CONFIG(statustip)
        actionWebSite->setText(QCoreApplication::translate("VPiano", "VMPK &Web site", nullptr));
#if QT_CONFIG(statustip)
        actionWebSite->setStatusTip(QCoreApplication::translate("VPiano", "Open the VMPK web site address using a web browser", nullptr));
#endif // QT_CONFIG(statustip)
        actionImportSoundFont->setText(QCoreApplication::translate("VPiano", "&Import SoundFont...", nullptr));
#if QT_CONFIG(statustip)
        actionImportSoundFont->setStatusTip(QCoreApplication::translate("VPiano", "Import SoundFont", nullptr));
#endif // QT_CONFIG(statustip)
        actionExtraControls->setText(QCoreApplication::translate("VPiano", "&Extra Controls", nullptr));
#if QT_CONFIG(statustip)
        actionExtraControls->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the Extra Controls toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        actionEditExtra->setText(QCoreApplication::translate("VPiano", "Edit", nullptr));
#if QT_CONFIG(statustip)
        actionEditExtra->setStatusTip(QCoreApplication::translate("VPiano", "Open the Extra Controls editor", nullptr));
#endif // QT_CONFIG(statustip)
        actionEditPrograms->setText(QCoreApplication::translate("VPiano", "Edit", nullptr));
#if QT_CONFIG(statustip)
        actionEditPrograms->setStatusTip(QCoreApplication::translate("VPiano", "Open the Banks/Programs editor", nullptr));
#endif // QT_CONFIG(statustip)
        actionEditExtraControls->setText(QCoreApplication::translate("VPiano", "&Extra Controllers", nullptr));
#if QT_CONFIG(statustip)
        actionEditExtraControls->setStatusTip(QCoreApplication::translate("VPiano", "Open the Extra Controls editor", nullptr));
#endif // QT_CONFIG(statustip)
        actionShortcuts->setText(QCoreApplication::translate("VPiano", "&Shortcuts", nullptr));
#if QT_CONFIG(statustip)
        actionShortcuts->setStatusTip(QCoreApplication::translate("VPiano", "Open the Shortcuts editor", nullptr));
#endif // QT_CONFIG(statustip)
        actionOctaveUp->setText(QCoreApplication::translate("VPiano", "Octave Up", nullptr));
#if QT_CONFIG(statustip)
        actionOctaveUp->setStatusTip(QCoreApplication::translate("VPiano", "Play one octave higher", nullptr));
#endif // QT_CONFIG(statustip)
        actionOctaveDown->setText(QCoreApplication::translate("VPiano", "Octave Down", nullptr));
#if QT_CONFIG(statustip)
        actionOctaveDown->setStatusTip(QCoreApplication::translate("VPiano", "Play one octave lower", nullptr));
#endif // QT_CONFIG(statustip)
        actionTransposeUp->setText(QCoreApplication::translate("VPiano", "Transpose Up", nullptr));
#if QT_CONFIG(statustip)
        actionTransposeUp->setStatusTip(QCoreApplication::translate("VPiano", "Transpose one semitone higher", nullptr));
#endif // QT_CONFIG(statustip)
        actionTransposeDown->setText(QCoreApplication::translate("VPiano", "Transpose Down", nullptr));
#if QT_CONFIG(statustip)
        actionTransposeDown->setStatusTip(QCoreApplication::translate("VPiano", "Transpose one semitone lower", nullptr));
#endif // QT_CONFIG(statustip)
        actionChannelUp->setText(QCoreApplication::translate("VPiano", "Next  Channel", nullptr));
#if QT_CONFIG(statustip)
        actionChannelUp->setStatusTip(QCoreApplication::translate("VPiano", "Play and listen next channel", nullptr));
#endif // QT_CONFIG(statustip)
        actionChannelDown->setText(QCoreApplication::translate("VPiano", "Previous Channel", nullptr));
#if QT_CONFIG(statustip)
        actionChannelDown->setStatusTip(QCoreApplication::translate("VPiano", "Play and listen previous channel", nullptr));
#endif // QT_CONFIG(statustip)
        actionNextController->setText(QCoreApplication::translate("VPiano", "Next Controller", nullptr));
#if QT_CONFIG(statustip)
        actionNextController->setStatusTip(QCoreApplication::translate("VPiano", "Select the next controller", nullptr));
#endif // QT_CONFIG(statustip)
        actionPreviousController->setText(QCoreApplication::translate("VPiano", "Previous Controller", nullptr));
#if QT_CONFIG(statustip)
        actionPreviousController->setStatusTip(QCoreApplication::translate("VPiano", "Select the previous controller", nullptr));
#endif // QT_CONFIG(statustip)
        actionControllerUp->setText(QCoreApplication::translate("VPiano", "Controller Up", nullptr));
#if QT_CONFIG(statustip)
        actionControllerUp->setStatusTip(QCoreApplication::translate("VPiano", "Increment the controller value", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        actionControllerUp->setShortcut(QCoreApplication::translate("VPiano", "Alt++", nullptr));
#endif // QT_CONFIG(shortcut)
        actionControllerDown->setText(QCoreApplication::translate("VPiano", "Controller Down", nullptr));
#if QT_CONFIG(statustip)
        actionControllerDown->setStatusTip(QCoreApplication::translate("VPiano", "Decrement the controller value", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        actionControllerDown->setShortcut(QCoreApplication::translate("VPiano", "Alt+-", nullptr));
#endif // QT_CONFIG(shortcut)
        actionNextBank->setText(QCoreApplication::translate("VPiano", "Next Bank", nullptr));
#if QT_CONFIG(statustip)
        actionNextBank->setStatusTip(QCoreApplication::translate("VPiano", "Select the next instrument bank", nullptr));
#endif // QT_CONFIG(statustip)
        actionPreviousBank->setText(QCoreApplication::translate("VPiano", "Previous Bank", nullptr));
#if QT_CONFIG(statustip)
        actionPreviousBank->setStatusTip(QCoreApplication::translate("VPiano", "Select the previous instrument bank", nullptr));
#endif // QT_CONFIG(statustip)
        actionNextProgram->setText(QCoreApplication::translate("VPiano", "Next Program", nullptr));
#if QT_CONFIG(statustip)
        actionNextProgram->setStatusTip(QCoreApplication::translate("VPiano", "Select the next instrument program", nullptr));
#endif // QT_CONFIG(statustip)
        actionPreviousProgram->setText(QCoreApplication::translate("VPiano", "Previous Program", nullptr));
#if QT_CONFIG(statustip)
        actionPreviousProgram->setStatusTip(QCoreApplication::translate("VPiano", "Select the previous instrument program", nullptr));
#endif // QT_CONFIG(statustip)
        actionVelocityUp->setText(QCoreApplication::translate("VPiano", "Velocity Up", nullptr));
#if QT_CONFIG(statustip)
        actionVelocityUp->setStatusTip(QCoreApplication::translate("VPiano", "Increment note velocity", nullptr));
#endif // QT_CONFIG(statustip)
        actionVelocityDown->setText(QCoreApplication::translate("VPiano", "Velocity Down", nullptr));
#if QT_CONFIG(statustip)
        actionVelocityDown->setStatusTip(QCoreApplication::translate("VPiano", "Decrement note velocity", nullptr));
#endif // QT_CONFIG(statustip)
        actionAboutTranslation->setText(QCoreApplication::translate("VPiano", "About &Translation", nullptr));
#if QT_CONFIG(statustip)
        actionAboutTranslation->setStatusTip(QCoreApplication::translate("VPiano", "Show information about the program language translation", nullptr));
#endif // QT_CONFIG(statustip)
        actionKeyboardInput->setText(QCoreApplication::translate("VPiano", "Computer Keyboard", nullptr));
#if QT_CONFIG(statustip)
        actionKeyboardInput->setStatusTip(QCoreApplication::translate("VPiano", "Enable computer keyboard triggered note input", nullptr));
#endif // QT_CONFIG(statustip)
        actionMouseInput->setText(QCoreApplication::translate("VPiano", "Mouse", nullptr));
#if QT_CONFIG(statustip)
        actionMouseInput->setStatusTip(QCoreApplication::translate("VPiano", "Enable mouse triggered note input", nullptr));
#endif // QT_CONFIG(statustip)
        actionTouchScreenInput->setText(QCoreApplication::translate("VPiano", "Touch Screen", nullptr));
#if QT_CONFIG(statustip)
        actionTouchScreenInput->setStatusTip(QCoreApplication::translate("VPiano", "Enable screen touch triggered note input", nullptr));
#endif // QT_CONFIG(statustip)
        actionColorPalette->setText(QCoreApplication::translate("VPiano", "Color Palette", nullptr));
#if QT_CONFIG(statustip)
        actionColorPalette->setStatusTip(QCoreApplication::translate("VPiano", "Open the color palette editor", nullptr));
#endif // QT_CONFIG(statustip)
        actionColorScale->setText(QCoreApplication::translate("VPiano", "Color Scale", nullptr));
#if QT_CONFIG(statustip)
        actionColorScale->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide the colorized keys", nullptr));
#endif // QT_CONFIG(statustip)
        actionWindowFrame->setText(QCoreApplication::translate("VPiano", "Window frame", nullptr));
#if QT_CONFIG(statustip)
        actionWindowFrame->setStatusTip(QCoreApplication::translate("VPiano", "Show or hide window decorations", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(whatsthis)
        actionWindowFrame->setWhatsThis(QString());
#endif // QT_CONFIG(whatsthis)
        actionNever->setText(QCoreApplication::translate("VPiano", "Never", nullptr));
#if QT_CONFIG(statustip)
        actionNever->setStatusTip(QCoreApplication::translate("VPiano", "Don't show key labels", nullptr));
#endif // QT_CONFIG(statustip)
        actionWhen_Activated->setText(QCoreApplication::translate("VPiano", "When Activated", nullptr));
#if QT_CONFIG(statustip)
        actionWhen_Activated->setStatusTip(QCoreApplication::translate("VPiano", "Show key labels when notes are activated", nullptr));
#endif // QT_CONFIG(statustip)
        actionAlways->setText(QCoreApplication::translate("VPiano", "Always", nullptr));
#if QT_CONFIG(statustip)
        actionAlways->setStatusTip(QCoreApplication::translate("VPiano", "Show key labels always", nullptr));
#endif // QT_CONFIG(statustip)
        actionSharps->setText(QCoreApplication::translate("VPiano", "Sharps", nullptr));
#if QT_CONFIG(statustip)
        actionSharps->setStatusTip(QCoreApplication::translate("VPiano", "Display sharps", nullptr));
#endif // QT_CONFIG(statustip)
        actionFlats->setText(QCoreApplication::translate("VPiano", "Flats", nullptr));
#if QT_CONFIG(statustip)
        actionFlats->setStatusTip(QCoreApplication::translate("VPiano", "Display flats", nullptr));
#endif // QT_CONFIG(statustip)
        actionNothing->setText(QCoreApplication::translate("VPiano", "Nothing", nullptr));
#if QT_CONFIG(statustip)
        actionNothing->setStatusTip(QCoreApplication::translate("VPiano", "Don't display labels over black keys", nullptr));
#endif // QT_CONFIG(statustip)
        actionHorizontal->setText(QCoreApplication::translate("VPiano", "Horizontal", nullptr));
#if QT_CONFIG(statustip)
        actionHorizontal->setStatusTip(QCoreApplication::translate("VPiano", "Display key labels horizontally", nullptr));
#endif // QT_CONFIG(statustip)
        actionVertical->setText(QCoreApplication::translate("VPiano", "Vertical", nullptr));
#if QT_CONFIG(statustip)
        actionVertical->setStatusTip(QCoreApplication::translate("VPiano", "Display key labels vertically", nullptr));
#endif // QT_CONFIG(statustip)
        actionAutomatic->setText(QCoreApplication::translate("VPiano", "Automatic", nullptr));
#if QT_CONFIG(statustip)
        actionAutomatic->setStatusTip(QCoreApplication::translate("VPiano", "Display key labels with automatic orientation", nullptr));
#endif // QT_CONFIG(statustip)
        actionMinimal->setText(QCoreApplication::translate("VPiano", "Minimal", nullptr));
#if QT_CONFIG(statustip)
        actionMinimal->setStatusTip(QCoreApplication::translate("VPiano", "Show key labels only over C notes", nullptr));
#endif // QT_CONFIG(statustip)
        actionLoad_Configuration->setText(QCoreApplication::translate("VPiano", "Load Configuration...", nullptr));
        actionSave_Configuration->setText(QCoreApplication::translate("VPiano", "Save Configuration...", nullptr));
        actionOctave_Subscript_Designation->setText(QCoreApplication::translate("VPiano", "Octave Subscript Designation", nullptr));
        menuFile->setTitle(QCoreApplication::translate("VPiano", "&File", nullptr));
        menuEdit->setTitle(QCoreApplication::translate("VPiano", "&Edit", nullptr));
        menuHelp->setTitle(QCoreApplication::translate("VPiano", "&Help", nullptr));
        menuLanguage->setTitle(QCoreApplication::translate("VPiano", "&Language", nullptr));
        menuView->setTitle(QCoreApplication::translate("VPiano", "&View", nullptr));
        menuNames->setTitle(QCoreApplication::translate("VPiano", "Show Note Names", nullptr));
        menuBlack_Keys_Names->setTitle(QCoreApplication::translate("VPiano", "Black Keys Names", nullptr));
        menuNames_Orientation->setTitle(QCoreApplication::translate("VPiano", "Names Orientation", nullptr));
        menuTools->setTitle(QCoreApplication::translate("VPiano", "&Tools", nullptr));
        menuNotes->setTitle(QCoreApplication::translate("VPiano", "Notes", nullptr));
        menuControllers->setTitle(QCoreApplication::translate("VPiano", "Controllers", nullptr));
        menuPrograms->setTitle(QCoreApplication::translate("VPiano", "Programs", nullptr));
        menuNote_Input->setTitle(QCoreApplication::translate("VPiano", "Note Input", nullptr));
        toolBarNotes->setWindowTitle(QCoreApplication::translate("VPiano", "&Notes", nullptr));
#if QT_CONFIG(statustip)
        toolBarNotes->setStatusTip(QCoreApplication::translate("VPiano", "Notes Tool Bar", nullptr));
#endif // QT_CONFIG(statustip)
        toolBarPrograms->setWindowTitle(QCoreApplication::translate("VPiano", "&Programs", nullptr));
#if QT_CONFIG(statustip)
        toolBarPrograms->setStatusTip(QCoreApplication::translate("VPiano", "Programs Tool Bar", nullptr));
#endif // QT_CONFIG(statustip)
        toolBarControllers->setWindowTitle(QCoreApplication::translate("VPiano", "&Controllers", nullptr));
#if QT_CONFIG(statustip)
        toolBarControllers->setStatusTip(QCoreApplication::translate("VPiano", "Controllers Tool Bar", nullptr));
#endif // QT_CONFIG(statustip)
        toolBarExtra->setWindowTitle(QCoreApplication::translate("VPiano", "&Extra Controls", nullptr));
#if QT_CONFIG(statustip)
        toolBarExtra->setStatusTip(QCoreApplication::translate("VPiano", "Extra Tool Bar", nullptr));
#endif // QT_CONFIG(statustip)
        toolBarBender->setWindowTitle(QCoreApplication::translate("VPiano", "Pitch &Bender", nullptr));
#if QT_CONFIG(statustip)
        toolBarBender->setStatusTip(QCoreApplication::translate("VPiano", "Bender Tool Bar", nullptr));
#endif // QT_CONFIG(statustip)
        (void)VPiano;
    } // retranslateUi

};

namespace Ui {
    class VPiano: public Ui_VPiano {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_VPIANO_H
