/* Generated by wayland-scanner 1.23.1 */

#ifndef EXT_IMAGE_COPY_CAPTURE_V1_CLIENT_PROTOCOL_H
#define EXT_IMAGE_COPY_CAPTURE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ext_image_copy_capture_v1 The ext_image_copy_capture_v1 protocol
 * image capturing into client buffers
 *
 * @section page_desc_ext_image_copy_capture_v1 Description
 *
 * This protocol allows clients to ask the compositor to capture image sources
 * such as outputs and toplevels into user submitted buffers.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_ext_image_copy_capture_v1 Interfaces
 * - @subpage page_iface_ext_image_copy_capture_manager_v1 - manager to inform clients and begin capturing
 * - @subpage page_iface_ext_image_copy_capture_session_v1 - image copy capture session
 * - @subpage page_iface_ext_image_copy_capture_frame_v1 - image capture frame
 * - @subpage page_iface_ext_image_copy_capture_cursor_session_v1 - cursor capture session
 * @section page_copyright_ext_image_copy_capture_v1 Copyright
 * <pre>
 *
 * Copyright © 2021-2023 Andri Yngvason
 * Copyright © 2024 Simon Ser
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_image_capture_source_v1;
struct ext_image_copy_capture_cursor_session_v1;
struct ext_image_copy_capture_frame_v1;
struct ext_image_copy_capture_manager_v1;
struct ext_image_copy_capture_session_v1;
struct wl_buffer;
struct wl_pointer;

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_manager_v1 ext_image_copy_capture_manager_v1
 * @section page_iface_ext_image_copy_capture_manager_v1_desc Description
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 * @section page_iface_ext_image_copy_capture_manager_v1_api API
 * See @ref iface_ext_image_copy_capture_manager_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_manager_v1 The ext_image_copy_capture_manager_v1 interface
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 */
extern const struct wl_interface ext_image_copy_capture_manager_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_SESSION_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_session_v1 ext_image_copy_capture_session_v1
 * @section page_iface_ext_image_copy_capture_session_v1_desc Description
 *
 * This object represents an active image copy capture session.
 *
 * After a capture session is created, buffer constraint events will be
 * emitted from the compositor to tell the client which buffer types and
 * formats are supported for reading from the session. The compositor may
 * re-send buffer constraint events whenever they change.
 *
 * The advertise buffer constraints, the compositor must send in no
 * particular order: zero or more shm_format and dmabuf_format events, zero
 * or one dmabuf_device event, and exactly one buffer_size event. Then the
 * compositor must send a done event.
 *
 * When the client has received all the buffer constraints, it can create a
 * buffer accordingly, attach it to the capture session using the
 * attach_buffer request, set the buffer damage using the damage_buffer
 * request and then send the capture request.
 * @section page_iface_ext_image_copy_capture_session_v1_api API
 * See @ref iface_ext_image_copy_capture_session_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_session_v1 The ext_image_copy_capture_session_v1 interface
 *
 * This object represents an active image copy capture session.
 *
 * After a capture session is created, buffer constraint events will be
 * emitted from the compositor to tell the client which buffer types and
 * formats are supported for reading from the session. The compositor may
 * re-send buffer constraint events whenever they change.
 *
 * The advertise buffer constraints, the compositor must send in no
 * particular order: zero or more shm_format and dmabuf_format events, zero
 * or one dmabuf_device event, and exactly one buffer_size event. Then the
 * compositor must send a done event.
 *
 * When the client has received all the buffer constraints, it can create a
 * buffer accordingly, attach it to the capture session using the
 * attach_buffer request, set the buffer damage using the damage_buffer
 * request and then send the capture request.
 */
extern const struct wl_interface ext_image_copy_capture_session_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_frame_v1 ext_image_copy_capture_frame_v1
 * @section page_iface_ext_image_copy_capture_frame_v1_desc Description
 *
 * This object represents an image capture frame.
 *
 * The client should attach a buffer, damage the buffer, and then send a
 * capture request.
 *
 * If the capture is successful, the compositor must send the frame metadata
 * (transform, damage, presentation_time in any order) followed by the ready
 * event.
 *
 * If the capture fails, the compositor must send the failed event.
 * @section page_iface_ext_image_copy_capture_frame_v1_api API
 * See @ref iface_ext_image_copy_capture_frame_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_frame_v1 The ext_image_copy_capture_frame_v1 interface
 *
 * This object represents an image capture frame.
 *
 * The client should attach a buffer, damage the buffer, and then send a
 * capture request.
 *
 * If the capture is successful, the compositor must send the frame metadata
 * (transform, damage, presentation_time in any order) followed by the ready
 * event.
 *
 * If the capture fails, the compositor must send the failed event.
 */
extern const struct wl_interface ext_image_copy_capture_frame_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_cursor_session_v1 ext_image_copy_capture_cursor_session_v1
 * @section page_iface_ext_image_copy_capture_cursor_session_v1_desc Description
 *
 * This object represents a cursor capture session. It extends the base
 * capture session with cursor-specific metadata.
 * @section page_iface_ext_image_copy_capture_cursor_session_v1_api API
 * See @ref iface_ext_image_copy_capture_cursor_session_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_cursor_session_v1 The ext_image_copy_capture_cursor_session_v1 interface
 *
 * This object represents a cursor capture session. It extends the base
 * capture session with cursor-specific metadata.
 */
extern const struct wl_interface ext_image_copy_capture_cursor_session_v1_interface;
#endif

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM
enum ext_image_copy_capture_manager_v1_error {
	/**
	 * invalid option flag
	 */
	EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_INVALID_OPTION = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM
enum ext_image_copy_capture_manager_v1_options {
	/**
	 * paint cursors onto captured frames
	 */
	EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_PAINT_CURSORS = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM */

#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_SESSION 0
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_POINTER_CURSOR_SESSION 1
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_DESTROY 2


/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_POINTER_CURSOR_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_image_copy_capture_manager_v1 */
static inline void
ext_image_copy_capture_manager_v1_set_user_data(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_image_copy_capture_manager_v1, user_data);
}

/** @ingroup iface_ext_image_copy_capture_manager_v1 */
static inline void *
ext_image_copy_capture_manager_v1_get_user_data(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_image_copy_capture_manager_v1);
}

static inline uint32_t
ext_image_copy_capture_manager_v1_get_version(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_manager_v1);
}

/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 *
 * Create a capturing session for an image capture source.
 *
 * If the paint_cursors option is set, cursors shall be composited onto
 * the captured frame. The cursor must not be composited onto the frame
 * if this flag is not set.
 *
 * If the options bitfield is invalid, the invalid_option protocol error
 * is sent.
 */
static inline struct ext_image_copy_capture_session_v1 *
ext_image_copy_capture_manager_v1_create_session(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1, struct ext_image_capture_source_v1 *source, uint32_t options)
{
	struct wl_proxy *session;

	session = wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_manager_v1,
			 EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_SESSION, &ext_image_copy_capture_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_manager_v1), 0, NULL, source, options);

	return (struct ext_image_copy_capture_session_v1 *) session;
}

/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 *
 * Create a cursor capturing session for the pointer of an image capture
 * source.
 */
static inline struct ext_image_copy_capture_cursor_session_v1 *
ext_image_copy_capture_manager_v1_create_pointer_cursor_session(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1, struct ext_image_capture_source_v1 *source, struct wl_pointer *pointer)
{
	struct wl_proxy *session;

	session = wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_manager_v1,
			 EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_POINTER_CURSOR_SESSION, &ext_image_copy_capture_cursor_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_manager_v1), 0, NULL, source, pointer);

	return (struct ext_image_copy_capture_cursor_session_v1 *) session;
}

/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 *
 * Destroy the manager object.
 *
 * Other objects created via this interface are unaffected.
 */
static inline void
ext_image_copy_capture_manager_v1_destroy(struct ext_image_copy_capture_manager_v1 *ext_image_copy_capture_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_manager_v1,
			 EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM
enum ext_image_copy_capture_session_v1_error {
	/**
	 * create_frame sent before destroying previous frame
	 */
	EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_DUPLICATE_FRAME = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM */

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * @struct ext_image_copy_capture_session_v1_listener
 */
struct ext_image_copy_capture_session_v1_listener {
	/**
	 * image capture source dimensions
	 *
	 * Provides the dimensions of the source image in buffer pixel
	 * coordinates.
	 *
	 * The client must attach buffers that match this size.
	 * @param width buffer width
	 * @param height buffer height
	 */
	void (*buffer_size)(void *data,
			    struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1,
			    uint32_t width,
			    uint32_t height);
	/**
	 * shm buffer format
	 *
	 * Provides the format that must be used for shared-memory
	 * buffers.
	 *
	 * This event may be emitted multiple times, in which case the
	 * client may choose any given format.
	 * @param format shm format
	 */
	void (*shm_format)(void *data,
			   struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1,
			   uint32_t format);
	/**
	 * dma-buf device
	 *
	 * This event advertises the device buffers must be allocated on
	 * for dma-buf buffers.
	 *
	 * In general the device is a DRM node. The DRM node type (primary
	 * vs. render) is unspecified. Clients must not rely on the
	 * compositor sending a particular node type. Clients cannot check
	 * two devices for equality by comparing the dev_t value.
	 * @param device device dev_t value
	 */
	void (*dmabuf_device)(void *data,
			      struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1,
			      struct wl_array *device);
	/**
	 * dma-buf format
	 *
	 * Provides the format that must be used for dma-buf buffers.
	 *
	 * The client may choose any of the modifiers advertised in the
	 * array of 64-bit unsigned integers.
	 *
	 * This event may be emitted multiple times, in which case the
	 * client may choose any given format.
	 * @param format drm format code
	 * @param modifiers drm format modifiers
	 */
	void (*dmabuf_format)(void *data,
			      struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1,
			      uint32_t format,
			      struct wl_array *modifiers);
	/**
	 * all constraints have been sent
	 *
	 * This event is sent once when all buffer constraint events have
	 * been sent.
	 *
	 * The compositor must always end a batch of buffer constraint
	 * events with this event, regardless of whether it sends the
	 * initial constraints or an update.
	 */
	void (*done)(void *data,
		     struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1);
	/**
	 * session is no longer available
	 *
	 * This event indicates that the capture session has stopped and
	 * is no longer available. This can happen in a number of cases,
	 * e.g. when the underlying source is destroyed, if the user
	 * decides to end the image capture, or if an unrecoverable runtime
	 * error has occurred.
	 *
	 * The client should destroy the session after receiving this
	 * event.
	 */
	void (*stopped)(void *data,
			struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1);
};

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
static inline int
ext_image_copy_capture_session_v1_add_listener(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1,
					       const struct ext_image_copy_capture_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_image_copy_capture_session_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_CREATE_FRAME 0
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DESTROY 1

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_BUFFER_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_SHM_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_STOPPED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_CREATE_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_image_copy_capture_session_v1 */
static inline void
ext_image_copy_capture_session_v1_set_user_data(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_image_copy_capture_session_v1, user_data);
}

/** @ingroup iface_ext_image_copy_capture_session_v1 */
static inline void *
ext_image_copy_capture_session_v1_get_user_data(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_image_copy_capture_session_v1);
}

static inline uint32_t
ext_image_copy_capture_session_v1_get_version(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_session_v1);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 *
 * Create a capture frame for this session.
 *
 * At most one frame object can exist for a given session at any time. If
 * a client sends a create_frame request before a previous frame object
 * has been destroyed, the duplicate_frame protocol error is raised.
 */
static inline struct ext_image_copy_capture_frame_v1 *
ext_image_copy_capture_session_v1_create_frame(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_session_v1,
			 EXT_IMAGE_COPY_CAPTURE_SESSION_V1_CREATE_FRAME, &ext_image_copy_capture_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_session_v1), 0, NULL);

	return (struct ext_image_copy_capture_frame_v1 *) frame;
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 *
 * Destroys the session. This request can be sent at any time by the
 * client.
 *
 * This request doesn't affect ext_image_copy_capture_frame_v1 objects created by
 * this object.
 */
static inline void
ext_image_copy_capture_session_v1_destroy(struct ext_image_copy_capture_session_v1 *ext_image_copy_capture_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_session_v1,
			 EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM
enum ext_image_copy_capture_frame_v1_error {
	/**
	 * capture sent without attach_buffer
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_NO_BUFFER = 1,
	/**
	 * invalid buffer damage
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_INVALID_BUFFER_DAMAGE = 2,
	/**
	 * capture request has been sent
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ALREADY_CAPTURED = 3,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM
enum ext_image_copy_capture_frame_v1_failure_reason {
	/**
	 * unknown runtime error
	 *
	 * An unspecified runtime error has occurred. The client may
	 * retry.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_UNKNOWN = 0,
	/**
	 * buffer constraints mismatch
	 *
	 * The buffer submitted by the client doesn't match the latest
	 * session constraints. The client should re-allocate its buffers
	 * and retry.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_BUFFER_CONSTRAINTS = 1,
	/**
	 * session is no longer available
	 *
	 * The session has stopped. See
	 * ext_image_copy_capture_session_v1.stopped.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_STOPPED = 2,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM */

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * @struct ext_image_copy_capture_frame_v1_listener
 */
struct ext_image_copy_capture_frame_v1_listener {
	/**
	 * buffer transform
	 *
	 * This event is sent before the ready event and holds the
	 * transform that the compositor has applied to the buffer
	 * contents.
	 */
	void (*transform)(void *data,
			  struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1,
			  uint32_t transform);
	/**
	 * buffer damaged region
	 *
	 * This event is sent before the ready event. It may be generated
	 * multiple times to describe a region.
	 *
	 * The first captured frame in a session will always carry full
	 * damage. Subsequent frames' damaged regions describe which parts
	 * of the buffer have changed since the last ready event.
	 *
	 * These coordinates originate in the upper left corner of the
	 * buffer.
	 * @param x damage x coordinate
	 * @param y damage y coordinate
	 * @param width damage width
	 * @param height damage height
	 */
	void (*damage)(void *data,
		       struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1,
		       int32_t x,
		       int32_t y,
		       int32_t width,
		       int32_t height);
	/**
	 * presentation time of the frame
	 *
	 * This event indicates the time at which the frame is presented
	 * to the output in system monotonic time. This event is sent
	 * before the ready event.
	 *
	 * The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec
	 * triples, each component being an unsigned 32-bit value. Whole
	 * seconds are in tv_sec which is a 64-bit value combined from
	 * tv_sec_hi and tv_sec_lo, and the additional fractional part in
	 * tv_nsec as nanoseconds. Hence, for valid timestamps tv_nsec must
	 * be in [0, 999999999].
	 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
	 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
	 * @param tv_nsec nanoseconds part of the timestamp
	 */
	void (*presentation_time)(void *data,
				  struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1,
				  uint32_t tv_sec_hi,
				  uint32_t tv_sec_lo,
				  uint32_t tv_nsec);
	/**
	 * frame is available for reading
	 *
	 * Called as soon as the frame is copied, indicating it is
	 * available for reading.
	 *
	 * The buffer may be re-used by the client after this event.
	 *
	 * After receiving this event, the client must destroy the object.
	 */
	void (*ready)(void *data,
		      struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1);
	/**
	 * capture failed
	 *
	 * This event indicates that the attempted frame copy has failed.
	 *
	 * After receiving this event, the client must destroy the object.
	 */
	void (*failed)(void *data,
		       struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1,
		       uint32_t reason);
};

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
static inline int
ext_image_copy_capture_frame_v1_add_listener(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1,
					     const struct ext_image_copy_capture_frame_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_image_copy_capture_frame_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DESTROY 0
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ATTACH_BUFFER 1
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_BUFFER 2
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_CAPTURE 3

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_PRESENTATION_TIME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ATTACH_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_CAPTURE_SINCE_VERSION 1

/** @ingroup iface_ext_image_copy_capture_frame_v1 */
static inline void
ext_image_copy_capture_frame_v1_set_user_data(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_image_copy_capture_frame_v1, user_data);
}

/** @ingroup iface_ext_image_copy_capture_frame_v1 */
static inline void *
ext_image_copy_capture_frame_v1_get_user_data(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_image_copy_capture_frame_v1);
}

static inline uint32_t
ext_image_copy_capture_frame_v1_get_version(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_frame_v1);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 *
 * Destroys the session. This request can be sent at any time by the
 * client.
 */
static inline void
ext_image_copy_capture_frame_v1_destroy(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_frame_v1,
			 EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_frame_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 *
 * Attach a buffer to the session.
 *
 * The wl_buffer.release request is unused.
 *
 * The new buffer replaces any previously attached buffer.
 *
 * This request must not be sent after capture, or else the
 * already_captured protocol error is raised.
 */
static inline void
ext_image_copy_capture_frame_v1_attach_buffer(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_frame_v1,
			 EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ATTACH_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_frame_v1), 0, buffer);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 *
 * Apply damage to the buffer which is to be captured next. This request
 * may be sent multiple times to describe a region.
 *
 * The client indicates the accumulated damage since this wl_buffer was
 * last captured. During capture, the compositor will update the buffer
 * with at least the union of the region passed by the client and the
 * region advertised by ext_image_copy_capture_frame_v1.damage.
 *
 * When a wl_buffer is captured for the first time, or when the client
 * doesn't track damage, the client must damage the whole buffer.
 *
 * This is for optimisation purposes. The compositor may use this
 * information to reduce copying.
 *
 * These coordinates originate from the upper left corner of the buffer.
 *
 * If x or y are strictly negative, or if width or height are negative or
 * zero, the invalid_buffer_damage protocol error is raised.
 *
 * This request must not be sent after capture, or else the
 * already_captured protocol error is raised.
 */
static inline void
ext_image_copy_capture_frame_v1_damage_buffer(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_frame_v1,
			 EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_frame_v1), 0, x, y, width, height);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 *
 * Capture a frame.
 *
 * Unless this is the first successful captured frame performed in this
 * session, the compositor may wait an indefinite amount of time for the
 * source content to change before performing the copy.
 *
 * This request may only be sent once, or else the already_captured
 * protocol error is raised. A buffer must be attached before this request
 * is sent, or else the no_buffer protocol error is raised.
 */
static inline void
ext_image_copy_capture_frame_v1_capture(struct ext_image_copy_capture_frame_v1 *ext_image_copy_capture_frame_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_frame_v1,
			 EXT_IMAGE_COPY_CAPTURE_FRAME_V1_CAPTURE, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_frame_v1), 0);
}

#ifndef EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM
enum ext_image_copy_capture_cursor_session_v1_error {
	/**
	 * get_captuerer_session sent twice
	 */
	EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_DUPLICATE_SESSION = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM */

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * @struct ext_image_copy_capture_cursor_session_v1_listener
 */
struct ext_image_copy_capture_cursor_session_v1_listener {
	/**
	 * cursor entered captured area
	 *
	 * Sent when a cursor enters the captured area. It shall be
	 * generated before the "position" and "hotspot" events when and
	 * only when a cursor enters the area.
	 *
	 * The cursor enters the captured area when the cursor image
	 * intersects with the captured area. Note, this is different from
	 * e.g. wl_pointer.enter.
	 */
	void (*enter)(void *data,
		      struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1);
	/**
	 * cursor left captured area
	 *
	 * Sent when a cursor leaves the captured area. No "position" or
	 * "hotspot" event is generated for the cursor until the cursor
	 * enters the captured area again.
	 */
	void (*leave)(void *data,
		      struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1);
	/**
	 * position changed
	 *
	 * Cursors outside the image capture source do not get captured
	 * and no event will be generated for them.
	 *
	 * The given position is the position of the cursor's hotspot and
	 * it is relative to the main buffer's top left corner in
	 * transformed buffer pixel coordinates. The coordinates may be
	 * negative or greater than the main buffer size.
	 * @param x position x coordinates
	 * @param y position y coordinates
	 */
	void (*position)(void *data,
			 struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1,
			 int32_t x,
			 int32_t y);
	/**
	 * hotspot changed
	 *
	 * The hotspot describes the offset between the cursor image and
	 * the position of the input device.
	 *
	 * The given coordinates are the hotspot's offset from the origin
	 * in buffer coordinates.
	 *
	 * Clients should not apply the hotspot immediately: the hotspot
	 * becomes effective when the next
	 * ext_image_copy_capture_frame_v1.ready event is received.
	 *
	 * Compositors may delay this event until the client captures a new
	 * frame.
	 * @param x hotspot x coordinates
	 * @param y hotspot y coordinates
	 */
	void (*hotspot)(void *data,
			struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1,
			int32_t x,
			int32_t y);
};

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
static inline int
ext_image_copy_capture_cursor_session_v1_add_listener(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1,
						      const struct ext_image_copy_capture_cursor_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_DESTROY 0
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_GET_CAPTURE_SESSION 1

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_HOTSPOT_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_GET_CAPTURE_SESSION_SINCE_VERSION 1

/** @ingroup iface_ext_image_copy_capture_cursor_session_v1 */
static inline void
ext_image_copy_capture_cursor_session_v1_set_user_data(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1, user_data);
}

/** @ingroup iface_ext_image_copy_capture_cursor_session_v1 */
static inline void *
ext_image_copy_capture_cursor_session_v1_get_user_data(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1);
}

static inline uint32_t
ext_image_copy_capture_cursor_session_v1_get_version(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1);
}

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 *
 * Destroys the session. This request can be sent at any time by the
 * client.
 *
 * This request doesn't affect ext_image_copy_capture_frame_v1 objects created by
 * this object.
 */
static inline void
ext_image_copy_capture_cursor_session_v1_destroy(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1,
			 EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 *
 * Gets the image copy capture session for this cursor session.
 *
 * The session will produce frames of the cursor image. The compositor may
 * pause the session when the cursor leaves the captured area.
 *
 * This request must not be sent more than once, or else the
 * duplicate_session protocol error is raised.
 */
static inline struct ext_image_copy_capture_session_v1 *
ext_image_copy_capture_cursor_session_v1_get_capture_session(struct ext_image_copy_capture_cursor_session_v1 *ext_image_copy_capture_cursor_session_v1)
{
	struct wl_proxy *session;

	session = wl_proxy_marshal_flags((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1,
			 EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_GET_CAPTURE_SESSION, &ext_image_copy_capture_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_image_copy_capture_cursor_session_v1), 0, NULL);

	return (struct ext_image_copy_capture_session_v1 *) session;
}

#ifdef  __cplusplus
}
#endif

#endif
