/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMSelection.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGetComposedRangesOptions.h"
#include "JSNode.h"
#include "JSRange.h"
#include "JSShadowRoot.h"
#include "JSStaticRange.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_getRangeAt);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_addRange);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_removeRange);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_removeAllRanges);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_getComposedRanges);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_empty);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapse);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_setPosition);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapseToStart);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapseToEnd);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_extend);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_setBaseAndExtent);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_selectAllChildren);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_deleteFromDocument);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_containsNode);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_toString);
static JSC_DECLARE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_modify);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelectionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_anchorNode);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_anchorOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_focusNode);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_focusOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_isCollapsed);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_rangeCount);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_type);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_direction);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_baseNode);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_baseOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_extentNode);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMSelection_extentOffset);

class JSDOMSelectionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMSelectionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMSelectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMSelectionPrototype>(vm)) JSDOMSelectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMSelectionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMSelectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMSelectionPrototype, JSDOMSelectionPrototype::Base);

using JSDOMSelectionDOMConstructor = JSDOMConstructorNotConstructable<JSDOMSelection>;

template<> const ClassInfo JSDOMSelectionDOMConstructor::s_info = { "Selection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelectionDOMConstructor) };

template<> JSValue JSDOMSelectionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMSelectionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Selection"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMSelection::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 30> JSDOMSelectionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelectionConstructor, 0 } },
    HashTableValue { "anchorNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_anchorNode, 0 } },
    HashTableValue { "anchorOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_anchorOffset, 0 } },
    HashTableValue { "focusNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_focusNode, 0 } },
    HashTableValue { "focusOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_focusOffset, 0 } },
    HashTableValue { "isCollapsed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_isCollapsed, 0 } },
    HashTableValue { "rangeCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_rangeCount, 0 } },
    HashTableValue { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_type, 0 } },
    HashTableValue { "direction"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_direction, 0 } },
    HashTableValue { "baseNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_baseNode, 0 } },
    HashTableValue { "baseOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_baseOffset, 0 } },
    HashTableValue { "extentNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_extentNode, 0 } },
    HashTableValue { "extentOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMSelection_extentOffset, 0 } },
    HashTableValue { "getRangeAt"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_getRangeAt, 1 } },
    HashTableValue { "addRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_addRange, 1 } },
    HashTableValue { "removeRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_removeRange, 1 } },
    HashTableValue { "removeAllRanges"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_removeAllRanges, 0 } },
    HashTableValue { "getComposedRanges"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_getComposedRanges, 0 } },
    HashTableValue { "empty"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_empty, 0 } },
    HashTableValue { "collapse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_collapse, 1 } },
    HashTableValue { "setPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_setPosition, 1 } },
    HashTableValue { "collapseToStart"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_collapseToStart, 0 } },
    HashTableValue { "collapseToEnd"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_collapseToEnd, 0 } },
    HashTableValue { "extend"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_extend, 1 } },
    HashTableValue { "setBaseAndExtent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_setBaseAndExtent, 4 } },
    HashTableValue { "selectAllChildren"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_selectAllChildren, 1 } },
    HashTableValue { "deleteFromDocument"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_deleteFromDocument, 0 } },
    HashTableValue { "containsNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_containsNode, 1 } },
    HashTableValue { "toString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_toString, 0 } },
    HashTableValue { "modify"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMSelectionPrototypeFunction_modify, 0 } },
};

const ClassInfo JSDOMSelectionPrototype::s_info = { "Selection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelectionPrototype) };

void JSDOMSelectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMSelection::info(), JSDOMSelectionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMSelection::s_info = { "Selection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelection) };

JSDOMSelection::JSDOMSelection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMSelection>&& impl)
    : JSDOMWrapper<DOMSelection>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMSelection>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMSelection::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMSelectionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMSelectionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMSelection::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMSelection>(vm, globalObject);
}

JSValue JSDOMSelection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMSelectionDOMConstructor, DOMConstructorID::DOMSelection>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMSelection::destroy(JSC::JSCell* cell)
{
    JSDOMSelection* thisObject = static_cast<JSDOMSelection*>(cell);
    thisObject->JSDOMSelection::~JSDOMSelection();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelectionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMSelectionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMSelection::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMSelection_anchorNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.anchorNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_anchorNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_anchorNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_anchorOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.anchorOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_anchorOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_anchorOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_focusNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.focusNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_focusNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_focusNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_focusOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.focusOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_focusOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_focusOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_isCollapsedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isCollapsed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_isCollapsed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_isCollapsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_rangeCountGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.rangeCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_rangeCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_rangeCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_typeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_directionGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.direction())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_direction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_directionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_baseNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.anchorNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_baseNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_baseNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_baseOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.anchorOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_baseOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_baseOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_extentNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.focusNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_extentNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_extentNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMSelection_extentOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.focusOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMSelection_extentOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelection_extentOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_getRangeAtBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (indexConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRangeAt(indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_getRangeAt, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_getRangeAtBody>(*lexicalGlobalObject, *callFrame, "getRangeAt");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_addRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rangeConversionResult = convert<IDLInterface<Range>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range"_s, "Selection"_s, "addRange"_s, "Range"_s); });
    if (rangeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addRange(*rangeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_addRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_addRangeBody>(*lexicalGlobalObject, *callFrame, "addRange");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_removeRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rangeConversionResult = convert<IDLInterface<Range>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range"_s, "Selection"_s, "removeRange"_s, "Range"_s); });
    if (rangeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeRange(*rangeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_removeRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_removeRangeBody>(*lexicalGlobalObject, *callFrame, "removeRange");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_removeAllRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeAllRanges(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_removeAllRanges, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_removeAllRangesBody>(*lexicalGlobalObject, *callFrame, "removeAllRanges");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_getComposedRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLOptional<IDLUnion<IDLInterface<ShadowRoot>, IDLDictionary<GetComposedRangesOptions>>>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto shadowRoots = convertVariadicArguments<IDLInterface<ShadowRoot>>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<StaticRange>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getComposedRanges(optionsConversionResult.releaseReturnValue(), WTFMove(shadowRoots)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_getComposedRanges, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_getComposedRangesBody>(*lexicalGlobalObject, *callFrame, "getComposedRanges");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_emptyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.empty(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_empty, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_emptyBody>(*lexicalGlobalObject, *callFrame, "empty");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_collapseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Selection"_s, "collapse"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.collapse(nodeConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_collapseBody>(*lexicalGlobalObject, *callFrame, "collapse");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_setPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Selection"_s, "setPosition"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPosition(nodeConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_setPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_setPositionBody>(*lexicalGlobalObject, *callFrame, "setPosition");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_collapseToStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.collapseToStart(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapseToStart, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_collapseToStartBody>(*lexicalGlobalObject, *callFrame, "collapseToStart");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_collapseToEndBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.collapseToEnd(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_collapseToEnd, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_collapseToEndBody>(*lexicalGlobalObject, *callFrame, "collapseToEnd");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_extendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Selection"_s, "extend"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto offsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.extend(*nodeConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_extend, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_extendBody>(*lexicalGlobalObject, *callFrame, "extend");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_setBaseAndExtentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto anchorNodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "anchorNode"_s, "Selection"_s, "setBaseAndExtent"_s, "Node"_s); });
    if (anchorNodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto anchorOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (anchorOffsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto focusNodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "focusNode"_s, "Selection"_s, "setBaseAndExtent"_s, "Node"_s); });
    if (focusNodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto focusOffsetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    if (focusOffsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBaseAndExtent(*anchorNodeConversionResult.releaseReturnValue(), anchorOffsetConversionResult.releaseReturnValue(), *focusNodeConversionResult.releaseReturnValue(), focusOffsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_setBaseAndExtent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_setBaseAndExtentBody>(*lexicalGlobalObject, *callFrame, "setBaseAndExtent");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_selectAllChildrenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Selection"_s, "selectAllChildren"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.selectAllChildren(*nodeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_selectAllChildren, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_selectAllChildrenBody>(*lexicalGlobalObject, *callFrame, "selectAllChildren");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_deleteFromDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteFromDocument(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_deleteFromDocument, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_deleteFromDocumentBody>(*lexicalGlobalObject, *callFrame, "deleteFromDocument");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_containsNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Selection"_s, "containsNode"_s, "Node"_s); });
    if (nodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto allowPartialContainmentConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (allowPartialContainmentConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.containsNode(*nodeConversionResult.releaseReturnValue(), allowPartialContainmentConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_containsNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_containsNodeBody>(*lexicalGlobalObject, *callFrame, "containsNode");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_toStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_toString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_toStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunction_modifyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto alterConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (alterConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto directionConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (directionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto granularityConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (granularityConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.modify(alterConversionResult.releaseReturnValue(), directionConversionResult.releaseReturnValue(), granularityConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMSelectionPrototypeFunction_modify, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunction_modifyBody>(*lexicalGlobalObject, *callFrame, "modify");
}

JSC::GCClient::IsoSubspace* JSDOMSelection::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMSelection, UseCustomHeapCellType::No>(vm, "JSDOMSelection"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMSelection.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMSelection = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMSelection.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMSelection = std::forward<decltype(space)>(space); }
    );
}

void JSDOMSelection::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMSelection*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMSelectionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsDOMSelection = jsCast<JSDOMSelection*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsDOMSelection->wrapped().window());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Window"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSDOMSelectionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMSelection = static_cast<JSDOMSelection*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMSelection->protectedWrapped().ptr(), jsDOMSelection);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMSelection@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12DOMSelectionE[]; }
#endif
template<std::same_as<DOMSelection> T>
static inline void verifyVTable(DOMSelection* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMSelection@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12DOMSelectionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMSelection has subclasses. If DOMSelection has subclasses that get passed
        // to toJS() we currently require DOMSelection you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMSelection>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMSelection>(impl.ptr());
#endif
    return createWrapper<DOMSelection>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMSelection& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMSelection* JSDOMSelection::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMSelection*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
