/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSIIRFilterNode.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBaseAudioContext.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIIRFilterOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIIRFilterNodePrototypeFunction_getFrequencyResponse);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIIRFilterNodeConstructor);

class JSIIRFilterNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIIRFilterNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIIRFilterNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSIIRFilterNodePrototype>(vm)) JSIIRFilterNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIIRFilterNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIIRFilterNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIIRFilterNodePrototype, JSIIRFilterNodePrototype::Base);

using JSIIRFilterNodeDOMConstructor = JSDOMConstructor<JSIIRFilterNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSIIRFilterNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSIIRFilterNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "IIRFilterNode"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto audioContextConversionResult = convert<IDLInterface<BaseAudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "audioContext"_s, "IIRFilterNode"_s, nullptr, "BaseAudioContext"_s); });
    if (audioContextConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto optionsConversionResult = convert<IDLDictionary<IIRFilterOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = IIRFilterNode::create(*context, *audioContextConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<IIRFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<IIRFilterNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSIIRFilterNodeDOMConstructorConstruct, JSIIRFilterNodeDOMConstructor::construct);

template<> const ClassInfo JSIIRFilterNodeDOMConstructor::s_info = { "IIRFilterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIIRFilterNodeDOMConstructor) };

template<> JSValue JSIIRFilterNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSIIRFilterNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IIRFilterNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIIRFilterNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSIIRFilterNodePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIIRFilterNodeConstructor, 0 } },
    HashTableValue { "getFrequencyResponse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIIRFilterNodePrototypeFunction_getFrequencyResponse, 3 } },
};

const ClassInfo JSIIRFilterNodePrototype::s_info = { "IIRFilterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIIRFilterNodePrototype) };

void JSIIRFilterNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIIRFilterNode::info(), JSIIRFilterNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIIRFilterNode::s_info = { "IIRFilterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIIRFilterNode) };

JSIIRFilterNode::JSIIRFilterNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IIRFilterNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

Ref<IIRFilterNode> JSIIRFilterNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, IIRFilterNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIIRFilterNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIIRFilterNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSIIRFilterNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIIRFilterNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIIRFilterNode>(vm, globalObject);
}

JSValue JSIIRFilterNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIIRFilterNodeDOMConstructor, DOMConstructorID::IIRFilterNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIIRFilterNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIIRFilterNodePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIIRFilterNode::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsIIRFilterNodePrototypeFunction_getFrequencyResponseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIIRFilterNode>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto frequencyHzConversionResult = convert<IDLFloat32Array>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "frequencyHz"_s, "IIRFilterNode"_s, "getFrequencyResponse"_s, "Float32Array"_s); });
    if (frequencyHzConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto magResponseConversionResult = convert<IDLFloat32Array>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "magResponse"_s, "IIRFilterNode"_s, "getFrequencyResponse"_s, "Float32Array"_s); });
    if (magResponseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto phaseResponseConversionResult = convert<IDLFloat32Array>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "phaseResponse"_s, "IIRFilterNode"_s, "getFrequencyResponse"_s, "Float32Array"_s); });
    if (phaseResponseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getFrequencyResponse(frequencyHzConversionResult.releaseReturnValue(), magResponseConversionResult.releaseReturnValue(), phaseResponseConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIIRFilterNodePrototypeFunction_getFrequencyResponse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIIRFilterNode>::call<jsIIRFilterNodePrototypeFunction_getFrequencyResponseBody>(*lexicalGlobalObject, *callFrame, "getFrequencyResponse");
}

JSC::GCClient::IsoSubspace* JSIIRFilterNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIIRFilterNode, UseCustomHeapCellType::No>(vm, "JSIIRFilterNode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIIRFilterNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIIRFilterNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIIRFilterNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIIRFilterNode = std::forward<decltype(space)>(space); }
    );
}

void JSIIRFilterNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIIRFilterNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IIRFilterNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13IIRFilterNodeE[]; }
#endif
template<std::same_as<IIRFilterNode> T>
static inline void verifyVTable(IIRFilterNode* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7IIRFilterNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13IIRFilterNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // IIRFilterNode has subclasses. If IIRFilterNode has subclasses that get passed
        // to toJS() we currently require IIRFilterNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IIRFilterNode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<IIRFilterNode>(impl.ptr());
#endif
    return createWrapper<IIRFilterNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IIRFilterNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
