/* Manager.c generated by valac 0.56.17, the Vala compiler
 * generated from Manager.vala, do not modify */

/*-
 * Copyright (c) 2015-2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bluetooth.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_0_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothIndicatorServicesObjectManagerCreateManagerData BluetoothIndicatorServicesObjectManagerCreateManagerData;
typedef struct _Block4Data Block4Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _BluetoothIndicatorServicesObjectManagerSetGlobalStateData BluetoothIndicatorServicesObjectManagerSetGlobalStateData;
typedef struct _BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_GLOBAL_STATE_CHANGED_SIGNAL,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL,
	BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_NUM_SIGNALS
};
static guint bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_NUM_SIGNALS] = {0};

struct _BluetoothIndicatorServicesObjectManagerPrivate {
	gboolean _has_object;
	gboolean _retrieve_finished;
	GSettings* _settings;
	GDBusObjectManagerClient* object_manager;
	gboolean _is_powered;
	gboolean _is_connected;
};

struct _Block1Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	GDBusObject* object;
};

struct _Block2Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	GDBusObject* object;
};

struct _Block3Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	GDBusObject* object;
};

struct _BluetoothIndicatorServicesObjectManagerCreateManagerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothIndicatorServicesObjectManager* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GDBusObjectManagerClient* _tmp6_;
	GDBusObjectManagerClient* _tmp7_;
	GDBusObjectManagerClient* _tmp8_;
	GDBusObjectManagerClient* _tmp9_;
	GSettings* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	BluetoothIndicatorServicesDevice* device;
};

struct _Block5Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	GeeLinkedList* adapters;
};

struct _Block6Data {
	int _ref_count_;
	BluetoothIndicatorServicesObjectManager* self;
	GeeLinkedList* devices;
};

struct _BluetoothIndicatorServicesObjectManagerSetGlobalStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothIndicatorServicesObjectManager* self;
	gboolean state;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp1_;
	gint _adapter_size;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _adapter_index;
	gint _tmp5_;
	gint _tmp6_;
	BluetoothIndicatorServicesAdapter* adapter;
	GeeLinkedList* _tmp7_;
	gpointer _tmp8_;
	BluetoothIndicatorServicesAdapter* _tmp9_;
	GeeCollection* devices;
	GeeCollection* _tmp10_;
	GeeIterator* _device_it;
	GeeCollection* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	BluetoothIndicatorServicesDevice* device;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	BluetoothIndicatorServicesDevice* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	BluetoothIndicatorServicesDevice* _tmp19_;
	GError* e;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_;
};

struct _BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothIndicatorServicesObjectManager* self;
	GSettings* _tmp0_;
};

static gint BluetoothIndicatorServicesObjectManager_private_offset;
static gpointer bluetooth_indicator_services_object_manager_parent_class = NULL;

static void bluetooth_indicator_services_object_manager_create_manager_data_free (gpointer _data);
static void bluetooth_indicator_services_object_manager_create_manager (BluetoothIndicatorServicesObjectManager* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void bluetooth_indicator_services_object_manager_create_manager_finish (BluetoothIndicatorServicesObjectManager* self,
                                                                        GAsyncResult* _res_);
static gboolean bluetooth_indicator_services_object_manager_create_manager_co (BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_);
static GType bluetooth_indicator_services_object_manager_object_manager_proxy_get_type (BluetoothIndicatorServicesObjectManager* self,
                                                                                 GDBusObjectManagerClient* manager,
                                                                                 const gchar* object_path,
                                                                                 const gchar* interface_name);
static GType _bluetooth_indicator_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                                         const gchar* object_path,
                                                                                                         const gchar* interface_name,
                                                                                                         gpointer self);
static void bluetooth_indicator_services_object_manager_create_manager_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void ___lambda4_ (BluetoothIndicatorServicesObjectManager* self,
                  GDBusObject* object);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 GDBusInterface* iface);
static void bluetooth_indicator_services_object_manager_on_interface_added (BluetoothIndicatorServicesObjectManager* self,
                                                                     GDBusObject* object,
                                                                     GDBusInterface* iface);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda4__gfunc (gconstpointer data,
                         gpointer self);
static void _bluetooth_indicator_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                                            GDBusObject* object,
                                                                                                            GDBusInterface* interface_,
                                                                                                            gpointer self);
static void bluetooth_indicator_services_object_manager_on_interface_removed (BluetoothIndicatorServicesObjectManager* self,
                                                                       GDBusObject* object,
                                                                       GDBusInterface* iface);
static void _bluetooth_indicator_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                                                GDBusObject* object,
                                                                                                                GDBusInterface* interface_,
                                                                                                                gpointer self);
static void ___lambda10_ (BluetoothIndicatorServicesObjectManager* self,
                   GDBusObject* object);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda11_ (Block2Data* _data2_,
                  GDBusInterface* iface);
static void ___lambda11__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda10__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                       GDBusObject* object,
                                                       gpointer self);
static void ___lambda12_ (BluetoothIndicatorServicesObjectManager* self,
                   GDBusObject* object);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda13_ (Block3Data* _data3_,
                  GDBusInterface* iface);
static void ___lambda13__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda12__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                         GDBusObject* object,
                                                         gpointer self);
static void ___lambda14_ (BluetoothIndicatorServicesObjectManager* self);
static void ____lambda14__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void bluetooth_indicator_services_object_manager_set_retrieve_finished (BluetoothIndicatorServicesObjectManager* self,
                                                                        gboolean value);
GType bluetooth_indicator_services_device_proxy_get_type (void);
GType bluetooth_indicator_services_adapter_proxy_get_type (void);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda6_ (Block4Data* _data4_,
                  GVariant* changed,
                  gchar** invalid);
static void bluetooth_indicator_services_object_manager_check_global_state (BluetoothIndicatorServicesObjectManager* self);
static void ____lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void bluetooth_indicator_services_object_manager_set_has_object (BluetoothIndicatorServicesObjectManager* self,
                                                                 gboolean value);
static void ____lambda9_ (BluetoothIndicatorServicesObjectManager* self,
                   GVariant* changed,
                   gchar** invalid);
static void _____lambda9__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda7_ (Block5Data* _data5_,
                 GDBusObject* object);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda8_ (Block6Data* _data6_,
                 GDBusObject* object);
static void ___lambda8__gfunc (gconstpointer data,
                        gpointer self);
static void bluetooth_indicator_services_object_manager_set_is_powered (BluetoothIndicatorServicesObjectManager* self,
                                                                 gboolean value);
static void bluetooth_indicator_services_object_manager_set_is_connected (BluetoothIndicatorServicesObjectManager* self,
                                                                   gboolean value);
static void bluetooth_indicator_services_object_manager_set_global_state_data_free (gpointer _data);
static void bluetooth_indicator_services_object_manager_set_global_state (BluetoothIndicatorServicesObjectManager* self,
                                                                   gboolean state,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static void bluetooth_indicator_services_object_manager_set_global_state_finish (BluetoothIndicatorServicesObjectManager* self,
                                                                          GAsyncResult* _res_);
static gboolean bluetooth_indicator_services_object_manager_set_global_state_co (BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_);
static void bluetooth_indicator_services_object_manager_set_global_state_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static void bluetooth_indicator_services_object_manager_set_state_from_settings_data_free (gpointer _data);
static gboolean bluetooth_indicator_services_object_manager_set_state_from_settings_co (BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_);
static void bluetooth_indicator_services_object_manager_set_state_from_settings_ready (GObject* source_object,
                                                                                GAsyncResult* _res_,
                                                                                gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static GObject * bluetooth_indicator_services_object_manager_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void bluetooth_indicator_services_object_manager_finalize (GObject * obj);
static GType bluetooth_indicator_services_object_manager_get_type_once (void);
static void _vala_bluetooth_indicator_services_object_manager_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_bluetooth_indicator_services_object_manager_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);

static inline gpointer
bluetooth_indicator_services_object_manager_get_instance_private (BluetoothIndicatorServicesObjectManager* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothIndicatorServicesObjectManager_private_offset);
}

static void
bluetooth_indicator_services_object_manager_create_manager_data_free (gpointer _data)
{
	BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorServicesObjectManagerCreateManagerData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_indicator_services_object_manager_create_manager (BluetoothIndicatorServicesObjectManager* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_;
	BluetoothIndicatorServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothIndicatorServicesObjectManagerCreateManagerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_indicator_services_object_manager_create_manager_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_indicator_services_object_manager_create_manager_co (_data_);
}

static void
bluetooth_indicator_services_object_manager_create_manager_finish (BluetoothIndicatorServicesObjectManager* self,
                                                                   GAsyncResult* _res_)
{
	BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static GType
_bluetooth_indicator_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                                   const gchar* object_path,
                                                                                                   const gchar* interface_name,
                                                                                                   gpointer self)
{
	GType result;
	result = bluetooth_indicator_services_object_manager_object_manager_proxy_get_type ((BluetoothIndicatorServicesObjectManager*) self, manager, object_path, interface_name);
	return result;
}

static void
bluetooth_indicator_services_object_manager_create_manager_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_services_object_manager_create_manager_co (_data_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->object);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda5_ (Block1Data* _data1_,
            GDBusInterface* iface)
{
	BluetoothIndicatorServicesObjectManager* self;
	self = _data1_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_indicator_services_object_manager_on_interface_added (self, _data1_->object, iface);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (GDBusInterface*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda4_ (BluetoothIndicatorServicesObjectManager* self,
             GDBusObject* object)
{
	Block1Data* _data1_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data1_->object);
	_data1_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data1_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda5__gfunc, _data1_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
____lambda4__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda4_ ((BluetoothIndicatorServicesObjectManager*) self, (GDBusObject*) data);
}

static void
_bluetooth_indicator_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                                       GDBusObject* object,
                                                                                                       GDBusInterface* interface_,
                                                                                                       gpointer self)
{
	bluetooth_indicator_services_object_manager_on_interface_added ((BluetoothIndicatorServicesObjectManager*) self, object, interface_);
}

static void
_bluetooth_indicator_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                                           GDBusObject* object,
                                                                                                           GDBusInterface* interface_,
                                                                                                           gpointer self)
{
	bluetooth_indicator_services_object_manager_on_interface_removed ((BluetoothIndicatorServicesObjectManager*) self, object, interface_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->object);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda11_ (Block2Data* _data2_,
             GDBusInterface* iface)
{
	BluetoothIndicatorServicesObjectManager* self;
	self = _data2_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_indicator_services_object_manager_on_interface_added (self, _data2_->object, iface);
}

static void
___lambda11__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda11_ (self, (GDBusInterface*) data);
}

static void
___lambda10_ (BluetoothIndicatorServicesObjectManager* self,
              GDBusObject* object)
{
	Block2Data* _data2_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data2_->object);
	_data2_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data2_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda11__gfunc, _data2_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
____lambda10__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                  GDBusObject* object,
                                                  gpointer self)
{
	___lambda10_ ((BluetoothIndicatorServicesObjectManager*) self, object);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->object);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda13_ (Block3Data* _data3_,
             GDBusInterface* iface)
{
	BluetoothIndicatorServicesObjectManager* self;
	self = _data3_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_indicator_services_object_manager_on_interface_removed (self, _data3_->object, iface);
}

static void
___lambda13__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda13_ (self, (GDBusInterface*) data);
}

static void
___lambda12_ (BluetoothIndicatorServicesObjectManager* self,
              GDBusObject* object)
{
	Block3Data* _data3_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data3_->object);
	_data3_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data3_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda13__gfunc, _data3_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
____lambda12__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                    GDBusObject* object,
                                                    gpointer self)
{
	___lambda12_ ((BluetoothIndicatorServicesObjectManager*) self, object);
}

static void
___lambda14_ (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = self->priv->_settings;
	enabled = g_settings_get_boolean (_tmp0_, "bluetooth-enabled");
	_tmp1_ = self->priv->_is_powered;
	if (enabled != _tmp1_) {
		bluetooth_indicator_services_object_manager_set_state_from_settings (self, NULL, NULL);
	}
}

static void
____lambda14__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda14_ ((BluetoothIndicatorServicesObjectManager*) self);
}

static gboolean
bluetooth_indicator_services_object_manager_create_manager_co (BluetoothIndicatorServicesObjectManagerCreateManagerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.bluez", "/", _bluetooth_indicator_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, NULL, bluetooth_indicator_services_object_manager_create_manager_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->object_manager);
		_data_->self->priv->object_manager = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->object_manager;
		_data_->_tmp4_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		g_list_foreach (_data_->_tmp5_, ____lambda4__gfunc, _data_->self);
		(_data_->_tmp5_ == NULL) ? NULL : (_data_->_tmp5_ = (_g_list_free__g_object_unref0_ (_data_->_tmp5_), NULL));
		_data_->_tmp6_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp6_, "interface-added", (GCallback) _bluetooth_indicator_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added, _data_->self, 0);
		_data_->_tmp7_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp7_, "interface-removed", (GCallback) _bluetooth_indicator_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp8_, "object-added", (GCallback) ____lambda10__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->_tmp9_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp9_, "object-removed", (GCallback) ____lambda12__g_dbus_object_manager_object_removed, _data_->self, 0);
		_data_->_tmp10_ = _data_->self->priv->_settings;
		g_signal_connect_object (_data_->_tmp10_, "changed::bluetooth-enabled", (GCallback) ____lambda14__g_settings_changed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("Manager.vala:64: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	bluetooth_indicator_services_object_manager_set_retrieve_finished (_data_->self, TRUE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GType
bluetooth_indicator_services_object_manager_object_manager_proxy_get_type (BluetoothIndicatorServicesObjectManager* self,
                                                                           GDBusObjectManagerClient* manager,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (object_path != NULL, 0UL);
	if (interface_name == NULL) {
		result = g_dbus_object_proxy_get_type ();
		return result;
	}
	_tmp0_ = interface_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("org.bluez.Device1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_indicator_services_device_proxy_get_type ();
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("org.bluez.Adapter1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_indicator_services_adapter_proxy_get_type ();
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = g_dbus_proxy_get_type ();
				return result;
			}
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda6_ (Block4Data* _data4_,
             GVariant* changed,
             gchar** invalid)
{
	BluetoothIndicatorServicesObjectManager* self;
	GVariant* connected = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* paired = NULL;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	gboolean _tmp14_ = FALSE;
	GVariant* _tmp15_;
	self = _data4_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Connected", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	connected = _tmp3_;
	_tmp4_ = g_variant_type_new ("b");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_lookup_value (changed, "Paired", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_type_free0 (_tmp5_);
	paired = _tmp7_;
	_tmp8_ = paired;
	if (_tmp8_ != NULL) {
		BluetoothIndicatorServicesDevice* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = _data4_->device;
		_tmp10_ = bluetooth_indicator_services_device_get_paired (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			BluetoothIndicatorServicesDevice* _tmp12_;
			_tmp12_ = _data4_->device;
			g_signal_emit (self, bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL], 0, _tmp12_);
		} else {
			BluetoothIndicatorServicesDevice* _tmp13_;
			_tmp13_ = _data4_->device;
			g_signal_emit (self, bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL], 0, _tmp13_);
		}
	}
	_tmp15_ = connected;
	if (_tmp15_ != NULL) {
		_tmp14_ = TRUE;
	} else {
		GVariant* _tmp16_;
		_tmp16_ = paired;
		_tmp14_ = _tmp16_ != NULL;
	}
	if (_tmp14_) {
		bluetooth_indicator_services_object_manager_check_global_state (self);
	}
	_g_variant_unref0 (paired);
	_g_variant_unref0 (connected);
}

static void
____lambda6__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	___lambda6_ (self, changed_properties, invalidated_properties);
}

static void
____lambda9_ (BluetoothIndicatorServicesObjectManager* self,
              GVariant* changed,
              gchar** invalid)
{
	GVariant* powered = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Powered", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	powered = _tmp3_;
	_tmp4_ = powered;
	if (_tmp4_ != NULL) {
		bluetooth_indicator_services_object_manager_check_global_state (self);
	}
	_g_variant_unref0 (powered);
}

static void
_____lambda9__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	____lambda9_ ((BluetoothIndicatorServicesObjectManager*) self, changed_properties, invalidated_properties);
}

static void
bluetooth_indicator_services_object_manager_on_interface_added (BluetoothIndicatorServicesObjectManager* self,
                                                                GDBusObject* object,
                                                                GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_INDICATOR_SERVICES_IS_DEVICE (iface)) {
		Block4Data* _data4_;
		BluetoothIndicatorServicesDevice* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		BluetoothIndicatorServicesDevice* _tmp4_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_data4_->device = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE, BluetoothIndicatorServicesDevice);
		_tmp0_ = _data4_->device;
		_tmp1_ = bluetooth_indicator_services_device_get_paired (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			BluetoothIndicatorServicesDevice* _tmp3_;
			_tmp3_ = _data4_->device;
			g_signal_emit (self, bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL], 0, _tmp3_);
		}
		_tmp4_ = _data4_->device;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda6__g_dbus_proxy_g_properties_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		bluetooth_indicator_services_object_manager_check_global_state (self);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	} else {
		if (BLUETOOTH_INDICATOR_SERVICES_IS_ADAPTER (iface)) {
			BluetoothIndicatorServicesAdapter* adapter = NULL;
			BluetoothIndicatorServicesAdapter* _tmp5_;
			adapter = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_INDICATOR_SERVICES_TYPE_ADAPTER, BluetoothIndicatorServicesAdapter);
			bluetooth_indicator_services_object_manager_set_has_object (self, TRUE);
			_tmp5_ = adapter;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _____lambda9__g_dbus_proxy_g_properties_changed, self, 0);
			bluetooth_indicator_services_object_manager_check_global_state (self);
		}
	}
}

static void
bluetooth_indicator_services_object_manager_on_interface_removed (BluetoothIndicatorServicesObjectManager* self,
                                                                  GDBusObject* object,
                                                                  GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_INDICATOR_SERVICES_IS_DEVICE (iface)) {
		g_signal_emit (self, bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE, BluetoothIndicatorServicesDevice));
	} else {
		if (BLUETOOTH_INDICATOR_SERVICES_IS_ADAPTER (iface)) {
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp0_ = bluetooth_indicator_services_object_manager_get_adapters (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			bluetooth_indicator_services_object_manager_set_has_object (self, !_tmp3_);
			_g_object_unref0 (_tmp1_);
		}
	}
	bluetooth_indicator_services_object_manager_check_global_state (self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->adapters);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda7_ (Block5Data* _data5_,
            GDBusObject* object)
{
	BluetoothIndicatorServicesObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data5_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Adapter1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data5_->adapters;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_INDICATOR_SERVICES_TYPE_ADAPTER, BluetoothIndicatorServicesAdapter));
	_g_object_unref0 (iface);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ (self, (GDBusObject*) data);
}

GeeLinkedList*
bluetooth_indicator_services_object_manager_get_adapters (BluetoothIndicatorServicesObjectManager* self)
{
	Block5Data* _data5_;
	GeeLinkedList* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (BLUETOOTH_INDICATOR_SERVICES_TYPE_ADAPTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data5_->adapters = _tmp0_;
	_tmp1_ = self->priv->object_manager;
	_tmp2_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda7__gfunc, _data5_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
	_tmp4_ = _data5_->adapters;
	_data5_->adapters = NULL;
	result = _tmp4_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BluetoothIndicatorServicesObjectManager* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->devices);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda8_ (Block6Data* _data6_,
            GDBusObject* object)
{
	BluetoothIndicatorServicesObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data6_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Device1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data6_->devices;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE, BluetoothIndicatorServicesDevice));
	_g_object_unref0 (iface);
}

static void
___lambda8__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda8_ (self, (GDBusObject*) data);
}

GeeCollection*
bluetooth_indicator_services_object_manager_get_devices (BluetoothIndicatorServicesObjectManager* self)
{
	Block6Data* _data6_;
	GeeLinkedList* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data6_->devices = _tmp0_;
	_tmp1_ = self->priv->object_manager;
	_tmp2_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda8__gfunc, _data6_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
	_tmp4_ = _data6_->devices;
	_data6_->devices = NULL;
	result = (GeeCollection*) _tmp4_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

static void
bluetooth_indicator_services_object_manager_check_global_state (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean powered = FALSE;
	gboolean connected = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	powered = bluetooth_indicator_services_object_manager_get_global_state (self);
	connected = bluetooth_indicator_services_object_manager_get_connected (self);
	_tmp1_ = self->priv->_is_powered;
	if (powered != _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_connected;
		_tmp0_ = connected != _tmp2_;
	}
	if (_tmp0_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->_is_powered;
		if (powered != _tmp3_) {
			bluetooth_indicator_services_object_manager_set_is_powered (self, powered);
		}
		_tmp4_ = self->priv->_is_connected;
		if (connected != _tmp4_) {
			bluetooth_indicator_services_object_manager_set_is_connected (self, connected);
		}
		_tmp5_ = self->priv->_is_powered;
		_tmp6_ = self->priv->_is_connected;
		g_signal_emit (self, bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_GLOBAL_STATE_CHANGED_SIGNAL], 0, _tmp5_, _tmp6_);
	}
}

gboolean
bluetooth_indicator_services_object_manager_get_connected (BluetoothIndicatorServicesObjectManager* self)
{
	GeeCollection* devices = NULL;
	GeeCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bluetooth_indicator_services_object_manager_get_devices (self);
	devices = _tmp0_;
	{
		GeeIterator* _device_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = devices;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_device_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			BluetoothIndicatorServicesDevice* device = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			BluetoothIndicatorServicesDevice* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = _device_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _device_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			device = (BluetoothIndicatorServicesDevice*) _tmp5_;
			_tmp6_ = device;
			_tmp7_ = bluetooth_indicator_services_device_get_connected (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (device);
				_g_object_unref0 (_device_it);
				_g_object_unref0 (devices);
				return result;
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	result = FALSE;
	_g_object_unref0 (devices);
	return result;
}

gboolean
bluetooth_indicator_services_object_manager_get_global_state (BluetoothIndicatorServicesObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bluetooth_indicator_services_object_manager_get_adapters (self);
	adapters = _tmp0_;
	{
		GeeLinkedList* _adapter_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _adapter_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _adapter_index = 0;
		_tmp1_ = adapters;
		_adapter_list = _tmp1_;
		_tmp2_ = _adapter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_adapter_size = _tmp4_;
		_adapter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BluetoothIndicatorServicesAdapter* adapter = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			BluetoothIndicatorServicesAdapter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_adapter_index = _adapter_index + 1;
			_tmp5_ = _adapter_index;
			_tmp6_ = _adapter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _adapter_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _adapter_index);
			adapter = (BluetoothIndicatorServicesAdapter*) _tmp8_;
			_tmp9_ = adapter;
			_tmp10_ = bluetooth_indicator_services_adapter_get_powered (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				result = TRUE;
				_g_object_unref0 (adapter);
				_g_object_unref0 (adapters);
				return result;
			}
			_g_object_unref0 (adapter);
		}
	}
	result = FALSE;
	_g_object_unref0 (adapters);
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_global_state_data_free (gpointer _data)
{
	BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorServicesObjectManagerSetGlobalStateData, _data_);
}

static void
bluetooth_indicator_services_object_manager_set_global_state (BluetoothIndicatorServicesObjectManager* self,
                                                              gboolean state,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_;
	BluetoothIndicatorServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothIndicatorServicesObjectManagerSetGlobalStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_indicator_services_object_manager_set_global_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->state = state;
	bluetooth_indicator_services_object_manager_set_global_state_co (_data_);
}

static void
bluetooth_indicator_services_object_manager_set_global_state_finish (BluetoothIndicatorServicesObjectManager* self,
                                                                     GAsyncResult* _res_)
{
	BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_indicator_services_object_manager_set_global_state_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_services_object_manager_set_global_state_co (_data_);
}

static gboolean
bluetooth_indicator_services_object_manager_set_global_state_co (BluetoothIndicatorServicesObjectManagerSetGlobalStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = bluetooth_indicator_services_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_adapter_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_adapter_size = _data_->_tmp4_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp5_ = _data_->_adapter_index;
			_data_->_tmp6_ = _data_->_adapter_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_adapter_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_adapter_index);
			_data_->adapter = (BluetoothIndicatorServicesAdapter*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->adapter;
			bluetooth_indicator_services_adapter_set_powered (_data_->_tmp9_, _data_->state);
			_g_object_unref0 (_data_->adapter);
		}
	}
	if (_data_->state == FALSE) {
		_data_->_tmp10_ = bluetooth_indicator_services_object_manager_get_devices (_data_->self);
		_data_->devices = _data_->_tmp10_;
		{
			_data_->_tmp11_ = _data_->devices;
			_data_->_tmp12_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp11_);
			_data_->_device_it = _data_->_tmp12_;
			while (TRUE) {
				_data_->_tmp13_ = _data_->_device_it;
				if (!gee_iterator_next (_data_->_tmp13_)) {
					break;
				}
				_data_->_tmp14_ = _data_->_device_it;
				_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
				_data_->device = (BluetoothIndicatorServicesDevice*) _data_->_tmp15_;
				_data_->_tmp16_ = _data_->device;
				_data_->_tmp17_ = bluetooth_indicator_services_device_get_connected (_data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				if (_data_->_tmp18_) {
					{
						_data_->_tmp19_ = _data_->device;
						_data_->_state_ = 1;
						bluetooth_indicator_services_device_disconnect (_data_->_tmp19_, bluetooth_indicator_services_object_manager_set_global_state_ready, _data_);
						return FALSE;
						_state_1:
						bluetooth_indicator_services_device_disconnect_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp20_ = _data_->e;
						_data_->_tmp21_ = _data_->_tmp20_->message;
						g_critical ("Manager.vala:222: %s", _data_->_tmp21_);
						_g_error_free0 (_data_->e);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->device);
						_g_object_unref0 (_data_->_device_it);
						_g_object_unref0 (_data_->devices);
						_g_object_unref0 (_data_->adapters);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->device);
			}
			_g_object_unref0 (_data_->_device_it);
		}
		_g_object_unref0 (_data_->devices);
	}
	bluetooth_indicator_services_object_manager_check_global_state (_data_->self);
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_indicator_services_object_manager_set_state_from_settings_data_free (gpointer _data)
{
	BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData, _data_);
}

void
bluetooth_indicator_services_object_manager_set_state_from_settings (BluetoothIndicatorServicesObjectManager* self,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_;
	BluetoothIndicatorServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_indicator_services_object_manager_set_state_from_settings_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_indicator_services_object_manager_set_state_from_settings_co (_data_);
}

void
bluetooth_indicator_services_object_manager_set_state_from_settings_finish (BluetoothIndicatorServicesObjectManager* self,
                                                                            GAsyncResult* _res_)
{
	BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_indicator_services_object_manager_set_state_from_settings_ready (GObject* source_object,
                                                                           GAsyncResult* _res_,
                                                                           gpointer _user_data_)
{
	BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_services_object_manager_set_state_from_settings_co (_data_);
}

static gboolean
bluetooth_indicator_services_object_manager_set_state_from_settings_co (BluetoothIndicatorServicesObjectManagerSetStateFromSettingsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_settings;
	_data_->_state_ = 1;
	bluetooth_indicator_services_object_manager_set_global_state (_data_->self, g_settings_get_boolean (_data_->_tmp0_, "bluetooth-enabled"), bluetooth_indicator_services_object_manager_set_state_from_settings_ready, _data_);
	return FALSE;
	_state_1:
	bluetooth_indicator_services_object_manager_set_global_state_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
bluetooth_indicator_services_object_manager_compare_devices (BluetoothIndicatorServicesDevice* device,
                                                             BluetoothIndicatorServicesDevice* other)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (device != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = bluetooth_indicator_services_device_get_modalias (device);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = bluetooth_indicator_services_device_get_modalias (other);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp2_, _tmp5_) == 0;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

BluetoothIndicatorServicesObjectManager*
bluetooth_indicator_services_object_manager_construct (GType object_type)
{
	BluetoothIndicatorServicesObjectManager * self = NULL;
	self = (BluetoothIndicatorServicesObjectManager*) g_object_new (object_type, NULL);
	return self;
}

BluetoothIndicatorServicesObjectManager*
bluetooth_indicator_services_object_manager_new (void)
{
	return bluetooth_indicator_services_object_manager_construct (BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER);
}

gboolean
bluetooth_indicator_services_object_manager_get_has_object (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_object;
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_has_object (BluetoothIndicatorServicesObjectManager* self,
                                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_services_object_manager_get_has_object (self);
	if (old_value != value) {
		self->priv->_has_object = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY]);
	}
}

gboolean
bluetooth_indicator_services_object_manager_get_retrieve_finished (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_retrieve_finished;
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_retrieve_finished (BluetoothIndicatorServicesObjectManager* self,
                                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_services_object_manager_get_retrieve_finished (self);
	if (old_value != value) {
		self->priv->_retrieve_finished = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY]);
	}
}

GSettings*
bluetooth_indicator_services_object_manager_get_settings (BluetoothIndicatorServicesObjectManager* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_settings (BluetoothIndicatorServicesObjectManager* self,
                                                          GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_services_object_manager_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY]);
	}
}

gboolean
bluetooth_indicator_services_object_manager_get_is_powered (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_powered;
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_is_powered (BluetoothIndicatorServicesObjectManager* self,
                                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_services_object_manager_get_is_powered (self);
	if (old_value != value) {
		self->priv->_is_powered = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY]);
	}
}

gboolean
bluetooth_indicator_services_object_manager_get_is_connected (BluetoothIndicatorServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_connected;
	return result;
}

static void
bluetooth_indicator_services_object_manager_set_is_connected (BluetoothIndicatorServicesObjectManager* self,
                                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_services_object_manager_get_is_connected (self);
	if (old_value != value) {
		self->priv->_is_connected = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static GObject *
bluetooth_indicator_services_object_manager_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothIndicatorServicesObjectManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	parent_class = G_OBJECT_CLASS (bluetooth_indicator_services_object_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, BluetoothIndicatorServicesObjectManager);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wingpanel.bluetooth");
	_tmp1_ = _tmp0_;
	bluetooth_indicator_services_object_manager_set_settings (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	bluetooth_indicator_services_object_manager_create_manager (self, NULL, NULL);
	return obj;
}

static void
bluetooth_indicator_services_object_manager_class_init (BluetoothIndicatorServicesObjectManagerClass * klass,
                                                        gpointer klass_data)
{
	bluetooth_indicator_services_object_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothIndicatorServicesObjectManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_indicator_services_object_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_indicator_services_object_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_indicator_services_object_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_services_object_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY] = g_param_spec_boolean ("has-object", "has-object", "has-object", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY] = g_param_spec_boolean ("retrieve-finished", "retrieve-finished", "retrieve-finished", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY] = g_param_spec_boolean ("is-powered", "is-powered", "is-powered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY, bluetooth_indicator_services_object_manager_properties[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_GLOBAL_STATE_CHANGED_SIGNAL] = g_signal_new ("global-state-changed", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE);
	bluetooth_indicator_services_object_manager_signals[BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL] = g_signal_new ("device-removed", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE);
}

static void
bluetooth_indicator_services_object_manager_instance_init (BluetoothIndicatorServicesObjectManager * self,
                                                           gpointer klass)
{
	self->priv = bluetooth_indicator_services_object_manager_get_instance_private (self);
	self->priv->_has_object = FALSE;
	self->priv->_retrieve_finished = FALSE;
	self->priv->_is_powered = FALSE;
	self->priv->_is_connected = FALSE;
}

static void
bluetooth_indicator_services_object_manager_finalize (GObject * obj)
{
	BluetoothIndicatorServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, BluetoothIndicatorServicesObjectManager);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->object_manager);
	G_OBJECT_CLASS (bluetooth_indicator_services_object_manager_parent_class)->finalize (obj);
}

static GType
bluetooth_indicator_services_object_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorServicesObjectManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_services_object_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicatorServicesObjectManager), 0, (GInstanceInitFunc) bluetooth_indicator_services_object_manager_instance_init, NULL };
	GType bluetooth_indicator_services_object_manager_type_id;
	bluetooth_indicator_services_object_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BluetoothIndicatorServicesObjectManager", &g_define_type_info, 0);
	BluetoothIndicatorServicesObjectManager_private_offset = g_type_add_instance_private (bluetooth_indicator_services_object_manager_type_id, sizeof (BluetoothIndicatorServicesObjectManagerPrivate));
	return bluetooth_indicator_services_object_manager_type_id;
}

GType
bluetooth_indicator_services_object_manager_get_type (void)
{
	static volatile gsize bluetooth_indicator_services_object_manager_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_indicator_services_object_manager_type_id__once)) {
		GType bluetooth_indicator_services_object_manager_type_id;
		bluetooth_indicator_services_object_manager_type_id = bluetooth_indicator_services_object_manager_get_type_once ();
		g_once_init_leave (&bluetooth_indicator_services_object_manager_type_id__once, bluetooth_indicator_services_object_manager_type_id);
	}
	return bluetooth_indicator_services_object_manager_type_id__once;
}

static void
_vala_bluetooth_indicator_services_object_manager_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	BluetoothIndicatorServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, BluetoothIndicatorServicesObjectManager);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		g_value_set_boolean (value, bluetooth_indicator_services_object_manager_get_has_object (self));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY:
		g_value_set_boolean (value, bluetooth_indicator_services_object_manager_get_retrieve_finished (self));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY:
		g_value_set_object (value, bluetooth_indicator_services_object_manager_get_settings (self));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY:
		g_value_set_boolean (value, bluetooth_indicator_services_object_manager_get_is_powered (self));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, bluetooth_indicator_services_object_manager_get_is_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_indicator_services_object_manager_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	BluetoothIndicatorServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, BluetoothIndicatorServicesObjectManager);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		bluetooth_indicator_services_object_manager_set_has_object (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY:
		bluetooth_indicator_services_object_manager_set_retrieve_finished (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_SETTINGS_PROPERTY:
		bluetooth_indicator_services_object_manager_set_settings (self, g_value_get_object (value));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY:
		bluetooth_indicator_services_object_manager_set_is_powered (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_INDICATOR_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY:
		bluetooth_indicator_services_object_manager_set_is_connected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

