/* WifiInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from WifiInterface.vala, do not modify */

/*
* Copyright 2015-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "network.h"
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <polkit/polkit.h>
#include <glib-object.h>
#include <unistd.h>
#include <nma-wifi-dialog.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIFI_INTERFACE_0_PROPERTY,
	NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY,
	NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY,
	NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY,
	NETWORK_WIFI_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _rf_kill_device_unref0(var) ((var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _NetworkWifiInterfaceConnectToNetworkData NetworkWifiInterfaceConnectToNetworkData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL (network_wifi_interface_placeholder_label_get_type ())
#define NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL, NetworkWifiInterfacePlaceholderLabel))
#define NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL, NetworkWifiInterfacePlaceholderLabelClass))
#define NETWORK_WIFI_INTERFACE_IS_PLACEHOLDER_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL))
#define NETWORK_WIFI_INTERFACE_IS_PLACEHOLDER_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL))
#define NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL, NetworkWifiInterfacePlaceholderLabelClass))

typedef struct _NetworkWifiInterfacePlaceholderLabel NetworkWifiInterfacePlaceholderLabel;
typedef struct _NetworkWifiInterfacePlaceholderLabelClass NetworkWifiInterfacePlaceholderLabelClass;
typedef struct _NetworkWifiInterfacePlaceholderLabelPrivate NetworkWifiInterfacePlaceholderLabelPrivate;
enum  {
	NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL_0_PROPERTY,
	NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL_NUM_PROPERTIES
};
static GParamSpec* network_wifi_interface_placeholder_label_properties[NETWORK_WIFI_INTERFACE_PLACEHOLDER_LABEL_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetworkWifiInterfacePrivate {
	NMClient* _nm_client;
	gboolean _hidden_sensitivity;
	gchar* _active_ap_name;
	GraniteSwitchModelButton* wifi_item;
	GtkRevealer* revealer;
	RFKillManager* rfkill;
	NMAccessPoint* active_ap;
	GtkListBox* wifi_list;
	NetworkWifiMenuItem* active_wifi_item;
	GtkRadioButton* blank_item;
	GtkStack* placeholder;
	gboolean locked;
	gboolean software_locked;
	gboolean hardware_locked;
	guint timeout_scan;
	GCancellable* wifi_scan_cancellable;
};

struct _Block7Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMAWifiDialog* wifi_dialog;
};

struct _Block8Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMAWifiDialog* hidden_dialog;
};

struct _Block9Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMConnection* fuzzy;
	NMConnection* dialog_connection;
	gpointer _async_data_;
};

struct _NetworkWifiInterfaceConnectToNetworkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkWifiInterface* self;
	NMAWifiDialog* wifi_dialog;
	Block9Data* _data9_;
	NMDevice* dialog_device;
	NMAccessPoint* dialog_ap;
	NMDevice* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMConnection* _tmp2_;
	NMClient* _tmp3_;
	GPtrArray* _tmp4_;
	gchar* path;
	NMAccessPoint* _tmp5_;
	NMAccessPoint* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	NMConnection* _tmp9_;
	NMClient* _tmp10_;
	NMConnection* _tmp11_;
	NMDeviceWifi* _tmp12_;
	const gchar* _tmp13_;
	NMActiveConnection* _tmp14_;
	NMActiveConnection* _tmp15_;
	GError* _error_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	gchar* mode;
	NMSettingWireless* setting_wireless;
	NMConnection* _tmp18_;
	NMSettingWireless* _tmp19_;
	NMSettingWireless* _tmp20_;
	NMSettingWireless* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	NMSettingConnection* connection_setting;
	NMConnection* _tmp25_;
	NMSettingConnection* _tmp26_;
	NMSettingConnection* _tmp27_;
	NMSettingConnection* _tmp28_;
	NMSettingConnection* _tmp29_;
	NMConnection* _tmp30_;
	NMSettingConnection* _tmp31_;
	NMSetting* _tmp32_;
	NMClient* _tmp33_;
	NMConnection* _tmp34_;
	NMDevice* _tmp35_;
	const gchar* _tmp36_;
	NMActiveConnection* _tmp37_;
	NMActiveConnection* _tmp38_;
	GError* _vala1__error_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _NetworkWifiInterfacePlaceholderLabel {
	GtkLabel parent_instance;
	NetworkWifiInterfacePlaceholderLabelPrivate * priv;
};

struct _NetworkWifiInterfacePlaceholderLabelClass {
	GtkLabelClass parent_class;
};

static gint NetworkWifiInterface_private_offset;
static gpointer network_wifi_interface_parent_class = NULL;
static PolkitPermission* network_wifi_interface_permission;
static PolkitPermission* network_wifi_interface_permission = NULL;
static gpointer network_wifi_interface_placeholder_label_parent_class = NULL;

static void network_wifi_interface_update (NetworkWifiInterface* self);
static void _network_wifi_interface_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                                  RFKillDevice* device,
                                                                  gpointer self);
static void _network_wifi_interface_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                                    RFKillDevice* device,
                                                                    gpointer self);
static void _network_wifi_interface_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                                    RFKillDevice* device,
                                                                    gpointer self);
static void _network_wifi_interface_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void network_wifi_interface_access_point_added_cb (NetworkWifiInterface* self,
                                                   GObject* ap_);
static void _network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                      GObject* ap,
                                                                                      gpointer self);
static void network_wifi_interface_access_point_removed_cb (NetworkWifiInterface* self,
                                                     GObject* ap_);
static void _network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                          GObject* ap,
                                                                                          gpointer self);
static void _network_wifi_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                             guint new_state,
                                                             guint old_state,
                                                             guint reason,
                                                             gpointer self);
static void _network_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                          gpointer self);
static void network_wifi_interface_cancel_scan (NetworkWifiInterface* self);
static void network_wifi_interface_set_scan_placeholder (NetworkWifiInterface* self);
static NetworkState network_wifi_interface_strength_to_state (NetworkWifiInterface* self,
                                                       guint8 strength);
static void _rf_kill_device_unref0_ (gpointer var);
static inline void _g_list_free__rf_kill_device_unref0_ (GList* self);
static void network_wifi_interface_update_active_ap (NetworkWifiInterface* self);
static void network_wifi_interface_wifi_activate_cb (NetworkWifiInterface* self,
                                              NetworkWifiMenuItem* i);
static NMConnection* network_wifi_interface_get_valid_connection (NetworkWifiInterface* self,
                                                           NMAccessPoint* ap,
                                                           GPtrArray* ap_connections);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda14_ (Block7Data* _data7_,
                   gint response);
static void network_wifi_interface_connect_to_network (NetworkWifiInterface* self,
                                                NMAWifiDialog* wifi_dialog,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void network_wifi_interface_connect_to_network_finish (NetworkWifiInterface* self,
                                                       GAsyncResult* _res_);
static void ____lambda14__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void ___lambda16_ (NetworkWifiInterface* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda16__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __lambda17_ (NetworkWifiInterface* self);
static gboolean ___lambda17__gsource_func (gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda18_ (Block8Data* _data8_,
                  gint response);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void network_wifi_interface_connect_to_network_data_free (gpointer _data);
static gboolean network_wifi_interface_connect_to_network_co (NetworkWifiInterfaceConnectToNetworkData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda15_ (Block9Data* _data9_,
                  NMRemoteConnection* possible);
static void ___lambda15__gfunc (gconstpointer data,
                         gpointer self);
static void network_wifi_interface_connect_to_network_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void network_wifi_interface_set_active_ap_name (NetworkWifiInterface* self,
                                                const gchar* value);
static gboolean ___lambda13_ (NetworkWifiInterface* self);
static gboolean ____lambda13__gsource_func (gpointer self);
static gint network_wifi_interface_sort_func (NetworkWifiInterface* self,
                                       GtkListBoxRow* r1,
                                       GtkListBoxRow* r2);
static GType network_wifi_interface_placeholder_label_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NetworkWifiInterfacePlaceholderLabel* network_wifi_interface_placeholder_label_new (const gchar* label);
static NetworkWifiInterfacePlaceholderLabel* network_wifi_interface_placeholder_label_construct (GType object_type,
                                                                                          const gchar* label);
static GObject * network_wifi_interface_placeholder_label_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static GType network_wifi_interface_placeholder_label_get_type_once (void);
static GObject * network_wifi_interface_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gint _network_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                               GtkListBoxRow* row2,
                                                               gpointer self);
static void _network_wifi_interface___lambda19_ (NetworkWifiInterface* self,
                                          GtkListBoxRow* row);
static void __network_wifi_interface___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self);
static void _network_wifi_interface___lambda20_ (NetworkWifiInterface* self);
static GVariant* _variant_new1 (gboolean value);
static void ___lambda21_ (NetworkWifiInterface* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda21__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __network_wifi_interface___lambda20__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void network_wifi_interface_finalize (GObject * obj);
static GType network_wifi_interface_get_type_once (void);
static void _vala_network_wifi_interface_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_interface_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_interface_get_instance_private (NetworkWifiInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_network_wifi_interface_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                             RFKillDevice* device,
                                                             gpointer self)
{
	network_wifi_interface_update ((NetworkWifiInterface*) self);
}

static void
_network_wifi_interface_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                               RFKillDevice* device,
                                                               gpointer self)
{
	network_wifi_interface_update ((NetworkWifiInterface*) self);
}

static void
_network_wifi_interface_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                               RFKillDevice* device,
                                                               gpointer self)
{
	network_wifi_interface_update ((NetworkWifiInterface*) self);
}

static void
_network_wifi_interface_update_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	network_wifi_interface_update ((NetworkWifiInterface*) self);
}

static void
_network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                 GObject* ap,
                                                                                 gpointer self)
{
	network_wifi_interface_access_point_added_cb ((NetworkWifiInterface*) self, ap);
}

static void
_network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                     GObject* ap,
                                                                                     gpointer self)
{
	network_wifi_interface_access_point_removed_cb ((NetworkWifiInterface*) self, ap);
}

static void
_network_wifi_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                        guint new_state,
                                                        guint old_state,
                                                        guint reason,
                                                        gpointer self)
{
	network_wifi_interface_update ((NetworkWifiInterface*) self);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_network_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                     gpointer self)
{
	network_wifi_interface_access_point_added_cb ((NetworkWifiInterface*) self, (GObject*) data);
}

NetworkWifiInterface*
network_wifi_interface_construct (GType object_type,
                                  NMClient* nm_client,
                                  NMDevice* _device)
{
	NetworkWifiInterface * self = NULL;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceWifi* _tmp2_;
	GtkRadioButton* _tmp3_;
	RFKillManager* _tmp4_;
	RFKillManager* _tmp5_;
	RFKillManager* _tmp6_;
	RFKillManager* _tmp7_;
	RFKillManager* _tmp8_;
	NMDeviceWifi* _tmp9_;
	NMDeviceWifi* _tmp10_;
	NMDeviceWifi* _tmp11_;
	NMDeviceWifi* _tmp12_;
	GPtrArray* aps = NULL;
	NMDeviceWifi* _tmp13_;
	GPtrArray* _tmp14_;
	GPtrArray* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GPtrArray* _tmp17_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	self = (NetworkWifiInterface*) g_object_new (object_type, "nm-client", nm_client, NULL);
	network_widget_nm_interface_set_device ((NetworkWidgetNMInterface*) self, _device);
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, nm_device_wifi_get_type (), NMDeviceWifi));
	_g_object_unref0 (self->wifi_device);
	self->wifi_device = _tmp2_;
	_tmp3_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->blank_item);
	self->priv->blank_item = _tmp3_;
	_g_object_unref0 (self->priv->active_wifi_item);
	self->priv->active_wifi_item = NULL;
	_tmp4_ = rf_kill_manager_new ();
	_g_object_unref0 (self->priv->rfkill);
	self->priv->rfkill = _tmp4_;
	_tmp5_ = self->priv->rfkill;
	rf_kill_manager_open (_tmp5_);
	_tmp6_ = self->priv->rfkill;
	g_signal_connect_object (_tmp6_, "device-added", (GCallback) _network_wifi_interface_update_rf_kill_manager_device_added, self, 0);
	_tmp7_ = self->priv->rfkill;
	g_signal_connect_object (_tmp7_, "device-changed", (GCallback) _network_wifi_interface_update_rf_kill_manager_device_changed, self, 0);
	_tmp8_ = self->priv->rfkill;
	g_signal_connect_object (_tmp8_, "device-deleted", (GCallback) _network_wifi_interface_update_rf_kill_manager_device_deleted, self, 0);
	_tmp9_ = self->wifi_device;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::active-access-point", (GCallback) _network_wifi_interface_update_g_object_notify, self, 0);
	_tmp10_ = self->wifi_device;
	g_signal_connect_object (_tmp10_, "access-point-added", (GCallback) _network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added, self, 0);
	_tmp11_ = self->wifi_device;
	g_signal_connect_object (_tmp11_, "access-point-removed", (GCallback) _network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed, self, 0);
	_tmp12_ = self->wifi_device;
	g_signal_connect_object ((NMDevice*) _tmp12_, "state-changed", (GCallback) _network_wifi_interface_update_nm_device_state_changed, self, 0);
	_tmp13_ = self->wifi_device;
	_tmp14_ = nm_device_wifi_get_access_points (_tmp13_);
	_tmp15_ = _g_ptr_array_ref0 (_tmp14_);
	aps = _tmp15_;
	_tmp17_ = aps;
	if (_tmp17_ != NULL) {
		GPtrArray* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = aps;
		_tmp19_ = vala_g_ptr_array_get_length (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GPtrArray* _tmp21_;
		_tmp21_ = aps;
		g_ptr_array_foreach (_tmp21_, _network_wifi_interface_access_point_added_cb_gfunc, self);
	}
	network_wifi_interface_update (self);
	_g_ptr_array_unref0 (aps);
	return self;
}

NetworkWifiInterface*
network_wifi_interface_new (NMClient* nm_client,
                            NMDevice* _device)
{
	return network_wifi_interface_construct (NETWORK_TYPE_WIFI_INTERFACE, nm_client, _device);
}

static gpointer
_rf_kill_device_ref0 (gpointer self)
{
	return self ? rf_kill_device_ref (self) : NULL;
}

static void
_rf_kill_device_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL));
}

static inline void
_g_list_free__rf_kill_device_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rf_kill_device_unref0_);
}

static void
network_wifi_interface_update (NetworkWifiInterface* self)
{
	NMDeviceWifi* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	NetworkState _tmp10_;
	NetworkState _tmp11_;
	GEnumValue* _tmp12_;
	RFKillManager* _tmp13_;
	GList* _tmp14_;
	gboolean _tmp25_ = FALSE;
	GraniteSwitchModelButton* _tmp26_;
	GraniteSwitchModelButton* _tmp27_;
	NMDeviceWifi* _tmp28_;
	NMAccessPoint* _tmp29_;
	NMAccessPoint* _tmp30_;
	gboolean _tmp31_ = FALSE;
	NMDeviceWifi* _tmp32_;
	NMDeviceState _tmp33_;
	NMDeviceState _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->wifi_device;
	_tmp1_ = nm_device_get_state ((NMDevice*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_FAILED:
		{
			NetworkWifiMenuItem* _tmp3_;
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_WIFI);
			_tmp3_ = self->priv->active_wifi_item;
			if (_tmp3_ != NULL) {
				NetworkWifiMenuItem* _tmp4_;
				NMDeviceWifi* _tmp5_;
				NMDeviceState _tmp6_;
				NMDeviceState _tmp7_;
				_tmp4_ = self->priv->active_wifi_item;
				_tmp5_ = self->wifi_device;
				_tmp6_ = nm_device_get_state ((NMDevice*) _tmp5_);
				_tmp7_ = _tmp6_;
				network_wifi_menu_item_set_state (_tmp4_, _tmp7_);
			}
			network_wifi_interface_cancel_scan (self);
			break;
		}
		case NM_DEVICE_STATE_DEACTIVATING:
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			network_wifi_interface_cancel_scan (self);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_DISCONNECTED);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			network_wifi_interface_set_scan_placeholder (self);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_DISCONNECTED);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			network_wifi_interface_set_scan_placeholder (self);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_WIFI);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			NMAccessPoint* _tmp8_;
			network_wifi_interface_set_scan_placeholder (self);
			_tmp8_ = self->priv->active_ap;
			if (_tmp8_ != NULL) {
				NMAccessPoint* _tmp9_;
				_tmp9_ = self->priv->active_ap;
				network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_wifi_interface_strength_to_state (self, nm_access_point_get_strength (_tmp9_)));
			} else {
				network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTED_WIFI_WEAK);
			}
			break;
		}
		default:
		break;
	}
	_tmp10_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_enum_get_value (g_type_class_ref (NETWORK_TYPE_STATE), _tmp11_);
	g_debug ("WifiInterface.vala:196: New network state: %s", (_tmp12_ != NULL) ? _tmp12_->value_name : NULL);
	self->priv->software_locked = FALSE;
	self->priv->hardware_locked = FALSE;
	_tmp13_ = self->priv->rfkill;
	_tmp14_ = rf_kill_manager_get_devices (_tmp13_);
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp14_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			RFKillDevice* _tmp15_;
			RFKillDevice* device = NULL;
			_tmp15_ = _rf_kill_device_ref0 ((RFKillDevice*) device_it->data);
			device = _tmp15_;
			{
				RFKillDevice* _tmp16_;
				RFKillDeviceType _tmp17_;
				RFKillDeviceType _tmp18_;
				RFKillDevice* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				RFKillDevice* _tmp22_;
				gboolean _tmp23_;
				gboolean _tmp24_;
				_tmp16_ = device;
				_tmp17_ = rf_kill_device_get_device_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ != RF_KILL_DEVICE_TYPE_WLAN) {
					_rf_kill_device_unref0 (device);
					continue;
				}
				_tmp19_ = device;
				_tmp20_ = rf_kill_device_get_software_lock (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					self->priv->software_locked = TRUE;
				}
				_tmp22_ = device;
				_tmp23_ = rf_kill_device_get_hardware_lock (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_) {
					self->priv->hardware_locked = TRUE;
				}
				_rf_kill_device_unref0 (device);
			}
		}
		(device_collection == NULL) ? NULL : (device_collection = (_g_list_free__rf_kill_device_unref0_ (device_collection), NULL));
	}
	if (self->priv->hardware_locked) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = self->priv->software_locked;
	}
	self->priv->locked = _tmp25_;
	network_wifi_interface_update_active_ap (self);
	_tmp26_ = self->priv->wifi_item;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, !self->priv->hardware_locked);
	_tmp27_ = self->priv->wifi_item;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp27_, !self->priv->locked);
	_tmp28_ = self->wifi_device;
	_tmp29_ = nm_device_wifi_get_active_access_point (_tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (self->priv->active_ap);
	self->priv->active_ap = _tmp30_;
	_tmp32_ = self->wifi_device;
	_tmp33_ = nm_device_get_state ((NMDevice*) _tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == NM_DEVICE_STATE_UNAVAILABLE) {
		_tmp31_ = TRUE;
	} else {
		NetworkState _tmp35_;
		NetworkState _tmp36_;
		_tmp35_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
		_tmp36_ = _tmp35_;
		_tmp31_ = _tmp36_ == NETWORK_STATE_FAILED_WIFI;
	}
	if (_tmp31_) {
		GtkRevealer* _tmp37_;
		_tmp37_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp37_, FALSE);
		network_wifi_interface_set_hidden_sensitivity (self, FALSE);
	} else {
		GtkRevealer* _tmp38_;
		_tmp38_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp38_, TRUE);
		network_wifi_interface_set_hidden_sensitivity (self, TRUE);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->wifi_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda14_ (Block7Data* _data7_,
              gint response)
{
	NetworkWifiInterface* self;
	self = _data7_->self;
	if (response == ((gint) GTK_RESPONSE_OK)) {
		NMAWifiDialog* _tmp0_;
		_tmp0_ = _data7_->wifi_dialog;
		network_wifi_interface_connect_to_network (self, _tmp0_, NULL, NULL);
	}
}

static void
____lambda14__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda14_ (self, response_id);
}

static void
___lambda16_ (NetworkWifiInterface* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		NMClient* _tmp0_;
		NMActiveConnection* _tmp1_;
		NMActiveConnection* _tmp2_;
		_tmp0_ = self->priv->_nm_client;
		_tmp1_ = nm_client_add_and_activate_connection_finish (_tmp0_, res, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("WifiInterface.vala:334: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda16__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda16_ ((NetworkWifiInterface*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda17_ (NetworkWifiInterface* self)
{
	gboolean result;
	network_wifi_interface_update (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ ((NetworkWifiInterface*) self);
	return result;
}

static void
network_wifi_interface_wifi_activate_cb (NetworkWifiInterface* self,
                                         NetworkWifiMenuItem* i)
{
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceWifi* _tmp2_;
	NMAccessPoint* _tmp3_;
	NMAccessPoint* _tmp4_;
	NMAccessPoint* _tmp5_;
	PolkitPermission* _tmp6_;
	GPtrArray* connections = NULL;
	NMClient* _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* _tmp17_;
	GPtrArray* device_connections = NULL;
	NMDeviceWifi* _tmp18_;
	GPtrArray* _tmp19_;
	GPtrArray* _tmp20_;
	GPtrArray* ap_connections = NULL;
	NMAccessPoint* _tmp21_;
	NMAccessPoint* _tmp22_;
	GPtrArray* _tmp23_;
	GPtrArray* _tmp24_;
	NMConnection* valid_connection = NULL;
	NMAccessPoint* _tmp25_;
	NMAccessPoint* _tmp26_;
	GPtrArray* _tmp27_;
	NMConnection* _tmp28_;
	NMConnection* _tmp29_;
	NM80211ApSecurityFlags flags = 0U;
	NMAccessPoint* _tmp36_;
	NMAccessPoint* _tmp37_;
	NMAccessPoint* _tmp38_;
	NMAccessPoint* _tmp39_;
	gboolean is_secured = FALSE;
	NMConnection* connection = NULL;
	NMConnection* _tmp40_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->wifi_device;
	_tmp3_ = nm_device_wifi_get_active_access_point (_tmp2_);
	_tmp4_ = network_wifi_menu_item_get_ap (i);
	_tmp5_ = _tmp4_;
	if (_tmp3_ == _tmp5_) {
		return;
	}
	_tmp6_ = network_wifi_interface_permission;
	if (_tmp6_ == NULL) {
		{
			PolkitPermission* _tmp7_ = NULL;
			PolkitUnixProcess* _tmp8_;
			PolkitUnixProcess* _tmp9_;
			PolkitPermission* _tmp10_;
			PolkitPermission* _tmp11_;
			PolkitPermission* _tmp12_;
			_tmp8_ = (PolkitUnixProcess*) polkit_unix_process_new ((gint) getpid ());
			_tmp9_ = _tmp8_;
			_tmp10_ = (PolkitPermission*) polkit_permission_new_sync ("io.elementary.wingpanel.network.administration", (PolkitSubject*) _tmp9_, NULL, &_inner_error0_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp9_);
			_tmp7_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (network_wifi_interface_permission);
			network_wifi_interface_permission = _tmp12_;
			_g_object_unref0 (_tmp7_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("WifiInterface.vala:250: Can't get permission to add Wi-Fi network with" \
"out prompting for admin: %s", _tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = self->priv->_nm_client;
	_tmp16_ = nm_client_get_connections (_tmp15_);
	_tmp17_ = _g_ptr_array_ref0 (_tmp16_);
	connections = _tmp17_;
	_tmp18_ = self->wifi_device;
	_tmp19_ = connections;
	_tmp20_ = nm_device_filter_connections ((NMDevice*) _tmp18_, _tmp19_);
	device_connections = _tmp20_;
	_tmp21_ = network_wifi_menu_item_get_ap (i);
	_tmp22_ = _tmp21_;
	_tmp23_ = device_connections;
	_tmp24_ = nm_access_point_filter_connections (_tmp22_, _tmp23_);
	ap_connections = _tmp24_;
	_tmp25_ = network_wifi_menu_item_get_ap (i);
	_tmp26_ = _tmp25_;
	_tmp27_ = ap_connections;
	_tmp28_ = network_wifi_interface_get_valid_connection (self, _tmp26_, _tmp27_);
	valid_connection = _tmp28_;
	_tmp29_ = valid_connection;
	if (_tmp29_ != NULL) {
		NMClient* _tmp30_;
		NMConnection* _tmp31_;
		NMDeviceWifi* _tmp32_;
		NMAccessPoint* _tmp33_;
		NMAccessPoint* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = self->priv->_nm_client;
		_tmp31_ = valid_connection;
		_tmp32_ = self->wifi_device;
		_tmp33_ = network_wifi_menu_item_get_ap (i);
		_tmp34_ = _tmp33_;
		_tmp35_ = nm_object_get_path ((NMObject*) _tmp34_);
		nm_client_activate_connection_async (_tmp30_, _tmp31_, (NMDevice*) _tmp32_, _tmp35_, NULL, NULL, NULL);
		_g_object_unref0 (valid_connection);
		_g_ptr_array_unref0 (ap_connections);
		_g_ptr_array_unref0 (device_connections);
		_g_ptr_array_unref0 (connections);
		return;
	}
	_tmp36_ = network_wifi_menu_item_get_ap (i);
	_tmp37_ = _tmp36_;
	_tmp38_ = network_wifi_menu_item_get_ap (i);
	_tmp39_ = _tmp38_;
	flags = nm_access_point_get_wpa_flags (_tmp37_) | nm_access_point_get_rsn_flags (_tmp39_);
	is_secured = TRUE;
	_tmp40_ = nm_simple_connection_new ();
	connection = _tmp40_;
	if (flags != NM_802_11_AP_SEC_NONE) {
		NMSettingConnection* s_con = NULL;
		NMSettingConnection* _tmp41_;
		NMSettingConnection* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		NMConnection* _tmp45_;
		NMSettingConnection* _tmp46_;
		NMSetting* _tmp47_;
		gboolean _tmp48_ = FALSE;
		NMSettingWireless* s_wifi = NULL;
		NMSettingWireless* _tmp59_;
		NMSettingWireless* _tmp60_;
		NMAccessPoint* _tmp61_;
		NMAccessPoint* _tmp62_;
		GBytes* _tmp63_;
		NMConnection* _tmp64_;
		NMSettingWireless* _tmp65_;
		NMSetting* _tmp66_;
		_tmp41_ = (NMSettingConnection*) nm_setting_connection_new ();
		s_con = _tmp41_;
		_tmp42_ = s_con;
		_tmp43_ = nm_utils_uuid_generate ();
		_tmp44_ = _tmp43_;
		g_object_set (_tmp42_, "uuid", _tmp44_, NULL);
		_g_free0 (_tmp44_);
		_tmp45_ = connection;
		_tmp46_ = s_con;
		_tmp47_ = _g_object_ref0 ((NMSetting*) _tmp46_);
		nm_connection_add_setting (_tmp45_, _tmp47_);
		if ((flags & NM_802_11_AP_SEC_KEY_MGMT_OWE) == NM_802_11_AP_SEC_KEY_MGMT_OWE) {
			_tmp48_ = TRUE;
		} else {
			_tmp48_ = (flags & NM_802_11_AP_SEC_KEY_MGMT_OWE_TM) == NM_802_11_AP_SEC_KEY_MGMT_OWE_TM;
		}
		if (_tmp48_) {
			NMSettingWirelessSecurity* s_wsec = NULL;
			NMSettingWirelessSecurity* _tmp49_;
			NMSettingWirelessSecurity* _tmp50_;
			NMConnection* _tmp51_;
			NMSettingWirelessSecurity* _tmp52_;
			NMSetting* _tmp53_;
			_tmp49_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			s_wsec = _tmp49_;
			_tmp50_ = s_wsec;
			g_object_set (_tmp50_, "key-mgmt", "owe", NULL);
			_tmp51_ = connection;
			_tmp52_ = s_wsec;
			_tmp53_ = _g_object_ref0 ((NMSetting*) _tmp52_);
			nm_connection_add_setting (_tmp51_, _tmp53_);
			_g_object_unref0 (s_wsec);
		}
		if ((flags & NM_802_11_AP_SEC_KEY_MGMT_SAE) == NM_802_11_AP_SEC_KEY_MGMT_SAE) {
			NMSettingWirelessSecurity* s_wsec = NULL;
			NMSettingWirelessSecurity* _tmp54_;
			NMSettingWirelessSecurity* _tmp55_;
			NMConnection* _tmp56_;
			NMSettingWirelessSecurity* _tmp57_;
			NMSetting* _tmp58_;
			_tmp54_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			s_wsec = _tmp54_;
			_tmp55_ = s_wsec;
			g_object_set (_tmp55_, "key-mgmt", "sae", NULL);
			_tmp56_ = connection;
			_tmp57_ = s_wsec;
			_tmp58_ = _g_object_ref0 ((NMSetting*) _tmp57_);
			nm_connection_add_setting (_tmp56_, _tmp58_);
			_g_object_unref0 (s_wsec);
		}
		_tmp59_ = (NMSettingWireless*) nm_setting_wireless_new ();
		s_wifi = _tmp59_;
		_tmp60_ = s_wifi;
		_tmp61_ = network_wifi_menu_item_get_ap (i);
		_tmp62_ = _tmp61_;
		_tmp63_ = nm_access_point_get_ssid (_tmp62_);
		g_object_set (_tmp60_, "ssid", _tmp63_, NULL);
		_tmp64_ = connection;
		_tmp65_ = s_wifi;
		_tmp66_ = _g_object_ref0 ((NMSetting*) _tmp65_);
		nm_connection_add_setting (_tmp64_, _tmp66_);
		if ((flags & NM_802_11_AP_SEC_KEY_MGMT_802_1X) == NM_802_11_AP_SEC_KEY_MGMT_802_1X) {
			NMSettingWirelessSecurity* s_wsec = NULL;
			NMSettingWirelessSecurity* _tmp67_;
			NMSettingWirelessSecurity* _tmp68_;
			NMConnection* _tmp69_;
			NMSettingWirelessSecurity* _tmp70_;
			NMSetting* _tmp71_;
			NMSetting8021x* s_8021x = NULL;
			NMSetting8021x* _tmp72_;
			NMSetting8021x* _tmp73_;
			NMSetting8021x* _tmp74_;
			NMConnection* _tmp75_;
			NMSetting8021x* _tmp76_;
			NMSetting* _tmp77_;
			_tmp67_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			s_wsec = _tmp67_;
			_tmp68_ = s_wsec;
			g_object_set (_tmp68_, "key-mgmt", "wpa-eap", NULL);
			_tmp69_ = connection;
			_tmp70_ = s_wsec;
			_tmp71_ = _g_object_ref0 ((NMSetting*) _tmp70_);
			nm_connection_add_setting (_tmp69_, _tmp71_);
			_tmp72_ = (NMSetting8021x*) nm_setting_802_1x_new ();
			s_8021x = _tmp72_;
			_tmp73_ = s_8021x;
			nm_setting_802_1x_add_eap_method (_tmp73_, "ttls");
			_tmp74_ = s_8021x;
			g_object_set (_tmp74_, "phase2-auth", "mschapv2", NULL);
			_tmp75_ = connection;
			_tmp76_ = s_8021x;
			_tmp77_ = _g_object_ref0 ((NMSetting*) _tmp76_);
			nm_connection_add_setting (_tmp75_, _tmp77_);
			_g_object_unref0 (s_8021x);
			_g_object_unref0 (s_wsec);
		}
		_g_object_unref0 (s_wifi);
		_g_object_unref0 (s_con);
	}
	if (is_secured) {
		Block7Data* _data7_;
		NMClient* _tmp78_;
		NMConnection* _tmp79_;
		NMDeviceWifi* _tmp80_;
		NMAccessPoint* _tmp81_;
		NMAccessPoint* _tmp82_;
		NMAWifiDialog* _tmp83_ = NULL;
		NMAWifiDialog* _tmp84_;
		GtkWidget* _tmp85_;
		NMAWifiDialog* _tmp86_;
		NMAWifiDialog* _tmp87_;
		NMAWifiDialog* _tmp88_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->self = g_object_ref (self);
		_tmp78_ = self->priv->_nm_client;
		_tmp79_ = connection;
		_tmp80_ = self->wifi_device;
		_tmp81_ = network_wifi_menu_item_get_ap (i);
		_tmp82_ = _tmp81_;
		_tmp83_ = (NMAWifiDialog*) nma_wifi_dialog_new (_tmp78_, _tmp79_, (NMDevice*) _tmp80_, _tmp82_, FALSE);
		gtk_window_set_deletable ((GtkWindow*) _tmp83_, FALSE);
		g_object_ref_sink (_tmp83_);
		_data7_->wifi_dialog = _tmp83_;
		_tmp84_ = _data7_->wifi_dialog;
		_tmp85_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp84_, G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, gtk_window_get_type (), GtkWindow));
		_tmp86_ = _data7_->wifi_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp86_, "response", (GCallback) ____lambda14__gtk_dialog_response, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp87_ = _data7_->wifi_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp87_);
		_tmp88_ = _data7_->wifi_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp88_);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	} else {
		NMClient* _tmp89_;
		NMConnection* _tmp90_;
		NMDeviceWifi* _tmp91_;
		NMAccessPoint* _tmp92_;
		NMAccessPoint* _tmp93_;
		const gchar* _tmp94_;
		_tmp89_ = self->priv->_nm_client;
		_tmp90_ = connection;
		_tmp91_ = self->wifi_device;
		_tmp92_ = network_wifi_menu_item_get_ap (i);
		_tmp93_ = _tmp92_;
		_tmp94_ = nm_object_get_path ((NMObject*) _tmp93_);
		nm_client_add_and_activate_connection_async (_tmp89_, _tmp90_, (NMDevice*) _tmp91_, _tmp94_, NULL, ____lambda16__gasync_ready_callback, g_object_ref (self));
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (connection);
	_g_object_unref0 (valid_connection);
	_g_ptr_array_unref0 (ap_connections);
	_g_ptr_array_unref0 (device_connections);
	_g_ptr_array_unref0 (connections);
}

void
network_wifi_interface_start_scanning (NetworkWifiInterface* self)
{
	GCancellable* _tmp0_;
	NMDeviceWifi* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wifi_scan_cancellable;
	g_cancellable_reset (_tmp0_);
	_tmp1_ = self->wifi_device;
	_tmp2_ = self->priv->wifi_scan_cancellable;
	nm_device_wifi_request_scan_async (_tmp1_, _tmp2_, NULL, NULL);
}

void
network_wifi_interface_cancel_scanning (NetworkWifiInterface* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wifi_scan_cancellable;
	g_cancellable_cancel (_tmp0_);
}

static NMConnection*
network_wifi_interface_get_valid_connection (NetworkWifiInterface* self,
                                             NMAccessPoint* ap,
                                             GPtrArray* ap_connections)
{
	NMConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ap != NULL, NULL);
	g_return_val_if_fail (ap_connections != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				NMConnection* connection = NULL;
				gconstpointer _tmp4_;
				NMConnection* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = vala_g_ptr_array_get_length (ap_connections);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (ap_connections, (guint) i);
				connection = (NMConnection*) _tmp4_;
				_tmp5_ = connection;
				if (nm_access_point_connection_valid (ap, _tmp5_)) {
					NMConnection* _tmp6_;
					NMConnection* _tmp7_;
					_tmp6_ = connection;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->hidden_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda18_ (Block8Data* _data8_,
             gint response)
{
	NetworkWifiInterface* self;
	self = _data8_->self;
	if (response == ((gint) GTK_RESPONSE_OK)) {
		network_wifi_interface_connect_to_network (self, _data8_->hidden_dialog, NULL, NULL);
	}
}

static void
___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda18_ (self, response_id);
}

void
network_wifi_interface_connect_to_hidden (NetworkWifiInterface* self)
{
	Block8Data* _data8_;
	NMClient* _tmp0_;
	NMAWifiDialog* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = self->priv->_nm_client;
	_tmp1_ = (NMAWifiDialog*) nma_wifi_dialog_new_for_other (_tmp0_);
	gtk_window_set_deletable ((GtkWindow*) _tmp1_, FALSE);
	g_object_ref_sink (_tmp1_);
	_data8_->hidden_dialog = _tmp1_;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_window_set_transient_for ((GtkWindow*) _data8_->hidden_dialog, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
	g_signal_connect_data ((GtkDialog*) _data8_->hidden_dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_dialog_run ((GtkDialog*) _data8_->hidden_dialog);
	gtk_widget_destroy ((GtkWidget*) _data8_->hidden_dialog);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
network_wifi_interface_connect_to_network_data_free (gpointer _data)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wifi_dialog);
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkWifiInterfaceConnectToNetworkData, _data_);
}

static void
network_wifi_interface_connect_to_network (NetworkWifiInterface* self,
                                           NMAWifiDialog* wifi_dialog,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	NetworkWifiInterface* _tmp0_;
	NMAWifiDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wifi_dialog != NULL);
	_data_ = g_slice_new0 (NetworkWifiInterfaceConnectToNetworkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_wifi_interface_connect_to_network_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (wifi_dialog);
	_g_object_unref0 (_data_->wifi_dialog);
	_data_->wifi_dialog = _tmp1_;
	network_wifi_interface_connect_to_network_co (_data_);
}

static void
network_wifi_interface_connect_to_network_finish (NetworkWifiInterface* self,
                                                  GAsyncResult* _res_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->dialog_connection);
		_g_object_unref0 (_data9_->fuzzy);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda15_ (Block9Data* _data9_,
             NMRemoteConnection* possible)
{
	NetworkWifiInterface* self;
	NMConnection* _tmp0_;
	self = _data9_->self;
	g_return_if_fail (possible != NULL);
	_tmp0_ = _data9_->dialog_connection;
	if (nm_connection_compare (_tmp0_, (NMConnection*) possible, NM_SETTING_COMPARE_FLAG_FUZZY | NM_SETTING_COMPARE_FLAG_IGNORE_ID)) {
		NMConnection* _tmp1_;
		_tmp1_ = _g_object_ref0 ((NMConnection*) possible);
		_g_object_unref0 (_data9_->fuzzy);
		_data9_->fuzzy = _tmp1_;
	}
}

static void
___lambda15__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda15_ (self, (NMRemoteConnection*) data);
}

static void
network_wifi_interface_connect_to_network_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_wifi_interface_connect_to_network_co (_data_);
}

static gboolean
network_wifi_interface_connect_to_network_co (NetworkWifiInterfaceConnectToNetworkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_data9_->fuzzy = NULL;
	_data_->dialog_ap = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = nma_wifi_dialog_get_connection (_data_->wifi_dialog, &_data_->_tmp0_, &_data_->_tmp1_);
	_g_object_unref0 (_data_->dialog_device);
	_data_->dialog_device = _data_->_tmp0_;
	_g_object_unref0 (_data_->dialog_ap);
	_data_->dialog_ap = _data_->_tmp1_;
	_data_->_data9_->dialog_connection = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->_nm_client;
	_data_->_tmp4_ = nm_client_get_connections (_data_->_tmp3_);
	g_ptr_array_foreach (_data_->_tmp4_, ___lambda15__gfunc, _data_->_data9_);
	_data_->path = NULL;
	_data_->_tmp5_ = _data_->dialog_ap;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->dialog_ap;
		_data_->_tmp7_ = nm_object_get_path ((NMObject*) _data_->_tmp6_);
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_data9_->fuzzy;
	if (_data_->_tmp9_ != NULL) {
		{
			_data_->_tmp10_ = _data_->self->priv->_nm_client;
			_data_->_tmp11_ = _data_->_data9_->fuzzy;
			_data_->_tmp12_ = _data_->self->wifi_device;
			_data_->_tmp13_ = _data_->path;
			_data_->_state_ = 1;
			nm_client_activate_connection_async (_data_->_tmp10_, _data_->_tmp11_, (NMDevice*) _data_->_tmp12_, _data_->_tmp13_, NULL, network_wifi_interface_connect_to_network_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = nm_client_activate_connection_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_g_object_unref0 (_data_->_tmp15_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp16_ = _data_->_error_;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			g_critical ("WifiInterface.vala:403: %s", _data_->_tmp17_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->dialog_ap);
			_g_object_unref0 (_data_->dialog_device);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->mode = NULL;
		_data_->_tmp18_ = _data_->_data9_->dialog_connection;
		_data_->_tmp19_ = nm_connection_get_setting_wireless (_data_->_tmp18_);
		_data_->setting_wireless = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->setting_wireless;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = _data_->setting_wireless;
			_data_->_tmp22_ = nm_setting_wireless_get_mode (_data_->_tmp21_);
			_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
			_g_free0 (_data_->mode);
			_data_->mode = _data_->_tmp23_;
		}
		_data_->_tmp24_ = _data_->mode;
		if (g_strcmp0 (_data_->_tmp24_, "adhoc") == 0) {
			_data_->_tmp25_ = _data_->_data9_->dialog_connection;
			_data_->_tmp26_ = nm_connection_get_setting_connection (_data_->_tmp25_);
			_data_->_tmp27_ = _g_object_ref0 (_data_->_tmp26_);
			_data_->connection_setting = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->connection_setting;
			if (_data_->_tmp28_ == NULL) {
				_data_->_tmp29_ = (NMSettingConnection*) nm_setting_connection_new ();
				_g_object_unref0 (_data_->connection_setting);
				_data_->connection_setting = _data_->_tmp29_;
			}
			_data_->_tmp30_ = _data_->_data9_->dialog_connection;
			_data_->_tmp31_ = _data_->connection_setting;
			_data_->_tmp32_ = _g_object_ref0 ((NMSetting*) _data_->_tmp31_);
			nm_connection_add_setting (_data_->_tmp30_, _data_->_tmp32_);
			_g_object_unref0 (_data_->connection_setting);
		}
		{
			_data_->_tmp33_ = _data_->self->priv->_nm_client;
			_data_->_tmp34_ = _data_->_data9_->dialog_connection;
			_data_->_tmp35_ = _data_->dialog_device;
			_data_->_tmp36_ = _data_->path;
			_data_->_state_ = 2;
			nm_client_add_and_activate_connection_async (_data_->_tmp33_, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, NULL, network_wifi_interface_connect_to_network_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp37_ = nm_client_add_and_activate_connection_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_g_object_unref0 (_data_->_tmp38_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp39_ = _data_->_vala1__error_;
			_data_->_tmp40_ = _data_->_tmp39_->message;
			g_critical ("WifiInterface.vala:424: %s", _data_->_tmp40_);
			_g_error_free0 (_data_->_vala1__error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->mode);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->dialog_ap);
			_g_object_unref0 (_data_->dialog_device);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->mode);
	}
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->dialog_ap);
	_g_object_unref0 (_data_->dialog_device);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static void
network_wifi_interface_access_point_added_cb (NetworkWifiInterface* self,
                                              GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	GBytes* ap_ssid = NULL;
	NMAccessPoint* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	gboolean found = FALSE;
	GtkListBox* _tmp4_;
	GList* _tmp5_;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	_tmp1_ = ap;
	_tmp2_ = nm_access_point_get_ssid (_tmp1_);
	_tmp3_ = _tmp2_;
	ap_ssid = _tmp3_;
	found = FALSE;
	_tmp4_ = self->priv->wifi_list;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp5_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp6_;
				NetworkWifiMenuItem* _tmp7_;
				GBytes* menu_ssid = NULL;
				NetworkWifiMenuItem* _tmp8_;
				GBytes* _tmp9_;
				GBytes* _tmp10_;
				GBytes* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				GBytes* _tmp14_;
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp7_;
				_tmp8_ = menu_item;
				_tmp9_ = network_wifi_menu_item_get_ssid (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_bytes_ref0 (_tmp10_);
				menu_ssid = _tmp11_;
				_tmp14_ = menu_ssid;
				if (_tmp14_ != NULL) {
					NMAccessPoint* _tmp15_;
					GBytes* _tmp16_;
					GBytes* _tmp17_;
					_tmp15_ = ap;
					_tmp16_ = nm_access_point_get_ssid (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp13_ = _tmp17_ != NULL;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					NMAccessPoint* _tmp18_;
					GBytes* _tmp19_;
					GBytes* _tmp20_;
					GBytes* _tmp21_;
					_tmp18_ = ap;
					_tmp19_ = nm_access_point_get_ssid (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = menu_ssid;
					_tmp12_ = g_bytes_compare (_tmp20_, _tmp21_) == 0;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					NetworkWifiMenuItem* _tmp22_;
					NMAccessPoint* _tmp23_;
					found = TRUE;
					_tmp22_ = menu_item;
					_tmp23_ = ap;
					network_wifi_menu_item_add_ap (_tmp22_, _tmp23_);
					_g_bytes_unref0 (menu_ssid);
					_g_object_unref0 (menu_item);
					break;
				}
				_g_bytes_unref0 (menu_ssid);
				_g_object_unref0 (menu_item);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	if (!found) {
		GBytes* _tmp25_;
		_tmp25_ = ap_ssid;
		_tmp24_ = _tmp25_ != NULL;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		NetworkWifiMenuItem* item = NULL;
		NMAccessPoint* _tmp26_;
		GtkRadioButton* _tmp27_;
		NetworkWifiMenuItem* _tmp28_;
		GtkListBox* _tmp29_;
		NetworkWifiMenuItem* _tmp30_;
		GtkListBox* _tmp31_;
		_tmp26_ = ap;
		_tmp27_ = self->priv->blank_item;
		_tmp28_ = network_wifi_menu_item_new (_tmp26_, _tmp27_);
		g_object_ref_sink (_tmp28_);
		item = _tmp28_;
		_tmp29_ = self->priv->wifi_list;
		_tmp30_ = item;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
		_tmp31_ = self->priv->wifi_list;
		gtk_widget_show_all ((GtkWidget*) _tmp31_);
		network_wifi_interface_update (self);
		_g_object_unref0 (item);
	}
	_g_object_unref0 (ap);
}

static void
network_wifi_interface_update_active_ap (NetworkWifiInterface* self)
{
	NMDeviceWifi* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMAccessPoint* _tmp2_;
	NetworkWifiMenuItem* _tmp3_;
	NMAccessPoint* _tmp8_;
	g_return_if_fail (self != NULL);
	g_debug ("WifiInterface.vala:474: Update active AP");
	_tmp0_ = self->wifi_device;
	_tmp1_ = nm_device_wifi_get_active_access_point (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->active_ap);
	self->priv->active_ap = _tmp2_;
	_tmp3_ = self->priv->active_wifi_item;
	if (_tmp3_ != NULL) {
		NetworkWifiMenuItem* _tmp4_;
		NMDeviceState _tmp5_;
		NMDeviceState _tmp6_;
		_tmp4_ = self->priv->active_wifi_item;
		_tmp5_ = network_wifi_menu_item_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NM_DEVICE_STATE_CONFIG) {
			NetworkWifiMenuItem* _tmp7_;
			_tmp7_ = self->priv->active_wifi_item;
			network_wifi_menu_item_set_state (_tmp7_, NM_DEVICE_STATE_DISCONNECTED);
		}
		_g_object_unref0 (self->priv->active_wifi_item);
		self->priv->active_wifi_item = NULL;
	}
	_tmp8_ = self->priv->active_ap;
	if (_tmp8_ == NULL) {
		GtkRadioButton* _tmp9_;
		g_debug ("WifiInterface.vala:486: No active AP");
		_tmp9_ = self->priv->blank_item;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp9_, TRUE);
	} else {
		GBytes* active_ap_ssid = NULL;
		NMAccessPoint* _tmp10_;
		GBytes* _tmp11_;
		GBytes* _tmp12_;
		GBytes* _tmp13_;
		gsize _tmp14_ = 0;
		guint8* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean found = FALSE;
		GtkListBox* _tmp19_;
		GList* _tmp20_;
		_tmp10_ = self->priv->active_ap;
		_tmp11_ = nm_access_point_get_ssid (_tmp10_);
		_tmp12_ = _tmp11_;
		active_ap_ssid = _tmp12_;
		_tmp13_ = active_ap_ssid;
		_tmp15_ = g_bytes_get_data (_tmp13_, &_tmp14_);
		_tmp16_ = nm_utils_ssid_to_utf8 (_tmp15_, (gsize) _tmp14_);
		_tmp17_ = _tmp16_;
		network_wifi_interface_set_active_ap_name (self, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = self->priv->_active_ap_name;
		g_debug ("WifiInterface.vala:491: Active ap: %s", _tmp18_);
		found = FALSE;
		_tmp19_ = self->priv->wifi_list;
		_tmp20_ = gtk_container_get_children ((GtkContainer*) _tmp19_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp20_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* w = NULL;
				w = (GtkWidget*) w_it->data;
				{
					NetworkWifiMenuItem* menu_item = NULL;
					GtkWidget* _tmp21_;
					NetworkWifiMenuItem* _tmp22_;
					GBytes* _tmp23_;
					NetworkWifiMenuItem* _tmp24_;
					GBytes* _tmp25_;
					GBytes* _tmp26_;
					_tmp21_ = w;
					_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
					menu_item = _tmp22_;
					_tmp23_ = active_ap_ssid;
					_tmp24_ = menu_item;
					_tmp25_ = network_wifi_menu_item_get_ssid (_tmp24_);
					_tmp26_ = _tmp25_;
					if (g_bytes_compare (_tmp23_, _tmp26_) == 0) {
						NetworkWifiMenuItem* _tmp27_;
						NetworkWifiMenuItem* _tmp28_;
						NetworkWifiMenuItem* _tmp29_;
						NetworkWifiMenuItem* _tmp30_;
						NMDevice* _tmp31_;
						NMDevice* _tmp32_;
						NMDeviceState _tmp33_;
						NMDeviceState _tmp34_;
						found = TRUE;
						_tmp27_ = menu_item;
						network_wifi_menu_item_set_active (_tmp27_, TRUE);
						_tmp28_ = menu_item;
						_tmp29_ = _g_object_ref0 (_tmp28_);
						_g_object_unref0 (self->priv->active_wifi_item);
						self->priv->active_wifi_item = _tmp29_;
						_tmp30_ = self->priv->active_wifi_item;
						_tmp31_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
						_tmp32_ = _tmp31_;
						_tmp33_ = nm_device_get_state (_tmp32_);
						_tmp34_ = _tmp33_;
						network_wifi_menu_item_set_state (_tmp30_, _tmp34_);
					}
					_g_object_unref0 (menu_item);
				}
			}
			(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
		}
		if (!found) {
			g_debug ("WifiInterface.vala:507: Active AP not added");
		}
	}
}

static void
network_wifi_interface_access_point_removed_cb (NetworkWifiInterface* self,
                                                GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	NMAccessPoint* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	NetworkWifiMenuItem* found_item = NULL;
	GtkListBox* _tmp4_;
	GList* _tmp5_;
	NetworkWifiMenuItem* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	_tmp1_ = ap;
	_tmp2_ = nm_access_point_get_ssid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		network_wifi_interface_update (self);
		_g_object_unref0 (ap);
		return;
	}
	found_item = NULL;
	_tmp4_ = self->priv->wifi_list;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp5_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp6_;
				NetworkWifiMenuItem* _tmp7_;
				NetworkWifiMenuItem* _tmp8_;
				NMAccessPoint* _tmp9_;
				GBytes* _tmp10_;
				GBytes* _tmp11_;
				NetworkWifiMenuItem* _tmp12_;
				GBytes* _tmp13_;
				GBytes* _tmp14_;
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp7_;
				_tmp8_ = menu_item;
				_vala_assert (_tmp8_ != NULL, "menu_item != null");
				_tmp9_ = ap;
				_tmp10_ = nm_access_point_get_ssid (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = menu_item;
				_tmp13_ = network_wifi_menu_item_get_ssid (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_bytes_compare (_tmp11_, _tmp14_) == 0) {
					NetworkWifiMenuItem* _tmp15_;
					NetworkWifiMenuItem* _tmp16_;
					_tmp15_ = menu_item;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (found_item);
					found_item = _tmp16_;
					_g_object_unref0 (menu_item);
					break;
				}
				_g_object_unref0 (menu_item);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	_tmp17_ = found_item;
	if (_tmp17_ == NULL) {
		g_critical ("WifiInterface.vala:533: Couldn't remove an access point which has not " \
"been added.");
	} else {
		NetworkWifiMenuItem* _tmp18_;
		NMAccessPoint* _tmp19_;
		_tmp18_ = found_item;
		_tmp19_ = ap;
		if (!network_wifi_menu_item_remove_ap (_tmp18_, _tmp19_)) {
			NetworkWifiMenuItem* _tmp20_;
			_tmp20_ = found_item;
			gtk_widget_destroy ((GtkWidget*) _tmp20_);
		}
	}
	network_wifi_interface_update (self);
	_g_object_unref0 (found_item);
	_g_object_unref0 (ap);
}

static NetworkState
network_wifi_interface_strength_to_state (NetworkWifiInterface* self,
                                          guint8 strength)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	if (((gint) strength) < 30) {
		result = NETWORK_STATE_CONNECTED_WIFI_WEAK;
		return result;
	} else {
		if (((gint) strength) < 55) {
			result = NETWORK_STATE_CONNECTED_WIFI_OK;
			return result;
		} else {
			if (((gint) strength) < 80) {
				result = NETWORK_STATE_CONNECTED_WIFI_GOOD;
				return result;
			} else {
				result = NETWORK_STATE_CONNECTED_WIFI_EXCELLENT;
				return result;
			}
		}
	}
}

static void
network_wifi_interface_cancel_scan (NetworkWifiInterface* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_scan > ((guint) 0)) {
		g_source_remove (self->priv->timeout_scan);
		self->priv->timeout_scan = (guint) 0;
	}
}

static gboolean
___lambda13_ (NetworkWifiInterface* self)
{
	GtkStack* _tmp0_;
	gboolean result;
	self->priv->timeout_scan = (guint) 0;
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "no-aps");
	result = FALSE;
	return result;
}

static gboolean
____lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda13_ ((NetworkWifiInterface*) self);
	return result;
}

static void
network_wifi_interface_set_scan_placeholder (NetworkWifiInterface* self)
{
	NetworkState _tmp0_;
	NetworkState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NETWORK_STATE_DISCONNECTED) {
		GtkStack* _tmp2_;
		NMDeviceWifi* _tmp3_;
		_tmp2_ = self->priv->placeholder;
		gtk_stack_set_visible_child_name (_tmp2_, "scanning");
		network_wifi_interface_cancel_scan (self);
		_tmp3_ = self->wifi_device;
		nm_device_wifi_request_scan_async (_tmp3_, NULL, NULL, NULL);
		self->priv->timeout_scan = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ____lambda13__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gint
network_wifi_interface_sort_func (NetworkWifiInterface* self,
                                  GtkListBoxRow* r1,
                                  GtkListBoxRow* r2)
{
	gboolean _tmp0_ = FALSE;
	NetworkWifiMenuItem* w1 = NULL;
	NetworkWifiMenuItem* _tmp1_;
	NetworkWifiMenuItem* w2 = NULL;
	NetworkWifiMenuItem* _tmp2_;
	NetworkWifiMenuItem* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	NetworkWifiMenuItem* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (r1 != NULL, 0);
	g_return_val_if_fail (r2 != NULL, 0);
	if (r1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = r2 == NULL;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (r1, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	w1 = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (r2, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	w2 = _tmp2_;
	_tmp3_ = w2;
	_tmp4_ = network_wifi_menu_item_get_strength (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = w1;
	_tmp7_ = network_wifi_menu_item_get_strength (_tmp6_);
	_tmp8_ = _tmp7_;
	result = (gint) (_tmp5_ - _tmp8_);
	_g_object_unref0 (w2);
	_g_object_unref0 (w1);
	return result;
}

NMClient*
network_wifi_interface_get_nm_client (NetworkWifiInterface* self)
{
	NMClient* result;
	NMClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nm_client;
	result = _tmp0_;
	return result;
}

static void
network_wifi_interface_set_nm_client (NetworkWifiInterface* self,
                                      NMClient* value)
{
	NMClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_interface_get_nm_client (self);
	if (old_value != value) {
		NMClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_nm_client);
		self->priv->_nm_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY]);
	}
}

gboolean
network_wifi_interface_get_hidden_sensitivity (NetworkWifiInterface* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hidden_sensitivity;
	return result;
}

void
network_wifi_interface_set_hidden_sensitivity (NetworkWifiInterface* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_interface_get_hidden_sensitivity (self);
	if (old_value != value) {
		self->priv->_hidden_sensitivity = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY]);
	}
}

const gchar*
network_wifi_interface_get_active_ap_name (NetworkWifiInterface* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_ap_name;
	result = _tmp0_;
	return result;
}

static void
network_wifi_interface_set_active_ap_name (NetworkWifiInterface* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_interface_get_active_ap_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_active_ap_name);
		self->priv->_active_ap_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY]);
	}
}

static NetworkWifiInterfacePlaceholderLabel*
network_wifi_interface_placeholder_label_construct (GType object_type,
                                                    const gchar* label)
{
	NetworkWifiInterfacePlaceholderLabel * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (NetworkWifiInterfacePlaceholderLabel*) g_object_new (object_type, "label", label, NULL);
	return self;
}

static NetworkWifiInterfacePlaceholderLabel*
network_wifi_interface_placeholder_label_new (const gchar* label)
{
	return network_wifi_interface_placeholder_label_construct (NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL, label);
}

static GObject *
network_wifi_interface_placeholder_label_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWifiInterfacePlaceholderLabel * self;
	parent_class = G_OBJECT_CLASS (network_wifi_interface_placeholder_label_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIFI_INTERFACE_TYPE_PLACEHOLDER_LABEL, NetworkWifiInterfacePlaceholderLabel);
	gtk_label_set_justify ((GtkLabel*) self, GTK_JUSTIFY_CENTER);
	gtk_label_set_max_width_chars ((GtkLabel*) self, 30);
	gtk_label_set_use_markup ((GtkLabel*) self, TRUE);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	g_object_set ((GtkLabel*) self, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	g_object_set ((GtkLabel*) self, "wrap", TRUE, NULL);
	return obj;
}

static void
network_wifi_interface_placeholder_label_class_init (NetworkWifiInterfacePlaceholderLabelClass * klass,
                                                     gpointer klass_data)
{
	network_wifi_interface_placeholder_label_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = network_wifi_interface_placeholder_label_constructor;
}

static void
network_wifi_interface_placeholder_label_instance_init (NetworkWifiInterfacePlaceholderLabel * self,
                                                        gpointer klass)
{
}

static GType
network_wifi_interface_placeholder_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiInterfacePlaceholderLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_interface_placeholder_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiInterfacePlaceholderLabel), 0, (GInstanceInitFunc) network_wifi_interface_placeholder_label_instance_init, NULL };
	GType network_wifi_interface_placeholder_label_type_id;
	network_wifi_interface_placeholder_label_type_id = g_type_register_static (gtk_label_get_type (), "NetworkWifiInterfacePlaceholderLabel", &g_define_type_info, 0);
	return network_wifi_interface_placeholder_label_type_id;
}

static GType
network_wifi_interface_placeholder_label_get_type (void)
{
	static volatile gsize network_wifi_interface_placeholder_label_type_id__once = 0;
	if (g_once_init_enter (&network_wifi_interface_placeholder_label_type_id__once)) {
		GType network_wifi_interface_placeholder_label_type_id;
		network_wifi_interface_placeholder_label_type_id = network_wifi_interface_placeholder_label_get_type_once ();
		g_once_init_leave (&network_wifi_interface_placeholder_label_type_id__once, network_wifi_interface_placeholder_label_type_id);
	}
	return network_wifi_interface_placeholder_label_type_id__once;
}

static gint
_network_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self)
{
	gint result;
	result = network_wifi_interface_sort_func ((NetworkWifiInterface*) self, row1, row2);
	return result;
}

static void
_network_wifi_interface___lambda19_ (NetworkWifiInterface* self,
                                     GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (NETWORK_IS_WIFI_MENU_ITEM (row)) {
		network_wifi_interface_wifi_activate_cb (self, G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	}
}

static void
__network_wifi_interface___lambda19__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self)
{
	_network_wifi_interface___lambda19_ ((NetworkWifiInterface*) self, row);
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
___lambda21_ (NetworkWifiInterface* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		nm_client_dbus_set_property_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_client_get_type (), NMClient), res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("WifiInterface.vala:144: Error activating wifi item: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda21__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda21_ ((NetworkWifiInterface*) self, source_object, res);
	g_object_unref (self);
}

static void
_network_wifi_interface___lambda20_ (NetworkWifiInterface* self)
{
	gboolean active = FALSE;
	GraniteSwitchModelButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->wifi_item;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	if (active != (!self->priv->software_locked)) {
		RFKillManager* _tmp3_;
		NMClient* _tmp4_;
		GVariant* _tmp5_;
		_tmp3_ = self->priv->rfkill;
		rf_kill_manager_set_software_lock (_tmp3_, RF_KILL_DEVICE_TYPE_WLAN, !active);
		_tmp4_ = self->priv->_nm_client;
		_tmp5_ = _variant_new1 (active);
		nm_client_dbus_set_property (_tmp4_, NM_DBUS_PATH, NM_DBUS_INTERFACE, "WirelessEnabled", _tmp5_, -1, NULL, ____lambda21__gasync_ready_callback, g_object_ref (self));
		_g_variant_unref0 (_tmp5_);
	}
}

static void
__network_wifi_interface___lambda20__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_network_wifi_interface___lambda20_ ((NetworkWifiInterface*) self);
}

static GObject *
network_wifi_interface_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWifiInterface * self;
	NetworkWifiInterfacePlaceholderLabel* no_aps = NULL;
	NetworkWifiInterfacePlaceholderLabel* _tmp0_;
	NetworkWifiInterfacePlaceholderLabel* scanning = NULL;
	NetworkWifiInterfacePlaceholderLabel* _tmp1_ = NULL;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp2_;
	GtkSpinner* _tmp3_;
	GtkGrid* scanning_box = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_;
	NetworkWifiInterfacePlaceholderLabel* _tmp6_;
	GtkGrid* _tmp7_;
	GtkSpinner* _tmp8_;
	GtkStack* _tmp9_ = NULL;
	GtkStack* _tmp10_;
	NetworkWifiInterfacePlaceholderLabel* _tmp11_;
	GtkStack* _tmp12_;
	GtkGrid* _tmp13_;
	GtkStack* _tmp14_;
	GtkStack* _tmp15_;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkStack* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GraniteSwitchModelButton* _tmp22_;
	GraniteSwitchModelButton* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkScrolledWindow* scrolled_box = NULL;
	GtkScrolledWindow* _tmp25_ = NULL;
	GtkScrolledWindow* _tmp26_;
	GtkListBox* _tmp27_;
	GtkRevealer* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GraniteSwitchModelButton* _tmp31_;
	GtkRevealer* _tmp32_;
	GraniteSwitchModelButton* _tmp33_;
	GtkListBox* _tmp34_;
	GraniteSwitchModelButton* _tmp35_;
	parent_class = G_OBJECT_CLASS (network_wifi_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	_tmp0_ = network_wifi_interface_placeholder_label_new (_ ("No Access Points Available"));
	g_object_ref_sink (_tmp0_);
	no_aps = _tmp0_;
	_tmp1_ = network_wifi_interface_placeholder_label_new (_ ("Scanning for Access Points…"));
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	scanning = _tmp1_;
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	spinner = _tmp2_;
	_tmp3_ = spinner;
	gtk_spinner_start (_tmp3_);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp4_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp4_);
	scanning_box = _tmp4_;
	_tmp5_ = scanning_box;
	_tmp6_ = scanning;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = scanning_box;
	_tmp8_ = spinner;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp9_, 12);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp9_;
	_tmp10_ = self->priv->placeholder;
	_tmp11_ = no_aps;
	gtk_stack_add_named (_tmp10_, (GtkWidget*) _tmp11_, "no-aps");
	_tmp12_ = self->priv->placeholder;
	_tmp13_ = scanning_box;
	gtk_stack_add_named (_tmp12_, (GtkWidget*) _tmp13_, "scanning");
	_tmp14_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp14_, "no-aps");
	_tmp15_ = self->priv->placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp16_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->wifi_list);
	self->priv->wifi_list = _tmp16_;
	_tmp17_ = self->priv->wifi_list;
	gtk_list_box_set_sort_func (_tmp17_, _network_wifi_interface_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp18_ = self->priv->wifi_list;
	_tmp19_ = self->priv->placeholder;
	gtk_list_box_set_placeholder (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = granite_switch_model_button_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->wifi_item);
	self->priv->wifi_item = _tmp22_;
	_tmp23_ = self->priv->wifi_item;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp25_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp25_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_max_content_height (_tmp25_, 512);
	gtk_scrolled_window_set_propagate_natural_height (_tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	scrolled_box = _tmp25_;
	_tmp26_ = scrolled_box;
	_tmp27_ = self->priv->wifi_list;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp28_;
	_tmp29_ = self->priv->revealer;
	_tmp30_ = scrolled_box;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp31_ = self->priv->wifi_item;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = self->priv->revealer;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
	_tmp33_ = self->priv->wifi_item;
	g_object_bind_property_with_closures ((GObject*) self, "display-title", (GObject*) _tmp33_, "text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->wifi_list;
	g_signal_connect_object (_tmp34_, "row-activated", (GCallback) __network_wifi_interface___lambda19__gtk_list_box_row_activated, self, 0);
	_tmp35_ = self->priv->wifi_item;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::active", (GCallback) __network_wifi_interface___lambda20__g_object_notify, self, 0);
	_g_object_unref0 (scrolled_box);
	_g_object_unref0 (scanning_box);
	_g_object_unref0 (spinner);
	_g_object_unref0 (scanning);
	_g_object_unref0 (no_aps);
	return obj;
}

static void
network_wifi_interface_class_init (NetworkWifiInterfaceClass * klass,
                                   gpointer klass_data)
{
	network_wifi_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiInterface_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_wifi_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY] = g_param_spec_object ("nm-client", "nm-client", "nm-client", nm_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY] = g_param_spec_boolean ("hidden-sensitivity", "hidden-sensitivity", "hidden-sensitivity", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY, network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY] = g_param_spec_string ("active-ap-name", "active-ap-name", "active-ap-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_wifi_interface_instance_init (NetworkWifiInterface * self,
                                      gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = network_wifi_interface_get_instance_private (self);
	self->priv->_hidden_sensitivity = TRUE;
	self->priv->timeout_scan = (guint) 0;
	_tmp0_ = g_cancellable_new ();
	self->priv->wifi_scan_cancellable = _tmp0_;
}

static void
network_wifi_interface_finalize (GObject * obj)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	_g_object_unref0 (self->priv->_nm_client);
	_g_object_unref0 (self->wifi_device);
	_g_free0 (self->priv->_active_ap_name);
	_g_object_unref0 (self->priv->wifi_item);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->rfkill);
	_g_object_unref0 (self->priv->active_ap);
	_g_object_unref0 (self->priv->wifi_list);
	_g_object_unref0 (self->priv->active_wifi_item);
	_g_object_unref0 (self->priv->blank_item);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->wifi_scan_cancellable);
	G_OBJECT_CLASS (network_wifi_interface_parent_class)->finalize (obj);
}

static GType
network_wifi_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiInterface), 0, (GInstanceInitFunc) network_wifi_interface_instance_init, NULL };
	GType network_wifi_interface_type_id;
	network_wifi_interface_type_id = g_type_register_static (NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkWifiInterface", &g_define_type_info, 0);
	NetworkWifiInterface_private_offset = g_type_add_instance_private (network_wifi_interface_type_id, sizeof (NetworkWifiInterfacePrivate));
	return network_wifi_interface_type_id;
}

GType
network_wifi_interface_get_type (void)
{
	static volatile gsize network_wifi_interface_type_id__once = 0;
	if (g_once_init_enter (&network_wifi_interface_type_id__once)) {
		GType network_wifi_interface_type_id;
		network_wifi_interface_type_id = network_wifi_interface_get_type_once ();
		g_once_init_leave (&network_wifi_interface_type_id__once, network_wifi_interface_type_id);
	}
	return network_wifi_interface_type_id__once;
}

static void
_vala_network_wifi_interface_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		case NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY:
		g_value_set_object (value, network_wifi_interface_get_nm_client (self));
		break;
		case NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY:
		g_value_set_boolean (value, network_wifi_interface_get_hidden_sensitivity (self));
		break;
		case NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY:
		g_value_set_string (value, network_wifi_interface_get_active_ap_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_interface_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		case NETWORK_WIFI_INTERFACE_NM_CLIENT_PROPERTY:
		network_wifi_interface_set_nm_client (self, g_value_get_object (value));
		break;
		case NETWORK_WIFI_INTERFACE_HIDDEN_SENSITIVITY_PROPERTY:
		network_wifi_interface_set_hidden_sensitivity (self, g_value_get_boolean (value));
		break;
		case NETWORK_WIFI_INTERFACE_ACTIVE_AP_NAME_PROPERTY:
		network_wifi_interface_set_active_ap_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

