/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLVertexArrayObject.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLVertexArrayObjectConstructor);

class JSWebGLVertexArrayObjectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLVertexArrayObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLVertexArrayObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLVertexArrayObjectPrototype>(vm)) JSWebGLVertexArrayObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLVertexArrayObjectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLVertexArrayObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLVertexArrayObjectPrototype, JSWebGLVertexArrayObjectPrototype::Base);

using JSWebGLVertexArrayObjectDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLVertexArrayObject>;

template<> const ClassInfo JSWebGLVertexArrayObjectDOMConstructor::s_info = { "WebGLVertexArrayObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectDOMConstructor) };

template<> JSValue JSWebGLVertexArrayObjectDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLVertexArrayObjectDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLVertexArrayObject"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLVertexArrayObject::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSWebGLVertexArrayObjectPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLVertexArrayObjectConstructor, 0 } },
};

const ClassInfo JSWebGLVertexArrayObjectPrototype::s_info = { "WebGLVertexArrayObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectPrototype) };

void JSWebGLVertexArrayObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLVertexArrayObject::info(), JSWebGLVertexArrayObjectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLVertexArrayObject::s_info = { "WebGLVertexArrayObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObject) };

JSWebGLVertexArrayObject::JSWebGLVertexArrayObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLVertexArrayObject>&& impl)
    : JSDOMWrapper<WebGLVertexArrayObject>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLVertexArrayObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLVertexArrayObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLVertexArrayObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLVertexArrayObjectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLVertexArrayObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLVertexArrayObject>(vm, globalObject);
}

JSValue JSWebGLVertexArrayObject::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLVertexArrayObjectDOMConstructor, DOMConstructorID::WebGLVertexArrayObject>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLVertexArrayObject::destroy(JSC::JSCell* cell)
{
    JSWebGLVertexArrayObject* thisObject = static_cast<JSWebGLVertexArrayObject*>(cell);
    thisObject->JSWebGLVertexArrayObject::~JSWebGLVertexArrayObject();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLVertexArrayObjectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLVertexArrayObjectPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLVertexArrayObject::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebGLVertexArrayObject::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLVertexArrayObject, UseCustomHeapCellType::No>(vm, "JSWebGLVertexArrayObject"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLVertexArrayObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLVertexArrayObject = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLVertexArrayObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLVertexArrayObject = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLVertexArrayObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLVertexArrayObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLVertexArrayObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLVertexArrayObject = jsCast<JSWebGLVertexArrayObject*>(handle.slot()->asCell());
    WebGLVertexArrayObject* owner = &jsWebGLVertexArrayObject->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from WebGLVertexArrayObject"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLVertexArrayObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLVertexArrayObject = static_cast<JSWebGLVertexArrayObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLVertexArrayObject->protectedWrapped().ptr(), jsWebGLVertexArrayObject);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLVertexArrayObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLVertexArrayObjectE[]; }
#endif
template<std::same_as<WebGLVertexArrayObject> T>
static inline void verifyVTable(WebGLVertexArrayObject* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLVertexArrayObject@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22WebGLVertexArrayObjectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLVertexArrayObject has subclasses. If WebGLVertexArrayObject has subclasses that get passed
        // to toJS() we currently require WebGLVertexArrayObject you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLVertexArrayObject>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLVertexArrayObject>(impl.ptr());
#endif
    return createWrapper<WebGLVertexArrayObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLVertexArrayObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLVertexArrayObject* JSWebGLVertexArrayObject::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLVertexArrayObject*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
