/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __XDPSOCK_SKEL_H__
#define __XDPSOCK_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct xdpsock {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *xsks_map;
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *xdp_sock_prog;
	} progs;
	struct {
		struct bpf_link *xdp_sock_prog;
	} links;
	struct xdpsock__bss {
		int num_socks;
	} *bss;

#ifdef __cplusplus
	static inline struct xdpsock *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct xdpsock *open_and_load();
	static inline int load(struct xdpsock *skel);
	static inline int attach(struct xdpsock *skel);
	static inline void detach(struct xdpsock *skel);
	static inline void destroy(struct xdpsock *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
xdpsock__destroy(struct xdpsock *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
xdpsock__create_skeleton(struct xdpsock *obj);

static inline struct xdpsock *
xdpsock__open_opts(const struct bpf_object_open_opts *opts)
{
	struct xdpsock *obj;
	int err;

	obj = (struct xdpsock *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = xdpsock__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	xdpsock__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct xdpsock *
xdpsock__open(void)
{
	return xdpsock__open_opts(NULL);
}

static inline int
xdpsock__load(struct xdpsock *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct xdpsock *
xdpsock__open_and_load(void)
{
	struct xdpsock *obj;
	int err;

	obj = xdpsock__open();
	if (!obj)
		return NULL;
	err = xdpsock__load(obj);
	if (err) {
		xdpsock__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
xdpsock__attach(struct xdpsock *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
xdpsock__detach(struct xdpsock *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *xdpsock__elf_bytes(size_t *sz);

static inline int
xdpsock__create_skeleton(struct xdpsock *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "xdpsock";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "xsks_map";
	map->map = &obj->maps.xsks_map;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "xdpsock.bss";
	map->map = &obj->maps.bss;
	map->mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "xdp_sock_prog";
	s->progs[0].prog = &obj->progs.xdp_sock_prog;
	s->progs[0].link = &obj->links.xdp_sock_prog;

	s->data = xdpsock__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *xdpsock__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x28\x11\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x1a\0\
\x01\0\x18\x01\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\x61\x13\0\0\0\0\0\0\x04\x03\0\0\
\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x04\x02\0\0\
\xff\xff\xff\xff\x5c\x32\0\0\0\0\0\0\x63\x21\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xb7\x03\0\0\x01\0\0\0\x85\0\0\0\x33\0\0\0\x95\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\x11\x01\x25\
\x25\x13\x05\x03\x25\x72\x17\x10\x17\x1b\x25\x11\x1b\x12\x06\x73\x17\0\0\x02\
\x34\0\x03\x25\x49\x13\x3f\x19\x3a\x0b\x3b\x0b\x02\x18\0\0\x03\x24\0\x03\x25\
\x3e\x0b\x0b\x0b\0\0\x04\x34\0\x03\x25\x49\x13\x3a\x0b\x3b\x05\0\0\x05\x26\0\
\x49\x13\0\0\x06\x0f\0\x49\x13\0\0\x07\x15\x01\x49\x13\x27\x19\0\0\x08\x05\0\
\x49\x13\0\0\x09\x0f\0\0\0\x0a\x16\0\x49\x13\x03\x25\x3a\x0b\x3b\x0b\0\0\x0b\
\x13\x01\x0b\x0b\x3a\x0b\x3b\x0b\0\0\x0c\x0d\0\x03\x25\x49\x13\x3a\x0b\x3b\x0b\
\x38\x0b\0\0\x0d\x01\x01\x49\x13\0\0\x0e\x21\0\x49\x13\x37\x0b\0\0\x0f\x24\0\
\x03\x25\x0b\x0b\x3e\x0b\0\0\x10\x34\0\x03\x25\x49\x13\x3a\x0b\x3b\x0b\x02\x18\
\0\0\x11\x04\x01\x49\x13\x03\x25\x0b\x0b\x3a\x0b\x3b\x05\0\0\x12\x28\0\x03\x25\
\x1c\x0f\0\0\x13\x2e\x01\x11\x1b\x12\x06\x40\x18\x7a\x19\x03\x25\x3a\x0b\x3b\
\x0b\x27\x19\x49\x13\x3f\x19\0\0\x14\x05\0\x03\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\
\x15\x13\x01\x03\x25\x0b\x0b\x3a\x0b\x3b\x05\0\0\x16\x0d\0\x03\x25\x49\x13\x3a\
\x0b\x3b\x05\x38\x0b\0\0\0\x53\x01\0\0\x05\0\x01\x08\0\0\0\0\x01\0\x1d\0\x01\
\x08\0\0\0\0\0\0\0\x02\x03\x78\0\0\0\x08\0\0\0\x02\x03\x2e\0\0\0\0\x11\x02\xa1\
\0\x03\x04\x05\x04\x04\x05\x3b\0\0\0\x02\x3a\x05\x05\x40\0\0\0\x06\x45\0\0\0\
\x07\x5a\0\0\0\x08\x5e\0\0\0\x08\x5f\0\0\0\x08\x5f\0\0\0\0\x03\x06\x05\x08\x09\
\x0a\x67\0\0\0\x08\x01\x1f\x03\x07\x07\x08\x02\x09\x76\0\0\0\0\x0f\x02\xa1\x01\
\x0b\x20\0\x0a\x0c\x0a\x9f\0\0\0\0\x0b\0\x0c\x0c\xb4\0\0\0\0\x0c\x08\x0c\x0d\
\xb4\0\0\0\0\x0d\x10\x0c\x0e\xb4\0\0\0\0\x0e\x18\0\x06\xa4\0\0\0\x0d\x2e\0\0\0\
\x0e\xb0\0\0\0\x11\0\x0f\x0b\x08\x07\x06\xb9\0\0\0\x0d\x2e\0\0\0\x0e\xb0\0\0\0\
\x04\0\x10\x0f\xd0\0\0\0\0\x12\x02\xa1\x02\x03\x10\x07\x04\x11\xd0\0\0\0\x16\
\x04\x03\xf2\x17\x12\x11\0\x12\x12\x01\x12\x13\x02\x12\x14\x03\x12\x15\x04\0\
\x13\x03\x78\0\0\0\x01\x5a\x17\0\x15\x2e\0\0\0\x14\x18\0\x15\x06\x01\0\0\0\x06\
\x0b\x01\0\0\x15\x20\x18\x03\xfd\x17\x16\x19\x4e\x01\0\0\x03\xfe\x17\0\x16\x1b\
\x4e\x01\0\0\x03\xff\x17\x04\x16\x1c\x4e\x01\0\0\x03\0\x18\x08\x16\x1d\x4e\x01\
\0\0\x03\x02\x18\x0c\x16\x1e\x4e\x01\0\0\x03\x03\x18\x10\x16\x1f\x4e\x01\0\0\
\x03\x05\x18\x14\0\x0a\xd0\0\0\0\x1a\x01\x1b\0\x88\0\0\0\x05\0\0\0\0\0\0\0\x15\
\0\0\0\x23\0\0\0\x55\0\0\0\x5f\0\0\0\x63\0\0\0\x74\0\0\0\x79\0\0\0\x8c\0\0\0\
\x92\0\0\0\x9b\0\0\0\xa0\0\0\0\xb4\0\0\0\xc0\0\0\0\xc9\0\0\0\xd4\0\0\0\xd7\0\0\
\0\xe4\0\0\0\xf0\0\0\0\xf9\0\0\0\x02\x01\0\0\x09\x01\0\0\x16\x01\0\0\x21\x01\0\
\0\x2f\x01\0\0\x33\x01\0\0\x38\x01\0\0\x3e\x01\0\0\x47\x01\0\0\x51\x01\0\0\x61\
\x01\0\0\x70\x01\0\0\x7f\x01\0\0\x63\x6c\x61\x6e\x67\x20\x76\x65\x72\x73\x69\
\x6f\x6e\x20\x32\x31\x2e\x31\x2e\x38\0\x78\x64\x70\x73\x6f\x63\x6b\x2e\x62\x70\
\x66\x2e\x63\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\
\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\
\x31\x2e\x36\x2e\x31\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x6e\x75\x6d\x5f\x73\
\x6f\x63\x6b\x73\0\x69\x6e\x74\0\x62\x70\x66\x5f\x72\x65\x64\x69\x72\x65\x63\
\x74\x5f\x6d\x61\x70\0\x6c\x6f\x6e\x67\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\
\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x5f\x5f\x75\x36\x34\0\x78\x73\x6b\x73\
\x5f\x6d\x61\x70\0\x74\x79\x70\x65\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\
\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\
\x73\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\0\x76\x61\x6c\x75\x65\x5f\x73\x69\x7a\
\x65\0\x72\x72\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x58\x44\x50\
\x5f\x41\x42\x4f\x52\x54\x45\x44\0\x58\x44\x50\x5f\x44\x52\x4f\x50\0\x58\x44\
\x50\x5f\x50\x41\x53\x53\0\x58\x44\x50\x5f\x54\x58\0\x58\x44\x50\x5f\x52\x45\
\x44\x49\x52\x45\x43\x54\0\x78\x64\x70\x5f\x61\x63\x74\x69\x6f\x6e\0\x78\x64\
\x70\x5f\x73\x6f\x63\x6b\x5f\x70\x72\x6f\x67\0\x63\x74\x78\0\x64\x61\x74\x61\0\
\x5f\x5f\x75\x33\x32\0\x64\x61\x74\x61\x5f\x65\x6e\x64\0\x64\x61\x74\x61\x5f\
\x6d\x65\x74\x61\0\x69\x6e\x67\x72\x65\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\
\0\x72\x78\x5f\x71\x75\x65\x75\x65\x5f\x69\x6e\x64\x65\x78\0\x65\x67\x72\x65\
\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\x78\x64\x70\x5f\x6d\x64\0\x24\0\0\0\
\x05\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\xac\x01\0\0\xac\x01\0\0\x15\x01\0\0\0\0\0\0\0\
\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\
\0\0\0\0\x02\0\0\0\x04\0\0\0\x11\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\
\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x04\
\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x19\0\0\0\x01\0\0\0\0\0\0\0\x1e\0\0\0\x05\
\0\0\0\x40\0\0\0\x2a\0\0\0\x05\0\0\0\x80\0\0\0\x33\0\0\0\x05\0\0\0\xc0\0\0\0\
\x3e\0\0\0\0\0\0\x0e\x07\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\x47\0\0\0\
\x06\0\0\x04\x18\0\0\0\x4e\0\0\0\x0b\0\0\0\0\0\0\0\x53\0\0\0\x0b\0\0\0\x20\0\0\
\0\x5c\0\0\0\x0b\0\0\0\x40\0\0\0\x66\0\0\0\x0b\0\0\0\x60\0\0\0\x76\0\0\0\x0b\0\
\0\0\x80\0\0\0\x85\0\0\0\x0b\0\0\0\xa0\0\0\0\x94\0\0\0\0\0\0\x08\x0c\0\0\0\x9a\
\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xa7\0\0\0\
\x09\0\0\0\xab\0\0\0\x01\0\0\x0c\x0d\0\0\0\xfd\0\0\0\0\0\0\x0e\x02\0\0\0\x01\0\
\0\0\x07\x01\0\0\0\0\0\x0e\x0c\0\0\0\0\0\0\0\x0a\x01\0\0\x02\0\0\x0f\0\0\0\0\
\x0f\0\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x04\0\0\0\x04\0\0\0\x0f\x01\0\0\x01\0\0\
\x0f\0\0\0\0\x08\0\0\0\0\0\0\0\x20\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\
\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x74\x79\x70\x65\0\
\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\
\0\x76\x61\x6c\x75\x65\x5f\x73\x69\x7a\x65\0\x78\x73\x6b\x73\x5f\x6d\x61\x70\0\
\x78\x64\x70\x5f\x6d\x64\0\x64\x61\x74\x61\0\x64\x61\x74\x61\x5f\x65\x6e\x64\0\
\x64\x61\x74\x61\x5f\x6d\x65\x74\x61\0\x69\x6e\x67\x72\x65\x73\x73\x5f\x69\x66\
\x69\x6e\x64\x65\x78\0\x72\x78\x5f\x71\x75\x65\x75\x65\x5f\x69\x6e\x64\x65\x78\
\0\x65\x67\x72\x65\x73\x73\x5f\x69\x66\x69\x6e\x64\x65\x78\0\x5f\x5f\x75\x33\
\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x63\x74\x78\0\x78\x64\
\x70\x5f\x73\x6f\x63\x6b\x5f\x70\x72\x6f\x67\0\x78\x64\x70\0\x2f\x75\x73\x72\
\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\
\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\x31\x2e\x36\x2e\x31\x2f\x6c\
\x69\x62\x2f\x75\x74\x69\x6c\x2f\x78\x64\x70\x73\x6f\x63\x6b\x2e\x62\x70\x66\
\x2e\x63\0\x6e\x75\x6d\x5f\x73\x6f\x63\x6b\x73\0\x72\x72\0\x2e\x62\x73\x73\0\
\x2e\x6d\x61\x70\x73\0\0\0\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\
\0\x8c\0\0\0\xa0\0\0\0\0\0\0\0\x08\0\0\0\xb9\0\0\0\x01\0\0\0\0\0\0\0\x0e\0\0\0\
\x10\0\0\0\xb9\0\0\0\x08\0\0\0\0\0\0\0\xbd\0\0\0\0\0\0\0\x08\x5c\0\0\x18\0\0\0\
\xbd\0\0\0\0\0\0\0\x0b\x5c\0\0\x20\0\0\0\xbd\0\0\0\0\0\0\0\x13\x5c\0\0\x38\0\0\
\0\xbd\0\0\0\0\0\0\0\x1d\x5c\0\0\x40\0\0\0\xbd\0\0\0\0\0\0\0\x10\x5c\0\0\x48\0\
\0\0\xbd\0\0\0\0\0\0\0\x05\x5c\0\0\x50\0\0\0\xbd\0\0\0\0\0\0\0\x09\x60\0\0\x70\
\0\0\0\xbd\0\0\0\0\0\0\0\x02\x60\0\0\0\0\0\0\x0c\0\0\0\xff\xff\xff\xff\x04\0\
\x08\0\x08\x7c\x0b\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\0\0\0\0\0\0\0\xb6\0\
\0\0\x05\0\x08\0\x7e\0\0\0\x08\x01\x01\xfb\x0e\x0d\0\x01\x01\x01\x01\0\0\0\x01\
\0\0\x01\x01\x01\x1f\x03\0\0\0\0\x32\0\0\0\x37\0\0\0\x03\x01\x1f\x02\x0f\x05\
\x1e\x04\x4b\0\0\0\0\xf8\xa7\xd5\x3c\xc1\x8c\x0f\xbd\xd2\x1b\xef\x2c\xd6\xfe\
\xb9\xad\x59\0\0\0\x01\xb8\x10\xf2\x70\x73\x3e\x10\x63\x19\xb6\x7e\xf5\x12\xc6\
\x24\x6e\x78\0\0\0\x01\x11\xf0\x96\x23\xd7\x23\0\x81\x24\x7a\xfa\xcd\xc7\xc1\
\xa6\x41\x96\0\0\0\x02\xe3\x56\xfe\x73\xb5\x69\xa5\xa8\xf8\xd7\x71\x4d\xf6\xd1\
\xc0\xa5\x04\0\x05\x08\x0a\0\x09\x02\0\0\0\0\0\0\0\0\x03\x16\x01\x05\x0b\x06\
\x3c\x05\x13\x20\x05\x1d\x3c\x05\x10\x20\x05\x05\x20\x05\x09\x06\x21\x05\x02\
\x06\x4a\x02\x01\0\x01\x01\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\
\x67\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\
\x6c\x73\x2d\x31\x2e\x36\x2e\x31\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x2f\x75\
\x73\x72\0\x2e\x2e\x2f\x2e\x2e\x2f\x68\x65\x61\x64\x65\x72\x73\x2f\x6c\x69\x6e\
\x75\x78\0\x78\x64\x70\x73\x6f\x63\x6b\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x63\
\x6c\x75\x64\x65\x2f\x61\x73\x6d\x2d\x67\x65\x6e\x65\x72\x69\x63\x2f\x69\x6e\
\x74\x2d\x6c\x6c\x36\x34\x2e\x68\0\x69\x6e\x63\x6c\x75\x64\x65\x2f\x62\x70\x66\
\x2f\x62\x70\x66\x5f\x68\x65\x6c\x70\x65\x72\x5f\x64\x65\x66\x73\x2e\x68\0\x62\
\x70\x66\x2e\x68\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xda\0\0\
\0\x04\0\xf1\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x69\0\0\0\x01\0\x05\0\x04\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\
\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x03\0\x0c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0d\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x03\0\x15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x17\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9d\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x78\0\0\0\0\
\0\0\0\x44\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x84\0\0\0\x11\0\
\x06\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\
\x20\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x50\0\0\0\0\0\0\0\x01\0\0\0\x0e\0\0\0\
\x08\0\0\0\0\0\0\0\x03\0\0\0\x05\0\0\0\x11\0\0\0\0\0\0\0\x03\0\0\0\x06\0\0\0\
\x15\0\0\0\0\0\0\0\x03\0\0\0\x0a\0\0\0\x1f\0\0\0\0\0\0\0\x03\0\0\0\x08\0\0\0\
\x08\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x0c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x10\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x14\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x18\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x1c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x20\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x24\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x28\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x2c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x30\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x34\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x38\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x3c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x40\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x44\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x48\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x4c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x50\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x54\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x58\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x5c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x60\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x64\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x68\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x6c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x70\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x74\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x78\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x7c\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x80\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x84\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\
\x88\0\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x02\0\0\0\x0d\0\0\0\
\x10\0\0\0\0\0\0\0\x02\0\0\0\x0e\0\0\0\x18\0\0\0\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x20\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x98\x01\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\0\
\xa4\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xbc\x01\0\0\0\0\0\0\x04\0\0\0\x0e\0\0\
\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x50\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x70\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x90\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\xb0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x14\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\
\x18\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x22\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\
\x26\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x2a\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\
\x36\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x4b\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\
\x60\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\x75\0\0\0\0\0\0\0\x03\0\0\0\x0b\0\0\0\
\x92\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x0c\x0e\0\x2e\x64\x65\x62\x75\x67\x5f\
\x61\x62\x62\x72\x65\x76\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\
\x46\x2e\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x73\x74\x72\
\x5f\x6f\x66\x66\x73\x65\x74\x73\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x6e\
\x75\x6d\x5f\x73\x6f\x63\x6b\x73\0\x2e\x64\x65\x62\x75\x67\x5f\x73\x74\x72\0\
\x2e\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\x5f\x73\x74\x72\0\x72\x72\0\x2e\
\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x61\x64\x64\x72\0\x2e\x72\x65\x6c\x78\
\x64\x70\0\x78\x73\x6b\x73\x5f\x6d\x61\x70\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\
\x75\x67\x5f\x69\x6e\x66\x6f\0\x78\x64\x70\x5f\x73\x6f\x63\x6b\x5f\x70\x72\x6f\
\x67\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x2e\x72\x65\x6c\
\x2e\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\
\x75\x67\x5f\x66\x72\x61\x6d\x65\0\x78\x64\x70\x73\x6f\x63\x6b\x2e\x62\x70\x66\
\x2e\x63\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\
\x65\x6c\x2e\x42\x54\x46\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xe8\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x22\x10\0\0\0\0\0\
\0\x01\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\0\
\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\0\0\0\x01\0\0\0\x06\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x78\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7c\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x0c\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x19\0\0\0\x03\0\0\0\x08\0\0\
\0\0\0\0\0\x10\0\0\0\0\0\0\0\x39\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xb8\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x3e\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb8\0\0\0\0\
\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd8\0\0\0\0\0\0\0\x0f\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x91\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe7\x01\0\0\0\0\0\0\x57\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x8d\0\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x30\x0c\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x19\0\0\0\x08\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x26\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x3e\x03\0\0\0\0\0\0\x8c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x22\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\
\x0c\0\0\0\0\0\0\x10\x02\0\0\0\0\0\0\x19\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\
\0\0\0\0\0\0\0\x4e\0\0\0\x01\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xca\x03\0\
\0\0\0\0\0\x86\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\x70\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x05\0\0\0\0\0\0\
\x28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6c\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x0e\0\0\0\0\0\0\x40\0\0\0\0\0\
\0\0\x19\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xfc\0\0\0\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x05\0\0\0\0\0\0\xd9\x02\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\0\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xc0\x0e\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x19\0\0\0\x0f\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x19\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x54\x08\0\0\0\0\0\0\xc0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x15\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xf0\x0e\0\0\0\0\0\0\x90\0\0\0\0\0\0\0\x19\0\0\0\x11\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\xcd\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x09\
\0\0\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xc9\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x0f\0\0\0\0\0\0\
\x20\0\0\0\0\0\0\0\x19\0\0\0\x13\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xbd\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x09\0\0\0\0\0\0\xba\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb9\0\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x0f\0\0\0\0\0\0\x80\0\0\0\0\0\0\0\x19\0\
\0\0\x15\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x59\0\0\0\x01\0\0\0\x30\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xfa\x09\0\0\0\0\0\0\x9c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\xab\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\
\0\0\0\0\0\0\0\0\0\0\x20\x10\0\0\0\0\0\0\x02\0\0\0\0\0\0\0\x19\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x98\x0a\0\0\0\0\0\0\x68\x01\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x08\0\0\0\
\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct xdpsock *xdpsock::open(const struct bpf_object_open_opts *opts) { return xdpsock__open_opts(opts); }
struct xdpsock *xdpsock::open_and_load() { return xdpsock__open_and_load(); }
int xdpsock::load(struct xdpsock *skel) { return xdpsock__load(skel); }
int xdpsock::attach(struct xdpsock *skel) { return xdpsock__attach(skel); }
void xdpsock::detach(struct xdpsock *skel) { xdpsock__detach(skel); }
void xdpsock::destroy(struct xdpsock *skel) { xdpsock__destroy(skel); }
const void *xdpsock::elf_bytes(size_t *sz) { return xdpsock__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
xdpsock__assert(struct xdpsock *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->num_socks) == 4, "unexpected size of 'num_socks'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __XDPSOCK_SKEL_H__ */
