// OscilgenUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef OscilGenUI_h
#define OscilGenUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2016-2023 Will Godfrey and others.

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include "ResonanceUI.h"
#include <FL/Fl_Box.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Slider.H>
#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetPDial.h"
#include "UI/WidgetMWSlider.h"
#include "UI/ScaleTrackedWindow.h"
#include "EnvelopeUI.h"
#include "LFOUI.h"
#include "FilterUI.h"
#include "PresetsUI.h"
#include "Synth/OscilGen.h"
#include "Misc/Config.h"
#include "Misc/SynthEngine.h"

class OscilSpectrum : public Fl_Box {
public:
  OscilSpectrum(int x,int y, int w, int h, const char *label=0);
  void init(OscilGen *oscilSmp_,int oscbase_, SynthEngine *_synth);
  void draw();
private:
  OscilGen *oscilSmp;
  int oscbase;
  SynthEngine *synth;
};

class PSlider : public mwheel_slider {
public:
  PSlider(int x,int y, int w, int h, const char *label=0);
  void update_selection_color(int new_value);
  double value();
  int value(double val);
  int handle(int event);
};

class Oscilloscope : public Fl_Box {
public:
  Oscilloscope(int x,int y, int w, int h, int frame_, const char *label=0);
  void init(OscilGen *oscilSmp_, SynthEngine *_synth);
  void init(OscilGen *oscilSmp_,int oscbase_, SynthEngine *_synth);
  void init(OscilGen *oscilSmp_,int oscbase_,int phase_, SynthEngine *_synth);
  void draw();
private:
  OscilGen *oscilSmp;
  int oscbase;
public:
  int phase;
  int frame;
private:
  SynthEngine *synth;
};
#include <FL/Fl_Box.H>

class Oscilharmonic : public Fl_Group {
  Fl_Group* make_window();
  Fl_Group *harmonic;
public:
  mwheel_slider *mag;
private:
  inline void cb_mag_i(mwheel_slider*, void*);
  static void cb_mag(mwheel_slider*, void*);
public:
  mwheel_slider *phase;
private:
  inline void cb_phase_i(mwheel_slider*, void*);
  static void cb_phase(mwheel_slider*, void*);
public:
  Fl_Box *magblock;
  Fl_Box *phaseblock;
  Fl_Box *number;
  Oscilharmonic(int x,int y, int w, int h, const char *label=0);
  void send_data(int action, int insert, int control, float value, int type);
  void init(OscilParameters *oscil_,int n_,Fl_Group *display_,Fl_Widget *oldosc_,Fl_Widget *cbwidget_,Fl_Widget *applybutton_, SynthEngine *_synth, int npart_, int kititem_, int engine_);
  void refresh(int def = 0);
  ~Oscilharmonic();
private:
  OscilParameters *oscil;
  Fl_Group *display;
  int n;
  Fl_Widget *oldosc,*cbwidget,*applybutton;
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
};
#include <FL/Fl_Button.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Pack.H>

class OscilEditor : public PresetsUI_ {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *osceditUI;
private:
  inline void cb_osceditUI_i(ScaleTrackedWindow*, void*);
  static void cb_osceditUI(ScaleTrackedWindow*, void*);
public:
  Fl_Button *applybutton;
private:
  inline void cb_applybutton_i(Fl_Button*, void*);
  static void cb_applybutton(Fl_Button*, void*);
public:
  Fl_Group *oscildisplaygroup;
  Fl_Group *waveformgroup;
  Fl_Group *harmonicgroup;
  Fl_Choice *hrndtype;
private:
  inline void cb_hrndtype_i(Fl_Choice*, void*);
  static void cb_hrndtype(Fl_Choice*, void*);
public:
  WidgetPDial *hrnddial;
private:
  inline void cb_hrnddial_i(WidgetPDial*, void*);
  static void cb_hrnddial(WidgetPDial*, void*);
public:
  Fl_Box *oscilname;
  mwheel_val_slider_rev *rndslider;
private:
  inline void cb_rndslider_i(mwheel_val_slider_rev*, void*);
  static void cb_rndslider(mwheel_val_slider_rev*, void*);
public:
  Fl_Group *basefuncdisplaygroup;
  Fl_Group *basewave;
  WidgetPDial *bfknob;
private:
  inline void cb_bfknob_i(WidgetPDial*, void*);
  static void cb_bfknob(WidgetPDial*, void*);
public:
  Fl_Choice *bftype;
private:
  inline void cb_bftype_i(Fl_Choice*, void*);
  static void cb_bftype(Fl_Choice*, void*);
public:
  Fl_Box *basename;
  Fl_Group *baseharm;
  Fl_Box *parname;
  Fl_Value_Output *bfparval;
  Fl_Group *basefuncmodulation;
  Fl_Group *baseFuncPars;
  WidgetPDial *bfmodpar1;
private:
  inline void cb_bfmodpar1_i(WidgetPDial*, void*);
  static void cb_bfmodpar1(WidgetPDial*, void*);
public:
  WidgetPDial *bfmodpar2;
private:
  inline void cb_bfmodpar2_i(WidgetPDial*, void*);
  static void cb_bfmodpar2(WidgetPDial*, void*);
public:
  WidgetPDial *bfmodpar3;
private:
  inline void cb_bfmodpar3_i(WidgetPDial*, void*);
  static void cb_bfmodpar3(WidgetPDial*, void*);
public:
  Fl_Choice *bfmodtype;
private:
  inline void cb_bfmodtype_i(Fl_Choice*, void*);
  static void cb_bfmodtype(Fl_Choice*, void*);
public:
  Fl_Output *Warning;
  Fl_Choice *magtype;
private:
  inline void cb_magtype_i(Fl_Choice*, void*);
  static void cb_magtype(Fl_Choice*, void*);
public:
  Fl_Button *useasbase;
private:
  inline void cb_useasbase_i(Fl_Button*, void*);
  static void cb_useasbase(Fl_Button*, void*);
public:
  Fl_Button *oscilClose;
private:
  inline void cb_oscilClose_i(Fl_Button*, void*);
  static void cb_oscilClose(Fl_Button*, void*);
public:
  Fl_Button *clearHarm;
private:
  inline void cb_clearHarm_i(Fl_Button*, void*);
  static void cb_clearHarm(Fl_Button*, void*);
public:
  Fl_Choice *wshbutton;
private:
  inline void cb_wshbutton_i(Fl_Choice*, void*);
  static void cb_wshbutton(Fl_Choice*, void*);
public:
  WidgetPDial *wshpar;
private:
  inline void cb_wshpar_i(WidgetPDial*, void*);
  static void cb_wshpar(WidgetPDial*, void*);
public:
  Fl_Value_Output *wsparval;
  Fl_Light_Button *autoclearbutton;
private:
  inline void cb_autoclearbutton_i(Fl_Light_Button*, void*);
  static void cb_autoclearbutton(Fl_Light_Button*, void*);
public:
  Fl_Group *filterGroup;
  WidgetPDial *filtervalue1;
private:
  inline void cb_filtervalue1_i(WidgetPDial*, void*);
  static void cb_filtervalue1(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *filterpref;
private:
  inline void cb_filterpref_i(Fl_Check_Button2*, void*);
  static void cb_filterpref(Fl_Check_Button2*, void*);
public:
  WidgetPDial *filtervalue2;
private:
  inline void cb_filtervalue2_i(WidgetPDial*, void*);
  static void cb_filtervalue2(WidgetPDial*, void*);
public:
  Fl_Choice *fltbutton;
private:
  inline void cb_fltbutton_i(Fl_Choice*, void*);
  static void cb_fltbutton(Fl_Choice*, void*);
public:
  Fl_Choice *sabutton;
private:
  inline void cb_sabutton_i(Fl_Choice*, void*);
  static void cb_sabutton(Fl_Choice*, void*);
public:
  WidgetPDial *sadjpar;
private:
  inline void cb_sadjpar_i(WidgetPDial*, void*);
  static void cb_sadjpar(WidgetPDial*, void*);
public:
  Fl_Counter *harmonicshiftcounter;
private:
  inline void cb_harmonicshiftcounter_i(Fl_Counter*, void*);
  static void cb_harmonicshiftcounter(Fl_Counter*, void*);
public:
  Fl_Check_Button2 *harmonicshiftpre;
private:
  inline void cb_harmonicshiftpre_i(Fl_Check_Button2*, void*);
  static void cb_harmonicshiftpre(Fl_Check_Button2*, void*);
public:
  Fl_Group *adaptiveGroup;
  WidgetPDial *adhrpow;
private:
  inline void cb_adhrpow_i(WidgetPDial*, void*);
  static void cb_adhrpow(WidgetPDial*, void*);
public:
  WidgetPDial *adhrbf;
private:
  inline void cb_adhrbf_i(WidgetPDial*, void*);
  static void cb_adhrbf(WidgetPDial*, void*);
public:
  mwheel_slider_rev *adhrpar;
private:
  inline void cb_adhrpar_i(mwheel_slider_rev*, void*);
  static void cb_adhrpar(mwheel_slider_rev*, void*);
public:
  Fl_Choice *adhrtype;
private:
  inline void cb_adhrtype_i(Fl_Choice*, void*);
  static void cb_adhrtype(Fl_Choice*, void*);
public:
  Fl_Group *modulationGroup;
  WidgetPDial *modpar1;
private:
  inline void cb_modpar1_i(WidgetPDial*, void*);
  static void cb_modpar1(WidgetPDial*, void*);
public:
  WidgetPDial *modpar2;
private:
  inline void cb_modpar2_i(WidgetPDial*, void*);
  static void cb_modpar2(WidgetPDial*, void*);
public:
  WidgetPDial *modpar3;
private:
  inline void cb_modpar3_i(WidgetPDial*, void*);
  static void cb_modpar3(WidgetPDial*, void*);
public:
  Fl_Choice *modtype;
private:
  inline void cb_modtype_i(Fl_Choice*, void*);
  static void cb_modtype(Fl_Choice*, void*);
public:
  Fl_Button *tosine;
private:
  inline void cb_tosine_i(Fl_Button*, void*);
  static void cb_tosine(Fl_Button*, void*);
public:
  Fl_Button *oscilC;
private:
  inline void cb_oscilC_i(Fl_Button*, void*);
  static void cb_oscilC(Fl_Button*, void*);
public:
  Fl_Button *oscilP;
private:
  inline void cb_oscilP_i(Fl_Button*, void*);
  static void cb_oscilP(Fl_Button*, void*);
public:
  Fl_Scroll *frame;
  Fl_Pack *harmonics;
  void send_data(int action, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  OscilEditor(OscilParameters *oscil_, Fl_Widget *oldosc_, Fl_Widget *cbwidget_, Fl_Widget *cbapplywidget_, SynthEngine *_synth, int npart_, int kititem_, int engine_, bool forPAD_ =false);
  virtual ~OscilEditor();
  void refresh();
  void setWindowTitle();
  void redrawoscil();
  void waveRtext();
private:
  OscilParameters *oscil;
  fft::Calc *fft;
  OscilGen *oscilSmp;
  Fl_Widget *oldosc,*cbwidget,*cbapplywidget;
  Oscilharmonic *h[MAX_AD_HARMONICS];
  int npart;
  int kititem;
  int engine;
  int waveDW;
  int waveDH;
  int waveType;
  bool OSCseen;
  SynthEngine *synth;
  bool forPAD;
};
#endif
