/* extension.c generated by valac 0.56.17, the Vala compiler
 * generated from extension.vala, do not modify */

/* extension.vala
 *
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-engine.h"
#include <glib.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_EXTENSION_0_PROPERTY,
	ZEITGEIST_EXTENSION_ENGINE_PROPERTY,
	ZEITGEIST_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_properties[ZEITGEIST_EXTENSION_NUM_PROPERTIES];
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
enum  {
	ZEITGEIST_EXTENSION_LOADER_0_PROPERTY,
	ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY,
	ZEITGEIST_EXTENSION_LOADER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_loader_properties[ZEITGEIST_EXTENSION_LOADER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ZEITGEIST_MODULE_LOADER_0_PROPERTY,
	ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY,
	ZEITGEIST_MODULE_LOADER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_module_loader_properties[ZEITGEIST_MODULE_LOADER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
enum  {
	ZEITGEIST_BUILTIN_EXTENSION_0_PROPERTY,
	ZEITGEIST_BUILTIN_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_builtin_extension_properties[ZEITGEIST_BUILTIN_EXTENSION_NUM_PROPERTIES];

struct _ZeitgeistExtensionPrivate {
	ZeitgeistEngine* _engine;
};

struct _ZeitgeistExtensionLoaderPrivate {
	GType _extension_type;
};

struct _ZeitgeistModuleLoaderPrivate {
	gchar* _module_path;
	GModule* module;
};

struct _ZeitgeistBuiltinExtensionPrivate {
	ZeitgeistRegisterExtensionFunc reg_func;
};

static gint ZeitgeistExtension_private_offset;
static gpointer zeitgeist_extension_parent_class = NULL;
static gint ZeitgeistExtensionLoader_private_offset;
static gpointer zeitgeist_extension_loader_parent_class = NULL;
static gint ZeitgeistModuleLoader_private_offset;
static gpointer zeitgeist_module_loader_parent_class = NULL;
static gint ZeitgeistBuiltinExtension_private_offset;
static gpointer zeitgeist_builtin_extension_parent_class = NULL;

static void zeitgeist_extension_real_unload (ZeitgeistExtension* self);
static void zeitgeist_extension_real_pre_insert_events (ZeitgeistExtension* self,
                                                 GPtrArray* events,
                                                 const char* sender);
static void zeitgeist_extension_real_post_insert_events (ZeitgeistExtension* self,
                                                  GPtrArray* events,
                                                  const char* sender);
static guint32* zeitgeist_extension_real_pre_delete_events (ZeitgeistExtension* self,
                                                     guint32* ids,
                                                     gint ids_length1,
                                                     const char* sender,
                                                     gint* result_length1);
static void zeitgeist_extension_real_post_delete_events (ZeitgeistExtension* self,
                                                  guint32* ids,
                                                  gint ids_length1,
                                                  const char* sender);
static void zeitgeist_extension_finalize (GObject * obj);
static GType zeitgeist_extension_get_type_once (void);
static void _vala_zeitgeist_extension_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_zeitgeist_extension_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static ZeitgeistExtension* zeitgeist_extension_loader_real_create_instance (ZeitgeistExtensionLoader* self,
                                                                     ZeitgeistEngine* engine);
static void zeitgeist_extension_loader_finalize (GObject * obj);
static GType zeitgeist_extension_loader_get_type_once (void);
static void _vala_zeitgeist_extension_loader_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_zeitgeist_extension_loader_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static gboolean zeitgeist_module_loader_real_load (GTypeModule* base);
static void zeitgeist_module_loader_real_unload (GTypeModule* base);
static GObject * zeitgeist_module_loader_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void zeitgeist_module_loader_finalize (GObject * obj);
static GType zeitgeist_module_loader_get_type_once (void);
static void _vala_zeitgeist_module_loader_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_zeitgeist_module_loader_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static gboolean zeitgeist_builtin_extension_real_load (GTypeModule* base);
static void zeitgeist_builtin_extension_real_unload (GTypeModule* base);
static GObject * zeitgeist_builtin_extension_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void zeitgeist_builtin_extension_finalize (GObject * obj);
static GType zeitgeist_builtin_extension_get_type_once (void);

static inline gpointer
zeitgeist_extension_get_instance_private (ZeitgeistExtension* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistExtension_private_offset);
}

/**
         * This method gets called before Zeitgeist stops.
         *
         * Execution of this method isn't guaranteed, and you shouldn't do
         * anything slow in there.
         */
static void
zeitgeist_extension_real_unload (ZeitgeistExtension* self)
{
}

void
zeitgeist_extension_unload (ZeitgeistExtension* self)
{
	ZeitgeistExtensionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ZEITGEIST_EXTENSION_GET_CLASS (self);
	if (_klass_->unload) {
		_klass_->unload (self);
	}
}

/**
         * Hook applied to all events before they are inserted into the
         * log. The returned event is progressively passed through all
         * extensions before the final result is inserted.
         *
         * To block an event completely simply replace it with NULL.
         * The event may also be modified or completely substituted for
         * another event.
         *
         * @param events: A GenericArray of Event instances
         * @param sender: The D-Bus bus name of the client or NULL
         */
static void
zeitgeist_extension_real_pre_insert_events (ZeitgeistExtension* self,
                                            GPtrArray* events,
                                            const char* sender)
{
	g_return_if_fail (events != NULL);
}

void
zeitgeist_extension_pre_insert_events (ZeitgeistExtension* self,
                                       GPtrArray* events,
                                       const char* sender)
{
	ZeitgeistExtensionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ZEITGEIST_EXTENSION_GET_CLASS (self);
	if (_klass_->pre_insert_events) {
		_klass_->pre_insert_events (self, events, sender);
	}
}

/**
         * Hook applied to all events after they are inserted into the log.
         *
         * The inserted events will have been updated to include their new
         * ID.
         *
         * @param events: A GenericArray of Event instances
         * @param sender: The D-Bus bus name of the client or NULL
         */
static void
zeitgeist_extension_real_post_insert_events (ZeitgeistExtension* self,
                                             GPtrArray* events,
                                             const char* sender)
{
	g_return_if_fail (events != NULL);
}

void
zeitgeist_extension_post_insert_events (ZeitgeistExtension* self,
                                        GPtrArray* events,
                                        const char* sender)
{
	ZeitgeistExtensionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ZEITGEIST_EXTENSION_GET_CLASS (self);
	if (_klass_->post_insert_events) {
		_klass_->post_insert_events (self, events, sender);
	}
}

/**
         * Hook applied before events are deleted from the log.
         *
         * @param ids: A list with the IDs of the events whose deletion
         *     is being requested
         * @param sender: The unique DBus name for the client triggering
         *     the delete, or NULL
         * @return: The filtered list of event IDs which should be deleted,
         *     or NULL to specify no change
         */
static guint32*
zeitgeist_extension_real_pre_delete_events (ZeitgeistExtension* self,
                                            guint32* ids,
                                            gint ids_length1,
                                            const char* sender,
                                            gint* result_length1)
{
	guint32* _tmp0_;
	gint _tmp0__length1;
	guint32* result;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}

guint32*
zeitgeist_extension_pre_delete_events (ZeitgeistExtension* self,
                                       guint32* ids,
                                       gint ids_length1,
                                       const char* sender,
                                       gint* result_length1)
{
	ZeitgeistExtensionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ZEITGEIST_EXTENSION_GET_CLASS (self);
	if (_klass_->pre_delete_events) {
		return _klass_->pre_delete_events (self, ids, ids_length1, sender, result_length1);
	}
	return NULL;
}

/**
         * Hook applied after events have been deleted from the log.
         *
         * @param ids: A list with the IDs of the events that have been deleted
         * @param sender: The unique DBus name for the client triggering the delete
         */
static void
zeitgeist_extension_real_post_delete_events (ZeitgeistExtension* self,
                                             guint32* ids,
                                             gint ids_length1,
                                             const char* sender)
{
}

void
zeitgeist_extension_post_delete_events (ZeitgeistExtension* self,
                                        guint32* ids,
                                        gint ids_length1,
                                        const char* sender)
{
	ZeitgeistExtensionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ZEITGEIST_EXTENSION_GET_CLASS (self);
	if (_klass_->post_delete_events) {
		_klass_->post_delete_events (self, ids, ids_length1, sender);
	}
}

/**
         * Store `data' under the given (extension unique) key, overwriting any
         * previous value.
         */
void
zeitgeist_extension_store_config (ZeitgeistExtension* self,
                                  const gchar* key,
                                  GVariant* data)
{
	ZeitgeistEngine* _tmp0_;
	ZeitgeistExtensionStore* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->_engine;
	_tmp1_ = _tmp0_->extension_store;
	_tmp2_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
	zeitgeist_extension_store_store (_tmp1_, _tmp2_, key, data);
}

/**
         * Retrieve data this extension previously stored under the given key,
         * or null if there is no such data.
         *
         * @param key: key under which the data is stored
         * @param format: type string for the resulting Variant
         */
GVariant*
zeitgeist_extension_retrieve_config (ZeitgeistExtension* self,
                                     const gchar* key,
                                     const gchar* format)
{
	GVariantType* type = NULL;
	GVariantType* _tmp0_;
	ZeitgeistEngine* _tmp1_;
	ZeitgeistExtensionStore* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_variant_type_new (format);
	type = _tmp0_;
	_tmp1_ = self->priv->_engine;
	_tmp2_ = _tmp1_->extension_store;
	_tmp3_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
	_tmp4_ = zeitgeist_extension_store_retrieve (_tmp2_, _tmp3_, key, type);
	result = _tmp4_;
	_g_variant_type_free0 (type);
	return result;
}

ZeitgeistExtension*
zeitgeist_extension_construct (GType object_type)
{
	ZeitgeistExtension * self = NULL;
	self = (ZeitgeistExtension*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistEngine*
zeitgeist_extension_get_engine (ZeitgeistExtension* self)
{
	ZeitgeistEngine* result;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}

void
zeitgeist_extension_set_engine (ZeitgeistExtension* self,
                                ZeitgeistEngine* value)
{
	ZeitgeistEngine* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_extension_get_engine (self);
	if (old_value != value) {
		self->priv->_engine = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_extension_properties[ZEITGEIST_EXTENSION_ENGINE_PROPERTY]);
	}
}

static void
zeitgeist_extension_class_init (ZeitgeistExtensionClass * klass,
                                gpointer klass_data)
{
	zeitgeist_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistExtension_private_offset);
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension*)) zeitgeist_extension_real_unload;
	((ZeitgeistExtensionClass *) klass)->pre_insert_events = (void (*) (ZeitgeistExtension*, GPtrArray*, const char*)) zeitgeist_extension_real_pre_insert_events;
	((ZeitgeistExtensionClass *) klass)->post_insert_events = (void (*) (ZeitgeistExtension*, GPtrArray*, const char*)) zeitgeist_extension_real_post_insert_events;
	((ZeitgeistExtensionClass *) klass)->pre_delete_events = (guint32* (*) (ZeitgeistExtension*, guint32*, gint, const char*, gint*)) zeitgeist_extension_real_pre_delete_events;
	((ZeitgeistExtensionClass *) klass)->post_delete_events = (void (*) (ZeitgeistExtension*, guint32*, gint, const char*)) zeitgeist_extension_real_post_delete_events;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_ENGINE_PROPERTY, zeitgeist_extension_properties[ZEITGEIST_EXTENSION_ENGINE_PROPERTY] = g_param_spec_object ("engine", "engine", "engine", ZEITGEIST_TYPE_ENGINE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
zeitgeist_extension_instance_init (ZeitgeistExtension * self,
                                   gpointer klass)
{
	self->priv = zeitgeist_extension_get_instance_private (self);
}

static void
zeitgeist_extension_finalize (GObject * obj)
{
	ZeitgeistExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension);
	G_OBJECT_CLASS (zeitgeist_extension_parent_class)->finalize (obj);
}

/**
     * Base class for all extensions
     *
     * The constructor of an Extension object takes the Engine object
     * it extends as the only argument.
     *
     * Extensions have a set of hooks with which they can control how
     * events are inserted and retrieved from the log.
     *
     * Additionally, extensions may create their own D-Bus interface
     * over which they can expose their own methods.
     */
static GType
zeitgeist_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtension), 0, (GInstanceInitFunc) zeitgeist_extension_instance_init, NULL };
	GType zeitgeist_extension_type_id;
	zeitgeist_extension_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtension", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ZeitgeistExtension_private_offset = g_type_add_instance_private (zeitgeist_extension_type_id, sizeof (ZeitgeistExtensionPrivate));
	return zeitgeist_extension_type_id;
}

GType
zeitgeist_extension_get_type (void)
{
	static volatile gsize zeitgeist_extension_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_extension_type_id__once)) {
		GType zeitgeist_extension_type_id;
		zeitgeist_extension_type_id = zeitgeist_extension_get_type_once ();
		g_once_init_leave (&zeitgeist_extension_type_id__once, zeitgeist_extension_type_id);
	}
	return zeitgeist_extension_type_id__once;
}

static void
_vala_zeitgeist_extension_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ZeitgeistExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_ENGINE_PROPERTY:
		g_value_set_object (value, zeitgeist_extension_get_engine (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_extension_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ZeitgeistExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_ENGINE_PROPERTY:
		zeitgeist_extension_set_engine (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
zeitgeist_extension_loader_get_instance_private (ZeitgeistExtensionLoader* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistExtensionLoader_private_offset);
}

static ZeitgeistExtension*
zeitgeist_extension_loader_real_create_instance (ZeitgeistExtensionLoader* self,
                                                 ZeitgeistEngine* engine)
{
	ZeitgeistExtension* result;
	g_return_val_if_fail (engine != NULL, NULL);
	if (g_type_module_use ((GTypeModule*) self)) {
		GType _tmp0_;
		ZeitgeistExtension* instance = NULL;
		GType _tmp1_;
		GObject* _tmp2_;
		GObject* _tmp3_;
		ZeitgeistExtension* _tmp4_;
		GType _tmp5_;
		const gchar* _tmp6_;
		_tmp0_ = self->priv->_extension_type;
		if (_tmp0_ == G_TYPE_INVALID) {
			result = NULL;
			return result;
		}
		_tmp1_ = self->priv->_extension_type;
		_tmp2_ = g_object_new (_tmp1_, "engine", engine, NULL);
		_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
		_tmp4_ = ZEITGEIST_IS_EXTENSION (_tmp3_) ? ((ZeitgeistExtension*) _tmp3_) : NULL;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (_tmp3_);
		}
		instance = _tmp4_;
		_tmp5_ = self->priv->_extension_type;
		_tmp6_ = g_type_name (_tmp5_);
		g_debug ("extension.vala:146: Loaded extension: %s", _tmp6_);
		g_type_module_unuse ((GTypeModule*) self);
		result = instance;
		return result;
	}
	result = NULL;
	return result;
}

ZeitgeistExtension*
zeitgeist_extension_loader_create_instance (ZeitgeistExtensionLoader* self,
                                            ZeitgeistEngine* engine)
{
	ZeitgeistExtensionLoaderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ZEITGEIST_EXTENSION_LOADER_GET_CLASS (self);
	if (_klass_->create_instance) {
		return _klass_->create_instance (self, engine);
	}
	return NULL;
}

ZeitgeistExtensionLoader*
zeitgeist_extension_loader_construct (GType object_type)
{
	ZeitgeistExtensionLoader * self = NULL;
	self = (ZeitgeistExtensionLoader*) g_object_new (object_type, NULL);
	return self;
}

GType
zeitgeist_extension_loader_get_extension_type (ZeitgeistExtensionLoader* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_extension_type;
	return result;
}

void
zeitgeist_extension_loader_set_extension_type (ZeitgeistExtensionLoader* self,
                                               GType value)
{
	GType old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_extension_loader_get_extension_type (self);
	if (old_value != value) {
		self->priv->_extension_type = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_extension_loader_properties[ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY]);
	}
}

static void
zeitgeist_extension_loader_class_init (ZeitgeistExtensionLoaderClass * klass,
                                       gpointer klass_data)
{
	zeitgeist_extension_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistExtensionLoader_private_offset);
	((ZeitgeistExtensionLoaderClass *) klass)->create_instance = (ZeitgeistExtension* (*) (ZeitgeistExtensionLoader*, ZeitgeistEngine*)) zeitgeist_extension_loader_real_create_instance;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_loader_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY, zeitgeist_extension_loader_properties[ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY] = g_param_spec_gtype ("extension-type", "extension-type", "extension-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
zeitgeist_extension_loader_instance_init (ZeitgeistExtensionLoader * self,
                                          gpointer klass)
{
	self->priv = zeitgeist_extension_loader_get_instance_private (self);
}

static void
zeitgeist_extension_loader_finalize (GObject * obj)
{
	ZeitgeistExtensionLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader);
	G_OBJECT_CLASS (zeitgeist_extension_loader_parent_class)->finalize (obj);
}

static GType
zeitgeist_extension_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionLoader), 0, (GInstanceInitFunc) zeitgeist_extension_loader_instance_init, NULL };
	GType zeitgeist_extension_loader_type_id;
	zeitgeist_extension_loader_type_id = g_type_register_static (g_type_module_get_type (), "ZeitgeistExtensionLoader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ZeitgeistExtensionLoader_private_offset = g_type_add_instance_private (zeitgeist_extension_loader_type_id, sizeof (ZeitgeistExtensionLoaderPrivate));
	return zeitgeist_extension_loader_type_id;
}

GType
zeitgeist_extension_loader_get_type (void)
{
	static volatile gsize zeitgeist_extension_loader_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_extension_loader_type_id__once)) {
		GType zeitgeist_extension_loader_type_id;
		zeitgeist_extension_loader_type_id = zeitgeist_extension_loader_get_type_once ();
		g_once_init_leave (&zeitgeist_extension_loader_type_id__once, zeitgeist_extension_loader_type_id);
	}
	return zeitgeist_extension_loader_type_id__once;
}

static void
_vala_zeitgeist_extension_loader_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ZeitgeistExtensionLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY:
		g_value_set_gtype (value, zeitgeist_extension_loader_get_extension_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_extension_loader_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ZeitgeistExtensionLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE_PROPERTY:
		zeitgeist_extension_loader_set_extension_type (self, g_value_get_gtype (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
zeitgeist_module_loader_get_instance_private (ZeitgeistModuleLoader* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistModuleLoader_private_offset);
}

ZeitgeistModuleLoader*
zeitgeist_module_loader_construct (GType object_type,
                                   const gchar* module_path)
{
	ZeitgeistModuleLoader * self = NULL;
	g_return_val_if_fail (module_path != NULL, NULL);
	self = (ZeitgeistModuleLoader*) g_object_new (object_type, "module-path", module_path, NULL);
	return self;
}

ZeitgeistModuleLoader*
zeitgeist_module_loader_new (const gchar* module_path)
{
	return zeitgeist_module_loader_construct (ZEITGEIST_TYPE_MODULE_LOADER, module_path);
}

static gboolean
zeitgeist_module_loader_real_load (GTypeModule* base)
{
	ZeitgeistModuleLoader * self;
	const gchar* _tmp0_;
	GModule* _tmp1_;
	GModule* _tmp2_;
	void* func_ptr = NULL;
	GModule* _tmp4_;
	void* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean result;
	self = (ZeitgeistModuleLoader*) base;
	_tmp0_ = self->priv->_module_path;
	_tmp1_ = g_module_open (_tmp0_, G_MODULE_BIND_LOCAL);
	_g_module_close0 (self->priv->module);
	self->priv->module = _tmp1_;
	_tmp2_ = self->priv->module;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = g_module_error ();
		g_warning ("extension.vala:176: %s", _tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->module;
	_tmp6_ = g_module_symbol (_tmp4_, "zeitgeist_extension_register", &_tmp5_);
	func_ptr = _tmp5_;
	if (_tmp6_) {
		ZeitgeistRegisterExtensionFunc func = NULL;
		void* _tmp7_;
		ZeitgeistRegisterExtensionFunc _tmp8_;
		GType _tmp9_;
		GType _tmp10_;
		_tmp7_ = func_ptr;
		func = (ZeitgeistRegisterExtensionFunc) _tmp7_;
		_tmp8_ = func;
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp8_ ((GTypeModule*) self));
		_tmp9_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
		_tmp10_ = _tmp9_;
		if (g_type_is_a (_tmp10_, ZEITGEIST_TYPE_EXTENSION) == FALSE) {
			const gchar* _tmp11_;
			zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, G_TYPE_INVALID);
			_tmp11_ = self->priv->_module_path;
			g_warning ("Type implemented in \"%s\" does not subclass " "Zeitgeist.Extension!", _tmp11_);
			result = FALSE;
			return result;
		}
		g_object_ref ((GObject*) self);
	} else {
		const gchar* _tmp12_;
		_tmp12_ = g_module_error ();
		g_warning ("extension.vala:200: %s", _tmp12_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
zeitgeist_module_loader_real_unload (GTypeModule* base)
{
	ZeitgeistModuleLoader * self;
	self = (ZeitgeistModuleLoader*) base;
	_g_module_close0 (self->priv->module);
	self->priv->module = NULL;
}

const gchar*
zeitgeist_module_loader_get_module_path (ZeitgeistModuleLoader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_path;
	result = _tmp0_;
	return result;
}

static void
zeitgeist_module_loader_set_module_path (ZeitgeistModuleLoader* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_module_loader_get_module_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_module_path);
		self->priv->_module_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_module_loader_properties[ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY]);
	}
}

static GObject *
zeitgeist_module_loader_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistModuleLoader * self;
	const gchar* _tmp0_;
	parent_class = G_OBJECT_CLASS (zeitgeist_module_loader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader);
	_tmp0_ = self->priv->_module_path;
	g_type_module_set_name ((GTypeModule*) self, _tmp0_);
	return obj;
}

static void
zeitgeist_module_loader_class_init (ZeitgeistModuleLoaderClass * klass,
                                    gpointer klass_data)
{
	zeitgeist_module_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistModuleLoader_private_offset);
	((GTypeModuleClass *) klass)->load = (gboolean (*) (GTypeModule*)) zeitgeist_module_loader_real_load;
	((GTypeModuleClass *) klass)->unload = (void (*) (GTypeModule*)) zeitgeist_module_loader_real_unload;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_module_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_module_loader_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_module_loader_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_module_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY, zeitgeist_module_loader_properties[ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY] = g_param_spec_string ("module-path", "module-path", "module-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
zeitgeist_module_loader_instance_init (ZeitgeistModuleLoader * self,
                                       gpointer klass)
{
	self->priv = zeitgeist_module_loader_get_instance_private (self);
	self->priv->module = NULL;
}

static void
zeitgeist_module_loader_finalize (GObject * obj)
{
	ZeitgeistModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader);
	_g_free0 (self->priv->_module_path);
	_g_module_close0 (self->priv->module);
	G_OBJECT_CLASS (zeitgeist_module_loader_parent_class)->finalize (obj);
}

static GType
zeitgeist_module_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistModuleLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_module_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistModuleLoader), 0, (GInstanceInitFunc) zeitgeist_module_loader_instance_init, NULL };
	GType zeitgeist_module_loader_type_id;
	zeitgeist_module_loader_type_id = g_type_register_static (ZEITGEIST_TYPE_EXTENSION_LOADER, "ZeitgeistModuleLoader", &g_define_type_info, 0);
	ZeitgeistModuleLoader_private_offset = g_type_add_instance_private (zeitgeist_module_loader_type_id, sizeof (ZeitgeistModuleLoaderPrivate));
	return zeitgeist_module_loader_type_id;
}

GType
zeitgeist_module_loader_get_type (void)
{
	static volatile gsize zeitgeist_module_loader_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_module_loader_type_id__once)) {
		GType zeitgeist_module_loader_type_id;
		zeitgeist_module_loader_type_id = zeitgeist_module_loader_get_type_once ();
		g_once_init_leave (&zeitgeist_module_loader_type_id__once, zeitgeist_module_loader_type_id);
	}
	return zeitgeist_module_loader_type_id__once;
}

static void
_vala_zeitgeist_module_loader_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ZeitgeistModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader);
	switch (property_id) {
		case ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY:
		g_value_set_string (value, zeitgeist_module_loader_get_module_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_module_loader_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ZeitgeistModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader);
	switch (property_id) {
		case ZEITGEIST_MODULE_LOADER_MODULE_PATH_PROPERTY:
		zeitgeist_module_loader_set_module_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
zeitgeist_builtin_extension_get_instance_private (ZeitgeistBuiltinExtension* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistBuiltinExtension_private_offset);
}

ZeitgeistBuiltinExtension*
zeitgeist_builtin_extension_construct (GType object_type,
                                       ZeitgeistRegisterExtensionFunc func)
{
	ZeitgeistBuiltinExtension * self = NULL;
	self = (ZeitgeistBuiltinExtension*) g_object_new (object_type, NULL);
	self->priv->reg_func = func;
	return self;
}

ZeitgeistBuiltinExtension*
zeitgeist_builtin_extension_new (ZeitgeistRegisterExtensionFunc func)
{
	return zeitgeist_builtin_extension_construct (ZEITGEIST_TYPE_BUILTIN_EXTENSION, func);
}

static gboolean
zeitgeist_builtin_extension_real_load (GTypeModule* base)
{
	ZeitgeistBuiltinExtension * self;
	GType _tmp0_;
	GType _tmp1_;
	gboolean result;
	self = (ZeitgeistBuiltinExtension*) base;
	_tmp0_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == G_TYPE_INVALID) {
		ZeitgeistRegisterExtensionFunc _tmp2_;
		GType _tmp3_;
		GType _tmp4_;
		_tmp2_ = self->priv->reg_func;
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp2_ ((GTypeModule*) self));
		_tmp3_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
		_tmp4_ = _tmp3_;
		if (g_type_is_a (_tmp4_, ZEITGEIST_TYPE_EXTENSION) == FALSE) {
			GType _tmp5_;
			GType _tmp6_;
			const gchar* _tmp7_;
			ZeitgeistRegisterExtensionFunc _tmp8_;
			_tmp5_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_type_name (_tmp6_);
			_tmp8_ = self->priv->reg_func;
			g_warning ("Type \"%s\" implemented by [%p] does not " "subclass Zeitgeist.Extension!", _tmp7_, _tmp8_);
			zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, G_TYPE_INVALID);
			result = FALSE;
			return result;
		}
		g_object_ref ((GObject*) self);
	} else {
		ZeitgeistRegisterExtensionFunc _tmp9_;
		_tmp9_ = self->priv->reg_func;
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp9_ ((GTypeModule*) self));
	}
	result = TRUE;
	return result;
}

static void
zeitgeist_builtin_extension_real_unload (GTypeModule* base)
{
	ZeitgeistBuiltinExtension * self;
	self = (ZeitgeistBuiltinExtension*) base;
}

static GObject *
zeitgeist_builtin_extension_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistBuiltinExtension * self;
	parent_class = G_OBJECT_CLASS (zeitgeist_builtin_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtension);
	g_type_module_set_name ((GTypeModule*) self, "builtin");
	return obj;
}

static void
zeitgeist_builtin_extension_class_init (ZeitgeistBuiltinExtensionClass * klass,
                                        gpointer klass_data)
{
	zeitgeist_builtin_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistBuiltinExtension_private_offset);
	((GTypeModuleClass *) klass)->load = (gboolean (*) (GTypeModule*)) zeitgeist_builtin_extension_real_load;
	((GTypeModuleClass *) klass)->unload = (void (*) (GTypeModule*)) zeitgeist_builtin_extension_real_unload;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_builtin_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_builtin_extension_finalize;
}

static void
zeitgeist_builtin_extension_instance_init (ZeitgeistBuiltinExtension * self,
                                           gpointer klass)
{
	self->priv = zeitgeist_builtin_extension_get_instance_private (self);
}

static void
zeitgeist_builtin_extension_finalize (GObject * obj)
{
	ZeitgeistBuiltinExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtension);
	G_OBJECT_CLASS (zeitgeist_builtin_extension_parent_class)->finalize (obj);
}

static GType
zeitgeist_builtin_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistBuiltinExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_builtin_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistBuiltinExtension), 0, (GInstanceInitFunc) zeitgeist_builtin_extension_instance_init, NULL };
	GType zeitgeist_builtin_extension_type_id;
	zeitgeist_builtin_extension_type_id = g_type_register_static (ZEITGEIST_TYPE_EXTENSION_LOADER, "ZeitgeistBuiltinExtension", &g_define_type_info, 0);
	ZeitgeistBuiltinExtension_private_offset = g_type_add_instance_private (zeitgeist_builtin_extension_type_id, sizeof (ZeitgeistBuiltinExtensionPrivate));
	return zeitgeist_builtin_extension_type_id;
}

GType
zeitgeist_builtin_extension_get_type (void)
{
	static volatile gsize zeitgeist_builtin_extension_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_builtin_extension_type_id__once)) {
		GType zeitgeist_builtin_extension_type_id;
		zeitgeist_builtin_extension_type_id = zeitgeist_builtin_extension_get_type_once ();
		g_once_init_leave (&zeitgeist_builtin_extension_type_id__once, zeitgeist_builtin_extension_type_id);
	}
	return zeitgeist_builtin_extension_type_id__once;
}

