/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2013 Seif Lotfy <seif@lotfy.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist-datamodel.h"
#include <glib/gstdio.h>
#include <gio/gio.h>

#define ZEITGEIST_UTILS_DATA_FOLDER "zeitgeist"
#define ZEITGEIST_UTILS_DATABASE_BASENAME "activity.sqlite"
#define ZEITGEIST_UTILS_USER_EXTENSION_PATH ""
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN gchar* zeitgeist_utils_DATA_PATH;
gchar* zeitgeist_utils_DATA_PATH = NULL;
VALA_EXTERN gchar* zeitgeist_utils_DATABASE_FILE_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_PATH = NULL;
VALA_EXTERN gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = NULL;
VALA_EXTERN gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH = NULL;

VALA_EXTERN void zeitgeist_utils_assert_sig (gboolean condition,
                                 const gchar* error_message,
                                 GError** error);

const gchar*
zeitgeist_utils_get_data_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* result;
	_tmp0_ = zeitgeist_utils_DATA_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATA_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATA_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = zeitgeist_utils_get_default_data_path ();
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	}
	_tmp6_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATA_PATH);
	zeitgeist_utils_DATA_PATH = _tmp6_;
	_tmp7_ = zeitgeist_utils_DATA_PATH;
	if (!g_file_test (_tmp7_, G_FILE_TEST_IS_DIR)) {
		const gchar* _tmp8_;
		_tmp8_ = zeitgeist_utils_DATA_PATH;
		g_mkdir_with_parents (_tmp8_, 0755);
	}
	_tmp9_ = zeitgeist_utils_DATA_PATH;
	g_debug ("utils.vala:67: DATA_PATH = %s", _tmp9_);
	_tmp10_ = zeitgeist_utils_DATA_PATH;
	result = _tmp10_;
	_g_free0 (_tmp2_);
	return result;
}

gchar*
zeitgeist_utils_get_default_data_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ZEITGEIST_UTILS_DATA_FOLDER, NULL);
	result = _tmp1_;
	return result;
}

const gchar*
zeitgeist_utils_get_database_file_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* result;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATABASE_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = zeitgeist_utils_get_data_path ();
		_tmp6_ = g_build_filename (_tmp5_, ZEITGEIST_UTILS_DATABASE_BASENAME, NULL);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATABASE_FILE_PATH);
	zeitgeist_utils_DATABASE_FILE_PATH = _tmp7_;
	_tmp8_ = zeitgeist_utils_DATABASE_FILE_PATH;
	g_debug ("utils.vala:86: DATABASE_FILE_PATH = %s", _tmp8_);
	_tmp9_ = zeitgeist_utils_DATABASE_FILE_PATH;
	result = _tmp9_;
	_g_free0 (_tmp2_);
	return result;
}

/**
         * Sets the filepath of the database.
         * @param path a {@link string}
         */
void
zeitgeist_utils_set_database_file_path (const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (zeitgeist_utils_DATABASE_FILE_PATH);
	zeitgeist_utils_DATABASE_FILE_PATH = _tmp0_;
}

const gchar*
zeitgeist_utils_get_database_file_backup_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* result;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp3_ = g_getenv ("ZEITGEIST_DATABASE_BACKUP_PATH");
	_tmp4_ = g_strdup (_tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = zeitgeist_utils_get_data_path ();
		_tmp6_ = g_build_filename (_tmp5_, ZEITGEIST_UTILS_DATABASE_BASENAME ".bck", NULL);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (zeitgeist_utils_DATABASE_FILE_BACKUP_PATH);
	zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = _tmp7_;
	_tmp8_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	g_debug ("utils.vala:109: DATABASE_FILE_BACKUP_PATH = %s", _tmp8_);
	_tmp9_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	result = _tmp9_;
	_g_free0 (_tmp2_);
	return result;
}

gchar*
zeitgeist_utils_get_database_file_retire_name (void)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y%m%d-%H%M%S");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (".%s.bck", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (ZEITGEIST_UTILS_DATABASE_BASENAME, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}

const gchar*
zeitgeist_utils_get_local_extensions_path (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* result;
	_tmp0_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = zeitgeist_utils_get_data_path ();
	_tmp3_ = g_build_filename (_tmp2_, "extensions", NULL);
	_g_free0 (zeitgeist_utils_LOCAL_EXTENSIONS_PATH);
	zeitgeist_utils_LOCAL_EXTENSIONS_PATH = _tmp3_;
	_tmp4_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	g_debug ("utils.vala:127: LOCAL_EXTENSIONS_PATH = %s", _tmp4_);
	_tmp5_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	result = _tmp5_;
	return result;
}

/**
         * @return Whether a in-memory SQLite database is in use (vs.
         *         a file-based one).
         */
gboolean
zeitgeist_utils_using_in_memory_database (void)
{
	const gchar* _tmp0_;
	gboolean result;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	result = g_strcmp0 (_tmp0_, ":memory:") == 0;
	return result;
}

void
zeitgeist_utils_backup_database (GError** error)
{
	GFile* original = NULL;
	GFile* destination = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (original);
	original = _tmp1_;
	_tmp2_ = zeitgeist_utils_get_database_file_backup_path ();
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (destination);
	destination = _tmp3_;
	_tmp4_ = zeitgeist_utils_get_database_file_backup_path ();
	g_message ("utils.vala:148: Backing up database to \"%s\" for schema upgrade...", _tmp4_);
	g_file_copy (original, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (destination);
		_g_object_unref0 (original);
		return;
	}
	_g_object_unref0 (destination);
	_g_object_unref0 (original);
}

/**
         * Check if the value starts with the negation operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         *
         * @param val value to check
         */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
zeitgeist_utils_parse_negation (gchar** val)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (*val != NULL, FALSE);
	if (!g_str_has_prefix (*val, "!")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_substring (*val, (glong) 1, (glong) -1);
	_g_free0 (*val);
	*val = _tmp0_;
	result = TRUE;
	return result;
}

/**
         * Check if the value starts with the noexpand operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         *
         * Check for the negation operator before calling this function.
         *
         * @param val value to check
         */
gboolean
zeitgeist_utils_parse_noexpand (gchar** val)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (*val != NULL, FALSE);
	if (!g_str_has_prefix (*val, "+")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_substring (*val, (glong) 1, (glong) -1);
	_g_free0 (*val);
	*val = _tmp0_;
	result = TRUE;
	return result;
}

/**
         * Check if the value ends with the wildcard character. If it does,
         * remove the wildcard character from the value and return true.
         * Otherwise, return false.
         *
         * @param val value to check
         */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
zeitgeist_utils_parse_wildcard (gchar** val)
{
	guint8* val_data = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint val_data_length1;
	gint _val_data_size_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gboolean result;
	g_return_val_if_fail (*val != NULL, FALSE);
	if (!g_str_has_suffix (*val, "*")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_get_data (*val, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	val_data = _tmp2_;
	val_data_length1 = _tmp2__length1;
	_val_data_size_ = val_data_length1;
	_tmp3_ = val_data;
	_tmp3__length1 = val_data_length1;
	_tmp4_ = val_data;
	_tmp4__length1 = val_data_length1;
	_tmp3_[_tmp4__length1 - 1] = (guint8) '\0';
	result = TRUE;
	return result;
}

/**
         * Return true if a string is empty (null or containing just a null
         * byte).
         *
         * @param s string to check
         */
gboolean
zeitgeist_utils_is_empty_string (const gchar* s)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (s == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (s, "") == 0;
	}
	result = _tmp0_;
	return result;
}

void
zeitgeist_utils_assert_sig (gboolean condition,
                            const gchar* error_message,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (error_message != NULL);
	if (G_UNLIKELY (!condition)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE, error_message);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
         * @return True if direct reading of the DB is enabled for Log, default is True.
         */
gboolean
zeitgeist_utils_log_may_read_directly (void)
{
	gchar* env_var = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = g_getenv ("ZEITGEIST_LOG_DIRECT_READ");
	_tmp1_ = g_strdup (_tmp0_);
	env_var = _tmp1_;
	_tmp2_ = env_var;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_free0 (env_var);
		return result;
	}
	_tmp3_ = env_var;
	result = atoi (_tmp3_) != 0;
	_g_free0 (env_var);
	return result;
}

