/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.json;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import tim.prune.App;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.SourceInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.json.JsonBlock;
import tim.prune.load.json.JsonPoint;

public class JsonFileLoader
extends FileTypeLoader {
    private final Stack<JsonBlock> _jsonBlocks = new Stack();
    private final ArrayList<JsonPoint> _jsonPoints = new ArrayList();
    private boolean _newSegment = true;

    public JsonFileLoader(App app) {
        super(app);
    }

    public void openFile(FileToBeLoaded fileToBeLoaded, boolean bl) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileToBeLoaded.getFile()));){
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.processTokensInLine(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.getApp().showErrorMessage("error.load.dialogtitle", "error.load.noread");
        }
        if (!this._jsonPoints.isEmpty()) {
            int n = this.getAppendOption(bl);
            if (n == 2) {
                return;
            }
            this.loadData(this.makePointList(), new SourceInfo(fileToBeLoaded.getFile(), SourceInfo.FILE_TYPE.JSON), n == 0);
        }
    }

    private void processTokensInLine(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (bl || c == '\"') {
                stringBuilder.append(c);
            } else if (" :,".indexOf(c) >= 0) {
                this.processToken(stringBuilder.toString());
                stringBuilder.setLength(0);
            } else if ("[{".indexOf(c) >= 0) {
                this._jsonBlocks.add(new JsonBlock());
            } else if ("]}".indexOf(c) >= 0) {
                this.processToken(stringBuilder.toString());
                stringBuilder.setLength(0);
                this.processBlock(this._jsonBlocks.pop());
            } else {
                stringBuilder.append(c);
            }
            if (c == '\"' && !bl2) {
                bl = !bl;
            }
            bl2 = c == '\\' && !bl2;
            ++n2;
        }
        this.processToken(stringBuilder.toString());
    }

    private void processToken(String string) {
        if (string == null || string.isBlank()) {
            return;
        }
        if (string.equals("\"coordinates\"")) {
            this._newSegment = true;
        }
        this._jsonBlocks.peek().addToken(string);
    }

    private void processBlock(JsonBlock jsonBlock) {
        if (jsonBlock.areFieldsValid()) {
            this._jsonPoints.add(jsonBlock.createSinglePoint(this._newSegment));
            this._newSegment = false;
        } else if (jsonBlock.areSingleCoordsValid()) {
            this._jsonBlocks.peek().addSingleCoordsFrom(jsonBlock);
        } else if (jsonBlock.isCoordListValid()) {
            this._jsonBlocks.peek().addCoordListFrom(jsonBlock);
        } else if (jsonBlock.hasValidCoordList()) {
            int n = 0;
            while (n < jsonBlock.getNumPoints()) {
                this._jsonPoints.add(jsonBlock.createPointFromList(n));
                ++n;
            }
            this._newSegment = true;
        }
    }

    private List<DataPoint> makePointList() {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (JsonPoint jsonPoint : this._jsonPoints) {
            DataPoint dataPoint = new DataPoint(new Latitude(jsonPoint._latitude), new Longitude(jsonPoint._longitude), new Altitude(jsonPoint._altitude, UnitSetLibrary.UNITS_METRES));
            dataPoint.setSegmentStart(jsonPoint._newSegment);
            arrayList.add(dataPoint);
        }
        return arrayList;
    }
}

