/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.BitMap;

public class MarkBits {
    private BitMap bits;
    private Address start;
    private Address end;

    public MarkBits(CollectedHeap heap) {
        MemRegion reserved = heap.reservedRegion();
        this.start = reserved.start();
        this.end = reserved.end();
        long numOopHandles = this.end.minus(this.start) / VM.getVM().getOopSize();
        this.bits = new BitMap((int)numOopHandles);
    }

    public void clear() {
        this.bits.clear();
    }

    public boolean mark(Oop obj) {
        if (obj == null) {
            System.err.println("MarkBits: WARNING: null object, ignoring");
            return false;
        }
        OopHandle handle = obj.getHandle();
        long idx = handle.minus(this.start) / VM.getVM().getOopSize();
        if (idx < 0L || idx >= (long)this.bits.size()) {
            System.err.println("MarkBits: WARNING: object " + handle + " outside of heap, ignoring");
            return false;
        }
        int intIdx = (int)idx;
        if (this.bits.at(intIdx)) {
            return false;
        }
        this.bits.atPut(intIdx, true);
        return true;
    }

    public void clear(Oop obj) {
        OopHandle handle = obj.getHandle();
        long idx = handle.minus(this.start) / VM.getVM().getOopSize();
        if (idx < 0L || idx >= (long)this.bits.size()) {
            System.err.println("MarkBits: WARNING: object " + handle + " outside of heap, ignoring");
            return;
        }
        int intIdx = (int)idx;
        this.bits.atPut(intIdx, false);
    }
}

