/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.spi.preferences.Config;

public abstract class SourcePrefHelper {
    private final String pref;
    protected final SourceType type;

    protected SourcePrefHelper(String pref, SourceType type) {
        this.pref = pref;
        this.type = type;
    }

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public Map<String, String> serialize(SourceEntry entry) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("url", entry.url == null ? "" : entry.url);
        res.put("title", entry.title == null ? "" : entry.title);
        return res;
    }

    public SourceEntry deserialize(Map<String, String> entryStr) {
        return new SourceEntry(this.type, entryStr.get("url"), entryStr.get("name"), entryStr.get("title"), Optional.ofNullable(entryStr.get("active")).map(Boolean::parseBoolean).orElse(true));
    }

    public List<SourceEntry> get() {
        List<Map<String, String>> src = Config.getPref().getListOfMaps(this.pref, null);
        if (src == null) {
            return new ArrayList<SourceEntry>(this.getDefault());
        }
        return src.stream().map(sourcePref -> this.deserialize(new HashMap<String, String>((Map<String, String>)sourcePref))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean put(Collection<? extends SourceEntry> entries) {
        List<Map<String, String>> def;
        boolean unset;
        List<Map<String, String>> setting = this.serializeList(entries);
        boolean bl = unset = Config.getPref().getListOfMaps(this.pref, null) == null;
        if (unset && setting.equals(def = this.serializeList(this.getDefault()))) {
            return false;
        }
        return Config.getPref().putListOfMaps(this.pref, setting);
    }

    private List<Map<String, String>> serializeList(Collection<? extends SourceEntry> entries) {
        return new ArrayList<SourceEntry>(entries).stream().map(this::serialize).collect(Collectors.toList());
    }

    public final Set<String> getActiveUrls() {
        return this.get().stream().filter(e -> e.active).map(e -> e.url).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

