/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(ThreadContext context) {
        return Define.defineModule(context, "Comparable").defineMethods(context, RubyComparable.class);
    }

    public static int cmpint(ThreadContext context, CallSite op_gt2, CallSite op_lt2, IRubyObject val, IRubyObject a, IRubyObject b2) {
        if (val == context.nil) {
            RubyComparable.cmperr(context, a, b2);
        }
        if (val instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)val;
            return Integer.compare(Convert.toInt(context, fixnum), 0);
        }
        if (val instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)val;
            return bignum.signum(context) == -1 ? -1 : 1;
        }
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (op_gt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return 1;
        }
        if (op_lt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b2) {
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        return RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, val, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, a, a, b2);
        return RubyComparable.cmpint(context, cmpResult, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, CallSite op_cmp2, CallSite op_gt2, CallSite op_lt2, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = op_cmp2.call(context, a, a, b2);
        return RubyComparable.cmpint(context, op_gt2, op_lt2, cmpResult, a, b2);
    }

    @Deprecated
    public static IRubyObject cmperr(IRubyObject recv2, IRubyObject other) {
        return RubyComparable.cmperr(((RubyBasicObject)recv2).getCurrentContext(), recv2, other);
    }

    public static IRubyObject cmperr(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject target2 = other.isImmediate() || !other.isNil() && !other.isTrue() && other != context.fals ? other.inspect(context) : other.getType();
        throw Error.argumentError(context, "comparison of " + String.valueOf(recv2.getType()) + " with " + String.valueOf(target2) + " failed");
    }

    public static IRubyObject invcmp(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.invcmp(context, RubyComparable::invcmpRecursive, recv2, other);
    }

    private static IRubyObject invcmpRecursive(ThreadContext context, IRubyObject recv2, IRubyObject other, boolean recur) {
        if (recur || !RubyComparable.sites((ThreadContext)context).respond_to_op_cmp.respondsTo(context, other, other)) {
            return context.nil;
        }
        return RubyComparable.sites((ThreadContext)context).op_cmp.call(context, other, other, recv2);
    }

    public static IRubyObject invcmp(ThreadContext context, ThreadContext.RecursiveFunctionEx<IRubyObject> func, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = context.safeRecurse(func, recv2, other, "<=>", true);
        return result2.isNil() ? context.nil : Convert.asFixnum(context, -RubyComparable.cmpint(context, result2, recv2, other));
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.callCmpMethod(context, recv2, other, context.fals);
    }

    private static IRubyObject callCmpMethod(ThreadContext context, IRubyObject recv2, IRubyObject other, IRubyObject returnValueOnError) {
        if (recv2 == other) {
            return context.tru;
        }
        IRubyObject result2 = context.safeRecurse((ctx, obj, self2, recur) -> recur ? ctx.nil : RubyComparable.sites((ThreadContext)ctx).op_cmp.call(ctx, self2, self2, (IRubyObject)obj), other, recv2, "<=>", true);
        if (result2.isNil()) {
            return returnValueOnError;
        }
        return Convert.asBoolean(context, RubyComparable.cmpint(context, result2, recv2, other) == 0);
    }

    @JRubyMethod(name={">"})
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(context, recv2, other);
        }
        return Convert.asBoolean(context, RubyComparable.cmpint(context, result2, recv2, other) > 0);
    }

    @JRubyMethod(name={">="})
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(context, recv2, other);
        }
        return Convert.asBoolean(context, RubyComparable.cmpint(context, result2, recv2, other) >= 0);
    }

    @JRubyMethod(name={"<"})
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.op_lt(context, RubyComparable.sites((ThreadContext)context).op_cmp, recv2, other);
    }

    public static RubyBoolean op_lt(ThreadContext context, CallSite cmp2, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = cmp2.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(context, recv2, other);
        }
        return Convert.asBoolean(context, RubyComparable.cmpint(context, result2, recv2, other) < 0);
    }

    @JRubyMethod(name={"<="})
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(context, recv2, other);
        }
        return Convert.asBoolean(context, RubyComparable.cmpint(context, result2, recv2, other) <= 0);
    }

    @JRubyMethod(name={"between?"})
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv2, IRubyObject first2, IRubyObject second2) {
        return Convert.asBoolean(context, RubyComparable.op_lt(context, recv2, first2).isFalse() && RubyComparable.op_gt(context, recv2, second2).isFalse());
    }

    @JRubyMethod(name={"clamp"})
    public static IRubyObject clamp(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyRange range = Convert.castAsRange(context, arg2);
        IRubyObject min2 = range.begin(context);
        IRubyObject max2 = range.end(context);
        if (!max2.isNil() && range.isExcludeEnd()) {
            throw Error.argumentError(context, "cannot clamp with an exclusive range");
        }
        return RubyComparable.clamp(context, recv2, min2, max2);
    }

    @JRubyMethod(name={"clamp"})
    public static IRubyObject clamp(ThreadContext context, IRubyObject recv2, IRubyObject min2, IRubyObject max2) {
        int c;
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        CallSite op_gt2 = sites.op_gt;
        CallSite op_lt2 = sites.op_lt;
        CallSite op_cmp2 = sites.op_cmp;
        if (!min2.isNil() && !max2.isNil() && RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, min2, max2) > 0) {
            throw Error.argumentError(context, "min argument must be less than or equal to max argument");
        }
        if (!min2.isNil()) {
            c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv2, min2);
            if (c == 0) {
                return recv2;
            }
            if (c < 0) {
                return min2;
            }
        }
        if (!max2.isNil() && (c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv2, max2)) > 0) {
            return max2;
        }
        return recv2;
    }

    private static JavaSites.ComparableSites sites(ThreadContext context) {
        return context.sites.Comparable;
    }
}

