/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class IndexOfFunction<K, V>
implements ListBucketBaseFunction<K, V, Collection<Long>> {
    public static final AdvancedExternalizer<IndexOfFunction> EXTERNALIZER = new Externalizer();
    private final V element;
    private final long count;
    private final long rank;
    private final long maxLen;

    public IndexOfFunction(V element, long count, long rank, long maxLen) {
        this.element = element;
        this.count = count;
        this.rank = rank;
        this.maxLen = maxLen;
    }

    public Collection<Long> apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((ListBucket)existing.get()).indexOf(this.element, this.count, this.rank, this.maxLen);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<IndexOfFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends IndexOfFunction>> getTypeClasses() {
            return Collections.singleton(IndexOfFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.INDEXOF_FUNCTION;
        }

        public void writeObject(ObjectOutput output, IndexOfFunction object) throws IOException {
            output.writeObject(object.element);
            output.writeLong(object.count);
            output.writeLong(object.rank);
            output.writeLong(object.maxLen);
        }

        public IndexOfFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IndexOfFunction(input.readObject(), input.readLong(), input.readLong(), input.readLong());
        }
    }
}

