/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.client.TokenBindingStatus;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenBinding {
    @NotNull
    private final TokenBindingStatus status;
    @Nullable
    private final String id;

    @JsonCreator
    public TokenBinding(@JsonProperty(value="status") @NotNull TokenBindingStatus status, @JsonProperty(value="id") @Nullable String id) {
        AssertUtil.notNull(status, "status must not be null");
        this.status = status;
        this.id = id;
    }

    public TokenBinding(@NotNull TokenBindingStatus status, @Nullable byte[] id) {
        AssertUtil.notNull(status, "status must not be null");
        this.status = status;
        this.id = id == null ? null : Base64UrlUtil.encodeToString(id);
    }

    @NotNull
    public TokenBindingStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenBinding that = (TokenBinding)o;
        return this.status.equals(that.status) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.id);
    }

    public String toString() {
        return "TokenBinding(status=" + String.valueOf(this.status) + ", id=" + this.id + ")";
    }
}

