/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.locale;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;
import org.jboss.logging.Logger;

abstract class AbstractLocaleResolver
implements LocaleResolver {
    private static final Logger log = Logger.getLogger(AbstractLocaleResolver.class);
    private static final String ACCEPT_HEADER = "Accept-Language";

    AbstractLocaleResolver() {
    }

    protected abstract Map<String, List<String>> getHeaders();

    public Locale resolve(LocaleResolverContext context) {
        Optional<List<Locale.LanguageRange>> localePriorities = this.getAcceptableLanguages();
        if (localePriorities.isEmpty()) {
            return null;
        }
        List<Locale> resolvedLocales = Locale.filter(localePriorities.get(), context.getSupportedLocales());
        if (!resolvedLocales.isEmpty()) {
            return resolvedLocales.get(0);
        }
        return null;
    }

    private Optional<List<Locale.LanguageRange>> getAcceptableLanguages() {
        block3: {
            List<String> acceptLanguageList;
            Map<String, List<String>> httpHeaders = this.getHeaders();
            if (httpHeaders != null && (acceptLanguageList = httpHeaders.get(ACCEPT_HEADER)) != null && !acceptLanguageList.isEmpty()) {
                try {
                    return Optional.of(Locale.LanguageRange.parse(acceptLanguageList.get(0)));
                }
                catch (IllegalArgumentException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Unable to parse the \"Accept-Language\" header. \"" + acceptLanguageList.get(0) + "\" is not a valid language range string."), (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }
}

