/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToByteArrayAdapter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XRefreshable;
import java.util.Hashtable;
import org.openoffice.da.comp.w2lcommon.filter.EPSCleaner;
import writer2latex.api.GraphicConverter;

public class GraphicConverterImpl2
implements GraphicConverter {
    private XComponentContext xComponentContext;
    private Hashtable<String, String> importFilter;
    private Hashtable<String, String> exportFilter;
    private EPSCleaner epsCleaner;

    public GraphicConverterImpl2(XComponentContext xComponentContext) {
        this.xComponentContext = xComponentContext;
        this.importFilter = new Hashtable();
        this.importFilter.put("image/bmp", "BMP - MS Windows");
        this.importFilter.put("image/x-emf", "EMF - MS Windows Metafile");
        this.importFilter.put("image/x-eps", "EPS - Encapsulated PostScript");
        this.importFilter.put("image/gif", "GIF - Graphics Interchange Format");
        this.importFilter.put("image/jpeg", "JPG - JPEG");
        this.importFilter.put("image/png", "PNG - Portable Network Graphic");
        this.importFilter.put("application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"", "SVM - StarView Metafile");
        this.importFilter.put("image/tiff", "TIF - Tag Image File");
        this.importFilter.put("image/x-wmf", "WMF - MS Windows Metafile");
        this.exportFilter = new Hashtable();
        this.exportFilter.put("image/bmp", "draw_bmp_Export");
        this.exportFilter.put("image/x-emf", "draw_emf_Export");
        this.exportFilter.put("image/x-eps", "draw_eps_Export");
        this.exportFilter.put("image/gif", "draw_gif_Export");
        this.exportFilter.put("image/jpeg", "draw_jpg_Export");
        this.exportFilter.put("image/png", "draw_png_Export");
        this.exportFilter.put("image/svg+xml", "draw_svg_Export");
        this.exportFilter.put("application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"", "draw_svm_Export");
        this.exportFilter.put("image/tiff", "draw_tif_Export");
        this.exportFilter.put("image/x-wmf", "draw_wmf_Export");
        this.exportFilter.put("application/pdf", "draw_pdf_Export");
        this.epsCleaner = new EPSCleaner();
    }

    @Override
    public boolean supportsConversion(String sSourceMime, String sTargetMime, boolean bCrop, boolean bResize) {
        if (bCrop || bResize) {
            return false;
        }
        boolean bSupportsSource = "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sSourceMime) || "image/png".equals(sSourceMime) || "image/jpeg".equals(sSourceMime) || "image/gif".equals(sSourceMime) || "image/tiff".equals(sSourceMime) || "image/bmp".equals(sSourceMime) || "image/x-wmf".equals(sSourceMime) || "image/x-emf".equals(sSourceMime);
        boolean bSupportsTarget = "application/pdf".equals(sTargetMime) || "image/x-eps".equals(sTargetMime) || "image/svg+xml".equals(sTargetMime);
        return bSupportsSource && bSupportsTarget;
    }

    @Override
    public byte[] convert(byte[] source, String sSourceMime, String sTargetMime) {
        XMultiComponentFactory xMCF = this.xComponentContext.getServiceManager();
        try {
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)desktop);
            PropertyValue[] fileProps = new PropertyValue[3];
            fileProps[0] = new PropertyValue();
            fileProps[0].Name = "FilterName";
            fileProps[0].Value = this.importFilter.get(sSourceMime);
            fileProps[1] = new PropertyValue();
            fileProps[1].Name = "InputStream";
            fileProps[1].Value = new ByteArrayToXInputStreamAdapter(source);
            fileProps[2] = new PropertyValue();
            fileProps[2].Name = "Hidden";
            fileProps[2].Value = new Boolean(true);
            XComponent xDocument = xComponentLoader.loadComponentFromURL("private:stream", "_blank", 0, fileProps);
            XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDocument);
            XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
            Object drawPage = xDrawPages.getByIndex(0);
            XDrawPage xDrawPage = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)drawPage);
            Object shape = xDrawPage.getByIndex(0);
            XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)shape);
            Point position = new Point();
            position.X = 0;
            position.Y = 0;
            xShape.setPosition(position);
            XPropertySet xPageProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDrawPage);
            Size size = xShape.getSize();
            xPageProps.setPropertyValue("Width", (Object)new Integer(size.Width));
            xPageProps.setPropertyValue("Height", (Object)new Integer(size.Height));
            xPageProps.setPropertyValue("BorderTop", (Object)new Integer(0));
            xPageProps.setPropertyValue("BorderBottom", (Object)new Integer(0));
            xPageProps.setPropertyValue("BorderLeft", (Object)new Integer(0));
            xPageProps.setPropertyValue("BorderRight", (Object)new Integer(0));
            this.refreshDocument(xDocument);
            XOutputStreamToByteArrayAdapter outputStream = new XOutputStreamToByteArrayAdapter();
            PropertyValue[] exportProps = new PropertyValue[3];
            exportProps[0] = new PropertyValue();
            exportProps[0].Name = "FilterName";
            exportProps[0].Value = this.exportFilter.get(sTargetMime);
            exportProps[1] = new PropertyValue();
            exportProps[1].Name = "OutputStream";
            exportProps[1].Value = outputStream;
            exportProps[2] = new PropertyValue();
            exportProps[2].Name = "Overwrite";
            exportProps[2].Value = new Boolean(true);
            XStorable xStore = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xDocument);
            xStore.storeToURL("private:stream", exportProps);
            outputStream.closeOutput();
            byte[] result = outputStream.getBuffer();
            xDocument.dispose();
            if ("image/x-eps".equals(sTargetMime)) {
                return this.epsCleaner.cleanEps(result);
            }
            return result;
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (WrappedTargetException wrappedTargetException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void refreshDocument(XComponent document) {
        XRefreshable refreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)document);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }
}

