/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import org.openoffice.da.comp.w2lcommon.filter.UNOPublisher;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer2xhtml.XhtmlUNOPublisher;

public final class Writer2xhtml
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XInitialization,
XDispatch {
    private static final String PROTOCOL = "org.openoffice.da.writer2xhtml:";
    private final XComponentContext m_xContext;
    private XFrame m_xFrame;
    private XhtmlUNOPublisher unoPublisher = null;
    public static final String __implementationName = Writer2xhtml.class.getName();
    public static final String __serviceName = "com.sun.star.frame.ProtocolHandler";
    private static final String[] m_serviceNames = new String[]{"com.sun.star.frame.ProtocolHandler"};

    public Writer2xhtml(XComponentContext xContext) {
        this.m_xContext = xContext;
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object[0]);
        }
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public XDispatch queryDispatch(URL aURL, String sTargetFrameName, int iSearchFlags) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("PublishAsXHTML") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("PublishAsEPUB") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("EditEPUBDocumentProperties") == 0) {
                return this;
            }
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescriptors) {
        int nCount = seqDescriptors.length;
        XDispatch[] seqDispatcher = new XDispatch[seqDescriptors.length];
        for (int i = 0; i < nCount; ++i) {
            seqDispatcher[i] = this.queryDispatch(seqDescriptors[i].FeatureURL, seqDescriptors[i].FrameName, seqDescriptors[i].SearchFlags);
        }
        return seqDispatcher;
    }

    public void dispatch(URL aURL, PropertyValue[] aArguments) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("PublishAsXHTML") == 0) {
                this.publishAsXhtml();
                return;
            }
            if (aURL.Path.compareTo("PublishAsEPUB") == 0) {
                this.publishAsEpub();
                return;
            }
            if (aURL.Path.compareTo("EditEPUBDocumentProperties") == 0) {
                this.editDocumentProperties();
                return;
            }
        }
    }

    public void addStatusListener(XStatusListener xControl, URL aURL) {
    }

    public void removeStatusListener(XStatusListener xControl, URL aURL) {
    }

    private void editDocumentProperties() {
        try {
            Object dialog = this.m_xContext.getServiceManager().createInstanceWithContext("org.openoffice.da.writer2xhtml.EpubMetadataDialog", this.m_xContext);
            XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
            xDialog.execute();
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)dialog);
            if (xComponent != null) {
                xComponent.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void publishAsXhtml() {
        RegistryHelper registry = new RegistryHelper(this.m_xContext);
        try {
            Object view = registry.getRegistryView("/org.openoffice.da.Writer2xhtml.toolbar.ToolbarOptions/Settings", false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            short nXhtmlFormat = XPropertySetHelper.getPropertyValueAsShort(xProps, "XhtmlFormat");
            switch (nXhtmlFormat) {
                case 0: {
                    this.publish(UNOPublisher.TargetFormat.xhtml);
                    break;
                }
                case 1: {
                    this.publish(UNOPublisher.TargetFormat.xhtml11);
                    break;
                }
                case 2: {
                    this.publish(UNOPublisher.TargetFormat.xhtml_mathml);
                    break;
                }
                case 3: {
                    this.publish(UNOPublisher.TargetFormat.html5);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void publishAsEpub() {
        RegistryHelper registry = new RegistryHelper(this.m_xContext);
        try {
            Object view = registry.getRegistryView("/org.openoffice.da.Writer2xhtml.toolbar.ToolbarOptions/Settings", false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            short nEpubFormat = XPropertySetHelper.getPropertyValueAsShort(xProps, "EpubFormat");
            switch (nEpubFormat) {
                case 0: {
                    this.publish(UNOPublisher.TargetFormat.epub);
                    break;
                }
                case 1: {
                    this.publish(UNOPublisher.TargetFormat.epub3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void publish(UNOPublisher.TargetFormat format) {
        if (this.unoPublisher == null) {
            this.unoPublisher = new XhtmlUNOPublisher(this.m_xContext, this.m_xFrame, "Writer2xhtml");
        }
        this.unoPublisher.publish(format);
    }
}

