/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import writer2latex.util.Misc;

public class LaTeXDocumentPortion {
    private Vector<Object> nodes;
    private StringBuilder curText;
    private boolean bEmpty;
    private boolean bWrap;

    public LaTeXDocumentPortion(boolean bWrap) {
        this.bWrap = bWrap;
        this.nodes = new Vector();
        this.curText = new StringBuilder();
        this.bEmpty = true;
    }

    public LaTeXDocumentPortion append(LaTeXDocumentPortion ldp) {
        if (!this.bEmpty) {
            this.nodes.add(this.curText);
            this.curText = new StringBuilder();
            this.bEmpty = true;
        }
        this.nodes.add(ldp);
        return this;
    }

    public LaTeXDocumentPortion append(String s) {
        this.curText.append(s);
        this.bEmpty = false;
        return this;
    }

    public LaTeXDocumentPortion append(int n) {
        this.curText.append(n);
        this.bEmpty = false;
        return this;
    }

    public LaTeXDocumentPortion nl() {
        this.curText.append("\n");
        this.bEmpty = false;
        return this;
    }

    private void writeSegment(String s, int nStart, int nEnd, OutputStreamWriter osw) throws IOException {
        for (int i = nStart; i < nEnd; ++i) {
            osw.write(s.charAt(i));
        }
    }

    private void writeBuffer(StringBuilder text, OutputStreamWriter osw, int nLineLen, String sNewline) throws IOException {
        String s = text.toString();
        int nLen = s.length();
        int[] nBreakPoints = new int[100];
        int nLastBPIndex = 99;
        int nStart = 0;
        while (nStart < nLen) {
            int nNewline;
            int nBPIndex = 0;
            boolean bEscape = false;
            boolean bComment = false;
            for (nNewline = nStart; nNewline < nLen; ++nNewline) {
                char c;
                if (nBPIndex == nLastBPIndex) {
                    nBreakPoints = Misc.doubleIntArray(nBreakPoints);
                    nLastBPIndex = nBreakPoints.length - 1;
                }
                if ((c = s.charAt(nNewline)) == '\n') {
                    nBreakPoints[nBPIndex++] = nNewline;
                    break;
                }
                if (bEscape) {
                    bEscape = false;
                    continue;
                }
                if (c == '\\') {
                    bEscape = true;
                    continue;
                }
                if (c == '%') {
                    bComment = true;
                    continue;
                }
                if (bComment || c != ' ') continue;
                nBreakPoints[nBPIndex++] = nNewline;
            }
            if (nBPIndex == nLastBPIndex) {
                nBreakPoints = Misc.doubleIntArray(nBreakPoints);
                nLastBPIndex = nBreakPoints.length - 1;
            }
            if (nNewline == nLen) {
                nBreakPoints[nBPIndex++] = nNewline;
            }
            int nCurLineLen = nBreakPoints[0] - nStart;
            this.writeSegment(s, nStart, nBreakPoints[0], osw);
            for (int i = 0; i < nBPIndex - 1; ++i) {
                int nSegmentLen = nBreakPoints[i + 1] - nBreakPoints[i];
                if (nSegmentLen + nCurLineLen > nLineLen) {
                    osw.write(sNewline);
                    nCurLineLen = nSegmentLen;
                } else {
                    osw.write(" ");
                    nCurLineLen += nSegmentLen;
                }
                this.writeSegment(s, nBreakPoints[i] + 1, nBreakPoints[i + 1], osw);
            }
            osw.write(sNewline);
            nStart = nNewline + 1;
        }
    }

    private void writeBuffer(StringBuilder text, OutputStreamWriter osw, String sNewline) throws IOException {
        String s = text.toString();
        int nLen = s.length();
        int nStart = 0;
        while (nStart < nLen) {
            int nNewline;
            for (nNewline = nStart; nNewline < nLen && s.charAt(nNewline) != '\n'; ++nNewline) {
            }
            this.writeSegment(s, nStart, nNewline, osw);
            osw.write(sNewline);
            nStart = nNewline + 1;
        }
    }

    public void write(OutputStreamWriter osw, int nLineLen, String sNewline) throws IOException {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            if (this.nodes.get(i) instanceof LaTeXDocumentPortion) {
                ((LaTeXDocumentPortion)this.nodes.get(i)).write(osw, nLineLen, sNewline);
                continue;
            }
            if (this.bWrap && nLineLen > 0) {
                this.writeBuffer((StringBuilder)this.nodes.get(i), osw, nLineLen, sNewline);
                continue;
            }
            this.writeBuffer((StringBuilder)this.nodes.get(i), osw, sNewline);
        }
        if (!this.bEmpty) {
            if (this.bWrap && nLineLen > 0) {
                this.writeBuffer(this.curText, osw, nLineLen, sNewline);
            } else {
                this.writeBuffer(this.curText, osw, sNewline);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            if (this.nodes.get(i) instanceof LaTeXDocumentPortion) {
                buf.append(((LaTeXDocumentPortion)this.nodes.get(i)).toString());
                continue;
            }
            buf.append((CharSequence)((StringBuilder)this.nodes.get(i)));
        }
        if (!this.bEmpty) {
            buf.append(this.curText.toString());
        }
        return buf.toString();
    }
}

