/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.beans.XMultiHierarchicalPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.StreamGobbler;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer2latex.Messages;

public class ExternalApps {
    public static final short EXPORT = 0;
    public static final short BUILD = 1;
    public static final short PREVIEW = 2;
    public static final String LATEX = "LaTeX";
    public static final String PDFLATEX = "PdfLaTeX";
    public static final String XELATEX = "XeLaTeX";
    public static final String BIBTEX = "BibTeX";
    public static final String MAKEINDEX = "Makeindex";
    public static final String MK4HT = "Mk4ht";
    public static final String DVIPS = "Dvips";
    public static final String DVIVIEWER = "DVIViewer";
    public static final String POSTSCRIPTVIEWER = "PostscriptViewer";
    public static final String PDFVIEWER = "PdfViewer";
    private static final String[] sApps = new String[]{"LaTeX", "PdfLaTeX", "XeLaTeX", "BibTeX", "Makeindex", "Mk4ht", "Dvips", "DVIViewer", "PostscriptViewer", "PdfViewer"};
    private XComponentContext xContext;
    private short nLevel = (short)2;
    private Map<String, String[]> apps;
    private Set<String> defaultApps;

    public ExternalApps(XComponentContext xContext) {
        this.xContext = xContext;
        this.apps = new HashMap<String, String[]>();
        this.defaultApps = new HashSet<String>();
        for (int i = 0; i < sApps.length; ++i) {
            this.setApplication(sApps[i], "", "");
            this.setUseDefaultApplication(sApps[i], true);
        }
    }

    public static String getUIAppName(String sName) {
        if (DVIVIEWER.equals(sName)) {
            return Messages.getString("ExternalApps.dviviewer");
        }
        if (PDFVIEWER.equals(sName)) {
            return Messages.getString("ExternalApps.pdfviewer");
        }
        if (POSTSCRIPTVIEWER.equals(sName)) {
            return Messages.getString("ExternalApps.psviewer");
        }
        return sName;
    }

    public void setProcessingLevel(short nLevel) {
        this.nLevel = nLevel;
    }

    public short getProcessingLevel() {
        return this.nLevel;
    }

    public boolean isViewer(String sAppName) {
        return sAppName != null && sAppName.endsWith("Viewer");
    }

    public void setApplication(String sAppName, String sExecutable, String sOptions) {
        String[] sValue = new String[]{sExecutable, sOptions};
        this.apps.put(sAppName, sValue);
    }

    public String[] getApplication(String sAppName) {
        return this.apps.get(sAppName);
    }

    public void setUseDefaultApplication(String sAppName, boolean bUseDefault) {
        if (bUseDefault && this.isViewer(sAppName)) {
            this.defaultApps.add(sAppName);
        } else if (this.defaultApps.contains(sAppName)) {
            this.defaultApps.remove(sAppName);
        }
    }

    public boolean getUseDefaultApplication(String sAppName) {
        return this.defaultApps.contains(sAppName);
    }

    public int execute(String sAppName, String sFileName, File workDir, Map<String, String> env, boolean bWaitFor) {
        if (this.defaultApps.contains(sAppName)) {
            return this.openWithDefaultApplication(new File(sFileName)) ? 0 : 1;
        }
        return this.execute(sAppName, "", sFileName, workDir, env, bWaitFor);
    }

    private boolean openWithDefaultApplication(File file) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
                return true;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return false;
    }

    public int execute(String sAppName, String sCommand, String sFileName, File workDir, Map<String, String> env, boolean bWaitFor) {
        String[] sApp = this.getApplication(sAppName);
        if (sApp == null) {
            return 1;
        }
        try {
            String[] sArguments;
            Vector<String> command = new Vector<String>();
            command.add(sApp[0]);
            for (String s : sArguments = sApp[1].split(" ")) {
                command.add(s.replace("%c", sCommand).replace("%s", sFileName));
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(workDir);
            if (env != null) {
                pb.environment().putAll(env);
            }
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            return bWaitFor ? proc.waitFor() : 0;
        }
        catch (InterruptedException e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public void load() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/Applications", false);
        }
        catch (com.sun.star.uno.Exception e) {
            return;
        }
        XPropertySet xSimpleProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
        this.nLevel = XPropertySetHelper.getPropertyValueAsShort(xSimpleProps, "AfterExport");
        XMultiHierarchicalPropertySet xProps = (XMultiHierarchicalPropertySet)UnoRuntime.queryInterface(XMultiHierarchicalPropertySet.class, (Object)view);
        for (int i = 0; i < sApps.length; ++i) {
            String[] sNames = new String[]{sApps[i] + "/Executable", sApps[i] + "/Options", sApps[i] + "/UseDefault"};
            try {
                Object[] values = xProps.getHierarchicalPropertyValues(sNames);
                this.setApplication(sApps[i], (String)values[0], (String)values[1]);
                this.setUseDefaultApplication(sApps[i], (Boolean)values[2]);
                continue;
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
        }
        registry.disposeRegistryView(view);
    }

    public void save() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/Applications", true);
        }
        catch (com.sun.star.uno.Exception e) {
            return;
        }
        XPropertySet xSimpleProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
        XPropertySetHelper.setPropertyValue(xSimpleProps, "AfterExport", this.nLevel);
        XMultiHierarchicalPropertySet xProps = (XMultiHierarchicalPropertySet)UnoRuntime.queryInterface(XMultiHierarchicalPropertySet.class, (Object)view);
        for (int i = 0; i < sApps.length; ++i) {
            String[] sNames = new String[]{sApps[i] + "/Executable", sApps[i] + "/Options", sApps[i] + "/UseDefault"};
            String[] sApp = this.getApplication(sApps[i]);
            boolean bUseDefault = this.getUseDefaultApplication(sApps[i]);
            Object[] values = new Object[]{sApp[0], sApp[1], new Boolean(bUseDefault)};
            try {
                xProps.setHierarchicalPropertyValues(sNames, values);
                continue;
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
        }
        XChangesBatch xUpdateContext = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
        try {
            xUpdateContext.commitChanges();
        }
        catch (Exception exception) {
            // empty catch block
        }
        registry.disposeRegistryView(view);
    }
}

